/*
 * Hexxagon board game.
 * Copyright (C) 2001 Erik Jonsson.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Email erik@nesqi.homeip.net
 * 
 */

#include "gtk-navigation.h"
#include "gtk-interface.h"
#include "game.h"

#include <libhexx/libhexx.h>

#include "pictures/fastundo.xpm"
#include "pictures/undo.xpm"
#include "pictures/hint.xpm"
#include "pictures/redo.xpm"
#include "pictures/fastredo.xpm"

extern HexxagonGame hex_game; /* The game. =) */

extern int thinking;

void quick_message(gchar *message) 
{
	GtkWidget *dialog, *label, *okay_button;
    
    dialog = gtk_dialog_new();
    label = gtk_label_new(message);
    okay_button = gtk_button_new_with_label("Okay");
    
    gtk_signal_connect_object(GTK_OBJECT(okay_button), "clicked",
							  GTK_SIGNAL_FUNC(gtk_widget_destroy), 
							  GTK_OBJECT(dialog));
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->action_area),
					  okay_button);
	
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox),
					  label);
    gtk_widget_show_all(dialog);
}

int still_thinking()
{
	if(thinking)
	{
		quick_message("\n   Still thinking!   \n");
		return 1;
	}
	else
		return 0;
}

void button1_callback(GtkWidget *button)
{
	if(!still_thinking())
	{
		if(hex_game.prev())
			gdk_beep();
		else
		{
			while(!hex_game.prev())
				;
			update_board();
		}
	}
}

void button2_callback(GtkWidget *button)
{
	if(!still_thinking())
	{
		if(hex_game.prev())
			gdk_beep();
		else
			update_board();
	}
}

void button3_callback(GtkWidget *button)
{
	if(!still_thinking())
	{
		if(hex_game.endOfGame())
			quick_message("\n   The game is over !!   \n");
		else
			computer_move();
	};
}

void button4_callback(GtkWidget *button)
{
	if(!still_thinking())
	{
		if(hex_game.next())
			gdk_beep();
		else
			update_board();
	}
}

void button5_callback(GtkWidget *button)
{
	if(!still_thinking())
	{
		if(hex_game.next())
			gdk_beep();
		else
		{
			while(!hex_game.next())
			;
			update_board();
		}
	}
}

GtkWidget *create_navigation_bar(GtkWidget *window)
{
	GtkStyle *style = gtk_widget_get_style(window);

	GdkBitmap *mask_1, *mask_2, *mask_3, *mask_4, *mask_5;

	GdkPixmap *pixmap_1 = gdk_pixmap_create_from_xpm_d(window->window,  &mask_1,
													   &style->bg[GTK_STATE_NORMAL],
													   (gchar **) fastundo_xpm);
	GdkPixmap *pixmap_2 = gdk_pixmap_create_from_xpm_d(window->window,  &mask_2,
													   &style->bg[GTK_STATE_NORMAL],
													   (gchar **) undo_xpm);
	GdkPixmap *pixmap_3 = gdk_pixmap_create_from_xpm_d(window->window,  &mask_3,
													   &style->bg[GTK_STATE_NORMAL],
													   (gchar **) hint_xpm);
	GdkPixmap *pixmap_4 = gdk_pixmap_create_from_xpm_d(window->window,  &mask_4,
													   &style->bg[GTK_STATE_NORMAL],
													   (gchar **) redo_xpm);
	GdkPixmap *pixmap_5 = gdk_pixmap_create_from_xpm_d(window->window,  &mask_5,
													   &style->bg[GTK_STATE_NORMAL],
													   (gchar **) fastredo_xpm);

	GtkWidget *pixmapwid_1 = gtk_pixmap_new(pixmap_1, mask_1);
	GtkWidget *pixmapwid_2 = gtk_pixmap_new(pixmap_2, mask_2);
	GtkWidget *pixmapwid_3 = gtk_pixmap_new(pixmap_3, mask_3);
	GtkWidget *pixmapwid_4 = gtk_pixmap_new(pixmap_4, mask_4);
	GtkWidget *pixmapwid_5 = gtk_pixmap_new(pixmap_5, mask_5);

	GtkWidget *button_1 = gtk_button_new();
	GtkWidget *button_2 = gtk_button_new();
	GtkWidget *button_3 = gtk_button_new();
	GtkWidget *button_4 = gtk_button_new();
	GtkWidget *button_5 = gtk_button_new();

	GtkTooltips *button_bar_tips = gtk_tooltips_new();
	gtk_tooltips_set_tip(GTK_TOOLTIPS(button_bar_tips), button_1,
						 "Undo all moves.", (gchar)NULL);
	gtk_tooltips_set_tip(GTK_TOOLTIPS(button_bar_tips), button_2,
						 "Undo last move.", (gchar)NULL);
	gtk_tooltips_set_tip(GTK_TOOLTIPS(button_bar_tips), button_3,
						 "Make the computer move.", (gchar)NULL);
	gtk_tooltips_set_tip(GTK_TOOLTIPS(button_bar_tips), button_4,
						 "Redo next move.", (gchar)NULL);
	gtk_tooltips_set_tip(GTK_TOOLTIPS(button_bar_tips), button_5,
						 "Redo all moves.", (gchar)NULL);

	gtk_container_add(GTK_CONTAINER(button_1), pixmapwid_1 );
	gtk_container_add(GTK_CONTAINER(button_2), pixmapwid_2 );
	gtk_container_add(GTK_CONTAINER(button_3), pixmapwid_3 );
	gtk_container_add(GTK_CONTAINER(button_4), pixmapwid_4 );
	gtk_container_add(GTK_CONTAINER(button_5), pixmapwid_5 );
	
	GtkWidget *hbox = gtk_hbox_new(0, 0);

	gtk_container_add(GTK_CONTAINER(hbox), button_1);
	gtk_container_add(GTK_CONTAINER(hbox), button_2);
	gtk_container_add(GTK_CONTAINER(hbox), button_3);
	gtk_container_add(GTK_CONTAINER(hbox), button_4);
	gtk_container_add(GTK_CONTAINER(hbox), button_5);


	gtk_signal_connect_object(GTK_OBJECT(button_1), "clicked",
							  GTK_SIGNAL_FUNC(button1_callback), 
							  GTK_OBJECT(button_1));
	gtk_signal_connect_object(GTK_OBJECT(button_2), "clicked",
							  GTK_SIGNAL_FUNC(button2_callback), 
							  GTK_OBJECT(button_2));
	gtk_signal_connect_object(GTK_OBJECT(button_3), "clicked",
							  GTK_SIGNAL_FUNC(button3_callback), 
							  GTK_OBJECT(button_3));
	gtk_signal_connect_object(GTK_OBJECT(button_4), "clicked",
							  GTK_SIGNAL_FUNC(button4_callback), 
							  GTK_OBJECT(button_4));
	gtk_signal_connect_object(GTK_OBJECT(button_5), "clicked",
							  GTK_SIGNAL_FUNC(button5_callback), 
							  GTK_OBJECT(button_5));

	return hbox;
}
