/*
 * Copyright (c) 1998,1999,2000,2001,2002 Tal Davidson. All rights reserved.
 *
 * compiler_defines.h   (1 January 1999)
 * by Tal Davidson (davidsont@bigfoot.com)
 * This file is a part of "Artistic Style" - an indentater and reformatter
 * of C, C++, C# and Java source files.
 *
 * The "Artistic Style" project, including all files needed to compile it,
 * is free software; you can redistribute it and/or use it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, 
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.
 */


#ifndef ASFORMATTER_H
#define ASFORMATTER_H

#include "ASBeautifier.h"
#include "enums.h"
#include "compiler_defines.h"

namespace astyle {

  class ASFormatter : public ASBeautifier
    {
    public:
      ASFormatter();
      virtual ~ASFormatter();
      virtual void init(ASSourceIterator* iter);
      virtual bool hasMoreLines() const;
      virtual string nextLine();
      void setBracketFormatMode(BracketMode mode);
      void setBreakClosingHeaderBracketsMode(bool state);
      void setOperatorPaddingMode(bool mode);
      void setParenthesisPaddingMode(bool mode);
      void setBreakOneLineBlocksMode(bool state);
      void setSingleStatementsMode(bool state);
      void setTabSpaceConversionMode(bool state);
      void setBreakBlocksMode(bool state);
      void setBreakClosingHeaderBlocksMode(bool state);
      void setBreakElseIfsMode(bool state);

    private:
      void ASformatter(ASFormatter &copy); // not to be imlpemented
      void operator=(ASFormatter&); // not to be implemented
      void staticInit();
      bool isFormattingEnabled() const;
      void goForward(int i);
      bool getNextChar();
      char peekNextChar() const;
      bool isBeforeComment() const;
      void trimNewLine();
      BracketType getBracketType() const;
      bool isPointerOrReference() const;
      bool isUrinaryMinus() const;
      bool isInExponent() const;
      bool isOneLineBlockReached() const;
      void appendChar(char ch, bool canBreakLine = true);
      void appendCurrentChar(bool canBreakLine = true);
      void appendSequence(const string &sequence, bool canBreakLine = true);
      void appendSpacePad();
      void breakLine();
      inline bool isSequenceReached(const string &sequence) const;
      const string *findHeader(const vector<const string*> &headers, bool checkBoundry = true);

      static vector<const string*> headers;
      static vector<const string*> nonParenHeaders;
      static vector<const string*> preprocessorHeaders;
      static vector<const string*> preDefinitionHeaders;
      static vector<const string*> preCommandHeaders;
      static vector<const string*> operators;
      static vector<const string*> assignmentOperators;
      static bool calledInitStatic;

      ASSourceIterator *sourceIterator;
      vector<const string*> *preBracketHeaderStack;
      vector<BracketType> *bracketTypeStack;
      vector<int> *parenStack;
      string readyFormattedLine;
      string currentLine;
      string formattedLine;
      const string *currentHeader;
      const string *previousOperator;
      char currentChar;
      char previousChar;
      char previousNonWSChar;
      char previousCommandChar;
      char quoteChar;
      unsigned int charNum;
      BracketMode bracketFormatMode;
      bool isVirgin;
      bool shouldPadOperators;
      bool shouldPadParenthesies;
      bool shouldConvertTabs;
      bool isInLineComment;
      bool isInComment;
      bool isInPreprocessor;
      bool isInTemplate;			// true both in template definitions (e.g. template<class A>) and template usage (e.g. F<int>).
      bool doesLineStartComment;
      bool isInQuote;
      bool isSpecialChar;
      bool isNonParenHeader;
      bool foundQuestionMark;
      bool foundPreDefinitionHeader;
      bool foundPreCommandHeader;
      bool isInLineBreak;
      bool isInClosingBracketLineBreak;
      bool endOfCodeReached;
      bool isLineReady;
      bool isPreviousBracketBlockRelated;
      bool isInPotentialCalculation;
      //bool foundOneLineBlock;
      bool shouldBreakOneLineBlocks;
      bool shouldReparseCurrentChar;
      bool shouldBreakOneLineStatements;
      bool shouldBreakLineAfterComments;
      bool shouldBreakClosingHeaderBrackets;
      bool shouldBreakElseIfs;
      bool passedSemicolon;
      bool passedColon;
      bool isImmediatelyPostComment;
      bool isImmediatelyPostLineComment;
      bool isImmediatelyPostEmptyBlock;

      bool shouldBreakBlocks;
      bool shouldBreakClosingHeaderBlocks;
      bool isPrependPostBlockEmptyLineRequested;
      bool isAppendPostBlockEmptyLineRequested;

      bool prependEmptyLine;
      bool foundClosingHeader;
      int previousReadyFormattedLineLength;

      bool isInHeader;
      bool isImmediatelyPostHeader;

    };

}

#endif
