/***************************************************************************
                          configurationreader.cpp  -  description
                             -------------------
    begin                : Son Nov 10 2002
    copyright            : (C) 2002 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configurationreader.h"

using namespace std;

ConfigurationReader::ConfigurationReader(const string & configuration_path, bool complain)
{
  ifstream in (configuration_path.c_str());
  if (in)
    {
      string line;
      line.reserve(500);
      unsigned int delimPos, lineBegin;
      string paramName, paramValue;
      while (getline(in, line))
        {
          lineBegin=line.find_first_not_of("\t ");
          if ((line.size()>2) && (lineBegin!=string::npos) 
               && (line.at(lineBegin)!='#'))  //Kommentar??
            {
              if (line[lineBegin]=='$' || line[lineBegin]=='/')// '/' deprecated
                {             // neuer Parametername?
                  delimPos=line.find("=",lineBegin)-1;  // Name vom Wert trennen
                  if (delimPos!=string::npos)
                    {
                      paramName=line.substr(lineBegin+1, delimPos);
                      parameterNames.push_back(paramName);
                      paramValue=line.substr(delimPos+2, line.length());
                    }
                }
              else // Zeile gehoert zum letzten Parameterwert
                {                                      
                  paramValue=line;
                }
              // Wert an wert[name] haengen
              if (parameterMap[StringTools::lowerCase(paramName)].empty())
                {
                  parameterMap[StringTools::lowerCase(paramName)]
                  = paramValue;
                }
              else
                {
                  parameterMap[StringTools::lowerCase(paramName)]
                  += (" "+paramValue);
                }                        
            }  //if ((lineBegin!=string::npos) && (line.at(lineBegin)!='#'))
        } //while
      fileFound = true;
      in.close();
    } //if (in)
  else
    {
      if (complain)
        {
          cerr << "highlight: file "
          << configuration_path
          << " not found.\n"
          << endl;
        }
      fileFound = false;
    }
}
ConfigurationReader::~ConfigurationReader()
{
}

bool ConfigurationReader::found()
{
  return fileFound;
}

/*liefert Wert des Paramters zurueck
  ParameterName ohne einleitendes "/" angeben! */
string &ConfigurationReader::getParameter(const string & paramName)
{
  return parameterMap[paramName] ;
}
const char* ConfigurationReader::getCParameter(const string & paramName)
{
  return parameterMap[paramName].c_str() ;
}

vector<string> &ConfigurationReader::getParameterNames()
{
  return parameterNames;
}
