/***************************************************************************
                          documentstyle.cpp  -  description
                             -------------------
    begin                : Son Nov 10 2002
    copyright            : (C) 2002 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "documentstyle.h"

namespace highlight {

DocumentStyle::DocumentStyle(const string & styleDefinitionFile)    
{
  fileFound=load(styleDefinitionFile);
}

DocumentStyle::DocumentStyle():fileFound(false)
{}

bool DocumentStyle::load(const string & styleDefinitionPath)
{  
  ConfigurationReader styleConfig(styleDefinitionPath, true);
  if (styleConfig.found())
    {
      fontsize = styleConfig.getParameter("fontsize");
      bgColour.setRGBValues(styleConfig.getParameter("bgcolour"));
      defaultElem.set(styleConfig.getParameter("defaultcolour"));
      comment.set(styleConfig.getParameter("comment"));
      keyword.set(styleConfig.getParameter("keyword"));
      type.set(styleConfig.getParameter("type"));
      directive.set(styleConfig.getParameter("directive"));
      str.set(styleConfig.getParameter("string"));
      escapeChar.set(styleConfig.getParameter("escapechar"));
      number.set(styleConfig.getParameter("number"));
      dstr.set(styleConfig.getParameter("string_directive"));
      line.set(styleConfig.getParameter("line"));
      
      // TODO: Remove this check as soon as all themes have a brackets attribute
      string bstr=styleConfig.getParameter("symbol");
      if (bstr.empty()) {
        bstr=styleConfig.getParameter("defaultcolour");
      }
      symbol.set(bstr);
      fileFound = true;
    }
  else
    {
      fileFound = false;
    }
  return fileFound;
}

DocumentStyle::~DocumentStyle()
{  
}

string &DocumentStyle::getFontSize()
  {
    return fontsize;
  }
StyleColour& DocumentStyle::getBgColour()
  {
    return bgColour;
  }
ElementStyle& DocumentStyle::getDefaultStyle() 
  {
    return defaultElem;
  }
ElementStyle& DocumentStyle::getCommentStyle() 
  {
    return comment;
  }
ElementStyle& DocumentStyle::getKeywordStyle() 
  {
    return keyword;
  }
ElementStyle& DocumentStyle::getStringStyle() 
  {
    return str;
  }
ElementStyle& DocumentStyle::getDirectiveStringStyle() 
  {
    return dstr;
  }
ElementStyle& DocumentStyle::getEscapeCharStyle() 
  {
    return escapeChar;
  }
ElementStyle& DocumentStyle::getNumberStyle() 
  {
    return number;
  }
ElementStyle& DocumentStyle::getDirectiveStyle() 
  {
    return directive;
  }
ElementStyle& DocumentStyle::getTypeStyle() 
  {
    return type;
  }
ElementStyle& DocumentStyle::getLineStyle() 
  {
    return line;
  }

ElementStyle& DocumentStyle::getSymbolStyle() 
  {
    return symbol;
  }

bool DocumentStyle::found () const
  {
    return fileFound;
  }

}
