/***************************************************************************
                          htmlcode.h  -  description
                             -------------------
    begin                : Wed Nov 28 2001
    copyright            : (C) 2001 by André Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef HTMLCODE_H
#define HTMLCODE_H

#include <fstream>  
#include <iostream>
#include <string>
#include <sstream>

#include "version.h"
#include "charcodes.h"
#include "stylecolour.h"
#include "elementstyle.h"
#include "stringtools.h"

#ifdef USE_WX_LIBRARY

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

// Include wxWindows' headers
#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

#endif


#include "codeparser.h"

namespace highlight {

/** 
   Class for outputting HTML/XHTML
   @author Andre Simon
*/

class HtmlCode  : public highlight::CodeParser
  {
  public:

    /** Constructor     
     \param langDef LanguageDefinition which contains parsing information
     \param colourTheme Name of Colour theme to use
     \param cssFilename Path of external CSS stylesheet
     \param includeCssDef Test if CSS should be included in outfile
     \param printLineNumbers Test if line numbers should be printed
     \param fragment Test if header and footer of document should be omitted
     \param withAnchors Test if HTML anchors should be attached to line numbers
     \param xhtmlFormat Test if XHTML should be produced
     \param numSpaces Number of spaces which replace a tab
     \param wrapStyle Line wrapping mode (0=none, 1=simple, 2=normal)
    */
    HtmlCode( const string &colourTheme,              
              bool printLineNumbers=false,
              bool fragment=false,
              int numSpaces=0,
              highlight::WrapMode wrapStyle=highlight::WRAP_DISABLED,
              const string &cssFilename="",
              bool includeCssDef=false,
              bool withAnchors = false,
              bool xhtmlFormat=false);
    HtmlCode();
  
    /** Destructor*/
    virtual ~HtmlCode() {};

    /** insert line number in the beginning of the new line     
    */
    virtual void insertLineNumber(bool insertNewLine=true);

    /** prints document header
       \param  title Title of the document
    */
    string getHeader(const string &title);
    /** Prints document body*/
    void printBody();
    /** Prints document footer*/
    string getFooter();

    /** Prints CSS definitions to external file 
     \param cssInFileName Path of file to be included in cssOutFileName
     \param cssOutFileName Path of CSS outfile
     */
    bool printCSSFile(const string &cssInFileName, const string &cssOutFileName);

    /** Prints HTML index file 
      \param fileList List of output files
      \param outPath Output path
    */
    bool printIndexFile(const 
                    #ifdef USE_WX_LIBRARY
                      wxListBox* 
                    #else
                      vector<string> &
                    #endif  
                      fileList, const string &outPath );

  private:

    string  getOpenTag(const string& styleName);

    /** Gibt HTML-Code der Sonderzeichen zurueck */
    virtual string maskCharacter(unsigned char );

    /** Kommentar zu den CSS-Definitionen */
    static const string cssComment;

    /** gibt an, ob Anker an Zielenummerierung gesetzt werden sollen*/
    bool attachAnchors;

    /** Pfad zur CSS-Definitionsdatei */
    string cssFile, cssOutDir;
  
    string styleDefinitionCache, headerCache2;

    /** gibt an, ob CSS-Definition in HTML eingebettet wird*/
    bool includeCss;

    /** gibt an, ob eine XHTML-Datei erzeugt werden soll
    falls false, wird HTML Datei erzeugt */
    bool xhtmlOutput;
    
    /** gibt CSS String, der die Informationen der Argumente enth�t, zurck*/
    string  formatStyleAttributes(const string & elemName, const ElementStyle & elem);
  
    /** gibt CSS-Definitionen aus*/
    string  getStyleDefinition();
  };

}

#endif
