/***************************************************************************
                          languagedefinition.cpp  -  description
                             -------------------
    begin                : Wed Nov 28 2001
    copyright            : (C) 2001 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "languagedefinition.h"

using namespace std;

namespace highlight {

LanguageDefinition::LanguageDefinition():    
    caseSensitive(false),
    disableHighlighting(false),
    thisIs4th(false),
    allowNestedMultiLineComments(true),
    enableTypesWithinStrings(false),
    fullLineComment(false)
{}

void LanguageDefinition::printKeys()
{
  copy(keys.begin(), keys.end(),
       ostream_iterator<string>(cout, " "));
}
void LanguageDefinition::printTypes()
{
  copy(types.begin(), types.end(),
       ostream_iterator<string>(cout, " "));
}

/** gibt true zurueck, wenn s Element von keys ist */
bool LanguageDefinition::isKeyword(const string &s)
{
  if (s.length())
    {
      return ((keys.count(s)>0) || (s[0]==keywordPrefix));
    }
  else
    {
      return false;
    }
}

/** gibt true zurueck, wenn s Element von types ist */
bool LanguageDefinition::isType(const string &s)
{
  if (s.length())
    {
      return ((types.count(s)>0) || (s[0]==variablePrefix));
    }
  else
    {
      return false;
    }
}

bool LanguageDefinition::isPrefix(unsigned char c)
{
  return ( (c==variablePrefix) || (c==keywordPrefix));
}

bool LanguageDefinition::isNumberPrefix(unsigned char c)
{
  return  (c==numberPrefix);
}

void LanguageDefinition::fill(set<string>& s, const string &paramValues){

  istringstream valueStream(paramValues);
  string value;  
  while (valueStream >> value){
    s.insert(value);
  }
}

void LanguageDefinition::addSimpleSymbol(stringstream& symbolStream, 
                                        State state, 
                                        const string& paramValues ) {
  istringstream valueStream(paramValues);
  bool valExists=false;
  string value;
   while (valueStream >> value)
    {
      symbolStream << " " << value;
      valExists = true;
    }
  if (valExists)
    {
      symbolStream << " " << state;      
    }
}

void LanguageDefinition::addDelimiterSymbol(stringstream& symbolStream, 
                                        State stateBegin, State stateEnd, 
                                        const string& paramValues ) {
  istringstream valueStream(paramValues);
  string value;
      //momentan nur 2 Token!
  if (valueStream >> value)
    {
      symbolStream << " "<<value <<" " << stateBegin;
    }
  if (valueStream >> value)
    {
      symbolStream <<" "<< value<<" "<< stateEnd;
    }
}

bool LanguageDefinition::getFlag( string& paramValue){      
      return (StringTools::lowerCase(paramValue)=="true");        
}

unsigned char LanguageDefinition::getSymbol(const string& paramValue){      
      istringstream valueStream(paramValue);
      unsigned char symbol;
      valueStream >> symbol;
      return symbol;        
}

bool LanguageDefinition::load(const string& langDefPath, bool clear)
{
  if (langDefPath==currentPath) return true;
  if (clear)  reset();  
  ConfigurationReader langDef(langDefPath, true);   
  if (langDef.found())
    {    
      currentPath=langDefPath;
      disableHighlighting=false;
      bool valExists=false;
      string token;
      stringstream symbolStrStream;

      //Stringstream zum Einlesen der Token:
      istringstream valueStream;
      
      fill(keys,langDef.getParameter("keywords"));
      fill(types,langDef.getParameter("types"));
      fill(types,langDef.getParameter("typesmods")); //deprecated

      addSimpleSymbol(symbolStrStream, ESC_CHAR, 
                      langDef.getParameter("escchar"));

      addSimpleSymbol(symbolStrStream, DIRECTIVE_LINE_END, 
                      langDef.getParameter("directiveend"));
      
      addDelimiterSymbol(symbolStrStream, MULTI_LINE_COMMENT_BEGIN, 
                         MULTI_LINE_COMMENT_END,
                         langDef.getParameter("multilinecomment"));

      addSimpleSymbol(symbolStrStream, SINGLE_LINE_COMMENT, 
                      langDef.getParameter("singlelinecomment"));

      addSimpleSymbol(symbolStrStream, DIRECTIVE_LINE, 
                      langDef.getParameter("directive"));      
     
 
      addDelimiterSymbol(symbolStrStream, TAG_BEGIN, TAG_END,
                         langDef.getParameter("tagdelimiters"));

      addDelimiterSymbol(symbolStrStream, KEYWORD_BEGIN, KEYWORD_END,
                         langDef.getParameter("keyworddelimiters"));

      addDelimiterSymbol(symbolStrStream, TYPE_BEGIN, TYPE_END,
                         langDef.getParameter("typedelimiters"));

      addDelimiterSymbol(symbolStrStream, MEMBER_ATTRIBUTE_BEGIN, 
                         MEMBER_ATTRIBUTE_END,
                         langDef.getParameter("memberattrdelimiters"));
      
      // zuletzt einlesen, um Probleme mit Delimitern, die Zeichen der 
      // Symbolliste enthalten, zu vermeiden 
      addSimpleSymbol(symbolStrStream, SYMBOL, 
                      langDef.getParameter("symbols"));
      
      caseSensitive=getFlag(langDef.getParameter("iscasesensitive"));      
      allowNestedMultiLineComments=getFlag(langDef.getParameter("allownestedmultilinecomments"));
      escCharsAllowedOutsideStrings=getFlag(langDef.getParameter("esccharsoutsidestrings"));
      thisIs4th=getFlag(langDef.getParameter("thisis4th"));
      disableHighlighting=getFlag(langDef.getParameter("disablehighlighting"));
      enableTypesWithinStrings=getFlag(langDef.getParameter("enabletypeswithinstrings"));
      fullLineComment=getFlag(langDef.getParameter("fulllinecomment"));

      variablePrefix=getSymbol(langDef.getParameter("variableprefix"));
      keywordPrefix=getSymbol(langDef.getParameter("keywordprefix"));
      numberPrefix=getSymbol(langDef.getParameter("numberPrefix"));
      rawStringPrefix=getSymbol(langDef.getParameter("rawstringprefix"));
      continuationChar=getSymbol(langDef.getParameter("continuationsymbol"));

      valueStream.str(langDef.getParameter("allowedchars"));
      while (valueStream >> token )
        {
          allowedChars += token;
        }
      valueStream.clear();

      valueStream.str(langDef.getParameter("stringdelimiterpair"));
      while (valueStream >> token)    // String open delimiter
        {
          symbolStrStream << " "<<token <<" " << STRING;

          string token2;
          if (valueStream >> token2)   // String close delimiter
           {
              symbolStrStream <<" "<< token2<<" "<< STRING_END;
           }
          stringCloseDelim.insert(make_pair(token, token2));
         }
      valueStream.clear();

      valueStream.str(langDef.getParameter("stringdelimiters"));
      while (valueStream >> token )
        {
          symbolStrStream << " " << token;
          stringCloseDelim.insert(make_pair(token, token)); 
          valExists=true;
        }
      if (valExists)
        {
          symbolStrStream <<" "<< STRING;
          valExists=false;
        }
      valueStream.clear();

      symbolString = symbolStrStream.str();
      
      string fileToInclude=langDef.getParameter("include");
      if (!fileToInclude.empty()){
        string::size_type Pos = langDefPath.find_last_of(PATH_SEPARATOR_CHAR);
        string includeLangDefPath = langDefPath.substr(0, Pos+1) + fileToInclude;
        load(includeLangDefPath, false);
      }
      return true;
    }
  else
    {   
      disableHighlighting=true;
      return false;
    }
}

/** setzt Membervariablen auf Defaultwerte */
void LanguageDefinition::reset()
{
  keys.clear();
  types.clear();
  stringCloseDelim.clear();
  caseSensitive=escCharsAllowedOutsideStrings = thisIs4th = false;
  allowNestedMultiLineComments=enableTypesWithinStrings = false;
  variablePrefix=keywordPrefix=numberPrefix=rawStringPrefix = '\0';  
}
/** gibt true zurck, falls Forth Code geparst wird */
bool LanguageDefinition::isForth()
{
  return thisIs4th;
}

/** gibt true zurck, falls verschachtelte MultiLineComments erlaubt sind */
bool LanguageDefinition::allowNestedMLComments(){
  return allowNestedMultiLineComments;
}

bool LanguageDefinition::highlightingDisabled(){
  return disableHighlighting;
}

bool LanguageDefinition::typesWithinStringsEnabled(){
  return enableTypesWithinStrings;
}

bool LanguageDefinition::isMatchingStringDelim(const string &open,
                                              const string &close){  
  return (stringCloseDelim.count(open)? 
         (*stringCloseDelim.find(open)).second==close : false); 
}

bool LanguageDefinition::isFullLineComment(){
  return fullLineComment;
}

bool LanguageDefinition::needsReload(const string &langDefPath){
  return currentPath!=langDefPath;
}

}
