/***************************************************************************
                          latexcode.h  -  description
                             -------------------
    begin                : Mit Jul 24 2002
    copyright            : (C) 2002 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LATEXCODE_H
#define LATEXCODE_H

#include <string>
#include <iostream>
#include <sstream>

#include "codeparser.h"
#include "version.h"
#include "charcodes.h"


namespace highlight {

/** Class for outputting LaTeX
   @author Andre Simon
*/

class LatexCode : public highlight::CodeParser
  {
  public:

   /** Constructor     
     \param langDef LanguageDefinition which contains parsing information   
     \param colourTheme Name of Colour theme to use  
     \param printLineNumbers Test if line numbers should be printed
     \param fragment Test if header and footer of document should be omitted          
     \param numSpaces Number of spaces which replace a tab
     \param wrapStyle Line wrapping mode (0=none, 1=simple, 2=normal)
     \param replQuotes Test if quotes shold be replaced by \dq
    */
    LatexCode(const string &colourTheme,
              bool printLineNumbers=false,  bool fragment=false, 
              int numSpaces=0, 
              highlight::WrapMode wrapStyle=highlight::WRAP_DISABLED,
              bool replQuotes=false);
    LatexCode();
    ~LatexCode();

   /** prints document header
       \param  title Title of the document
    */
    string getHeader(const string & title);

    /** Prints document footer*/
    string getFooter();

    /** Prints document body*/
    void printBody();    

  private: // Private methods
    string styleDefinition;
    /** Gibt Tex-Code der Sonderzeichen zurueck */
    virtual string maskCharacter(unsigned char );
    string formatStyleAttributes(const string & elemName, 
                                 const ElementStyle & elem);
    bool isOpeningStringDelim;
    bool replaceQuotes;
    string getNewLine();
  };

}

#endif
