/***************************************************************************
                          stylecolour.cpp  -  description
                             -------------------
    begin                : Die Nov 5 2002
    copyright            : (C) 2002 by Andr�Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "stylecolour.h"

using std::string;

namespace highlight {

StyleColour::StyleColour(const string & r_hex, const string & g_hex, const string & b_hex)
    : r(r_hex), g(g_hex), b(b_hex)
{}
StyleColour::StyleColour()
    : r("00"), g("00"), b("00")
{}

//Parst PArameter aus style-Datei
StyleColour::StyleColour(const string & styleColourString)
{
  setRGBValues(styleColourString);
}

void StyleColour::setRGBValues(const string & styleColourString){
  //Stringstream zum Einlesen der Tokens:
  istringstream valueStream(styleColourString.c_str());
  valueStream >> r;
  valueStream >> g;
  valueStream >> b;
}

void StyleColour::setRedValue(const string & r_hex)
{
  r = r_hex;
}

void StyleColour::setGreenValue(const string & g_hex)
{
  g = g_hex;
}

void StyleColour::setBlueValue(const string & b_hex)
{
  b = b_hex;
}

string& StyleColour::getHexRedValue()
{
  return r;
}
string& StyleColour::getHexGreenValue()
{
  return g;
}
string& StyleColour::getHexBlueValue()
{
  return b;
}


string StyleColour::getRTFRedValue()
{
  return int2str(hex2dec(r));
}
string StyleColour::getRTFGreenValue()
{
  return int2str(hex2dec(g));
}
string StyleColour::getRTFBlueValue()
{
  return int2str(hex2dec(b));
}


string StyleColour::getLatexRedValue()
{
  return float2str((float)hex2dec(r)/255);
}
string StyleColour::getLatexGreenValue()
{
  return float2str((float)hex2dec(g)/255);
}
string StyleColour::getLatexBlueValue()
{
  return float2str((float)hex2dec(b)/255);
}

// Konvertieren von RGB nach CYM
string StyleColour::getTexRedValue()
{
  return float2str(1-(float)hex2dec(r)/255);
}
string StyleColour::getTexGreenValue()
{
  return float2str(1-(float)hex2dec(g)/255);
}
string StyleColour::getTexBlueValue()
{
  return float2str(1-(float)hex2dec(b)/255);
}


string StyleColour::int2str(const int num)
{
  std::ostringstream outStream;
  outStream << num;

  return outStream.str();
}

string StyleColour::float2str(const double num)
{
  std::ostringstream outStream;
  outStream << ( floor ( num * 100 + .5 ) / 100);

  return outStream.str();
}

int  StyleColour::hex2dec(const string &hexVal)
{

  if (hexVal.length() != 2)
    return 0;

  unsigned int decVal=0, koeff=16;

  for (int i=0; i<2;i++ )
    {
      if ((hexVal[i] >= '0')&& (hexVal[i]<= '9' ))
        {
          decVal += (koeff * (hexVal[i]-'0'));

        }
      if ((hexVal[i] >= 'a')&& (hexVal[i]<= 'f' ))
        {
          decVal +=( koeff * (hexVal[i]-87));
        }
      if ((hexVal[i] >= 'A')&& (hexVal[i]<= 'F' ))
        {
          decVal += (koeff * (hexVal[i]-55));
        }
      koeff=1;
    }
  return decVal;
}

}

