/***************************************************************************
                        linewrapper.cpp  -  description
                             -------------------
    begin                : Sa Jan 00 2004
    copyright            : (C) 2004 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "linewrapper.h"

namespace highlight {

LineWrapper::LineWrapper(unsigned int maxlength, bool indentAfterOpenBraces):
 MAX_LINE_LENGTH(maxlength-1), 
 index(0),
 wsPrefixLength(string::npos),
 hasMore(false),
 indentAfterOpenBraces(indentAfterOpenBraces),
 redefineWsPrefix(false)
{  
}

LineWrapper::LineWrapper():
 MAX_LINE_LENGTH(80), 
 index(0),
 wsPrefixLength(string::npos),
 hasMore(false),
 indentAfterOpenBraces(true),
 redefineWsPrefix(false)
{  
}

LineWrapper::~LineWrapper()
{
}

bool LineWrapper::hasMoreLines(){
  return hasMore;
}

bool LineWrapper::indentCode(){
  return indentAfterOpenBraces;
}

void LineWrapper::setLine(const std::string newLine){
  line=newLine;
  wsPrefix="";  
  index=0;
  wsPrefixLength=string::npos;
  hasMore=true;
  redefineWsPrefix=false;
}

std::string  LineWrapper::getNextLine(){        
   
   if (!index && line.length() > MAX_LINE_LENGTH){ // erster Durchlauf...
      // wenn mglich an ffnender Klammer oder Geichheitszeichen ausrichten
      if (indentAfterOpenBraces){
          wsPrefixLength=line.find_first_of("{(=");
      }
      // sonst die Einrckung der Originalzeile beibehalten
      if (wsPrefixLength==string::npos || wsPrefixLength-index>MAX_LINE_LENGTH){
          wsPrefixLength=line.find_first_not_of(WS_CHARS);
      }
      else {
          // wsPrefix in allen neu umgebrochenen Zeilen durch Spaces ersetzen
          redefineWsPrefix=true;
          //  Position hinter ffnende Klammer springen
          wsPrefixLength=line.find_first_not_of(WS_CHARS,wsPrefixLength+1); 
      }
      
      if (wsPrefixLength!=string::npos){
        index = wsPrefixLength;
        // Falls Anzahl der Whitespaces am beginn der ersten zeile gr�r
        // als Max. Zeilenl�ge, Whitespaces verwerfen
        if (wsPrefixLength>MAX_LINE_LENGTH){   
          wsPrefixLength=0;
          return string();          
        }
        else{          
           wsPrefix=line.substr(0, wsPrefixLength);          
        }
      }
      // Zeile enthaelt nur Whitespace; verwerfen
      else {
       hasMore= false;
       return string();
      }
   } else {
     if (redefineWsPrefix){
       wsPrefix="";
       for (unsigned int i=0;i<wsPrefixLength;i++)
          wsPrefix += " ";
     }
     redefineWsPrefix=false;
   }

   string resultString;
   
   // Position, ab der rckwaerts nach Umbruchmglichkeit gesucht wird
   unsigned int searchEndPos=MAX_LINE_LENGTH-wsPrefixLength;
   
   // letztes Teilstueck der Zeile ausgeben; Parsen beenden
   if (line.length()-index < searchEndPos) {
     hasMore=false;
     resultString=(index>0)?wsPrefix + line.substr(index): line.substr(index);
     return resultString;
   }
   
   // Umbrechposition suchen
   size_t lbPos = line.find_last_of(LB_CHARS, index+searchEndPos);
   if (lbPos <= index || lbPos == string::npos) {
     // nichts gefunden, hart umbrechen
     lbPos = index + searchEndPos;
   }
   // Einrckung der Originalzeile erhalten
   resultString+=wsPrefix;
   // Neue Zeile erzeugen
   resultString += line.substr(index, lbPos-index+1);
  
   // Whitespace am neuen Zeilenbeginn ignorieren, ausser beim ersten Durchlauf
   //unsigned int newIndex=StringTools::getNextNonWsPos(line,lbPos+1);
   size_t newIndex=line.find_first_not_of(WS_CHARS, lbPos+1);
   index=(newIndex!=string::npos)?newIndex:line.length();

   hasMore=index!=line.length(); // unnoetigen Leerstring vermeiden

   return resultString;
}

}
