/***************************************************************************
                          xslfocode.cpp  -  description
                             -------------------
    begin                : Do 11.12.2003
    copyright            : (C) 2003 by Andr Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "xslfogenerator.h"

using namespace std;
namespace highlight {

XslFoGenerator::XslFoGenerator(const string &colourTheme,
                               bool fopCompatible)
    : CodeGenerator(colourTheme),
     fopOutput(fopCompatible)
{
  styleTagOpen.push_back( getOpenTag(docStyle.getDefaultStyle()));
  styleTagOpen.push_back( getOpenTag(docStyle.getStringStyle()));
  styleTagOpen.push_back( getOpenTag(docStyle.getNumberStyle()));
  styleTagOpen.push_back( getOpenTag(docStyle.getSingleLineCommentStyle()));
  styleTagOpen.push_back( getOpenTag(docStyle.getCommentStyle()));
  styleTagOpen.push_back( getOpenTag(docStyle.getEscapeCharStyle()));
  styleTagOpen.push_back( getOpenTag(docStyle.getDirectiveStyle()));
  styleTagOpen.push_back( getOpenTag(docStyle.getDirectiveStringStyle()));
  styleTagOpen.push_back( getOpenTag(docStyle.getLineStyle()));
  styleTagOpen.push_back( getOpenTag(docStyle.getSymbolStyle()));
  snl << "  <fo:block font-size=\""
      << docStyle.getFontSize()
      << "pt\" font-family=\"Courier\" white-space-collapse=\"false\" "
      << "wrap-option=\"wrap\" line-height=\"12pt\" background-color=\"#"
      << (docStyle.getBgColour().getHexRedValue())
      << (docStyle.getBgColour().getHexGreenValue())
      << (docStyle.getBgColour().getHexBlueValue())
      << "\">";

 for (int i=0;i<NUMBER_BUILTIN_STYLES; i++)
  {
    styleTagClose.push_back( "</fo:inline>");
  }
  if (fopOutput)
    newLineTag ="</fo:block>\n<fo:block>";
  else
    newLineTag ="</fo:block>\n"+ snl.str();

  spacer = " ";
}

XslFoGenerator::XslFoGenerator()
{}
XslFoGenerator::~XslFoGenerator()
{}

string  XslFoGenerator::getOpenTag(const ElementStyle &elem)
{
  ostringstream s;
  s  << "<fo:inline color=\"#"
     << (elem.getColour().getHexRedValue())
     << (elem.getColour().getHexGreenValue())
     << (elem.getColour().getHexBlueValue())
     << "\"";
   s << ( elem.isBold() ?" font-weight=\"bold\"" :"" )
     << ( elem.isItalic() ?" font-style=\"italic\"" :"" )
     << ( elem.isUnderline() ?" text-decoration=\"underline\"" :"" );
   s << ">";
  return  s.str();
}

string XslFoGenerator::getHeader(const string & title)
{
   ostringstream os;
   os << "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n"
      << "<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\n"
      << "<fo:layout-master-set>\n"
      << "<fo:simple-page-master master-name=\"DINA4\"\n"
      << "    page-height=\"29.7cm\"\n"
      << "    page-width=\"21cm\"\n"
      << "    margin-top=\"1cm\"\n"
      << "    margin-bottom=\"2cm\"\n"
      << "    margin-left=\"2.5cm\"\n"
      << "    margin-right=\"2.5cm\">\n"
      << "<fo:region-body />\n"
      << "</fo:simple-page-master>\n"
      << "<fo:page-sequence-master master-name=\"basic\">\n"
      << "<fo:repeatable-page-master-alternatives>\n"
      << "<fo:conditional-page-master-reference master-reference=\"DINA4\" />\n"
      << "</fo:repeatable-page-master-alternatives>\n"
      << "</fo:page-sequence-master>\n"
      << "</fo:layout-master-set>\n\n"
      << "<fo:page-sequence master-reference=\"basic\">\n"
      << " <fo:flow flow-name=\"xsl-region-body\">\n";
   if (fopOutput)
     os << snl.str()<< "<fo:block>";
   else
     os << snl.str();

  return  os.str();
}

/** gibt RTF-Text aus */
void XslFoGenerator::printBody()
{
  processRootState();
}


string XslFoGenerator::getFooter()
{
  ostringstream os;
  if (fopOutput)
    os <<"\n</fo:block>";
  os <<"\n</fo:block>\n </fo:flow>\n</fo:page-sequence>\n</fo:root>"<<endl
     << "<!-- XSL-FO generated by Highlight "
     << HIGHLIGHT_VERSION
     << ", "
     << HIGHLIGHT_URL
     <<" -->\n";
  return os.str();
}

/** Gibt RTF-Code der Sonderzeichen zurueck */
string XslFoGenerator::maskCharacter(unsigned  char c)
{
  switch (c)
    {
      case '<' :
      return "&lt;";
      break;
    case '>' :
      return "&gt;";
      break;
    case '&' :
      return "&amp;";
      break;
    case '\"' :
      return "&quot;";
      break;

// skip  first byte of multibyte chracters
    #ifndef _WIN32
    case 195:
      return string("");
      break;
    #endif

    default:
      string m;
      m += c;
      return m;
    }
}

string XslFoGenerator::getNewLine(){
  string nlStr;

  if (currentState!=_UNKNOWN){
    nlStr+=styleTagClose[currentState];
  }
  nlStr += newLineTag;
  if (currentState!=_UNKNOWN){
    nlStr+=styleTagOpen[currentState];
  }
  return nlStr;
}

string XslFoGenerator::getMatchingOpenTag(unsigned int styleID){
 return getOpenTag(docStyle.getKeywordStyle(langInfo.getKeywordClasses()[styleID]));
}

string XslFoGenerator::getMatchingCloseTag(unsigned int styleID){
  return "</fo:inline>";
}

}
