/***************************************************************************
                          xmlcode.cpp  -  description
                             -------------------
    begin                : Do 20.01.2005
    copyright            : (C) 2005 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "xmlgenerator.h"

using namespace std;
namespace highlight {

XmlGenerator::XmlGenerator()
: CodeGenerator(XML)
{
    styleTagOpen.push_back(getOpenTag("def"));
    styleTagOpen.push_back(getOpenTag("str"));
    styleTagOpen.push_back(getOpenTag("num"));
    styleTagOpen.push_back(getOpenTag("slc"));
    styleTagOpen.push_back(getOpenTag("com"));
    styleTagOpen.push_back(getOpenTag("esc"));
    styleTagOpen.push_back(getOpenTag("dir"));
    styleTagOpen.push_back(getOpenTag("dstr"));
    styleTagOpen.push_back(getOpenTag("line"));
    styleTagOpen.push_back(getOpenTag("sym"));

    styleTagClose.push_back(getCloseTag("def"));
    styleTagClose.push_back(getCloseTag("str"));
    styleTagClose.push_back(getCloseTag("num"));
    styleTagClose.push_back(getCloseTag("slc"));
    styleTagClose.push_back(getCloseTag("com"));
    styleTagClose.push_back(getCloseTag("esc"));
    styleTagClose.push_back(getCloseTag("dir"));
    styleTagClose.push_back(getCloseTag("dstr"));
    styleTagClose.push_back(getCloseTag("line"));
    styleTagClose.push_back(getCloseTag("sym"));

    spacer = " ";
    newLineTag = "<br />\n";
}

XmlGenerator::~XmlGenerator() {}

string XmlGenerator::getStyleDefinition()
{
    if (styleDefinitionCache.empty()) {
        ostringstream os;
        os << "\n<style>\n"
           << "\t<bgcolor value=\""
           << (docStyle.getBgColour().getHexRedValue())
           << (docStyle.getBgColour().getHexGreenValue())
           << (docStyle.getBgColour().getHexBlueValue())
           << "\" />\n";
        os << "\t<font size=\"" << getBaseFontSize();
        os << "\" family=\"" << getBaseFont() << "\" />\n";
        os << formatStyleAttributes("def", docStyle.getDefaultStyle())
           << formatStyleAttributes("num", docStyle.getNumberStyle())
           << formatStyleAttributes("esc", docStyle.getEscapeCharStyle())
           << formatStyleAttributes("str", docStyle.getStringStyle())
           << formatStyleAttributes("dstr", docStyle.getDirectiveStringStyle())
           << formatStyleAttributes("slc", docStyle.getSingleLineCommentStyle())
           << formatStyleAttributes("com", docStyle.getCommentStyle())
           << formatStyleAttributes("dir", docStyle.getDirectiveStyle())
           << formatStyleAttributes("sym", docStyle.getSymbolStyle())
           << formatStyleAttributes("line", docStyle.getLineStyle());

        KeywordStyles styles = docStyle.getKeywordStyles();
        for (KSIterator it=styles.begin(); it!=styles.end(); it++){
            os << formatStyleAttributes(it->first, *(it->second));
        }
        os << "</style>\n";
        styleDefinitionCache=os.str();
    }
    return styleDefinitionCache;
}


string XmlGenerator::formatStyleAttributes(const string & elemName,
                                           const ElementStyle & elem)
{
    ostringstream s;
    s  << "\t<class name=\""
       << elemName
       <<"\" color=\""
       << (elem.getColour().getHexRedValue())
       << (elem.getColour().getHexGreenValue())
       << (elem.getColour().getHexBlueValue()  )
       << "\" bold=\""
       << ( elem.isBold() ? "true" :"false" )
       << "\" italic=\""
       << ( elem.isItalic() ? "true" :"false" )
       << "\" underline=\""
       << ( elem.isUnderline() ? "true" :"false" )
       << "\" />\n" ;
    return  s.str();
}

string  XmlGenerator::getOpenTag(const string& styleName ){
    return "<"+styleName+">";
}

string  XmlGenerator::getCloseTag(const string& styleName ){
    return "</"+styleName+">";
}

string XmlGenerator::getHeader(const string & title)
{
    ostringstream header;
    header << "<?xml version=\"1.0\"";
    if (encodingDefined()) {
        header << " encoding=\"" << encoding << "\"";
    }
    header << "?>\n<document>" << getStyleDefinition();
    return header.str();
}

void XmlGenerator::printBody()
{
  *out << "<source>\n";
  processRootState();
  *out << "</source>\n";
}


string XmlGenerator::getFooter()
{
  ostringstream os;
  os <<"</document>\n";
  os<< "<!-- XML generated by Highlight "
     << HIGHLIGHT_VERSION
     << ", "
     << HIGHLIGHT_URL
     <<" -->\n";
  return os.str();
}

string XmlGenerator::maskCharacter(unsigned  char c)
{
  switch (c)
    {
      case '<' :
      return "&lt;";
      break;
    case '>' :
      return "&gt;";
      break;
    case '&' :
      return "&amp;";
      break;
    case '\"' :
      return "&quot;";
      break;
    default:
      string m;
      m += c;
      return m;
    }
}

/*string XmlGenerator::getNewLine(){
  string nlStr;
  if (currentState!=_UNKNOWN){
      nlStr+=styleTagClose[getStyleID(currentState, currentKeywordClass)];
  }
  nlStr += newLineTag;
  if (currentState!=_UNKNOWN){
      nlStr+=styleTagOpen[getStyleID(currentState, currentKeywordClass)];
  }
  return nlStr;
}
*/
string XmlGenerator::getMatchingOpenTag(unsigned int styleID){
    return getOpenTag(langInfo.getKeywordClasses()[styleID]);
}

string XmlGenerator::getMatchingCloseTag(unsigned int styleID){
    return getCloseTag(langInfo.getKeywordClasses()[styleID]);
}

}
