{- This module was generated from data in the Kate syntax highlighting file haskell.xml, version 1.04,
   by  Marcel Martin (mmar@freenet.de) -}

module Text.Highlighting.Kate.Syntax.Haskell ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Data.List (nub)
import qualified Data.Set as Set
import Data.Map (fromList)
import Data.Maybe (fromMaybe)

-- | Full name of language.
syntaxName :: String
syntaxName = "Haskell"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.hs"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Haskell" }
  context <- currentContext <|> (pushContext "normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Haskell",["normal"])], synStLanguage = "Haskell", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "normal" -> return ()
    "comment_single_line" -> (popContext >> return ())
    "comment_multi_line" -> return ()
    "string" -> return ()
    "infix" -> return ()
    "single_char" -> (popContext >> return ())
    "function_definition" -> (popContext >> return ())
    _ -> return ()
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents, synStCharsParsedInLine = 0, synStPrevChar = '\n' }

withAttribute attr txt = do
  if null txt
     then fail "Parser matched no text"
     else return ()
  let style = fromMaybe "" $ lookup attr styles
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (nub [style, attr], txt)

styles = [("Normal Text","Normal"),("Module Name","Normal"),("Keyword","Keyword"),("Function","Function"),("Function Definition","Function"),("Class","Keyword"),("Decimal","DecVal"),("Float","Float"),("Char","Char"),("String","String"),("Constructor","Others"),("Comment","Comment"),("Data Constructor","Keyword"),("Type Constructor","DataType"),("Infix Operator","Others")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "as case class data deriving do else if import in infixl infixr instance let module of primitive qualified then type where"
list_infix_operators = Set.fromList $ words $ "quot rem div mod elem notElem seq"
list_functions = Set.fromList $ words $ "FilePath IOError abs acos acosh all and any appendFile approxRational asTypeOf asin asinh atan atan2 atanh basicIORun break catch ceiling chr compare concat concatMap const cos cosh curry cycle decodeFloat denominator digitToInt div divMod drop dropWhile either elem encodeFloat enumFrom enumFromThen enumFromThenTo enumFromTo error even exp exponent fail filter flip floatDigits floatRadix floatRange floor fmap foldl foldl1 foldr foldr1 fromDouble fromEnum fromInt fromInteger fromIntegral fromRational fst gcd getChar getContents getLine head id inRange index init intToDigit interact ioError isAlpha isAlphaNum isAscii isControl isDenormalized isDigit isHexDigit isIEEE isInfinite isLower isNaN isNegativeZero isOctDigit isPrint isSpace isUpper iterate last lcm length lex lexDigits lexLitChar lines log logBase lookup map mapM mapM_ max maxBound maximum maybe min minBound minimum mod negate not notElem null numerator odd or ord otherwise pi pred primExitWith print product properFraction putChar putStr putStrLn quot quotRem range rangeSize read readDec readFile readFloat readHex readIO readInt readList readLitChar readLn readOct readParen readSigned reads readsPrec realToFrac recip rem repeat replicate return reverse round scaleFloat scanl scanl1 scanr scanr1 seq sequence sequence_ show showChar showInt showList showLitChar showParen showSigned showString shows showsPrec significand signum sin sinh snd span splitAt sqrt subtract succ sum tail take takeWhile tan tanh threadToIOResult toEnum toInt toInteger toLower toRational toUpper truncate uncurry undefined unlines until unwords unzip unzip3 userError words writeFile zip zip3 zipWith zipWith3"
list_type_constructors = Set.fromList $ words $ "Bool Char Double Either Float IO Integer Int Maybe Ordering Rational Ratio ReadS ShowS String"
list_classes = Set.fromList $ words $ "Bounded Enum Eq Floating Fractional Functor Integral Ix Monad Num Ord Read RealFloat RealFrac Real Show"
list_data_constructors = Set.fromList $ words $ "EQ False GT Just LT Left Nothing Right True"

regex_'2d'2d'24 = compileRegex "--$"
regex_'2d'2d'5b_A'2dZa'2dz0'2d9'5c'2d'2c'3b'60'5d'2e'2a'24 = compileRegex "--[ A-Za-z0-9\\-,;`].*$"
regex_'28'5bA'2dZ'5d'5bA'2dZa'2dz0'2d9'5d'2a'5c'2e'29'2b'5bA'2dZ'5d'5bA'2dZa'2dz0'2d9'5d'2a = compileRegex "([A-Z][A-Za-z0-9]*\\.)+[A-Z][A-Za-z0-9]*"
regex_'5cw'5b'27'5d'2b = compileRegex "\\w[']+"
regex_'5ba'2dz'5f'5d'2b'5cw'2a'27'2a'5cs'2a'3a'3a = compileRegex "[a-z_]+\\w*'*\\s*::"
regex_'5c'5c'2e = compileRegex "\\\\."

defaultAttributes = [("normal","Normal Text"),("comment_single_line","Comment"),("comment_multi_line","Comment"),("string","String"),("infix","Infix Operator"),("single_char","Char"),("function_definition","Function Definition")]

parseRules "normal" = 
  do (attr, result) <- (((pDetect2Chars False '{' '-' >>= withAttribute "Comment") >>~ pushContext "comment_multi_line")
                        <|>
                        ((pRegExpr regex_'2d'2d'24 >>= withAttribute "Comment") >>~ pushContext "comment_single_line")
                        <|>
                        ((pRegExpr regex_'2d'2d'5b_A'2dZa'2dz0'2d9'5c'2d'2c'3b'60'5d'2e'2a'24 >>= withAttribute "Comment") >>~ pushContext "comment_single_line")
                        <|>
                        ((pRegExpr regex_'28'5bA'2dZ'5d'5bA'2dZa'2dz0'2d9'5d'2a'5c'2e'29'2b'5bA'2dZ'5d'5bA'2dZa'2dz0'2d9'5d'2a >>= withAttribute "Module Name"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_classes >>= withAttribute "Class"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_type_constructors >>= withAttribute "Type Constructor"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_functions >>= withAttribute "Function"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_data_constructors >>= withAttribute "Data Constructor"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "string")
                        <|>
                        ((pDetectChar False '`' >>= withAttribute "Infix Operator") >>~ pushContext "infix")
                        <|>
                        ((pRegExpr regex_'5cw'5b'27'5d'2b >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Char") >>~ pushContext "single_char")
                        <|>
                        ((pRegExpr regex_'5ba'2dz'5f'5d'2b'5cw'2a'27'2a'5cs'2a'3a'3a >>= withAttribute "Function Definition"))
                        <|>
                        ((pFloat >>= withAttribute "Float"))
                        <|>
                        ((pInt >>= withAttribute "Decimal")))
     return (attr, result)

parseRules "comment_single_line" = 
  pzero

parseRules "comment_multi_line" = 
  do (attr, result) <- ((pDetect2Chars False '-' '}' >>= withAttribute "Comment") >>~ (popContext >> return ()))
     return (attr, result)

parseRules "string" = 
  do (attr, result) <- (((pRegExpr regex_'5c'5c'2e >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "infix" = 
  do (attr, result) <- ((pDetectChar False '`' >>= withAttribute "Infix Operator") >>~ (popContext >> return ()))
     return (attr, result)

parseRules "single_char" = 
  do (attr, result) <- (((pRegExpr regex_'5c'5c'2e >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Char") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "function_definition" = 
  do (attr, result) <- ((pDetectChar False ';' >>= withAttribute "Function Definition") >>~ (popContext >> return ()))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
