{- This module was generated from data in the Kate syntax highlighting file ansys.xml, version 1.1,
   by  Giovanni Bacci (giovanni@castellodilari.it) -}

module Text.Highlighting.Kate.Syntax.Ansys ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Ansys"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.ans"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Ansys" }
  context <- currentContext <|> (pushContext "Normal Text" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Ansys",["Normal Text"])], synStLanguage = "Ansys", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal Text" -> (popContext) >> pEndLine
    "doublequotestring" -> return () >> pHandleEndLine
    "functions" -> (popContext) >> pEndLine
    "open_parentesis" -> (popContext) >> pEndLine
    "comment" -> (popContext) >> pEndLine
    "functions_arg" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("MatProp","dt"),("Labels","ch"),("APDLcmd","fu"),("SESSIONcmd","fu"),("DBcmd","fu"),("GRPH_cmds","fu"),("PREP7Commands","fu"),("SOLUCommands","fu"),("POST1Commands","fu"),("POST26Commands","fu"),("AUX2cmds","fu"),("AUX3cmds","fu"),("AUX12cmds","fu"),("AUX15cmds","fu"),("RUNSTATcmds","fu"),("OPTIMIZATIONcmds","fu"),("PROBcmds","fu"),("DISPLAYcmds","fu"),("REDUORDERcmds","fu"),("Commands","ot"),("variable","ot"),("String","st"),("NumInt","dv"),("NumFloat","fl"),("functions_arg","kw"),("comment","co"),("parentesis_not_closed","re"),("error","er")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_session'5fcmds = Set.fromList $ words $ "/batch /config /cwd /eof /exit /filname help /input keyw memm /menu /mstart /nerr /output /status /syp /sys /ui /uis /aux2 /aux3 /aux12 /aux15 finish /opt /post1 /post26 /prep7 /quit /runst /solu /assign /clog /copy /delete /fdele /ftype lgwrite *list /rename /com /go /golist /gopr /nolist /nopr"
list_database'5fcmds = Set.fromList $ words $ "/clear resume save /smbc stat /stitle /title undo /units allsel asll asel aslv dofsel esel esla esll esln eslv ksel ksll ksln lsel lsla lslk nsel nsla nsle nslk nsll nslv partsel vsel vsla cm cmdele cmedit cmgrp cmlist cmmod cmplot cmsel kwpave kwplan lwplan nwpave nwplan wpave wpcsys wplane wpoffs wprota wpstyl clocal cs cscir csdele cskp cslist cswpla csys local fitem flst"
list_graphic'5fcmds = Set.fromList $ words $ "/cmap /color /device dsys /dv3d /erase erase /gcmd /gcolumn /gfile gplot /graphics /gresume /gsave /gtype hpgl /image immed jpeg /mrep /noerase /pcopy pngr pscr /pstatus /replot /reset /seg /show tiff /window /angle /auto /dist /focus /user /vcone /view /vup /xfrm /zoom /dscale /iclwid /icscale /ratio /shrink /sscale /txtre /vscale /cplane /ctype /edge /eshape /facet /gline /gmarker gmface /light /normal /shade /trlcy /type /cformat /clabel /contour /cval /gformat /hbc /number /pbc /pbf pgsele /pice /plopts /pnum /psf /psymb /triad /udoc /axlab /grid /gropt /grtyp /gthk /xrange /yrange /an3d /annot /anum /larc /line /lspec /lsymbol /pcircle /pmore /polygon /pspec /pwedge /tlabel /tspec"
list_APDL'5fcommands = Set.fromList $ words $ "get *abbr abbres abbsav *afun *ask *cfclos *cfopen *cfwrite *create *cycle *del /dflab *dim /directory *do *dowhile *else *elseif *end *enddo *endif *exit *get *go *if /inquire /mail *mfouri *mfun *moper *msg *mwrite parres parsav /pmacro /psearch *repeat *return *set *sread *status *taxis /tee *toper *tread /ucmd *ulib *use *vabs *vcol *vcum *vedit *vfact *vfill *vfun *vget *vitrp *vlen *vmask *voper *vplot *vput *vread *vscfun *vstat *vwrite /wait"
list_prep7'5fcommands = Set.fromList $ words $ "aflist cdread cdwrite cdopt cecheck check cncheck fc fccheck fcdele fclist igesout nooffset numcmp nummrg numoff numstr dof et etcontrol etdele etlist keyopt nsvr r rdele rlist rmodif rmore setfgap emunit *eval *mooney mp mpamod mpchg mpcopy mpdata mpdele mpdres /mplib mplist mpplot mpread mptemp mptgen mptres mpwrite tbft uimp tb tbcopy tbdata tbdele tbfield tblist tbmodif tbplot tbpt tbtemp blc4 blc5 block con4 cone cyl4 cyl5 cylind pcirc poly pri2 prism ptxy rectng rpoly rpr4 rprism sph4 sph5 sphere torus gsum k kbetw kcenter kdele kdist kfill kgen kl klist kmodif kmove knode kplot kpscale kscale ksum ksymm ktran source hptcreate hptdelete bsplin circle gsum l l2ang l2tan lang larc larea lcomb ldele ldiv ldrag lextnd lfillt lgen llist lplot lreverse lrotat lsscale lstr lsum lsymm ltan ltran spline ssln a aatt adele adgl adrag afillt agen al alist anorm aoffst aplot areverse arotat arscale arsym askin asub asum atran gsum splot extopt gsum v va vdele vdgl vdrag vext vgen vlist vlscale voffst vplot vrotat vsum vsymm vtran aadd aglue aina ainp ainv aovlap aptn asba asbl asbv asbw boptn btol lcsl lglue lina linl linp linv lovlap lptn lsba lsbl lsbv lsbw vadd vglue vinp vinv vovlap vptn vsba vsbv vsbw accat aclear aesize amap amesh arefine chkmsh clrmshln cpcyc desize eorient erefine esize esys fvmesh gsgdata imesh katta kclear kesize kmesh krefine kscon latt lccat lclear lesize lmesh lrefine mat mcheck modmsh mopt mshape mshcopy mshkey mshmid mshpattern nrefine psmesh real rthick shpp smrtsize tchg timp type vatt vclear vimp vmesh veorient vsweep center fill move n nang ndele ndist ngen nkpt nlist nmodif nplot nread nrotat nrrang nscale nsmooth nsym nwrite quad source transfer afsurf e edele egen eintf elist emid emodif emore emtgen en endrelease engen enorm ensym eorient eplot eread errang esurf esym esys ewrite laylist layplot lfsurf mat ndsurf real shsd swadd swdel swgen swlist tshap type upgeom se sedlist selistl sesymm setran bellow bend branch flange miter pcorro pdrag pfluid pgap pinsul popt ppres pspec psprng ptemp punit reduce run tee valve dig dmove dset dsurf cp cpdele cpintf cplgen cplist cpngen cpsgen ce cecyc cedele ceintf celist cerig cesgen rbe3 noorder waves werase wfront wmid wmore wsort wstart fldata fldata1 fldata2 fldata3 fldata4 fldata4a fldata5 fldata6 fldata7 fldata8 fldata9 fldata10 fldata11 fldata12 fldata13 fldata14 fldata15 fldata16 fldata17 fldata18 fldata19 fldata20 fldata20a fldata20b fldata21 fldata22 fldata23 fldata24 fldata24a fldata24b fldata24c fldata24d fldata24e fldata24f fldata24g fldata24h fldata40 fldata25 fldata26 fldata34 fldata27 fldata28 fldata29 fldata30 fldata31 fldata32 fldata33 fldata35 fldata36 fldata37 fldata38 fldata39 icvfrc plvfrc msadv mscap msdata msmass msmeth msmir msnomf msprop msquad msrelax mssolu msspec msterm msvary /cycexpand cyclic cycopt emsym hferefine perbc2d physics race areas bool ceqn couple digit elem etype fatigue febody fecons fefor fesurf flotran geometry keypts line mater meshing nodes pipe pmeth prim rcon reorder selm tble volumes edasmp edbound edbx edcgen edclist edcmore edcnstr edcontact edcrb edcurve eddbl eddc edipart edlcs edmp ednb edndtsd ednrot edpart edpc edsp edweld alpfill arcollapse ardetach arfill armerge arsplit gapfinish gaplist gapmerge gapopt gapplot lncollapse lndetach lnfill lnmerge lnsplit sarplot slpplot slsplot vcvfill bsax bsm1 bsm2 bsmd bss1 bss2 bste bstq prssol sdelete secdata secjoint /seclib seclock secnum secoffset secplot secread secstop sectype secwrite slist ssbt ssmt sspa sspb sspd sspe sspm morph damorph demorph dvmorph tzamesh tzdele tzegen pmlopt pmlsize fsan fsco fsdt fsin fsit fsor fsou fsre fsstat fsti fstr"
list_solution'5fcommands = Set.fromList $ words $ "abextract adams adapt antype bcsoption cecheck check cmatrix cmsopt cncheck cutcontrol cycopt dmpext dsproc dsopt ematwrite eqslv eresx escheck essolv expass fsrs fssolv gauge gmatrix hfeigopt hfpa hfpcswp hfscat hfsweep lmatrix lumpm monitor msave opncontrol precision pscontrol psolve rate rstoff seexp segen seopt solcontrol /solu solve spscan spswp staopt toffst pconv pexclude pinclude /pmeth pmopts pprange arclena arctrm bucopt cnvtol crplim /gst lnsrch mxpand ncnv neqit nldiag nldpost nlgeom nlhist nropt pred pstres sstif subopt alphad betad dmprat harfrq hrexp hropt hrout lvscale mdamp mdplot modopt mxpand rigid subopt timint tintp trnopt addam coval cqc dsum freq grp nrlsum pfact psdcom psdfrq psdgraph psdspl psdunit psdval psdwav qdval rock sed spopt srss sv svtyp vddam autots cecmod deltim expsol hmagsolv kbc kuse magopt magsolv mode nsubst numexp time tref tsres upcoord usrcal wrfull da dadele dalist dk dkdele dklist dl dldele dllist dtran fk fkdele fklist ftran sfa sfadele sfalist sfl sfldele sfllist sftran bfa bfadele bfalist bfk bfkdele bfklist bfl bfldele bfllist bftran bfv bfvdele bfvlist acel cgloc cgomga cmacel cmdomega cmomega dcgomg domega irlf omega biot fmagbc hfport ic icdele ice icedele icelist iclist isfile mpchg outpr outres pgraph pgsave pgwrite plwave rescontrol sbclist sbctran wsprings lsclear lsdele lsread lssolve lswrite m mdele mgen mlist total gp gpdele gplist rezone mapsolve remesh aremesh ealive ekill estif d dcum ddele dj djdele djlist dlist dscale dsym gsbdata gslist ldread f fcum fdele fj fjdele fjlist flist fscale sf sfbeam sfcum sfdele sfe sfedele sfelist sffun sfgrad sflist sfscale bf bfcum bfdele bfe bfecum bfedele bfelist bfescal bflist bfscale bfunif ldread rimport tunif bioopt deact dynopt gap genopt inrtia lsoper master nlopt outopt smbody smcons smfor smsurf soluopt sptopt edadapt edale edbvis edcadapt edcpu edcsc edcts eddamp eddrelax eddump edenergy edfplot edgcale edhgls edhist edhtime edint edis edload edopt edout edpl edpvel edrc edrd edri edrst edrun edshell edsolv edstart edterm edtp edvel edwrite rexport flocheck pemopts hemiopt radopt rdec rsurf rsymm spcnod spctemp stef v2dopt vfcalc vfopt qsopt fsan fsco fsdt fsin fsit fsor fsou fsre fsrs fsstat fsti fstr mfanalysis mfbucket mfcalc mfclear mfcmmand mfconv mfdtime mfelem mfem mfexter mffname mfimport mfinter mfiter mflist mfmap mforder mfoutput mfrelax mfrstart mfsurface mftime mftol mfvolume"
list_POST1'5fcommands = Set.fromList $ words $ "append detab dnsol file hrcplx pgrset /post1 reset set subset avprin avres /efacet ernorm force inres layer rsys shell nsort nusort plconv pldisp plesol plnsol plvect pplot prconv presol prjsol prnld prnsol prrfor prrsol prssol prvect sumtype desol esort etable eusort pletab plls plvect pretab prvect sabs sadd sallow sexp sfact sfcalc smax smin smult ssum tallow vcross vdot /format /header irlist /page prerr priter ancntr ancut andata andscl ancyc andyna /anfile anflow anharm anim anisos anmode anmres antime trtime padele paget paput paresu pasave path pcalc pcross pdef pdot plpagm plpath plsect pmap ppath prange prpath prsect psel pvect sucalc sucr sudel sueval suget sumap supl supr suresu susave susel suvect lcabs lcase lcdef lcfact lcfile lcoper lcsel lcsum lcwrite lczero rappnd curr2d emagerr emf emft fluxv fmagsum for2d impd mmf plf2d powerh qfact reflcoef senergy sparm torq2d torqc2d torqsum fe felist fl fllist fp fplist fs fsdele fslist fsnode fsplot fssect ftcalc ftsize ftwrite pltrac trpdel trplis trpoin flread bfint cbdof cmsfile /cycexpand cycphase /expand expand fssparm fsum hfang hfarray hfnear hfpower hfsym intsrf kcalc nforce plcrack plhffar plsch plsyz prhffar prsyz rmflvec rsplit spoint datadef define display lccalc point print sort spec fc fccheck fcdele fclist"
list_POST26'5fcommands = Set.fromList $ words $ "ansol data edread esol file gapf gssol jsol nsol nstore numvar /post26 reset rforce /rgb solu store timerange vardel varnam cfact force layerp26 shell tvar abs add atan clog conjug deriv exp filldata imagin int1 large nlog prod quot realvar small sqrt plcplx pltime plvar spread xvar extrem lines nprint prcplx prtime prvar cvar pmgtran resp rpsd smooth vget vput define operate plotting print"
list_aux2'5fcmds = Set.fromList $ words $ "/aux2 dump fileaux2 form hbmat"
list_aux3'5fcmds = Set.fromList $ words $ "/aux3 compress delete fileaux3 list modify undelete"
list_aux12'5fcmds = Set.fromList $ words $ "/aux12 emis geom mprint space stef vfquery vtype write"
list_aux15'5fcmds = Set.fromList $ words $ "/aux15 igesin ioptn"
list_runstats'5fcmds = Set.fromList $ words $ "rall rfilsz riter rmemry rspeed rstat rtimst /runst rwfrnt"
list_optimization'5fcmds = Set.fromList $ words $ "/opt opeqn opfact opfrst opgrad opkeep oploop opprnt oprand opsubp opsweep optype opuser opvar tocomp todef tofreq totype tovar opadd opclr opdel opmake opsel opanl opdata opresu opsave opexe toexe toloop oplfa oplgr oplist oplsw oprfa oprgr oprsw plvaropt prvaropt tograph tolist toplot toprint tostat xvaropt"
list_probabilistic'5fcmds = Set.fromList $ words $ "/pds pdanl pdcorr pdinqr pdplot pdvar pddoel pddmcs pdmeth pduser pdexe pdcdf pdcmat pdhist pdpinv pdprob pdropt pdscat pdsens pdshis pdwrite pdclr pdresu pdsave rsfit rsplot rsprnt rssims"
list_display'5fcmds = Set.fromList $ words $ "/cmap /devdisp filedisp helpdisp nocolor /seg /showdisp trans grph term finish plot stat"
list_reduced'5forder'5fcmds = Set.fromList $ words $ "rmresume rmsave rmndisp rmnevec rmalist rmanl rmaster rmcap rmclist rmmlist rmmrange rmmselect rmporder rmrgenerate rmroptions rmrplot rmrstatus rmsmple rmxport dcvswp rmlvscale rmuse"
list_parametric'5ffunctions = Set.fromList $ words $ "abs sign exp log log10 sqrt nint mod rand gdis sin cos tan sinh cosh tanh asin acos atan atan2 valchr chrval upcase lwcase"
list_elements = Set.fromList $ words $ "link1 plane2 beam3 beam4 solid5 combin7 link8 infin9 link10 link11 contac12 plane13 combin14 pipe16 pipe17 pipe18 pipe20 mass21 beam23 beam24 plane25 matrix27 shell28 fluid29 fluid30 link31 link32 link33 link34 plane35 sourc36 combin37 fluid38 combin39 combin40 shell41 plane42 shell43 beam44 solid45 solid46 infin47 matrix50 shell51 contac52 plane53 beam54 plane55 hyper56 shell57 hyper58 pipe59 pipe60 shell61 solid62 shell63 solid64 solid65 plane67 link68 solid69 solid70 mass71 hyper74 plane75 plane77 plane78 fluid79 fluid80 fluid81 plane82 plane83 hyper84 hyper86 solid87 visco88 visco89 solid90 shell91 solid92 shell93 circu94 solid95 solid96 solid97 solid98 shell99 visco106 visco107 visco108 trans109 infin110 infin111 inter115 fluid116 solid117 hf118 hf119 hf120 plane121 solid122 solid123 circu124 circu125 trans126 solid127 solid128 fluid129 fluid130 shell131 shell132 fluid136 fluid138 fluid139 fluid141 fluid142 shell143 rom144 plane145 plane146 solid147 solid148 shell150 surf151 surf152 surf153 surf154 shell157 hyper158 link160 beam161 plane162 shell163 solid164 combi165 mass166 link167 solid168 targe169 targe170 conta171 conta172 conta173 conta174 conta175 conta178 prets179 link180 shell181 plane182 plane183 mpc184 solid185 solid186 solid187 beam188 beam189 solsh190 solid191 inter192 inter193 inter194 inter195 mesh200 follw201 shell208 shell209 plane223 solid226 solid227 plane230 solid231 solid232 surf251 surf252"
list_material'5fproperties = Set.fromList $ words $ "ex ey ez gxy nuxy alpx alpy alpz ctex ctey ctez thsx thsy thsz reft prxy pryz prxz nuxy nuyz nuxz gxy gyz gxz damp dmpr mu dens c enth kxx kyy kzz hf emis qrate visc sonc rsvx rsvy rsvz perx murx mury murz mgxx mgyy mgzz lsst sbkx"
list_force'2ddisplacement'2dlabels = Set.fromList $ words $ "ux uy uz fx fy fz mx my mz heat hbot he2 he3 htop flow amps chrg csgx csgy csgz rotx roty rotz warp temp tbot te2 te3 ttop pres vx vy vz enke ends sp01 sp02 sp03 sp04 sp05 sp06 volt mag ax ayaz"
list_antype'5fflag = Set.fromList $ words $ "static buckle modal harmic trans substr spectr"
list_various'5flabels = Set.fromList $ words $ "nx ny nz"

regex_'5bA'2dZa'2dZ0'2d9'5d'2b'5c'3d = compileRegex "[A-Za-Z0-9]+\\="

defaultAttributes = [("Normal Text","Normal Text"),("doublequotestring","String"),("functions","Normal Text"),("open_parentesis","parentesis_not_closed"),("comment","comment"),("functions_arg","NumFloat")]

parseRules "Normal Text" = 
  do (attr, result) <- (((pFirstNonSpace >> pString False "C***" >>= withAttribute "comment") >>~ pushContext "comment")
                        <|>
                        ((pDetectChar False '!' >>= withAttribute "comment") >>~ pushContext "comment")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_various'5flabels >>= withAttribute "MatProp"))
                        <|>
                        ((pRangeDetect '(' ')' >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '(' >>= withAttribute "error") >>~ pushContext "open_parentesis")
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bA'2dZa'2dZ0'2d9'5d'2b'5c'3d >>= withAttribute "Normal Text"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_elements >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_material'5fproperties >>= withAttribute "MatProp"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_force'2ddisplacement'2dlabels >>= withAttribute "Labels"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_antype'5fflag >>= withAttribute "Labels"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_parametric'5ffunctions >>= withAttribute "Commands"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_session'5fcmds >>= withAttribute "SESSIONcmd"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_database'5fcmds >>= withAttribute "DBcmd"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_graphic'5fcmds >>= withAttribute "GRPH_cmds"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_APDL'5fcommands >>= withAttribute "APDLcmd"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_prep7'5fcommands >>= withAttribute "PREP7Commands"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_solution'5fcommands >>= withAttribute "SOLUCommands"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_POST1'5fcommands >>= withAttribute "POST1Commands"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_POST26'5fcommands >>= withAttribute "POST26Commands"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_aux2'5fcmds >>= withAttribute "AUX2cmds"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_aux3'5fcmds >>= withAttribute "AUX3cmds"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_aux12'5fcmds >>= withAttribute "AUX12cmds"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_aux15'5fcmds >>= withAttribute "AUX15cmds"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_runstats'5fcmds >>= withAttribute "RUNSTATScmds"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_optimization'5fcmds >>= withAttribute "OPTIMIZATIONcmds"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_probabilistic'5fcmds >>= withAttribute "PROBcmds"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_display'5fcmds >>= withAttribute "DISPLAYcmds"))
                        <|>
                        ((pFirstNonSpace >> pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_reduced'5forder'5fcmds >>= withAttribute "REDUORDERcmds"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "doublequotestring")
                        <|>
                        ((pRangeDetect '\'' '\'' >>= withAttribute "String"))
                        <|>
                        ((pRangeDetect '%' '%' >>= withAttribute "variable"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&;?[]^{|}~\\" list_APDL'5fcommands >>= withAttribute "MatProp"))
                        <|>
                        ((pFloat >>= withAttribute "NumFloat"))
                        <|>
                        (withChildren (pInt >>= withAttribute "NumInt") ((pString False "**" >>= withAttribute "NumInt"))))
     return (attr, result)

parseRules "doublequotestring" = 
  do (attr, result) <- ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext))
     return (attr, result)

parseRules "functions" = 
  do (attr, result) <- (((pRangeDetect '(' ')' >>= withAttribute "Normal Text") >>~ (popContext))
                        <|>
                        ((pDetectChar False '(' >>= withAttribute "error") >>~ pushContext "open_parentesis"))
     return (attr, result)

parseRules "open_parentesis" = 
  do (attr, result) <- ((pDetectChar False ')' >>= withAttribute "Normal Text") >>~ (popContext))
     return (attr, result)

parseRules "comment" = 
  pzero

parseRules "functions_arg" = 
  do (attr, result) <- (((pDetectChar False '(' >>= withAttribute "Keyword"))
                        <|>
                        ((pDetectChar False ')' >>= withAttribute "Keyword") >>~ (popContext)))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
