{- This module was generated from data in the Kate syntax highlighting file gap.xml, version 0.2,
   by  Jose Joao Morais -}

module Text.Highlighting.Kate.Syntax.Gap ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "GAP"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.gd;*.gi;*.g"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "GAP" }
  context <- currentContext <|> (pushContext "Top_Level" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("GAP",["Top_Level"])], synStLanguage = "GAP", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Top_Level" -> return () >> pHandleEndLine
    "Commentary" -> (popContext) >> pEndLine
    "Code_Folding" -> pushContext "Top_Level" >> pHandleEndLine
    "Two Char Operators" -> return () >> pHandleEndLine
    "Strings" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Builtin Functions","fu"),("Commentary","co"),("Control Statements","kw"),("Function","kw"),("GAP Keywords","kw"),("Incomplete String","ch"),("Logic Operators","kw"),("Math Operators","kw"),("Number","fl"),("String","st")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_controlstatements = Set.fromList $ words $ "break continue do elif else then"
list_logicoperators = Set.fromList $ words $ "and fail false not or true"
list_gapkeywords = Set.fromList $ words $ "in local rec return"
list_mathoperators = Set.fromList $ words $ "mod"
list_builtinfunctions = Set.fromList $ words $ "AClosVecLib AClosestVectorCombinationsMatFFEVecFFE AClosestVectorCombinationsMatFFEVecFFECoords AClosestVectorDriver ANFAutomorphism ANonReesCongruenceOfSemigroup APolyProd AbelianGroup AbelianGroupCons AbelianInvariants AbelianInvariantsMultiplier AbelianInvariantsNormalClosureFpGroup AbelianInvariantsNormalClosureFpGroupRrs AbelianInvariantsOfList AbelianInvariantsSubgroupFpGroup AbelianInvariantsSubgroupFpGroupMtc AbelianInvariantsSubgroupFpGroupRrs AbelianNumberField AbelianNumberFieldByReducedGaloisStabilizerInfo AbelianPQuotient AbelianSubfactorAction AbsAndIrredModules AbsInt AbsolutIrreducibleModules AbsoluteIrreducibleModules AbsoluteValue AbstractWordTietzeWord AbstractWordTzWord ActingAlgebra ActingDomain Action ActionAbelianCSPG ActionHomomorphism ActionHomomorphismAttr ActionHomomorphismConstructor ActionKernelExternalSet ActionSubspacesElementaryAbelianGroup ActorOfExternalSet Add AddAbelianRelator AddCoeffs AddCosetInfoStabChain AddDictionary AddEquationsSQ AddGenerator AddGenerators AddGeneratorsExtendSchreierTree AddGeneratorsGenimagesExtendSchreierTree AddHashEntry AddImage AddImageNC AddNaturalHomomorphismsPool AddNormalizingElementPcgs AddPageNumbersToSix AddParagraphNumbersGapDocTree AddRefinement AddRelator AddRootParseTree AddRowVector AddRule AddRuleReduced AddSet AddToListEntries AddVectorLTM AddendumSCTable AdditiveCoset AdditiveElementAsMultiplicativeElement AdditiveElementsAsMultiplicativeElementsFamily AdditiveGroup AdditiveGroupByGenerators AdditiveInverse AdditiveInverseAttr AdditiveInverseImmutable AdditiveInverseMutable AdditiveInverseOp AdditiveInverseSM AdditiveInverseSameMutability AdditiveMagma AdditiveMagmaByGenerators AdditiveMagmaWithInverses AdditiveMagmaWithInversesByGenerators AdditiveMagmaWithZero AdditiveMagmaWithZeroByGenerators AdditiveNeutralElement AdditivelyActingDomain AdjointAssociativeAlgebra AdjointBasis AdjointMatrix AdjointModule AffineAction AffineActionByMatrixGroup AffineActionLayer AffineOperation AffineOperationLayer Agemo AgemoAbove AgemoOp AlgExtElm AlgExtEmbeddedPol AlgExtFactSQFree AlgExtSquareHensel AlgFacUPrep Algebra AlgebraByGenerators AlgebraByStructureConstants AlgebraByStructureConstantsArg AlgebraGeneralMappingByImages AlgebraHomomorphismByImages AlgebraHomomorphismByImagesNC AlgebraWithOne AlgebraWithOneByGenerators AlgebraWithOneGeneralMappingByImages AlgebraWithOneHomomorphismByImages AlgebraWithOneHomomorphismByImagesNC AlgebraicElementsFamilies AlgebraicElementsFamily AlgebraicExtension AlgebraicPolynomialModP AllBlocks AllGroups AllIrreducibleMonicPolynomialCoeffsOfDegree AllIrreducibleMonicPolynomials AllIrreducibleSolvableGroups AllLibTomNames AllModulesSQ AllMonicPolynomialCoeffsOfDegree AllPrimitiveGroups AllSmallGroups AllTransitiveGroups AllowableSubgroup Alpha AlternatingDegree AlternatingGroup AlternatingGroupCons AlternatingSubgroup AntiSymmetricParts Append AppendCollectedList AppendTo ApplicableMethod ApplicableMethodTypes Apply ApplyGeneratorsToPoint ApplyGeneratorsToPointsList ApplyRel ApplySimpleReflection ApplyToNodesParseTree ApproxRational ApproxRootBound ApproximateRoot ApproximateSuborbitsStabilizerPermGroup ArithmeticElementCreator Arrangements ArrangementsA ArrangementsK AsAlgebra AsAlgebraWithOne AsBinaryRelationOnPoints AsBlockMatrix AsCharacterMorphismFunction AsDivisionRing AsDuplicateFreeList AsFLMLOR AsFLMLORWithOne AsField AsFreeLeftModule AsGroup AsGroupGeneralMappingByImages AsInducedPcgs AsLeftIdeal AsLeftMagmaIdeal AsLeftModule AsLeftModuleGeneralMappingByImages AsLieAlgebra AsList AsListOfFreeLeftModule AsListSorted AsMagma AsMagmaIdeal AsMonoid AsNearRing AsPerm AsPlist AsPolynomial AsRightIdeal AsRightMagmaIdeal AsRing AsSSortedList AsSSortedListList AsSSortedListNonstored AsSemigroup AsSemiring AsSemiringWithOne AsSemiringWithOneAndZero AsSemiringWithZero AsSet AsSortedList AsSubFLMLOR AsSubFLMLORWithOne AsSubalgebra AsSubalgebraWithOne AsSubgroup AsSubgroupOfWholeGroupByQuotient AsSubmagma AsSubmonoid AsSubsemigroup AsSubspace AsTransformation AsTransformationNC AsTwoSidedIdeal AsVectorSpace AscendingChain AscendingChainOp Assert AssertionLevel AssignGeneratorVariables AssignNiceMonomorphismAutomorphismGroup AssocBWorLetRepPow AssocWWorLetRepPow AssocWord AssocWordByLetterRep AssociatedPartition AssociatedReesMatrixSemigroupOfDClass AssociatedSemigroup Associates AtlasIrrationality AttributeMethodByNiceMonomorphism AttributeMethodByNiceMonomorphismCollColl AttributeMethodByNiceMonomorphismCollElm AttributeMethodByNiceMonomorphismElmColl AttributeValueNotSet AugmentationIdeal AugmentedCosetTableInWholeGroup AugmentedCosetTableMtc AugmentedCosetTableMtcInWholeGroup AugmentedCosetTableNormalClosure AugmentedCosetTableNormalClosureInWholeGroup AugmentedCosetTableRrs AugmentedCosetTableRrsInWholeGroup AutoloadPackages AutomorphismDomain AutomorphismGroup AutomorphismGroupAbelianGroup AutomorphismGroupElAbGroup AutomorphismGroupFrattFreeGroup AutomorphismGroupPermGroup AutomorphismGroupSolvableGroup AutomorphismRepresentingGroup AutomorphismsOfTable AvoidedLayers BPolyProd BagStats BarPartitions BaseFixedSpace BaseImage BaseIntMat BaseIntersectionIntMats BaseMat BaseMatDestructive BaseOfBasicImageGroup BaseOfElt BaseOfGroup BaseOrthogonalSpaceMat BasePoint BasePointOfSchreierTransversal BaseShortVectors BaseStabChain BaseSteinitzVectors BasicImageEltRepFamily BasicImageGroup BasicImageGroupElement BasicWreathProductOrdering BasicWreathProductOrderingNC Basis BasisForFreeModuleByNiceBasis BasisNC BasisNullspaceModN BasisOfAlgebraModule BasisOfHomCosetAddMatrixGroup BasisOfHomCosetAddMatrixGroupFnc BasisOfMonomialSpace BasisOfSparseRowSpace BasisOfWeightRepSpace BasisVectors BasisVectorsForMatrixAction BasisWithReplacedLeftModule BaumClausenInfo BaumClausenInfoDebug BeauzamyBound BeauzamyBoundGcd Bell Bernoulli BestQuoInt BestSplittingMatrix BetaSet BiAlgebraModule BiAlgebraModuleByGenerators BilinearFormMat BinaryRelationByElements BinaryRelationByListOfImages BinaryRelationByListOfImagesNC BinaryRelationOnPoints BinaryRelationOnPointsNC BinaryRelationTransformation BindGlobal Binomial BlistList BlistStringDecode BlockMatrix BlockStabilizer Blocks BlocksAttr BlocksInfo BlocksOp BlowUpCocycleSQ BlowUpIsomorphism BlownUpMat BlownUpMatrix BlownUpModule BlownUpVector BombieriNorm BooleanFamily BrauerCharacterValue BrauerTable BrauerTableOp BravaisGroup BravaisSubgroups BravaisSupergroups BuildIsomorphismReesMatrixSemigroupWithMap CIUnivPols COAffineBlocks COComplements COComplementsMain CONextCentral CONextCentralizer CONextCocycles CONextComplements CalcDoubleCosets CalcOrder CallFuncList CallFuncTrapError CanComputeIndex CanComputeIsSubset CanComputeSize CanComputeSizeAnySubgroup CanEasilyCompareElements CanEasilyCompareElementsFamily CanEasilyComputePcgs CanEasilySortElements CanEasilySortElementsFamily CanEasilyTestMembership CanFindGeneratorOfCyclicGroup CanFindNilpotentClassTwoElement CanonicalBasis CanonicalElt CanonicalGenerators CanonicalNiceMonomorphism CanonicalPcElement CanonicalPcgs CanonicalPcgsByGeneratorsWithImages CanonicalPcgsWrtFamilyPcgs CanonicalPcgsWrtHomePcgs CanonicalPcgsWrtSpecialPcgs CanonicalRelator CanonicalRepresentativeDeterminatorOfExternalSet CanonicalRepresentativeOfExternalSet CanonicalRightCosetElement CanonicalSubgroupRepresentativePcGroup CartanMatrix CartanSubalgebra Cartesian CasesCSPG CategoriesOfObject CategoryCollections CategoryFamily CayleyGraphDualSemigroup CayleyGraphSemigroup Cell CellNoPoint CellNoPoints Cells Center CenterOfCharacter CentralCharacter CentralIdempotentsOfAlgebra CentralIdempotentsOfSemiring CentralNormalSeriesByPcgs CentralProductOfMatrixGroups CentralRelations CentralStelClEANSNonsolv CentralStepClEANS CentralStepConjugatingElement CentralStepRatClPGroup Centralizer CentralizerInAssociativeGaussianMatrixAlgebra CentralizerInFiniteDimensionalAlgebra CentralizerInGLnZ CentralizerInParent CentralizerModulo CentralizerNormalCSPG CentralizerNormalTransCSPG CentralizerOp CentralizerOrder CentralizerSizeLimitConsiderFunction CentralizerSolvableGroup CentralizerTransSymmCSPG CentralizerWreath Centre CentreFromSCTable CentreOfCharacter CentrePcGroup ChaNuPol ChainHomomorphicImage ChainStatistics ChainSubgroup ChainSubgroupByDirectProduct ChainSubgroupByHomomorphism ChainSubgroupByPSubgroupOfAbelian ChainSubgroupByProjectionFunction ChainSubgroupBySiftFunction ChainSubgroupByStabiliser ChainSubgroupByStabilizer ChainSubgroupByTrivialSubgroup ChainSubgroupQuotient ChangeStabChain ChangeTypeObj ChangedBaseGroup CharTableAlternating CharTableDoubleCoverAlternating CharTableDoubleCoverSymmetric CharTableSymmetric CharTableWeylB CharTableWeylD CharValueDoubleCoverSymmetric CharValueSymmetric CharValueWeylB CharValueWreathSymmetric Character CharacterDegreePool CharacterDegrees CharacterMorphismGroup CharacterMorphismOrbits CharacterNames CharacterParameters CharacterString CharacterTable CharacterTableDirectProduct CharacterTableDisplayPrintLegendDefault CharacterTableDisplayStringEntryDataDefault CharacterTableDisplayStringEntryDefault CharacterTableFactorGroup CharacterTableFromLibrary CharacterTableHeadOfFactorGroupByFusion CharacterTableIsoclinic CharacterTableOfNormalSubgroup CharacterTableQuaternionic CharacterTableRegular CharacterTableWithSortedCharacters CharacterTableWithSortedClasses CharacterTableWreathSymmetric Characteristic CharacteristicPolynomial CharacteristicPolynomialMatrixNC CharsFamily CheckAndCleanGapDocTree CheckAuto CheckCompletionFiles CheckConsistencyOfDefinitions CheckCosetTableFpGroup CheckFixedPoints CheckForHandlingByNiceBasis CheckGlobalName CheckPackageLoading CheckPermChar CheckSchreierTreeInternalConsistency ChevalleyBasis ChiefNormalSeriesByPcgs ChiefSeries ChiefSeriesOfGroup ChiefSeriesThrough ChiefSeriesUnderAction ChineseRem Chomp ChooseNextBasePoint ClassComparison ClassElementLargeGroup ClassElementLattice ClassElementSmallGroup ClassFunction ClassFunctionSameType ClassMultiplicationCoefficient ClassNames ClassNamesTom ClassNumbersElements ClassOrbit ClassParameters ClassPermutation ClassPositionsOfAgemo ClassPositionsOfCentre ClassPositionsOfDerivedSubgroup ClassPositionsOfDirectProductDecompositions ClassPositionsOfElementaryAbelianSeries ClassPositionsOfFittingSubgroup ClassPositionsOfKernel ClassPositionsOfLowerCentralSeries ClassPositionsOfMaximalNormalSubgroups ClassPositionsOfNormalClosure ClassPositionsOfNormalSubgroup ClassPositionsOfNormalSubgroups ClassPositionsOfSolvableResiduum ClassPositionsOfSupersolvableResiduum ClassPositionsOfUpperCentralSeries ClassRepsPermutedTuples ClassRoots ClassStructureCharTable ClassTypesTom ClassesSolvableGroup CleanedTailPcElement ClearCacheStats ClearCentralRelations ClearDefinitionNC ClearPQuotientStatistics ClearProfile CloseMutableBasis CloseNaturalHomomorphismsPool CloseStream ClosedStreamType ClosureAdditiveGroup ClosureAdditiveMagmaDefault ClosureAdditiveMagmaWithInverses ClosureAlgebra ClosureDivisionRing ClosureField ClosureGroup ClosureGroupAddElm ClosureGroupCompare ClosureGroupDefault ClosureGroupIntest ClosureLeftModule ClosureLeftOperatorRing ClosureMagmaDefault ClosureNearAdditiveGroup ClosureNearAdditiveMagmaWithInverses ClosureRandomPermGroup ClosureRing ClosureSemiring ClosureSubgroup ClosureSubgroupNC CntOp CoKernel CoKernelGensIterator CoKernelGensPermHom CoKernelOfAdditiveGeneralMapping CoKernelOfMultiplicativeGeneralMapping CoSuFp Coboundaries CocGroup Cochain CochainSpace CocycleSQ CocycleToRelVector Cocycles CodeGenerators CodePcGroup CodePcgs CoefficientTaylorSeries Coefficients CoefficientsAndMagmaElements CoefficientsFamily CoefficientsMultiadic CoefficientsOfLaurentPolynomial CoefficientsOfUnivariateLaurentPolynomial CoefficientsOfUnivariatePolynomial CoefficientsOfUnivariateRationalFunction CoefficientsOfVector CoefficientsQadic CoefficientsRing CoeffsCyc CoeffsMod CollFamRangeEqFamElms CollFamSourceEqFamElms CollapsedMat CollectPolycyclic CollectUEALatticeElement CollectWord CollectWordOrFail Collected CollectedPartition CollectedWordSQ CollectionsFamily CollectorSQ ColorPrompt ColumnIndexOfReesMatrixSemigroupElement ColumnIndexOfReesZeroMatrixSemigroupElement ColumnsOfReesMatrixSemigroup ColumnsOfReesZeroMatrixSemigroup Combinations CombinationsA CombinationsK CombinatorialCollector CombinatorialCollectorByGenerators CombinatoricSplit Comm CommutGenImgs CommutativeDiagram CommutatorFactorGroup CommutatorLength CommutatorSubgroup Compacted CompanionMat CompareVersionNumbers CompatibleConjugacyClasses CompatibleConjugacyClassesDefault CompatiblePairs CompileFunc ComplementIntMat ComplementSystem Complementclasses ComplementclassesEA ComplementclassesSolvableNC ComplementclassesSolvableWBG CompleteChain CompleteGaloisGroupPElement CompleteOrdersOfRws CompleteSchreierTransversal CompletionBar ComplexConjugate ComplexificationQuat ComponentsOfTuplesFamily ComposedXMLString CompositionMapping CompositionMaps CompositionOfStraightLinePrograms CompositionSeries Compress ComputeTails ComputedAgemos ComputedAscendingChains ComputedBrauerTables ComputedClassFusions ComputedCyclicExtensionsTom ComputedHallSubgroups ComputedIndicators ComputedIsPNilpotents ComputedIsPSolvableCharacterTables ComputedIsPSolvables ComputedOmegas ComputedPCentralSeriess ComputedPCores ComputedPRumps ComputedPowerMaps ComputedPrimeBlockss ComputedSylowComplements ComputedSylowSubgroups ConcatSubos Concatenation Conductor ConfluentRws Congruences ConjugacyClass ConjugacyClassSubgroups ConjugacyClasses ConjugacyClassesByOrbits ConjugacyClassesByRandomSearch ConjugacyClassesFittingFreeGroup ConjugacyClassesForSmallGroup ConjugacyClassesMaximalSubgroups ConjugacyClassesOfNaturalGroup ConjugacyClassesPerfectSubgroups ConjugacyClassesSubgroups ConjugacyClassesSubwreath ConjugacyClassesTry ConjugacyClassesViaRadical ConjugateDominantWeight ConjugateDominantWeightWithWord ConjugateGroup ConjugateMatrixActionToLinearAction ConjugateMatrixGroupToLinearAction ConjugateMatrixGroupToLinearGroup ConjugateStabChain ConjugateSubgroup ConjugateSubgroups ConjugatedModule Conjugates ConjugatingElement ConjugatorAutomorphism ConjugatorAutomorphismNC ConjugatorInnerAutomorphism ConjugatorIsomorphism ConjugatorOfConjugatorIsomorphism ConnectGroupAndCharacterTable ConsiderKernels ConsiderSmallerPowerMaps ConsiderStructureConstants ConsiderTableAutomorphisms ConstantInBaseRingPol ConstantTimeAccessList ConstituentsCompositionMapping ConstituentsOfCharacter ConstituentsPolynomial ContainedCharacters ContainedDecomposables ContainedMaps ContainedPossibleCharacters ContainedPossibleVirtualCharacters ContainedSpecialVectors ContainedTom ContainingTom ContinuedFractionApproximationOfRoot ContinuedFractionExpansionOfRoot ConvertBasicImageGroupElement ConvertToCharacterTable ConvertToCharacterTableNC ConvertToLibTom ConvertToLibraryCharacterTableNC ConvertToMatrixRep ConvertToMatrixRepNC ConvertToNormalFormMonomialElement ConvertToRangeRep ConvertToSiftGroup ConvertToStringRep ConvertToTableOfMarks ConvertToVectorRep ConvertToVectorRepNC ConwayCandidates ConwayPol ConwayPolynomial CopiedAugmentedCosetTable CopyMappingAttributes CopyOptionsDefaults CopyRel CopyStabChain Core CoreInParent CoreOp CorestEval CorrectConjugacyClass CorrespondingGeneratorsByModuloPcgs CorrespondingPermutations CosetLeadersInner CosetLeadersMatFFE CosetNumber CosetRepAsWord CosetTable CosetTableBySubgroup CosetTableDefaultLimit CosetTableDefaultMaxLimit CosetTableFpHom CosetTableFromGensAndRels CosetTableInWholeGroup CosetTableNormalClosure CosetTableNormalClosureInWholeGroup CosetTableOfFpSemigroup CosetTableStandard CoveringTriplesCharacters CrcFile CreateAllCycleStructures CreateCompletionFiles CreateKnuthBendixRewritingSystem CreateOrderingByLtFunction CreateOrderingByLteqFunction CrystGroupDefaultAction CurrentAssertionLevel CycList Cycle CycleByPosOp CycleIndex CycleIndexOp CycleLength CycleLengthOp CycleLengthPermInt CycleLengths CycleLengthsOp CycleOp CyclePermInt CycleStructureClass CycleStructurePerm CycleStructuresGroup Cycles CyclesOp CyclicExtensionsTom CyclicExtensionsTomOp CyclicGroup CyclicGroupCons CyclicTopExtensions CyclotomicField CyclotomicPol CyclotomicPolynomial Cyclotomics CyclotomicsFamily DMYDay DMYhmsSeconds DTCommutator DTConjugate DTMultiply DTPower DTQuotient DTSolution DataObj DataType DayDMY DaysInMonth DaysInYear DeclareAttribute DeclareAttributeKernel DeclareAttributeSuppCT DeclareAutoPackage DeclareAutoreadableVariables DeclareCategory DeclareCategoryCollections DeclareCategoryFamily DeclareCategoryKernel DeclareComponent DeclareConstructor DeclareConstructorKernel DeclareFilter DeclareGlobalFunction DeclareGlobalVariable DeclareHandlingByNiceBasis DeclareInfoClass DeclareOperation DeclareOperationKernel DeclarePackage DeclarePackageAutoDocumentation DeclarePackageDocumentation DeclareProperty DeclarePropertyKernel DeclarePropertySuppCT DeclareRepresentation DeclareRepresentationKernel DeclareSynonym DeclareSynonymAttr DecodeTree DecodedTreeEntry DecomposeEltIntoPElts DecomposeTensorProduct DecomposedFixedPointVector DecomposedRationalClass Decomposition DecompositionInt DecompositionMatrix DecompositionTypes DecompositionTypesOfGroup Decreased DeepThoughtCollector DeepThoughtCollectorByGenerators DefaultField DefaultFieldByGenerators DefaultFieldOfMatrix DefaultFieldOfMatrixGroup DefaultHashLength DefaultPackageBannerString DefaultRing DefaultRingByGenerators DefaultSparseHashRepType DefaultSparseHashWithIKRepType DefaultStabChainOptions DefectApproximation DefineNewGenerators DefiningPcgs DefiningPolynomial DefiningQuotientHomomorphism Degree DegreeAction DegreeFFE DegreeIndeterminate DegreeNaturalHomomorphismsPool DegreeOfBinaryRelation DegreeOfCharacter DegreeOfLaurentPolynomial DegreeOfMatrixGroup DegreeOfTransformation DegreeOfTransformationSemigroup DegreeOfUnivariateLaurentPolynomial DegreeOperation DegreeOverPrimeField DeleteImage Delta DenominatorCyc DenominatorOfModuloPcgs DenominatorOfRationalFunction DenominatorRat DenseHashTable DenseIntKey DepthOfPcElement DepthOfUpperTriangularMatrix DepthSchreierTrees Derangements DerangementsK Derivations Derivative DerivedLength DerivedSeries DerivedSeriesOfGroup DerivedSubgroup DerivedSubgroupTom DerivedSubgroupsTom DerivedSubgroupsTomPossible DerivedSubgroupsTomUnique DescendingListWithElementRemoved DescriptionOfNormalizedUEAElement DescriptionOfRootOfUnity Determinant DeterminantIntMat DeterminantMat DeterminantMatDestructive DeterminantMatDivFree DeterminantOfCharacter DiagonalMat DiagonalOfMat DiagonalSocleAction DiagonalizeIntMat DiagonalizeIntMatNormDriven DiagonalizeMat DictionariesFamily DictionaryByList DictionaryByPosition DictionaryBySort DiffCoc Difference DifferenceBlist DifferenceLists DifferenceOfPcElement DigitsNumber DihedralGenerators DihedralGroup DihedralGroupCons Dimension DimensionOfHighestWeightModule DimensionOfMatrixGroup DimensionOfVectors DimensionsLoewyFactors DimensionsMat DirProdTransversal DirectFactorsOfGroup DirectProduct DirectProductDecompositionsLocal DirectProductInfo DirectProductOp DirectSumDecomposition DirectSumMat DirectSumOfAlgebraModules DirectSumOfAlgebras DirectoriesFamily DirectoriesLibrary DirectoriesPackageLibrary DirectoriesPackagePrograms DirectoriesSystemPrograms Directory DirectoryContents DirectoryCurrent DirectoryTemporary DirectoryType DisableAttributeValueStoring Discriminant Display DisplayCacheStats DisplayCompositionSeries DisplayEggBoxOfDClass DisplayImfInvariants DisplayImfReps DisplayInformationPerfectGroups DisplayOptions DisplayOptionsStack DisplayProfile DisplayRevision DisplaySemigroup DisplayXMLStructure DistVecClosVecLib DistanceVecFFE DistancesDistributionMatFFEVecFFE DistancesDistributionVecFFEsVecFFE DivisionRingByGenerators DivisorsInt DivisorsIntCache DixonInit DixonRecord DixonRepChi DixonRepGHchi DixonSplit DixontinI DnLattice DnLatticeIterative DoAlgebraicExt DoCentralSeriesPcgsIfNilpot DoCheapActionImages DoCheapOperationImages DoClosurePrmGp DoEASLS DoExponentsConjLayerFampcgs DoFactorCosetAction DoGaloisType DoImmutableMatrix DoInducedPcgsByPcSequenceNC DoLogModRho DoLowIndexSubgroupsFpGroup DoMulExt DoNFIM DoNormalClosurePermGroup DoNormalizerSA DoPcgsElementaryAbelianSeries DoPcgsOrbitOp DoPrintUnivariateLaurent DoReadPkg DoRereadPkg DoRightTransversalPc DoShortwordBasepoint DoSnAnGiantTest DoSparseActionHomomorphism DoSparseLinearActionOnFaithfulSubset DoTest DoUnivTestRatfun Domain DomainByGenerators DomainForAction DominantCharacter DominantWeights DoubleCentralizerOrbit DoubleCoset DoubleCosetRepsAndSizes DoubleCosets DoubleCosetsNC DoubleCosetsPcGroup DoubleHashArraySize DoubleHashDictSize DownEnv DualGModule DumpWorkspace DuplicateFreeList DxActiveCols DxCalcAllPowerMaps DxCalcPrimeClasses DxDegreeCandidates DxEigenbase DxFrobSchurInd DxGaloisOrbits DxGeneratePrimeCyclotomic DxIncludeIrreducibles DxIsInSpace DxLiftCharacter DxLinearCharacters DxModProduct DxModularValuePol DxNiceBasis DxPreparation DxRegisterModularChar DxSplitDegree EANormalSeriesByPcgs EAPrimeLayerSQ ERepAssWorInv ERepAssWorProd ERepLettWord Earns Edit EggBoxOfDClass EichlerTransformation Eigenspaces Eigenvalues EigenvaluesChar Eigenvectors ElementByRws ElementOfFpAlgebra ElementOfFpGroup ElementOfFpMonoid ElementOfFpSemigroup ElementOfMagmaRing ElementOrdersPowerMap ElementProperty ElementTestFunction ElementaryAbelianGroup ElementaryAbelianGroupCons ElementaryAbelianSeries ElementaryAbelianSeriesLargeSteps ElementaryAbelianSubseries ElementaryDivisorsMat ElementaryDivisorsMatDestructive Elements ElementsFamily ElementsStabChain EliminatedWord EliminationOrdering ElmDivRingElm ElmTimesRingElm ElmWPObj ElsymsPowersums Embedding EmptyBinaryRelation EmptyMatrix EmptyRBase EmptyRowVector EmptySCTable EmptyStabChain EmptyTuplesFamily EnableAttributeValueStoring End EndoMappingByTransformation EnumerateIndependentAbelianProducts Enumerator EnumeratorByBasis EnumeratorByFunctions EnumeratorByPcgs EnumeratorOfAdditiveMagma EnumeratorOfGroup EnumeratorOfIdeal EnumeratorOfMagma EnumeratorOfMagmaIdeal EnumeratorOfNormedRowVectors EnumeratorOfPrimeField EnumeratorOfRing EnumeratorOfSemigroupIdeal EnumeratorOfSubset EnumeratorOfTrivialAdditiveMagmaWithZero EnumeratorOfTrivialMagmaWithOne EnumeratorOfTuples EnumeratorOfZmodnZ EnumeratorSorted EnvelopingAlgebra EpiPcByModpcgs EpimorphismNilpotentQuotient EpimorphismNilpotentQuotientOp EpimorphismPGroup EpimorphismQuotientSystem EpimorphismSchurCover EqualBoxedObj EquivalenceClassOfElement EquivalenceClassOfElementNC EquivalenceClassRelation EquivalenceClasses EquivalenceRelationByPairs EquivalenceRelationByPairsNC EquivalenceRelationByPartition EquivalenceRelationByPartitionNC EquivalenceRelationByProperty EquivalenceRelationByRelation EquivalenceRelationPartition EquivalenceType Error ErrorCount EspaceBasePoints EuclideanDegree EuclideanQuotient EuclideanRemainder EulerianFunction EulerianFunctionByTom EvalF EvalFpCoc EvalStraightLineProgElm EvalString EvaluateConsistency EvaluateOverlapANA EvaluateOverlapBAN EvaluateOverlapBNA EvaluateOverlapCBA EvaluateRelation EvaluateRelators EvectBasePoints ExactSizeConsiderFunction ExcludeFromAutoload ExcludedOrders Exec ExecuteProcess ExpPcElmSortedFun Exponent ExponentOfPcElement ExponentOfPowering ExponentSumWord ExponentSums ExponentSyllable ExponentsConjugateLayer ExponentsOfCommutator ExponentsOfConjugate ExponentsOfPcElement ExponentsOfPcElementPermGroup ExponentsOfRelativePower ExportToKernelFinished ExtOrbStabDom ExtRepByTailVector ExtRepDenominatorRatFun ExtRepNumeratorRatFun ExtRepOfObj ExtRepPolynomialRatFun ExtendRepresentation ExtendSchreierTransversal ExtendSchreierTransversalShortCube ExtendSchreierTransversalShortTree ExtendSeriesPermGroup ExtendStabChain ExtendToBasis ExtendedGroup ExtendedIntersectionSumPcgs ExtendedPcgs ExtendedT ExtendedVectors Extension ExtensionNC ExtensionOnBlocks ExtensionRepresentatives ExtensionSQ Extensions ExtensionsOfModule ExteriorPower ExteriorPowerOfAlgebraModule ExternalOrbit ExternalOrbitOp ExternalOrbits ExternalOrbitsStabilizers ExternalSet ExternalSetByFilterConstructor ExternalSetByTypeConstructor ExternalSubset ExternalSubsetOp Extract ExtraspecialGroup ExtraspecialGroupCons FFEFamily FFPFactors FFPOrderKnownDividend FFPPowerModCheck FFPUpperBoundOrder FLMLORByGenerators FLMLORFromFFE FLMLORWithOne FLMLORWithOneByGenerators FMRRemoveZero FactorCosetAction FactorCosetOperation FactorFreeAlgebraByRelators FactorFreeGroupByRelators FactorFreeMonoidByRelations FactorFreeSemigroupByRelations FactorGroup FactorGroupFpGroupByRels FactorGroupNC FactorGroupNormalSubgroupClasses FactorGroupTom FactorSemigroup FactorSemigroupByClosure Factorial Factorization Factors FactorsCommonDegreePol FactorsInt FactorsOfDirectProduct FactorsRho FactorsSquarefree FaithfulModule FamElmEqFamRange FamElmEqFamSource FamMapFamSourceFamRange FamRangeEqFamElm FamRangeNotEqFamElm FamSourceEqFamElm FamSourceNotEqFamElm FamSourceRgtEqFamsLft FamiliesOfGeneralMappingsAndRanges FamiliesOfRows FamilyForOrdering FamilyForRewritingSystem FamilyObj FamilyOfFamilies FamilyOfTypes FamilyPcgs FamilyRange FamilySource FamilyType FastExtSQ Fibonacci FibonacciGroup Field FieldByGenerators FieldExtension FieldOfMatrixGroup FieldOfMatrixList FieldOverItselfByGenerators FileDescriptorOfStream FileString Filename FilterSGMLMarkup Filtered FilteredOp FinIndexCyclicSubgroupGenerator FindActionKernel FindBag FindLayer FindNewReps FindNormalCSPG FindOperationKernel FindRegularNormalCSPG FindWindowId Fingerprint FingerprintFF FingerprintLarge FingerprintMedium FingerprintPerm FingerprintSmall FiniteField First FirstOp FittingSubgroup FixcellPoint Fixcells FixcellsCell FixedPointSpace FixpointCellNo FlagsFamily FlagsObj FlagsType Flat FlatBlockMat FlatHashParams FloatsFamily FlushCaches ForAll ForAllOp ForAny ForAnyOp FormatParagraph FormattedString FpAlgebraByGeneralizedCartanMatrix FpElmComparisonMethod FpElmEqualityMethod FpElmKBRWS FpGroupPcGroupSQ FpGroupPresentation FpGrpMonSmgOfFpGrpMonSmgElement FpLieAlgebraByCartanMatrix FpLieAlgebraEnumeration FpMonoidOfElementOfFpMonoid FpOfModules FpSemigroupOfElementOfFpSemigroup FptoSCAMorphismImageElm FrattiniSubgroup FrattinifactorId FrattinifactorSize FreeAlgebra FreeAlgebraConstructor FreeAlgebraOfFpAlgebra FreeAlgebraWithOne FreeAssociativeAlgebra FreeAssociativeAlgebraWithOne FreeGeneratorsOfFpAlgebra FreeGeneratorsOfFpGroup FreeGeneratorsOfFpMonoid FreeGeneratorsOfFpSemigroup FreeGeneratorsOfWholeGroup FreeGroup FreeGroupOfBasicImageGroup FreeGroupOfElt FreeGroupOfFpGroup FreeLeftModule FreeLieAlgebra FreeMagma FreeMagmaRing FreeMagmaWithOne FreeMonoid FreeMonoidNatHomByGeneratorsNC FreeMonoidOfFpMonoid FreeMonoidOfRewritingSystem FreeSemigroup FreeSemigroupNatHomByGeneratorsNC FreeSemigroupOfFpSemigroup FreeSemigroupOfRewritingSystem FreeStructureOfRewritingSystem FrobeniusAutomorphism FrobeniusAutomorphismI FrobeniusCharacterValue FullMatrixAlgebra FullMatrixAlgebraCentralizer FullMatrixFLMLOR FullMatrixLieAlgebra FullMatrixLieFLMLOR FullMatrixModule FullMatrixSpace FullRowModule FullRowSpace FullSparseRowSpace FullTransformationSemigroup FunctionAction FunctionsFamily FusionCharTableTom FusionConjugacyClasses FusionConjugacyClassesOp FusionRationalClassesPSubgroup FusionsAllowedByRestrictions FusionsOfLibTom FusionsToLibTom FusionsTom GAPDocManualLab GAPInfo GInverses GLDegree GLUnderlyingField GModuleByMats GPartitions GPartitionsEasy GPartitionsGreatestEQ GPartitionsGreatestEQHelper GPartitionsGreatestLE GPartitionsGreatestLEEasy GPartitionsNrParts GPartitionsNrPartsHelper GQuotients GaloisConjugates GaloisCyc GaloisDiffResolvent GaloisField GaloisGroup GaloisMat GaloisSetResolvent GaloisStabilizer GaloisType GapInputPcGroup GapInputSCTable GasmanLimits GasmanMessageStatus GasmanStatistics GaussianIntegers GaussianRationals Gcd GcdCoeffs GcdInt GcdOp GcdRepresentation GcdRepresentationOp Gcdex GeneralLinearGroup GeneralLinearGroupCons GeneralMappingByElements GeneralMappingsFamily GeneralOrthogonalGroup GeneralOrthogonalGroupCons GeneralStepClEANS GeneralStepClEANSNonsolv GeneralUnitaryGroup GeneralUnitaryGroupCons GeneralisedEigenspaces GeneralisedEigenvalues GeneralizedEigenspaces GeneralizedEigenvalues GeneralizedPcgs GeneratingPairsOfLeftMagmaCongruence GeneratingPairsOfMagmaCongruence GeneratingPairsOfRightMagmaCongruence GeneratingPairsOfSemigroupCongruence GeneratingSetIsComplete GeneratorNumberOfQuotient GeneratorOfCyclicGroup GeneratorSyllable GeneratorTranslationAugmentedCosetTable GeneratorsCenterPGroup GeneratorsCentrePGroup GeneratorsListTom GeneratorsOfAdditiveGroup GeneratorsOfAdditiveMagma GeneratorsOfAdditiveMagmaWithInverses GeneratorsOfAdditiveMagmaWithZero GeneratorsOfAlgebra GeneratorsOfAlgebraModule GeneratorsOfAlgebraWithOne GeneratorsOfDivisionRing GeneratorsOfDomain GeneratorsOfEquivalenceRelationPartition GeneratorsOfExtASet GeneratorsOfExtLSet GeneratorsOfExtRSet GeneratorsOfExtUSet GeneratorsOfFLMLOR GeneratorsOfFLMLORWithOne GeneratorsOfField GeneratorsOfGroup GeneratorsOfIdeal GeneratorsOfLayer GeneratorsOfLeftIdeal GeneratorsOfLeftMagmaIdeal GeneratorsOfLeftModule GeneratorsOfLeftOperatorAdditiveGroup GeneratorsOfLeftOperatorRing GeneratorsOfLeftOperatorRingWithOne GeneratorsOfLeftVectorSpace GeneratorsOfMagma GeneratorsOfMagmaIdeal GeneratorsOfMagmaWithInverses GeneratorsOfMagmaWithOne GeneratorsOfMonoid GeneratorsOfNearAdditiveGroup GeneratorsOfNearAdditiveMagma GeneratorsOfNearAdditiveMagmaWithInverses GeneratorsOfNearAdditiveMagmaWithZero GeneratorsOfPresentation GeneratorsOfRightIdeal GeneratorsOfRightMagmaIdeal GeneratorsOfRightModule GeneratorsOfRightOperatorAdditiveGroup GeneratorsOfRing GeneratorsOfRingForIdeal GeneratorsOfRingWithOne GeneratorsOfRws GeneratorsOfSemigroup GeneratorsOfSemiring GeneratorsOfSemiringWithOne GeneratorsOfSemiringWithOneAndZero GeneratorsOfSemiringWithZero GeneratorsOfTwoSidedIdeal GeneratorsOfVectorSpace GeneratorsOverIntersection GeneratorsPrimeResidues GeneratorsSmallest GeneratorsSmallestStab GeneratorsSubgroupsTom GenericFindActionKernel GetChars GetCommutatorNC GetConjugateNC GetDefinitionNC GetETag GetElement GetEnt GetFusionMap GetHashEntry GetHashEntryAtLastIndex GetHashEntryIndex GetMax GetNaturalHomomorphismsPool GetNumRight GetPols GetPowerNC GetSTag GetWord GiveNumbersNIndeterminates GlasbyCover GlasbyIntersection GlasbyShift GlasbyStabilizer GlobalPartitionOfClasses Grading GreensDClassOfElement GreensDClasses GreensDRelation GreensHClassOfElement GreensHClasses GreensHRelation GreensJClassOfElement GreensJClasses GreensJRelation GreensLClassOfElement GreensLClasses GreensLRelation GreensRClassOfElement GreensRClasses GreensRRelation GroebnerBasis GroebnerBasisNC Group GroupByGenerators GroupByMultiplicationTable GroupByNiceMonomorphism GroupByPcgs GroupByPrimeResidues GroupByQuotientSystem GroupByRws GroupByRwsNC GroupFromAdditiveGroup GroupGeneralMappingByImages GroupHClassOfGreensDClass GroupHomomorphismByFunction GroupHomomorphismByImages GroupHomomorphismByImagesNC GroupMethodByNiceMonomorphism GroupMethodByNiceMonomorphismCollColl GroupMethodByNiceMonomorphismCollElm GroupMethodByNiceMonomorphismCollOther GroupOfPcgs GroupOnSubgroupsOrbit GroupRing GroupSeriesMethodByNiceMonomorphism GroupSeriesMethodByNiceMonomorphismCollColl GroupSeriesMethodByNiceMonomorphismCollElm GroupSeriesMethodByNiceMonomorphismCollOther GroupStabChain GroupString GroupToAdditiveGroupHomomorphismByFunction GroupWithGenerators HMSMSec HallSubgroup HallSubgroupOp HallSystem HasANonReesCongruenceOfSemigroup HasAbelianFactorGroup HasAbelianInvariants HasAbelianInvariantsOfList HasAbsoluteValue HasActingDomain HasActionHomomorphismAttr HasActionKernelExternalSet HasActorOfExternalSet HasAdditiveElementAsMultiplicativeElement HasAdditiveElementsAsMultiplicativeElementsFamily HasAdditiveInverse HasAdditiveInverseAttr HasAdditiveInverseImmutable HasAdditiveNeutralElement HasAdditivelyActingDomain HasAdjointBasis HasAdjointModule HasAlgebraicElementsFamilies HasAllBlocks HasAlpha HasAlternatingDegree HasAlternatingSubgroup HasAsDuplicateFreeList HasAsGroup HasAsGroupGeneralMappingByImages HasAsLeftModuleGeneralMappingByImages HasAsList HasAsMagma HasAsMonoid HasAsNearRing HasAsPolynomial HasAsRing HasAsSSortedList HasAsSemigroup HasAsSemiring HasAsSemiringWithOne HasAsSemiringWithOneAndZero HasAsSemiringWithZero HasAsSortedList HasAsSubgroupOfWholeGroupByQuotient HasAssociatedReesMatrixSemigroupOfDClass HasAssociatedSemigroup HasAugmentationIdeal HasAugmentedCosetTableMtcInWholeGroup HasAugmentedCosetTableNormalClosureInWholeGroup HasAugmentedCosetTableRrsInWholeGroup HasAutomorphismDomain HasAutomorphismGroup HasAutomorphismsOfTable HasBaseIntMat HasBaseMat HasBaseOfBasicImageGroup HasBaseOfGroup HasBaseOrthogonalSpaceMat HasBasis HasBasisOfHomCosetAddMatrixGroup HasBasisVectors HasBaumClausenInfo HasBilinearFormMat HasBlocksAttr HasBlocksInfo HasBrauerCharacterValue HasBravaisGroup HasBravaisSubgroups HasBravaisSupergroups HasCanEasilyCompareElements HasCanEasilySortElements HasCanFindNilpotentClassTwoElement HasCanonicalBasis HasCanonicalElt HasCanonicalGenerators HasCanonicalNiceMonomorphism HasCanonicalPcgs HasCanonicalPcgsWrtFamilyPcgs HasCanonicalPcgsWrtHomePcgs HasCanonicalPcgsWrtSpecialPcgs HasCanonicalRepresentativeDeterminatorOfExternalSet HasCanonicalRepresentativeOfExternalSet HasCartanMatrix HasCartanSubalgebra HasCayleyGraphDualSemigroup HasCayleyGraphSemigroup HasCenter HasCentralCharacter HasCentralIdempotentsOfSemiring HasCentralNormalSeriesByPcgs HasCentralizerInGLnZ HasCentralizerInParent HasCentre HasCentreOfCharacter HasChainHomomorphicImage HasChainSubgroup HasChainSubgroupQuotient HasCharacterDegrees HasCharacterNames HasCharacterParameters HasCharacteristic HasCharacteristicPolynomial HasChevalleyBasis HasChiefNormalSeriesByPcgs HasChiefSeries HasClassNames HasClassNamesTom HasClassParameters HasClassPermutation HasClassPositionsOfCentre HasClassPositionsOfDerivedSubgroup HasClassPositionsOfDirectProductDecompositions HasClassPositionsOfElementaryAbelianSeries HasClassPositionsOfFittingSubgroup HasClassPositionsOfKernel HasClassPositionsOfLowerCentralSeries HasClassPositionsOfMaximalNormalSubgroups HasClassPositionsOfNormalSubgroups HasClassPositionsOfSolvableResiduum HasClassPositionsOfSupersolvableResiduum HasClassPositionsOfUpperCentralSeries HasClassRoots HasClassTypesTom HasCoKernelOfAdditiveGeneralMapping HasCoKernelOfMultiplicativeGeneralMapping HasCoefficientsAndMagmaElements HasCoefficientsFamily HasCoefficientsOfLaurentPolynomial HasCoefficientsOfUnivariatePolynomial HasCoefficientsOfUnivariateRationalFunction HasCoefficientsRing HasCollectionsFamily HasColumnIndexOfReesMatrixSemigroupElement HasColumnIndexOfReesZeroMatrixSemigroupElement HasColumnsOfReesMatrixSemigroup HasColumnsOfReesZeroMatrixSemigroup HasCommutatorFactorGroup HasCommutatorLength HasComplementSystem HasComplexConjugate HasComponentsOfTuplesFamily HasCompositionSeries HasComputedAgemos HasComputedAscendingChains HasComputedBrauerTables HasComputedClassFusions HasComputedCyclicExtensionsTom HasComputedHallSubgroups HasComputedIndicators HasComputedIsPNilpotents HasComputedIsPSolvableCharacterTables HasComputedIsPSolvables HasComputedOmegas HasComputedPCentralSeriess HasComputedPCores HasComputedPRumps HasComputedPowerMaps HasComputedPrimeBlockss HasComputedSylowComplements HasComputedSylowSubgroups HasConductor HasConfluentRws HasConjugacyClasses HasConjugacyClassesMaximalSubgroups HasConjugacyClassesPerfectSubgroups HasConjugacyClassesSubgroups HasConjugates HasConjugatorInnerAutomorphism HasConjugatorOfConjugatorIsomorphism HasConstantTimeAccessList HasConstituentsOfCharacter HasConvertBasicImageGroupElement HasCoreInParent HasCosetTableFpHom HasCosetTableInWholeGroup HasCosetTableNormalClosureInWholeGroup HasCosetTableOfFpSemigroup HasCycleStructurePerm HasCyclicExtensionsTom HasDecompositionMatrix HasDecompositionTypesOfGroup HasDefaultFieldOfMatrix HasDefaultFieldOfMatrixGroup HasDefectApproximation HasDefiningPcgs HasDefiningPolynomial HasDegreeAction HasDegreeOfBinaryRelation HasDegreeOfCharacter HasDegreeOfLaurentPolynomial HasDegreeOfMatrixGroup HasDegreeOfTransformation HasDegreeOfTransformationSemigroup HasDegreeOperation HasDegreeOverPrimeField HasDelta HasDenominatorOfModuloPcgs HasDenominatorOfRationalFunction HasDepthOfUpperTriangularMatrix HasDerivations HasDerivative HasDerivedLength HasDerivedSeriesOfGroup HasDerivedSubgroup HasDerivedSubgroupsTomPossible HasDerivedSubgroupsTomUnique HasDeterminantMat HasDeterminantOfCharacter HasDihedralGenerators HasDimension HasDimensionOfMatrixGroup HasDimensionOfVectors HasDimensionsLoewyFactors HasDimensionsMat HasDirectFactorsOfGroup HasDirectProductInfo HasDirectSumDecomposition HasDisplayOptions HasDixonRecord HasEANormalSeriesByPcgs HasEarns HasEggBoxOfDClass HasElementTestFunction HasElementaryAbelianFactorGroup HasElementaryAbelianSeries HasElementaryAbelianSeriesLargeSteps HasElementaryAbelianSubseries HasElementsFamily HasEmptyRowVector HasEnumerator HasEnumeratorByBasis HasEnumeratorSorted HasEquivalenceClassRelation HasEquivalenceClasses HasEquivalenceRelationPartition HasExponent HasExponentOfPowering HasExtRepDenominatorRatFun HasExtRepNumeratorRatFun HasExtRepPolynomialRatFun HasExternalOrbits HasExternalOrbitsStabilizers HasExternalSet HasFactorsOfDirectProduct HasFaithfulModule HasFamiliesOfGeneralMappingsAndRanges HasFamilyForOrdering HasFamilyForRewritingSystem HasFamilyPcgs HasFamilyRange HasFamilySource HasFieldOfMatrixGroup HasFittingSubgroup HasFpElmComparisonMethod HasFpElmEqualityMethod HasFpElmKBRWS HasFrattiniSubgroup HasFrattinifactorId HasFrattinifactorSize HasFreeAlgebraOfFpAlgebra HasFreeGeneratorsOfFpAlgebra HasFreeGeneratorsOfFpGroup HasFreeGeneratorsOfFpMonoid HasFreeGeneratorsOfFpSemigroup HasFreeGroupOfBasicImageGroup HasFreeGroupOfFpGroup HasFreeMonoidOfFpMonoid HasFreeMonoidOfRewritingSystem HasFreeSemigroupOfFpSemigroup HasFreeSemigroupOfRewritingSystem HasFrobeniusAutomorphism HasFunctionAction HasFusionConjugacyClassesOp HasFusionsOfLibTom HasFusionsToLibTom HasFusionsTom HasGLDegree HasGLUnderlyingField HasGaloisGroup HasGaloisMat HasGaloisStabilizer HasGaloisType HasGeneralizedPcgs HasGeneratingPairsOfLeftMagmaCongruence HasGeneratingPairsOfMagmaCongruence HasGeneratingPairsOfRightMagmaCongruence HasGeneratingSetIsComplete HasGeneratorOfCyclicGroup HasGeneratorsOfAdditiveGroup HasGeneratorsOfAdditiveMagma HasGeneratorsOfAdditiveMagmaWithInverses HasGeneratorsOfAdditiveMagmaWithZero HasGeneratorsOfAlgebra HasGeneratorsOfAlgebraModule HasGeneratorsOfAlgebraWithOne HasGeneratorsOfDivisionRing HasGeneratorsOfDomain HasGeneratorsOfEquivalenceRelationPartition HasGeneratorsOfExtASet HasGeneratorsOfExtLSet HasGeneratorsOfExtRSet HasGeneratorsOfExtUSet HasGeneratorsOfFLMLOR HasGeneratorsOfFLMLORWithOne HasGeneratorsOfField HasGeneratorsOfGroup HasGeneratorsOfIdeal HasGeneratorsOfLeftIdeal HasGeneratorsOfLeftMagmaIdeal HasGeneratorsOfLeftModule HasGeneratorsOfLeftOperatorAdditiveGroup HasGeneratorsOfLeftOperatorRing HasGeneratorsOfLeftOperatorRingWithOne HasGeneratorsOfLeftVectorSpace HasGeneratorsOfMagma HasGeneratorsOfMagmaIdeal HasGeneratorsOfMagmaWithInverses HasGeneratorsOfMagmaWithOne HasGeneratorsOfMonoid HasGeneratorsOfNearAdditiveGroup HasGeneratorsOfNearAdditiveMagma HasGeneratorsOfNearAdditiveMagmaWithInverses HasGeneratorsOfNearAdditiveMagmaWithZero HasGeneratorsOfRightIdeal HasGeneratorsOfRightMagmaIdeal HasGeneratorsOfRightModule HasGeneratorsOfRightOperatorAdditiveGroup HasGeneratorsOfRing HasGeneratorsOfRingWithOne HasGeneratorsOfRws HasGeneratorsOfSemigroup HasGeneratorsOfSemiring HasGeneratorsOfSemiringWithOne HasGeneratorsOfSemiringWithOneAndZero HasGeneratorsOfSemiringWithZero HasGeneratorsOfTwoSidedIdeal HasGeneratorsOfVectorSpace HasGeneratorsSmallest HasGeneratorsSubgroupsTom HasGlobalPartitionOfClasses HasGrading HasGreensDRelation HasGreensHRelation HasGreensJRelation HasGreensLRelation HasGreensRRelation HasGroupByPcgs HasGroupHClassOfGreensDClass HasGroupOfPcgs HasHallSystem HasHirschLength HasHomCosetFamily HasHomFromFreeOfBasicImageGroup HasHomeEnumerator HasHomePcgs HasIBr HasIdGroup HasIdempotents HasIdempotentsTom HasIdempotentsTomInfo HasIdentificationOfConjugacyClasses HasIdentifier HasIdentity HasIdentityMapping HasImageElt HasImageListOfTransformation HasImageSetOfTransformation HasImagesSmallestGenerators HasImagesSource HasImfRecord HasIndependentGeneratorsOfAbelianGroup HasIndependentGeneratorsOfAbelianMatrixGroup HasIndeterminateName HasIndeterminateNumberOfLaurentPolynomial HasIndeterminateNumberOfUnivariateLaurentPolynomial HasIndeterminateNumberOfUnivariateRationalFunction HasIndeterminateOfUnivariateRationalFunction HasIndeterminatesOfPolynomialRing HasIndexInParent HasIndexInWholeGroup HasIndicesCentralNormalSteps HasIndicesChiefNormalSteps HasIndicesEANormalSteps HasIndicesInvolutaryGenerators HasIndicesNormalSteps HasIndicesOfAdjointBasis HasIndicesPCentralNormalStepsPGroup HasInducedPcgsWrtFamilyPcgs HasInducedPcgsWrtHomePcgs HasInducedPcgsWrtSpecialPcgs HasInfoText HasInjectionZeroMagma HasInnerAutomorphismsAutomorphismGroup HasInt HasInternalRepresentative HasInvariantBilinearForm HasInvariantConjugateSubgroup HasInvariantForm HasInvariantLattice HasInvariantQuadraticForm HasInvariantSesquilinearForm HasInverse HasInverseAttr HasInverseClasses HasInverseGeneralMapping HasInverseImmutable HasIrr HasIrrBaumClausen HasIrrConlon HasIrrDixonSchneider HasIrrFacsPol HasIrreducibleRepresentations HasIsAbelian HasIsAbelianNumberField HasIsAbelianTom HasIsAdditiveGroupGeneralMapping HasIsAdditiveGroupHomomorphism HasIsAdditiveGroupToGroupGeneralMapping HasIsAdditiveGroupToGroupHomomorphism HasIsAdditivelyCommutative HasIsAlgebraGeneralMapping HasIsAlgebraHomomorphism HasIsAlgebraModule HasIsAlgebraWithOneGeneralMapping HasIsAlgebraWithOneHomomorphism HasIsAlternatingGroup HasIsAnticommutative HasIsAntisymmetricBinaryRelation HasIsAssociative HasIsAutomorphismGroup HasIsBasicWreathProductOrdering HasIsBergerCondition HasIsBijective HasIsBravaisGroup HasIsBuiltFromAdditiveMagmaWithInverses HasIsBuiltFromGroup HasIsBuiltFromMagma HasIsBuiltFromMagmaWithInverses HasIsBuiltFromMagmaWithOne HasIsBuiltFromMonoid HasIsBuiltFromSemigroup HasIsCanonicalBasis HasIsCanonicalBasisFullMatrixModule HasIsCanonicalBasisFullRowModule HasIsCanonicalBasisFullSCAlgebra HasIsCanonicalNiceMonomorphism HasIsCanonicalPcgs HasIsCanonicalPcgsWrtSpecialPcgs HasIsChainTypeGroup HasIsCharacter HasIsCharacteristicMatrixPGroup HasIsCommutative HasIsCommutativeFamily HasIsConfluent HasIsConjugatorAutomorphism HasIsConjugatorIsomorphism HasIsConstantRationalFunction HasIsConstantTimeAccessGeneralMapping HasIsCycInt HasIsCyclic HasIsCyclicTom HasIsCyclotomicField HasIsDihedralGroup HasIsDistributive HasIsDivisionRing HasIsDuplicateFree HasIsDuplicateFreeList HasIsElementaryAbelian HasIsEmpty HasIsEndoGeneralMapping HasIsEndoMapping HasIsEquivalenceRelation HasIsFFEMatrixGroupOverLargeSpace HasIsFamilyPcgs HasIsField HasIsFieldHomomorphism HasIsFinite HasIsFiniteDimensional HasIsFiniteOrdersPcgs HasIsFiniteSemigroupGreensRelation HasIsFinitelyGeneratedGroup HasIsFrattiniFree HasIsFreeMonoid HasIsFreeSemigroup HasIsFullFpAlgebra HasIsFullHomModule HasIsFullMatrixModule HasIsFullRowModule HasIsFullSCAlgebra HasIsFullSubgroupGLorSLRespectingBilinearForm HasIsFullSubgroupGLorSLRespectingQuadraticForm HasIsFullSubgroupGLorSLRespectingSesquilinearForm HasIsFullTransformationSemigroup HasIsGL HasIsGeneralLinearGroup HasIsGeneralizedCartanMatrix HasIsGeneratorsOfMagmaWithInverses HasIsGreensClass HasIsGreensDClass HasIsGreensDRelation HasIsGreensHClass HasIsGreensHRelation HasIsGreensJClass HasIsGreensJRelation HasIsGreensLClass HasIsGreensLRelation HasIsGreensRClass HasIsGreensRRelation HasIsGreensRelation HasIsGroupGeneralMapping HasIsGroupHClass HasIsGroupHomomorphism HasIsGroupOfAutomorphisms HasIsGroupOfAutomorphismsFiniteGroup HasIsGroupRing HasIsGroupToAdditiveGroupGeneralMapping HasIsGroupToAdditiveGroupHomomorphism HasIsHandledByNiceMonomorphism HasIsHasseDiagram HasIsHomCosetOfAdditiveElt HasIsHomCosetOfFp HasIsHomCosetOfMatrix HasIsHomCosetOfPerm HasIsHomCosetOfTuple HasIsIdealInParent HasIsIdempotent HasIsImpossible HasIsInducedFromNormalSubgroup HasIsInducedPcgsWrtSpecialPcgs HasIsInjective HasIsInnerAutomorphism HasIsIntegerMatrixGroup HasIsIntegralBasis HasIsIntegralCyclotomic HasIsIntegralRing HasIsIrreducibleCharacter HasIsJacobianRing HasIsLDistributive HasIsLatticeOrderBinaryRelation HasIsLaurentPolynomial HasIsLeftActedOnByDivisionRing HasIsLeftAlgebraModule HasIsLeftIdealInParent HasIsLeftModuleGeneralMapping HasIsLeftModuleHomomorphism HasIsLeftSemigroupCongruence HasIsLeftSemigroupIdeal HasIsLieAbelian HasIsLieAlgebra HasIsLieNilpotent HasIsLieSolvable HasIsLinearlyPrimitive HasIsMagmaHomomorphism HasIsMapping HasIsMatrixModule HasIsMinimalNonmonomial HasIsMonoid HasIsMonomialCharacter HasIsMonomialCharacterTable HasIsMonomialGroup HasIsMonomialMatrix HasIsMonomialNumber HasIsNaturalAlternatingGroup HasIsNaturalGL HasIsNaturalSL HasIsNaturalSymmetricGroup HasIsNearRing HasIsNearRingWithOne HasIsNilpQuotientSystem HasIsNilpotentCharacterTable HasIsNilpotentGroup HasIsNilpotentTom HasIsNonTrivial HasIsNoncharacteristicMatrixPGroup HasIsNormalBasis HasIsNormalForm HasIsNormalInParent HasIsNumberField HasIsNumeratorParentPcgsFamilyPcgs HasIsOne HasIsOrderingOnFamilyOfAssocWords HasIsPGroup HasIsPQuotientSystem HasIsPSL HasIsParentPcgsFamilyPcgs HasIsPartialOrderBinaryRelation HasIsPcgsCentralSeries HasIsPcgsChiefSeries HasIsPcgsElementaryAbelianSeries HasIsPcgsPCentralSeriesPGroup HasIsPerfectCharacterTable HasIsPerfectGroup HasIsPerfectTom HasIsPolycyclicGroup HasIsPolynomial HasIsPositionsList HasIsPreOrderBinaryRelation HasIsPrimeField HasIsPrimeOrdersPcgs HasIsPrimitive HasIsPrimitiveAffine HasIsPrimitiveCharacter HasIsPrimitiveMatrixGroup HasIsPseudoCanonicalBasisFullHomModule HasIsQuasiDihedralGroup HasIsQuasiPrimitive HasIsQuaternionGroup HasIsRDistributive HasIsRationalMatrixGroup HasIsRectangularTable HasIsReduced HasIsReesCongruence HasIsReesCongruenceSemigroup HasIsReesMatrixSemigroup HasIsReesZeroMatrixSemigroup HasIsReflexiveBinaryRelation HasIsRegular HasIsRegularDClass HasIsRegularSemigroup HasIsRelativelySM HasIsRestrictedLieAlgebra HasIsRightAlgebraModule HasIsRightIdealInParent HasIsRightSemigroupCongruence HasIsRightSemigroupIdeal HasIsRing HasIsRingGeneralMapping HasIsRingHomomorphism HasIsRingWithOne HasIsRingWithOneGeneralMapping HasIsRingWithOneHomomorphism HasIsRowModule HasIsSL HasIsSSortedList HasIsSemiEchelonized HasIsSemiRegular HasIsSemigroup HasIsSemigroupCongruence HasIsSemigroupIdeal HasIsSemiring HasIsSemiringWithOne HasIsSemiringWithOneAndZero HasIsSemiringWithZero HasIsShortLexOrdering HasIsSimpleAlgebra HasIsSimpleCharacterTable HasIsSimpleGroup HasIsSimpleSemigroup HasIsSingleValued HasIsSkewFieldFamily HasIsSmallList HasIsSolvableCharacterTable HasIsSolvableGroup HasIsSolvableTom HasIsSortedList HasIsSpecialLinearGroup HasIsSpecialPcgs HasIsSporadicSimpleCharacterTable HasIsSporadicSimpleGroup HasIsStabChainViaChainSubgroup HasIsSubgroupSL HasIsSubmonoidFpMonoid HasIsSubnormallyMonomial HasIsSubsemigroupFpSemigroup HasIsSubsemigroupReesMatrixSemigroup HasIsSubsemigroupReesZeroMatrixSemigroup HasIsSubsetLocallyFiniteGroup HasIsSupersolvableCharacterTable HasIsSupersolvableGroup HasIsSurjective HasIsSymmetricBinaryRelation HasIsSymmetricGroup HasIsTotal HasIsTotalOrdering HasIsTransformationMonoid HasIsTransformationSemigroup HasIsTransitive HasIsTransitiveBinaryRelation HasIsTranslationInvariantOrdering HasIsTrivial HasIsTwoSidedIdealInParent HasIsUFDFamily HasIsUniformMatrixGroup HasIsUnivariatePolynomial HasIsUnivariateRationalFunction HasIsVectorSpaceHomomorphism HasIsVirtualCharacter HasIsWeightLexOrdering HasIsWellFoundedOrdering HasIsWeylGroup HasIsWholeFamily HasIsWreathProductOrdering HasIsZero HasIsZeroGroup HasIsZeroMultiplicationRing HasIsZeroRationalFunction HasIsZeroSimpleSemigroup HasIsZeroSquaredRing HasIsomorphismFpAlgebra HasIsomorphismFpFLMLOR HasIsomorphismFpGroup HasIsomorphismFpMonoid HasIsomorphismFpSemigroup HasIsomorphismMatrixAlgebra HasIsomorphismMatrixFLMLOR HasIsomorphismPcGroup HasIsomorphismPermGroup HasIsomorphismReesMatrixSemigroup HasIsomorphismRefinedPcGroup HasIsomorphismSCAlgebra HasIsomorphismSCFLMLOR HasIsomorphismSimplifiedFpGroup HasIsomorphismSpecialPcGroup HasIsomorphismTransformationSemigroup HasJenningsLieAlgebra HasJenningsSeries HasJordanDecomposition HasKernelOfAdditiveGeneralMapping HasKernelOfCharacter HasKernelOfMultiplicativeGeneralMapping HasKernelOfTransformation HasKillingMatrix HasKnowsHowToDecompose HasLClassOfHClass HasLGFirst HasLGHeads HasLGLayers HasLGLength HasLGTails HasLGWeights HasLargestElementGroup HasLargestMovedPoint HasLargestMovedPointPerm HasLatticeGeneratorsInUEA HasLatticeSubgroups HasLeadCoeffsIGS HasLeftActingAlgebra HasLeftActingDomain HasLeftActingGroup HasLeftActingRingOfIdeal HasLeftDerivations HasLength HasLengthsTom HasLessThanFunction HasLessThanOrEqualFunction HasLetterRepWordsLessFunc HasLevelsOfGenerators HasLeviMalcevDecomposition HasLieAlgebraByDomain HasLieCenter HasLieCentralizerInParent HasLieCentre HasLieDerivedSeries HasLieDerivedSubalgebra HasLieFamily HasLieLowerCentralSeries HasLieNilRadical HasLieNormalizerInParent HasLieObject HasLieSolvableRadical HasLieUpperCentralSeries HasLinearActionBasis HasLinearCharacters HasLinesOfStraightLineProgram HasLongestWeylWordPerm HasLowerCentralSeriesOfGroup HasMagmaGeneratorsOfFamily HasMappingGeneratorsImages HasMappingOfWhichItIsAsGGMBI HasMarksTom HasMatTom HasMatrixByBlockMatrix HasMatrixDimension HasMaximalAbelianQuotient HasMaximalBlocksAttr HasMaximalNormalSubgroups HasMaximalSubgroupClassReps HasMaximalSubgroups HasMaximalSubgroupsLattice HasMaximalSubgroupsTom HasMinimalBlockDimension HasMinimalGeneratingSet HasMinimalNormalSubgroups HasMinimalStabChain HasMinimalSupergroupsLattice HasMinimizedBombieriNorm HasModuleOfExtension HasModulusOfZmodnZObj HasMoebiusTom HasMolienSeriesInfo HasMonoidOfRewritingSystem HasMonomialComparisonFunction HasMonomialExtrepComparisonFun HasMovedPoints HasMultiplicationTable HasMultiplicativeNeutralElement HasMultiplicativeZero HasName HasNameIsomorphismClass HasNamesLibTom HasNamesOfFusionSources HasNaturalCharacter HasNaturalHomomorphismByNormalSubgroupNCInParent HasNaturalHomomorphismsPool HasNegativeRootVectors HasNegativeRoots HasNestingDepthA HasNestingDepthM HasNiceAlgebraMonomorphism HasNiceBasis HasNiceFreeLeftModule HasNiceFreeLeftModuleInfo HasNiceMonomorphism HasNiceNormalFormByExtRepFunction HasNiceObject HasNilpotencyClassOfGroup HasNilpotentClassTwoElement HasNonLieNilpotentElement HasNonNilpotentElement HasNorm HasNormalBase HasNormalClosureInParent HasNormalMaximalSubgroups HasNormalSeriesByPcgs HasNormalSubgroupClassesInfo HasNormalSubgroups HasNormalizerInGLnZ HasNormalizerInGLnZBravaisGroup HasNormalizerInHomePcgs HasNormalizerInParent HasNormalizersTom HasNormedRowVector HasNormedRowVectors HasNormedVectors HasNotifiedFusionsOfLibTom HasNotifiedFusionsToLibTom HasNrConjugacyClasses HasNrInputsOfStraightLineProgram HasNrMovedPoints HasNrMovedPointsPerm HasNrSubsTom HasNrSyllables HasNullAlgebra HasNullspaceIntMat HasNullspaceMat HasNumberGeneratorsOfRws HasNumberSyllables HasNumeratorOfModuloPcgs HasNumeratorOfRationalFunction HasONanScottType HasOccuringVariableIndices HasOmegaAndLowerPCentralSeries HasOmegaSeries HasOne HasOneAttr HasOneImmutable HasOneOfPcgs HasOperatorOfExternalSet HasOrbitGeneratorsOfGroup HasOrbitLengths HasOrbitLengthsDomain HasOrbitStabilizingParentGroup HasOrbits HasOrbitsDomain HasOrder HasOrderingOfRewritingSystem HasOrderingOnGenerators HasOrderingsFamily HasOrdersClassRepresentatives HasOrdersTom HasOrdinaryCharacterTable HasOrthogonalSpaceInFullRowSpace HasPCentralLieAlgebra HasPCentralNormalSeriesByPcgsPGroup HasPClassPGroup HasPSLDegree HasPSLUnderlyingField HasParent HasParentAttr HasParentPcgs HasPartialClosureOfCongruence HasPartialOrderOfHasseDiagram HasPcGroupWithPcgs HasPcSeries HasPcgs HasPcgsCentralSeries HasPcgsChiefSeries HasPcgsElementaryAbelianSeries HasPcgsPCentralSeriesPGroup HasPerfectIdentification HasPerfectResiduum HasPermutationTom HasPositiveRootVectors HasPositiveRoots HasPositiveRootsAsWeights HasPowerS HasPowerSubalgebraSeries HasPreBasis HasPreImagesRange HasPreferredGenerators HasPrefrattiniSubgroup HasPresentation HasPrimaryGeneratorWords HasPrimeField HasPrimePGroup HasPrimePowerComponents HasPrimitiveElement HasPrimitiveIdentification HasPrimitiveRoot HasProjectiveOrder HasPseudoRandomSeed HasPthPowerImages HasQuasiDihedralGenerators HasQuaternionGenerators HasQuotientGroup HasQuotientGroupHom HasQuotientSemigroupCongruence HasQuotientSemigroupHomomorphism HasQuotientSemigroupPreimage HasRClassOfHClass HasRadicalGroup HasRadicalOfAlgebra HasRange HasRankAction HasRankMat HasRankOfTransformation HasRankPGroup HasRat HasRationalClasses HasRationalFunctionsFamily HasRationalizedMat HasRealClasses HasRecNames HasReducedConfluentRewritingSystem HasReesCongruenceOfSemigroupIdeal HasReesZeroMatrixSemigroupElementIsZero HasRefinedPcGroup HasRegularActionHomomorphism HasRelationsOfFpMonoid HasRelationsOfFpSemigroup HasRelativeOrders HasRelatorsOfFpAlgebra HasRelatorsOfFpGroup HasRepresentative HasRepresentativeSmallest HasRepresentativesContainedRightCosets HasRepresentativesMinimalBlocksAttr HasRepresentativesPerfectSubgroups HasRepresentativesSimpleSubgroups HasRespectsAddition HasRespectsAdditiveInverses HasRespectsInverses HasRespectsMultiplication HasRespectsOne HasRespectsScalarMultiplication HasRespectsZero HasRightActingAlgebra HasRightActingDomain HasRightActingGroup HasRightActingRingOfIdeal HasRightDerivations HasRightTransversalInParent HasRootOfDefiningPolynomial HasRootSystem HasRowIndexOfReesMatrixSemigroupElement HasRowIndexOfReesZeroMatrixSemigroupElement HasRowsOfReesMatrixSemigroup HasRowsOfReesZeroMatrixSemigroup HasRules HasSLDegree HasSLUnderlyingField HasSandwichMatrixOfReesMatrixSemigroup HasSandwichMatrixOfReesZeroMatrixSemigroup HasSemiEchelonBasis HasSemiEchelonMat HasSemiEchelonMatTransformation HasSemiSimpleType HasSemidirectFactorsOfGroup HasSemidirectProductInfo HasSemigroupOfRewritingSystem HasSiftFunction HasSiftGroup HasSignPerm HasSimpleSystem HasSimsNo HasSize HasSizesCentralizers HasSizesConjugacyClasses HasSmallGeneratingSet HasSmallestGeneratorPerm HasSmallestMovedPoint HasSmallestMovedPointPerm HasSocle HasSocleComplement HasSocleDimensions HasSocleTypePrimitiveGroup HasSortingPerm HasSource HasSparseCartanMatrix HasSpecialPcgs HasSplittingField HasStabChainImmutable HasStabChainMutable HasStabChainOptions HasStabilizerOfExternalSet HasStandardGeneratorsInfo HasStoredExcludedOrders HasStoredGroebnerBasis HasStraightLineProgElmType HasStraightLineProgramsTom HasString HasStructureConstantsTable HasStructureDescription HasSubdirectProductInfo HasSubfields HasSubnormalSeriesInParent HasSubsTom HasSubspaces HasSubspacesAll HasSuccessors HasSupersolvableResiduum HasSurjectiveActionHomomorphismAttr HasSylowSystem HasSymmetricDegree HasSymmetricParentGroup HasTableOfMarks HasTestMonomial HasTestMonomialQuick HasTestQuasiPrimitive HasTestRelativelySM HasTestSubnormallyMonomial HasTietzeOrigin HasTrace HasTranformsOneIntoZero HasTransformationRepresentation HasTransformsAdditionIntoMultiplication HasTransformsAdditiveInversesIntoInverses HasTransformsInversesIntoAdditiveInverses HasTransformsMultiplicationIntoAddition HasTransformsZeroIntoOne HasTransitiveIdentification HasTransitivity HasTransposedMat HasTransposedMatAttr HasTransposedMatImmutable HasTransposedMatrixGroup HasTransversal HasTriangulizedNullspaceMat HasTrivialCharacter HasTrivialSubFLMLOR HasTrivialSubadditiveMagmaWithZero HasTrivialSubalgebra HasTrivialSubgroup HasTrivialSubmagmaWithOne HasTrivialSubmodule HasTrivialSubmonoid HasTrivialSubnearAdditiveMagmaWithZero HasTrivialSubspace HasTwoClosure HasTzOptions HasTzRules HasUnderlyingCharacterTable HasUnderlyingCharacteristic HasUnderlyingCollection HasUnderlyingElementOfReesMatrixSemigroupElement HasUnderlyingElementOfReesZeroMatrixSemigroupElement HasUnderlyingExternalSet HasUnderlyingFamily HasUnderlyingField HasUnderlyingGeneralMapping HasUnderlyingGroup HasUnderlyingLeftModule HasUnderlyingLieAlgebra HasUnderlyingMagma HasUnderlyingRelation HasUnderlyingSemigroupOfReesMatrixSemigroup HasUnderlyingSemigroupOfReesZeroMatrixSemigroup HasUnderlyingVectorSpace HasUnits HasUniversalEnvelopingAlgebra HasUpperActingDomain HasUpperCentralSeriesOfGroup HasValuesOfClassFunction HasWeightOfGenerators HasWeightsTom HasWeylGroup HasWreathProductInfo HasZClassRepsQClass HasZero HasZeroAttr HasZeroCoefficient HasZeroImmutable HasZuppos HashDictAddDictionary HashFunct HashKeyBag HashKeyEnumerator HashTable HasnpeGL HasnpePSL HasnpeSL HasseDiagramBinaryRelation HeadPcElementByNumber HeadsInfoOfSemiEchelonizedMat HeadsInfoOfSemiEchelonizedMats HenselBound HermiteNormalFormIntegerMat HermiteNormalFormIntegerMatTransform HermiteNormalFormIntegerMatTransforms HeuGcdIntPolsCoeffs HeuGcdIntPolsExtRep HeuristicCancelPolynomialsExtRep HexBlistSetup HexStringBlist HexStringBlistEncode HexStringInt HideGlobalVariables HighestWeightModule HirschLength Hom HomCoset HomCosetFamily HomCosetWithImage HomFromFree HomFromFreeOfBasicImageGroup HomTransversal HomeEnumerator HomePcgs HomomorphicCanonicalPcgs HomomorphicInducedPcgs Homomorphism HomomorphismFactorSemigroup HomomorphismFactorSemigroupByClosure HomomorphismQuotientSemigroup HomomorphismTransformationSemigroup HomomorphismsSeries HumanReadableDefinition IBr IMFList IMFLoad IMFRec IdFunc IdGroup IdSmallGroup Ideal IdealByGenerators IdealByGeneratorsForLieAlgebra IdealNC Idempotents IdempotentsTom IdempotentsTomInfo IdentificationGenericGroup IdentificationOfConjugacyClasses IdentificationPermGroup IdentificationSolvableGroup Identifier IdentifierLetters Identity IdentityBinaryRelation IdentityFromSCTable IdentityMapping IdentityMat IdentityTransformation IdsOfAllGroups IdsOfAllSmallGroups Ignore Image ImageElm ImageElmActionHomomorphism ImageElt ImageGroup ImageInWord ImageKernelBlocksHomomorphism ImageListOfTransformation ImageMat ImageOnAbelianCSPG ImageSetOfTransformation ImageSiftedBaseImage ImageUnderWord Images ImagesElm ImagesListOfBinaryRelation ImagesRepresentative ImagesRepresentativeGMBIByElementsList ImagesSet ImagesSmallestGenerators ImagesSource ImfInvariants ImfMatrixGroup ImfNumberQClasses ImfNumberQQClasses ImfNumberZClasses ImfPositionNumber ImfRecord ImgElmSLP ImgElmSLPNonrecursive ImmediateImplicationsIdentityMapping ImmediateImplicationsZeroMapping Immutable ImmutableBasis ImmutableMatrix ImproveActionDegreeByBlocks ImproveMaps ImproveOperationDegreeByBlocks InParentFOA IncorporateCentralRelations IncreaseCounter IndPcgsWrtSpecFromFamOrHome IndependentGeneratorsAbelianPPermGroup IndependentGeneratorsOfAbelianGroup IndependentGeneratorsOfAbelianMatrixGroup Indeterminate IndeterminateName IndeterminateNumberOfLaurentPolynomial IndeterminateNumberOfUnivariateLaurentPolynomial IndeterminateNumberOfUnivariateRationalFunction IndeterminateOfLaurentPolynomial IndeterminateOfUnivariateRationalFunction Indeterminateness IndeterminatenessInfo IndeterminatesOfPolynomialRing Index IndexCosetTab IndexInParent IndexInWholeGroup IndexNC IndexOp Indicator IndicatorOp IndicesCentralNormalSteps IndicesChiefNormalSteps IndicesEANormalSteps IndicesInvolutaryGenerators IndicesNormalSteps IndicesOfAdjointBasis IndicesPCentralNormalStepsPGroup IndicesStabChain Indirected Induced InducedActionAutGroup InducedActionFactor InducedAutomorphism InducedClassFunction InducedClassFunctions InducedClassFunctionsByFusionMap InducedCyclic InducedGModule InducedLinearAction InducedModule InducedModuleByFieldReduction InducedPcgs InducedPcgsByGenerators InducedPcgsByGeneratorsNC InducedPcgsByGeneratorsWithImages InducedPcgsByPcSequence InducedPcgsByPcSequenceAndGenerators InducedPcgsByPcSequenceNC InducedPcgsWrtFamilyPcgs InducedPcgsWrtHomePcgs InducedPcgsWrtSpecialPcgs InducedRepFpGroup InducedRepresentation InducedRepresentationImagesRepresentative InduciblePairs InductionScheme Inequalities InertiaSubgroup InfiniteListOfGenerators InfiniteListOfNames Inflated Info InfoAction InfoAlgebra InfoAttributes InfoAutGrp InfoBasicImage InfoBckt InfoChain InfoCharacterTable InfoClassFamily InfoClasses InfoCoh InfoCompPairs InfoComplement InfoConfluence InfoCoset InfoData InfoDebug InfoDecision InfoDoPrint InfoExtReps InfoFactor InfoFpGroup InfoGalois InfoGlobal InfoGroebner InfoGroup InfoHash InfoHashTables InfoHomClass InfoIdgroup InfoImf InfoKnuthBendix InfoLattice InfoLevel InfoMatInt InfoMatOrb InfoMatrix InfoMeatAxe InfoMethodSelection InfoMonomial InfoMorph InfoNumtheor InfoOperation InfoOptions InfoOverGr InfoPcGroup InfoPcNormalizer InfoPcSubgroup InfoPerformance InfoPoly InfoPrimeInt InfoQuotientGroup InfoQuotientSystem InfoRSS InfoRandIso InfoSQ InfoSchur InfoSearchTable InfoSpecPcgs InfoTeaching InfoText InfoTiming InfoTom InfoTransversal InfoTuples InfoWarning InfoZLattice InitAbsAndIrredModules InitEpimorphismSQ InitFusion InitPowerMap InitialiseCentralRelations InitializePackagesInfoRecords InitializeSchreierTree Injection InjectionZeroMagma InnerAutomorphism InnerAutomorphismNC InnerAutomorphismsAutomorphismGroup InnerSubdirectProducts InputLogTo InputOutputLocalProcess InputOutputStreamByPtyDefaultType InputTextFile InputTextFileStillOpen InputTextFileType InputTextNone InputTextNoneType InputTextString InputTextStringType InputTextUser Insert InsertElmList InsertTrivialStabilizer InstallAccessToGenerators InstallAtExit InstallAttributeFunction InstallAttributeMethodByGroupGeneralMappingByImages InstallCharReadHookFunc InstallEqMethodForMappingsFromGenerators InstallFactorMaintenance InstallFlushableValue InstallGlobalFunction InstallHandlingByNiceBasis InstallHiddenTrueMethod InstallImmediateMethod InstallIsomorphismMaintenance InstallIsomorphismMaintenanceFunction InstallMethod InstallMonomialOrdering InstallOtherMethod InstallPcgsSeriesFromIndices InstallSubsetMaintenance InstallTrueMethod InstallTrueMethodNewFilter InstallValue InstalledPackageVersion Int IntFFE IntFFESymm IntHexString IntScalarProducts IntVecFFE Integers IntegralizedMat IntegratedStraightLineProgram IntermediateGroup IntermediateSubgroups InternalRepresentative InterpolatedPolynomial IntersectBlist IntersectSet Intersection IntersectionBlist IntersectionNormalClosurePermGroup IntersectionSet IntersectionSumPcgs IntersectionsTom InvariantBilinearForm InvariantElementaryAbelianSeries InvariantForm InvariantLattice InvariantQuadraticForm InvariantSesquilinearForm InvariantSubgroupsElementaryAbelianGroup InvariantSubspaceOrCyclicGroup InvariantSubspaceOrUniformCyclicPGroup Inverse InverseAsWord InverseAttr InverseClasses InverseGeneralMapping InverseImmutable InverseMap InverseMatMod InverseMutable InverseOp InversePcgs InverseRepresentative InverseRepresentativeWord InverseSLPElm InverseSM InverseSameMutability Irr IrrBaumClausen IrrConlon IrrDixonSchneider IrrFacsPol IrredSolGroupList IrredSolJSGens IrreducibleDifferences IrreducibleModules IrreducibleRepresentations IrreducibleRepresentationsByBaumClausen IrreducibleRepresentationsDixon IrreducibleSolvableGroup IrreducibleSolvableGroupMS IsANFAutomorphism IsANFAutomorphismRep IsAbelian IsAbelianNumberField IsAbelianNumberFieldPolynomialRing IsAbelianTom IsActionHomomorphism IsActionHomomorphismAutomGroup IsActionHomomorphismByActors IsActionHomomorphismByBase IsActionHomomorphismSubset IsAdditiveCoset IsAdditiveCosetDefaultRep IsAdditiveElement IsAdditiveElementAsMultiplicativeElementRep IsAdditiveElementCollColl IsAdditiveElementCollCollColl IsAdditiveElementCollection IsAdditiveElementList IsAdditiveElementTable IsAdditiveElementWithInverse IsAdditiveElementWithInverseCollColl IsAdditiveElementWithInverseCollCollColl IsAdditiveElementWithInverseCollection IsAdditiveElementWithInverseList IsAdditiveElementWithInverseTable IsAdditiveElementWithZero IsAdditiveElementWithZeroCollColl IsAdditiveElementWithZeroCollCollColl IsAdditiveElementWithZeroCollection IsAdditiveElementWithZeroList IsAdditiveElementWithZeroTable IsAdditiveGroup IsAdditiveGroupGeneralMapping IsAdditiveGroupHomomorphism IsAdditiveGroupToGroupGeneralMapping IsAdditiveGroupToGroupHomomorphism IsAdditiveMagma IsAdditiveMagmaWithInverses IsAdditiveMagmaWithZero IsAdditivelyCommutative IsAdditivelyCommutativeElement IsAdditivelyCommutativeElementCollColl IsAdditivelyCommutativeElementCollection IsAdditivelyCommutativeElementFamily IsAlgBFRep IsAlgExtRep IsAlgebra IsAlgebraGeneralMapping IsAlgebraGeneralMappingByImagesDefaultRep IsAlgebraHomomorphism IsAlgebraHomomorphismFromFpRep IsAlgebraModule IsAlgebraModuleElement IsAlgebraModuleElementCollection IsAlgebraModuleElementFamily IsAlgebraWithOne IsAlgebraWithOneGeneralMapping IsAlgebraWithOneHomomorphism IsAlgebraicElement IsAlgebraicElementCollColl IsAlgebraicElementCollCollColl IsAlgebraicElementCollection IsAlgebraicElementFamily IsAlgebraicExtension IsAlgebraicExtensionDefaultRep IsAlgebraicExtensionPolynomialRing IsAlphaChar IsAlternatingGroup IsAnticommutative IsAntisymmetricBinaryRelation IsAssocWord IsAssocWordCollection IsAssocWordFamily IsAssocWordWithInverse IsAssocWordWithInverseCollection IsAssocWordWithInverseFamily IsAssocWordWithOne IsAssocWordWithOneCollection IsAssocWordWithOneFamily IsAssociated IsAssociative IsAssociativeAOpDSum IsAssociativeAOpESum IsAssociativeElement IsAssociativeElementCollColl IsAssociativeElementCollection IsAssociativeLOpDProd IsAssociativeLOpEProd IsAssociativeROpDProd IsAssociativeROpEProd IsAssociativeUOpDProd IsAssociativeUOpEProd IsAttributeStoringRep IsAttributeStoringRepFlags IsAutomorphismGroup IsBLetterAssocWordRep IsBLetterWordsFamily IsBasicImageEltRep IsBasicImageEltRepCollection IsBasicImageGroup IsBasicWreathLessThanOrEqual IsBasicWreathProductOrdering IsBasis IsBasisByNiceBasis IsBasisFiniteFieldRep IsBasisOfAlgebraModuleElementSpace IsBasisOfMonomialSpaceRep IsBasisOfSparseRowSpaceRep IsBasisOfWeightRepElementSpace IsBasisWithReplacedLeftModuleRep IsBergerCondition IsBijective IsBinaryRelation IsBinaryRelationDefaultRep IsBinaryRelationOnPointsRep IsBlist IsBlistRep IsBlockMatrixRep IsBlocksHomomorphism IsBlocksOfActionHomomorphism IsBlowUpIsomorphism IsBool IsBound IsBoundElmWPObj IsBoundGlobal IsBracketRep IsBrauerTable IsBravaisGroup IsBuiltFromAdditiveMagmaWithInverses IsBuiltFromGroup IsBuiltFromMagma IsBuiltFromMagmaWithInverses IsBuiltFromMagmaWithOne IsBuiltFromMonoid IsBuiltFromSemigroup IsCanonicalBasis IsCanonicalBasisAbelianNumberFieldRep IsCanonicalBasisAlgebraicExtension IsCanonicalBasisCyclotomicFieldRep IsCanonicalBasisFreeMagmaRingRep IsCanonicalBasisFullMatrixModule IsCanonicalBasisFullRowModule IsCanonicalBasisFullSCAlgebra IsCanonicalBasisGaussianIntegersRep IsCanonicalBasisIntegersRep IsCanonicalBasisRationals IsCanonicalNiceMonomorphism IsCanonicalPcgs IsCanonicalPcgsWrtSpecialPcgs IsCentral IsCentralFromGenerators IsChainTypeGroup IsChar IsCharCollection IsCharacter IsCharacterTable IsCharacterTableInProgress IsCharacteristicMatrixPGroup IsCharacteristicSubgroup IsCheapConwayPolynomial IsClassFunction IsClassFunctionsSpace IsClassFusionOfNormalSubgroup IsClosedStream IsCochain IsCochainCollection IsCochainsSpace IsCocycle IsCoeffsElms IsCollCollsElms IsCollCollsElmsElms IsCollCollsElmsElmsX IsCollLieCollsElms IsCollection IsCollectionFamily IsCollsCollsElms IsCollsCollsElmsX IsCollsCollsElmsXX IsCollsElms IsCollsElmsColls IsCollsElmsElms IsCollsElmsElmsElms IsCollsElmsElmsX IsCollsElmsX IsCollsElmsXElms IsCollsElmsXX IsCollsXElms IsCollsXElmsX IsCombinatorialCollectorRep IsCommutative IsCommutativeElement IsCommutativeElementCollColl IsCommutativeElementCollection IsCommutativeFamily IsCommutativeFromGenerators IsCompatiblePair IsComponentObjectRep IsCompositionMappingRep IsConfluent IsCongruenceClass IsConjugacyClassGroupRep IsConjugacyClassPermGroupRep IsConjugacyClassSubgroupsByStabilizerRep IsConjugacyClassSubgroupsRep IsConjugate IsConjugatorAutomorphism IsConjugatorIsomorphism IsConsistentPolynomial IsConstantRationalFunction IsConstantTimeAccessGeneralMapping IsConstantTimeAccessList IsConstituentHomomorphism IsContainedInSpan IsCopyable IsCyc IsCycInt IsCyclic IsCyclicTom IsCyclotomic IsCyclotomicCollColl IsCyclotomicCollCollColl IsCyclotomicCollection IsCyclotomicField IsCyclotomicMatrixGroup IsDataObjectRep IsDeepThoughtCollectorRep IsDefaultGeneralMappingRep IsDefaultRhsTypeSingleCollector IsDefaultTupleRep IsDenseCoeffVectorRep IsDenseHashRep IsDenseList IsDiagonalMat IsDictionary IsDictionaryDefaultRep IsDigitChar IsDihedralGroup IsDirectSumElement IsDirectSumElementCollection IsDirectSumElementFamily IsDirectSumElementsSpace IsDirectory IsDirectoryPath IsDirectoryRep IsDistributive IsDistributiveLOpDProd IsDistributiveLOpDSum IsDistributiveLOpEProd IsDistributiveLOpESum IsDistributiveROpDProd IsDistributiveROpDSum IsDistributiveROpEProd IsDistributiveROpESum IsDistributiveUOpDProd IsDistributiveUOpDSum IsDistributiveUOpEProd IsDistributiveUOpESum IsDivisionRing IsDocumentedVariable IsDomain IsDoneIterator IsDoubleCoset IsDoubleCosetDefaultRep IsDuplicateFree IsDuplicateFreeCollection IsDuplicateFreeList IsDxLargeGroup IsElementFinitePolycyclicGroup IsElementFinitePolycyclicGroupCollection IsElementOfFpAlgebra IsElementOfFpAlgebraCollection IsElementOfFpAlgebraFamily IsElementOfFpGroup IsElementOfFpGroupCollection IsElementOfFpGroupFamily IsElementOfFpMonoid IsElementOfFpMonoidCollection IsElementOfFpMonoidFamily IsElementOfFpSemigroup IsElementOfFpSemigroupCollection IsElementOfFpSemigroupFamily IsElementOfFreeGroup IsElementOfFreeGroupFamily IsElementOfFreeMagmaRing IsElementOfFreeMagmaRingCollection IsElementOfFreeMagmaRingFamily IsElementOfMagmaRingModuloRelations IsElementOfMagmaRingModuloRelationsCollection IsElementOfMagmaRingModuloRelationsFamily IsElementOfMagmaRingModuloSpanOfZeroFamily IsElementaryAbelian IsElementsFamilyByRws IsElmsCoeffs IsElmsCollColls IsElmsCollCollsX IsElmsCollLieColls IsElmsColls IsElmsCollsX IsElmsCollsXX IsElmsLieColls IsEmbeddingDirectProductPermGroup IsEmbeddingImprimitiveWreathProductPermGroup IsEmbeddingMagmaMagmaRing IsEmbeddingProductActionWreathProductPermGroup IsEmbeddingRingMagmaRing IsEmbeddingWreathProductPermGroup IsEmpty IsEmptyRowVectorRep IsEmptyString IsEndOfStream IsEndoGeneralMapping IsEndoMapping IsEnumeratorByFunctions IsEnumeratorByFunctionsRep IsEnumeratorByPcgsRep IsEqualSet IsEquivalenceClass IsEquivalenceClassDefaultRep IsEquivalenceRelation IsEquivalenceRelationDefaultRep IsEquivalentByFp IsEuclideanRing IsEvenInt IsExecutableFile IsExistingFile IsExtAElement IsExtAElementCollColl IsExtAElementCollection IsExtAElementList IsExtAElementTable IsExtASet IsExtLElement IsExtLElementCollColl IsExtLElementCollection IsExtLElementList IsExtLElementTable IsExtLSet IsExtRElement IsExtRElementCollColl IsExtRElementCollection IsExtRElementList IsExtRElementTable IsExtRSet IsExtUSet IsExtensibleGeneralMapping IsExtensiblePartialMapping IsExternalOrbit IsExternalOrbitByStabilizerRep IsExternalSet IsExternalSetByActorsRep IsExternalSetByOperatorsRep IsExternalSetByPcgs IsExternalSetDefaultRep IsExternalSubset IsFFE IsFFECollColl IsFFECollCollColl IsFFECollection IsFFEFamily IsFFEMatrixGroup IsFFEMatrixGroupOverLargeSpace IsFLMLOR IsFLMLORWithOne IsFamFamFam IsFamFamFamX IsFamFamX IsFamFamXY IsFamLieFam IsFamXFam IsFamXFamY IsFamXYFamZ IsFamily IsFamilyDefaultRep IsFamilyElementOfFreeLieAlgebra IsFamilyOfFamilies IsFamilyOfTypes IsFamilyOverFullCoefficientsFamily IsFamilyPcgs IsField IsFieldControlledByGaloisGroup IsFieldElementsSpace IsFieldHomomorphism IsFilter IsFinite IsFiniteBasisDefault IsFiniteDimensional IsFiniteFieldPolynomialRing IsFiniteOrderElement IsFiniteOrderElementCollColl IsFiniteOrderElementCollection IsFiniteOrdersPcgs IsFiniteSemigroupGreensRelation IsFinitelyGeneratedGroup IsFixedStabilizer IsFlatHashTable IsFlexibleGeneralMapping IsFlexiblePartialMapping IsFpAlgebraElementsSpace IsFpGroup IsFpMonoid IsFpSemigroup IsFptoSCAMorphism IsFrattiniFree IsFreeGroup IsFreeLeftModule IsFreeMagma IsFreeMagmaRing IsFreeMagmaRingWithOne IsFreeMonoid IsFreeSemigroup IsFrobeniusAutomorphism IsFromFpGroupGeneralMapping IsFromFpGroupGeneralMappingByImages IsFromFpGroupHomomorphism IsFromFpGroupHomomorphismByImages IsFromFpGroupStdGensGeneralMappingByImages IsFromFpGroupStdGensHomomorphismByImages IsFullFpAlgebra IsFullHomModule IsFullMatrixModule IsFullRowModule IsFullSCAlgebra IsFullSubgroupGLorSLRespectingBilinearForm IsFullSubgroupGLorSLRespectingQuadraticForm IsFullSubgroupGLorSLRespectingSesquilinearForm IsFullTransformationSemigroup IsFunction IsGL IsGaussInt IsGaussRat IsGaussianIntegers IsGaussianMatrixSpace IsGaussianRationals IsGaussianRowSpace IsGaussianSpace IsGeneralLinearGroup IsGeneralMapping IsGeneralMappingCollection IsGeneralMappingFamily IsGeneralPcgs IsGeneralizedCartanMatrix IsGeneralizedDomain IsGeneralizedRowVector IsGeneratorsOfMagmaWithInverses IsGenericCharacterTableRep IsGenericFiniteSpace IsGreensClass IsGreensDClass IsGreensDRelation IsGreensHClass IsGreensHRelation IsGreensJClass IsGreensJRelation IsGreensLClass IsGreensLRelation IsGreensLessThanOrEqual IsGreensRClass IsGreensRRelation IsGreensRelation IsGroup IsGroupGeneralMapping IsGroupGeneralMappingByAsGroupGeneralMappingByImages IsGroupGeneralMappingByImages IsGroupGeneralMappingByPcgs IsGroupHClass IsGroupHomomorphism IsGroupOfAutomorphisms IsGroupOfAutomorphismsFiniteGroup IsGroupOfFamily IsGroupRing IsGroupToAdditiveGroupGeneralMapping IsGroupToAdditiveGroupHomomorphism IsHandledByNiceBasis IsHandledByNiceMonomorphism IsHash IsHashTable IsHasseDiagram IsHomCoset IsHomCosetCollection IsHomCosetOfAdditiveElt IsHomCosetOfFp IsHomCosetOfMatrix IsHomCosetOfPerm IsHomCosetOfTuple IsHomCosetToAdditiveElt IsHomCosetToAdditiveEltCollection IsHomCosetToAdditiveEltRep IsHomCosetToFp IsHomCosetToFpCollection IsHomCosetToFpRep IsHomCosetToMatrix IsHomCosetToMatrixCollection IsHomCosetToMatrixRep IsHomCosetToObjectRep IsHomCosetToPerm IsHomCosetToPermCollection IsHomCosetToPermRep IsHomCosetToTuple IsHomCosetToTupleCollection IsHomCosetToTupleRep IsHomQuotientGroup IsHomogeneousList IsIdeal IsIdealInParent IsIdealOp IsIdempotent IsIdenticalObj IsIdenticalObjFamiliesColObjObj IsIdenticalObjFamiliesColObjObjObj IsIdenticalObjFamiliesColXXXObj IsIdenticalObjFamiliesColXXXXXXObj IsIdenticalObjFamiliesRwsObj IsIdenticalObjFamiliesRwsObjObj IsIdenticalObjFamiliesRwsObjXXX IsIdenticalObjObjObjX IsIdenticalObjObjXObj IsImfMatrixGroup IsImpossible IsInBasicOrbit IsInCenter IsInCentre IsInChain IsIncomparableUnder IsInducedFromNormalSubgroup IsInducedPcgs IsInducedPcgsRep IsInducedPcgsWrtSpecialPcgs IsInfBitsAssocWord IsInfBitsFamily IsInfiniteListOfGeneratorsRep IsInfiniteListOfNamesRep IsInfinity IsInfoClass IsInfoClassCollection IsInfoClassListRep IsInfoSelector IsInjective IsInnerAutomorphism IsInputOutputStream IsInputOutputStreamByPtyRep IsInputStream IsInputTextFileRep IsInputTextNone IsInputTextNoneRep IsInputTextStream IsInputTextStringRep IsInt IsIntegerMatrixGroup IsIntegers IsIntegralBasis IsIntegralCyclotomic IsIntegralRing IsInternalRep IsInternallyConsistent IsInverseGeneralMappingRep IsIrreducible IsIrreducibleCharacter IsIrreducibleRingElement IsIterator IsIteratorByFunctions IsIteratorByFunctionsRep IsJacobianElement IsJacobianElementCollColl IsJacobianElementCollection IsJacobianRing IsKernelPcWord IsKnuthBendixRewritingSystem IsKnuthBendixRewritingSystemRep IsLDistributive IsLatticeOrderBinaryRelation IsLatticeSubgroupsRep IsLaurentPolynomial IsLaurentPolynomialDefaultRep IsLaurentPolynomialsFamily IsLaurentPolynomialsFamilyElement IsLeftActedOnByDivisionRing IsLeftActedOnByRing IsLeftActedOnBySuperset IsLeftAlgebraModule IsLeftAlgebraModuleElement IsLeftAlgebraModuleElementCollection IsLeftIdeal IsLeftIdealFromGenerators IsLeftIdealInParent IsLeftIdealOp IsLeftMagmaCongruence IsLeftMagmaIdeal IsLeftModule IsLeftModuleGeneralMapping IsLeftModuleHomomorphism IsLeftOperatorAdditiveGroup IsLeftOperatorRing IsLeftOperatorRingWithOne IsLeftSemigroupCongruence IsLeftSemigroupIdeal IsLeftVectorSpace IsLessThanOrEqualUnder IsLessThanUnder IsLetterAssocWordRep IsLetterWordsFamily IsLexicographicallyLess IsLibTomRep IsLibraryCharacterTableRep IsLieAbelian IsLieAlgebra IsLieEmbeddingRep IsLieFamFam IsLieMatrix IsLieNilpotent IsLieNilpotentElement IsLieObject IsLieObjectCollection IsLieObjectsModule IsLieSolvable IsLinearActionHomomorphism IsLinearGeneralMappingByImagesDefaultRep IsLinearMapping IsLinearMappingByMatrixDefaultRep IsLinearMappingsModule IsLinearlyIndependent IsLinearlyPrimitive IsList IsListDefault IsListDictionary IsListHashTable IsListLookupDictionary IsListOrCollection IsLockedRepresentationVector IsLookupDictionary IsLowerAlphaChar IsLowerTriangularMat IsMagma IsMagmaByMultiplicationTableObj IsMagmaCollsMagmaRingColls IsMagmaCongruence IsMagmaHomomorphism IsMagmaIdeal IsMagmaRingModuloRelations IsMagmaRingModuloSpanOfZero IsMagmaRingObjDefaultRep IsMagmaRingsMagmas IsMagmaRingsRings IsMagmaWithInverses IsMagmaWithInversesIfNonzero IsMagmaWithMultiplicativeZeroAdjoinedElementRep IsMagmaWithOne IsMagmasMagmaRings IsMapping IsMappingByFunctionRep IsMappingByFunctionWithInverseRep IsMatchingSublist IsMatrix IsMatrixCollection IsMatrixFLMLOR IsMatrixGroup IsMatrixModule IsMatrixSpace IsMemberPcSeriesPermGroup IsMinimalNonmonomial IsModuloPcgs IsModuloPcgsFpGroupRep IsModuloPcgsPermGroupRep IsModuloPcgsRep IsModuloTailPcgsByListRep IsModuloTailPcgsRep IsModulusRep IsMonoid IsMonomial IsMonomialCharacter IsMonomialCharacterTable IsMonomialElement IsMonomialElementCollection IsMonomialElementFamily IsMonomialElementRep IsMonomialGroup IsMonomialMatrix IsMonomialNumber IsMonomialOrdering IsMonomialOrderingDefaultRep IsMultiplicativeElement IsMultiplicativeElementCollColl IsMultiplicativeElementCollCollColl IsMultiplicativeElementCollection IsMultiplicativeElementList IsMultiplicativeElementTable IsMultiplicativeElementWithInverse IsMultiplicativeElementWithInverseByPolycyclicCollector IsMultiplicativeElementWithInverseByPolycyclicCollectorCollection IsMultiplicativeElementWithInverseByRws IsMultiplicativeElementWithInverseCollColl IsMultiplicativeElementWithInverseCollCollColl IsMultiplicativeElementWithInverseCollection IsMultiplicativeElementWithInverseList IsMultiplicativeElementWithInverseTable IsMultiplicativeElementWithOne IsMultiplicativeElementWithOneCollColl IsMultiplicativeElementWithOneCollCollColl IsMultiplicativeElementWithOneCollection IsMultiplicativeElementWithOneList IsMultiplicativeElementWithOneTable IsMultiplicativeElementWithZero IsMultiplicativeElementWithZeroCollection IsMultiplicativeGeneralizedRowVector IsMultiplicativeZero IsMutable IsMutableBasis IsMutableBasisByImmutableBasisRep IsMutableBasisOfGaussianMatrixSpaceRep IsMutableBasisOfGaussianRowSpaceRep IsMutableBasisViaNiceMutableBasisRep IsMutableBasisViaUnderlyingMutableBasisRep IsNBitsPcWordRep IsNameOfNoninstalledTableOfMarks IsNaturalAlternatingGroup IsNaturalGL IsNaturalGLnZ IsNaturalHomomorphismPcGroupRep IsNaturalSL IsNaturalSLnZ IsNaturalSymmetricGroup IsNearAdditiveElement IsNearAdditiveElementCollColl IsNearAdditiveElementCollCollColl IsNearAdditiveElementCollection IsNearAdditiveElementList IsNearAdditiveElementTable IsNearAdditiveElementWithInverse IsNearAdditiveElementWithInverseCollColl IsNearAdditiveElementWithInverseCollCollColl IsNearAdditiveElementWithInverseCollection IsNearAdditiveElementWithInverseList IsNearAdditiveElementWithInverseTable IsNearAdditiveElementWithZero IsNearAdditiveElementWithZeroCollColl IsNearAdditiveElementWithZeroCollCollColl IsNearAdditiveElementWithZeroCollection IsNearAdditiveElementWithZeroList IsNearAdditiveElementWithZeroTable IsNearAdditiveGroup IsNearAdditiveMagma IsNearAdditiveMagmaWithInverses IsNearAdditiveMagmaWithZero IsNearRing IsNearRingElement IsNearRingElementCollColl IsNearRingElementCollCollColl IsNearRingElementCollection IsNearRingElementFamily IsNearRingElementList IsNearRingElementTable IsNearRingElementWithInverse IsNearRingElementWithInverseCollColl IsNearRingElementWithInverseCollCollColl IsNearRingElementWithInverseCollection IsNearRingElementWithInverseList IsNearRingElementWithInverseTable IsNearRingElementWithOne IsNearRingElementWithOneCollColl IsNearRingElementWithOneCollCollColl IsNearRingElementWithOneCollection IsNearRingElementWithOneList IsNearRingElementWithOneTable IsNearRingWithOne IsNearlyCharacterTable IsNegInt IsNegRat IsNiceMonomorphism IsNilpQuotientSystem IsNilpotent IsNilpotentCharacterTable IsNilpotentElement IsNilpotentGroup IsNilpotentTom IsNoImmediateMethodsObject IsNonGaussianMatrixSpace IsNonGaussianRowSpace IsNonSPGeneralMapping IsNonSPMappingByFunctionRep IsNonSPMappingByFunctionWithInverseRep IsNonTrivial IsNonassocWord IsNonassocWordCollection IsNonassocWordFamily IsNonassocWordWithOne IsNonassocWordWithOneCollection IsNonassocWordWithOneFamily IsNoncharacteristicMatrixPGroup IsNonnegativeIntegers IsNormal IsNormalBasis IsNormalForm IsNormalInParent IsNormalOp IsNotElmsColls IsNotIdenticalObj IsNullMapMatrix IsNumberField IsNumeratorParentForExponentsRep IsNumeratorParentPcgsFamilyPcgs IsObjToBePrinted IsObject IsOddAdditiveNestingDepthFamily IsOddAdditiveNestingDepthObject IsOddInt IsOne IsOperation IsOperationAlgebraHomomorphismDefaultRep IsOrdering IsOrderingOnFamilyOfAssocWords IsOrdinaryMatrix IsOrdinaryMatrixCollection IsOrdinaryTable IsOutputStream IsOutputTextFileRep IsOutputTextNone IsOutputTextNoneRep IsOutputTextStream IsOutputTextStringRep IsPGroup IsPNilpotent IsPNilpotentOp IsPQuotientSystem IsPSL IsPSolvable IsPSolvableCharacterTable IsPSolvableCharacterTableOp IsPSolvableOp IsPackedElementDefaultRep IsPadicExtensionNumber IsPadicExtensionNumberFamily IsPadicNumber IsPadicNumberCollColl IsPadicNumberCollection IsPadicNumberFamily IsPadicNumberList IsPadicNumberTable IsParentPcgsFamilyPcgs IsPartialOrderBinaryRelation IsPartition IsPcGroup IsPcGroupGeneralMappingByImages IsPcGroupHomomorphismByImages IsPcgs IsPcgsCentralSeries IsPcgsChiefSeries IsPcgsDefaultRep IsPcgsElementaryAbelianSeries IsPcgsFamily IsPcgsPCentralSeriesPGroup IsPcgsPermGroupRep IsPcgsToPcgsGeneralMappingByImages IsPcgsToPcgsHomomorphism IsPerfect IsPerfectCharacterTable IsPerfectGroup IsPerfectLibraryGroup IsPerfectTom IsPerm IsPermCollColl IsPermCollection IsPermGroup IsPermGroupGeneralMappingByImages IsPermGroupHomomorphismByImages IsPermOnEnumerator IsPlistRep IsPolycyclicCollector IsPolycyclicGroup IsPolynomial IsPolynomialDefaultRep IsPolynomialFunction IsPolynomialFunctionCollection IsPolynomialFunctionsFamily IsPolynomialFunctionsFamilyElement IsPolynomialRing IsPolynomialRingIdeal IsPosInt IsPosRat IsPositionDictionary IsPositionLookupDictionary IsPositionalObjectRep IsPositionsList IsPositiveIntegers IsPowerCommutatorCollector IsPowerConjugateCollector IsPreOrderBinaryRelation IsPreimagesByAsGroupGeneralMappingByImages IsPresentation IsPresentationDefaultRep IsPrimGrpIterRep IsPrime IsPrimeField IsPrimeInt IsPrimeOrdersPcgs IsPrimePowerInt IsPrimitive IsPrimitiveAffine IsPrimitiveCharacter IsPrimitiveMatrixGroup IsPrimitivePolynomial IsPrimitiveRootMod IsProbablyPrimeInt IsProbablyPrimeIntWithFail IsProjectionDirectProductPermGroup IsProjectionSubdirectProductPermGroup IsPseudoCanonicalBasisFullHomModule IsPurePadicNumber IsPurePadicNumberFamily IsQuasiDihedralGroup IsQuasiPrimitive IsQuaternion IsQuaternionCollColl IsQuaternionCollection IsQuaternionGroup IsQuickPositionList IsQuotientSemigroup IsQuotientSystem IsQuotientToAdditiveGroup IsQuotientToFpGroup IsQuotientToMatrixGroup IsQuotientToPermGroup IsQuotientToTupleGroup IsRDistributive IsRange IsRangeRep IsRat IsRationalClassGroupRep IsRationalClassPermGroupRep IsRationalFunction IsRationalFunctionCollection IsRationalFunctionDefaultRep IsRationalFunctionOverField IsRationalFunctionsFamily IsRationalFunctionsFamilyElement IsRationalMatrixGroup IsRationals IsRationalsPolynomialRing IsReadOnlyGVar IsReadOnlyGlobal IsReadableFile IsRecord IsRecordCollColl IsRecordCollection IsRectangularTable IsRectangularTablePlist IsReduced IsReducedConfluentRewritingSystem IsReducedForm IsReductionOrdering IsReesCongruence IsReesCongruenceSemigroup IsReesMatrixSemigroup IsReesMatrixSemigroupElement IsReesMatrixSemigroupElementCollection IsReesMatrixSemigroupElementRep IsReesZeroMatrixSemigroup IsReesZeroMatrixSemigroupElement IsReesZeroMatrixSemigroupElementCollection IsReflexiveBinaryRelation IsRegular IsRegularDClass IsRegularSemigroup IsRegularSemigroupElement IsRelativeBasisDefaultRep IsRelativelySM IsRestrictedLieAlgebra IsRewritingSystem IsRightActedOnByDivisionRing IsRightActedOnByRing IsRightActedOnBySuperset IsRightAlgebraModule IsRightAlgebraModuleElement IsRightAlgebraModuleElementCollection IsRightCoset IsRightCosetDefaultRep IsRightIdeal IsRightIdealFromGenerators IsRightIdealInParent IsRightIdealOp IsRightMagmaCongruence IsRightMagmaIdeal IsRightModule IsRightOperatorAdditiveGroup IsRightSemigroupCongruence IsRightSemigroupIdeal IsRightTransversal IsRightTransversalCollection IsRightTransversalFpGroupRep IsRightTransversalPcGroupRep IsRightTransversalPermGroupRep IsRightTransversalRep IsRightTransversalViaCosetsRep IsRing IsRingCollsMagmaRingColls IsRingElement IsRingElementCollColl IsRingElementCollCollColl IsRingElementCollection IsRingElementFamily IsRingElementList IsRingElementTable IsRingElementWithInverse IsRingElementWithInverseCollColl IsRingElementWithInverseCollCollColl IsRingElementWithInverseCollection IsRingElementWithInverseList IsRingElementWithInverseTable IsRingElementWithOne IsRingElementWithOneCollColl IsRingElementWithOneCollCollColl IsRingElementWithOneCollection IsRingElementWithOneList IsRingElementWithOneTable IsRingGeneralMapping IsRingHomomorphism IsRingWithOne IsRingWithOneGeneralMapping IsRingWithOneHomomorphism IsRingsMagmaRings IsRootSystem IsRootSystemFromLieAlgebra IsRowModule IsRowSpace IsRowVector IsSCAlgebraObj IsSCAlgebraObjCollColl IsSCAlgebraObjCollCollColl IsSCAlgebraObjCollection IsSCAlgebraObjFamily IsSCAlgebraObjSpace IsSL IsSPGeneralMapping IsSPMappingByFunctionRep IsSPMappingByFunctionWithInverseRep IsSSortedList IsScalar IsScalarCollColl IsScalarCollection IsScalarList IsScalarTable IsSearchTable IsSemiEchelonBasisOfGaussianMatrixSpaceRep IsSemiEchelonBasisOfGaussianRowSpaceRep IsSemiEchelonized IsSemiRegular IsSemigroup IsSemigroupCongruence IsSemigroupIdeal IsSemiring IsSemiringWithOne IsSemiringWithOneAndZero IsSemiringWithZero IsSet IsShortLexLessThanOrEqual IsShortLexOrdering IsSimple IsSimpleAlgebra IsSimpleCharacterTable IsSimpleGroup IsSimpleSemigroup IsSingleCollectorRep IsSingleValued IsSkewFieldFamily IsSlicedPerm IsSlicedPermInv IsSmallIntRep IsSmallList IsSolvable IsSolvableCharacterTable IsSolvableGroup IsSolvableTom IsSortDictionary IsSortLookupDictionary IsSortedList IsSortedPcgsRep IsSpaceOfElementsOfMagmaRing IsSpaceOfRationalFunctions IsSpaceOfUEAElements IsSparseHashRep IsSparseRowSpaceElement IsSparseRowSpaceElementCollection IsSparseRowSpaceElementFamily IsSpecialLinearGroup IsSpecialPcgs IsSporadicSimple IsSporadicSimpleCharacterTable IsSporadicSimpleGroup IsStabChainViaChainSubgroup IsStandardGeneratorsOfGroup IsStandardized IsStraightLineProgElm IsStraightLineProgram IsStream IsString IsStringRep IsSubalgebraFpAlgebra IsSubgroup IsSubgroupFgGroup IsSubgroupFpGroup IsSubgroupOfWholeGroupByQuotientRep IsSubgroupSL IsSubmonoidFpMonoid IsSubnormal IsSubnormallyMonomial IsSubsemigroupFpSemigroup IsSubsemigroupReesMatrixSemigroup IsSubsemigroupReesZeroMatrixSemigroup IsSubset IsSubsetBlist IsSubsetInducedNumeratorModuloTailPcgsRep IsSubsetInducedPcgsRep IsSubsetLocallyFiniteGroup IsSubsetSet IsSubspace IsSubspacesFullRowSpaceDefaultRep IsSubspacesVectorSpace IsSubspacesVectorSpaceDefaultRep IsSupersolvable IsSupersolvableCharacterTable IsSupersolvableGroup IsSurjective IsSyllableAssocWordRep IsSyllableWordsFamily IsSymmetricBinaryRelation IsSymmetricGroup IsSymmetricPowerElement IsSymmetricPowerElementCollection IsTable IsTableOfMarks IsTableOfMarksWithGens IsTailInducedPcgsRep IsTensorElement IsTensorElementCollection IsToBeDefinedObj IsToFpGroupGeneralMappingByImages IsToFpGroupHomomorphismByImages IsToPcGroupGeneralMappingByImages IsToPcGroupHomomorphismByImages IsToPermGroupGeneralMappingByImages IsToPermGroupHomomorphismByImages IsTotal IsTotalOrdering IsTransformation IsTransformationCollection IsTransformationMonoid IsTransformationRep IsTransformationRepOfEndo IsTransformationSemigroup IsTransitive IsTransitiveBinaryRelation IsTranslationInvariantOrdering IsTransvByDirProd IsTransvByDirProdCollection IsTransvByHomomorphism IsTransvByHomomorphismCollection IsTransvBySchreierTree IsTransvBySchreierTreeCollection IsTransvBySiftFunct IsTransvBySiftFunctCollection IsTransvByTrivSubgrp IsTransvByTrivSubgrpCollection IsTrivial IsTrivialAOpEZero IsTrivialHomCoset IsTrivialLOpEOne IsTrivialLOpEZero IsTrivialRBase IsTrivialROpEOne IsTrivialROpEZero IsTrivialUOpEOne IsTrivialUOpEZero IsTuple IsTupleCollection IsTupleFamily IsTwoSidedIdeal IsTwoSidedIdealInParent IsTwoSidedIdealOp IsType IsTypeDefaultRep IsUEALatticeElement IsUEALatticeElementCollection IsUEALatticeElementFamily IsUFDFamily IsUniformMatrixGroup IsUniqueFactorizationRing IsUnit IsUnivariatePolynomial IsUnivariatePolynomialRing IsUnivariatePolynomialsFamily IsUnivariatePolynomialsFamilyElement IsUnivariateRationalFunction IsUnivariateRationalFunctionDefaultRep IsUnknown IsUnknownDefaultRep IsUnsortedPcgsRep IsUpToDatePolycyclicCollector IsUpperActedOnByGroup IsUpperActedOnBySuperset IsUpperAlphaChar IsUpperTriangularMat IsValidIdentifier IsVector IsVectorCollColl IsVectorCollection IsVectorList IsVectorSearchTable IsVectorSearchTableDefaultRep IsVectorSpace IsVectorSpaceHomomorphism IsVectorTable IsVirtualCharacter IsWLetterAssocWordRep IsWLetterWordsFamily IsWPObj IsWeakPointerObject IsWedgeElement IsWedgeElementCollection IsWeightLexOrdering IsWeightRepElement IsWeightRepElementCollection IsWeightRepElementFamily IsWellFoundedOrdering IsWeylGroup IsWholeFamily IsWord IsWordCollection IsWordWithInverse IsWordWithOne IsWreathProductElement IsWreathProductElementCollection IsWreathProductElementDefaultRep IsWreathProductOrdering IsWritableFile IsZDFRE IsZDFRECollColl IsZDFRECollection IsZero IsZeroCochainRep IsZeroCyc IsZeroGroup IsZeroMultiplicationRing IsZeroRationalFunction IsZeroSimpleSemigroup IsZeroSquaredElement IsZeroSquaredElementCollColl IsZeroSquaredElementCollection IsZeroSquaredRing IsZmodnZObj IsZmodnZObjNonprime IsZmodnZObjNonprimeCollColl IsZmodnZObjNonprimeCollCollColl IsZmodnZObjNonprimeCollection IsZmodnZObjNonprimeFamily IsZmodpZObj IsZmodpZObjLarge IsZmodpZObjSmall IsolatePoint IsomorphicSubgroups IsomorphismAbelianGroups IsomorphismFpAlgebra IsomorphismFpFLMLOR IsomorphismFpGroup IsomorphismFpGroupByCompositionSeries IsomorphismFpGroupByGenerators IsomorphismFpGroupByGeneratorsNC IsomorphismFpGroupByPcgs IsomorphismFpGroupBySubnormalSeries IsomorphismFpMonoid IsomorphismFpSemigroup IsomorphismGroups IsomorphismMatrixAlgebra IsomorphismMatrixFLMLOR IsomorphismPcGroup IsomorphismPermGroup IsomorphismPermGroupImfGroup IsomorphismPermGroupOrFailFpGroup IsomorphismPermGroups IsomorphismReesMatrixSemigroup IsomorphismRefinedPcGroup IsomorphismSCAlgebra IsomorphismSCFLMLOR IsomorphismSimplifiedFpGroup IsomorphismSolvableSmallGroups IsomorphismSpecialPcGroup IsomorphismToFullRowSpace IsomorphismTransformationSemigroup IsomorphismTypeInfoFiniteSimpleGroup Iterated Iterator IteratorByBasis IteratorByFunctions IteratorList IteratorSorted IteratorsFamily Jacobi JenningsLieAlgebra JenningsSeries JoinEquivalenceRelations JoinMagmaCongruences JoinSemigroupCongruences JoinStringsWithSeparator JordanDecomposition KBOverlaps KappaPerp Kernel KernelHcommaC KernelOfAdditiveGeneralMapping KernelOfCharacter KernelOfHomQuotientGroup KernelOfMultiplicativeGeneralMapping KernelOfTransformation KernelUnderDualAction KeyDependentOperation KillingMatrix KnownAttributesOfObject KnownNaturalHomomorphismsPool KnownPropertiesOfObject KnownTruePropertiesOfObject KnowsDictionary KnowsHowToDecompose KnuthBendixRewritingSystem KroneckerProduct KuKGenerators LClassOfHClass LGFirst LGHeads LGLayers LGLength LGTails LGWeights LLLReducedBasis LLLReducedGramMat LLLint LMPSLPSeed LaTeX LaTeXObj LaTeXStringDecompositionMatrix LaTeXToHTMLString LabsLims Lambda LargeGaloisField LargestElementGroup LargestElementStabChain LargestMovedPoint LargestMovedPointPerm LargestMovedPointPerms LargestUnknown LastHashIndex LastReadValue LastSystemError LatticeByCyclicExtension LatticeGeneratorsInUEA LatticeSubgroups LatticeSubgroupsByTom LaurentPolynomialByCoefficients LaurentPolynomialByExtRep Lcm LcmInt LcmOp LcmPP LeadCoeffsIGS LeadingCoefficient LeadingCoefficientOfPolynomial LeadingExponentOfPcElement LeadingMonomial LeadingMonomialOfPolynomial LeadingMonomialPosExtRep LeadingTermOfPolynomial LeadingUEALatticeMonomial LeastBadComplementLayer LeastBadHallLayer LeftActingAlgebra LeftActingDomain LeftActingGroup LeftActingRingOfIdeal LeftAction LeftAlgebraModule LeftAlgebraModuleByGenerators LeftDerivations LeftIdeal LeftIdealByGenerators LeftIdealNC LeftMagmaCongruence LeftMagmaCongruenceByGeneratingPairs LeftMagmaIdeal LeftMagmaIdealByGenerators LeftModuleByGenerators LeftModuleByHomomorphismToMatAlg LeftModuleGeneralMappingByImages LeftModuleGeneratorsForIdealFromGenerators LeftModuleHomomorphismByImages LeftModuleHomomorphismByImagesNC LeftModuleHomomorphismByMatrix LeftNormedComm LeftQuotient LeftQuotientPowerPcgsElement LeftReduceUEALatticeElement LeftSemigroupCongruenceByGeneratingPairs LeftSemigroupIdealEnumeratorDataGetElement LeftShiftRowVector Legendre Length LengthOfDescendingSeries LengthOfLongestCommonPrefixOfTwoAssocWords LengthWPObj LengthsTom LenstraBase LessBoxedObj LessThanFunction LessThanOrEqualFunction LetterRepAssocWord LetterRepWordsLessFunc LevelsOfGenerators LeviMalcevDecomposition LexicographicOrdering LexicographicOrderingNC LieAlgebra LieAlgebraByDomain LieAlgebraByStructureConstants LieBracket LieCenter LieCentralizer LieCentralizerInParent LieCentre LieCoboundaryOperator LieDerivedSeries LieDerivedSubalgebra LieFamily LieLowerCentralSeries LieNilRadical LieNormalizer LieNormalizerInParent LieObject LieSolvableRadical LieUpperCentralSeries LiftAbsAndIrredModules LiftEpimorphism LiftEpimorphismSQ LiftInduciblePair LiftedInducedPcgs LiftedPcElement LineNumberStringPosition LinearAction LinearActionBasis LinearActionLayer LinearCharacters LinearCombination LinearCombinationPcgs LinearCombinationVecs LinearGroupParameters LinearIndependentColumns LinearOperation LinearOperationLayer LinesOfStraightLineProgram List ListBlist ListHashParams ListN ListOp ListPerm ListSorted ListStabChain ListWithIdenticalEntries ListX ListXHelp ListsFamily LoadAllPackages LoadDynamicModule LoadPackage LoadPackageDocumentation LoadStaticModule LoadedModules LockNaturalHomomorphismsPool Log LogFFE LogInputTo LogInt LogMod LogModRhoIterate LogModShanks LogOutputTo LogTo LongestWeylWordPerm LookupDictionary LowIndexSubgroupsFpGroup LowerCentralSeries LowerCentralSeriesOfGroup LowerTriangularMatrix LowercaseString Lucas MATINTbezout MATINTmgcdex MATINTrgcd MATINTsplit Magma MagmaByGenerators MagmaByMultiplicationTable MagmaByMultiplicationTableCreator MagmaCongruenceByGeneratingPairs MagmaCongruencePartition MagmaElement MagmaGeneratorsOfFamily MagmaHomomorphismByFunctionNC MagmaIdeal MagmaIdealByGenerators MagmaInputString MagmaIsomorphismByFunctionsNC MagmaRingModuloSpanOfZero MagmaWithInverses MagmaWithInversesByGenerators MagmaWithInversesByMultiplicationTable MagmaWithOne MagmaWithOneByGenerators MagmaWithOneByMultiplicationTable MakeCanonical MakeConfluent MakeConsequences MakeConsequencesPres MakeFormulaVector MakeGAPDocDoc MakeHomChain MakeImagesInfoLinearGeneralMappingByImages MakeImmutable MakeKnuthBendixRewritingSystemConfluent MakeLIBTOMLIST MakeMagmaWithInversesByFiniteGenerators MakeMapping MakeMonomialOrdering MakePreImagesInfoLinearGeneralMappingByImages MakePreImagesInfoLinearMappingByMatrix MakePreImagesInfoOperationAlgebraHomomorphism MakeReadOnlyGVar MakeReadOnlyGlobal MakeReadWriteGVar MakeReadWriteGlobal MakeStabChainLong ManageableQuotientOfAbelianPGroup ManageableQuotientOfNilpotentGroup MappedExpression MappedExpressionForElementOfFreeAssociativeAlgebra MappedPcElement MappedVector MappedWord MappedWordSyllableAssocWord MappingByFunction MappingGeneratorsImages MappingOfWhichItIsAsGGMBI MappingPermListList MarksTom MatAlgebra MatAutomorphismsFamily MatCharsWreathSymmetric MatClassMultCoeffsCharTable MatLieAlgebra MatOrbs MatOrbsApprox MatScalarProducts MatSpace MatTom MathieuGroup MathieuGroupCons MatricesOfRelator MatrixAlgebra MatrixAutomorphisms MatrixByBlockMatrix MatrixDimension MatrixLieAlgebra MatrixNewBasePoint MatrixOfAction MatrixOperationOfCP MatrixOperationOfCPGroup MatrixSpace MatrixSpinCharsSn MaxHashViewSize MaxNumeratorCoeffAlgElm MaximalAbelianQuotient MaximalBlocks MaximalBlocksAttr MaximalBlocksOp MaximalNormalSubgroups MaximalSubgroupClassReps MaximalSubgroupClassesRepsLayer MaximalSubgroups MaximalSubgroupsLattice MaximalSubgroupsSymmAlt MaximalSubgroupsTom Maximum MaximumList MeetEquivalenceRelations MeetMagmaCongruences MeetMaps MeetPartitionStrat MeetPartitionStratCell MeetSemigroupCongruences MembershipTestKnownBase MinimalBlockDimension MinimalElementCosetStabChain MinimalGeneratingSet MinimalGensLayer MinimalNonmonomialGroup MinimalNormalSubgroups MinimalPolynomial MinimalPolynomialMatrixNC MinimalStabChain MinimalSupergroupsLattice MinimalSupergroupsTom MinimizeExplicitTransversal MinimizedBombieriNorm Minimum MinimumGroupOnSubgroupsOrbit MinimumList MinusCharacter ModGauss ModifyMinGens ModifyPcgs ModularCharacterDegree ModuleByRestriction ModuleOfExtension ModuloPcgs ModuloPcgsByPcSequence ModuloPcgsByPcSequenceNC ModuloTailPcgsByList ModulusOfZmodnZObj MoebiusMu MoebiusTom MolienSeries MolienSeriesInfo MolienSeriesWithGivenDenominator Monoid MonoidByGenerators MonoidByMultiplicationTable MonoidOfRewritingSystem MonomialComparisonFunction MonomialExtGrlexLess MonomialExtrepComparisonFun MonomialGrevlexOrdering MonomialGrlexOrdering MonomialLexOrdering MonomialOrderingsFamily MonomialTotalDegreeLess MorClassLoop MorClassOrbs MorFindGeneratingSystem MorFroWords MorMaxFusClasses MorRatClasses Morphium MorrisRecursion MostFrequentGeneratorFpGroup MovedPoints MovedPointsPerms MulExt MultCoeffs MultMatrixPadicNumbersByCoefficientsList MultRowVector MultiplicationTable MultiplicativeElementsWithInversesFamilyByRws MultiplicativeNeutralElement MultiplicativeZero MultiplicativeZeroOp Multiply MutableBasis MutableBasisOfClosureUnderAction MutableBasisOfIdealInNonassociativeAlgebra MutableBasisOfNonassociativeAlgebra MutableBasisOfProductSpace MutableCopyMat MutableIdentityMat MutableNullMat MutableTransposedMat MutableTransposedMatDestructive MyFingerprint MyIntCoefficients Naive Name NameFunction NameIsomorphismClass NameMonth NameRNam NameWeekDay NamesFilter NamesGVars NamesLibTom NamesLocalVariablesFunction NamesOfComponents NamesOfFusionSources NamesSystemGVars NamesUserGVars NaturalActedSpace NaturalCharacter NaturalHomomorphismByFixedPointSubspace NaturalHomomorphismByGenerators NaturalHomomorphismByHomVW NaturalHomomorphismByIdeal NaturalHomomorphismByInvariantSubspace NaturalHomomorphismByNilpotentClassTwoElement NaturalHomomorphismByNormalSubgroup NaturalHomomorphismByNormalSubgroupInParent NaturalHomomorphismByNormalSubgroupNC NaturalHomomorphismByNormalSubgroupNCInParent NaturalHomomorphismByNormalSubgroupNCOp NaturalHomomorphismByNormalSubgroupNCOrig NaturalHomomorphismByNormalSubgroupOp NaturalHomomorphismBySubAlgebraModule NaturalHomomorphismBySubspace NaturalHomomorphismBySubspaceOntoFullRowSpace NaturalHomomorphismsPool NaturalIsomorphismByPcgs NearAdditiveGroup NearAdditiveGroupByGenerators NearAdditiveMagma NearAdditiveMagmaByGenerators NearAdditiveMagmaWithInverses NearAdditiveMagmaWithInversesByGenerators NearAdditiveMagmaWithZero NearAdditiveMagmaWithZeroByGenerators NearlyCharacterTablesFamily NegativeRootVectors NegativeRoots NestingDepthA NestingDepthM NewAttribute NewCategory NewConstructor NewDictionary NewFamily NewFilter NewInfoClass NewOperation NewProperty NewRepresentation NewToBeDefinedObj NewType NewmanInfinityCriterion NextIterator NextLevelRegularGroups NextPrimeInt NextRBasePoint NextStepCentralizer NiceAlgebraMonomorphism NiceBasis NiceBasisFiltersInfo NiceBasisNC NiceFreeLeftModule NiceFreeLeftModuleForFLMLOR NiceFreeLeftModuleInfo NiceMonomorphism NiceMonomorphismAutomGroup NiceNormalFormByExtRepFunction NiceObject NiceVector NicomorphismOfFFEMatrixGroup NicomorphismOfGeneralMatrixGroup NilpotencyClassOfGroup NilpotentClassTwoElement NilpotentQuotientOfFpLieAlgebra NinKernelCSPG NonLieNilpotentElement NonNilpotentElement NonPerfectCSPG NonSplitExtensions NonTrivialRightHandSides NonassocWord NonnegIntScalarProducts NonnegativeIntegers NorSerPermPcgs Norm NormalBase NormalClosure NormalClosureByChain NormalClosureInParent NormalClosureOp NormalFormIntMat NormalIntersection NormalIntersectionPcgs NormalMaximalSubgroups NormalSeriesByPcgs NormalSubgroupClasses NormalSubgroupClassesInfo NormalSubgroups NormalSubgroupsAbove NormalSubgroupsCalc NormalizeNameAndKey NormalizeWhitespace NormalizedArgList NormalizedElementOfMagmaRingModuloRelations NormalizedNameAndKey NormalizedWhitespace Normalizer NormalizerInGLnZ NormalizerInGLnZBravaisGroup NormalizerInHomePcgs NormalizerInParent NormalizerOp NormalizerParentSA NormalizerStabCSPG NormalizerTom NormalizersTom NormalizingReducedGL NormedRowVector NormedRowVectors NormedVectors NotifiedFusionsOfLibTom NotifiedFusionsToLibTom NrAffinePrimitiveGroups NrArrangements NrArrangementsMSetA NrArrangementsMSetK NrArrangementsSetA NrArrangementsSetK NrArrangementsX NrBasisVectors NrBitsInt NrCombinations NrCombinationsMSetA NrCombinationsMSetK NrCombinationsSetA NrCombinationsSetK NrCombinationsX NrCompatiblePolynomials NrConjugacyClasses NrConjugacyClassesGL NrConjugacyClassesGU NrConjugacyClassesInSupergroup NrConjugacyClassesPGL NrConjugacyClassesPGU NrConjugacyClassesPSL NrConjugacyClassesPSU NrConjugacyClassesSL NrConjugacyClassesSLIsogeneous NrConjugacyClassesSU NrConjugacyClassesSUIsogeneous NrDerangements NrDerangementsK NrInputsOfStraightLineProgram NrIrreducibleSolvableGroups NrMovedPoints NrMovedPointsPerm NrMovedPointsPerms NrOrderedPartitions NrPartitionTuples NrPartitions NrPartitionsSet NrPerfectGroups NrPerfectLibraryGroups NrPermutationsList NrPolyhedralSubgroups NrPrimitiveGroups NrRestrictedPartitions NrRestrictedPartitionsK NrSmallGroups NrSolvableAffinePrimitiveGroups NrSubsTom NrSyllables NrTransitiveGroups NrTuples NrUnorderedTuples NthChainSubgroup NthFundamentalOrbit NthRoot NthSchreierTransversalOfChainSubgroup NthSiftOneLevel Nucleus NullAlgebra NullMapMatrix NullMat NullspaceIntMat NullspaceMat NullspaceMatDestructive NullspaceModQ NumBol Number NumberArgumentsFunction NumberCells NumberCoset NumberDigits NumberFFVector NumberField NumberGeneratorsOfRws NumberIrreducibleSolvableGroups NumberOfCommutators NumberOfNewGenerators NumberOp NumberPerfectGroups NumberPerfectLibraryGroups NumberSmallGroups NumberSyllables NumeratorOfModuloPcgs NumeratorOfRationalFunction NumeratorRat OCAddBigMatrices OCAddCentralizer OCAddComplement OCAddGenerators OCAddGeneratorsGeneral OCAddGeneratorsPcgs OCAddMatrices OCAddRelations OCAddSumMatrices OCAddToFunctions OCConjugatingWord OCCoprimeComplement OCEquationMatrix OCEquationVector OCNormalRelations OCOneCoboundaries OCOneCocycles OCSmallEquationMatrix OCSmallEquationVector OCTestRelations OCTestRelators ONanScottType ObjByExponents ObjByExtRep ObjByVector Objectify ObjectifyWithAttributes OccuringVariableIndices OctaveAlgebra OddSpinVals OldGeneratorsOfPresentation OldKernelHcommaC OldSubspaceVectorSpaceGroup Omega OmegaAndLowerPCentralSeries OmegaOp OmegaSeries OminusEven OnBreak OnBreakMessage OnCharReadHookExcFds OnCharReadHookExcFuncs OnCharReadHookExcStreams OnCharReadHookInFds OnCharReadHookInFuncs OnCharReadHookInStreams OnCharReadHookOutFds OnCharReadHookOutFuncs OnCharReadHookOutStreams OnCocycle OnIndeterminates OnLeftAntiOperation OnLeftInverse OnLines OnPairs OnPoints OnQuit OnRelVector OnRight OnSets OnSetsDisjointSets OnSetsSets OnSetsTuples OnSubspacesByCanonicalBasis OnTuples OnTuplesSets OnTuplesTuples One OneAttr OneCoboundaries OneCocycles OneFactorBound OneGroup OneImmutable OneIrreducibleSolvableGroup OneMutable OneNormalizerfixedBlockSystem OneOfPcgs OneOp OnePrimitiveGroup OneSM OneSameMutability OneSmallGroup OneTransitiveGroup OperationAlgebraHomomorphism OperatorOfExternalSet OplusEven OpmOdd OpmSmall OptionsStack Orbit OrbitByPosOp OrbitChar OrbitFusions OrbitGenerators OrbitGeneratorsInv OrbitGeneratorsOfGroup OrbitLength OrbitLengthOp OrbitLengths OrbitLengthsDomain OrbitOp OrbitPerms OrbitPowerMaps OrbitRepresentativesCharacters OrbitShortVectors OrbitSplit OrbitStabChain OrbitStabilizer OrbitStabilizerAlgorithm OrbitStabilizerOp OrbitStabilizingParentGroup OrbitalPartition OrbitishFO OrbitishReq Orbits OrbitsByPosOp OrbitsCharacters OrbitsDomain OrbitsPartition OrbitsPerms OrbitsishOperation OrbitsishReq Order OrderKnownDividendList OrderMatLimit OrderMatTrial OrderMod OrderModK OrderOfRewritingSystem OrderOfSchurLift OrderPerm OrderedPartitions OrderedPartitionsA OrderedPartitionsK OrderingByLessThanFunctionNC OrderingByLessThanOrEqualFunctionNC OrderingOfRewritingSystem OrderingOnGenerators OrderingsFamily OrdersClassRepresentatives OrdersTom Ordinal OrdinaryCharacterTable OrthogonalComponents OrthogonalEmbeddings OrthogonalEmbeddingsSpecialDimension OrthogonalSpaceInFullRowSpace OrthogonalityDefectEuclideanLattice OutdatePolycyclicCollector OutputLogTo OutputTextFile OutputTextFileStillOpen OutputTextFileType OutputTextNone OutputTextNoneType OutputTextString OutputTextStringType OutputTextUser OzeroEven OzeroOdd PBIsMinimal PCentralLieAlgebra PCentralNormalSeriesByPcgsPGroup PCentralSeries PCentralSeriesOp PClassPGroup PCore PCoreOp PCover PERFRec PGroupGeneratorsOfAbelianGroup PMultiplicator PQStatistics PQuotient PRIMGrp PRump PRumpOp PSLDegree PSLUnderlyingField PSp PackageInfo PackageVariablesInfo PadicCoefficients PadicExpansionByRat PadicExtensionNumberFamily PadicNumber Page PageDisplay Pager Parametrized Parent ParentAttr ParentPcgs ParityPol ParseArguments ParseBibFiles ParseError ParseTreeXMLString PartialClosureOfCongruence PartialOrderByOrderingFunction PartialOrderOfHasseDiagram Partition PartitionBacktrack PartitionSortedPoints PartitionStabilizerPermGroup PartitionTuples Partitions PartitionsA PartitionsGreatestEQ PartitionsGreatestLE PartitionsK PartitionsRecursively PartitionsSet PartitionsSetA PartitionsSetK PartitionsTest PcElementByExponents PcElementByExponentsNC PcGroupClassMatrixColumn PcGroupCode PcGroupCodeRec PcGroupFpGroup PcGroupFpGroupNC PcGroupWithPcgs PcSeries Pcgs PcgsByIndependentGeneratorsOfAbelianGroup PcgsByPcSequence PcgsByPcSequenceCons PcgsByPcSequenceNC PcgsCentralSeries PcgsChiefSeries PcgsElAbSerFromSpecPcgs PcgsElementaryAbelianSeries PcgsHomSoImPow PcgsMemberPcSeriesPermGroup PcgsPCentralSeriesPGroup PcgsStabChainSeries PcgsSystemLGSeries PcgsSystemWithComplementSystem PcgsSystemWithHallSystem PcgsSystemWithWf PerfGrpConst PerfGrpLoad PerfectCSPG PerfectCentralProduct PerfectGroup PerfectIdentification PerfectResiduum PerfectSubdirectProduct PerfectSubgroupsAlternatingGroup Perform PermBounds PermCandidates PermCandidatesFaithful PermCharInfo PermCharInfoRelative PermChars PermCharsTom PermComb PermLeftQuoTransformation PermList PermListList PermMatrixGroup PermNatAnTestDetect PermNewBasePoint PermOnEnumerator Permanent PermgpContainsAn PermpcgsPcGroupPcgs Permut Permutation PermutationCharacter PermutationCycle PermutationCycleOp PermutationGModule PermutationMat PermutationOp PermutationToSortCharacters PermutationToSortClasses PermutationTom PermutationsFamily PermutationsList PermutationsListK Permuted Phi PlainListCopy PlainListCopyOp PointInCellNo PolycyclicFactorGroup PolycyclicFactorGroupByRelators PolycyclicFactorGroupByRelatorsNC PolycyclicFactorGroupNC PolynomialByExtRep PolynomialByExtRepNC PolynomialCoefficientsOfPolynomial PolynomialDivisionAlgorithm PolynomialModP PolynomialReducedRemainder PolynomialReduction PolynomialRing PopOptions PosSublOdd PosVecEnumFF Position PositionBound PositionCanonical PositionFirstComponent PositionMatchingDelimiter PositionNonZero PositionNot PositionNthOccurrence PositionNthTrueBlist PositionProperty PositionSet PositionSorted PositionStream PositionSublist PositionWord PositionsTrueBlist PositiveExponentsPresentationFpHom PositiveIntegers PositiveRootVectors PositiveRoots PositiveRootsAsWeights PossibleClassFusions PossibleFusionsCharTableTom PossiblePowerMaps PostMakeImmutable Pover PowerDecompositions PowerMap PowerMapByComposition PowerMapOfGroup PowerMapOfGroupWithInvariants PowerMapOp PowerMapsAllowedBySymmetrisations PowerMapsAllowedBySymmetrizations PowerMod PowerModCoeffs PowerModEvalPol PowerModInt PowerPartition PowerPcgsElement PowerS PowerSi PowerSubalgebraSeries PowerWreath PowersumsElsyms PreBasis PreImage PreImageElm PreImageSetStabBlocksHomomorphism PreImageWord PreImages PreImagesElm PreImagesRange PreImagesRepresentative PreImagesRepresentativeOperationAlgebraHomomorphism PreImagesSet PreOrbishProcessing PreferredGenerators PrefrattiniSubgroup PreimagesOfTransformation Presentation PresentationAugmentedCosetTable PresentationFpGroup PresentationNormalClosure PresentationNormalClosureRrs PresentationRegularPermutationGroup PresentationRegularPermutationGroupNC PresentationSubgroup PresentationSubgroupMtc PresentationSubgroupRrs PresentationViaCosetTable PresentationsFamily PrevPrimeInt PriGroItNext PrimGrpLoad PrimaryGeneratorWords PrimeBlocks PrimeBlocksOp PrimeField PrimeOfPGroup PrimePGroup PrimePowerComponent PrimePowerComponents PrimePowerPcSequence PrimePowersInt PrimeResidues PrimeResiduesCache Primes PrimitiveElement PrimitiveFacExtRepRatPol PrimitiveGroup PrimitiveGroupSims PrimitiveGroupsIterator PrimitiveIdentification PrimitiveIndexIrreducibleSolvableGroup PrimitivePolynomial PrimitiveRoot PrimitiveRootMod Print PrintAmbiguity PrintArray PrintBibAsBib PrintBibAsHTML PrintBibAsText PrintCharacterTable PrintCounters PrintFactorsInt PrintFormattedString PrintFormattingStatus PrintGAPDocElementTemplates PrintHashWithNames PrintObj PrintPadicExpansion PrintRecIndent PrintSixFile PrintTo ProbabilityShapes Process ProcessFixpoint ProdCoefRatfun ProdCoeffLaurpol ProdCoeffUnivfunc Product ProductCoeffs ProductMod ProductOp ProductPP ProductPol ProductRootsPol ProductSpace ProductX ProductXHelp ProfileFunctions ProfileFunctionsInGlobalVariables ProfileGlobalFunctions ProfileMethods ProfileOperations ProfileOperationsAndMethods ProfileOperationsAndMethodsOff ProfileOperationsAndMethodsOn ProfileOperationsOff ProfileOperationsOn ProjectedInducedPcgs ProjectedPcElement Projection ProjectionMap ProjectionOntoFullRowSpace ProjectionOntoVectorSubspace ProjectiveActionHomomorphismMatrixGroup ProjectiveActionOnFullSpace ProjectiveCharDeg ProjectiveGeneralLinearGroup ProjectiveGeneralLinearGroupCons ProjectiveGeneralUnitaryGroup ProjectiveGeneralUnitaryGroupCons ProjectiveOrder ProjectiveSpecialLinearGroup ProjectiveSpecialLinearGroupCons ProjectiveSpecialUnitaryGroup ProjectiveSpecialUnitaryGroupCons ProjectiveSymplecticGroup ProjectiveSymplecticGroupCons PropertyMethodByNiceMonomorphism PropertyMethodByNiceMonomorphismCollColl PropertyMethodByNiceMonomorphismCollElm PropertyMethodByNiceMonomorphismElmColl PseudoRandom PseudoRandomSeed PthPowerImage PthPowerImages PullBack PullbackCSPG PullbackKernelCSPG PurePadicNumberFamily PushOptions Quadratic QuasiDihedralGenerators QuaternionAlgebra QuaternionGenerators QuickInverseRepresentative QuoInt QuotRemLaurpols QuotRemPolList QuotSysDefinitionByIndex QuotSysIndexByDefinition Quotient QuotientFromSCTable QuotientGroup QuotientGroupByChainHomomorphicImage QuotientGroupByHomomorphism QuotientGroupByImages QuotientGroupByImagesNC QuotientGroupHom QuotientMod QuotientPolynomialsExtRep QuotientRemainder QuotientSemigroupCongruence QuotientSemigroupHomomorphism QuotientSemigroupPreimage QuotientSystem RBaseGroupsBloxPermGroup RClassOfHClass RNamObj RPFactorsModPrime RPGcdCRT RPGcdModPrime RPGcdRepresentationModPrime RPIFactors RPIGcd RPQuotientModPrime RPSquareHensel RRefine RSSDefaultOptions RadicalGroup RadicalOfAlgebra RanImgSrcSurjBloho RanImgSrcSurjTraho Random RandomBinaryRelationOnPoints RandomByPcs RandomCommutatorSubproduct RandomElmAsWord RandomHashKey RandomInvertibleMat RandomIsomorphismTest RandomList RandomMat RandomNormalSubproduct RandomPcgsSylowSubgroup RandomPol RandomPrimitivePolynomial RandomSchreierSims RandomSpecialPcgsCoded RandomSubprod RandomTransformation RandomUnimodularMat Range Rank RankAction RankFilter RankMat RankMatDestructive RankOfTransformation RankPGroup RanksOfDescendingSeries Rat RatClasPElmArrangeClasses RatPairString RationalClass RationalClasses RationalClassesInEANS RationalClassesPElements RationalClassesPermGroup RationalClassesSolvableGroup RationalClassesTry RationalFunctionByExtRep RationalFunctionByExtRepWithCancellation RationalFunctionsFamily RationalIdentificationPermGroup RationalizedMat Rationals ReObjectify Read ReadAll ReadAllIoStreamByPty ReadAllLine ReadAndCheckFunc ReadAsFunction ReadByte ReadGapRoot ReadGrp ReadLib ReadLine ReadOrComplete ReadPackage ReadPkg ReadPrim ReadSmall ReadSmallLib ReadTest ReadTom ReadTrans RealClasses RealizableBrauerCharacters RecFields RecNames RecordsFamily RecurseSchreierTree RedispatchOnCondition ReduceCoefficientsOfRws ReduceCoeffs ReduceCoeffsMod ReduceLetterRepWordsRewSys ReduceRules ReduceStabChain ReduceWordUsingRewritingSystem Reduced ReducedAdditiveInverse ReducedByIsomorphisms ReducedCharacters ReducedClassFunctions ReducedComm ReducedConfluentRewritingSystem ReducedConfluentRwsFromKbrwsNC ReducedConjugate ReducedDifference ReducedForm ReducedGaloisStabilizerInfo ReducedGroebnerBasis ReducedInverse ReducedLeftQuotient ReducedOne ReducedOrdinary ReducedPcElement ReducedPower ReducedProduct ReducedQuotient ReducedRrsWord ReducedSCTable ReducedScalarProduct ReducedSum ReducedVectorLTM ReducedZero Ree ReeGroup ReeGroupCons ReesCongruenceOfSemigroupIdeal ReesMatrixSemigroup ReesMatrixSemigroupElement ReesMatrixSemigroupEnumeratorGetElement ReesZeroMatrixSemigroup ReesZeroMatrixSemigroupElement ReesZeroMatrixSemigroupElementIsZero ReesZeroMatrixSemigroupEnumeratorGetElement RefinedChain RefinedPcGroup RefinedSymmetrisations RefinedSymmetrizations Refinements ReflectionMat ReflexiveClosureBinaryRelation RegisterRBasePoint RegularActionHomomorphism RegularModule RegularModuleByGens RegularNinKernelCSPG RelVectorToCocycle RelationsOfFpMonoid RelationsOfFpSemigroup RelativeBasis RelativeBasisNC RelativeOrderOfPcElement RelativeOrders RelatorFixedMultiplier RelatorMatrixAbelianizedNormalClosure RelatorMatrixAbelianizedNormalClosureRrs RelatorMatrixAbelianizedSubgroup RelatorMatrixAbelianizedSubgroupMtc RelatorMatrixAbelianizedSubgroupRrs RelatorRepresentatives RelatorsCode RelatorsOfFpAlgebra RelatorsOfFpGroup RelatorsPermGroupHom RelsSortedByStartGen RelsViaCosetTable RemInt RemoveCharacters RemoveElmList RemoveFile RemoveOuterCoeffs RemoveRelator RemoveRootParseTree RemoveSet RemoveStabChain RenumberHighestWeightGenerators RenumberTree RenumberedWord RepOpElmTuplesPermGroup RepOpSetsPermGroup RepeatedString ReplacedString RepresentationsOfMatrix RepresentationsOfObject Representative RepresentativeAction RepresentativeActionOp RepresentativeFromGenerators RepresentativeLinearOperation RepresentativeSmallest RepresentativeTom RepresentativeTomByGenerators RepresentativeTomByGeneratorsNC RepresentativesContainedRightCosets RepresentativesFusions RepresentativesMinimalBlocks RepresentativesMinimalBlocksAttr RepresentativesMinimalBlocksOp RepresentativesPerfectSubgroups RepresentativesPowerMaps RepresentativesSimpleSubgroups RepsPerfSimpSub RequirePackage Reread RereadAndCheckFunc RereadGrp RereadLib RereadPackage RereadPkg RereadPrim RereadSmall RereadTrans ResetFilterObj ResetOptionsStack ResizeFlatHashTable ResizeListHashTable RespectsAddition RespectsAdditiveInverses RespectsInverses RespectsMultiplication RespectsOne RespectsScalarMultiplication RespectsZero RestoreStateRandom Restricted RestrictedClassFunction RestrictedClassFunctions RestrictedExternalSet RestrictedMapping RestrictedNiceMonomorphism RestrictedPartitions RestrictedPartitionsA RestrictedPartitionsK RestrictedPerm RestrictedTransformation ResultOfLineOfStraightLineProgram ResultOfStraightLineProgram Resultant ReturnFail ReturnFalse ReturnNextBasePoint ReturnPopOptions ReturnTrue Reversed ReversedOp Revision RewindStream RewriteAbelianizedSubgroupRelators RewriteSubgroupRelators RewriteWord RightActingAlgebra RightActingDomain RightActingGroup RightActingRingOfIdeal RightAction RightAlgebraModule RightAlgebraModuleByGenerators RightCoset RightCosetCanonicalRepresentativeDeterminator RightCosets RightCosetsNC RightDerivations RightIdeal RightIdealByGenerators RightIdealNC RightMagmaCongruence RightMagmaCongruenceByGeneratingPairs RightMagmaIdeal RightMagmaIdealByGenerators RightModuleByHomomorphismToMatAlg RightSemigroupCongruenceByGeneratingPairs RightSemigroupIdealEnumeratorDataGetElement RightShiftRowVector RightTransversal RightTransversalInParent RightTransversalOp RightTransversalPermGroupConstructor Ring RingByGenerators RingElmTimesElm RingFromFFE RingWithOne RingWithOneByGenerators Root RootBound RootInt RootMod RootModPrime RootModPrimePower RootOfDefiningPolynomial RootSystem RootsMod RootsModPrime RootsModPrimePower RootsOfUPol RootsRepresentativeFFPol RootsUnityMod RootsUnityModPrime RootsUnityModPrimePower RoundCyc RoundCycDown RowEchelonFormLTM RowIndexOfReesMatrixSemigroupElement RowIndexOfReesZeroMatrixSemigroupElement RowSpace RowsOfReesMatrixSemigroup RowsOfReesZeroMatrixSemigroup Rules RunImmediateMethods Runtime Runtimes SCMinSmaGens SCRExtend SCRExtendRecord SCRMakeStabStrong SCRNotice SCRRandomPerm SCRRandomString SCRRandomSubproduct SCRRestoredRecord SCRSchTree SCRSift SCRStrongGenTest SCTableEntry SCTableProduct SLDegree SLUnderlyingField SNFofREF SPolynomial SSortedList SSortedListList STDOut STGSelFunc SameBlock SandwichMatrixOfReesMatrixSemigroup SandwichMatrixOfReesZeroMatrixSemigroup SaveWorkspace ScalarProduct SchreierTransversal SchreierTreeDepth SchreierTreeInternalConsistencyCheck SchuMu SchurCover SchurCoverFP ScriptFromString Search SecHMSM SecondaryGeneratorWordsAugmentedCosetTable SecondaryImagesAugmentedCosetTable SecondsDMYhms SeekPositionStream SelectSmallGroups SelectTransitiveGroups SemiEchelonBasis SemiEchelonBasisNC SemiEchelonMat SemiEchelonMatDestructive SemiEchelonMatTransformation SemiEchelonMatTransformationDestructive SemiEchelonMats SemiEchelonMatsDestructive SemiEchelonMatsNoCo SemiSimpleType SemidirectFactorsOfGroup SemidirectProduct SemidirectProductInfo Semigroup SemigroupByGenerators SemigroupByMultiplicationTable SemigroupCongruenceByGeneratingPairs SemigroupIdealByGenerators SemigroupIdealEnumeratorDataGetElement SemigroupOfRewritingSystem SemigroupTCInitialTableSize SemigroupToddCoxeterInfo Semiring SemiringByGenerators SemiringWithOne SemiringWithOneAndZero SemiringWithOneAndZeroByGenerators SemiringWithOneByGenerators SemiringWithZero SemiringWithZeroByGenerators SeqsOrbits Set SetANonReesCongruenceOfSemigroup SetAbelianInvariants SetAbelianInvariantsOfList SetAbsoluteValue SetActingDomain SetActionHomomorphismAttr SetActionKernelExternalSet SetActorOfExternalSet SetActualLibFileName SetAdditiveElementAsMultiplicativeElement SetAdditiveElementsAsMultiplicativeElementsFamily SetAdditiveInverse SetAdditiveInverseAttr SetAdditiveInverseImmutable SetAdditiveNeutralElement SetAdditivelyActingDomain SetAdjointBasis SetAdjointModule SetAlgebraicElementsFamilies SetAllBlocks SetAllInfoLevels SetAlpha SetAlternatingDegree SetAlternatingSubgroup SetAsDuplicateFreeList SetAsGroup SetAsGroupGeneralMappingByImages SetAsLeftModuleGeneralMappingByImages SetAsList SetAsMagma SetAsMonoid SetAsNearRing SetAsPolynomial SetAsRing SetAsSSortedList SetAsSemigroup SetAsSemiring SetAsSemiringWithOne SetAsSemiringWithOneAndZero SetAsSemiringWithZero SetAsSortedList SetAsSubgroupOfWholeGroupByQuotient SetAssertionLevel SetAssociatedReesMatrixSemigroupOfDClass SetAssociatedSemigroup SetAugmentationIdeal SetAugmentedCosetTableMtcInWholeGroup SetAugmentedCosetTableNormalClosureInWholeGroup SetAugmentedCosetTableRrsInWholeGroup SetAutomorphismDomain SetAutomorphismGroup SetAutomorphismsOfTable SetBaseIntMat SetBaseMat SetBaseOfBasicImageGroup SetBaseOfGroup SetBaseOrthogonalSpaceMat SetBasis SetBasisOfHomCosetAddMatrixGroup SetBasisVectors SetBaumClausenInfo SetBilinearFormMat SetBlocksAttr SetBlocksInfo SetBrauerCharacterValue SetBravaisGroup SetBravaisSubgroups SetBravaisSupergroups SetCanEasilyCompareElements SetCanEasilySortElements SetCanFindNilpotentClassTwoElement SetCanonicalBasis SetCanonicalElt SetCanonicalGenerators SetCanonicalNiceMonomorphism SetCanonicalPcgs SetCanonicalPcgsWrtFamilyPcgs SetCanonicalPcgsWrtHomePcgs SetCanonicalPcgsWrtSpecialPcgs SetCanonicalRepresentativeDeterminatorOfExternalSet SetCanonicalRepresentativeOfExternalOrbitByPcgs SetCanonicalRepresentativeOfExternalSet SetCartanMatrix SetCartanSubalgebra SetCayleyGraphDualSemigroup SetCayleyGraphSemigroup SetCenter SetCentralCharacter SetCentralIdempotentsOfSemiring SetCentralNormalSeriesByPcgs SetCentralizerInGLnZ SetCentralizerInParent SetCentre SetCentreOfCharacter SetChainSubgroup SetChainSubgroupQuotient SetCharacterDegrees SetCharacterNames SetCharacterParameters SetCharacteristic SetCharacteristicPolynomial SetChevalleyBasis SetChiefNormalSeriesByPcgs SetChiefSeries SetClassNames SetClassNamesTom SetClassParameters SetClassPermutation SetClassPositionsOfCentre SetClassPositionsOfDerivedSubgroup SetClassPositionsOfDirectProductDecompositions SetClassPositionsOfElementaryAbelianSeries SetClassPositionsOfFittingSubgroup SetClassPositionsOfKernel SetClassPositionsOfLowerCentralSeries SetClassPositionsOfMaximalNormalSubgroups SetClassPositionsOfNormalSubgroups SetClassPositionsOfSolvableResiduum SetClassPositionsOfSupersolvableResiduum SetClassPositionsOfUpperCentralSeries SetClassRoots SetClassTypesTom SetCoKernelOfAdditiveGeneralMapping SetCoKernelOfMultiplicativeGeneralMapping SetCoefficientsAndMagmaElements SetCoefficientsFamily SetCoefficientsOfLaurentPolynomial SetCoefficientsOfUnivariatePolynomial SetCoefficientsOfUnivariateRationalFunction SetCoefficientsRing SetCollectionsFamily SetColumnIndexOfReesMatrixSemigroupElement SetColumnIndexOfReesZeroMatrixSemigroupElement SetColumnsOfReesMatrixSemigroup SetColumnsOfReesZeroMatrixSemigroup SetCommutator SetCommutatorANC SetCommutatorFactorGroup SetCommutatorLength SetCommutatorNC SetComplementSystem SetComplexConjugate SetComponentsOfTuplesFamily SetCompositionSeries SetComputedAgemos SetComputedAscendingChains SetComputedBrauerTables SetComputedClassFusions SetComputedCyclicExtensionsTom SetComputedHallSubgroups SetComputedIndicators SetComputedIsPNilpotents SetComputedIsPSolvableCharacterTables SetComputedIsPSolvables SetComputedOmegas SetComputedPCentralSeriess SetComputedPCores SetComputedPRumps SetComputedPowerMaps SetComputedPrimeBlockss SetComputedSylowComplements SetComputedSylowSubgroups SetConductor SetConfluentRws SetConjugacyClasses SetConjugacyClassesMaximalSubgroups SetConjugacyClassesPerfectSubgroups SetConjugacyClassesSubgroups SetConjugate SetConjugateANC SetConjugateNC SetConjugates SetConjugatorInnerAutomorphism SetConjugatorOfConjugatorIsomorphism SetConstantTimeAccessList SetConstituentsOfCharacter SetConvertBasicImageGroupElement SetCoreInParent SetCosetTableFpHom SetCosetTableInWholeGroup SetCosetTableNormalClosureInWholeGroup SetCosetTableOfFpSemigroup SetCrystGroupDefaultAction SetCycleStructurePerm SetCyclicExtensionsTom SetDataType SetDecompositionMatrix SetDecompositionTypesOfGroup SetDefaultFieldOfMatrix SetDefaultFieldOfMatrixGroup SetDefectApproximation SetDefiningPcgs SetDefiningPolynomial SetDefinitionNC SetDegreeAction SetDegreeOfBinaryRelation SetDegreeOfCharacter SetDegreeOfLaurentPolynomial SetDegreeOfMatrixGroup SetDegreeOfTransformation SetDegreeOfTransformationSemigroup SetDegreeOperation SetDegreeOverPrimeField SetDelta SetDenominatorOfModuloPcgs SetDenominatorOfRationalFunction SetDepthOfUpperTriangularMatrix SetDerivations SetDerivative SetDerivedLength SetDerivedSeriesOfGroup SetDerivedSubgroup SetDerivedSubgroupsTomPossible SetDerivedSubgroupsTomUnique SetDeterminantMat SetDeterminantOfCharacter SetDihedralGenerators SetDimension SetDimensionOfMatrixGroup SetDimensionOfVectors SetDimensionsLoewyFactors SetDimensionsMat SetDirectFactorsOfGroup SetDirectProductInfo SetDirectSumDecomposition SetDisplayOptions SetDixonRecord SetEANormalSeriesByPcgs SetEarns SetEggBoxOfDClass SetElementTestFunction SetElementaryAbelianSeries SetElementaryAbelianSeriesLargeSteps SetElementaryAbelianSubseries SetElementsFamily SetElmWPObj SetEmptyRowVector SetEntrySCTable SetEnumerator SetEnumeratorByBasis SetEnumeratorSorted SetEquivalenceClassRelation SetEquivalenceClasses SetEquivalenceRelationPartition SetErrorHandler SetExponent SetExponentOfPowering SetExtRepDenominatorRatFun SetExtRepNumeratorRatFun SetExtRepPolynomialRatFun SetExternalOrbits SetExternalOrbitsStabilizers SetExternalSet SetFactorsOfDirectProduct SetFaithfulModule SetFamiliesOfGeneralMappingsAndRanges SetFamilyForOrdering SetFamilyForRewritingSystem SetFamilyPcgs SetFamilyRange SetFamilySource SetFeatureObj SetFieldOfMatrixGroup SetFilterObj SetFittingSubgroup SetFpElmComparisonMethod SetFpElmEqualityMethod SetFpElmKBRWS SetFrattiniSubgroup SetFrattinifactorId SetFrattinifactorSize SetFreeAlgebraOfFpAlgebra SetFreeGeneratorsOfFpAlgebra SetFreeGeneratorsOfFpGroup SetFreeGeneratorsOfFpMonoid SetFreeGeneratorsOfFpSemigroup SetFreeGroupOfBasicImageGroup SetFreeGroupOfFpGroup SetFreeMonoidOfFpMonoid SetFreeMonoidOfRewritingSystem SetFreeSemigroupOfFpSemigroup SetFreeSemigroupOfRewritingSystem SetFrobeniusAutomorphism SetFunctionAction SetFusionConjugacyClassesOp SetFusionsOfLibTom SetFusionsToLibTom SetFusionsTom SetGLDegree SetGLUnderlyingField SetGaloisGroup SetGaloisMat SetGaloisStabilizer SetGaloisType SetGapDocHTMLOptions SetGapDocLaTeXOptions SetGapDocTxtOptions SetGasmanMessageStatus SetGeneralizedPcgs SetGeneratingPairsOfLeftMagmaCongruence SetGeneratingPairsOfMagmaCongruence SetGeneratingPairsOfRightMagmaCongruence SetGeneratingSetIsComplete SetGeneratorOfCyclicGroup SetGeneratorsOfAdditiveGroup SetGeneratorsOfAdditiveMagma SetGeneratorsOfAdditiveMagmaWithInverses SetGeneratorsOfAdditiveMagmaWithZero SetGeneratorsOfAlgebra SetGeneratorsOfAlgebraModule SetGeneratorsOfAlgebraWithOne SetGeneratorsOfDivisionRing SetGeneratorsOfDomain SetGeneratorsOfEquivalenceRelationPartition SetGeneratorsOfExtASet SetGeneratorsOfExtLSet SetGeneratorsOfExtRSet SetGeneratorsOfExtUSet SetGeneratorsOfFLMLOR SetGeneratorsOfFLMLORWithOne SetGeneratorsOfField SetGeneratorsOfGroup SetGeneratorsOfIdeal SetGeneratorsOfLeftIdeal SetGeneratorsOfLeftMagmaIdeal SetGeneratorsOfLeftModule SetGeneratorsOfLeftOperatorAdditiveGroup SetGeneratorsOfLeftOperatorRing SetGeneratorsOfLeftOperatorRingWithOne SetGeneratorsOfLeftVectorSpace SetGeneratorsOfMagma SetGeneratorsOfMagmaIdeal SetGeneratorsOfMagmaWithInverses SetGeneratorsOfMagmaWithOne SetGeneratorsOfMonoid SetGeneratorsOfNearAdditiveGroup SetGeneratorsOfNearAdditiveMagma SetGeneratorsOfNearAdditiveMagmaWithInverses SetGeneratorsOfNearAdditiveMagmaWithZero SetGeneratorsOfRightIdeal SetGeneratorsOfRightMagmaIdeal SetGeneratorsOfRightModule SetGeneratorsOfRightOperatorAdditiveGroup SetGeneratorsOfRing SetGeneratorsOfRingWithOne SetGeneratorsOfRws SetGeneratorsOfSemigroup SetGeneratorsOfSemiring SetGeneratorsOfSemiringWithOne SetGeneratorsOfSemiringWithOneAndZero SetGeneratorsOfSemiringWithZero SetGeneratorsOfTwoSidedIdeal SetGeneratorsOfVectorSpace SetGeneratorsSmallest SetGeneratorsSubgroupsTom SetGlobalPartitionOfClasses SetGrading SetGreensDRelation SetGreensHRelation SetGreensJRelation SetGreensLRelation SetGreensRRelation SetGroupByPcgs SetGroupHClassOfGreensDClass SetGroupOfPcgs SetHallSystem SetHashEntry SetHashEntryAtLastIndex SetHelpViewer SetHirschLength SetHomCosetFamily SetHomFromFreeOfBasicImageGroup SetHomeEnumerator SetHomePcgs SetIBr SetIdGroup SetIdempotents SetIdempotentsTom SetIdempotentsTomInfo SetIdentificationOfConjugacyClasses SetIdentifier SetIdentity SetIdentityMapping SetImage SetImageElt SetImageListOfTransformation SetImageSetOfTransformation SetImagesSmallestGenerators SetImagesSource SetImfRecord SetIndependentGeneratorsOfAbelianGroup SetIndependentGeneratorsOfAbelianMatrixGroup SetIndeterminateName SetIndeterminateNumberOfLaurentPolynomial SetIndeterminateNumberOfUnivariateLaurentPolynomial SetIndeterminateNumberOfUnivariateRationalFunction SetIndeterminateOfUnivariateRationalFunction SetIndeterminatesOfPolynomialRing SetIndexInParent SetIndexInWholeGroup SetIndicesCentralNormalSteps SetIndicesChiefNormalSteps SetIndicesEANormalSteps SetIndicesInvolutaryGenerators SetIndicesNormalSteps SetIndicesOfAdjointBasis SetIndicesPCentralNormalStepsPGroup SetInducedPcgs SetInducedPcgsWrtFamilyPcgs SetInducedPcgsWrtHomePcgs SetInducedPcgsWrtSpecialPcgs SetInfoLevel SetInfoText SetInjectionZeroMagma SetInnerAutomorphismsAutomorphismGroup SetInt SetInternalRepresentative SetInvariantBilinearForm SetInvariantForm SetInvariantLattice SetInvariantQuadraticForm SetInvariantSesquilinearForm SetInverse SetInverseAttr SetInverseClasses SetInverseGeneralMapping SetInverseImmutable SetIrr SetIrrBaumClausen SetIrrConlon SetIrrDixonSchneider SetIrrFacsPol SetIrreducibleRepresentations SetIsAbelian SetIsAbelianNumberField SetIsAbelianTom SetIsAdditiveGroupGeneralMapping SetIsAdditiveGroupHomomorphism SetIsAdditiveGroupToGroupGeneralMapping SetIsAdditiveGroupToGroupHomomorphism SetIsAdditivelyCommutative SetIsAlgebraGeneralMapping SetIsAlgebraHomomorphism SetIsAlgebraModule SetIsAlgebraWithOneGeneralMapping SetIsAlgebraWithOneHomomorphism SetIsAlternatingGroup SetIsAnticommutative SetIsAntisymmetricBinaryRelation SetIsAssociative SetIsAutomorphismGroup SetIsBasicWreathProductOrdering SetIsBergerCondition SetIsBijective SetIsBravaisGroup SetIsBuiltFromAdditiveMagmaWithInverses SetIsBuiltFromGroup SetIsBuiltFromMagma SetIsBuiltFromMagmaWithInverses SetIsBuiltFromMagmaWithOne SetIsBuiltFromMonoid SetIsBuiltFromSemigroup SetIsCanonicalBasis SetIsCanonicalBasisFullMatrixModule SetIsCanonicalBasisFullRowModule SetIsCanonicalBasisFullSCAlgebra SetIsCanonicalNiceMonomorphism SetIsCanonicalPcgs SetIsCanonicalPcgsWrtSpecialPcgs SetIsChainTypeGroup SetIsCharacter SetIsCharacteristicMatrixPGroup SetIsCommutative SetIsCommutativeFamily SetIsConfluent SetIsConjugatorAutomorphism SetIsConjugatorIsomorphism SetIsConstantRationalFunction SetIsConstantTimeAccessGeneralMapping SetIsCycInt SetIsCyclic SetIsCyclicTom SetIsCyclicWithSize SetIsCyclotomicField SetIsDihedralGroup SetIsDistributive SetIsDivisionRing SetIsDuplicateFree SetIsDuplicateFreeList SetIsElementaryAbelian SetIsEmpty SetIsEndoGeneralMapping SetIsEndoMapping SetIsEquivalenceRelation SetIsFFEMatrixGroupOverLargeSpace SetIsFamilyPcgs SetIsField SetIsFieldHomomorphism SetIsFinite SetIsFiniteDimensional SetIsFiniteOrdersPcgs SetIsFiniteSemigroupGreensRelation SetIsFinitelyGeneratedGroup SetIsFrattiniFree SetIsFreeMonoid SetIsFreeSemigroup SetIsFullFpAlgebra SetIsFullHomModule SetIsFullMatrixModule SetIsFullRowModule SetIsFullSCAlgebra SetIsFullSubgroupGLorSLRespectingBilinearForm SetIsFullSubgroupGLorSLRespectingQuadraticForm SetIsFullSubgroupGLorSLRespectingSesquilinearForm SetIsFullTransformationSemigroup SetIsGL SetIsGeneralLinearGroup SetIsGeneralizedCartanMatrix SetIsGeneratorsOfMagmaWithInverses SetIsGreensClass SetIsGreensDClass SetIsGreensDRelation SetIsGreensHClass SetIsGreensHRelation SetIsGreensJClass SetIsGreensJRelation SetIsGreensLClass SetIsGreensLRelation SetIsGreensRClass SetIsGreensRRelation SetIsGreensRelation SetIsGroupGeneralMapping SetIsGroupHClass SetIsGroupHomomorphism SetIsGroupOfAutomorphisms SetIsGroupOfAutomorphismsFiniteGroup SetIsGroupRing SetIsGroupToAdditiveGroupGeneralMapping SetIsGroupToAdditiveGroupHomomorphism SetIsHandledByNiceMonomorphism SetIsHasseDiagram SetIsHomCosetOfAdditiveElt SetIsHomCosetOfFp SetIsHomCosetOfMatrix SetIsHomCosetOfPerm SetIsHomCosetOfTuple SetIsIdealInParent SetIsIdempotent SetIsImpossible SetIsInducedFromNormalSubgroup SetIsInducedPcgsWrtSpecialPcgs SetIsInjective SetIsInnerAutomorphism SetIsIntegerMatrixGroup SetIsIntegralBasis SetIsIntegralCyclotomic SetIsIntegralRing SetIsIrreducibleCharacter SetIsJacobianRing SetIsLDistributive SetIsLatticeOrderBinaryRelation SetIsLaurentPolynomial SetIsLeftActedOnByDivisionRing SetIsLeftAlgebraModule SetIsLeftIdealInParent SetIsLeftModuleGeneralMapping SetIsLeftModuleHomomorphism SetIsLeftSemigroupCongruence SetIsLeftSemigroupIdeal SetIsLieAbelian SetIsLieAlgebra SetIsLieNilpotent SetIsLieSolvable SetIsLinearlyPrimitive SetIsMagmaHomomorphism SetIsMapping SetIsMatrixModule SetIsMinimalNonmonomial SetIsMonoid SetIsMonomialCharacter SetIsMonomialCharacterTable SetIsMonomialGroup SetIsMonomialMatrix SetIsMonomialNumber SetIsNaturalAlternatingGroup SetIsNaturalGL SetIsNaturalSL SetIsNaturalSymmetricGroup SetIsNearRing SetIsNearRingWithOne SetIsNilpQuotientSystem SetIsNilpotentCharacterTable SetIsNilpotentGroup SetIsNilpotentTom SetIsNonTrivial SetIsNoncharacteristicMatrixPGroup SetIsNormalBasis SetIsNormalForm SetIsNormalInParent SetIsNumberField SetIsNumeratorParentPcgsFamilyPcgs SetIsOne SetIsOrderingOnFamilyOfAssocWords SetIsPGroup SetIsPQuotientSystem SetIsPSL SetIsParentPcgsFamilyPcgs SetIsPartialOrderBinaryRelation SetIsPcgsCentralSeries SetIsPcgsChiefSeries SetIsPcgsElementaryAbelianSeries SetIsPcgsPCentralSeriesPGroup SetIsPerfectCharacterTable SetIsPerfectGroup SetIsPerfectTom SetIsPolycyclicGroup SetIsPolynomial SetIsPositionsList SetIsPreOrderBinaryRelation SetIsPrimeField SetIsPrimeOrdersPcgs SetIsPrimitive SetIsPrimitiveAffine SetIsPrimitiveCharacter SetIsPrimitiveMatrixGroup SetIsPseudoCanonicalBasisFullHomModule SetIsQuasiDihedralGroup SetIsQuasiPrimitive SetIsQuaternionGroup SetIsRDistributive SetIsRationalMatrixGroup SetIsRectangularTable SetIsReduced SetIsReesCongruence SetIsReesCongruenceSemigroup SetIsReesMatrixSemigroup SetIsReesZeroMatrixSemigroup SetIsReflexiveBinaryRelation SetIsRegular SetIsRegularDClass SetIsRegularSemigroup SetIsRelativelySM SetIsRestrictedLieAlgebra SetIsRightAlgebraModule SetIsRightIdealInParent SetIsRightSemigroupCongruence SetIsRightSemigroupIdeal SetIsRing SetIsRingGeneralMapping SetIsRingHomomorphism SetIsRingWithOne SetIsRingWithOneGeneralMapping SetIsRingWithOneHomomorphism SetIsRowModule SetIsSL SetIsSSortedList SetIsSemiEchelonized SetIsSemiRegular SetIsSemigroup SetIsSemigroupCongruence SetIsSemigroupIdeal SetIsSemiring SetIsSemiringWithOne SetIsSemiringWithOneAndZero SetIsSemiringWithZero SetIsShortLexOrdering SetIsSimpleAlgebra SetIsSimpleCharacterTable SetIsSimpleGroup SetIsSimpleSemigroup SetIsSingleValued SetIsSkewFieldFamily SetIsSmallList SetIsSolvableCharacterTable SetIsSolvableGroup SetIsSolvableTom SetIsSortedList SetIsSpecialLinearGroup SetIsSpecialPcgs SetIsSporadicSimpleCharacterTable SetIsSporadicSimpleGroup SetIsStabChainViaChainSubgroup SetIsSubgroupSL SetIsSubmonoidFpMonoid SetIsSubnormallyMonomial SetIsSubsemigroupFpSemigroup SetIsSubsemigroupReesMatrixSemigroup SetIsSubsemigroupReesZeroMatrixSemigroup SetIsSubsetLocallyFiniteGroup SetIsSupersolvableCharacterTable SetIsSupersolvableGroup SetIsSurjective SetIsSymmetricBinaryRelation SetIsSymmetricGroup SetIsTotal SetIsTotalOrdering SetIsTransformationMonoid SetIsTransformationSemigroup SetIsTransitive SetIsTransitiveBinaryRelation SetIsTranslationInvariantOrdering SetIsTrivial SetIsTwoSidedIdealInParent SetIsUFDFamily SetIsUniformMatrixGroup SetIsUnivariatePolynomial SetIsUnivariateRationalFunction SetIsVectorSpaceHomomorphism SetIsVirtualCharacter SetIsWeightLexOrdering SetIsWellFoundedOrdering SetIsWeylGroup SetIsWholeFamily SetIsWreathProductOrdering SetIsZero SetIsZeroGroup SetIsZeroMultiplicationRing SetIsZeroRationalFunction SetIsZeroSimpleSemigroup SetIsZeroSquaredRing SetIsomorphismFpAlgebra SetIsomorphismFpFLMLOR SetIsomorphismFpGroup SetIsomorphismFpMonoid SetIsomorphismFpSemigroup SetIsomorphismMatrixAlgebra SetIsomorphismMatrixFLMLOR SetIsomorphismPcGroup SetIsomorphismPermGroup SetIsomorphismReesMatrixSemigroup SetIsomorphismRefinedPcGroup SetIsomorphismSCAlgebra SetIsomorphismSCFLMLOR SetIsomorphismSimplifiedFpGroup SetIsomorphismSpecialPcGroup SetIsomorphismTransformationSemigroup SetJenningsLieAlgebra SetJenningsSeries SetJordanDecomposition SetKernelOfAdditiveGeneralMapping SetKernelOfCharacter SetKernelOfMultiplicativeGeneralMapping SetKernelOfTransformation SetKillingMatrix SetKnowsHowToDecompose SetLClassOfHClass SetLGFirst SetLGHeads SetLGLayers SetLGLength SetLGTails SetLGWeights SetLargestElementGroup SetLargestMovedPoint SetLargestMovedPointPerm SetLatticeGeneratorsInUEA SetLatticeSubgroups SetLeadCoeffsIGS SetLeftActingAlgebra SetLeftActingDomain SetLeftActingGroup SetLeftActingRingOfIdeal SetLeftDerivations SetLength SetLengthsTom SetLessThanFunction SetLessThanOrEqualFunction SetLetterRepWordsLessFunc SetLevelsOfGenerators SetLeviMalcevDecomposition SetLieAlgebraByDomain SetLieCenter SetLieCentralizerInParent SetLieCentre SetLieDerivedSeries SetLieDerivedSubalgebra SetLieFamily SetLieLowerCentralSeries SetLieNilRadical SetLieNormalizerInParent SetLieObject SetLieSolvableRadical SetLieUpperCentralSeries SetLinearActionBasis SetLinearCharacters SetLinesOfStraightLineProgram SetLongestWeylWordPerm SetLowerCentralSeriesOfGroup SetMagmaGeneratorsOfFamily SetMappingGeneratorsImages SetMappingOfWhichItIsAsGGMBI SetMarksTom SetMatTom SetMatrixByBlockMatrix SetMatrixDimension SetMaximalAbelianQuotient SetMaximalBlocksAttr SetMaximalNormalSubgroups SetMaximalSubgroupClassReps SetMaximalSubgroups SetMaximalSubgroupsLattice SetMaximalSubgroupsTom SetMinimalBlockDimension SetMinimalGeneratingSet SetMinimalNormalSubgroups SetMinimalStabChain SetMinimalSupergroupsLattice SetMinimizedBombieriNorm SetModuleOfExtension SetModulusOfZmodnZObj SetMoebiusTom SetMolienSeriesInfo SetMonoidOfRewritingSystem SetMonomialComparisonFunction SetMonomialExtrepComparisonFun SetMovedPoints SetMultipleAttributes SetMultiplicationTable SetMultiplicativeNeutralElement SetMultiplicativeZero SetName SetNameIsomorphismClass SetNamesLibTom SetNamesOfFusionSources SetNaturalCharacter SetNaturalHomomorphismByNormalSubgroupNCInParent SetNaturalHomomorphismsPool SetNegativeRootVectors SetNegativeRoots SetNestingDepthA SetNestingDepthM SetNiceAlgebraMonomorphism SetNiceBasis SetNiceFreeLeftModule SetNiceFreeLeftModuleInfo SetNiceMonomorphism SetNiceNormalFormByExtRepFunction SetNiceObject SetNilpotencyClassOfGroup SetNilpotentClassTwoElement SetNonLieNilpotentElement SetNonNilpotentElement SetNorm SetNormalBase SetNormalClosureInParent SetNormalMaximalSubgroups SetNormalSeriesByPcgs SetNormalSubgroupClassesInfo SetNormalSubgroups SetNormalizerInGLnZ SetNormalizerInGLnZBravaisGroup SetNormalizerInHomePcgs SetNormalizerInParent SetNormalizersTom SetNormedRowVector SetNormedRowVectors SetNormedVectors SetNotifiedFusionsOfLibTom SetNotifiedFusionsToLibTom SetNrConjugacyClasses SetNrInputsOfStraightLineProgram SetNrMovedPoints SetNrMovedPointsPerm SetNrSubsTom SetNrSyllables SetNullAlgebra SetNullspaceIntMat SetNullspaceMat SetNumberGeneratorsOfRws SetNumberSyllables SetNumeratorOfModuloPcgs SetNumeratorOfRationalFunction SetONanScottType SetOccuringVariableIndices SetOmegaAndLowerPCentralSeries SetOmegaSeries SetOne SetOneAttr SetOneImmutable SetOneOfPcgs SetOperatorOfExternalSet SetOrbitGeneratorsOfGroup SetOrbitLengths SetOrbitLengthsDomain SetOrbitStabilizingParentGroup SetOrbits SetOrbitsDomain SetOrder SetOrderingOfRewritingSystem SetOrderingOnGenerators SetOrderingsFamily SetOrdersClassRepresentatives SetOrdersTom SetOrdinaryCharacterTable SetOrthogonalSpaceInFullRowSpace SetPCentralLieAlgebra SetPCentralNormalSeriesByPcgsPGroup SetPClassPGroup SetPSLDegree SetPSLUnderlyingField SetPackageInfo SetParent SetParentAttr SetParentPcgs SetPartialClosureOfCongruence SetPartialOrderOfHasseDiagram SetPcGroupWithPcgs SetPcSeries SetPcgs SetPcgsCentralSeries SetPcgsChiefSeries SetPcgsElementaryAbelianSeries SetPcgsPCentralSeriesPGroup SetPerfectIdentification SetPerfectResiduum SetPermutationTom SetPositiveRootVectors SetPositiveRoots SetPositiveRootsAsWeights SetPower SetPowerANC SetPowerNC SetPowerS SetPowerSubalgebraSeries SetPreBasis SetPreImagesRange SetPreferredGenerators SetPrefrattiniSubgroup SetPresentation SetPrimaryGeneratorWords SetPrimeField SetPrimePGroup SetPrimePowerComponents SetPrimitiveElement SetPrimitiveIdentification SetPrimitiveRoot SetPrintFormattingStatus SetProjectiveOrder SetPseudoRandomSeed SetPthPowerImages SetQuasiDihedralGenerators SetQuaternionGenerators SetQuotientGroup SetQuotientGroupHom SetQuotientSemigroupCongruence SetQuotientSemigroupHomomorphism SetQuotientSemigroupPreimage SetRClassOfHClass SetRadicalGroup SetRadicalOfAlgebra SetRange SetRankAction SetRankMat SetRankOfTransformation SetRankPGroup SetRat SetRationalClasses SetRationalFunctionsFamily SetRationalizedMat SetRealClasses SetRecNames SetRecursionTrapInterval SetReducedConfluentRewritingSystem SetReducedMultiplication SetReesCongruenceOfSemigroupIdeal SetReesZeroMatrixSemigroupElementIsZero SetRefinedPcGroup SetRegularActionHomomorphism SetRelationsOfFpMonoid SetRelationsOfFpSemigroup SetRelativeOrder SetRelativeOrderNC SetRelativeOrders SetRelatorsOfFpAlgebra SetRelatorsOfFpGroup SetRepresentative SetRepresentativeSmallest SetRepresentativesContainedRightCosets SetRepresentativesMinimalBlocksAttr SetRepresentativesPerfectSubgroups SetRepresentativesSimpleSubgroups SetRespectsAddition SetRespectsAdditiveInverses SetRespectsInverses SetRespectsMultiplication SetRespectsOne SetRespectsScalarMultiplication SetRespectsZero SetRightActingAlgebra SetRightActingDomain SetRightActingGroup SetRightActingRingOfIdeal SetRightDerivations SetRightTransversalInParent SetRootOfDefiningPolynomial SetRootSystem SetRowIndexOfReesMatrixSemigroupElement SetRowIndexOfReesZeroMatrixSemigroupElement SetRowsOfReesMatrixSemigroup SetRowsOfReesZeroMatrixSemigroup SetRules SetSLDegree SetSLUnderlyingField SetSandwichMatrixOfReesMatrixSemigroup SetSandwichMatrixOfReesZeroMatrixSemigroup SetSemiEchelonBasis SetSemiEchelonMat SetSemiEchelonMatTransformation SetSemiSimpleType SetSemidirectFactorsOfGroup SetSemidirectProductInfo SetSemigroupOfRewritingSystem SetSiftFunction SetSiftGroup SetSignPerm SetSimpleSystem SetSimsNo SetSize SetSizesCentralizers SetSizesConjugacyClasses SetSmallGeneratingSet SetSmallestGeneratorPerm SetSmallestMovedPoint SetSmallestMovedPointPerm SetSocle SetSocleComplement SetSocleDimensions SetSocleTypePrimitiveGroup SetSortingPerm SetSource SetSparseCartanMatrix SetSpecialPcgs SetSplittingField SetStabChainImmutable SetStabChainMutable SetStabChainOptions SetStabilizerOfExternalSet SetStandardGeneratorsInfo SetStoredExcludedOrders SetStoredGroebnerBasis SetStraightLineProgElmType SetStraightLineProgramsTom SetString SetStructureConstantsTable SetStructureDescription SetSubdirectProductInfo SetSubfields SetSubnormalSeriesInParent SetSubsTom SetSubspaces SetSubspacesAll SetSuccessors SetSupersolvableResiduum SetSurjectiveActionHomomorphismAttr SetSylowSystem SetSymmetricDegree SetSymmetricParentGroup SetTableOfMarks SetTestMonomial SetTestMonomialQuick SetTestQuasiPrimitive SetTestRelativelySM SetTestSubnormallyMonomial SetTietzeOrigin SetTrace SetTranformsOneIntoZero SetTransformationRepresentation SetTransformsAdditionIntoMultiplication SetTransformsAdditiveInversesIntoInverses SetTransformsInversesIntoAdditiveInverses SetTransformsMultiplicationIntoAddition SetTransformsZeroIntoOne SetTransitiveIdentification SetTransitivity SetTransposedMat SetTransposedMatAttr SetTransposedMatImmutable SetTransposedMatrixGroup SetTransversal SetTriangulizedNullspaceMat SetTrivialCharacter SetTrivialSubFLMLOR SetTrivialSubadditiveMagmaWithZero SetTrivialSubalgebra SetTrivialSubgroup SetTrivialSubmagmaWithOne SetTrivialSubmodule SetTrivialSubmonoid SetTrivialSubnearAdditiveMagmaWithZero SetTrivialSubspace SetTwoClosure SetTypeObj SetTzOptions SetTzRules SetUnderlyingCharacterTable SetUnderlyingCharacteristic SetUnderlyingCollection SetUnderlyingElementOfReesMatrixSemigroupElement SetUnderlyingElementOfReesZeroMatrixSemigroupElement SetUnderlyingExternalSet SetUnderlyingFamily SetUnderlyingField SetUnderlyingGeneralMapping SetUnderlyingGroup SetUnderlyingLeftModule SetUnderlyingLieAlgebra SetUnderlyingMagma SetUnderlyingRelation SetUnderlyingSemigroupOfReesMatrixSemigroup SetUnderlyingSemigroupOfReesZeroMatrixSemigroup SetUnderlyingVectorSpace SetUnits SetUniversalEnvelopingAlgebra SetUpperActingDomain SetUpperCentralSeriesOfGroup SetValueOption SetValuesOfClassFunction SetWeightOfGenerators SetWeightsTom SetWeylGroup SetWreathProductInfo SetX SetXHelp SetZClassRepsQClass SetZero SetZeroAttr SetZeroCoefficient SetZeroImmutable SetZuppos SetnpeGL SetnpePSL SetnpeSL SetsOrbits Setter ShallowCopy ShapeFrequencies SharedObj SharedType ShiftedCoeffs ShiftedPadicNumber ShortLexOrdering ShortLexOrderingNC ShortestVectors ShowArgument ShowArguments ShowDetails ShowImpliedFilters ShowMethods ShowOtherMethods ShowPackageVariables ShrinkCoeffs ShrinkRowVector ShrinkableHashTable ShrinkableSingleValuedHashTable Sift SiftAsWord SiftForStrongGenerator SiftFunction SiftGroup SiftOneLevel SiftVector SiftedPcElement SiftedPermutation SiftedVector SiftedVectorForGaussianMatrixSpace SiftedVectorForGaussianRowSpace SiftedWord Sigma SignInt SignPartition SignPerm SignPermGroup SimpleLieAlgebra SimpleLieAlgebraTypeH SimpleLieAlgebraTypeK SimpleLieAlgebraTypeS SimpleLieAlgebraTypeW SimpleSystem SimplifiedFpGroup SimplifyPresentation SimsName SimsNo SimultaneousEigenvalues SingleCollector SingleCollectorByGenerators SingleCollectorByRelators SingleValuedHashTable Size SizeBlist SizeConsiderFunction SizeGL SizeNumbersPerfectGroups SizeOfChainOfGroup SizeOfFieldOfDefinition SizeOfGLdZmodmZ SizePSL SizePolynomialUnipotentClassGL SizeSL SizeScreen SizeStabChain SizeUpperBound SizesCentralizers SizesConjugacyClasses SizesPerfectGroups Sleep SmallGeneratingSet SmallGroup SmallGroupsInformation SmallSpaceCutoff SmallerDegreePermutationRepresentation SmallestGeneratorPerm SmallestMovedPoint SmallestMovedPointPerm SmallestMovedPointPerms SmallestPrimeDivisor SmallestRootInt SmithNormalFormIntegerMat SmithNormalFormIntegerMatTransforms SmithNormalFormSQ Socle SocleComplement SocleDimensions SocleTypePrimitiveGroup SolutionIntMat SolutionMat SolutionMatDestructive SolutionMatNoCo SolutionNullspaceIntMat SolutionSQ SolvableNormalClosurePermGroup SolvableQuotient SomeVerbalSubgroups Sort SortParallel SortRationalClasses SortRelsSortedByStartGen SortedCharacterTable SortedCharacters SortedList SortedSparseActionHomomorphism SortedSparseActionHomomorphismOp SortedTom Sortex SortingPerm Source SourceElt Sp SpanOfMatrixGroup SpanningTree SparseActionHomomorphism SparseActionHomomorphismOp SparseCartanMatrix SparseHashTable SparseIntKey SpecialLinearGroup SpecialLinearGroupCons SpecialOrthogonalGroup SpecialOrthogonalGroupCons SpecialPcgs SpecialPcgsFactor SpecialPcgsSubgroup SpecialUnitaryGroup SpecialUnitaryGroupCons SpecializedExtRepPol SpinInductionScheme SpinorNorm SplitCell SplitCharacters SplitExtension SplitStep SplitString SplitStringInternal SplitTwoSpace SplitUpSublistsByFpFunc SplitWordTail SplittingField Sqrt SquareRoots StabChain StabChainBaseStrongGenerators StabChainForcePoint StabChainImmutable StabChainMutable StabChainOp StabChainOptions StabChainPermGroupToPermGroupGeneralMappingByImages StabChainRandomPermGroup StabChainStrong StabChainSwap Stabilizer StabilizerByMatrixOperation StabilizerFunc StabilizerFuncOp StabilizerOfBlockNC StabilizerOfExternalSet StabilizerOp StabilizerPcgs StandardAssociate StandardClassMatrixColumn StandardGeneratorsFunctions StandardGeneratorsInfo StandardGeneratorsOfFullHomModule StandardGeneratorsOfFullMatrixModule StandardGeneratorsOfGroup StandardScalarProduct StandardizeTable StandardizeTableC StarCyc StateRandom StatusRandom StepModGauss StopNumConsecSiftToOne StopNumSift StopSize StoreAlgExtFam StoreFactorsPol StoreFusion StoreInfoFreeMagma StoredExcludedOrders StoredGroebnerBasis StraightLineProgElm StraightLineProgElmType StraightLineProgGens StraightLineProgram StraightLineProgramElmRankFilter StraightLineProgramNC StraightLineProgramsDefaultType StraightLineProgramsFamily StraightLineProgramsTom StratMeetPartition StreamsFamily StretchImportantSLPElement String StringDate StringFamily StringFile StringImType StringOfResultOfLineOfStraightLineProgram StringOfResultOfStraightLineProgram StringOfUnivariateRationalPolynomialByCoefficients StringPP StringPrint StringStreamInputTextFile StringTime StringToStraightLineProgram StringUnivariateLaurent StringView StripBeginEnd StripEscapeSequences StrongGeneratorsStabChain StrongGens StronglyConnectedComponents StructuralCopy StructureConstantsPadicNumbers StructureConstantsTable StructureDescription SuPeRfail SubAlgebraModule SubFLMLOR SubFLMLORNC SubFLMLORWithOne SubFLMLORWithOneNC SubGModLeadPos SubSyllables SubadditiveGroup SubadditiveGroupNC SubadditiveMagma SubadditiveMagmaNC SubadditiveMagmaWithInverses SubadditiveMagmaWithInversesNC SubadditiveMagmaWithZero SubadditiveMagmaWithZeroNC Subalgebra SubalgebraNC SubalgebraWithOne SubalgebraWithOneNC SubdirProdPcGroups SubdirectDiagonalPerms SubdirectProduct SubdirectProductInfo SubdirectProductOp SubdirectProducts Subfield SubfieldNC Subfields SubgpConjSymmgp Subgroup SubgroupByPcgs SubgroupByProperty SubgroupGeneratorsCosetTable SubgroupMethodByNiceMonomorphism SubgroupMethodByNiceMonomorphismCollColl SubgroupMethodByNiceMonomorphismCollElm SubgroupMethodByNiceMonomorphismCollOther SubgroupNC SubgroupOfWholeGroupByCosetTable SubgroupOfWholeGroupByQuotientSubgroup SubgroupProperty SubgroupShell SubgroupsMethodByNiceMonomorphism SubgroupsOrbitsAndNormalizers SubgroupsSolvableGroup Submagma SubmagmaNC SubmagmaWithInverses SubmagmaWithInversesNC SubmagmaWithOne SubmagmaWithOneNC Submodule SubmoduleNC Submonoid SubmonoidNC SubnearAdditiveGroup SubnearAdditiveGroupNC SubnearAdditiveMagma SubnearAdditiveMagmaNC SubnearAdditiveMagmaWithInverses SubnearAdditiveMagmaWithInversesNC SubnearAdditiveMagmaWithZero SubnearAdditiveMagmaWithZeroNC SubnormalSeries SubnormalSeriesInParent SubnormalSeriesOp SuboLiBli SuboSiBli SuboTruePos SuboUniteBlist Suborbits Subring SubringNC SubringWithOne SubringWithOneNC SubsTom Subsemigroup SubsemigroupNC Subsemiring SubsemiringNC SubsemiringWithOne SubsemiringWithOneAndZero SubsemiringWithOneAndZeroNC SubsemiringWithOneNC SubsemiringWithZero SubsemiringWithZeroNC Subspace SubspaceNC SubspaceVectorSpaceGroup Subspaces SubspacesAll SubspacesDim SubstitutedWord SubstitutionSublist SubtractBlist SubtractBlistOrbitStabChain SubtractSet Subtype Subword Successors SuggestUpgrades Sum SumCoefPolynomial SumCoefRatfun SumCoeffLaurpol SumCoeffUnivfunc SumFactorizationFunctionPcgs SumIntersectionMat SumOfMBMAndMapping SumOfMappingAndMBM SumOfPcElement SumOp SumPcgs SumRootsPol SumRootsPolComp SumX SumXHelp SummandMolienSeries SupType SupersolvableResiduum SupersolvableResiduumDefault SupportedCharacterTableInfo SupportedLibraryTableComponents SurjectiveActionHomomorphismAttr SuzukiGroup SuzukiGroupCons SyllableRepAssocWord SyllableWordObjByExtRep SylowComplement SylowComplementOp SylowSubgroup SylowSubgroupOp SylowSubgroupPermGroup SylowSystem SymAdic SymmetricClosureBinaryRelation SymmetricDegree SymmetricGroup SymmetricGroupCons SymmetricParentGroup SymmetricParts SymmetricPower SymmetricPowerOfAlgebraModule Symmetrisations Symmetrizations SymplecticComponents SymplecticGroup SymplecticGroupCons SyzygyCriterion Sz TRANSGrp TRANSProperties TableAutomorphisms TableHasIntKeyFun TableOfMarks TableOfMarksByLattice TableOfMarksComponents TableOfMarksCyclic TableOfMarksDihedral TableOfMarksFamily TableOfMarksFrobenius TableOfMarksFromLibrary TailOfPcgsPermGroup TailsInverses Tau TeX TeXObj TemporaryGlobalVarName TensorProduct TensorProductGModule TensorProductOfAlgebraModules TensorWreathProductOfMatrixGroup Tensored TestConsistencyMaps TestHomogeneous TestInducedFromNormalSubgroup TestJacobi TestMonomial TestMonomialFromLattice TestMonomialQuick TestMonomialUseLattice TestPackageAvailability TestQuasiPrimitive TestRelativelySM TestRelativelySMFun TestRow TestSubnormallyMonomial Tester TextAttr TextM TietzeOrigin TietzeWordAbstractWord TmpDirectory TmpName ToBeDefinedObjFamily ToBeDefinedObjType ToggleEcho TopExtensionsByAutomorphism Trace TraceDefinition TraceImmediateMethods TraceMat TraceMethods TraceModQF TracePolynomial TracedCosetFpGroup TrailingEntriesLTM TranformsOneIntoZero TransArrange TransCombinat TransGrpLoad TransStabCSPG TransferDiagram TransferPcgsInfo TransferedExtensionPol Transformation TransformationData TransformationFamily TransformationNC TransformationRelation TransformationRepresentation TransformationType TransformingPermutationFamily TransformingPermutations TransformingPermutationsCharacterTables TransformsAdditionIntoMultiplication TransformsAdditiveInversesIntoInverses TransformsInversesIntoAdditiveInverses TransformsMultiplicationIntoAddition TransformsZeroIntoOne TransitiveClosureBinaryRelation TransitiveGroup TransitiveIdentification Transitivity TranslateString TranslatorSubalgebra TransposedMat TransposedMatAttr TransposedMatDestructive TransposedMatImmutable TransposedMatMutable TransposedMatOp TransposedMatrixGroup TransvByDirProdFamily TransvByHomomorphismFamily TransvBySchreierTreeFamily TransvBySiftFunctFamily TransvByTrivSubgrpFamily Transversal TransversalBySiftFunction TransversalByTrivial TransversalElt TransversalOfChainSubgroup TreeEntry TreeRepresentedWord TrialQuotientRPF TriangulizeIntegerMat TriangulizeMat TriangulizeMonomialElementList TriangulizeWeightRepElementList TriangulizedGeneratorsByMatrix TriangulizedIntegerMat TriangulizedIntegerMatTransform TriangulizedIntegerMatTransforms TriangulizedNullspaceMat TriangulizedNullspaceMatDestructive TriangulizedNullspaceMatNT TrivialCharacter TrivialGModule TrivialGroup TrivialGroupCons TrivialIterator TrivialModule TrivialPartition TrivialQuotientSubgroup TrivialSubFLMLOR TrivialSubadditiveMagmaWithZero TrivialSubalgebra TrivialSubgroup TrivialSubmagmaWithOne TrivialSubmodule TrivialSubmonoid TrivialSubnearAdditiveMagmaWithZero TrivialSubspace TryCombinations TryConwayPolynomialForFrobeniusCharacterValue TryCosetTableInWholeGroup TryGcdCancelExtRepPolynomials TryLayerSQ TryModuleSQ TryNextMethod TryPcgsPermGroup TrySecondaryImages Tschirnhausen Tuple TupleNC Tuples TuplesFamily TuplesK TwoClosure TwoClosurePermGroup TwoCoboundaries TwoCoboundariesSQ TwoCocycles TwoCocyclesSQ TwoCohomology TwoCohomologySQ TwoSeqPol TwoSidedIdeal TwoSidedIdealByGenerators TwoSidedIdealNC TwoSquares TypeObj TypeOfDefaultGeneralMapping TypeOfFamilies TypeOfFamilyOfFamilies TypeOfFamilyOfTypes TypeOfTypes TzCheckRecord TzEliminate TzEliminateFromTree TzEliminateGen TzEliminateGens TzFindCyclicJoins TzGeneratorExponents TzGo TzGoGo TzImagesOldGens TzInitGeneratorImages TzMostFrequentPairs TzNewGenerator TzOccurrences TzOccurrencesPairs TzOptionNames TzOptions TzPreImagesNewGens TzPrint TzPrintGeneratorImages TzPrintGenerators TzPrintLengths TzPrintOptions TzPrintPairs TzPrintPresentation TzPrintRelators TzPrintStatus TzRelator TzRemoveGenerators TzRenumberGens TzReplaceGens TzRules TzSearch TzSearchC TzSearchEqual TzSort TzSortC TzSubstitute TzSubstituteCyclicJoins TzSubstituteGen TzSubstituteWord TzTestInitialSetup TzUpdateGeneratorImages TzWordAbstractWord UNIXSelect UglyVector UnInstallCharReadHookFunc UnSetImage Unbind UnbindElmWPObj UnbindGlobal UnderlyingCharacterTable UnderlyingCharacteristic UnderlyingCollection UnderlyingDomainOfBinaryRelation UnderlyingElement UnderlyingElementOfReesMatrixSemigroupElement UnderlyingElementOfReesZeroMatrixSemigroupElement UnderlyingExternalSet UnderlyingFamily UnderlyingField UnderlyingGeneralMapping UnderlyingGroup UnderlyingLeftModule UnderlyingLieAlgebra UnderlyingMagma UnderlyingRelation UnderlyingSemigroupOfReesMatrixSemigroup UnderlyingSemigroupOfReesZeroMatrixSemigroup UnderlyingVectorSpace UndoRefinement UnhideGlobalVariables Union UnionBlist UnionSet UnipotentSubgroup Unique UniteBlist UniteBlistList UniteSet Units UnivariateLaurentPolynomialByCoefficients UnivariatePolynomial UnivariatePolynomialByCoefficients UnivariatePolynomialRing UnivariateRationalFunctionByCoefficients UnivariateRationalFunctionByExtRep UnivariatenessTestRationalFunction UniversalEnvelopingAlgebra Unknown UnknownsType UnloadSmallGroupsData UnlockNaturalHomomorphismsPool UnmarkTree UnorderedTuples UnorderedTuplesK UnprofileFunctions UnprofileMethods UntraceMethods UpEnv UpdateMap UpdatePolycyclicCollector UpdateWeightInfo UpperActingDomain UpperCentralSeries UpperCentralSeriesOfGroup UpperSubdiagonal UseBasis UseFactorRelation UseIsomorphismRelation UseMatrixChainSubgroups UsePermChainSubgroups UseStabChainViaChainSubgroup UseSubsetRelation UseSubsetRelationNC VPActionHom VSTInsertToLeft VSTNode ValidatePackageInfo Valuation Value ValueCochain ValueGlobal ValueMolienSeries ValueOption ValuePol ValuesOfClassFunction VectorOfRelator VectorSearchTable VectorSpace VectorSpaceByPcgsOfElementaryAbelianGroup VerifySGS VerifyStabilizer View ViewFullHomModule ViewLength ViewMolienSeries ViewObj VirtualCharacter WallForm WeakPointerObj WedgeGModule WeekDay WeightLexOrdering WeightLexOrderingNC WeightOfGenerators WeightVecFFE WeightsTom WeylGroup WeylOrbitIterator Where WindowCmd Word WordAlp WordsString WreathElm WreathProduct WreathProductImprimitiveAction WreathProductInfo WreathProductOfMatrixGroup WreathProductOrdering WreathProductProductAction WriteAll WriteBibFile WriteByte WriteLine ZClassRepsQClass ZOp ZassenhausIntersection Zero ZeroAttr ZeroCoefficient ZeroCoefficientRatFun ZeroImmutable ZeroMapping ZeroMutable ZeroOp ZeroSM ZeroSameMutability ZevData ZevDataValue ZippedListQuotient ZippedProduct ZippedSum ZmodnZ ZmodnZObj ZmodpZ ZmodpZNC ZumbroichBase Zuppos"

regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f = compileRegex "(\\d+(\\.\\d+)?|\\.\\d+)([eE][+-]?\\d+)?[ij]?"
regex_'5ba'2dzA'2dZ'5d'5cw'2a = compileRegex "[a-zA-Z]\\w*"
regex_'5cb'28for'29'5cb = compileRegex "\\b(for)\\b"
regex_'5cb'28while'29'5cb = compileRegex "\\b(while)\\b"
regex_'5cb'28od'29'5cb = compileRegex "\\b(od)\\b"
regex_'5cb'28repeat'29'5cb = compileRegex "\\b(repeat)\\b"
regex_'5cb'28until'29'5cb = compileRegex "\\b(until)\\b"
regex_'5cb'28if'29'5cb = compileRegex "\\b(if)\\b"
regex_'5cb'28fi'29'5cb = compileRegex "\\b(fi)\\b"
regex_'5cb'28function'29'5cb = compileRegex "\\b(function)\\b"
regex_'5cb'28end'29'5cb = compileRegex "\\b(end)\\b"
regex_'27'28'5b'5e'27'5c'5c'5d'7c'27'27'7c'5c'5c'27'7c'5c'5c'5b'5e'27'5d'29'2a'27'28'3f'3d'5b'5e'27'5d'7c'24'29 = compileRegex "'([^'\\\\]|''|\\\\'|\\\\[^'])*'(?=[^']|$)"
regex_'27'28'5b'5e'27'5d'7c'27'27'7c'5c'5c'27'29'2a = compileRegex "'([^']|''|\\\\')*"
regex_'22'28'5b'5e'22'5c'5c'5d'7c'22'22'7c'5c'5c'22'7c'5c'5c'5b'5e'22'5d'29'2a'22'28'3f'3d'5b'5e'22'5d'7c'24'29 = compileRegex "\"([^\"\\\\]|\"\"|\\\\\"|\\\\[^\"])*\"(?=[^\"]|$)"
regex_'22'28'5b'5e'22'5d'7c'22'22'7c'5c'5c'22'29'2a = compileRegex "\"([^\"]|\"\"|\\\\\")*"

defaultAttributes = [("Top_Level","Normal Text"),("Commentary","Commentary"),("Code_Folding","Normal Text"),("Two Char Operators","Normal Text"),("Strings","Strings")]

parseRules "Top_Level" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((parseRules "Strings"))
                        <|>
                        ((parseRules "Code_Folding"))
                        <|>
                        ((parseRules "Two Char Operators"))
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Normal Text") >>~ pushContext "Commentary")
                        <|>
                        ((pAnyChar "!%*+,/;=>|;-:<>\\^" >>= withAttribute "Operator1"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_builtinfunctions >>= withAttribute "Builtin Functions"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_controlstatements >>= withAttribute "Control Statements"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_gapkeywords >>= withAttribute "GAP Keywords"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_logicoperators >>= withAttribute "Logic Operators"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_mathoperators >>= withAttribute "Math Operators"))
                        <|>
                        ((pRegExpr regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f >>= withAttribute "Number"))
                        <|>
                        ((pRegExpr regex_'5ba'2dzA'2dZ'5d'5cw'2a >>= withAttribute "Variable")))
     return (attr, result)

parseRules "Commentary" = 
  pzero

parseRules "Code_Folding" = 
  do (attr, result) <- (((pRegExpr regex_'5cb'28for'29'5cb >>= withAttribute "Control Statements"))
                        <|>
                        ((pRegExpr regex_'5cb'28while'29'5cb >>= withAttribute "Control Statements"))
                        <|>
                        ((pRegExpr regex_'5cb'28od'29'5cb >>= withAttribute "Control Statements"))
                        <|>
                        ((pRegExpr regex_'5cb'28repeat'29'5cb >>= withAttribute "Control Statements"))
                        <|>
                        ((pRegExpr regex_'5cb'28until'29'5cb >>= withAttribute "Control Statements"))
                        <|>
                        ((pRegExpr regex_'5cb'28if'29'5cb >>= withAttribute "Control Statements"))
                        <|>
                        ((pRegExpr regex_'5cb'28fi'29'5cb >>= withAttribute "Control Statements"))
                        <|>
                        ((pRegExpr regex_'5cb'28function'29'5cb >>= withAttribute "Function"))
                        <|>
                        ((pRegExpr regex_'5cb'28end'29'5cb >>= withAttribute "Function")))
     return (attr, result)

parseRules "Two Char Operators" = 
  do (attr, result) <- (((pString False ".." >>= withAttribute "Operator2"))
                        <|>
                        ((pString False "!." >>= withAttribute "Operator2"))
                        <|>
                        ((pString False ":=" >>= withAttribute "Operator2"))
                        <|>
                        ((pString False "->" >>= withAttribute "Operator2"))
                        <|>
                        ((pString False "<=" >>= withAttribute "Operator2"))
                        <|>
                        ((pString False ">=" >>= withAttribute "Operator2"))
                        <|>
                        ((pString False "<>" >>= withAttribute "Operator2")))
     return (attr, result)

parseRules "Strings" = 
  do (attr, result) <- (((pRegExpr regex_'27'28'5b'5e'27'5c'5c'5d'7c'27'27'7c'5c'5c'27'7c'5c'5c'5b'5e'27'5d'29'2a'27'28'3f'3d'5b'5e'27'5d'7c'24'29 >>= withAttribute "String"))
                        <|>
                        ((pRegExpr regex_'27'28'5b'5e'27'5d'7c'27'27'7c'5c'5c'27'29'2a >>= withAttribute "Incomplete String"))
                        <|>
                        ((pRegExpr regex_'22'28'5b'5e'22'5c'5c'5d'7c'22'22'7c'5c'5c'22'7c'5c'5c'5b'5e'22'5d'29'2a'22'28'3f'3d'5b'5e'22'5d'7c'24'29 >>= withAttribute "String"))
                        <|>
                        ((pRegExpr regex_'22'28'5b'5e'22'5d'7c'22'22'7c'5c'5c'22'29'2a >>= withAttribute "Incomplete String")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
