{- This module was generated from data in the Kate syntax highlighting file haxe.xml, version 0.1,
   by  Chad Joan -}

module Text.Highlighting.Kate.Syntax.Haxe ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Haxe"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.hx;*.Hx;*.hX;*.HX;"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Haxe" }
  context <- currentContext <|> (pushContext "normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Haxe",["normal"])], synStLanguage = "Haxe", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "normal" -> return () >> pHandleEndLine
    "ModuleName" -> return () >> pHandleEndLine
    "RawString" -> return () >> pHandleEndLine
    "String" -> return () >> pHandleEndLine
    "CommentLine" -> (popContext) >> pEndLine
    "CommentBlock" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Type","dt"),("Integer","dv"),("Hex","bn"),("Float","fl"),("Module","kw"),("EscapeSequence","st"),("String","st"),("RawString","st"),("Comment","co"),("Preprocessor","ot")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "break case cast catch class continue default else enum extends false for function if implements in inline interface new null override private public return static super switch this throw trace true try typedef untyped var while"
list_modules = Set.fromList $ words $ "package import"
list_types = Set.fromList $ words $ "Array Void Bool Int UInt Float Dynamic String List Error Unknown Type"

regex_'23if'28'5cs'2b'5cw'2b'29'3f = compileRegex "#if(\\s+\\w+)?"
regex_'23'28else'7celseif'7cend'7cerror'29 = compileRegex "#(else|elseif|end|error)"
regex_'5b'5cd'5d'5b'5cd'5d'2a'28'5c'2e'28'3f'21'5c'2e'29'5b'5cd'5d'2a'28'5beE'5d'5b'2d'2b'5d'3f'5b'5cd'5d'2b'29'3f'29 = compileRegex "[\\d][\\d]*(\\.(?!\\.)[\\d]*([eE][-+]?[\\d]+)?)"
regex_'5c'2e'5b'5cd'5d'5b'5cd'5d'2a'28'5beE'5d'5b'2d'2b'5d'3f'5b'5cd'5d'2b'29'3f = compileRegex "\\.[\\d][\\d]*([eE][-+]?[\\d]+)?"
regex_0'5bxX'5d'5b'5cda'2dfA'2dF'5d'2b = compileRegex "0[xX][\\da-fA-F]+"
regex_'5cd'2b = compileRegex "\\d+"
regex_'5b'5e'5cs'5cw'2e'3a'2c'5d = compileRegex "[^\\s\\w.:,]"
regex_'5c'5c'28u'5b'5cda'2dfA'2dF'5d'7b4'7d'7cU'5b'5cda'2dfA'2dF'5d'7b8'7d'7c'26'5ba'2dzA'2dZ'5d'5cw'2b'3b'29 = compileRegex "\\\\(u[\\da-fA-F]{4}|U[\\da-fA-F]{8}|&[a-zA-Z]\\w+;)"

defaultAttributes = [("normal","Normal Text"),("ModuleName","Module Name"),("RawString","RawString"),("String","String"),("CommentLine","Comment"),("CommentBlock","Comment")]

parseRules "normal" = 
  do (attr, result) <- (((pRegExpr regex_'23if'28'5cs'2b'5cw'2b'29'3f >>= withAttribute "Preprocessor") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'23'28else'7celseif'7cend'7cerror'29 >>= withAttribute "Preprocessor") >>~ (popContext))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_modules >>= withAttribute "Module") >>~ pushContext "ModuleName")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute "Type"))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Normal Text"))
                        <|>
                        ((pHlCStringChar >>= withAttribute "EscapeString") >>~ (popContext))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "RawString") >>~ pushContext "RawString")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "CommentLine")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "CommentBlock")
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Normal Text"))
                        <|>
                        ((pString False "..." >>= withAttribute "Normal Text") >>~ (popContext))
                        <|>
                        ((pDetect2Chars False '.' '.' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'5b'5cd'5d'5b'5cd'5d'2a'28'5c'2e'28'3f'21'5c'2e'29'5b'5cd'5d'2a'28'5beE'5d'5b'2d'2b'5d'3f'5b'5cd'5d'2b'29'3f'29 >>= withAttribute "Float") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5c'2e'5b'5cd'5d'5b'5cd'5d'2a'28'5beE'5d'5b'2d'2b'5d'3f'5b'5cd'5d'2b'29'3f >>= withAttribute "Float") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_0'5bxX'5d'5b'5cda'2dfA'2dF'5d'2b >>= withAttribute "Hex") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cd'2b >>= withAttribute "Integer") >>~ (popContext)))
     return (attr, result)

parseRules "ModuleName" = 
  do (attr, result) <- (((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "CommentLine")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "CommentBlock")
                        <|>
                        ((pRegExpr regex_'5b'5e'5cs'5cw'2e'3a'2c'5d >>= withAttribute "Module Name") >>~ (popContext)))
     return (attr, result)

parseRules "RawString" = 
  do (attr, result) <- ((pDetectChar False '\'' >>= withAttribute "RawString") >>~ (popContext))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pDetect2Chars False '\\' '"' >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pHlCStringChar >>= withAttribute "EscapeSequence"))
                        <|>
                        ((pRegExpr regex_'5c'5c'28u'5b'5cda'2dfA'2dF'5d'7b4'7d'7cU'5b'5cda'2dfA'2dF'5d'7b8'7d'7c'26'5ba'2dzA'2dZ'5d'5cw'2b'3b'29 >>= withAttribute "EscapeSequence")))
     return (attr, result)

parseRules "CommentLine" = 
  pzero

parseRules "CommentBlock" = 
  do (attr, result) <- ((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
