{- This module was generated from data in the Kate syntax highlighting file jsp.xml, version 1.02,
   by  Rob Martin (rob@gamepimp.com) -}

module Text.Highlighting.Kate.Syntax.Jsp ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "JSP"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.jsp;*.JSP"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "JSP" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("JSP",["Normal"])], synStLanguage = "JSP", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = False, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "Jsp Standard Directive" -> return () >> pHandleEndLine
    "Jsp Xml Directive" -> return () >> pHandleEndLine
    "Jsp Comment" -> return () >> pHandleEndLine
    "Jsp Custom Tag" -> return () >> pHandleEndLine
    "Jsp Standard Directive Value" -> return () >> pHandleEndLine
    "Jsp Xml Directive Value" -> return () >> pHandleEndLine
    "Jsp Custom Tag Value" -> return () >> pHandleEndLine
    "Jsp Double Quoted Param Value" -> return () >> pHandleEndLine
    "Jsp Single Quoted Param Value" -> return () >> pHandleEndLine
    "Jsp Double Quoted Custom Tag Value" -> return () >> pHandleEndLine
    "Jsp Single Quoted Custom Tag Value" -> return () >> pHandleEndLine
    "Jsp Scriptlet" -> return () >> pHandleEndLine
    "Jsp Expression" -> return () >> pHandleEndLine
    "Java Single-Line Comment" -> (popContext) >> pEndLine
    "Java Multi-Line Comment" -> return () >> pHandleEndLine
    "Java String" -> return () >> pHandleEndLine
    "Html Attribute" -> return () >> pHandleEndLine
    "Html Value" -> return () >> pHandleEndLine
    "Html Double Quoted Value" -> return () >> pHandleEndLine
    "Html Single Quoted Value" -> return () >> pHandleEndLine
    "Html Unquoted Value" -> return () >> pHandleEndLine
    "Html Comment" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Identifier","ot"),("Types","dt"),("String","st"),("Comment","co"),("Html Comment","co"),("Decimal","dv"),("Octal","bn"),("Hex","bn"),("Float","fl"),("Char","ch"),("String Char","ch"),("Jsp Comment","co"),("Jsp Param Name","ot"),("Jsp Param Value","st"),("Java Comment","co")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_java'2d1'2e4'2e2'2dclasses = Set.fromList $ words $ "ARG_IN ARG_INOUT ARG_OUT AWTError AWTEvent AWTEventListener AWTEventListenerProxy AWTEventMulticaster AWTException AWTKeyStroke AWTPermission AbstractAction AbstractBorder AbstractButton AbstractCellEditor AbstractCollection AbstractColorChooserPanel AbstractDocument AbstractFormatter AbstractFormatterFactory AbstractInterruptibleChannel AbstractLayoutCache AbstractList AbstractListModel AbstractMap AbstractMethodError AbstractPreferences AbstractSelectableChannel AbstractSelectionKey AbstractSelector AbstractSequentialList AbstractSet AbstractSpinnerModel AbstractTableModel AbstractUndoableEdit AbstractWriter AccessControlContext AccessControlException AccessController AccessException Accessible AccessibleAction AccessibleBundle AccessibleComponent AccessibleContext AccessibleEditableText AccessibleExtendedComponent AccessibleExtendedTable AccessibleHyperlink AccessibleHypertext AccessibleIcon AccessibleKeyBinding AccessibleObject AccessibleRelation AccessibleRelationSet AccessibleResourceBundle AccessibleRole AccessibleSelection AccessibleState AccessibleStateSet AccessibleTable AccessibleTableModelChange AccessibleText AccessibleValue AccountExpiredException Acl AclEntry AclNotFoundException Action ActionEvent ActionListener ActionMap ActionMapUIResource Activatable ActivateFailedException ActivationDesc ActivationException ActivationGroup ActivationGroupDesc ActivationGroupID ActivationGroup_Stub ActivationID ActivationInstantiator ActivationMonitor ActivationSystem Activator ActiveEvent ActiveValue AdapterActivator AdapterActivatorOperations AdapterAlreadyExists AdapterAlreadyExistsHelper AdapterInactive AdapterInactiveHelper AdapterNonExistent AdapterNonExistentHelper AddressHelper Adjustable AdjustmentEvent AdjustmentListener Adler32 AffineTransform AffineTransformOp AlgorithmParameterGenerator AlgorithmParameterGeneratorSpi AlgorithmParameterSpec AlgorithmParameters AlgorithmParametersSpi AlignmentAction AllPermission AlphaComposite AlreadyBound AlreadyBoundException AlreadyBoundHelper AlreadyBoundHolder AlreadyConnectedException AncestorEvent AncestorListener Annotation Any AnyHolder AnySeqHelper AnySeqHelper AnySeqHolder AppConfigurationEntry Applet AppletContext AppletInitializer AppletStub ApplicationException Arc2D Area AreaAveragingScaleFilter ArithmeticException Array Array ArrayIndexOutOfBoundsException ArrayList ArrayStoreException Arrays AssertionError AsyncBoxView AsynchronousCloseException Attr Attribute Attribute Attribute Attribute Attribute AttributeContext AttributeException AttributeInUseException AttributeList AttributeList AttributeListImpl AttributeModificationException AttributeSet AttributeSet AttributeSetUtilities AttributeUndoableEdit AttributedCharacterIterator AttributedString Attributes Attributes Attributes AttributesImpl AudioClip AudioFileFormat AudioFileReader AudioFileWriter AudioFormat AudioInputStream AudioPermission AudioSystem AuthPermission AuthenticationException AuthenticationNotSupportedException Authenticator Autoscroll BAD_CONTEXT BAD_INV_ORDER BAD_OPERATION BAD_PARAM BAD_POLICY BAD_POLICY_TYPE BAD_POLICY_VALUE BAD_TYPECODE BCSIterator BCSSServiceProvider BYTE_ARRAY BackingStoreException BadKind BadLocationException BadPaddingException BandCombineOp BandedSampleModel BasicArrowButton BasicAttribute BasicAttributes BasicBorders BasicButtonListener BasicButtonUI BasicCaret BasicCheckBoxMenuItemUI BasicCheckBoxUI BasicColorChooserUI BasicComboBoxEditor BasicComboBoxRenderer BasicComboBoxUI BasicComboPopup BasicDesktopIconUI BasicDesktopPaneUI BasicDirectoryModel BasicEditorPaneUI BasicFileChooserUI BasicFormattedTextFieldUI BasicGraphicsUtils BasicHTML BasicHighlighter BasicIconFactory BasicInternalFrameTitlePane BasicInternalFrameUI BasicLabelUI BasicListUI BasicLookAndFeel BasicMenuBarUI BasicMenuItemUI BasicMenuUI BasicOptionPaneUI BasicPanelUI BasicPasswordFieldUI BasicPermission BasicPopupMenuSeparatorUI BasicPopupMenuUI BasicProgressBarUI BasicRadioButtonMenuItemUI BasicRadioButtonUI BasicRootPaneUI BasicScrollBarUI BasicScrollPaneUI BasicSeparatorUI BasicSliderUI BasicSpinnerUI BasicSplitPaneDivider BasicSplitPaneUI BasicStroke BasicTabbedPaneUI BasicTableHeaderUI BasicTableUI BasicTextAreaUI BasicTextFieldUI BasicTextPaneUI BasicTextUI BasicToggleButtonUI BasicToolBarSeparatorUI BasicToolBarUI BasicToolTipUI BasicTreeUI BasicViewportUI BatchUpdateException BeanContext BeanContextChild BeanContextChildComponentProxy BeanContextChildSupport BeanContextContainerProxy BeanContextEvent BeanContextMembershipEvent BeanContextMembershipListener BeanContextProxy BeanContextServiceAvailableEvent BeanContextServiceProvider BeanContextServiceProviderBeanInfo BeanContextServiceRevokedEvent BeanContextServiceRevokedListener BeanContextServices BeanContextServicesListener BeanContextServicesSupport BeanContextSupport BeanDescriptor BeanInfo Beans BeepAction BevelBorder BevelBorderUIResource Bias Bidi BigDecimal BigInteger BinaryRefAddr BindException Binding Binding BindingHelper BindingHolder BindingIterator BindingIteratorHelper BindingIteratorHolder BindingIteratorOperations BindingIteratorPOA BindingListHelper BindingListHolder BindingType BindingTypeHelper BindingTypeHolder BitSet Blob BlockView BoldAction Book Boolean BooleanControl BooleanHolder BooleanSeqHelper BooleanSeqHolder Border BorderFactory BorderLayout BorderUIResource BoundedRangeModel Bounds Bounds Box BoxLayout BoxPainter BoxView BoxedValueHelper BreakIterator Buffer BufferCapabilities BufferOverflowException BufferStrategy BufferUnderflowException BufferedImage BufferedImageFilter BufferedImageOp BufferedInputStream BufferedOutputStream BufferedReader BufferedWriter Button ButtonAreaLayout ButtonBorder ButtonBorder ButtonGroup ButtonModel ButtonUI Byte ByteArrayInputStream ByteArrayOutputStream ByteBuffer ByteChannel ByteHolder ByteLookupTable ByteOrder CDATASection CHAR_ARRAY CMMException COMM_FAILURE CRC32 CRL CRLException CRLSelector CSS CTX_RESTRICT_SCOPE Calendar CallableStatement Callback CallbackHandler CancelablePrintJob CancelledKeyException CannotProceed CannotProceedException CannotProceedHelper CannotProceedHolder CannotRedoException CannotUndoException Canvas CardLayout Caret CaretEvent CaretListener CaretPolicy CellEditor CellEditorListener CellRendererPane CertPath CertPathBuilder CertPathBuilderException CertPathBuilderResult CertPathBuilderSpi CertPathParameters CertPathRep CertPathValidator CertPathValidatorException CertPathValidatorResult CertPathValidatorSpi CertSelector CertStore CertStoreException CertStoreParameters CertStoreSpi Certificate Certificate Certificate CertificateEncodingException CertificateEncodingException CertificateException CertificateException CertificateExpiredException CertificateExpiredException CertificateFactory CertificateFactorySpi CertificateNotYetValidException CertificateNotYetValidException CertificateParsingException CertificateParsingException CertificateRep ChangeEvent ChangeListener ChangedCharSetException Channel ChannelBinding Channels CharArrayReader CharArrayWriter CharBuffer CharConversionException CharHolder CharSeqHelper CharSeqHolder CharSequence Character CharacterAttribute CharacterCodingException CharacterConstants CharacterData CharacterIterator Charset CharsetDecoder CharsetEncoder CharsetProvider Checkbox CheckboxGroup CheckboxMenuItem CheckedInputStream CheckedOutputStream Checksum Choice ChoiceCallback ChoiceFormat Chromaticity Cipher CipherInputStream CipherOutputStream CipherSpi Class ClassCastException ClassCircularityError ClassDesc ClassFormatError ClassLoader ClassNotFoundException ClientRequestInfo ClientRequestInfoOperations ClientRequestInterceptor ClientRequestInterceptorOperations Clip Clipboard ClipboardOwner Clob CloneNotSupportedException Cloneable ClosedByInterruptException ClosedChannelException ClosedSelectorException CodeSets CodeSource Codec CodecFactory CodecFactoryHelper CodecFactoryOperations CodecOperations CoderMalfunctionError CoderResult CodingErrorAction CollationElementIterator CollationKey Collator Collection CollectionCertStoreParameters Collections Color ColorAttribute ColorChooserComponentFactory ColorChooserUI ColorConstants ColorConvertOp ColorModel ColorSelectionModel ColorSpace ColorSupported ColorType ColorUIResource ComboBoxEditor ComboBoxModel ComboBoxUI ComboPopup CommandEnvironment Comment CommunicationException Comparable Comparator Compiler CompletionStatus CompletionStatusHelper Component ComponentAdapter ComponentColorModel ComponentEvent ComponentIdHelper ComponentInputMap ComponentInputMapUIResource ComponentListener ComponentOrientation ComponentSampleModel ComponentUI ComponentView Composite CompositeContext CompositeName CompositeView CompoundBorder CompoundBorderUIResource CompoundControl CompoundEdit CompoundName Compression ConcurrentModificationException Configuration ConfigurationException ConfirmationCallback ConnectException ConnectException ConnectIOException Connection ConnectionEvent ConnectionEventListener ConnectionPendingException ConnectionPoolDataSource ConsoleHandler Constraints Constructor Container ContainerAdapter ContainerEvent ContainerListener ContainerOrderFocusTraversalPolicy Content ContentHandler ContentHandler ContentHandlerFactory ContentModel Context Context ContextList ContextNotEmptyException ContextualRenderedImageFactory Control Control ControlFactory ControllerEventListener ConvolveOp CookieHolder Copies CopiesSupported CopyAction CredentialExpiredException CropImageFilter CubicCurve2D Currency Current Current Current CurrentHelper CurrentHelper CurrentHelper CurrentHolder CurrentOperations CurrentOperations CurrentOperations Cursor CustomMarshal CustomValue Customizer CutAction DATA_CONVERSION DESKeySpec DESedeKeySpec DGC DHGenParameterSpec DHKey DHParameterSpec DHPrivateKey DHPrivateKeySpec DHPublicKey DHPublicKeySpec DOMException DOMImplementation DOMLocator DOMResult DOMSource DSAKey DSAKeyPairGenerator DSAParameterSpec DSAParams DSAPrivateKey DSAPrivateKeySpec DSAPublicKey DSAPublicKeySpec DTD DTDConstants DTDHandler DataBuffer DataBufferByte DataBufferDouble DataBufferFloat DataBufferInt DataBufferShort DataBufferUShort DataFlavor DataFormatException DataInput DataInputStream DataInputStream DataLine DataOutput DataOutputStream DataOutputStream DataSource DataTruncation DatabaseMetaData DatagramChannel DatagramPacket DatagramSocket DatagramSocketImpl DatagramSocketImplFactory Date Date DateEditor DateFormat DateFormatSymbols DateFormatter DateTimeAtCompleted DateTimeAtCreation DateTimeAtProcessing DateTimeSyntax DebugGraphics DecimalFormat DecimalFormatSymbols DeclHandler DefaultBoundedRangeModel DefaultButtonModel DefaultCaret DefaultCellEditor DefaultColorSelectionModel DefaultComboBoxModel DefaultDesktopManager DefaultEditor DefaultEditorKit DefaultFocusManager DefaultFocusTraversalPolicy DefaultFormatter DefaultFormatterFactory DefaultHandler DefaultHighlightPainter DefaultHighlighter DefaultKeyTypedAction DefaultKeyboardFocusManager DefaultListCellRenderer DefaultListModel DefaultListSelectionModel DefaultMenuLayout DefaultMetalTheme DefaultMutableTreeNode DefaultPersistenceDelegate DefaultSelectionType DefaultSingleSelectionModel DefaultStyledDocument DefaultTableCellRenderer DefaultTableColumnModel DefaultTableModel DefaultTextUI DefaultTreeCellEditor DefaultTreeCellRenderer DefaultTreeModel DefaultTreeSelectionModel DefinitionKind DefinitionKindHelper Deflater DeflaterOutputStream Delegate Delegate Delegate DelegationPermission DesignMode DesktopIconUI DesktopManager DesktopPaneUI Destination DestinationType DestroyFailedException Destroyable Dialog DialogType Dictionary DigestException DigestInputStream DigestOutputStream Dimension Dimension2D DimensionUIResource DirContext DirObjectFactory DirStateFactory DirectColorModel DirectoryManager DisplayMode DnDConstants Doc DocAttribute DocAttributeSet DocFlavor DocPrintJob Document Document DocumentBuilder DocumentBuilderFactory DocumentEvent DocumentFilter DocumentFragment DocumentHandler DocumentListener DocumentName DocumentParser DocumentType DomainCombiner DomainManager DomainManagerOperations Double Double Double Double Double Double Double Double Double DoubleBuffer DoubleHolder DoubleSeqHelper DoubleSeqHolder DragGestureEvent DragGestureListener DragGestureRecognizer DragSource DragSourceAdapter DragSourceContext DragSourceDragEvent DragSourceDropEvent DragSourceEvent DragSourceListener DragSourceMotionListener Driver DriverManager DriverPropertyInfo DropTarget DropTargetAdapter DropTargetAutoScroller DropTargetContext DropTargetDragEvent DropTargetDropEvent DropTargetEvent DropTargetListener DuplicateName DuplicateNameHelper DynAny DynAny DynAnyFactory DynAnyFactoryHelper DynAnyFactoryOperations DynAnyHelper DynAnyOperations DynAnySeqHelper DynArray DynArray DynArrayHelper DynArrayOperations DynEnum DynEnum DynEnumHelper DynEnumOperations DynFixed DynFixed DynFixedHelper DynFixedOperations DynSequence DynSequence DynSequenceHelper DynSequenceOperations DynStruct DynStruct DynStructHelper DynStructOperations DynUnion DynUnion DynUnionHelper DynUnionOperations DynValue DynValue DynValueBox DynValueBoxOperations DynValueCommon DynValueCommonOperations DynValueHelper DynValueOperations DynamicImplementation DynamicImplementation DynamicUtilTreeNode ENCODING_CDR_ENCAPS EOFException EditorKit Element Element Element ElementChange ElementEdit ElementIterator ElementSpec Ellipse2D EmptyBorder EmptyBorderUIResource EmptySelectionModel EmptyStackException EncodedKeySpec Encoder Encoding Encoding EncryptedPrivateKeyInfo Engineering Entity Entity EntityReference EntityResolver Entry EnumControl EnumSyntax Enumeration Environment Error ErrorHandler ErrorListener ErrorManager EtchedBorder EtchedBorderUIResource Event EventContext EventDirContext EventHandler EventListener EventListenerList EventListenerProxy EventObject EventQueue EventSetDescriptor EventType EventType Exception ExceptionInInitializerError ExceptionList ExceptionListener ExemptionMechanism ExemptionMechanismException ExemptionMechanismSpi ExpandVetoException ExportException Expression ExtendedRequest ExtendedResponse Externalizable FREE_MEM FactoryConfigurationError FailedLoginException FeatureDescriptor Fidelity Field Field Field Field Field FieldBorder FieldNameHelper FieldNameHelper FieldPosition FieldView File FileCacheImageInputStream FileCacheImageOutputStream FileChannel FileChooserUI FileDescriptor FileDialog FileFilter FileFilter FileHandler FileIcon16 FileImageInputStream FileImageOutputStream FileInputStream FileLock FileLockInterruptionException FileNameMap FileNotFoundException FileOutputStream FilePermission FileReader FileSystemView FileView FileWriter FilenameFilter Filler Filter Filter FilterBypass FilterBypass FilterInputStream FilterOutputStream FilterReader FilterWriter FilteredImageSource Finishings FixedHeightLayoutCache FixedHolder FlatteningPathIterator FlavorException FlavorMap FlavorTable FlipContents Float Float Float Float Float Float Float Float Float FloatBuffer FloatControl FloatHolder FloatSeqHelper FloatSeqHolder FlowLayout FlowStrategy FlowView Flush3DBorder FocusAdapter FocusEvent FocusListener FocusManager FocusTraversalPolicy FolderIcon16 Font FontAttribute FontConstants FontFamilyAction FontFormatException FontMetrics FontRenderContext FontSizeAction FontUIResource ForegroundAction FormView Format FormatConversionProvider FormatMismatch FormatMismatchHelper Formatter ForwardRequest ForwardRequest ForwardRequestHelper ForwardRequestHelper Frame GSSContext GSSCredential GSSException GSSManager GSSName GZIPInputStream GZIPOutputStream GapContent GatheringByteChannel GeneralPath GeneralSecurityException GetField GlyphJustificationInfo GlyphMetrics GlyphPainter GlyphVector GlyphView GradientPaint GraphicAttribute Graphics Graphics2D GraphicsConfigTemplate GraphicsConfiguration GraphicsDevice GraphicsEnvironment GrayFilter GregorianCalendar GridBagConstraints GridBagLayout GridLayout Group Guard GuardedObject HTML HTMLDocument HTMLEditorKit HTMLEditorKit HTMLEditorKit HTMLFrameHyperlinkEvent HTMLWriter Handler HandlerBase HandshakeCompletedEvent HandshakeCompletedListener HasControls HashAttributeSet HashDocAttributeSet HashMap HashPrintJobAttributeSet HashPrintRequestAttributeSet HashPrintServiceAttributeSet HashSet Hashtable HeadlessException HierarchyBoundsAdapter HierarchyBoundsListener HierarchyEvent HierarchyListener Highlight HighlightPainter Highlighter HostnameVerifier HttpURLConnection HttpsURLConnection HyperlinkEvent HyperlinkListener ICC_ColorSpace ICC_Profile ICC_ProfileGray ICC_ProfileRGB IDLEntity IDLType IDLTypeHelper IDLTypeOperations ID_ASSIGNMENT_POLICY_ID ID_UNIQUENESS_POLICY_ID IIOByteBuffer IIOException IIOImage IIOInvalidTreeException IIOMetadata IIOMetadataController IIOMetadataFormat IIOMetadataFormatImpl IIOMetadataNode IIOParam IIOParamController IIOReadProgressListener IIOReadUpdateListener IIOReadWarningListener IIORegistry IIOServiceProvider IIOWriteProgressListener IIOWriteWarningListener IMPLICIT_ACTIVATION_POLICY_ID IMP_LIMIT INITIALIZE INPUT_STREAM INTERNAL INTF_REPOS INVALID_TRANSACTION INV_FLAG INV_IDENT INV_OBJREF INV_POLICY IOException IOR IORHelper IORHolder IORInfo IORInfoOperations IORInterceptor IORInterceptorOperations IRObject IRObjectOperations ISO Icon IconUIResource IconView IdAssignmentPolicy IdAssignmentPolicyOperations IdAssignmentPolicyValue IdUniquenessPolicy IdUniquenessPolicyOperations IdUniquenessPolicyValue IdentifierHelper Identity IdentityHashMap IdentityScope IllegalAccessError IllegalAccessException IllegalArgumentException IllegalBlockSizeException IllegalBlockingModeException IllegalCharsetNameException IllegalComponentStateException IllegalMonitorStateException IllegalPathStateException IllegalSelectorException IllegalStateException IllegalThreadStateException Image ImageCapabilities ImageConsumer ImageFilter ImageGraphicAttribute ImageIO ImageIcon ImageInputStream ImageInputStreamImpl ImageInputStreamSpi ImageObserver ImageOutputStream ImageOutputStreamImpl ImageOutputStreamSpi ImageProducer ImageReadParam ImageReader ImageReaderSpi ImageReaderWriterSpi ImageTranscoder ImageTranscoderSpi ImageTypeSpecifier ImageView ImageWriteParam ImageWriter ImageWriterSpi ImagingOpException ImplicitActivationPolicy ImplicitActivationPolicyOperations ImplicitActivationPolicyValue IncompatibleClassChangeError InconsistentTypeCode InconsistentTypeCode InconsistentTypeCodeHelper IndexColorModel IndexOutOfBoundsException IndexedPropertyDescriptor IndirectionException Inet4Address Inet6Address InetAddress InetSocketAddress Inflater InflaterInputStream Info Info Info Info Info InheritableThreadLocal InitialContext InitialContextFactory InitialContextFactoryBuilder InitialDirContext InitialLdapContext InlineView InputContext InputEvent InputMap InputMapUIResource InputMethod InputMethodContext InputMethodDescriptor InputMethodEvent InputMethodHighlight InputMethodListener InputMethodRequests InputSource InputStream InputStream InputStream InputStreamReader InputSubset InputVerifier InsertBreakAction InsertContentAction InsertHTMLTextAction InsertTabAction Insets InsetsUIResource InstantiationError InstantiationException Instrument InsufficientResourcesException IntBuffer IntHolder Integer IntegerSyntax Interceptor InterceptorOperations InternalError InternalFrameAdapter InternalFrameBorder InternalFrameEvent InternalFrameFocusTraversalPolicy InternalFrameListener InternalFrameUI InternationalFormatter InterruptedException InterruptedIOException InterruptedNamingException InterruptibleChannel IntrospectionException Introspector Invalid InvalidAddress InvalidAddressHelper InvalidAddressHolder InvalidAlgorithmParameterException InvalidAttributeIdentifierException InvalidAttributeValueException InvalidAttributesException InvalidClassException InvalidDnDOperationException InvalidKeyException InvalidKeySpecException InvalidMarkException InvalidMidiDataException InvalidName InvalidName InvalidName InvalidNameException InvalidNameHelper InvalidNameHelper InvalidNameHolder InvalidObjectException InvalidParameterException InvalidParameterSpecException InvalidPolicy InvalidPolicyHelper InvalidPreferencesFormatException InvalidSearchControlsException InvalidSearchFilterException InvalidSeq InvalidSlot InvalidSlotHelper InvalidTransactionException InvalidTypeForEncoding InvalidTypeForEncodingHelper InvalidValue InvalidValue InvalidValueHelper InvocationEvent InvocationHandler InvocationTargetException InvokeHandler IstringHelper ItalicAction ItemEvent ItemListener ItemSelectable Iterator Iterator IvParameterSpec JApplet JButton JCheckBox JCheckBoxMenuItem JColorChooser JComboBox JComponent JDesktopIcon JDesktopPane JDialog JEditorPane JFileChooser JFormattedTextField JFrame JIS JInternalFrame JLabel JLayeredPane JList JMenu JMenuBar JMenuItem JOptionPane JPEGHuffmanTable JPEGImageReadParam JPEGImageWriteParam JPEGQTable JPanel JPasswordField JPopupMenu JProgressBar JRadioButton JRadioButtonMenuItem JRootPane JScrollBar JScrollPane JSeparator JSlider JSpinner JSplitPane JTabbedPane JTable JTableHeader JTextArea JTextComponent JTextField JTextPane JToggleButton JToolBar JToolTip JTree JViewport JWindow JarEntry JarException JarFile JarInputStream JarOutputStream JarURLConnection JobAttributes JobHoldUntil JobImpressions JobImpressionsCompleted JobImpressionsSupported JobKOctets JobKOctetsProcessed JobKOctetsSupported JobMediaSheets JobMediaSheetsCompleted JobMediaSheetsSupported JobMessageFromOperator JobName JobOriginatingUserName JobPriority JobPrioritySupported JobSheets JobState JobStateReason JobStateReasons KerberosKey KerberosPrincipal KerberosTicket Kernel Key Key KeyAdapter KeyAgreement KeyAgreementSpi KeyBinding KeyEvent KeyEventDispatcher KeyEventPostProcessor KeyException KeyFactory KeyFactorySpi KeyGenerator KeyGeneratorSpi KeyListener KeyManagementException KeyManager KeyManagerFactory KeyManagerFactorySpi KeyPair KeyPairGenerator KeyPairGeneratorSpi KeySelectionManager KeySpec KeyStore KeyStoreException KeyStoreSpi KeyStroke KeyboardFocusManager Keymap LDAPCertStoreParameters LIFESPAN_POLICY_ID LOCATION_FORWARD Label LabelUI LabelView LanguageCallback LastOwnerException LayerPainter LayeredHighlighter LayoutFocusTraversalPolicy LayoutManager LayoutManager2 LayoutQueue LazyInputMap LazyValue LdapContext LdapReferralException Lease Level LexicalHandler LifespanPolicy LifespanPolicyOperations LifespanPolicyValue LimitExceededException Line Line2D LineBorder LineBorderUIResource LineBreakMeasurer LineEvent LineListener LineMetrics LineNumberInputStream LineNumberReader LineUnavailableException LinkController LinkException LinkLoopException LinkRef LinkageError LinkedHashMap LinkedHashSet LinkedList List List ListCellRenderer ListDataEvent ListDataListener ListEditor ListIterator ListModel ListPainter ListResourceBundle ListSelectionEvent ListSelectionListener ListSelectionModel ListUI ListView LoaderHandler LocalObject Locale LocateRegistry Locator LocatorImpl LogManager LogRecord LogStream Logger LoggingPermission LoginContext LoginException LoginModule LoginModuleControlFlag Long LongBuffer LongHolder LongLongSeqHelper LongLongSeqHolder LongSeqHelper LongSeqHolder LookAndFeel LookAndFeelInfo LookupOp LookupTable MARSHAL Mac MacSpi MalformedInputException MalformedLinkException MalformedURLException ManagerFactoryParameters Manifest Map MapMode MappedByteBuffer MarginBorder MarshalException MarshalledObject MaskFormatter Matcher Math MatteBorder MatteBorderUIResource Media MediaName MediaPrintableArea MediaSize MediaSizeName MediaTracker MediaTray MediaType Member MemoryCacheImageInputStream MemoryCacheImageOutputStream MemoryHandler MemoryImageSource Menu MenuBar MenuBarBorder MenuBarBorder MenuBarUI MenuComponent MenuContainer MenuDragMouseEvent MenuDragMouseListener MenuElement MenuEvent MenuItem MenuItemBorder MenuItemUI MenuKeyEvent MenuKeyListener MenuListener MenuSelectionManager MenuShortcut MessageDigest MessageDigestSpi MessageFormat MessageProp MetaEventListener MetaMessage MetalBorders MetalButtonUI MetalCheckBoxIcon MetalCheckBoxUI MetalComboBoxButton MetalComboBoxEditor MetalComboBoxIcon MetalComboBoxUI MetalDesktopIconUI MetalFileChooserUI MetalIconFactory MetalInternalFrameTitlePane MetalInternalFrameUI MetalLabelUI MetalLookAndFeel MetalPopupMenuSeparatorUI MetalProgressBarUI MetalRadioButtonUI MetalRootPaneUI MetalScrollBarUI MetalScrollButton MetalScrollPaneUI MetalSeparatorUI MetalSliderUI MetalSplitPaneUI MetalTabbedPaneUI MetalTextFieldUI MetalTheme MetalToggleButtonUI MetalToolBarUI MetalToolTipUI MetalTreeUI Method MethodDescriptor MidiChannel MidiDevice MidiDeviceProvider MidiEvent MidiFileFormat MidiFileReader MidiFileWriter MidiMessage MidiSystem MidiUnavailableException MimeTypeParseException MinimalHTMLWriter MissingResourceException Mixer MixerProvider ModificationItem Modifier MouseAdapter MouseDragGestureRecognizer MouseEvent MouseInputAdapter MouseInputListener MouseListener MouseMotionAdapter MouseMotionListener MouseWheelEvent MouseWheelListener MultiButtonUI MultiColorChooserUI MultiComboBoxUI MultiDesktopIconUI MultiDesktopPaneUI MultiDoc MultiDocPrintJob MultiDocPrintService MultiFileChooserUI MultiInternalFrameUI MultiLabelUI MultiListUI MultiLookAndFeel MultiMenuBarUI MultiMenuItemUI MultiOptionPaneUI MultiPanelUI MultiPixelPackedSampleModel MultiPopupMenuUI MultiProgressBarUI MultiRootPaneUI MultiScrollBarUI MultiScrollPaneUI MultiSeparatorUI MultiSliderUI MultiSpinnerUI MultiSplitPaneUI MultiTabbedPaneUI MultiTableHeaderUI MultiTableUI MultiTextUI MultiToolBarUI MultiToolTipUI MultiTreeUI MultiViewportUI MulticastSocket MultipleComponentProfileHelper MultipleComponentProfileHolder MultipleDocumentHandling MultipleDocumentHandlingType MultipleMaster MutableAttributeSet MutableComboBoxModel MutableTreeNode NA NO_IMPLEMENT NO_MEMORY NO_PERMISSION NO_RESOURCES NO_RESPONSE NVList Name Name NameAlreadyBoundException NameCallback NameClassPair NameComponent NameComponentHelper NameComponentHolder NameDynAnyPair NameDynAnyPairHelper NameDynAnyPairSeqHelper NameHelper NameHolder NameNotFoundException NameParser NameValuePair NameValuePair NameValuePairHelper NameValuePairHelper NameValuePairSeqHelper NamedNodeMap NamedValue NamespaceChangeListener NamespaceSupport Naming NamingContext NamingContextExt NamingContextExtHelper NamingContextExtHolder NamingContextExtOperations NamingContextExtPOA NamingContextHelper NamingContextHolder NamingContextOperations NamingContextPOA NamingEnumeration NamingEvent NamingException NamingExceptionEvent NamingListener NamingManager NamingSecurityException NavigationFilter NegativeArraySizeException NetPermission NetworkInterface NoClassDefFoundError NoConnectionPendingException NoContext NoContextHelper NoInitialContextException NoPermissionException NoRouteToHostException NoServant NoServantHelper NoSuchAlgorithmException NoSuchAttributeException NoSuchElementException NoSuchFieldError NoSuchFieldException NoSuchMethodError NoSuchMethodException NoSuchObjectException NoSuchPaddingException NoSuchProviderException Node NodeChangeEvent NodeChangeListener NodeDimensions NodeList NonReadableChannelException NonWritableChannelException NoninvertibleTransformException NotActiveException NotBoundException NotContextException NotEmpty NotEmptyHelper NotEmptyHolder NotFound NotFoundHelper NotFoundHolder NotFoundReason NotFoundReasonHelper NotFoundReasonHolder NotOwnerException NotSerializableException NotYetBoundException NotYetConnectedException Notation NullCipher NullPointerException Number NumberEditor NumberFormat NumberFormatException NumberFormatter NumberOfDocuments NumberOfInterveningJobs NumberUp NumberUpSupported NumericShaper OBJECT_NOT_EXIST OBJ_ADAPTER OMGVMCID ORB ORB ORBInitInfo ORBInitInfoOperations ORBInitializer ORBInitializerOperations ObjID Object Object ObjectAlreadyActive ObjectAlreadyActiveHelper ObjectChangeListener ObjectFactory ObjectFactoryBuilder ObjectHelper ObjectHolder ObjectIdHelper ObjectImpl ObjectImpl ObjectInput ObjectInputStream ObjectInputValidation ObjectNotActive ObjectNotActiveHelper ObjectOutput ObjectOutputStream ObjectStreamClass ObjectStreamConstants ObjectStreamException ObjectStreamField ObjectView Observable Observer OctetSeqHelper OctetSeqHolder Oid OpenType Operation OperationNotSupportedException Option OptionDialogBorder OptionPaneUI OptionalDataException OrientationRequested OrientationRequestedType OriginType Other OutOfMemoryError OutputDeviceAssigned OutputKeys OutputStream OutputStream OutputStream OutputStreamWriter OverlappingFileLockException OverlayLayout Owner PBEKey PBEKeySpec PBEParameterSpec PDLOverrideSupported PERSIST_STORE PKCS8EncodedKeySpec PKIXBuilderParameters PKIXCertPathBuilderResult PKIXCertPathChecker PKIXCertPathValidatorResult PKIXParameters POA POAHelper POAManager POAManagerOperations POAOperations PRIVATE_MEMBER PSSParameterSpec PUBLIC_MEMBER Package PackedColorModel PageAttributes PageFormat PageRanges Pageable PagesPerMinute PagesPerMinuteColor Paint PaintContext PaintEvent PaletteBorder PaletteCloseIcon Panel PanelUI Paper ParagraphAttribute ParagraphConstants ParagraphView ParagraphView Parameter ParameterBlock ParameterDescriptor ParameterMetaData ParameterMode ParameterModeHelper ParameterModeHolder ParseException ParsePosition Parser Parser Parser ParserAdapter ParserCallback ParserConfigurationException ParserDelegator ParserFactory PartialResultException PasswordAuthentication PasswordCallback PasswordView PasteAction Patch PathIterator Pattern PatternSyntaxException Permission Permission PermissionCollection Permissions PersistenceDelegate PhantomReference Pipe PipedInputStream PipedOutputStream PipedReader PipedWriter PixelGrabber PixelInterleavedSampleModel PlainDocument PlainView Point Point2D Policy Policy Policy PolicyError PolicyErrorCodeHelper PolicyErrorHelper PolicyErrorHolder PolicyFactory PolicyFactoryOperations PolicyHelper PolicyHolder PolicyListHelper PolicyListHolder PolicyNode PolicyOperations PolicyQualifierInfo PolicyTypeHelper Polygon PooledConnection Popup PopupFactory PopupMenu PopupMenuBorder PopupMenuEvent PopupMenuListener PopupMenuUI Port PortUnreachableException PortableRemoteObject PortableRemoteObjectDelegate Position PreferenceChangeEvent PreferenceChangeListener Preferences PreferencesFactory PreparedStatement PresentationDirection Principal Principal PrincipalHolder PrintEvent PrintException PrintGraphics PrintJob PrintJobAdapter PrintJobAttribute PrintJobAttributeEvent PrintJobAttributeListener PrintJobAttributeSet PrintJobEvent PrintJobListener PrintQuality PrintQualityType PrintRequestAttribute PrintRequestAttributeSet PrintService PrintServiceAttribute PrintServiceAttributeEvent PrintServiceAttributeListener PrintServiceAttributeSet PrintServiceLookup PrintStream PrintWriter Printable PrinterAbortException PrinterException PrinterGraphics PrinterIOException PrinterInfo PrinterIsAcceptingJobs PrinterJob PrinterLocation PrinterMakeAndModel PrinterMessageFromOperator PrinterMoreInfo PrinterMoreInfoManufacturer PrinterName PrinterResolution PrinterState PrinterStateReason PrinterStateReasons PrinterURI PrivateCredentialPermission PrivateKey PrivilegedAction PrivilegedActionException PrivilegedExceptionAction Process ProcessingInstruction ProfileDataException ProfileIdHelper ProgressBarUI ProgressMonitor ProgressMonitorInputStream Properties PropertyChangeEvent PropertyChangeListener PropertyChangeListenerProxy PropertyChangeSupport PropertyDescriptor PropertyEditor PropertyEditorManager PropertyEditorSupport PropertyPermission PropertyResourceBundle PropertyVetoException ProtectionDomain ProtocolException Provider ProviderException Proxy ProxyLazyValue PublicKey PushbackInputStream PushbackReader PutField QuadCurve2D QueuedJobCount RC2ParameterSpec RC5ParameterSpec READER REQUEST_PROCESSING_POLICY_ID RGBImageFilter RMIClassLoader RMIClassLoaderSpi RMIClientSocketFactory RMIFailureHandler RMISecurityException RMISecurityManager RMIServerSocketFactory RMISocketFactory RSAKey RSAKeyGenParameterSpec RSAMultiPrimePrivateCrtKey RSAMultiPrimePrivateCrtKeySpec RSAOtherPrimeInfo RSAPrivateCrtKey RSAPrivateCrtKeySpec RSAPrivateKey RSAPrivateKeySpec RSAPublicKey RSAPublicKeySpec RTFEditorKit RadioButtonBorder Random RandomAccess RandomAccessFile Raster RasterFormatException RasterOp ReadOnlyBufferException ReadableByteChannel Reader Receiver Rectangle Rectangle2D RectangularShape Ref RefAddr Reference Reference ReferenceQueue ReferenceUriSchemesSupported Referenceable ReferralException ReflectPermission RefreshFailedException Refreshable RegisterableService Registry RegistryHandler RemarshalException Remote RemoteCall RemoteException RemoteObject RemoteRef RemoteServer RemoteStub RenderContext RenderableImage RenderableImageOp RenderableImageProducer RenderedImage RenderedImageFactory Renderer RenderingHints RepaintManager ReplicateScaleFilter RepositoryIdHelper Request RequestInfo RequestInfoOperations RequestProcessingPolicy RequestProcessingPolicyOperations RequestProcessingPolicyValue RequestingUserName RescaleOp ResolutionSyntax ResolveResult Resolver ResourceBundle ResponseHandler Result Result ResultSet ResultSetMetaData ReverbType Robot RolloverButtonBorder RolloverButtonBorder RootPaneContainer RootPaneUI RoundRectangle2D RowMapper RowSet RowSetEvent RowSetInternal RowSetListener RowSetMetaData RowSetReader RowSetWriter RuleBasedCollator RunTime RunTimeOperations Runnable Runtime RuntimeException RuntimePermission SAXException SAXNotRecognizedException SAXNotSupportedException SAXParseException SAXParser SAXParserFactory SAXResult SAXSource SAXTransformerFactory SERVANT_RETENTION_POLICY_ID SERVICE_FORMATTED SQLData SQLException SQLInput SQLOutput SQLPermission SQLWarning SSLContext SSLContextSpi SSLException SSLHandshakeException SSLKeyException SSLPeerUnverifiedException SSLPermission SSLProtocolException SSLServerSocket SSLServerSocketFactory SSLSession SSLSessionBindingEvent SSLSessionBindingListener SSLSessionContext SSLSocket SSLSocketFactory STRING SUCCESSFUL SYNC_WITH_TRANSPORT SYSTEM_EXCEPTION SampleModel Savepoint ScatteringByteChannel SchemaViolationException ScrollBarUI ScrollPane ScrollPaneAdjustable ScrollPaneBorder ScrollPaneConstants ScrollPaneLayout ScrollPaneUI Scrollable Scrollbar SealedObject SearchControls SearchResult SecretKey SecretKeyFactory SecretKeyFactorySpi SecretKeySpec SecureClassLoader SecureRandom SecureRandomSpi Security SecurityException SecurityManager SecurityPermission Segment SelectableChannel SelectionKey Selector SelectorProvider Separator Separator SeparatorUI Sequence SequenceInputStream Sequencer Serializable SerializablePermission Servant ServantActivator ServantActivatorHelper ServantActivatorOperations ServantActivatorPOA ServantAlreadyActive ServantAlreadyActiveHelper ServantLocator ServantLocatorHelper ServantLocatorOperations ServantLocatorPOA ServantManager ServantManagerOperations ServantNotActive ServantNotActiveHelper ServantObject ServantRetentionPolicy ServantRetentionPolicyOperations ServantRetentionPolicyValue ServerCloneException ServerError ServerException ServerNotActiveException ServerRef ServerRequest ServerRequestInfo ServerRequestInfoOperations ServerRequestInterceptor ServerRequestInterceptorOperations ServerRuntimeException ServerSocket ServerSocketChannel ServerSocketFactory ServiceContext ServiceContextHelper ServiceContextHolder ServiceContextListHelper ServiceContextListHolder ServiceDetail ServiceDetailHelper ServiceIdHelper ServiceInformation ServiceInformationHelper ServiceInformationHolder ServicePermission ServiceRegistry ServiceUI ServiceUIFactory ServiceUnavailableException Set SetOfIntegerSyntax SetOverrideType SetOverrideTypeHelper Severity Shape ShapeGraphicAttribute SheetCollate Short ShortBuffer ShortBufferException ShortHolder ShortLookupTable ShortMessage ShortSeqHelper ShortSeqHolder Sides SidesType Signature SignatureException SignatureSpi SignedObject Signer SimpleAttributeSet SimpleBeanInfo SimpleDateFormat SimpleDoc SimpleFormatter SimpleTimeZone SinglePixelPackedSampleModel SingleSelectionModel SinkChannel Size2DSyntax SizeLimitExceededException SizeRequirements SizeSequence Skeleton SkeletonMismatchException SkeletonNotFoundException SliderUI Socket SocketAddress SocketChannel SocketException SocketFactory SocketHandler SocketImpl SocketImplFactory SocketOptions SocketPermission SocketSecurityException SocketTimeoutException SoftBevelBorder SoftReference SortedMap SortedSet SortingFocusTraversalPolicy Soundbank SoundbankReader SoundbankResource Source SourceChannel SourceDataLine SourceLocator SpinnerDateModel SpinnerListModel SpinnerModel SpinnerNumberModel SpinnerUI SplitPaneBorder SplitPaneUI Spring SpringLayout Stack StackOverflowError StackTraceElement StartTlsRequest StartTlsResponse State StateEdit StateEditable StateFactory Statement Statement StreamCorruptedException StreamHandler StreamPrintService StreamPrintServiceFactory StreamResult StreamSource StreamTokenizer Streamable StreamableValue StrictMath String StringBuffer StringBufferInputStream StringCharacterIterator StringContent StringHolder StringIndexOutOfBoundsException StringNameHelper StringReader StringRefAddr StringSelection StringSeqHelper StringSeqHolder StringTokenizer StringValueHelper StringWriter Stroke Struct StructMember StructMemberHelper Stub StubDelegate StubNotFoundException Style StyleConstants StyleContext StyleSheet StyledDocument StyledEditorKit StyledTextAction Subject SubjectDomainCombiner Subset SupportedValuesAttribute SwingConstants SwingPropertyChangeSupport SwingUtilities SyncFailedException SyncMode SyncScopeHelper Synthesizer SysexMessage System SystemColor SystemException SystemFlavorMap TAG_ALTERNATE_IIOP_ADDRESS TAG_CODE_SETS TAG_INTERNET_IOP TAG_JAVA_CODEBASE TAG_MULTIPLE_COMPONENTS TAG_ORB_TYPE TAG_POLICIES TCKind THREAD_POLICY_ID TRANSACTION_REQUIRED TRANSACTION_ROLLEDBACK TRANSIENT TRANSPORT_RETRY TabExpander TabSet TabStop TabableView TabbedPaneUI TableCellEditor TableCellRenderer TableColumn TableColumnModel TableColumnModelEvent TableColumnModelListener TableHeaderBorder TableHeaderUI TableModel TableModelEvent TableModelListener TableUI TableView Tag TagElement TaggedComponent TaggedComponentHelper TaggedComponentHolder TaggedProfile TaggedProfileHelper TaggedProfileHolder TargetDataLine Templates TemplatesHandler Text TextAction TextArea TextAttribute TextComponent TextEvent TextField TextFieldBorder TextHitInfo TextInputCallback TextLayout TextListener TextMeasurer TextOutputCallback TextSyntax TextUI TexturePaint Thread ThreadDeath ThreadGroup ThreadLocal ThreadPolicy ThreadPolicyOperations ThreadPolicyValue Throwable Tie TileObserver Time TimeLimitExceededException TimeZone Timer Timer TimerTask Timestamp TitledBorder TitledBorderUIResource ToggleButtonBorder ToggleButtonBorder ToggleButtonModel TooManyListenersException ToolBarBorder ToolBarUI ToolTipManager ToolTipUI Toolkit Track TransactionRequiredException TransactionRolledbackException TransactionService TransferHandler Transferable TransformAttribute Transformer TransformerConfigurationException TransformerException TransformerFactory TransformerFactoryConfigurationError TransformerHandler Transmitter Transparency TreeCellEditor TreeCellRenderer TreeControlIcon TreeExpansionEvent TreeExpansionListener TreeFolderIcon TreeLeafIcon TreeMap TreeModel TreeModelEvent TreeModelListener TreeNode TreePath TreeSelectionEvent TreeSelectionListener TreeSelectionModel TreeSet TreeUI TreeWillExpandListener TrustAnchor TrustManager TrustManagerFactory TrustManagerFactorySpi Type Type Type Type Type Type Type TypeCode TypeCodeHolder TypeMismatch TypeMismatch TypeMismatch TypeMismatchHelper TypeMismatchHelper Types UID UIDefaults UIManager UIResource UIResource UIResource UIResource UIResource UIResource UIResource ULongLongSeqHelper ULongLongSeqHolder ULongSeqHelper ULongSeqHolder UNKNOWN UNSUPPORTED_POLICY UNSUPPORTED_POLICY_VALUE URI URIException URIResolver URISyntax URISyntaxException URL URL URLClassLoader URLConnection URLDecoder URLEncoder URLStreamHandler URLStreamHandlerFactory URLStringHelper USER_EXCEPTION UShortSeqHelper UShortSeqHolder UTFDataFormatException UndeclaredThrowableException UnderlineAction UndoManager UndoableEdit UndoableEditEvent UndoableEditListener UndoableEditSupport UnexpectedException UnicastRemoteObject UnicodeBlock UnionMember UnionMemberHelper UnknownEncoding UnknownEncodingHelper UnknownError UnknownException UnknownGroupException UnknownHostException UnknownHostException UnknownObjectException UnknownServiceException UnknownTag UnknownUserException UnknownUserExceptionHelper UnknownUserExceptionHolder UnmappableCharacterException UnmarshalException UnmodifiableSetException UnrecoverableKeyException Unreferenced UnresolvedAddressException UnresolvedPermission UnsatisfiedLinkError UnsolicitedNotification UnsolicitedNotificationEvent UnsolicitedNotificationListener UnsupportedAddressTypeException UnsupportedAudioFileException UnsupportedCallbackException UnsupportedCharsetException UnsupportedClassVersionError UnsupportedEncodingException UnsupportedFlavorException UnsupportedLookAndFeelException UnsupportedOperationException UserException Util UtilDelegate Utilities VMID VM_ABSTRACT VM_CUSTOM VM_NONE VM_TRUNCATABLE ValueBase ValueBaseHelper ValueBaseHolder ValueFactory ValueHandler ValueMember ValueMemberHelper VariableHeightLayoutCache Vector VerifyError VersionSpecHelper VetoableChangeListener VetoableChangeListenerProxy VetoableChangeSupport View ViewFactory ViewportLayout ViewportUI VirtualMachineError Visibility VisibilityHelper VoiceStatus Void VolatileImage WCharSeqHelper WCharSeqHolder WStringSeqHelper WStringSeqHolder WStringValueHelper WeakHashMap WeakReference Window WindowAdapter WindowConstants WindowEvent WindowFocusListener WindowListener WindowStateListener WrappedPlainView WritableByteChannel WritableRaster WritableRenderedImage WriteAbortedException Writer WrongAdapter WrongAdapterHelper WrongPolicy WrongPolicyHelper WrongTransaction WrongTransactionHelper WrongTransactionHolder X500Principal X500PrivateCredential X509CRL X509CRLEntry X509CRLSelector X509CertSelector X509Certificate X509Certificate X509EncodedKeySpec X509Extension X509KeyManager X509TrustManager XAConnection XADataSource XAException XAResource XMLDecoder XMLEncoder XMLFilter XMLFilterImpl XMLFormatter XMLReader XMLReaderAdapter XMLReaderFactory Xid ZipEntry ZipException ZipFile ZipInputStream ZipOutputStream ZoneView _BindingIteratorImplBase _BindingIteratorStub _DynAnyFactoryStub _DynAnyStub _DynArrayStub _DynEnumStub _DynFixedStub _DynSequenceStub _DynStructStub _DynUnionStub _DynValueStub _IDLTypeStub _NamingContextExtStub _NamingContextImplBase _NamingContextStub _PolicyStub _Remote_Stub _ServantActivatorStub _ServantLocatorStub"
list_java'2d1'2e4'2e2'2dkeywords = Set.fromList $ words $ "abstract assert break case catch class continue default do else extends false finally for goto if implements import instanceof interface native new null package private protected public return super strictfp switch synchronized this throws throw transient true try volatile while"
list_java'2d1'2e4'2e2'2dtypes = Set.fromList $ words $ "boolean byte char const double final float int long short static void"
list_jsp'2dreserved'2dwords = Set.fromList $ words $ "and eq gt true instanceof or ne le false empty not lt ge null div mod"

regex_'3c'25'40'5cs'2a'5ba'2dzA'2dZ0'2d9'5f'5c'2e'5d'2a = compileRegex "<%@\\s*[a-zA-Z0-9_\\.]*"
regex_'3c'5cs'2ajsp'3a'28declaration'7cexpression'7cscriptlet'29'5cs'2a'3e = compileRegex "<\\s*jsp:(declaration|expression|scriptlet)\\s*>"
regex_'3c'5cs'2a'5c'2f'3fs'2ajsp'3a'5ba'2dzA'2dZ0'2d9'5f'5c'2e'5d'2a = compileRegex "<\\s*\\/?s*jsp:[a-zA-Z0-9_\\.]*"
regex_'3c'25'28'21'7c'3d'29'3f = compileRegex "<%(!|=)?"
regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5c'24'3f'5ba'2dzA'2dZ0'2d9'5f'5d'2a'3a'5c'24'3f'5ba'2dzA'2dZ0'2d9'5f'5d'2a = compileRegex "<\\s*\\/?\\s*\\$?[a-zA-Z0-9_]*:\\$?[a-zA-Z0-9_]*"
regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5ba'2dzA'2dZ0'2d9'5f'5d'2a = compileRegex "<\\s*\\/?\\s*[a-zA-Z0-9_]*"
regex_'5cs'2a'3d'5cs'2a = compileRegex "\\s*=\\s*"
regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5c'24'3f'5cw'2a'3a'5c'24'3f'5cw'2a = compileRegex "<\\s*\\/?\\s*\\$?\\w*:\\$?\\w*"
regex_'5cs'2a'5c'2f'3f'5cs'2a'3e = compileRegex "\\s*\\/?\\s*>"
regex_'5c'2f'3f'3e = compileRegex "\\/?>"
regex_'2f'2f'5cs'2aBEGIN'2e'2a'24 = compileRegex "//\\s*BEGIN.*$"
regex_'2f'2f'5cs'2aEND'2e'2a'24 = compileRegex "//\\s*END.*$"
regex_'28'22'7c'26quot'3b'7c'26'2334'3b'29 = compileRegex "(\"|&quot;|&#34;)"
regex_'28'27'7c'26'2339'3b'29 = compileRegex "('|&#39;)"
regex_'5cs'2a'23'3f'2d'3f'5f'3f'5c'2e'3f'5ba'2dzA'2dZ0'2d9'5d'2a = compileRegex "\\s*#?-?_?\\.?[a-zA-Z0-9]*"
regex_'5cs'2b = compileRegex "\\s+"
regex_'5c'2f'2a'2d'2d'3e = compileRegex "\\/*-->"

defaultAttributes = [("Normal","Normal Text"),("Jsp Standard Directive","Jsp Param Name"),("Jsp Xml Directive","Jsp Param Name"),("Jsp Comment","Jsp Comment"),("Jsp Custom Tag","Identifier"),("Jsp Standard Directive Value","Jsp Param Value"),("Jsp Xml Directive Value","Jsp Param Value"),("Jsp Custom Tag Value","Normal Text"),("Jsp Double Quoted Param Value","Jsp Param Value"),("Jsp Single Quoted Param Value","Jsp Param Value"),("Jsp Double Quoted Custom Tag Value","Types"),("Jsp Single Quoted Custom Tag Value","Types"),("Jsp Scriptlet","Normal Text"),("Jsp Expression","Normal Text"),("Java Single-Line Comment","Java Comment"),("Java Multi-Line Comment","Java Comment"),("Java String","String"),("Html Attribute","Identifier"),("Html Value","Types"),("Html Double Quoted Value","Types"),("Html Single Quoted Value","Types"),("Html Unquoted Value","Types"),("Html Comment","Html Comment")]

parseRules "Normal" = 
  do (attr, result) <- (((pRegExpr regex_'3c'25'40'5cs'2a'5ba'2dzA'2dZ0'2d9'5f'5c'2e'5d'2a >>= withAttribute "Jsp Directive") >>~ pushContext "Jsp Standard Directive")
                        <|>
                        ((pRegExpr regex_'3c'5cs'2ajsp'3a'28declaration'7cexpression'7cscriptlet'29'5cs'2a'3e >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pRegExpr regex_'3c'5cs'2a'5c'2f'3fs'2ajsp'3a'5ba'2dzA'2dZ0'2d9'5f'5c'2e'5d'2a >>= withAttribute "Jsp Directive") >>~ pushContext "Jsp Xml Directive")
                        <|>
                        ((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pString False "<!--" >>= withAttribute "Html Comment") >>~ pushContext "Html Comment")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression")
                        <|>
                        ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5c'24'3f'5ba'2dzA'2dZ0'2d9'5f'5d'2a'3a'5c'24'3f'5ba'2dzA'2dZ0'2d9'5f'5d'2a >>= withAttribute "Keyword") >>~ pushContext "Jsp Custom Tag")
                        <|>
                        ((pString False "<![CDATA[" >>= withAttribute "Normal Text"))
                        <|>
                        ((pString False "]]>" >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5ba'2dzA'2dZ0'2d9'5f'5d'2a >>= withAttribute "Normal Text") >>~ pushContext "Html Attribute"))
     return (attr, result)

parseRules "Jsp Standard Directive" = 
  do (attr, result) <- (((pDetect2Chars False '%' '>' >>= withAttribute "Jsp Directive") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute "Normal Text") >>~ pushContext "Jsp Standard Directive Value")
                        <|>
                        ((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression")
                        <|>
                        ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5c'24'3f'5cw'2a'3a'5c'24'3f'5cw'2a >>= withAttribute "Keyword") >>~ pushContext "Jsp Custom Tag"))
     return (attr, result)

parseRules "Jsp Xml Directive" = 
  do (attr, result) <- (((pRegExpr regex_'5cs'2a'5c'2f'3f'5cs'2a'3e >>= withAttribute "Jsp Directive") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute "Normal Text") >>~ pushContext "Jsp Xml Directive Value")
                        <|>
                        ((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression"))
     return (attr, result)

parseRules "Jsp Comment" = 
  do (attr, result) <- ((pString False "--%>" >>= withAttribute "Jsp Comment") >>~ (popContext))
     return (attr, result)

parseRules "Jsp Custom Tag" = 
  do (attr, result) <- (((pRegExpr regex_'5c'2f'3f'3e >>= withAttribute "Keyword") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute "Normal Text") >>~ pushContext "Jsp Custom Tag Value")
                        <|>
                        ((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression"))
     return (attr, result)

parseRules "Jsp Standard Directive Value" = 
  do (attr, result) <- (((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "Jsp Param Value") >>~ pushContext "Jsp Double Quoted Param Value")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Jsp Param Value") >>~ pushContext "Jsp Single Quoted Param Value")
                        <|>
                        ((pDetect2Chars False '%' '>' >>= withAttribute "Jsp Directive") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "Jsp Xml Directive Value" = 
  do (attr, result) <- (((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "Jsp Param Value") >>~ pushContext "Jsp Double Quoted Param Value")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Jsp Param Value") >>~ pushContext "Jsp Single Quoted Param Value")
                        <|>
                        ((pRegExpr regex_'5cs'2a'5c'2f'3f'5cs'2a'3e >>= withAttribute "Jsp Directive") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "Jsp Custom Tag Value" = 
  do (attr, result) <- (((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "Types") >>~ pushContext "Jsp Double Quoted Custom Tag Value")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Types") >>~ pushContext "Jsp Single Quoted Custom Tag Value")
                        <|>
                        ((pRegExpr regex_'5c'2f'3f'3e >>= withAttribute "Normal Text") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "Jsp Double Quoted Param Value" = 
  do (attr, result) <- (((pDetectChar False '"' >>= withAttribute "Jsp Param Value") >>~ (popContext >> popContext))
                        <|>
                        ((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression"))
     return (attr, result)

parseRules "Jsp Single Quoted Param Value" = 
  do (attr, result) <- (((pDetectChar False '\'' >>= withAttribute "Jsp Param Value") >>~ (popContext >> popContext))
                        <|>
                        ((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression"))
     return (attr, result)

parseRules "Jsp Double Quoted Custom Tag Value" = 
  do (attr, result) <- (((pDetectChar False '"' >>= withAttribute "Types") >>~ (popContext >> popContext))
                        <|>
                        ((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression"))
     return (attr, result)

parseRules "Jsp Single Quoted Custom Tag Value" = 
  do (attr, result) <- (((pDetectChar False '\'' >>= withAttribute "Types") >>~ (popContext >> popContext))
                        <|>
                        ((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression"))
     return (attr, result)

parseRules "Jsp Scriptlet" = 
  do (attr, result) <- (((pDetect2Chars False '%' '>' >>= withAttribute "Jsp Scriptlet") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'3c'5cs'2ajsp'3a'28declaration'7cexpression'7cscriptlet'29'5cs'2a'3e >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_java'2d1'2e4'2e2'2dkeywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_jsp'2dreserved'2dwords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_java'2d1'2e4'2e2'2dtypes >>= withAttribute "Types"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_java'2d1'2e4'2e2'2dclasses >>= withAttribute "Java 1.4.2 Classes"))
                        <|>
                        (withChildren (pFloat >>= withAttribute "Float") ((pAnyChar "fF" >>= withAttribute "Float")))
                        <|>
                        ((pHlCOct >>= withAttribute "Octal"))
                        <|>
                        ((pHlCHex >>= withAttribute "Hex"))
                        <|>
                        (withChildren (pInt >>= withAttribute "Decimal") (((pString False "ULL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LUL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LLU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "UL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "U" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "L" >>= withAttribute "Decimal"))))
                        <|>
                        ((pHlCChar >>= withAttribute "Char"))
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'2f'2f'5cs'2aBEGIN'2e'2a'24 >>= withAttribute "Decimal"))
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'2f'2f'5cs'2aEND'2e'2a'24 >>= withAttribute "Decimal"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "Java String")
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Normal Text"))
                        <|>
                        ((pAnyChar "!%&()+,-<=>?[]^{|}~" >>= withAttribute "Symbol"))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Java Comment") >>~ pushContext "Java Single-Line Comment")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Java Comment") >>~ pushContext "Java Multi-Line Comment"))
     return (attr, result)

parseRules "Jsp Expression" = 
  do (attr, result) <- (((pString False "'${'" >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Jsp Scriptlet") >>~ (popContext))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_java'2d1'2e4'2e2'2dkeywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_jsp'2dreserved'2dwords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_java'2d1'2e4'2e2'2dtypes >>= withAttribute "Types"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_java'2d1'2e4'2e2'2dclasses >>= withAttribute "Java 1.4.2 Classes"))
                        <|>
                        (withChildren (pFloat >>= withAttribute "Float") ((pAnyChar "fF" >>= withAttribute "Float")))
                        <|>
                        ((pHlCOct >>= withAttribute "Octal"))
                        <|>
                        ((pHlCHex >>= withAttribute "Hex"))
                        <|>
                        (withChildren (pInt >>= withAttribute "Decimal") (((pString False "ULL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LUL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LLU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "UL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "U" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "L" >>= withAttribute "Decimal"))))
                        <|>
                        ((pHlCChar >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "Java String")
                        <|>
                        ((pAnyChar "!%&()+,-<=>?[]^{|}~" >>= withAttribute "Symbol")))
     return (attr, result)

parseRules "Java Single-Line Comment" = 
  pzero

parseRules "Java Multi-Line Comment" = 
  do (attr, result) <- ((pDetect2Chars False '*' '/' >>= withAttribute "Java Comment") >>~ (popContext))
     return (attr, result)

parseRules "Java String" = 
  do (attr, result) <- (((pDetect2Chars False '\\' '"' >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules "Html Attribute" = 
  do (attr, result) <- (((pRegExpr regex_'5c'2f'3f'3e >>= withAttribute "Normal Text") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute "Normal Text") >>~ pushContext "Html Value")
                        <|>
                        ((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression"))
     return (attr, result)

parseRules "Html Value" = 
  do (attr, result) <- (((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression")
                        <|>
                        ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5c'24'3f'5cw'2a'3a'5c'24'3f'5cw'2a >>= withAttribute "Keyword") >>~ pushContext "Jsp Custom Tag")
                        <|>
                        ((pRegExpr regex_'28'22'7c'26quot'3b'7c'26'2334'3b'29 >>= withAttribute "Types") >>~ pushContext "Html Double Quoted Value")
                        <|>
                        ((pRegExpr regex_'28'27'7c'26'2339'3b'29 >>= withAttribute "Types") >>~ pushContext "Html Single Quoted Value")
                        <|>
                        ((pRegExpr regex_'5cs'2a'23'3f'2d'3f'5f'3f'5c'2e'3f'5ba'2dzA'2dZ0'2d9'5d'2a >>= withAttribute "Types") >>~ pushContext "Html Unquoted Value")
                        <|>
                        ((pRegExpr regex_'5c'2f'3f'3e >>= withAttribute "Normal Text") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "Html Double Quoted Value" = 
  do (attr, result) <- (((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression")
                        <|>
                        ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5c'24'3f'5cw'2a'3a'5c'24'3f'5cw'2a >>= withAttribute "Keyword") >>~ pushContext "Jsp Custom Tag")
                        <|>
                        ((pRegExpr regex_'28'22'7c'26quot'3b'7c'26'2334'3b'29 >>= withAttribute "Types") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "Html Single Quoted Value" = 
  do (attr, result) <- (((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression")
                        <|>
                        ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5c'24'3f'5cw'2a'3a'5c'24'3f'5cw'2a >>= withAttribute "Keyword") >>~ pushContext "Jsp Custom Tag")
                        <|>
                        ((pRegExpr regex_'28'27'7c'26'2339'3b'29 >>= withAttribute "Types") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "Html Unquoted Value" = 
  do (attr, result) <- (((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression")
                        <|>
                        ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5c'24'3f'5cw'2a'3a'5c'24'3f'5cw'2a >>= withAttribute "Keyword") >>~ pushContext "Jsp Custom Tag")
                        <|>
                        ((pRegExpr regex_'5c'2f'3f'3e >>= withAttribute "Normal Text") >>~ (popContext >> popContext >> popContext))
                        <|>
                        ((pRegExpr regex_'5cs'2b >>= withAttribute "Types") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "Html Comment" = 
  do (attr, result) <- (((pString False "<%--" >>= withAttribute "Jsp Comment") >>~ pushContext "Jsp Comment")
                        <|>
                        ((pRegExpr regex_'3c'25'28'21'7c'3d'29'3f >>= withAttribute "Jsp Scriptlet") >>~ pushContext "Jsp Scriptlet")
                        <|>
                        ((pDetect2Chars False '$' '{' >>= withAttribute "Jsp Expression") >>~ pushContext "Jsp Expression")
                        <|>
                        ((pRegExpr regex_'5c'2f'2a'2d'2d'3e >>= withAttribute "Html Comment") >>~ (popContext)))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
