{- This module was generated from data in the Kate syntax highlighting file pike.xml, version 1.07,
   by  Paul Pogonyshev -}

module Text.Highlighting.Kate.Syntax.Pike ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Pike"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.pike"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Pike" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Pike",["Normal"])], synStLanguage = "Pike", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "String" -> (popContext) >> pEndLine
    "Line Comment" -> (popContext) >> pEndLine
    "Block Comment" -> return () >> pHandleEndLine
    "Preprocessor" -> (popContext) >> pEndLine
    "Outscoped" -> return () >> pHandleEndLine
    "Outscoped intern" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Builtin Function","fu"),("Data Type","dt"),("Decimal","dv"),("Hex","bn"),("Octal","bn"),("Binary","bn"),("Float","fl"),("Char","ch"),("String","st"),("String Char","ch"),("Comment","co"),("Note","al"),("Preprocessor","ot"),("Preprocessor Lib","st")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "break case class continue default do else for foreach if return switch while"
list_types = Set.fromList $ words $ "array float function int mapping mixed multiset> object program static string void"
list_builtins = Set.fromList $ words $ "catch gauge sscanf typeof"

regex_'60'28'5b'5c'2b'5c'2d'5c'2a'2f'25'7e'26'5c'7c'5e'5d'7c'5b'21'3d'3c'3e'5d'3d'7c'3c'3c'3f'7c'3e'3e'3f'7c'28'5c'5b'5c'5d'7c'2d'3e'29'3d'3f'29 = compileRegex "`([\\+\\-\\*/%~&\\|^]|[!=<>]=|<<?|>>?|(\\[\\]|->)=?)"
regex_0'5bbB'5d'5b01'5d'2b = compileRegex "0[bB][01]+"
regex_'23'5cs'2aif'5cs'2b0 = compileRegex "#\\s*if\\s+0"
regex_'5c'5cd'5b0'2d9'5d'2b = compileRegex "\\\\d[0-9]+"
regex_'28FIXME'7cTODO'7cNOT'28IC'29'3fE'29'3a'3f = compileRegex "(FIXME|TODO|NOT(IC)?E):?"
regex_'23'5cs'2aif = compileRegex "#\\s*if"
regex_'23'5cs'2a'28endif'7celif'7celse'29 = compileRegex "#\\s*(endif|elif|else)"
regex_'23'5cs'2aendif = compileRegex "#\\s*endif"

defaultAttributes = [("Normal","Normal Text"),("String","String"),("Line Comment","Comment"),("Block Comment","Comment"),("Preprocessor","Preprocessor"),("Outscoped","Comment"),("Outscoped intern","Comment")]

parseRules "Normal" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute "Data Type"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_builtins >>= withAttribute "Builtin Function"))
                        <|>
                        ((pRegExpr regex_'60'28'5b'5c'2b'5c'2d'5c'2a'2f'25'7e'26'5c'7c'5e'5d'7c'5b'21'3d'3c'3e'5d'3d'7c'3c'3c'3f'7c'3e'3e'3f'7c'28'5c'5b'5c'5d'7c'2d'3e'29'3d'3f'29 >>= withAttribute "Builtin Function"))
                        <|>
                        ((pFloat >>= withAttribute "Float"))
                        <|>
                        ((pRegExpr regex_0'5bbB'5d'5b01'5d'2b >>= withAttribute "Binary"))
                        <|>
                        ((pHlCOct >>= withAttribute "Octal"))
                        <|>
                        ((pHlCHex >>= withAttribute "Hex"))
                        <|>
                        ((pInt >>= withAttribute "Decimal"))
                        <|>
                        ((pHlCChar >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Line Comment")
                        <|>
                        ((pDetect2Chars False '#' '!' >>= withAttribute "Comment") >>~ pushContext "Line Comment")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Block Comment")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'5cs'2b0 >>= withAttribute "Preprocessor") >>~ pushContext "Outscoped")
                        <|>
                        ((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Preprocessor") >>~ pushContext "Preprocessor"))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pRegExpr regex_'5c'5cd'5b0'2d9'5d'2b >>= withAttribute "String Char"))
                        <|>
                        ((pHlCStringChar >>= withAttribute "String Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pLineContinue >>= withAttribute "String")))
     return (attr, result)

parseRules "Line Comment" = 
  do (attr, result) <- ((pRegExpr regex_'28FIXME'7cTODO'7cNOT'28IC'29'3fE'29'3a'3f >>= withAttribute "Note"))
     return (attr, result)

parseRules "Block Comment" = 
  do (attr, result) <- (((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'28FIXME'7cTODO'7cNOT'28IC'29'3fE'29'3a'3f >>= withAttribute "Note")))
     return (attr, result)

parseRules "Preprocessor" = 
  do (attr, result) <- (((pRangeDetect '"' '"' >>= withAttribute "Preprocessor Lib"))
                        <|>
                        ((pRangeDetect '<' '>' >>= withAttribute "Preprocessor Lib"))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Line Comment")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Block Comment")
                        <|>
                        ((pLineContinue >>= withAttribute "Preprocessor")))
     return (attr, result)

parseRules "Outscoped" = 
  do (attr, result) <- (((pRegExpr regex_'28FIXME'7cTODO'7cNOT'28IC'29'3fE'29'3a'3f >>= withAttribute "Note"))
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Block Comment")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute "Comment") >>~ pushContext "Outscoped intern")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2a'28endif'7celif'7celse'29 >>= withAttribute "Preprocessor") >>~ (popContext)))
     return (attr, result)

parseRules "Outscoped intern" = 
  do (attr, result) <- (((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Block Comment")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute "Comment") >>~ pushContext "Outscoped intern")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute "Comment") >>~ (popContext)))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
