{- This module was generated from data in the Kate syntax
   highlighting file lua.xml, version 1.04, by  -}

module Text.Highlighting.Kate.Syntax.Lua
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Lua"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.lua"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Lua" }
  context <- currentContext <|> (pushContext "Base" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Lua",["Base"])], synStLanguage = "Lua", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Base" -> pushContext "Normal" >> return ()
    "Normal" -> return ()
    "Comment" -> (popContext) >> pEndLine
    "Block Comment" -> return ()
    "String_single" -> pushContext "Error" >> return ()
    "String_double" -> pushContext "Error" >> return ()
    "String_block" -> return ()
    "Error" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "and function in local not or"
list_control = Set.fromList $ words $ "break do else elseif end for if repeat return then until while"
list_pseudo'2dvariables = Set.fromList $ words $ "nil false true"
list_basefunc = Set.fromList $ words $ "string.byte string.char string.find string.len string.lower string.rep string.sub string.upper string.format string.gfind string.gsub table.concat table.getn table.sort table.insert table.remove table.setn math.abs math.sin math.cos math.tan math.asin math.acos math.atan math.atan2 math.ceil math.floor math.mod math.frexp math.ldexp math.squrt math.min math.max math.log math.log10 math.exp math.deg math.rad math.random math.randomseed io.close io.flush io.input io.lines io.open io.output io.read io.stderr io.stdin io.stdout io.tmpfile io.write os.clock os.date os.difftime os.execute os.exit os.getenv os.remove os.rename os.setlocale os.time os.tmpname debug.getinfo debug.getlocal debug.setlocal debug.sethook debug.gethook assert collectgarbage dofile error next print rawget rawset tonumber tostring type _ALERT _ERRORMESSAGE call getmetatable gcinfo ipairs loadfile loadstring pairs pcall require LUA_PATH setmetatable _LOADED _VERSION gettagmethod globals newtag setglobal settag settagmethod setlinehook getglobals copytagmethods dostring getglobal tag setglobals unpack exit readfrom writeto appendto read write getinfo getlocal setlocal setcallhook tinsert tremove flush seek setlocale execute remove rename tmpname getenv getn sort table.foreach table.foreachi foreach foreachi abs sin cos tan asin acos atan atan2 ceil floor mod frexp ldexp squrt min max log log10 exp deg rad random randomseed strlen strsub strlower strupper strchar strrep ascii strbyte format strfind gsub openfile closefile date clock cgilua cgilua.lp.translate cgilua.contentheader cgilua.script_file cgilua.header cgilua.script_path cgilua.htmlheader cgilua.script_pdir cgilua.redirect cgilua.script_vdir cgilua.mkabsoluteurl cgilua.script_vpath cgilua.mkurlpath cgilua.servervariable cgilua.put cgilua.urlpath cgilua.handlelp cgilua.errorlog cgilua.lp.compile cgilua.seterrorhandler cgilua.lp.include cgilua.seterroroutput cgilua.lp.setcompatmode cgilua.addclosefunction cgilua.lp.setoutfunc cgilua.addopenfunction cgilua.addscripthandler cgilua.addscripthandler cgilua.buildprocesshandler cgilua.setmaxfilesize cgilua.setmaxinput cgilua.urlcode.encodetable cgilua.urlcode.escape cgilua.urlcode.parsequery cgilua.urlcode.unescape cgilua.urlcode.insertfield cgilua.setoutfunc cgilua.addopenfunction cgilua.doif cgilua.doscript cgilua.pack cgilua.splitpath cgilua.cookies.get cgilua.cookies.set cgilua.cookies.sethtml cgilua.cookies.delete cgilua.serialize cgilua.session.close cgilua.session.data cgilua.session.load cgilua.session.new cgilua.session.open cgilua.session.save cgilua.session.setsessiondir cgilua.session.delete cgilua.session cgilua.cookies numrows connect close fetch getcolnames getcoltypes commit rollback setautocommit lfs lfs.attributes lfs.chdir lfs.currentdir lfs.dir lfs.lock lfs.mkdir lfs.rmdir lfs.touch lfs.unlock zip zip.open zip.openfile files seek close lines"
list_attention = Set.fromList $ words $ "TODO FIXME NOTE"
list_deprecated = Set.fromList $ words $ "table.foreach table.foreachi foreach foreachi"

regex_'23'21'2e'2a'24 = compileRegex "#!.*$"
regex_'5cbfunction'5cb = compileRegex "\\bfunction\\b"
regex_'5cbelse'5cb = compileRegex "\\belse\\b"
regex_'5cbelseif'5cb = compileRegex "\\belseif\\b"
regex_'5cbdo'5cb = compileRegex "\\bdo\\b"
regex_'5cbif'5cb = compileRegex "\\bif\\b"
regex_'5cbend'5cb = compileRegex "\\bend\\b"
regex_'5cb'5cd'2a'5c'2e'3f'5cd'2a'28e'7ce'5c'2d'7ce'5c'2b'29'3f'5cd'2b'5cb = compileRegex "\\b\\d*\\.?\\d*(e|e\\-|e\\+)?\\d+\\b"
regex_'5cb'2d'3f0'5bxX'5d'5b0'2d9a'2dfA'2dF'5d'2b'5cb = compileRegex "\\b-?0[xX][0-9a-fA-F]+\\b"
regex_'5cb'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'28'3f'3d'5cs'2a'28'5b'28'7b'27'22'5d'7c'5c'5b'5c'5b'29'29'5cb = compileRegex "\\b[a-zA-Z_][a-zA-Z0-9_]*(?=\\s*([({'\"]|\\[\\[))\\b"
regex_'5cb'5bA'2dZ'5f'5d'5bA'2dZ0'2d9'5f'5d'2a'5cb = compileRegex "\\b[A-Z_][A-Z0-9_]*\\b"
regex_'5cb'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5cb = compileRegex "\\b[a-zA-Z_][a-zA-Z0-9_]*\\b"
regex_'5c'5c'28a'7cb'7cf'7cn'7cr'7ct'7cv'7c'5c'5c'7c'22'7c'5c'27'7c'5b'7c'5d'29 = compileRegex "\\\\(a|b|f|n|r|t|v|\\\\|\"|\\'|[|])"
regex_'5c'5c'5babfnrtv'27'22'5c'5c'5c'5b'5c'5d'5d = compileRegex "\\\\[abfnrtv'\"\\\\\\[\\]]"

defaultAttributes = [("Base",CommentTok),("Normal",NormalTok),("Comment",CommentTok),("Block Comment",CommentTok),("String_single",StringTok),("String_double",StringTok),("String_block",StringTok),("Error",ErrorTok)]

parseRules "Base" =
  (((pColumn 0 >> pRegExpr regex_'23'21'2e'2a'24 >>= withAttribute CommentTok) >>~ pushContext "Normal")
   <|>
   (pushContext "Normal" >> currentContext >>= parseRules))

parseRules "Normal" =
  (((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_deprecated >>= withAttribute ErrorTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExprDynamic "--\\[(=*)\\[" >>= withAttribute CommentTok) >>~ pushContext "Block Comment")
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pRegExprDynamic "\\[(=*)\\[" >>= withAttribute StringTok) >>~ pushContext "String_block")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "String_single")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String_double")
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_basefunc >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5cbfunction'5cb >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_pseudo'2dvariables >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbelse'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbelseif'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbdo'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbif'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbend'5cb >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_control >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5cb'5cd'2a'5c'2e'3f'5cd'2a'28e'7ce'5c'2d'7ce'5c'2b'29'3f'5cd'2b'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cb'2d'3f0'5bxX'5d'5b0'2d9a'2dfA'2dF'5d'2b'5cb >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cb'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'28'3f'3d'5cs'2a'28'5b'28'7b'27'22'5d'7c'5c'5b'5c'5b'29'29'5cb >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cb'5bA'2dZ'5f'5d'5bA'2dZ0'2d9'5f'5d'2a'5cb >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5cb >>= withAttribute KeywordTok))
   <|>
   ((pDetect2Chars False '!' '=' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '-' '=' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '+' '=' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '+' '+' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '.' '=' >>= withAttribute ErrorTok))
   <|>
   ((pAnyChar "[]().=~+-*/^><#;" >>= withAttribute OtherTok)))

parseRules "Comment" =
  (((pDetect2Chars False '-' '-' >>= withAttribute AlertTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_attention >>= withAttribute AlertTok)))

parseRules "Block Comment" =
  (((pRegExprDynamic "\\]%1\\]" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute AlertTok))
   <|>
   ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\\"" list_attention >>= withAttribute AlertTok)))

parseRules "String_single" =
  (((pRegExpr regex_'5c'5c'28a'7cb'7cf'7cn'7cr'7ct'7cv'7c'5c'5c'7c'22'7c'5c'27'7c'5b'7c'5d'29 >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "String_double" =
  (((pRegExpr regex_'5c'5c'5babfnrtv'27'22'5c'5c'5c'5b'5c'5d'5d >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "String_block" =
  (((pRegExpr regex_'5c'5c'28a'7cb'7cf'7cn'7cr'7ct'7cv'7c'5c'5c'7c'22'7c'5c'27'7c'5b'7c'5d'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExprDynamic "\\]%1\\]" >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Error" =
  pzero

parseRules "" = parseRules "Base"

parseRules x = fail $ "Unknown context" ++ x
