{- This module was generated from data in the Kate syntax
   highlighting file sql-mysql.xml, version 1.15, by Shane Wright (me@shanewright.co.uk) -}

module Text.Highlighting.Kate.Syntax.SqlMysql
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "SQL (MySQL)"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.sql;*.SQL;*.ddl;*.DDL"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("SQL (MySQL)","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("SQL (MySQL)","Normal") -> return ()
      ("SQL (MySQL)","String") -> return ()
      ("SQL (MySQL)","String2") -> return ()
      ("SQL (MySQL)","Name") -> return ()
      ("SQL (MySQL)","SingleLineComment") -> (popContext) >> pEndLine
      ("SQL (MySQL)","MultiLineComment") -> return ()
      ("SQL (MySQL)","Preprocessor") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "access add all alter analyze and as asc auto_increment bdb berkeleydb between both by cascade case change charset column columns constraint create cross current_date current_time current_timestamp database databases day_hour day_minute day_second dec default delayed delete desc describe distinct distinctrow drop else enclosed escaped exists explain fields for foreign from fulltext function grant group having high_priority if ignore in index infile inner innodb insert interval into is join key keys kill leading left like limit lines load lock low_priority master_server_id match mrg_myisam natural national not null numeric on optimize option optionally or order outer outfile partial precision primary privileges procedure purge read references regexp rename replace require restrict returns revoke right rlike select set show soname sql_big_result sql_calc_found_rows sql_small_result ssl starting straight_join striped table tables terminated then to trailing truncate type union unique unlock unsigned update usage use user_resources using values varying when where while with write xor year_month zerofill"
list_operators = Set.fromList $ words $ "+ - * / || = != <> < <= > >= ~= ^= := => ** .."
list_functions = Set.fromList $ words $ "ascii ord conv bin oct hex char concat concat_ws length octet_length char_length character_length bit_length locate position instr lpad rpad left right substring substring_index mid ltrim rtrim trim soundex space replace repeat reverse insert elt field find_in_set make_set export_set lcase lower ucase upper load_file quote abs sign mod floor ceiling round exp ln log log2 log10 pow power sqrt pi cos sin tan acos asin atan atan2 cot rand least greatest degrees radians dayofweek weekday dayofmonth dayofyear month dayname monthname quarter week year yearweek hour minute second period_add period_diff date_add date_sub adddate subdate extract to_days from_days date_format time_format curdate current_date curtime current_time now sysdate current_timestamp unix_timestamp from_unixtime sec_to_time time_to_sec cast convert bit_count database user system_user session_user password encrypt encode decode md5 sha1 sha aes_encrypt aes_decrypt des_encrypt des_decrypt last_insert_id format version connection_id get_lock release_lock is_free_lock benchmark inet_ntoa inet_aton master_pos_wait found_rows count avg min max sum std stddev bit_or bit_and"
list_types = Set.fromList $ words $ "char character varchar binary varbinary tinyblob mediumblob blob longblob tinytext mediumtext text longtext enum bit bool boolean tinyint smallint mediumint middleint int integer bigint float double real decimal dec fixed numeric long serial date datetime time timestamp year"

regex_SET'28'3f'3d'5cs'2a'5c'28'29 = compileRegex False "SET(?=\\s*\\()"
regex_'5cbCHARACTER_SET'5cb = compileRegex False "\\bCHARACTER SET\\b"
regex_'25'28'3f'3abulk'5f'28'3f'3aexceptions'7crowcount'29'7cfound'7cisopen'7cnotfound'7crowcount'7crowtype'7ctype'29'5cb = compileRegex False "%(?:bulk_(?:exceptions|rowcount)|found|isopen|notfound|rowcount|rowtype|type)\\b"
regex_rem'5cb = compileRegex False "rem\\b"
regex_'2f'24 = compileRegex False "/$"
regex_'40'40'3f'5b'5e'40_'5ct'5cr'5cn'5d = compileRegex False "@@?[^@ \\t\\r\\n]"

parseRules ("SQL (MySQL)","Normal") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_SET'28'3f'3d'5cs'2a'5c'28'29 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5cbCHARACTER_SET'5cb >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t(),%&;?[]{}\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t(),%&;?[]{}\\" list_operators >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t(),%&;?[]{}\\" list_functions >>= withAttribute FunctionTok))
   <|>
   ((pKeyword " \n\t(),%&;?[]{}\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'28'3f'3abulk'5f'28'3f'3aexceptions'7crowcount'29'7cfound'7cisopen'7cnotfound'7crowcount'7crowtype'7ctype'29'5cb >>= withAttribute DataTypeTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("SQL (MySQL)","String"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("SQL (MySQL)","String2"))
   <|>
   ((pDetectChar False '`' >>= withAttribute StringTok) >>~ pushContext ("SQL (MySQL)","Name"))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("SQL (MySQL)","SingleLineComment"))
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext ("SQL (MySQL)","SingleLineComment"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("SQL (MySQL)","MultiLineComment"))
   <|>
   ((pColumn 0 >> pRegExpr regex_rem'5cb >>= withAttribute CommentTok) >>~ pushContext ("SQL (MySQL)","SingleLineComment"))
   <|>
   ((pAnyChar ":&" >>= withAttribute CharTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'2f'24 >>= withAttribute CharTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'40'40'3f'5b'5e'40_'5ct'5cr'5cn'5d >>= withAttribute OtherTok) >>~ pushContext ("SQL (MySQL)","Preprocessor"))
   <|>
   ((pDetectChar False '.' >>= withAttribute CharTok))
   <|>
   (currentContext >>= \x -> guard (x == ("SQL (MySQL)","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("SQL (MySQL)","String") =
  (((pLineContinue >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '&' >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("SQL (MySQL)","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("SQL (MySQL)","String2") =
  (((pLineContinue >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '&' >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("SQL (MySQL)","String2")) >> pDefault >>= withAttribute StringTok))

parseRules ("SQL (MySQL)","Name") =
  (((pLineContinue >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '`' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("SQL (MySQL)","Name")) >> pDefault >>= withAttribute StringTok))

parseRules ("SQL (MySQL)","SingleLineComment") =
  (currentContext >>= \x -> guard (x == ("SQL (MySQL)","SingleLineComment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("SQL (MySQL)","MultiLineComment") =
  (((pLineContinue >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("SQL (MySQL)","MultiLineComment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("SQL (MySQL)","Preprocessor") =
  (currentContext >>= \x -> guard (x == ("SQL (MySQL)","Preprocessor")) >> pDefault >>= withAttribute OtherTok)


parseRules x = parseRules ("SQL (MySQL)","Normal") <|> fail ("Unknown context" ++ show x)
