{- This module was generated from data in the Kate syntax
   highlighting file asn1.xml, version 1.01, by Philippe Rigault -}

module Text.Highlighting.Kate.Syntax.Asn1
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "ASN.1"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.asn;*.asn1"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("ASN.1","Normal Text")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("ASN.1","Normal Text") -> return ()
      ("ASN.1","Comment") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "DEFINITIONS BEGIN END EXPORTS IMPORTS FROM APPLICATION PRIVATE UNIVERSAL DEFAULT OPTIONAL FALSE TRUE"
list_types = Set.fromList $ words $ "BOOLEAN INTEGER OCTET STRING NULL REAL ENUMERATED SEQUENCE SET CHOICE OF VisibleString StringStore"


parseRules ("ASN.1","Normal Text") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext ("ASN.1","Comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("ASN.1","Normal Text")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ASN.1","Comment") =
  (currentContext >>= \x -> guard (x == ("ASN.1","Comment")) >> pDefault >>= withAttribute CommentTok)


parseRules x = parseRules ("ASN.1","Normal Text") <|> fail ("Unknown context" ++ show x)
