{- This module was generated from data in the Kate syntax
   highlighting file haxe.xml, version 0.1, by Chad Joan -}

module Text.Highlighting.Kate.Syntax.Haxe
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Haxe"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.hx;*.Hx;*.hX;*.HX;"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Haxe","normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Haxe","normal") -> return ()
      ("Haxe","ModuleName") -> return ()
      ("Haxe","RawString") -> return ()
      ("Haxe","String") -> return ()
      ("Haxe","CommentLine") -> (popContext) >> pEndLine
      ("Haxe","CommentBlock") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "break case cast catch class continue default else enum extends false for function if implements in inline interface new null override private public return static super switch this throw trace true try typedef untyped var while"
list_modules = Set.fromList $ words $ "package import"
list_types = Set.fromList $ words $ "Array Void Bool Int UInt Float Dynamic String List Error Unknown Type"

regex_'23if'28'5cs'2b'5cw'2b'29'3f = compileRegex "#if(\\s+\\w+)?"
regex_'23'28else'7celseif'7cend'7cerror'29 = compileRegex "#(else|elseif|end|error)"
regex_'5b'5cd'5d'5b'5cd'5d'2a'28'5c'2e'28'3f'21'5c'2e'29'5b'5cd'5d'2a'28'5beE'5d'5b'2d'2b'5d'3f'5b'5cd'5d'2b'29'3f'29 = compileRegex "[\\d][\\d]*(\\.(?!\\.)[\\d]*([eE][-+]?[\\d]+)?)"
regex_'5c'2e'5b'5cd'5d'5b'5cd'5d'2a'28'5beE'5d'5b'2d'2b'5d'3f'5b'5cd'5d'2b'29'3f = compileRegex "\\.[\\d][\\d]*([eE][-+]?[\\d]+)?"
regex_0'5bxX'5d'5b'5cda'2dfA'2dF'5d'2b = compileRegex "0[xX][\\da-fA-F]+"
regex_'5cd'2b = compileRegex "\\d+"
regex_'5b'5e'5cs'5cw'2e'3a'2c'5d = compileRegex "[^\\s\\w.:,]"
regex_'5c'5c'28u'5b'5cda'2dfA'2dF'5d'7b4'7d'7cU'5b'5cda'2dfA'2dF'5d'7b8'7d'7c'26'5ba'2dzA'2dZ'5d'5cw'2b'3b'29 = compileRegex "\\\\(u[\\da-fA-F]{4}|U[\\da-fA-F]{8}|&[a-zA-Z]\\w+;)"

parseRules ("Haxe","normal") =
  (((pRegExpr regex_'23if'28'5cs'2b'5cw'2b'29'3f >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'23'28else'7celseif'7cend'7cerror'29 >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_modules >>= withAttribute KeywordTok) >>~ pushContext ("Haxe","ModuleName"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pHlCStringChar >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("Haxe","RawString"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Haxe","String"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Haxe","CommentLine"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Haxe","CommentBlock"))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pString False "..." >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '.' '.' >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5b'5cd'5d'5b'5cd'5d'2a'28'5c'2e'28'3f'21'5c'2e'29'5b'5cd'5d'2a'28'5beE'5d'5b'2d'2b'5d'3f'5b'5cd'5d'2b'29'3f'29 >>= withAttribute FloatTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'2e'5b'5cd'5d'5b'5cd'5d'2a'28'5beE'5d'5b'2d'2b'5d'3f'5b'5cd'5d'2b'29'3f >>= withAttribute FloatTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_0'5bxX'5d'5b'5cda'2dfA'2dF'5d'2b >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cd'2b >>= withAttribute DecValTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Haxe","normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Haxe","ModuleName") =
  (((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Haxe","CommentLine"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Haxe","CommentBlock"))
   <|>
   ((pRegExpr regex_'5b'5e'5cs'5cw'2e'3a'2c'5d >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Haxe","ModuleName")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Haxe","RawString") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Haxe","RawString")) >> pDefault >>= withAttribute StringTok))

parseRules ("Haxe","String") =
  (((pDetect2Chars False '\\' '"' >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'5c'5c'28u'5b'5cda'2dfA'2dF'5d'7b4'7d'7cU'5b'5cda'2dfA'2dF'5d'7b8'7d'7c'26'5ba'2dzA'2dZ'5d'5cw'2b'3b'29 >>= withAttribute StringTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Haxe","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Haxe","CommentLine") =
  (currentContext >>= \x -> guard (x == ("Haxe","CommentLine")) >> pDefault >>= withAttribute CommentTok)

parseRules ("Haxe","CommentBlock") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Haxe","CommentBlock")) >> pDefault >>= withAttribute CommentTok))


parseRules x = parseRules ("Haxe","normal") <|> fail ("Unknown context" ++ show x)
