{- This module was generated from data in the Kate syntax
   highlighting file literate-haskell.xml, version 2.0.2, by Nicolas Wu (zenzike@gmail.com) -}

module Text.Highlighting.Kate.Syntax.LiterateHaskell
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Haskell
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "Literate Haskell"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.lhs"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Literate Haskell","text")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Literate Haskell","text") -> return ()
      ("Literate Haskell","normal") -> (popContext) >> pEndLine
      ("Literate Haskell","normals") -> return ()
      ("Literate Haskell","comments'") -> pushContext ("Literate Haskell","uncomments") >> return ()
      ("Literate Haskell","uncomments") -> return ()
      ("Literate Haskell","recomments") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'5c'7b'2d'5b'5e'23'5d = compileRegex "\\{-[^#]"

parseRules ("Literate Haskell","text") =
  (((pColumn 0 >> pDetectChar False '>' >>= withAttribute OtherTok) >>~ pushContext ("Literate Haskell","normal"))
   <|>
   ((pColumn 0 >> pDetectChar False '<' >>= withAttribute OtherTok) >>~ pushContext ("Literate Haskell","normal"))
   <|>
   ((pString False "\\begin{code}" >>= withAttribute NormalTok) >>~ pushContext ("Literate Haskell","normals"))
   <|>
   ((pString False "\\begin{spec}" >>= withAttribute NormalTok) >>~ pushContext ("Literate Haskell","normals"))
   <|>
   (currentContext >>= \x -> guard (x == ("Literate Haskell","text")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Literate Haskell","normal") =
  (((pRegExpr regex_'5c'7b'2d'5b'5e'23'5d >>= withAttribute CommentTok) >>~ pushContext ("Literate Haskell","comments'"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Haskell.parseExpression))
   <|>
   (currentContext >>= \x -> guard (x == ("Literate Haskell","normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Literate Haskell","normals") =
  (((pString False "\\end{code}" >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pString False "\\end{spec}" >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Haskell.parseExpression))
   <|>
   (currentContext >>= \x -> guard (x == ("Literate Haskell","normals")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Literate Haskell","comments'") =
  (((pDetect2Chars False '-' '}' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Literate Haskell","comments'")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Literate Haskell","uncomments") =
  (((pColumn 0 >> pDetectChar False '>' >>= withAttribute OtherTok) >>~ pushContext ("Literate Haskell","recomments"))
   <|>
   ((pColumn 0 >> pDetectChar False '<' >>= withAttribute OtherTok) >>~ pushContext ("Literate Haskell","recomments"))
   <|>
   (currentContext >>= \x -> guard (x == ("Literate Haskell","uncomments")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Literate Haskell","recomments") =
  (((pDetect2Chars False '-' '}' >>= withAttribute CommentTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Literate Haskell","recomments")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Haskell", _) = Text.Highlighting.Kate.Syntax.Haskell.parseExpression

parseRules x = parseRules ("Literate Haskell","text") <|> fail ("Unknown context" ++ show x)
