{- This module was generated from data in the Kate syntax
   highlighting file rust.xml, version 0.4.0, by  -}

module Text.Highlighting.Kate.Syntax.Rust
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Rust"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.rs;*.rc"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Rust","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Rust","Normal") -> return ()
      ("Rust","Function") -> return ()
      ("Rust","Type") -> return ()
      ("Rust","String") -> return ()
      ("Rust","Character") -> (popContext) >> pEndLine
      ("Rust","Commentar 1") -> (popContext) >> pEndLine
      ("Rust","Commentar 2") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_fn = Set.fromList $ words $ "fn"
list_type = Set.fromList $ words $ "type"
list_keywords = Set.fromList $ words $ "as assert break const copy do drop else enum export extern fail for if impl let log loop match mod move mut priv pub pure ref return static struct trait unsafe use while"
list_types = Set.fromList $ words $ "bool int uint i8 i16 i32 i64 u8 u16 u32 u64 f32 f64 float char str Either Option Result"
list_ctypes = Set.fromList $ words $ "c_float c_double c_void FILE fpos_t DIR dirent c_char c_schar c_uchar c_short c_ushort c_int c_uint c_long c_ulong size_t ptrdiff_t clock_t time_t c_longlong c_ulonglong intptr_t uintptr_t off_t dev_t ino_t pid_t mode_t ssize_t"
list_self = Set.fromList $ words $ "self"
list_constants = Set.fromList $ words $ "true false Some None Left Right Ok Err Success Failure Cons Nil"
list_cconstants = Set.fromList $ words $ "EXIT_FAILURE EXIT_SUCCESS RAND_MAX EOF SEEK_SET SEEK_CUR SEEK_END _IOFBF _IONBF _IOLBF BUFSIZ FOPEN_MAX FILENAME_MAX L_tmpnam TMP_MAX O_RDONLY O_WRONLY O_RDWR O_APPEND O_CREAT O_EXCL O_TRUNC S_IFIFO S_IFCHR S_IFBLK S_IFDIR S_IFREG S_IFMT S_IEXEC S_IWRITE S_IREAD S_IRWXU S_IXUSR S_IWUSR S_IRUSR F_OK R_OK W_OK X_OK STDIN_FILENO STDOUT_FILENO STDERR_FILENO"

regex_0x'5b0'2d9a'2dfA'2dF'5f'5d'2b'28u8'7cu16'7cu32'7cu64'7ci8'7ci16'7ci32'7ci64'7cu'7ci'29'3f = compileRegex "0x[0-9a-fA-F_]+(u8|u16|u32|u64|i8|i16|i32|i64|u|i)?"
regex_0b'5b0'2d1'5f'5d'2b'28u8'7cu16'7cu32'7cu64'7ci8'7ci16'7ci32'7ci64'7cu'7ci'29'3f = compileRegex "0b[0-1_]+(u8|u16|u32|u64|i8|i16|i32|i64|u|i)?"
regex_'5b0'2d9'5d'5b0'2d9'5f'5d'2a'5c'2e'5b0'2d9'5f'5d'2a'28'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5f'5d'2b'29'3f'28f32'7cf64'7cf'29'3f = compileRegex "[0-9][0-9_]*\\.[0-9_]*([eE][+-]?[0-9_]+)?(f32|f64|f)?"
regex_'5b0'2d9'5d'5b0'2d9'5f'5d'2a'28u8'7cu16'7cu32'7cu64'7ci8'7ci16'7ci32'7ci64'7cu'7ci'29'3f = compileRegex "[0-9][0-9_]*(u8|u16|u32|u64|i8|i16|i32|i64|u|i)?"
regex_'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'3a'3a = compileRegex "[a-zA-Z_][a-zA-Z0-9_]*::"

parseRules ("Rust","Normal") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_fn >>= withAttribute KeywordTok) >>~ pushContext ("Rust","Function"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_type >>= withAttribute KeywordTok) >>~ pushContext ("Rust","Type"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_ctypes >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_self >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_constants >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_cconstants >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Rust","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Rust","Commentar 2"))
   <|>
   ((pRegExpr regex_0x'5b0'2d9a'2dfA'2dF'5f'5d'2b'28u8'7cu16'7cu32'7cu64'7ci8'7ci16'7ci32'7ci64'7cu'7ci'29'3f >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_0b'5b0'2d1'5f'5d'2b'28u8'7cu16'7cu32'7cu64'7ci8'7ci16'7ci32'7ci64'7cu'7ci'29'3f >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'5b0'2d9'5f'5d'2a'5c'2e'5b0'2d9'5f'5d'2a'28'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5f'5d'2b'29'3f'28f32'7cf64'7cf'29'3f >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'5b0'2d9'5f'5d'2a'28u8'7cu16'7cu32'7cu64'7ci8'7ci16'7ci32'7ci64'7cu'7ci'29'3f >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'3a'3a >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Rust","String"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ pushContext ("Rust","Character"))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Rust","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Rust","Function") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '<' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Rust","Function")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Rust","Type") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '=' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '<' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Rust","Type")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Rust","String") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Rust","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Rust","Character") =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Rust","Character")) >> pDefault >>= withAttribute CharTok))

parseRules ("Rust","Commentar 1") =
  (currentContext >>= \x -> guard (x == ("Rust","Commentar 1")) >> pDefault >>= withAttribute CommentTok)

parseRules ("Rust","Commentar 2") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Rust","Commentar 2")) >> pDefault >>= withAttribute CommentTok))


parseRules x = parseRules ("Rust","Normal") <|> fail ("Unknown context" ++ show x)
