{- This module was generated from data in the Kate syntax
   highlighting file tcl.xml, version 1.11, by  -}

module Text.Highlighting.Kate.Syntax.Tcl
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Tcl/Tk"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.tcl;*.tk"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Tcl/Tk","Base")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Tcl/Tk","Base") -> return ()
      ("Tcl/Tk","String") -> return ()
      ("Tcl/Tk","Comment") -> (popContext) >> pEndLine
      ("Tcl/Tk","New command line") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "after append AppleScript argv argc array auto_execk auto_execok auto_import auto_load auto_mkindex auto_mkindex_old auto_path auto_qualify auto_reset beep bell binary bind bindtags bgerror break button canvas case catch cd chan checkbutton clipboard clock close combobox concat console continue dde destroy dict else elseif encoding entry env eof error errorCode errorInfo eval event exec exit expr fblocked fconfigure fcopy file fileevent flush focus font for foreach format frame gets glob global grab grid history if image incr info interp join label labelframe lappend lassign lindex linsert list listbox llength load lower lrange lremove lrepeat lreplace lreverse lsearch lset lsort menu menubutton message namespace notebook open option OptProc pack package panedwindow parray pid place pkg_mkIndex proc progressbar puts pwd radiobutton raise read regexp registry regsub rename resource return scale scan scrollbar seek selection send separator set sizegrip socket source spinbox split string style subst switch tclLog tcl_endOfWord tcl_findLibrary tcl_library tcl_patchLevel tcl_platform tcl_precision tcl_rcFileName tcl_rcRsrcName tcl_startOfNextWord tcl_startOfPreviousWord tcl_traceCompile tcl_traceExec tcl_version tcl_wordBreakAfter tcl_wordBreakBefore tell text time tk tkTabToWindow tkwait tk_chooseColor tk_chooseDirectory tk_focusFollowMouse tk_focusNext tk_focusPrev tk_getOpenFile tk_getSaveFile tk_library tk_menuSetFocus tk_messageBox tk_optionMenu tk_patchLevel tk_popup tk_strictMotif tk_textCopy tk_textCut tk_textPaste tk_version toplevel trace traverseTo treeview unknown unload unset update uplevel upvar variable vwait while winfo wm"
list_keywords'2dopt = Set.fromList $ words $ "add args atime attributes body bytelength cancel channels clicks cmdcount commands compare complete convertfrom convertto copy default delete dirname equal executable exists extension first forget format functions globals hostname idle ifneeded index info is isdirectory isfile join last length level library link loaded locals lstat map match mkdir mtime nameofexecutable names nativename normalize number owned patchlevel pathtype present procs provide range readable readlink remove rename repeat replace require rootname scan script seconds separator sharedlibextension size split stat system tail tclversion tolower totitle toupper trim trimleft trimright type unknown variable vars vcompare vdelete versions vinfo volumes vsatisfies wordend wordstart writable activate actual addtag append appname aspect atom atomname bbox bind broadcast canvasx canvasy caret cells cget children class clear client clone colormapfull colormapwindows command configure containing coords create current curselection dchars debug deiconify delta depth deselect dlineinfo dtag dump edit entrycget entryconfigure families find flash focus focusmodel fpixels fraction frame generate geometry get gettags grid group handle height hide iconbitmap iconify iconmask iconname iconposition iconwindow icursor id identify image insert interps inuse invoke ismapped itemcget itemconfigure keys lower manager mark maxsize measure metrics minsize move name nearest overrideredirect own panecget paneconfigure panes parent pathname pixels pointerx pointerxy pointery positionfrom post postcascade postscript protocol proxy raise release reqheight reqwidth resizable rgb rootx rooty scale scaling screen screencells screendepth screenheight screenmmheight screenmmwidth screenvisual screenwidth search see select selection server set show sizefrom stackorder state status tag title toplevel transient types unpost useinputmethods validate values viewable visual visualid visualsavailable vrootheight vrootwidth vrootx vrooty width window windowingsystem withdraw x xview y"

regex_'23'5cs'2aBEGIN'2e'2a'24 = compileRegex "#\\s*BEGIN.*$"
regex_'23'5cs'2aEND'2e'2a'24 = compileRegex "#\\s*END.*$"
regex_'5c'5c'2e = compileRegex "\\\\."
regex_'5cs'2d'5cw'2b = compileRegex "\\s-\\w+"
regex_'5c'24'5c'7b'28'5b'5e'5c'7d'5d'7c'5c'5c'5c'7d'29'2b'5c'7d = compileRegex "\\$\\{([^\\}]|\\\\\\})+\\}"
regex_'5c'24'28'3a'3a'7c'5cw'29'2b = compileRegex "\\$(::|\\w)+"
regex_'22'7b2'7d = compileRegex "\"{2}"
regex_'22 = compileRegex "\""
regex_'5cs'2a'23 = compileRegex "\\s*#"
regex_'2e = compileRegex "."

parseRules ("Tcl/Tk","Base") =
  (((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aBEGIN'2e'2a'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aEND'2e'2a'24 >>= withAttribute RegionMarkerTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords'2dopt >>= withAttribute OtherTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5c'5c'2e >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'5cs'2d'5cw'2b >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'28'5b'5e'5c'7d'5d'7c'5c'5c'5c'7d'29'2b'5c'7d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'24'28'3a'3a'7c'5cw'29'2b >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'22'7b2'7d >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'22 >>= withAttribute StringTok) >>~ pushContext ("Tcl/Tk","String"))
   <|>
   ((pDetectChar False ';' >>= withAttribute NormalTok) >>~ pushContext ("Tcl/Tk","New command line"))
   <|>
   ((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Tcl/Tk","Comment"))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcl/Tk","Base")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcl/Tk","String") =
  (((pRegExpr regex_'5c'5c'2e >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pDetectChar False '$' >>= withAttribute DataTypeTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcl/Tk","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Tcl/Tk","Comment") =
  (currentContext >>= \x -> guard (x == ("Tcl/Tk","Comment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("Tcl/Tk","New command line") =
  (((pRegExpr regex_'5cs'2a'23 >>= withAttribute CommentTok) >>~ pushContext ("Tcl/Tk","Comment"))
   <|>
   ((lookAhead (pRegExpr regex_'2e) >> (popContext) >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcl/Tk","New command line")) >> pDefault >>= withAttribute NormalTok))


parseRules x = parseRules ("Tcl/Tk","Base") <|> fail ("Unknown context" ++ show x)
