{- This module was generated from data in the Kate syntax
   highlighting file agda.xml, version 2, by Matthias C. M. Troffaes -}

module Text.Highlighting.Kate.Syntax.Agda
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Agda"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.agda"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Agda","code")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Agda","code") -> return ()
      ("Agda","comment") -> (popContext) >> pEndLine
      ("Agda","comments") -> return ()
      ("Agda","hole") -> return ()
      ("Agda","char") -> (popContext) >> pEndLine
      ("Agda","string") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_reserved_keywords = Set.fromList $ words $ "abstract codata coinductive constructor data field forall hiding import in inductive infix infixl infixr let open pattern postulate primitive private public module mutual quote quoteGoal quoteTerm record renaming rewrite syntax to unquote using where with"

regex_'5c'7b'2d'23'2e'2a'23'2d'5c'7d = compileRegex True "\\{-#.*#-\\}"
regex_'28Prop'7cSet'5b₀'2d₉'5d'2b'7cSet'5b0'2d9'5d'2a'29'28'3f'3d'28'5b'5f'3b'2e'22'28'29'7b'7d'40'5d'7c'5cs'7c'24'29'29 = compileRegex True "(Prop|Set[\8320-\8329]+|Set[0-9]*)(?=([_;.\"(){}@]|\\s|$))"
regex_'28'2d'3e'7c'2192'7c'2200'7cλ'7c'3a'7c'3d'7c'5c'7c'29'28'3f'3d'28'5b'5f'3b'2e'22'28'29'7b'7d'40'5d'7c'5cs'7c'24'29'29 = compileRegex True "(->|\8594|\8704|\955|:|=|\\|)(?=([_;.\"(){}@]|\\s|$))"
regex_'5cd'2b'5c'2e'5cd'2b'28'3f'3d'28'5b'5f'3b'2e'22'28'29'7b'7d'40'5d'7c'5cs'7c'24'29'29 = compileRegex True "\\d+\\.\\d+(?=([_;.\"(){}@]|\\s|$))"
regex_'5b0'2d9'5d'2b'28'3f'3d'28'5b'5f'3b'2e'22'28'29'7b'7d'40'5d'7c'5cs'7c'24'29'29 = compileRegex True "[0-9]+(?=([_;.\"(){}@]|\\s|$))"
regex_'5b'5e'5f'3b'2e'22'28'29'7b'7d'40'5cs'5d'2b = compileRegex True "[^_;.\"(){}@\\s]+"

parseRules ("Agda","code") =
  (((pRegExpr regex_'5c'7b'2d'23'2e'2a'23'2d'5c'7d >>= withAttribute PreprocessorTok))
   <|>
   ((pKeyword " \n\t.();{}_;.\"(){}@" list_reserved_keywords >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28Prop'7cSet'5b₀'2d₉'5d'2b'7cSet'5b0'2d9'5d'2a'29'28'3f'3d'28'5b'5f'3b'2e'22'28'29'7b'7d'40'5d'7c'5cs'7c'24'29'29 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'2d'3e'7c'2192'7c'2200'7cλ'7c'3a'7c'3d'7c'5c'7c'29'28'3f'3d'28'5b'5f'3b'2e'22'28'29'7b'7d'40'5d'7c'5cs'7c'24'29'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5cd'2b'5c'2e'5cd'2b'28'3f'3d'28'5b'5f'3b'2e'22'28'29'7b'7d'40'5d'7c'5cs'7c'24'29'29 >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'2b'28'3f'3d'28'5b'5f'3b'2e'22'28'29'7b'7d'40'5d'7c'5cs'7c'24'29'29 >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ pushContext ("Agda","char"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Agda","string"))
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext ("Agda","comment"))
   <|>
   ((pDetect2Chars False '{' '-' >>= withAttribute CommentTok) >>~ pushContext ("Agda","comments"))
   <|>
   ((pDetect2Chars False '{' '!' >>= withAttribute OtherTok) >>~ pushContext ("Agda","hole"))
   <|>
   ((pAnyChar "_;.\"(){}@\\\\" >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5b'5e'5f'3b'2e'22'28'29'7b'7d'40'5cs'5d'2b >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Agda","code")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Agda","comment") =
  (currentContext >>= \x -> guard (x == ("Agda","comment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("Agda","comments") =
  (((pDetect2Chars False '{' '-' >>= withAttribute CommentTok) >>~ pushContext ("Agda","comments"))
   <|>
   ((pDetect2Chars False '-' '}' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Agda","comments")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Agda","hole") =
  (((pDetect2Chars False '!' '}' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Agda","hole")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Agda","char") =
  (((pDetect2Chars False '\\' '\'' >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Agda","char")) >> pDefault >>= withAttribute CharTok))

parseRules ("Agda","string") =
  (((pDetect2Chars False '\\' '"' >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Agda","string")) >> pDefault >>= withAttribute StringTok))


parseRules x = parseRules ("Agda","code") <|> fail ("Unknown context" ++ show x)
