// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_sqlite3classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include "hk_sqlite3datasource.h"
#include "hk_sqlite3database.h"
#include "hk_sqlite3connection.h"
#include "hk_sqlite3column.h"
#include "hk_sqlite3actionquery.h"
#include <sqlite3.h>
#include <exception>
#include <new>

hk_sqlite3datasource::hk_sqlite3datasource(hk_sqlite3database* d,hk_presentation* p):hk_storagedatasource(d,p)
{
#ifdef HK_DEBUG
//wanna_debug(true);
    hkdebug("hk_sqlite3datasource::constructor");
#endif
   vm=0;
   colnums=0;
    p_sqlitedatabase=d;
    p_actionquery=new hk_sqlite3actionquery(d);
    p_enabled=false;
}


hk_sqlite3datasource::~hk_sqlite3datasource()
{
#ifdef HK_DEBUG
    hkdebug("hk_sqlite3datasource::destructor");
#endif
    if (accessmode()!=standard &&is_enabled()) driver_specific_batch_disable();
    list<coltest*>::iterator it=p_coltest.begin();
    while (it!=p_coltest.end())
    {
      coltest* t=(*it);
      ++it;
      delete t;
    }
}


list<hk_column*>* hk_sqlite3datasource::driver_specific_columns(void)
{
#ifdef HK_DEBUG
                                                  //cout <<"hk_sqlite3datasource::driver_specific_columns"<<endl;
    hkdebug("hk_sqlite3datasource::driver_specific_columns");
#endif
    if (p_columns==NULL&&type()==ds_table&&p_name.size()>0&&p_sqlitedatabase->dbhandler())
    {
        hk_string s="SELECT * FROM '"  +p_name+"' WHERE 0=1"; 
	vm=0;
	
	if (sqlite3_prepare(p_sqlitedatabase->dbhandler() ,s.c_str(),s.size(),&vm,0 ))
	{ //cerr <<"type="<<type()<<endl;
          p_sqlitedatabase->sqliteconnection()->servermessage(sqlite3_errmsg(p_sqlitedatabase->dbhandler()));
	  cerr<< "driver_specific_columns compile problem"<<s<<endl;
	  return p_columns;
	}
            
	colnums=0;
	int result=0;
	if (vm)
	{
	result=sqlite3_step(vm);
	colnums=sqlite3_column_count(vm);
        driver_specific_create_columns();
	sqlite3_finalize(vm);
	}
	

	if (result && p_sqlitedatabase->dbhandler()) 
        {
	  p_sqlitedatabase->sqliteconnection()->servermessage(sqlite3_errmsg(p_sqlitedatabase->dbhandler()));
  	}  
	vm=0;
    }
    return p_columns;

}


bool hk_sqlite3datasource::driver_specific_create_columns(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_sqlite3datasource::driver_specific_create_columns");
#endif
  clear_columnlist();
  p_columns=new list<hk_column*>;
  list<coltest*>::iterator pit=p_coltest.begin();
  while (pit!=p_coltest.end())
  {
   delete(*pit);
  ++pit;
  }
  p_coltest.clear();
  if (type()==ds_table)
     parse_createstatement();

     
   int z = 0;                             //counting the fieldnumbers
   for(int i=0;i<colnums;++i)
   {
    hk_sqlite3column *col= new hk_sqlite3column(this,p_true,p_false);
    col->set_fieldnumber(z++);
    col->set_name(sqlite3_column_name(vm,i));
      
    hk_string coltype;
    if (sqlite3_column_decltype(vm,i)!=0)coltype=string2lower(sqlite3_column_decltype(vm,i));
    else coltype="memo";
    hk_column::enum_columntype ct=hk_column::textcolumn;
    int cs=255;
    if (coltype.find("smallint")!=hk_string::npos)
    {
      ct=hk_column::smallintegercolumn;
    }
    else
    if (coltype.find("int")!=hk_string::npos)
    {
      ct=hk_column::integercolumn;
      
     } 
  //   delete r;

    //}
    else
    if (coltype.find("smallfloat")!=hk_string::npos)
    {
      ct=hk_column::smallfloatingcolumn;
    }
    else
    if (coltype.find("float")!=hk_string::npos)
    {
      ct=hk_column::smallfloatingcolumn;
    }
    else
    if (coltype.find("double")!=hk_string::npos)
    {
      ct=hk_column::floatingcolumn;
    }
    else
    if (coltype.find("real")!=hk_string::npos)
    {
      ct=hk_column::floatingcolumn;
    }
    else
    if (coltype.find("numeric")!=hk_string::npos)
    {
      ct=hk_column::floatingcolumn;
    }
    else
    if (coltype.find("decimal")!=hk_string::npos)
    {
      ct=hk_column::floatingcolumn;
    }
    else
    if (coltype.find("memo")!=hk_string::npos)
    {
       ct=hk_column::memocolumn;
       cs=100000;
    }
    else
    if (coltype.find("blob")!=hk_string::npos)
    {
       ct=hk_column::binarycolumn;
       cs=100000;
    }
    else
    if (coltype.find("binary")!=hk_string::npos)
    {
       ct=hk_column::binarycolumn;
       cs=100000;
    }
    else
    if (coltype.find("bool")!=hk_string::npos)
    {
       ct=hk_column::boolcolumn;
       cs=1;
    }
    else
    if (coltype.find("datetime")!=hk_string::npos)
    {
       ct=hk_column::datetimecolumn;
    }
    else
    if (coltype.find("time")!=hk_string::npos)
    {
       ct=hk_column::timecolumn;
    
    }
    else
    if (coltype.find("date")!=hk_string::npos)
    {
       ct=hk_column::datecolumn;
    
    }
    
    if (type()==ds_table)
    {
      list<coltest*>::iterator it=p_coltest.begin();
      while(it!=p_coltest.end())
      {
        if ((*it)->p_name==col->name())
	 {
	  if ((*it)->p_autoinc)
	    {
	      ct=hk_column::auto_inccolumn;
	      col->set_primary(true);
	      col->set_notnull(true);
	      p_primary_key_used=true;
	    } 
	    
	  if ((*it)->p_primary)
	    {
	      col->set_primary(true);
	      col->set_notnull(true);
	      p_primary_key_used=true;
	    } 
	    
	  if ((*it)->p_notnull)
	    {
	      col->set_notnull(true);
	    } 
	    
	  break;
	 }
	
	++it;
      }
    
    
    } 
    
    
    
    
    p_columns->insert(p_columns->end(),col);
    col->set_columntype(ct);
    col->set_size(cs);
 

   }
   return true;
}




bool hk_sqlite3datasource::driver_specific_enable(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_sqlite3datasource::driver_specific_enable");
#endif
   if (p_print_sqlstatements)   print_sql();
    if (!p_enabled)
    {
        if  (!p_sqlitedatabase||!p_sqlitedatabase->dbhandler()) 
	 {
	  cerr <<"error p_sqlitedatabase==NULL||p_sqlitedatabase->dbhandler()"<<endl;
	  cerr <<"db="<<p_sqlitedatabase<<" handler="<<p_sqlitedatabase->dbhandler()<<endl;
	  return false;
	 } 
        vm=0;
        if (accessmode()==batchwrite)
        {
            clear_columnlist();
            driver_specific_create_columns();
            return true;
        }
	if (sqlite3_prepare(p_sqlitedatabase->dbhandler() ,p_sql.c_str(),p_sql.size(),&vm,0 ))
	{
          p_sqlitedatabase->sqliteconnection()->servermessage(sqlite3_errmsg(p_sqlitedatabase->dbhandler()));
	  cerr<< "driver_specific_enable compile problem"<<endl;print_sql();
	  return false;
	}
            
	colnums=0;
	int result=0;
	if (vm)
	{
	colnums=sqlite3_column_count(vm);
         while ((result=sqlite3_step(vm))==SQLITE_ROW)
	{ 
          struct_raw_data* datarow=new struct_raw_data[colnums];
	   for (int col=0;col<colnums;++col)
	   {
            //neue Datenzeile erzeugen
	      const char* coltext=(const char*)sqlite3_column_text(vm,col);
              datarow[col].length=(coltext?strlen(coltext)+1:0); 
              char* dt=NULL;
              //leave NULL pointer if there is no data
              if (coltext)
	       {
	       dt=new char[datarow[col].length];
               strcpy(dt,coltext);
	       }
		
//	       for (unsigned int tk=0;tk<datarow[col].length;tk++) dt[tk]=data[col][tk];
              datarow[col].data=dt;
	   }
//Daten speichern
	insert_data(datarow);
        }
       driver_specific_create_columns();
	
	sqlite3_finalize(vm);
	vm=0;
	if (result==SQLITE_ERROR) 
        {
	  p_sqlitedatabase->sqliteconnection()->servermessage(sqlite3_errmsg(p_sqlitedatabase->dbhandler()));
         return false;
	}  
	}
	    
   }
   return true;	    
}




hk_column* hk_sqlite3datasource::driver_specific_new_column(void)
{
#ifdef HK_DEBUG
    hkdebug("driver_specific_new_column");
#endif
    hk_column* col=new hk_sqlite3column(this,p_true,p_false);

    return col;
}


bool hk_sqlite3datasource::driver_specific_insert_data(void)
{
    
    hk_string new_autoinc;

    struct_raw_data* datarow=new struct_raw_data[p_columns->size()];
    list<hk_column*>::iterator col_it;
    col_it=p_columns->begin();
    unsigned int spalte=0;
    while (spalte<p_columns->size())
    {
        const struct_raw_data* changed_data=(*col_it)->changed_data();
        if ((*col_it)->columntype()==hk_column::auto_inccolumn)
        {
            new_autoinc=format_number(sqlite3_last_insert_rowid(p_sqlitedatabase->dbhandler()),false,0);
            const int bsize=new_autoinc.size()+1;
            char* data=new char[bsize];
            strcpy(data,new_autoinc.c_str());
            datarow[spalte].data=data;
            datarow[spalte].length=strlen(data);
        }
        else
        {                                         //not a autoinc column
            datarow[spalte].length=changed_data->length;;
            char* data=NULL;
            if (changed_data->data)
            {
                data=new char[datarow[spalte].length];
                for (unsigned int tk=0;tk<datarow[spalte].length;tk++) data[tk]=changed_data->data[tk];
            }
            datarow[spalte].data=data;
        }
        spalte++;
        col_it++;
    }
    insert_data(datarow);
    return true;
}


hk_sqlite3connection* hk_sqlite3datasource::sqliteconnection(void)
{
    return p_sqlitedatabase->connection();

}


bool hk_sqlite3datasource::driver_specific_batch_enable(void)
{
   p_counter=0;
   if (p_print_sqlstatements)   print_sql();
    if (!p_enabled)
    {
        if  (!p_sqlitedatabase||!p_sqlitedatabase->dbhandler()) 
	 {
	  cerr <<"error p_sqlitedatabase==NULL||p_sqlitedatabase->dbhandler()"<<endl;
	  cerr <<"db="<<p_sqlitedatabase<<" handler="<<p_sqlitedatabase->dbhandler()<<endl;
	  return false;
	 } 
        vm=0;
	int result=0;
	if ( sqlite3_prepare(p_sqlitedatabase->dbhandler() ,p_sql.c_str(),p_sql.size(),&vm,0 ))
	{
          p_sqlitedatabase->sqliteconnection()->servermessage(sqlite3_errmsg(p_sqlitedatabase->dbhandler()));
	  cerr<< "driver_specific_enable compile problem"<<endl;print_sql();
	  return false;
	}
        if (accessmode()==batchwrite)   return true; 
	colnums=0;
	if (vm)
	{
	colnums=sqlite3_column_count(vm);
	result=sqlite3_step(vm);
       driver_specific_create_columns();
	if(result==SQLITE_ROW&& colnums>0)
	{
          struct_raw_data* datarow=new struct_raw_data[colnums];
	   for (int col=0;col<colnums;++col)
	   {
            //neue Datenzeile erzeugen
	       const char* coltext=(const char*)sqlite3_column_text(vm,col);
              datarow[col].length=(coltext?strlen(coltext)+1:0); 
              char* dt=NULL;
              //leave NULL pointer if there is no data
              if (coltext)
	       {
	       dt=new char[datarow[col].length];
               strcpy(dt,coltext);
	       }
		
//	       for (unsigned int tk=0;tk<datarow[col].length;tk++) dt[tk]=data[col][tk];
              datarow[col].data=dt;
	   
	   
	   }
//Daten speichern
        
	insert_data(datarow);
	set_maxrows(1);
	
       } 
	return true;
	}
	    
   }
   set_maxrows(0);
   return false;	    
}


bool hk_sqlite3datasource::driver_specific_batch_disable(void)
{
    delete_data();
    if (accessmode()==batchwrite) return true;
    if (vm)
    {
    int result=	sqlite3_finalize(vm);

	if (result==SQLITE_ERROR) 
        {
	  p_sqlitedatabase->sqliteconnection()->servermessage(sqlite3_errmsg(p_sqlitedatabase->dbhandler()));
	vm=0;
	return false;
	}  
     }	
     colnums=0;
     vm=0;
    return true;
 }


bool hk_sqlite3datasource::driver_specific_batch_goto_next(void)
{
    if (hk_storagedatasource::driver_specific_batch_goto_next()) return true;
  	if (vm)
	{
	if (sqlite3_step(vm)==SQLITE_ROW)
	{ 
	  set_maxrows(max_rows()+1);
          struct_raw_data* datarow=new struct_raw_data[colnums];
 
	   for (int col=0;col<colnums;++col)
	   {
            //neue Datenzeile erzeugen
	        const char* coltext=(const char*)sqlite3_column_text(vm,col);
                datarow[col].length=(coltext?strlen(coltext)+1:0); 
            char* dt=NULL;
              //leave NULL pointer if there is no data
              if (coltext)
	       {
	       dt=new char[datarow[col].length];
               strcpy(dt,coltext);
	       }
		
              datarow[col].data=dt;
	   }
//Daten speichern
	insert_data(datarow);
 	  ++p_counter;
	return true;
        }
	else
	 {
           int result=	sqlite3_finalize(vm);
	   if (result==SQLITE_ERROR) 
            {
	    p_sqlitedatabase->sqliteconnection()->servermessage(sqlite3_errmsg(p_sqlitedatabase->dbhandler()));
	   vm=0;
            return false;
	   }  
	   vm=0;
	 }
       
       }
    return false;
}





void hk_sqlite3datasource::parse_createstatement(void)
{
hk_string createsql;
sqlite3_stmt* tmpvm=0;

hk_string s="SELECT sql FROM sqlite_master WHERE type='table' AND name='"+name()+"'";
if( sqlite3_prepare(p_sqlitedatabase->dbhandler() ,s.c_str(),s.size(),&tmpvm,0 ))
{
  p_sqlitedatabase->sqliteconnection()->servermessage(sqlite3_errmsg(p_sqlitedatabase->dbhandler()));
  cerr<< "internal_is_autoinc_column compile problem"<<endl;print_sql();
  return ;
}
            

int result=0;
if (tmpvm)
{//cerr <<"vor sqlite_step"<<endl;
int tmpcolnums=sqlite3_column_count(tmpvm);
result=sqlite3_step(tmpvm);
//cerr<<"sqlite_step result="<<result<<endl;
hk_string createsql;
if (tmpcolnums==1&&result==SQLITE_ROW)
{
createsql=(const char*)sqlite3_column_text(tmpvm,0);
}





  hk_string::size_type startpos=createsql.find_first_of("(");
  hk_string::size_type endpos=createsql.find_last_of(")");
  if (startpos!=hk_string::npos && endpos!=hk_string::npos)
   createsql=trim(createsql.substr(startpos+1,endpos-startpos-1));

sqlite3_finalize(tmpvm);
tmpvm=0;
if (result==SQLITE_ERROR) 
       {
	  p_sqlitedatabase->sqliteconnection()->servermessage(sqlite3_errmsg(p_sqlitedatabase->dbhandler()));
         return ;
	}  







    hk_string::size_type offset=0;
    hk_string quotedtype;
    enum
    {
	S_START,S_IN_DOUBLEQUOTE,S_IN_QUOTE,S_IN_TAG, S_IN_BRACKETS
    } state=S_START;



//parser begin
int row=1;
int col=1;
list<hk_string> tags;
hk_string tag;

while (offset<createsql.size())
{
	hk_string x(1,createsql[offset]);
	switch (state)
	{
	case S_START:   
			tag="";
			if (isspace(x[0]))
				{
					if (x=="\n")
					{
						++row;col=0;
					}
				  break;
				}
			else
			if (x=="\"")
			   {
			     state=S_IN_DOUBLEQUOTE;
			   }
			else
			if (x=="(")
			   {
			     tag=x;
			     state=S_IN_BRACKETS;
			   }   
			else
			if (x=="'")
			 state=S_IN_QUOTE;   
			else 	
			if (x==",")
			 {
			   tag=",";
			   tags.insert(tags.end(),tag);
			   
			 } 
			else
			 {
			  state=S_IN_TAG;
			  tag=x;
			 }
			break;	
	case S_IN_QUOTE:
			  if (x=="'")
			   {
 			   tags.insert(tags.end(),tag);
			    state=S_START;
			   } 
			  else tag+=x;
 
			break;		
	
	
	case S_IN_DOUBLEQUOTE:
			  if (x=="\"")
			   {
 			   tags.insert(tags.end(),tag);
			    state=S_START;
			   } 
			  else tag+=x;
 
			break;		
	
	case S_IN_BRACKETS:
			  if (x==")")
			   {
			    tag+=x;
 			   tags.insert(tags.end(),tag);
			    state=S_START;
			   } 
			  else tag+=x;
 
			break;		
	
	
	case S_IN_TAG:
			if (isspace(x[0]))
			 {
			   tags.insert(tags.end(),tag);
			   tag="";
			   state=S_START;
			     
			 }
			 else
			if (x=="(")
			{
			 tag+=x;
			 state=S_IN_BRACKETS;
			}
			else 
			if (x==",")
			 {
			   tags.insert(tags.end(),tag);
			   tags.insert(tags.end(),",");  
			   state=S_START;
			 }
			else
			 tag+=x;
			break;
	}
	++offset;++col;

} // endloop
  
tags.insert(tags.end(),tag);


list<coltest*> p_cols;
coltest* currcol=NULL; 
list<hk_string>::iterator it=tags.begin();
//cerr <<"createsql="<<createsql<<endl;

    enum
    {
	T_START,T_NOT,T_INTEGER,T_INTEGERPRIMARY, T_ANYTAG
    } tagstate=T_START;


while (it!=tags.end())
{
 //cerr <<"tag=#"<<*it<<"#"<<endl;
 if (currcol==NULL||*it==",")
  {
    if (currcol) 
    {
     p_coltest.insert(p_coltest.end(),currcol);
     //cerr <<"currcol anh�gen"<<endl;
     tagstate=T_START;
    } 
    currcol=new coltest;//cerr <<"currcol anlegen"<<currcol<<endl;
  }
  hk_string t=string2upper(*it); 
  switch (tagstate)
  {
    case T_START:	
	    if (currcol&& *it!=",")
	     {
	      currcol->p_name=*it;
   	      tagstate=T_ANYTAG;
	     } 
    			break;
    case T_NOT:
    			if (t=="NULL") 
			  currcol->p_notnull=true;
			tagstate=T_ANYTAG;	
    			break;
    case T_INTEGER:	if (t=="PRIMARY")
    			  tagstate=T_INTEGERPRIMARY;
			else
			  tagstate=T_ANYTAG;  
    			break;
    case T_INTEGERPRIMARY:
			  currcol->p_primary=true;
    			if (t=="KEY") 
			  currcol->p_autoinc=true;
			tagstate=T_ANYTAG;	
    			break;
    case T_ANYTAG:
    		if (t=="INTEGER") tagstate=T_INTEGER;
		else
    		if (t=="NOT") tagstate=T_NOT;
		else
    		if (t=="PRIMARY") currcol->p_primary=true;
		
    			break;
  }
  
  
  
  
  
  
 ++it;

}	
  
if (currcol)      p_coltest.insert(p_coltest.end(),currcol);
  
/*  
 list<coltest*>::iterator it2=p_coltest.begin();
 while(it2!=p_coltest.end())
 {
  cerr <<"it2: #"<<(*it2)->p_name<<"# \tnotnull: "<<(*it2)->p_notnull<<" \tprimary: "<<(*it2)->p_primary<<" \tautoinc: "<<(*it2)->p_autoinc<<endl;
  ++it2;
 } 
*/
}
}
