// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.17 $
#include "hk_definitions.h"
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <locale.h>
#include <vector>
#include "config.h"

#include "hk_column.h"

int hk_random(int min,int max)
{
    int l;
    double e;
    e=(double) min+(rand()/(RAND_MAX+0.5))*(max-min+1);
    l=(int)(e);
    return l;
}


bool is_numerictype(hk_column* c)
{
    if (c==NULL) return false;

    return (is_integertype(c)||is_realtype(c));

}


bool is_integertype(hk_column*c)
{
    if (c==NULL) return false;

    switch (c->columntype())
    {
        case hk_column::auto_inccolumn :;
        case hk_column::smallintegercolumn:;
        case hk_column::integercolumn:return true;

        default: return false;
    }

}


bool is_realtype(hk_column*c)
{
    if (c==NULL) return false;

    switch (c->columntype())
    {
        case hk_column::smallfloatingcolumn :;
        case hk_column::floatingcolumn :return true;

        default: return false;
    }

}

double inch2cm(double i)
{
 return 2.54*i;
}
double cm2inch(double c)
{
  return c/2.54;
}
