// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#ifndef HK_FONT
#define HK_FONT
#include "hk_class.h"

class hk_font : public hk_class
{
public:
  hk_font();
  hk_font(const hk_string& fontname,int fontsize);
  hk_font(const hk_font&);
  void set_font(const hk_string& fontname,int fontsize);
  void set_font(const hk_font&);
  hk_string fontname(void) const;
  int fontsize(void) const;
  void set_bold(bool);
  bool bold(void) const;
  void set_italic(bool);
  bool italic(void) const;
  bool operator=(const hk_font&);
  bool operator==(const hk_font&);
  bool operator!=(const hk_font&);
  hk_string psfontname(void)const;
  static void set_defaultfont(const hk_string& d,int s);
  static hk_string defaultfontname(void);
  static int defaultfontsize(void);

virtual void savedata(ostream& s );
virtual void loaddata(const hk_string& definition);


protected:


private:
bool is_equal(const hk_font&);
hk_string p_fontname;
int	  p_fontsize;
bool p_italic;
bool p_bold;
static hk_string p_defaultfont;
static int   p_defaultfontsize;



};

ostream& operator<<(ostream&,hk_font&);
ostream& operator<<(ostream&,const hk_font&);

#endif
