// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#ifndef HK_SUBFORM
#define HK_SUBFORM
#include "hk_dsvisible.h"
#include "hk_definitions.h"
#include <list>
class hk_form;
class hk_subformprivate;



class hk_subform: public hk_dsvisible
{
friend class hk_form;
public:
hk_subform(hk_presentation* parent);
virtual ~hk_subform();
void set_name(const hk_string&, bool registerchange=true);
hk_string name(void) const;
hk_form* subform();
void        add_depending_fields( const hk_string& subfield,const hk_string& masterfield,bool registerchange=true);
void        clear_depending_fields(bool registerchange=true);
list<dependingclass>* depending_on_fields(void);
virtual void savedata(ostream& s, bool savedatasource,bool saveall);
virtual void savedata(ostream& s  );
virtual void loaddata(const hk_string& definition);

protected:
void set_subform(hk_form*);
virtual void    before_datasource_enables(void);
virtual bool	presentationmode_changed(void);
void internal_set_datasourcevalues(void);
private:

hk_subformprivate* p_private;
};

#endif
