/* $Id: eval.h 1158 2006-02-26 08:52:37Z holger $
 *
 * HoiChess/eval.h
 *
 * Copyright (C) 2004, 2005 Holger Ruckdeschel <holger@hoicher.de>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 */
#ifndef EVAL_H
#define EVAL_H

#include "common.h"
#include "board.h"
#include "evalcache.h"
#include "pawnhash.h"


/* score values */
#define INFTY		100000
#define MATE		 90000
#define DRAW		     0


class Evaluator
{
      public:
	enum game_phase {
		OPENING,
		MIDGAME,
		ENDGAME
	};

      private:
	static const struct score_plugin plugins[];

      private:
	PawnHashTable * pawnhashtable;
	EvaluationCache * evalcache;

	unsigned long stat_evals_full;
	unsigned long stat_evals_cut;

      private:
	const Board * board;
	unsigned int phase;
	PawnHashEntry pawnhashentry;
	Bitboard passed_pawns[2];
	//Bitboard pinned_on_king[2];
	
      public:
	Evaluator();
	~Evaluator();

      public:
	int eval(const Board & board, int alpha = -INFTY, int beta = INFTY);
	void print_eval(const Board & board, FILE * fp = stdout);
	void reset_statistics();
	void print_statistics(FILE * fp = stdout) const;
	void set_pawnhashtable(PawnHashTable * pawnhashtable);
	void set_evalcache(EvaluationCache * evalcache);
	
      private:
	void setup(const Board * board);
	void finish();
	
      public:
	static bool is_draw(const Board & board);
	static int material_balance(int mat_side, int mat_xside);
	static unsigned int get_phase(const Board & board);

      private:
	static const int pawn_scores[64];
	static const int pawn_scores_endgame[64];
	static const int knight_scores[64];
	static const int king_scores[64];
	static const int king_scores_endgame[64];

      private:
	int score_pawns(Color side);
	int score_knights(Color side);
	int score_bishops(Color side);
	int score_rooks(Color side);
	int score_queens(Color side);
	int score_king(Color side);
	int score_devel(Color side);
	int score_combo(Color side);
};

struct score_plugin {
	const char * name;
	int (Evaluator::* func)(Color);
};

#endif // EVAL_H
