/*
 *  JLib - Jacob's Library.
 *  Copyright (C) 2003, 2004  Juan Carlos Seijo Prez
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 * 
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  Juan Carlos Seijo Prez
 *  jacob@mainreactor.net
 */

/** Clase de aplicacin OpenGL.
 * @file    JGLApp.h
 * @author  Juan Carlos Seijo Prez
 * @date    01/04/2003
 * @version 0.0.1 - 01/04/2003 - Primera versin.
 */

#ifndef _JGLAPP_INCLUDED
#define _JGLAPP_INCLUDED

#ifdef WIN32
#include <windows.h>
#endif

#include <JLib/Util/JApp.h>
#include <SDL/SDL.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <stdio.h>

class JGLApp : public JApp
{
public:
  /** Crea la aplicacin.
   * @param  strTitle Ttulo de la aplicacin.
   * @param  w Anchura de la aplicacin.
   * @param  h Altura de la aplicacin.
   * @param  fullScr Flag de ejecucin en pantalla completa.
	 * @param  _depth Profundidad de color.
	 * @param  otherFlags Flags SDL adicionales. Por defecto son SDL_OPENGL | SDL_OPENGLBLIT.
   */
  JGLApp(const JString &strTitle, s32 w = 640, s32 h = 480, bool fullScr = false, s32 _depth = 16, u32 otherFlags = 0);

  /** Termina la aplicacin. La clase base se encarga de quitar SDL.
   */
  virtual ~JGLApp();

  /** Inicializa la aplicacin
   * @return <b>true</b> si se inicializ correctamente, <b>false</b> si no.
   */
  virtual bool Init();

	/** Intercambia el back-buffer con el front-buffer en caso de soportar doble buffer.
	 */
	void SwapBuffers() {SDL_GL_SwapBuffers();}
};

#endif  // JGLAPP_INCLUDED
