/*
 *  JLib - Jacob's Library.
 *  Copyright (C) 2003, 2004  Juan Carlos Seijo Prez
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 * 
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  Juan Carlos Seijo Prez
 *  jacob@mainreactor.net
 */

/** Timer.
 * @file    JTimer.h.
 * @author  Juan Carlos Seijo Prez.
 * @date    21/04/2003.
 * @version 0.0.1 - 21/04/2003 - Primera versin.
 */

#ifndef _JTIMER_INCLUDED
#define _JTIMER_INCLUDED

#include <JLib/Util/JTypes.h>
#include <JLib/Util/JObject.h>
#include <SDL/SDL.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <time.h>

/** Clase que encapsula una cuenta atrs cclica de baja precisin.
 */
class JTimer
{
protected:
	u32 start;	  	    /**< Primera medida (ciclo 0) */
	u32 pause;	  	    /**< Medida de pausa (millis) */
	u32 last;	  	      /**< ltima medida (millis) */
	
  u32 cycleTime;	    /**< Duracin del ciclo. */

  u32 cur;				    /**< Medida actual (millis) */

  u32 lastQueryCycle; /**< Ciclo en que estaba en la ltima consulta */

public:
	/** Construye e inicializa un nuevo cronmetro.
   * @param  millis Milisegundos por ciclo de cuenta.
   */
	JTimer(u32 millis = 1L);
	
	/** Comienza la cuenta.
   * @param  millis Milisegundos por ciclo de cuenta.
   */
	void Start(u32 millis = 0L);
	
	/** Pausa el timer.
   */
	void Pause();
	
	/** Continuar despus de pausa.
   */
	void Continue();
	
	/** Consulta el nmero de ms ocurridos desde el comienzo del ltimo ciclo.
   * @return Nmero de ms ocurridos desde el comienzo del ltimo ciclo.
   */
	u32 Lap();

	/** Consulta el nmero de ms que faltan para terminar el ciclo actual.
   * @return Nmero de ms que faltan para terminar el ciclo actual.
   */
	u32 Rem();

	/** Consulta el tiempo transcurrido entre llamadas a Tick().
   * @return Tiempo transcurrido entre llamadas a Tick().
   */
	u32 Tick();

  /** Consulta el nmero de ciclos desde el comienzo.
   * @return Nmero de ciclos desde el comienzo.
   */
	u32 Cycles();

  /** Consulta si hemos pasado a otro ciclo desde la ltima consulta a Lap() o Rem().
   * @return 0 si no hemos pasado, distinto de cero si lo hemos hecho.
   */
  u32 Changed();

  /** Consulta el nmero de ms ocurridos desde el comienzo.
   * @return Nmero de ms ocurridos desde el comienzo.
   */
  u32 TotalLap();

  /** Espera a que se complete el ciclo.
   */
  void WaitCycle();

  /** Devuelve el n de segundos de la poca (00:00h del 01/01/1970). 
   * @return n de segundos de la poca (00:00h del 01/01/1970).
   */
  static time_t CurS();
  
  /** Devuelve el n de milisegundos del segundo actual.
   * @return n de milisegundos del segundo actual.
   */
  static u16 CurMs();

  /** Devuelve el timestamp como cadena de texto.
   * @return timestamp como cadena de texto.
   */
  static const s8 * StrTime();

	/** Devuelve la duracin de ciclo.
	 * @return Duracin de ciclo.
	 */
	u32 CycleTime() {return cycleTime;}
};

#endif // _JTIMER_INCLUDED
