/*  HomeBank -- Free, easy, personal accounting for everyone.
 *  Copyright (C) 1995-2009 Maxime DOYEN
 *
 *  This file is part of HomeBank.
 *
 *  HomeBank is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  HomeBank is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "homebank.h"

#include "hb_transaction.h"

/****************************************************************************/
/* Debug macros										 */
/****************************************************************************/
#define MYDEBUG 0

#if MYDEBUG
#define DB(x) (x);
#else
#define DB(x);
#endif

/* our global datas */
extern struct HomeBank *GLOBALS;

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

//todo: this is only a test
gint transaction_auto_assign(GList *ope_list, guint key)
{
GList *l_ope;
GList *l_rul, *c_rul;
gint changes = 0;

	l_ope = g_list_first(ope_list);
	l_rul = g_hash_table_get_values(GLOBALS->h_rul);

	while (l_ope != NULL)
	{
	Operation *ope = l_ope->data;

		//DB( g_print("ope '%s' %d, %d\n", ope->wording, ope->payee, ope->category) );
		
		if( key == -1 || key == ope->account )
		{
		
		
			if( ope->payee == 0 && ope->category == 0 )
			{	
				c_rul = g_list_first(l_rul);
				while (c_rul != NULL)
				{
				Assign *rul = c_rul->data;

					DB( g_print("search %s in %s\n", rul->name, ope->wording) );
					if( rul->name != NULL)
					{
						if( rul->exact )
						{				
							if( g_strrstr(ope->wording, rul->name) != NULL )
							{
								DB( g_print(" found case\n") );
				
								ope->payee    = rul->payee;
								ope->category = rul->category;

								ope->flags |= OF_CHANGED;
								changes++;
							}
						}
						else
						{
						gchar *word   = g_utf8_casefold(ope->wording, -1);
						gchar *needle = g_utf8_casefold(rul->name, -1);
			
							if( g_strrstr(word, needle) != NULL )
							{
								DB( g_print(" found nocase\n") );
				
								ope->payee    = rul->payee;
								ope->category = rul->category;
					
								ope->flags |= OF_CHANGED;
								changes++;
							}
		
			
			
						}
					}

					c_rul = g_list_next(c_rul);
				}
			}
		
		}
		
		l_ope = g_list_next(l_ope);
	}

	g_list_free(l_rul);

	return changes;
}


/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */


guint
transaction_count_tags(Operation *ope)
{
guint count = 0;
guint32 *ptr = ope->tags;

	if( ope->tags == NULL )
		return 0;

	while(*ptr++ != 0 && count < 32)
		count++;

	return count;
}

guint
transaction_set_tags(Operation *ope, const gchar *tagstring)
{
gchar **str_array;
guint count, i;
Tag *tag;

	DB( g_print("(transaction_set_tags)\n") );

	str_array = g_strsplit (tagstring, " ", 0);
	count = g_strv_length( str_array );
	
	g_free(ope->tags);
	ope->tags = NULL;

	DB( g_print(" -> reset storage %x\n", ope->tags) );

	
	if( count > 0 )
	{
		
		ope->tags = g_new0(guint32, count + 1);

		DB( g_print(" -> storage %x\n", ope->tags) );

		for(i=0;i<count;i++)
		{
			tag = da_tag_get_by_name(str_array[i]);
			if(tag == NULL)
			{
			Tag *newtag = da_tag_malloc();
			
				newtag->name = g_strdup(str_array[i]);
				da_tag_append(newtag);
				tag = da_tag_get_by_name(str_array[i]);
			}
	
			DB( g_print(" -> storing %d=>%s at tags pos %d\n", tag->key, tag->name, i) );
	
			ope->tags[i] = tag->key;
		}
	}

	//hex_dump(ope->tags, sizeof(guint32*)*count+1);

	g_strfreev (str_array);

	return count;
}

gchar *
transaction_get_tagstring(Operation *ope)
{
guint count, i;
gchar **str_array;
gchar *tagstring;
Tag *tag;

	DB( g_print("transaction_get_tagstring\n") );

	DB( g_print(" -> tags at=%x\n", ope->tags) );

	if( ope->tags == NULL )
	{
	
		return NULL;
	}
	else
	{	
		count = transaction_count_tags(ope);

		DB( g_print(" -> tags at=%x, nbtags=%d\n", ope->tags, count) );

		str_array = g_new0(gchar*, count+1);	

		DB( g_print(" -> str_array at %x\n", str_array) );

		//hex_dump(ope->tags, sizeof(guint32*)*(count+1));

		for(i=0;i<count;i++)
		{
			DB( g_print(" -> try to get tag %d\n", ope->tags[i]) );
			
			tag = da_tag_get(ope->tags[i]);
			if( tag )
			{
				DB( g_print(" -> get %s at %d\n", tag->name, i) );
				str_array[i] = tag->name;
			}
			else
				str_array[i] = NULL;
			

		}

		tagstring = g_strjoinv(" ", str_array);

		g_free (str_array);

	}

	return tagstring;
}





