
#line 3 "lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 31
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE hydrestart(hydin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int hydleng;

extern FILE *hydin, *hydout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up hydtext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up hydtext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via hydrestart()), so that the user can continue scanning by
	 * just pointing hydin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when hydtext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int hydleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow hydwrap()'s to do buffer switches
 * instead of setting up a fresh hydin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void hydrestart (FILE *input_file  );
void hyd_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE hyd_create_buffer (FILE *file,int size  );
void hyd_delete_buffer (YY_BUFFER_STATE b  );
void hyd_flush_buffer (YY_BUFFER_STATE b  );
void hydpush_buffer_state (YY_BUFFER_STATE new_buffer  );
void hydpop_buffer_state (void );

static void hydensure_buffer_stack (void );
static void hyd_load_buffer_state (void );
static void hyd_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER hyd_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE hyd_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE hyd_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE hyd_scan_bytes (yyconst char *bytes,int len  );

void *hydalloc (yy_size_t  );
void *hydrealloc (void *,yy_size_t  );
void hydfree (void *  );

#define yy_new_buffer hyd_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        hydensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            hyd_create_buffer(hydin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        hydensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            hyd_create_buffer(hydin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *hydin = (FILE *) 0, *hydout = (FILE *) 0;

typedef int yy_state_type;

extern int hydlineno;

int hydlineno = 1;

extern char *hydtext;
#define yytext_ptr hydtext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up hydtext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	hydleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 88
#define YY_END_OF_BUFFER 89
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[327] =
    {   0,
        0,    0,   71,   71,   89,   87,   85,   84,   83,   87,
       87,   76,   79,   78,   82,   74,   81,   80,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   72,   71,   88,
        0,    0,   86,   76,    0,   74,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   62,   24,   59,
       76,   76,   76,   76,   37,   76,   15,   76,   43,   76,
       60,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   42,   76,

       76,   76,   76,   76,   76,   72,   71,   77,   75,   76,
       76,   76,    2,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   27,   76,   76,   76,   76,   76,   76,   76,   76,
       30,   20,   19,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   11,   76,   76,   76,   76,   25,   76,   53,
       76,   76,   76,   54,   26,   76,   76,   61,    0,   35,
       36,   76,   76,   76,   76,    4,   76,   76,   76,   76,
       76,   76,   44,   18,   76,   76,   76,   76,   76,   51,
       55,   76,   76,   76,   31,   58,   38,   76,   76,    7,

       76,   76,   76,    3,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   65,   76,   76,   76,    0,
       76,   76,   76,   76,    6,    5,   76,   69,   76,   76,
       76,   76,   29,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   21,   76,    8,   76,   28,   76,
       76,   50,   76,   76,   76,   76,   76,   76,    0,   10,
       76,   76,   76,    1,   76,   52,   76,   76,   76,   76,
       76,   76,   76,   76,   67,   76,   41,   76,   76,   13,
       76,   45,   57,   76,   49,   76,   48,   76,   22,   73,
       76,   76,   64,    9,   76,   56,   76,   16,   76,   70,

       76,   33,   47,   76,   76,   46,   76,   76,   32,   14,
       76,   23,   68,   17,   66,   76,   76,   76,   40,   34,
       63,   76,   39,   76,   12,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    1,    5,    6,    7,    1,    1,    1,    8,
        8,    8,    1,    1,    9,   10,   11,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   13,    1,    1,
       14,    1,    1,    1,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   16,   15,   17,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
        1,    1,    1,    1,    8,    1,   18,   19,   20,   21,

       22,   23,   24,   25,   26,   15,   27,   28,   29,   30,
       31,   32,   15,   33,   34,   35,   36,   15,   37,   38,
       39,   15,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[40] =
    {   0,
        1,    2,    2,    2,    3,    1,    1,    4,    4,    4,
        4,    4,    1,    1,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4
    } ;

static yyconst flex_int16_t yy_base[332] =
    {   0,
        0,    0,   38,   41,  351,  352,  352,  352,  352,    0,
      347,    0,  352,  352,  352,   36,  352,  352,  330,  329,
       29,   29,   25,   38,   26,   36,  321,   44,   47,   34,
       44,   51,   58,   66,   76,   98,   79,    0,   68,  352,
      341,  342,  352,    0,  332,   80,  311,  310,  306,  319,
      309,  308,  302,  306,  304,  303,  311,   76,  312,  300,
      300,  294,  303,  297,   75,  305,  296,    0,   67,    0,
      289,   80,  289,  284,    0,   59,    0,  300,    0,   95,
        0,  295,  286,  285,  286,  286,  281,  278,  278,  294,
      275,  279,  290,  278,  274,  274,  276,  275,    0,  273,

      270,  280,  267,  264,  276,    0,  117,  352,  113,  263,
      262,  269,    0,  263,  272,  255,  270,  270,  259,  270,
      251,  268,  263,  252,  251,  264,  248,  258,  245,  254,
      248,    0,  244,  247,  252,  251,  245,  236,  236,  246,
      231,    0,    0,  237,  240,  243,  230,  228,  224,  240,
      100,  225,    0,  226,  225,  226,  222,    0,  223,    0,
      222,  231,  222,    0,    0,  229,  224,    0,  237,    0,
        0,  217,  212,  209,  223,    0,  217,  221,  207,  217,
      204,  204,    0,  205,  208,  197,  202,  214,  204,    0,
        0,  196,  198,  200,    0,    0,    0,  208,  197,    0,

      196,  193,  194,    0,  185,  192,  187,  203,  198,  197,
      198,  194,  177,  189,  186,    0,  191,  194,  182,  116,
      180,  191,  182,  185,    0,    0,  184,    0,  177,  182,
      185,  176,    0,  171,  182,  177,  177,  167,  176,  161,
      161,  163,  155,  161,    0,  161,    0,  156,    0,  167,
      165,    0,  152,  150,  166,  155,  162,  159,  168,    0,
      144,  157,  147,    0,  141,    0,  140,  154,  151,  142,
      141,  148,  151,  129,    0,  140,    0,  140,  147,    0,
      129,    0,    0,  128,    0,  127,    0,  136,    0,  148,
      137,  123,    0,    0,  135,    0,  121,    0,  120,    0,

      126,    0,    0,  119,  124,    0,  127,  120,    0,    0,
      108,    0,    0,    0,    0,  110,  105,   98,    0,    0,
        0,   68,    0,   43,    0,  352,  135,  139,  143,   50,
      147
    } ;

static yyconst flex_int16_t yy_def[332] =
    {   0,
      326,    1,  327,  327,  326,  326,  326,  326,  326,  328,
      329,  330,  326,  326,  326,  326,  326,  326,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  331,  326,  326,
      328,  329,  326,  330,  326,  326,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,

      330,  330,  330,  330,  330,  331,  326,  326,  326,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  326,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,

      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  326,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  326,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  326,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,

      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
      330,  330,  330,  330,  330,    0,  326,  326,  326,  326,
      326
    } ;

static yyconst flex_int16_t yy_nxt[392] =
    {   0,
        6,    7,    8,    9,   10,   11,   12,    6,   13,   14,
       15,   16,   17,   18,   12,   19,   20,   21,   22,   23,
       24,   25,   26,   27,   12,   28,   12,   29,   30,   31,
       32,   33,   34,   35,   36,   37,   12,   12,   12,   39,
       40,   39,   39,   40,   39,   45,   52,   46,   49,   50,
       53,   74,   56,   44,   54,   62,   55,   57,   51,   58,
       63,   64,   59,   67,   71,   76,   68,   75,   65,  107,
       60,  107,   72,   69,   77,   70,   61,   73,   78,   83,
       79,  325,   80,   86,   81,   82,  134,   87,   84,   45,
       85,   46,  130,  141,  121,  142,   88,   89,  122,  101,

       90,  135,  324,  123,  102,  131,   91,   92,  103,  137,
      104,   93,  105,  138,   94,   95,  144,   96,  107,   97,
      107,  207,  169,   98,  109,  259,  323,  220,   99,  145,
      322,  321,  320,  100,  208,   38,   38,   38,   38,   41,
       41,  319,   41,   42,   42,   42,   42,  106,  318,  106,
      106,  317,  316,  315,  314,  313,  312,  311,  310,  290,
      309,  308,  307,  306,  305,  304,  303,  302,  301,  300,
      299,  298,  297,  296,  295,  294,  293,  292,  291,  290,
      289,  288,  287,  286,  285,  284,  283,  282,  281,  280,
      279,  278,  277,  276,  275,  274,  273,  272,  271,  270,

      269,  268,  267,  266,  265,  264,  263,  262,  261,  260,
      258,  257,  256,  255,  254,  253,  252,  251,  250,  249,
      248,  247,  246,  245,  244,  243,  242,  241,  240,  239,
      238,  237,  236,  235,  234,  233,  232,  231,  230,  229,
      228,  227,  226,  225,  224,  223,  222,  221,  220,  219,
      218,  217,  216,  215,  214,  213,  212,  211,  210,  209,
      206,  205,  204,  203,  202,  201,  200,  199,  198,  197,
      196,  195,  194,  193,  192,  191,  190,  189,  188,  187,
      186,  185,  184,  183,  182,  181,  180,  179,  178,  177,
      176,  175,  174,  173,  172,  171,  170,  168,  167,  166,

      165,  164,  163,  162,  161,  160,  159,  158,  157,  156,
      155,  154,  153,  152,  151,  150,  149,  148,  147,  146,
      143,  140,  139,  136,  133,  132,  129,  128,  127,  126,
      125,  124,  120,  119,  118,  117,  116,  115,  114,  113,
      112,  111,  110,  109,   43,  108,   66,   48,   47,   43,
      326,    5,  326,  326,  326,  326,  326,  326,  326,  326,
      326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
      326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
      326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
      326

    } ;

static yyconst flex_int16_t yy_chk[392] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    3,
        3,    3,    4,    4,    4,   16,   22,   16,   21,   21,
       22,   30,   23,  330,   22,   25,   22,   23,   21,   24,
       25,   26,   24,   28,   29,   31,   28,   30,   26,   39,
       24,   39,   29,   28,   31,   28,   24,   29,   32,   33,
       32,  324,   32,   34,   32,   32,   69,   34,   33,   46,
       33,   46,   65,   76,   58,   76,   34,   35,   58,   37,

       35,   69,  322,   58,   37,   65,   35,   35,   37,   72,
       37,   35,   37,   72,   35,   36,   80,   36,  107,   36,
      107,  151,  109,   36,  109,  220,  318,  220,   36,   80,
      317,  316,  311,   36,  151,  327,  327,  327,  327,  328,
      328,  308,  328,  329,  329,  329,  329,  331,  307,  331,
      331,  305,  304,  301,  299,  297,  295,  292,  291,  290,
      288,  286,  284,  281,  279,  278,  276,  274,  273,  272,
      271,  270,  269,  268,  267,  265,  263,  262,  261,  259,
      258,  257,  256,  255,  254,  253,  251,  250,  248,  246,
      244,  243,  242,  241,  240,  239,  238,  237,  236,  235,

      234,  232,  231,  230,  229,  227,  224,  223,  222,  221,
      219,  218,  217,  215,  214,  213,  212,  211,  210,  209,
      208,  207,  206,  205,  203,  202,  201,  199,  198,  194,
      193,  192,  189,  188,  187,  186,  185,  184,  182,  181,
      180,  179,  178,  177,  175,  174,  173,  172,  169,  167,
      166,  163,  162,  161,  159,  157,  156,  155,  154,  152,
      150,  149,  148,  147,  146,  145,  144,  141,  140,  139,
      138,  137,  136,  135,  134,  133,  131,  130,  129,  128,
      127,  126,  125,  124,  123,  122,  121,  120,  119,  118,
      117,  116,  115,  114,  112,  111,  110,  105,  104,  103,

      102,  101,  100,   98,   97,   96,   95,   94,   93,   92,
       91,   90,   89,   88,   87,   86,   85,   84,   83,   82,
       78,   74,   73,   71,   67,   66,   64,   63,   62,   61,
       60,   59,   57,   56,   55,   54,   53,   52,   51,   50,
       49,   48,   47,   45,   42,   41,   27,   20,   19,   11,
        5,  326,  326,  326,  326,  326,  326,  326,  326,  326,
      326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
      326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
      326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
      326

    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int hyd_flex_debug;
int hyd_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *hydtext;
#line 1 "lex.l"
/*
 * Copyright (c) 2002, 2003, 2004 Niels Provos <provos@citi.umich.edu>
 * All rights reserved.
 *
 * <LICENSEHERE> 
 */

#line 10 "lex.l"
#include <sys/types.h>
#include <sys/tree.h>

#include "config.h"

#include <sys/queue.h>
#include <sys/socket.h>
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <err.h>
#include <stdarg.h>
#include <string.h>
#ifdef HAVE_TIME_H
#include <time.h>
#endif

#include <dnet.h>

#include <event.h>

#include "honeyd.h"
#include "router.h"
#include "personality.h"
#include "plugins_config.h"
#include "condition.h"
#include "parse.h"

int hyderror(char *fmt, ...);
#define yyerror hyderror

extern int lineno;
extern char *filename;
extern int curtype;

#define MAX_INCLUDE_DEPTH 10

YY_BUFFER_STATE includes[MAX_INCLUDE_DEPTH];
int linenos[MAX_INCLUDE_DEPTH];
char *filenames[MAX_INCLUDE_DEPTH];
int includes_index = 0;

#line 690 "lex.c"

#define INITIAL 0
#define incl 1

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int hydwrap (void );
#else
extern int hydwrap (void );
#endif
#endif

    static void yyunput (int c,char *buf_ptr  );
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( hydtext, hydleng, 1, hydout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( hydin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( hydin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, hydin))==0 && ferror(hydin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(hydin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int hydlex (void);

#define YY_DECL int hydlex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after hydtext and hydleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 57 "lex.l"

#line 844 "lex.c"

	if ( (yy_init) )
		{
		(yy_init) = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! hydin )
			hydin = stdin;

		if ( ! hydout )
			hydout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			hydensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				hyd_create_buffer(hydin,YY_BUF_SIZE );
		}

		hyd_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of hydtext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 327 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 352 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 58 "lex.l"
{ return CREATE; }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 59 "lex.l"
{ return ADD; }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 60 "lex.l"
{ return PORT; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 61 "lex.l"
{ return BIND; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 62 "lex.l"
{ return CLONE; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 63 "lex.l"
{ return BLOCK; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 64 "lex.l"
{ return OPEN; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 65 "lex.l"
{ return RESET; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 66 "lex.l"
{ return DEFAULT; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 67 "lex.l"
{ return ACTION; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 68 "lex.l"
{ return SET; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 69 "lex.l"
{ return PERSONALITY; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 70 "lex.l"
{ return RANDOM; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 71 "lex.l"
{ return ANNOTATE; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 72 "lex.l"
{ return NO; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 73 "lex.l"
{ return FINSCAN; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 74 "lex.l"
{ return FRAGMENT; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 75 "lex.l"
{ return DROP; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 76 "lex.l"
{ return OLD; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 77 "lex.l"
{ return NEW; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 78 "lex.l"
{ return PROXY; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 79 "lex.l"
{ return UPTIME; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 80 "lex.l"
{ return DROPRATE; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 81 "lex.l"
{ return IN; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 82 "lex.l"
{ return SYN; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 83 "lex.l"
{ return UID; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 84 "lex.l"
{ return GID; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 85 "lex.l"
{ return ROUTE; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 86 "lex.l"
{ return ENTRY; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 87 "lex.l"
{ return NET; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 88 "lex.l"
{ return LINK; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 89 "lex.l"
{ return UNREACH; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 90 "lex.l"
{ return LATENCY; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 91 "lex.l"
{ return BANDWIDTH; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 92 "lex.l"
{ yylval.number = 1000; return NUMBER; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 93 "lex.l"
{ yylval.number = 1000000; return NUMBER; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 94 "lex.l"
{ return MS; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 95 "lex.l"
{ return LOSS; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 96 "lex.l"
{ return SUBSYSTEM; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 97 "lex.l"
{ return TEMPLATE; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 98 "lex.l"
{ return OPTION; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 99 "lex.l"
{ return TO; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 100 "lex.l"
{ return ON; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 101 "lex.l"
{ return DHCP; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 102 "lex.l"
{ return SHARED; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 103 "lex.l"
{ return RESTART; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 104 "lex.l"
{ return NETWORK; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 105 "lex.l"
{ return TUNNEL; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 106 "lex.l"
{ return TARPIT; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 107 "lex.l"
{ return SPOOF; }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 108 "lex.l"
{ return FROM; }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 109 "lex.l"
{ return DELETE; }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 110 "lex.l"
{ yylval.number = IP_PROTO_TCP;
		  curtype = SOCK_STREAM; return PROTO; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 112 "lex.l"
{ yylval.number = IP_PROTO_UDP;
		  curtype = SOCK_DGRAM; return PROTO; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 114 "lex.l"
{ yylval.number = IP_PROTO_ICMP; return PROTO; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 115 "lex.l"
{ return DYNAMIC; }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 116 "lex.l"
{ return SOURCE; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 117 "lex.l"
{ return LIST; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 118 "lex.l"
{ return IP; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 119 "lex.l"
{ return OS; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 120 "lex.l"
{ return USE; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 121 "lex.l"
{ return IF; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 122 "lex.l"
{ return OTHERWISE; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 123 "lex.l"
{ return BETWEEN; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 124 "lex.l"
{ return TIME; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 125 "lex.l"
{ return INTERNAL; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 126 "lex.l"
{ return MAXFDS; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 127 "lex.l"
{ return ETHERNET; }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 128 "lex.l"
{ return DEBUG; }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 129 "lex.l"
{ BEGIN(incl); }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 130 "lex.l"
/* eat the whitespace */
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 131 "lex.l"
{ /* got the include file name */
		  if (includes_index >= MAX_INCLUDE_DEPTH) {
			  yyerror("Includes nested too deeply");
			  exit(1);
		  }

		  linenos[includes_index] = lineno;
		  filenames[includes_index] = filename;
		  includes[includes_index++] = YY_CURRENT_BUFFER;
		  if ((hydin = fopen(hydtext, "r")) == NULL) {
			yyerror("Can not open \"%s\"", hydtext);
			exit(1);
		  }
		  filename = strdup(hydtext);
		  lineno = 1;
		  hyd_switch_to_buffer(hyd_create_buffer(hydin,YY_BUF_SIZE));

                  BEGIN(INITIAL);
		}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(incl):
#line 150 "lex.l"
{
		  if (--includes_index < 0)
			  yyterminate();
		  else {
			  free(filenames[includes_index + 1]);
			  filename = filenames[includes_index];
			  lineno = linenos[includes_index];
			  hyd_delete_buffer(YY_CURRENT_BUFFER);
			  hyd_switch_to_buffer(includes[includes_index]);
		  }
		}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 161 "lex.l"
{ yylval.string = strdup(hydtext); return IPSTRING; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 162 "lex.l"
{ yylval.number = atoi(hydtext); return NUMBER; }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 163 "lex.l"
{ yylval.floatp = atof(hydtext); return FLOAT; }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 164 "lex.l"
{ yylval.string = strdup(hydtext); return STRING; }
	YY_BREAK
case 77:
/* rule 77 can match eol */
YY_RULE_SETUP
#line 165 "lex.l"
{ yylval.string = strdup(hydtext); return CMDSTRING; }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 166 "lex.l"
{ return DOT; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 167 "lex.l"
{ return DASH; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 168 "lex.l"
{ return EQUAL; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 169 "lex.l"
{ return COLON; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 170 "lex.l"
{ return SLASH; }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 171 "lex.l"
{ ; }
	YY_BREAK
case 84:
/* rule 84 can match eol */
YY_RULE_SETUP
#line 172 "lex.l"
{ lineno++;}
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 173 "lex.l"
{ ; }
	YY_BREAK
case 86:
/* rule 86 can match eol */
YY_RULE_SETUP
#line 174 "lex.l"
{ lineno++; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 175 "lex.l"
{ yyerror("illegal token"); }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 176 "lex.l"
ECHO;
	YY_BREAK
#line 1405 "lex.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed hydin at a new source and called
			 * hydlex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = hydin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( hydwrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * hydtext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of hydlex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					hydrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			hydrestart(hydin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 327 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 327 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 326);

	return yy_is_jam ? 0 : yy_current_state;
}

    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up hydtext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					hydrestart(hydin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( hydwrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve hydtext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void hydrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        hydensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            hyd_create_buffer(hydin,YY_BUF_SIZE );
	}

	hyd_init_buffer(YY_CURRENT_BUFFER,input_file );
	hyd_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void hyd_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		hydpop_buffer_state();
	 *		hydpush_buffer_state(new_buffer);
     */
	hydensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	hyd_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (hydwrap()) processing, but the only time this flag
	 * is looked at is after hydwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void hyd_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	hydin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE hyd_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) hydalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in hyd_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) hydalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in hyd_create_buffer()" );

	b->yy_is_our_buffer = 1;

	hyd_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with hyd_create_buffer()
 * 
 */
    void hyd_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		hydfree((void *) b->yy_ch_buf  );

	hydfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a hydrestart() or at EOF.
 */
    static void hyd_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	hyd_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then hyd_init_buffer was _probably_
     * called from hydrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void hyd_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		hyd_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void hydpush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	hydensure_buffer_stack();

	/* This block is copied from hyd_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from hyd_switch_to_buffer. */
	hyd_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void hydpop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	hyd_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		hyd_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void hydensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)hydalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)hydrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE hyd_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) hydalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in hyd_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	hyd_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to hydlex() will
 * scan from a @e copy of @a str.
 * @param str a NUL-terminated string to scan
 * @param yy_str a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       hyd_scan_bytes() instead.
 */
YY_BUFFER_STATE hyd_scan_string (yyconst char * yy_str )
{
    
	return hyd_scan_bytes(yy_str,strlen(yy_str) );
}

/** Setup the input buffer state to scan the given bytes. The next call to hydlex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE hyd_scan_bytes  (yyconst char * bytes, int  len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) hydalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in hyd_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = hyd_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in hyd_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up hydtext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		hydtext[hydleng] = (yy_hold_char); \
		(yy_c_buf_p) = hydtext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		hydleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int hydget_lineno  (void)
{
        
    return hydlineno;
}

/** Get the input stream.
 * 
 */
FILE *hydget_in  (void)
{
        return hydin;
}

/** Get the output stream.
 * 
 */
FILE *hydget_out  (void)
{
        return hydout;
}

/** Get the length of the current token.
 * 
 */
int hydget_leng  (void)
{
        return hydleng;
}

/** Get the current token.
 * 
 */

char *hydget_text  (void)
{
        return hydtext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void hydset_lineno (int  line_number )
{
    
    hydlineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see hyd_switch_to_buffer
 */
void hydset_in (FILE *  in_str )
{
        hydin = in_str ;
}

void hydset_out (FILE *  out_str )
{
        hydout = out_str ;
}

int hydget_debug  (void)
{
        return hyd_flex_debug;
}

void hydset_debug (int  bdebug )
{
        hyd_flex_debug = bdebug ;
}

/* hydlex_destroy is for both reentrant and non-reentrant scanners. */
int hydlex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		hyd_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		hydpop_buffer_state();
	}

	/* Destroy the stack itself. */
	hydfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
    	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
    	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *hydalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *hydrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void hydfree (void * ptr )
{
	free( (char *) ptr );	/* see hydrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#undef YY_NEW_FILE
#undef YY_FLUSH_BUFFER
#undef yy_set_bol
#undef yy_new_buffer
#undef yy_set_interactive
#undef yytext_ptr
#undef YY_DO_BEFORE_ACTION

#ifdef YY_DECL_IS_OURS
#undef YY_DECL_IS_OURS
#undef YY_DECL
#endif
#line 176 "lex.l"


#ifndef hydwrap
int hydwrap() { return 1; }
#endif

