<?php
/*
 * $Horde: horde/index.php,v 2.43.2.12 2005/01/03 11:25:44 jan Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2005 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__));
$horde_configured = (@file_exists(HORDE_BASE . '/config/horde.php') &&
                     @file_exists(HORDE_BASE . '/config/html.php') &&
                     @file_exists(HORDE_BASE . '/config/mime_drivers.php') &&
                     @file_exists(HORDE_BASE . '/config/mime_mapping.php') &&
                     @file_exists(HORDE_BASE . '/config/registry.php'));

if ($horde_configured) {
    include_once HORDE_BASE . '/lib/base.php';

    $initial_app = $prefs->getValue('initial_application');
    if (!empty($initial_app)) {
        $main_page = Horde::url($registry->getInitialPage($initial_app));
    } elseif (isset($registry->applications['horde']['initial_page'])) {
        $main_page = Horde::applicationUrl($registry->applications['horde']['initial_page']);
    } else {
        $main_page = Horde::applicationUrl('login.php');
    }
    if ($browser->hasFeature('wml')) {
        include HORDE_TEMPLATES . '/index/wap.inc';
    } elseif ($conf['menu']['floating_bar'] && (!$browser->hasQuirk('avoid_popup_windows'))) {
        $flmenu_width = count($registry->applications) * 60;
        include HORDE_TEMPLATES . '/index/floating_index.inc';
    } else {
        if ($browser->hasQuirk('scrollbar_in_way')) {
            $scrollbar = 'yes';
        } else {
            $scrollbar = 'auto';
        }
        include HORDE_TEMPLATES . '/index/frames_index.inc';
    }
} else {
    include HORDE_BASE . '/templates/index/notconfigured.inc';
}

?>
