<?php
/**
 * $Horde: framework/RDO/RDO/Criteria.php,v 1.5.2.1 2005/10/18 11:01:22 jan Exp $
 *
 * Uses a Composite to represent a single criterion or a tree of many
 * criteria uniformly to clients. RDO_Criteria is the Component part
 * of the Composite pattern.
 *
 * @package RDO
 */
abstract class RDO_Criteria {

    public $relationships = array();

    public $mapper;

    public $conjunction = 'AND';

    public $fields = array();

    public $tests = array();

    public $limit;

    public function __construct($mapper = null)
    {
        $this->mapper = $mapper;
    }

    public function setMapper(RDO_Mapper $mapper)
    {
        $this->mapper = $mapper;
    }

    public function setFields($fields)
    {
        $this->fields = $fields;
    }

    public function combineWith($conjunction)
    {
        $this->conjunction = $conjunction;
    }

    public function addTest($field, $test, $value)
    {
        $this->tests[] = array('field' => $field,
                               'test' => $test,
                               'value' => $value);
    }

    public function limit($limit)
    {
        $this->limit = $limit;
    }

    public function addRelationship(RDO_Mapper $mapper, $container, $criteria)
    {
        $this->relationships[] = array('mapper' => $mapper,
                                       'container' => $container,
                                       'criteria' => $criteria);
    }

}

/**
 * RDO_Criterion models a single criterion in a search or query. It is
 * the Leaf part of the Composite pattern.
 *
 * @package RDO
 */
class RDO_Criterion extends RDO_Criteria {

}

/**
 * RDO_CriteriaGroup models a grouped set of criteria. It is the
 * Composite part of the Composite pattern.
 *
 * CriteriaGroup objects contain information about how their component
 * RDO_Criteria objects are to be assembled (AND, OR, etc).
 *
 * @package RDO
 */
class RDO_CriteriaGroup extends RDO_Criteria {

    public function addAnd(RDO_Criteria $criteria)
    {
    }

    public function addOr(RDO_Criteria $criteria)
    {
    }

    public function addUnion(RDO_Criteria $criteria)
    {
    }

}
