<?php
/**
 * MetaData class for RDO.
 *
 * $Horde: framework/RDO/RDO/MetaData.php,v 1.3.2.1 2005/10/18 11:01:23 jan Exp $
 *
 * @package RDO
 */
class RDO_MetaData {

    private $mapper;
    private $properties = array();
    private $fields = array();

    const NOT_NULL = 1;
    const PRIMARY = 2;
    const REQUIRED = 4;

    const INTEGER = 'int';
    const STRING = 'string';

    public function __construct(RDO_Mapper $mapper)
    {
        $this->mapper = $mapper;
    }

    public function __get($property)
    {
        return isset($this->properties[$property]) ? $this->properties[$property] : null;
    }

    public function __set($property, $value)
    {
        $this->properties[$property] = $value;
    }

    public function hasField($field)
    {
        return isset($this->fields[$field]);
    }

    public function addField($field, $params)
    {
        $this->fields[$field] = $params;
    }

    public function getField($field)
    {
        return isset($this->fields[$field]) ? $this->fields[$field] : null;
    }

    public function setFieldType($field, $rawtype)
    {
        if (stripos($rawtype, 'int') !== false) {
            $this->fields[$field]['type'] = self::INTEGER;
        } elseif (stripos($rawtype, 'char') !== false) {
            $this->fields[$field]['type'] = self::STRING;
        }
    }

}
