<?php
/**
 * Horde JavaScript Toggle.
 *
 * This script will disable permanently the javascript by storing a value in
 * in the session, which will override any automatic detection of javascript
 * support in the browser.
 * To re-enable the automatic detection, the script will unset the session
 * variable.
 *
 * $Horde: horde/services/toggle_js.php,v 1.1.2.1 2005/10/18 11:34:01 jan Exp $
 *
 * See the enclosed file COPYING for license information (LGPL). If you did not
 * receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

@define('HORDE_BASE', dirname(__FILE__) . '/..');
require_once HORDE_BASE . '/lib/core.php';

$registry = &Registry::singleton();

/* Enable or disable? */
if (Util::getFormData('value')) {
    /* Enabling, so remove any session setting. */
    unset($_SESSION['callbacks']['browser.disableJavascript']);
} else {
    /* Disabling, so add a callback function to the session. */
    $_SESSION['callbacks']['browser.disableJavascript'] = true;
}

/* Return back to the originating URL. */
$url = Util::getFormData('url');
header('Location: ' . Horde::url($url, true));
