#include "hotwayd.h"
#include <sys/time.h>

/* 20030209: In the name of sanity, move all caching operations to
 * cache.c, add char *response; to the cmdtable struct, and generally
 * clean up any globals related to caching. "It was a mess when I got
 * here" is no excuse ;^)
 *
 * As an aside, i think it's safe to cache much more aggresively, but
 * it requires keeping track of things a bit better than certain
 * sections of the current code allow.. 
 *  -jbm
 */

cmdtable *prev_command;

/* 20030128: prev_command points to the previously executed command (if to anything).
 \ prev_response contains the response/result of that command. It could of course
 \ be contained in prev_command: that would make caching persistent across commands, but
 \ would result in the possibility of obtaining the text of a just deleted message...
 */

/* 20030128 RJVB: register an executed command and the resultant response. This is currently
 \ (to be) done in the lower-level routines called from the toplevel ones in hotwayd.c, such
 \ as httpmail_retrieve(). This because errors result in clearing the cache (a foolproofness
 \ measure).
 */
void register_command( cmdtable *command, char *response, int argc, char *arg1, char *arg2 )
{
	int i;

	if( prev_command && prev_command->argc > 0 ){
		for( i = 0; i < prev_command->argc; i++ )
			free( prev_command->argv[i] );
		prev_command->argc= 0;
		free(prev_command->response);
	}

	if( response && command ){
		struct timeval tv;
		struct timezone tz;

		command->response= strdup(response);

		/* why not time() here? we only need a relative
		 * timestamp -jbm */

		gettimeofday( &tv, &tz );
		command->timestamp= tv.tv_sec;
		if( argc > 0 ){
			char *a;
			command->argc= MIN( argc, MAXARGC );
			for( i = 0; i < command->argc; i++ ){
				switch( i ){
				case 0:
					a= arg1;
					break;
				case 1:
					a= arg2;
					break;
				default:
					a= NULL;
					break;
				}
				command->argv[i]= (a) ? strdup(a) : NULL;
			}
		}
		prev_command= command;
#ifdef DEBUG
		fprintf( stderr, "Command \"%s\" registered in cache with timestamp %ld and %d arg(s)\n",
			 prev_command->name, prev_command->timestamp, prev_command->argc 
			);
#endif
	}
	else{
		prev_command= NULL;		
	}
}

cmdtable *cached_command( cmdtable *command, int argc, char **argv )
{ 
	struct timeval tv;
	struct timezone tz;

	gettimeofday( &tv, &tz );
	argc= MIN( argc-1, MAXARGC );
	if( prev_command && command->handler== prev_command->handler && 
		argc== prev_command->argc && tv.tv_sec- prev_command->timestamp<= 30
	){
		if( argc ){
		  int i;
		  char *a;
			for( i= 0; i< argc; i++ ){
				  /* If no previous argument was found, or it is different than the current at the matching
				   \ position, we exit with a failure status. The current command must be looked up at
				   \ offset 1 (argv[0] is the POP command name).
				   */
				if( !prev_command->argv[i] || strcmp( argv[i+1], prev_command->argv[i]) ){
					return NULL;
				}
			}
		}
		return prev_command;
	}
	else{
		return(0);
	}
}

