/*
 * hotwayd.h -- is a POP3-HTTPMail gateway. It will allow you to
 * check your HOTMAIL account from your unix box.
 * Created: Espeleta Tomas <espeleta@libero.it>, 12-Apr-2001
 * This POP3 code is based on nupop-0.4, by Kevin Stone <kstone@nuvox.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h> 
#include <syslog.h>
#include <unistd.h>
#include <errno.h>

#define N_BUFLEN 200
#define N_BUFFER 1024
#define N_MYBUF 1024
#define N_PAIR 1024
#define N_XML_LENGTH 16
#define N_PASSWORD 32

#define PAM_SERVICE_NAME "hotway"

#define SYSLOGNAME "hotway"
#define SYSLOGFACILITY LOG_LOCAL7

#ifndef MIN
#	define MIN(a,b)                (((a)<(b))?(a):(b))
#endif

/* the following are login errors */
#define E_LOGIN_NO_DOMAIN 0
#define E_LOGIN_UNRECOGNISED_DOMAIN 1
#define E_LOGIN_OK 2


/* #define PSOUT(args...) printf( args)	*/
#define PSOUT(args) fputs( args, stdout)
#define PFSOUT(args...) printf( args)
#define PCHAR(y) putchar(y)
#define PFLUSH fflush(stdout);
#define PCRLF PSOUT("\015\012"); fflush(stdout);

#define LOG(args...) syslog(LOG_DEBUG, args ); DPRINTF( args );
#define OPENLOG openlog(SYSLOGNAME, LOG_PID | LOG_NDELAY, SYSLOGFACILITY);
#define CLOSELOG closelog();	

#ifdef DEBUG
#define DPRINTF(args...) printf( args)
#else
#define DPRINTF(args...)
#endif

/* the OpenBSD strlcpy/strlcat functions */
size_t strlcpy(char *, const char*, size_t);
size_t strlcat(char *, const char*, size_t);

#define MAXARGC 4

typedef struct cmdtable {
		char name[10];
		int  states;
		void  (*handler)(struct cmdtable *, int, char *[]);
		int argc;
		char *argv[MAXARGC];
		long timestamp;
  char *response;
} cmdtable;

/* httpmail_ functions */
long httpmail_nemails(void);
void httpmail_destroy(void);
int httpmail_authenticate_user(char *, char *);
void httpmail_init(void);
void httpmail_stat(cmdtable *);
void httpmail_list(cmdtable *,char *);
void httpmail_rset(cmdtable *);
void httpmail_retrieve(cmdtable *,char *);
void httpmail_delete(cmdtable *,char *);
char *gen_uidl(char *, char *);
void httpmail_uidl(cmdtable *,char *);
void httpmail_top(cmdtable *,char *, char *);

extern void register_command( cmdtable *command, char *response, int argc, char *arg1, char *arg2 );
