/*
 * httpmail.h -- HTTPMail hack, some useful definition
 * Created: Espeleta Tomas <espeleta@libero.it>, 12-Apr-2001
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

/* Define HOTWAY_ONLY_NEW to have hotwayd deal only with new
 *  messages- pik 20021025 */

/* #define HOTWAY_ONLY_NEW */

#define MAX_COOKIES		16

#define INVALIDUSER     503
#define AUTHORIZATION   401
#define MOVED           302
#define MULTISTATUS		207
#define OKSTATUS		200
#define ERROR           50
#define PASSWORDFAILED	51

#define MSGFOLDERROOT	1
#define INBOXPROPS		2
#define MSGLIST			3

/* Cookie: has a key/value pair and is valid for a domain */
typedef struct keypairSt {
	char *key;
	char *value;
	char *domain;
} KEYPAIR;

/* For each message on server we grab only these properties... */
typedef struct msg_props_struct {
	char *href;
	int readmark;
	int length, deleted;
	char *message;
} MSG_STRUCT;

/* Inbox structure, here we read xml info passed by hotmail server... */
typedef struct inbox_props_struct {
	char *name;
	char *href;
	char *trash;
	int isfolder;
	int hassubs;
	int nosubs;
	int unreadcount;
	int visiblecount;
	MSG_STRUCT **msg_props;
	MSG_STRUCT **unread_props;
} FOLDER_STRUCT;

#ifndef HOTWAY_ONLY_NEW
# define list_props msg_props
# define listcount visiblecount
#else
# define list_props unread_props
# define listcount unreadcount
#endif
