#!/usr/bin/perl

package main;

use XML::Twig;

my $DATADIR="data";

$file;
my @files;
$counter=1;

open(INDEX,"> $DATADIR/.index.tmp");

my $twig= new XML::Twig(TwigRoots => {'/httpush/server' => 1}, KeepSpaces => 1, TwigHandlers => { 'server' => \&doindex});

opendir(DIR, "$DATADIR/") || die "can't open directory data: $!";
@files = grep { !/(^\.|~$)/ && -f "$DATADIR/$_" } readdir(DIR);
closedir DIR;

foreach $file (@files)
 {
 $twig->safe_parsefile("$DATADIR/$file") || die("$!");
 $twig->purge();
 }

close(INDEX);

if (! -e "$DATADIR/.index.tmp" || -f "$DATADIR/.index.tmp")
  {
  rename ("$DATADIR/.index.tmp","$DATADIR/.index") || die("can't create index file");
  }
else
  {
  print STDERR "Something strange with .index.tmp file, refusing to create it\n";
  exit(1);
  }

sub doindex {
 my ($twig,$server)=@_;
 my $desc, $tmp, $desc2, $ch;

 $desc=$server->first_child_text('desc');

 $desc2="";

 foreach $ch ($server->children('fqdn'))
  {
  if($tmp=$ch->text)
    {
    $desc2.="$tmp ";
    }
  }

 print INDEX $counter." \"$file\" \"$desc\" $desc2\n";
 $counter++;

 $twig->purge();
}
