/****************************************************************************
 *
 * Copyright (c) 1997-2004 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef MEMMGR_H
#define MEMMGR_H

#include "xpl.h"

/* Library Specific */
#define MEMMGR_API_VERSION          1
#define MEMMGR_API_COMPATIBILITY    1

typedef BOOL (*PoolEntryCB)(void *Buffer, void *ClientData);

typedef struct _MemStatistics {
    struct {
        unsigned long count;
        unsigned long size;
    } totalAlloc;

    unsigned long pitches;
    unsigned long hits;
    unsigned long strikes;

    struct {
        unsigned long size;

        unsigned long minimum;
        unsigned long maximum;

        unsigned long allocated;
    } entry;

    unsigned char *name;

    struct _MemStatistics *next;
    struct _MemStatistics *previous;
} MemStatistics;

EXPORT BOOL MemoryManagerOpen(const unsigned char *AgentName);
EXPORT BOOL MemoryManagerClose(const unsigned char *AgentName);

/*    Memory Allocation API's    */
EXPORT void *MemCallocDirect(size_t Number, size_t Size);
EXPORT void *MemCallocDebugDirect(size_t Number, size_t Size, unsigned char *SourceFile, unsigned long SourceLine);

EXPORT void *MemMallocDirect(size_t Size);
EXPORT void *MemMallocDebugDirect(size_t Size, unsigned char *SourceFile, unsigned long SourceLine);

EXPORT void *MemReallocDirect(void *Source, size_t Size);
EXPORT void *MemReallocDebugDirect(void *Source, size_t Size, unsigned char *SourceFile, unsigned long SourceLine);

#if !defined(DEBUG)
#define MemCalloc(n, s)     MemCallocDirect((n), (s))
#else
#define MemCalloc(n, s)     MemCallocDebugDirect((n), (s), __FILE__, __LINE__)
#endif

#if !defined(DEBUG)
#define MemMalloc(s)        MemMallocDirect((s))
#else
#define MemMalloc(s)        MemMallocDebugDirect((s), __FILE__, __LINE__)
#endif

#if !defined(DEBUG)
#define MemRealloc(m, s)    MemReallocDirect((m), (s))
#else
#define MemRealloc(m, s)    MemReallocDebugDirect((m), (s), __FILE__, __LINE__)
#endif

/*    Memory De-Allocation API's    */
EXPORT void MemFreeDirect(void *Source);
EXPORT void MemFreeDebugDirect(void *Source, unsigned char *SourceFile, unsigned long SourceLine);

#if !defined(DEBUG)
#define MemFree(m)          MemFreeDirect((m))
#else
#define MemFree(m)          MemFreeDebugDirect((m), __FILE__, __LINE__)
#endif

/*    String Allocation API's    */
EXPORT char *MemStrdupDirect(const char *StrSource);
EXPORT char *MemStrdupDebugDirect(const char *StrSource, unsigned char *SourceFile, unsigned long SourceLine);

#if !defined(DEBUG)
#define MemStrdup(s)        MemStrdupDirect((s))
#else
#define MemStrdup(s)        MemStrdupDebugDirect((s), __FILE__, __LINE__)
#endif

/*    Management Statistics    */
EXPORT MemStatistics *MemAllocStatistics(void);
EXPORT void MemFreeStatistics(MemStatistics *Statistics);

/*    Private Pool API's    */
EXPORT void *MemPrivatePoolAlloc(unsigned char *Ident, size_t AllocationSize, unsigned int MinAllocCount, unsigned int MaxAllocCount, BOOL Dynamic, BOOL Temporary, PoolEntryCB AllocCB, PoolEntryCB FreeCB, void *ClientData);
EXPORT void MemPrivatePoolFree(void *PoolHandle);
EXPORT void MemPrivatePoolEnumerate(void *PoolHandle, PoolEntryCB EnumerationCB, void *Data);
EXPORT void MemPrivatePoolStatistics(void *PoolHandle, MemStatistics *PoolStats);

EXPORT void *MemPrivatePoolGetEntry(void *PoolHandle);
EXPORT void *MemPrivatePoolGetEntryDebug(void *PoolHandle, unsigned char *SourceFile, unsigned long SourceLine);
EXPORT void MemPrivatePoolReturnEntry(void *PoolEntry);
EXPORT void MemPrivatePoolDiscardEntry(void *Source);

#endif    /* MEMMGR_H */
