/****************************************************************************
 *
 * Copyright (c) 1999-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#ifndef MSGAPI_H
#define MSGAPI_H

#include <mdb.h>

#include <msgftrs.h>
#include <msgdate.h>

#define MSGSRV_LOCAL_SERVER                 NULL
#define MSGSRV_SELECTED_CONTEXT             "."

#define MSGSRV_ROOT                         "Internet Services"

#define MSGSRV_LIST_ROOT                    "Mailing Lists"
#define MSGSRV_PARENT_ROOT                  "Parent Objects"
#define MSGSRV_TEMPLATE_ROOT                "Templates"

#define MSGSRV_C_ROOT                       "Novonyx:Services"
#define MSGSRV_C_SERVER                     "Novonyx:Messaging Server"
#define MSGSRV_C_WEBADMIN                   "Novonyx:WebAdmin Server"
#define MSGSRV_C_ADDRESSBOOK                "Novonyx:Addressbook Agent"
#define MSGSRV_C_AGENT                      "Novonyx:Mail Agent"
#define MSGSRV_C_ALIAS                      "Novonyx:Alias Agent"
#define MSGSRV_C_ANTISPAM                   "Novonyx:AntiSpam Agent"
#define MSGSRV_C_AUTOREPLY                  "Novonyx:AutoReply Agent"
#define MSGSRV_C_FINGER                     "Novonyx:Finger Agent"
#define MSGSRV_C_FORWARD                    "Novonyx:AutoReply Agent"
#define MSGSRV_C_GATEKEEPER                 "NIMS:ConnMgr Agent"
#define MSGSRV_C_CONNMGR                    "NIMS:ConnMgr Agent"
#define MSGSRV_C_IMAP                       "Novonyx:IMAP Agent"
#define MSGSRV_C_LIST                       "NIMS:List"
#define MSGSRV_C_NDSLIST                    "NIMS:NDSList"
#define MSGSRV_C_LISTCONTAINER              "NIMS:ListContainer"
#define MSGSRV_C_LISTUSER                   "NIMS:ListUser"
#define MSGSRV_C_LISTAGENT                  "NIMS:ListAgent"
#define MSGSRV_C_NMAP                       "Novonyx:NMAP Agent"
#define MSGSRV_C_POP                        "Novonyx:POP Agent"
#define MSGSRV_C_PROXY                      "Novonyx:Proxy Agent"
#define MSGSRV_C_RULESRV                    "NIMS:RuleAgent"
#define MSGSRV_C_SIGNUP                     "Novonyx:Signup Agent"
#define MSGSRV_C_SMTP                       "Novonyx:SMTP Agent"
#define MSGSRV_C_WEBMAIL                    "Novonyx:WebMail Agent"
#define MSGSRV_C_PARENTCONTAINER            "NIMS:ParentContainer"
#define MSGSRV_C_PARENTOBJECT               "NIMS:ParentObject"
#define MSGSRV_C_TEMPLATECONTAINER          "NIMS:TemplateContainer"
#define MSGSRV_C_MODWEBTEMPLATE             "NIMS:ModWebTemplate"
#define MSGSRV_C_MODWEB                     "NIMS:ModularWebAgent"
#define MSGSRV_C_MWMAIL_MODULE              "NIMS:MWMailModule"
#define MSGSRV_C_MWCAL_MODULE               "NIMS:MWCalModule"
#define MSGSRV_C_MWPREF_MODULE              "NIMS:MWPrefModule"
#define MSGSRV_C_MWTOM_MODULE               "NIMS:MWTomModule"
#define MSGSRV_C_CALAGENT                   "NIMSCalendarAgent"
#define MSGSRV_C_ANTIVIRUS                  "NIMSAntiVirusAgent"
#define MSGSRV_C_MWSIGNUP_MODULE            "NIMSSignupModule"
#define MSGSRV_C_RESOURCE                   "NetMailResource"
#define MSGSRV_C_CAP                        "NetMailCAPAgent"

#define MSGSRV_NLM_ADDRESSBOOK              "HULAMSGLDAP.NLM"
#define MSGSRV_NLM_ALIAS                    "HULAMSGALIAS.NLM"
#define MSGSRV_NLM_ANTISPAM                 "HULAANTISPAM.NLM"
#define MSGSRV_NLM_AUTOREPLY                "HULAFORWARD.NLM"
#define MSGSRV_NLM_FINGER                   "HULAFINGER.NLM"
#define MSGSRV_NLM_FORWARD                  "HULAFORWARD.NLM"
#define MSGSRV_NLM_GATEKEEPER               "HULAGKEEPER.NLM"
#define MSGSRV_NLM_CONNMGR                  "HULAGKEEPER.NLM"
#define MSGSRV_NLM_IMAP                     "HULAIMAP.NLM"
#define MSGSRV_NLM_LISTAGENT                "HULAIMSLIST.NLM"
#define MSGSRV_NLM_NMAP                     "HULANMAP.NLM"
#define MSGSRV_NLM_POP                      "HULAPOP3.NLM"
#define MSGSRV_NLM_PROXY                    "HULAMAILPROX.NLM"
#define MSGSRV_NLM_RULESRV                  "HULARULESRV.NLM"
#define MSGSRV_NLM_SIGNUP                   "HULAMSGSGNUP.NLM"
#define MSGSRV_NLM_SMTP                     "HULASMTP.NLM"
#define MSGSRV_NLM_WEBMAIL                  "HULAWEBMAIL.NLM"
#define MSGSRV_NLM_WEBADMIN                 "HULAWEBADMIN.NLM"
#define MSGSRV_NLM_MODWEB                   "HULAMODWEB.NLM"
#define MSGSRV_NLM_MWMAIL_MODULE            "MWMAIL.NLM"
#define MSGSRV_NLM_MWCAL_MODULE             "MWCAL.NLM"
#define MSGSRV_NLM_MWPREF_MODULE            "MWPREF.NLM"
#define MSGSRV_NLM_MWTOM_MODULE             "MWTOM.NLM"
#define MSGSRV_NLM_CALAGENT                 "HULACALAGENT.NLM"
#define MSGSRV_NLM_ANTIVIRUS                "HULAAVIRUS.NLM"
#define MSGSRV_NLM_MWSIGNUP_MODULE          "MWSIGNUP.NLM"
#define MSGSRV_NLM_CAP                      "HULACAP.NLM"
#define MSGSRV_NLM_DMC                      "HULADMC.NLM"

#define MSGSRV_AGENT_ADDRESSBOOK            "Address Book Agent"
#define MSGSRV_AGENT_ALIAS                  "Alias Agent"
#define MSGSRV_AGENT_ANTISPAM               "AntiSpam Agent"
#define MSGSRV_AGENT_AUTOREPLY              "AutoReply Agent"
#define MSGSRV_AGENT_FINGER                 "Finger Agent"
#define MSGSRV_AGENT_FORWARD                "AutoReply Agent"
#define MSGSRV_AGENT_GATEKEEPER             "Connection Manager"
#define MSGSRV_AGENT_CONNMGR                "Connection Manager"
#define MSGSRV_AGENT_IMAP                   "IMAP Agent"
#define MSGSRV_AGENT_LIST                   "List Agent"
#define MSGSRV_AGENT_NMAP                   "NMAP Agent"
#define MSGSRV_AGENT_POP                    "POP Agent"
#define MSGSRV_AGENT_PROXY                  "Proxy Agent"
#define MSGSRV_AGENT_RULESRV                "Rule Agent"
#define MSGSRV_AGENT_SIGNUP                 "Signup Agent"
#define MSGSRV_AGENT_SMTP                   "SMTP Agent"
#define MSGSRV_AGENT_WEBMAIL                "WebMail Agent"
#define MSGSRV_AGENT_WEBMAIL_OLD            "Messenger Express"
#define MSGSRV_AGENT_MODWEB                 "Modular Web Agent"
#define MSGSRV_AGENT_MWMAIL                 "IMS Mail Module"
#define MSGSRV_AGENT_MWCAL                  "IMS Calendar Module"
#define MSGSRV_AGENT_MWPREF                 "IMS Preferences Module"
#define MSGSRV_AGENT_MWTOM                  "IMS Task Managment Module"
#define MSGSRV_AGENT_CALAGENT               "Calendar Agent"
#define MSGSRV_AGENT_ANTIVIRUS              "AntiVirus Agent"
#define MSGSRV_AGENT_MWSIGNUP               "IMS Signup Module"
#define MSGSRV_AGENT_CAP                    "CAP Agent"
#define MSGSRV_AGENT_DMC                    "DMC Agent"

#define MSGSRV_A_ACTION                     "Novonyx:Action"
#define MSGSRV_A_AGENT_STATUS               "Novonyx:Agent Status"
#define MSGSRV_A_ALIAS                      "Novonyx:Alias"
#define MSGSRV_A_AUTHENTICATION_REQUIRED    "Novonyx:Authentication Required"
#define MSGSRV_A_CONFIGURATION              "Novonyx:Configuration"
#define MSGSRV_A_CLIENT                     "Novonyx:Client"
#define MSGSRV_A_CONTEXT                    "Novonyx:Context"
#define MSGSRV_A_DOMAIN                     "Novonyx:Domain"
#define MSGSRV_A_EMAIL_ADDRESS              "Novonyx:EMail Address"
#define MSGSRV_A_DISABLED                   "Novonyx:Disabled"
#define MSGSRV_A_FINGER_MESSAGE             "Novonyx:Finger Message"
#define MSGSRV_A_HOST                       "Novonyx:Host"
#define MSGSRV_A_IP_ADDRESS                 "Novonyx:IP Address"
#define MSGSRV_A_LDAP_SERVER                "Novonyx:LDAP Server"
#define MSGSRV_A_LDAP_NMAP_SERVER           "Novonyx:LDAP NMAP Server"
#define MSGSRV_A_LDAP_SEARCH_DN             "Novonyx:LDAP Search DN"
#define MSGSRV_A_MESSAGE_LIMIT              "Novonyx:Message Limit"
#define MSGSRV_A_MESSAGING_SERVER           "Novonyx:Messaging Server"
#define MSGSRV_A_MODULE_NAME                "Novonyx:Module Name"
#define MSGSRV_A_MODULE_VERSION             "Novonyx:Module Version"
#define MSGSRV_A_NMAP_SERVER                "Novonyx:NMAP Server"
#define MSGSRV_A_NMAP_QUEUE_SERVER          "Novonyx:NMAP Queue Server"
#define MSGSRV_A_OFFICIAL_NAME              "Novonyx:Official Name"
#define MSGSRV_A_QUOTA_MESSAGE              "Novonyx:Quota Message"
#define MSGSRV_A_POSTMASTER                 "Novonyx:Postmaster"
#define MSGSRV_A_REPLY_MESSAGE              "Novonyx:Reply Message"
#define MSGSRV_A_URL                        "Novonyx:URL"
#define MSGSRV_A_RESOLVER                   "Novonyx:Resolver"
#define MSGSRV_A_ROUTING                    "Novonyx:Routing"
#define MSGSRV_A_SERVER_STATUS              "Novonyx:Server Status"
#define MSGSRV_A_QUEUE_INTERVAL             "Novonyx:Queue Interval"
#define MSGSRV_A_QUEUE_TIMEOUT              "Novonyx:Queue Timeout"
#define MSGSRV_A_SSL_OPTIONS                "Novonyx:SSL Options"
#define MSGSRV_A_UID                        "Novonyx:UID"
#define MSGSRV_A_VACATION_MESSAGE           "Novonyx:Vacation Message"
#define MSGSRV_A_WORD                       "Novonyx:Word"
#define MSGSRV_A_MESSAGE_STORE              "Novonyx:Message Store"
#define MSGSRV_A_FORWARDING_ADDRESS         "Novonyx:Forwarding Address"
#define MSGSRV_A_FORWARDING_ENABLED         "Novonyx:Forwarding Enabled"
#define MSGSRV_A_AUTOREPLY_ENABLED          "Novonyx:Vacation Message Enabled"
#define MSGSRV_A_AUTOREPLY_MESSAGE          "Novonyx:Reply Message"
#define MSGSRV_A_PORT                       "Novonyx:Port"
#define MSGSRV_A_SSL_PORT                   "Novonyx:SSL Port"
#define MSGSRV_A_SNMP_DESCRIPTION           "Novonyx:SNMP Description"
#define MSGSRV_A_SNMP_VERSION               "Novonyx:SNMP Version"
#define MSGSRV_A_SNMP_ORGANIZATION          "Novonyx:SNMP Organization"
#define MSGSRV_A_SNMP_LOCATION              "Novonyx:SNMP Location"
#define MSGSRV_A_SNMP_CONTACT               "Novonyx:SNMP Contact"
#define MSGSRV_A_SNMP_NAME                  "Novonyx:SNMP Name"
#define MSGSRV_A_MESSAGING_DISABLED         "Novonyx:Messaging Disabled"
#define MSGSRV_A_NMAP_TRUSTED_HOSTS         "Novonyx:NMAP Trusted Hosts"
#define MSGSRV_A_USE_QUOTA                  "Novonyx:Use Quota"
#define MSGSRV_A_QUOTA_VALUE                "Novonyx:Quota Value"
#define MSGSRV_A_SCMS_USER_THRESHOLD        "Novonyx:SCMS User Threshold"
#define MSGSRV_A_SCMS_SIZE_THRESHOLD        "Novonyx:SCMS Size Threshold"
#define MSGSRV_A_SMTP_VERIFY_ADDRESS        "Novonyx:SMTP Verify Address" 
#define MSGSRV_A_SMTP_ALLOW_AUTH            "Novonyx:SMTP Allow AUTH" 
#define MSGSRV_A_SMTP_ALLOW_VRFY            "Novonyx:SMTP Allow VRFY" 
#define MSGSRV_A_SMTP_ALLOW_EXPN            "Novonyx:SMTP Allow EXPN" 
#define MSGSRV_A_WORK_DIRECTORY             "Novonyx:Work Directory"
#define MSGSRV_A_LOGLEVEL                   "Novonyx:Loglevel"
#define MSGSRV_A_MINIMUM_SPACE              "Novonyx:Minimum Free Space"
#define MSGSRV_A_SMTP_SEND_ETRN             "Novonyx:SMTP Send ETRN"
#define MSGSRV_A_SMTP_ACCEPT_ETRN           "Novonyx:SMTP Accept ETRN"
#define MSGSRV_A_LIMIT_REMOTE_PROCESSING    "Novonyx:Limit Remote Processing"
#define MSGSRV_A_LIMIT_REMOTE_START_WD      "Novonyx:Limit Remote Beg Weekday"
#define MSGSRV_A_LIMIT_REMOTE_END_WD        "Novonyx:Limit Remote End Weekday"
#define MSGSRV_A_LIMIT_REMOTE_START_WE      "Novonyx:Limit Remote Beg Weekend"
#define MSGSRV_A_LIMIT_REMOTE_END_WE        "Novonyx:Limit Remote End Weekend"
#define MSGSRV_A_PRODUCT_VERSION            "Novonyx:Product Version"
#define MSGSRV_A_PROXY_LIST                 "Novonyx:Proxy List"
#define MSGSRV_A_MAXIMUM_ITEMS              "Novonyx:Maximum Items"
#define MSGSRV_A_TIME_INTERVAL              "Novonyx:Time Interval"
#define MSGSRV_A_RELAYHOST                  "Novonyx:RelayHost"
#define MSGSRV_A_ALIAS_OPTIONS              "Novonyx:Alias Options"
#define MSGSRV_A_LDAP_OPTIONS               "Novonyx:LDAP Options"
#define MSGSRV_A_CUSTOM_ALIAS               "Novonyx:Custom Alias"
#define MSGSRV_A_ADVERTISING_CONFIG         "Novonyx:Advertising Config"
#define MSGSRV_A_LANGUAGE                   "Novonyx:Language"
#define MSGSRV_A_COLOR                      "Novonyx:Color"
#define MSGSRV_A_FONT                       "Novonyx:Font"
#define MSGSRV_A_PREFERENCES                "Novonyx:Preferences"
#define MSGSRV_A_QUOTA_WARNING              "Novonyx:Quota Warning"
#define MSGSRV_A_RTS_HANDLING               "Novonyx:RTS Handling"
#define MSGSRV_A_QUEUE_TUNING               "Novonyx:Queue Tuning"
#define MSGSRV_A_TIMEOUT                    "Novonyx:Timeout"
#define MSGSRV_A_PRIVACY                    "Novonyx:Privacy"
#define MSGSRV_A_THREAD_LIMIT               "Novonyx:Thread Limit"
#define MSGSRV_A_DBF_PAGESIZE               "Novonyx:DBF Page Size"
#define MSGSRV_A_DBF_KEYSIZE                "Novonyx:DBF Key Size"
#define MSGSRV_A_ADDRESSBOOK_CONFIG         "Novonyx:Addressbook Config"
#define MSGSRV_A_ADDRESSBOOK_URL_SYSTEM     "Novonyx:Addressbook URL System"
#define MSGSRV_A_ADDRESSBOOK_URL_PUBLIC     "Novonyx:Addressbook URL Public"
#define MSGSRV_A_ADDRESSBOOK                "Novonyx:Addressbook"
#define MSGSRV_A_SERVER_STANDALONE          "Novonyx:Server Standalone"
#define MSGSRV_A_FORWARD_UNDELIVERABLE      "Novonyx:Forward Undeliverable"
#define MSGSRV_A_PHRASE                     "Novonyx:Phrase"
#define MSGSRV_A_ACCOUNTING_ENABLED         "Novonyx:Accounting Enabled"
#define MSGSRV_A_ACCOUNTING_DATA            "Novonyx:Accounting Data"
#define MSGSRV_A_BILLING_DATA               "Novonyx:Billing Data"
#define MSGSRV_A_BLOCKED_ADDRESS            "NIMS:Blocked Address"
#define MSGSRV_A_ALLOWED_ADDRESS            "NIMS:Allowed Address"
#define MSGSRV_A_UBE_CONFIGURATION          "NIMS:UBE Configuration"
#define MSGSRV_A_RECIPIENT_LIMIT            "NIMS:Recipient Limit"
#define MSGSRV_A_RBL_HOST                   "NIMS:RBL Host"
#define MSGSRV_A_SIGNATURE                  "NIMS:Signature"
#define MSGSRV_A_CONNMGR                    "NIMS:ConnMgr"
#define MSGSRV_A_CONNMGR_CONFIG             "NIMS:ConnMgr Config"
#define MSGSRV_A_USER_DOMAIN                "NIMS:User Domain"
#define MSGSRV_A_RTS_ANTISPAM_CONFIG        "NIMS:RTS Antispam Config"
#define MSGSRV_A_SPOOL_DIRECTORY            "NIMS:SpoolDirectory"
#define MSGSRV_A_SCMS_DIRECTORY             "NIMS:SCMSDirectory"
#define MSGSRV_A_DBF_DIRECTORY              "NIMS:DBFDirectory"
#define MSGSRV_A_NLS_DIRECTORY              "NIMS:NLSDirectory"
#define MSGSRV_A_BIN_DIRECTORY              "NIMS:BinDirectory"
#define MSGSRV_A_LIB_DIRECTORY              "NIMS:LibDirectory"
#define MSGSRV_A_DEFAULT_CHARSET            "NIMS:Default Charset"
#define MSGSRV_A_RULE                       "NIMS:Rule"
#define MSGSRV_A_RELAY_DOMAIN               "NIMS:RelayDomain"
#define MSGSRV_A_LIST_DIGESTTIME            "NIMS:ListDigestTime"
#define MSGSRV_A_LIST_ABSTRACT              "NIMS:ListAbstract"
#define MSGSRV_A_LIST_DESCRIPTION           "NIMS:ListDescription"
#define MSGSRV_A_LIST_CONFIGURATION         "NIMS:ListConfiguration"
#define MSGSRV_A_LIST_STORE                 "NIMS:ListStore"
#define MSGSRV_A_LIST_NMAPSTORE             "NIMS:ListNMAPStore"
#define MSGSRV_A_LIST_MODERATOR             "NIMS:ListModerator"
#define MSGSRV_A_LIST_OWNER                 "NIMS:ListOwner"
#define MSGSRV_A_LIST_SIGNATURE             "NIMS:ListSignature"
#define MSGSRV_A_LIST_SIGNATURE_HTML        "NIMS:ListSignatureHTML"
#define MSGSRV_A_LIST_DIGEST_VERSION        "NIMS:ListDigestVersion"
#define MSGSRV_A_LIST_MEMBERS               "NIMS:ListMembers"
#define MSGSRV_A_LISTUSER_OPTIONS           "NIMS:ListUserOptions"
#define MSGSRV_A_LISTUSER_ADMINOPTIONS      "NIMS:ListUserAdminOptions"
#define MSGSRV_A_LISTUSER_PASSWORD          "NIMS:ListUserPassword"
#define MSGSRV_A_WAP_MSG_SIZE               "NIMS:WapMessageSize"
#define MSGSRV_A_FEATURE_SET                "NIMS:FeatureSet"
#define MSGSRV_A_WEBMAIL_PLUGIN_ORDER       "NIMS:WebmailPluginOrder"
#define MSGSRV_A_PRIVATE_KEY_LOCATION       "NIMS:PKeyFile"
#define MSGSRV_A_CERTIFICATE_LOCATION       "NIMS:CAFile"
#define MSGSRV_A_CONFIG_CHANGED             "NIMS:ConfigVersion"
#define MSGSRV_A_LISTSERVER_NAME            "NIMS:ListServerName"
#define MSGSRV_A_LIST_WELCOME_MESSAGE       "NIMS:ListWelcomeMessage"
#define MSGSRV_A_PARENT_OBJECT              "NIMS:ParentObject"
#define MSGSRV_A_FEATURE_INHERITANCE        "NIMS:FeatureInheritance"
#define MSGSRV_A_TEMPLATE                   "NIMS:Template"
#define MSGSRV_A_TIMEZONE                   "NIMS:Timezone"
#define MSGSRV_A_LOCALE                     "NIMS:Locale"
#define MSGSRV_A_PASSWORD_CONFIGURATION     "NIMS:PasswordConfig"
#define MSGSRV_A_TITLE                      "NIMS:Title"
#define MSGSRV_A_DEFAULT_TEMPLATE           "NIMS:DefaultTemplate"
#define MSGSRV_A_TOM_MANAGER                "NIMS:TOMManager"
#define MSGSRV_A_TOM_CONTEXTS               "NIMS:TOMContexts"
#define MSGSRV_A_TOM_DOMAINS                "NIMS:TOMDomains"
#define MSGSRV_A_TOM_OPTIONS                "NIMS:TOMOptions"
#define MSGSRV_A_DESCRIPTION                "NIMS:Description"
#define MSGSRV_A_STATSERVER_1               "NIMS:StatServer1"
#define MSGSRV_A_STATSERVER_2               "NIMS:StatServer2"
#define MSGSRV_A_STATSERVER_3               "NIMS:StatServer3"
#define MSGSRV_A_STATSERVER_4               "NIMS:StatServer4"
#define MSGSRV_A_STATSERVER_5               "NIMS:StatServer5"
#define MSGSRV_A_STATSERVER_6               "NIMS:StatServer6"
#define MSGSRV_A_NEWS                       "NIMS:News"
#define MSGSRV_A_MANAGER                    "NIMS:Manager"
#define MSGSRV_A_AVAILABLE_SHARES           "NetMail:AvailableShares"
#define MSGSRV_A_OWNED_SHARES               "NetMail:OwnedShares"
#define MSGSRV_A_NEW_SHARE_MESSAGE          "NetMail:NewShareMessage"
#define MSGSRV_A_AVAILABLE_PROXIES          "NetMail:AvailableProxies"
#define MSGSRV_A_OWNED_PROXIES              "NetMail:OwnedProxies"
#define MSGSRV_A_MANAGED_RESOURCES          "NetMail:ManagedResources"
#define MSGSRV_A_RESOURCE_MANAGER           "NetMail:Manager"
#define MSGSRV_A_HULA_MESSAGING_SERVER      "NetMail:MessagingServer"
#define MSGSRV_A_ACL                        "NIMS:ACL"
#define MSGSRV_A_WA_DEFAULT_TEMPLATE        "WebAdmin:DefaultTemplate"
#define MSGSRV_A_WA_ALLOWED_TEMPLATES       "WebAdmin:AllowedTemplates"
#define MSGSRV_A_WA_DISALLOWED_TEMPLATES    "WebAdmin:DisallowedTemplates"

#define PLUSPACK_AGENT                      "PlusPack Agent"
#define PLUSPACK_C                          "PlusPack:Agent"
#define PLUSPACK_NLM                        "PLUSPACK.NLM"
#define PLUSPACK_A_ACL_GROUP                "PlusPack:ACLGroup"
#define PLUSPACK_A_COPY_USER                "PlusPack:CopyUser"
#define PLUSPACK_A_COPY_MBOX                "PlusPack:CopyMBOX"

#define MSGSRV_LOAD_AGENT                   1
#define MSGSRV_UNLOAD_AGENT                 2
#define MSGSRV_RESTART_AGENT                3
#define MSGSRV_GET_STATS                    4
#define MSGSRV_RESET_STATS                  5
#define MSGSRV_GET_SPAM_STATS               6

#define MSGSRV_SUCCESS                      1
#define MSGSRV_NOT_AUTHORIZED               2
#define MSGSRV_UNKNOWN_REQUEST              3
#define MSGSRV_WRONG_ARGUMENTS              4

#define MSGSRV_MODULES_LOADED               0   /* Private                                             */
#define MSGSRV_UNAUTHORIZED                 1   /* Increments                                          */
#define MSGSRV_WRONG_PASSWORD               2   /* Increments                                          */
#define MSGSRV_DELIVERY_FAILED_LOCAL        3   /* Increments                                          */
#define MSGSRV_DELIVERY_FAILED_REMOTE       4   /* Increments                                          */

#define MSGSRV_INCOMING_CLIENT              5   /* Increments                                          */
#define MSGSRV_INCOMING_SERVER              6   /* Increments                                          */
#define MSGSRV_SERVICED_CLIENT              7   /* Increments, also decrements MSGSRV_INCOMING_CLIENTS */
#define MSGSRV_SERVICED_SERVER              8   /* Increments, also decrements MSGSRV_INCOMING_SERVERS */
#define MSGSRV_OUTGOING_SERVER              9   /* Increments                                          */
#define MSGSRV_CLOSED_OUT_SERVER            10  /* Increments, also decrements MSGSRV_OUTGOING_SERVERS */

#define MSGSRV_INCOMING_Q_AGENT             11  /* Increments/Decrements                               */
#define MSGSRV_OUTGOING_Q_AGENT             12  /* Increments/Decrements                               */
#define MSGSRV_STORE_AGENT                  13  /* Increments                                          */

#define MSGSRV_MSG_RECEIVED_LOCAL           15  /* Value    +/-                                        */
#define MSGSRV_MSG_RECEIVED_REMOTE          16  /* Value    +/-                                        */
#define MSGSRV_MSG_STORED_LOCAL             17  /* Value    +/-                                        */
#define MSGSRV_MSG_STORED_REMOTE            18  /* Value    +/-                                        */
#define MSGSRV_MSG_QUEUED_LOCAL             19  /* Value +/-                                           */
#define MSGSRV_MSG_QUEUED_REMOTE            20  /* Value +/-                                           */
                    
#define MSGSRV_BYTE_RECEIVED_LOCAL          21  /* Value +/-                                           */
#define MSGSRV_BYTE_RECEIVED_REMOTE         22  /* Value +/-                                           */
#define MSGSRV_BYTE_STORED_LOCAL            23  /* Value +/-                                           */
#define MSGSRV_BYTE_STORED_REMOTE           24  /* Value +/-                                           */

#define MSGSRV_RCPT_RECEIVED_LOCAL          25  /* Value +/-                                           */
#define MSGSRV_RCPT_RECEIVED_REMOTE         26  /* Value +/-                                           */
#define MSGSRV_RCPT_STORED_LOCAL            27  /* Value +/-                                           */
#define MSGSRV_RCPT_STORED_REMOTE           28  /* Value +/-                                           */

#define MSGSRV_SPAM_QUEUESPAM               29  /* Increments                                          */
#define MSGSRV_SPAM_ADDRESS_BLOCKED         30  /* Increments                                          */
#define MSGSRV_SPAM_MAPS_BLOCKED            31  /* Increments                                          */
#define MSGSRV_SPAM_DENIED_ROUTING          32  /* Increments                                          */
#define MSGSRV_SPAM_NO_DNS_ENTRY            33  /* Increments                                          */

#define MSGSRV_NMAP_TO_NMAP_AGENT           34  /* Increments                                          */

#define MSGSRV_SPAM_MESSAGES_SCANNED        35  /* Increments                                          */
#define MSGSRV_SPAM_ATTACHMENTS_SCANNED     36  /* Increments                                          */
#define MSGSRV_SPAM_ATTACHMENTS_BLOCKED     37  /* Increments                                          */
#define MSGSRV_SPAM_VIRUSES_FOUND           38  /* Increments                                          */
#define MSGSRV_SPAM_VIRUSES_BLOCKED         39  /* Increments                                          */
#define MSGSRV_SPAM_VIRUSES_CURED           40  /* Increments                                          */

#define MSGSRV_MAX_STAT_COUNT               41  /* How many stat entries are there?                    */

#define MSGSRV_STAT_UP                      1
#define MSGSRV_STAT_DOWN                    -1

#define MSGSRV_TRAP_ILLEGALACCESS           3
#define MSGSRV_TRAP_OTHER                   4

#define MSGFindUser(u, dn, t, n, v)         MsgFindObject((u), (dn), (t), (n), (v)) 

#ifdef __cplusplus
extern "C" {
#endif

typedef BOOL (*FindObjectCacheType)(const unsigned char *, unsigned char *, unsigned char *, struct in_addr *, MDBValueStruct *);
typedef BOOL (*FindObjectCacheExType)(const unsigned char *, unsigned char *, unsigned char *, struct in_addr *, BOOL *, MDBValueStruct *);
typedef const unsigned char *(*FindObjectStoreCacheType)(const unsigned char *User, const unsigned char *DefaultPath);

typedef struct _MSGCacheInitStruct {
    MDBHandle *DirectoryHandle;

    XplRWLock *ConfigLock;

    MDBValueStruct *ServerAddresses;
    MDBValueStruct *ServerContexts;
    MDBValueStruct *StorePath;

    FindObjectCacheType DefaultFindObject;
    FindObjectCacheExType DefaultFindObjectEx;
    FindObjectStoreCacheType DefaultFindObjectStore;

    unsigned char DefaultPathChar;
} MSGCacheInitStruct;

typedef BOOL (*FindObjectCacheInitType)(MSGCacheInitStruct *initData, unsigned char *description);
typedef BOOL (*FindObjectCacheShutdownType)(void);

/*  fixme - this api belongs in the dmc */
EXPORT void MsgSendTrap(int type, unsigned char *message);

EXPORT int MsgInit(void);
EXPORT BOOL MsgShutdown(void);

EXPORT const unsigned char *MsgGetServerDN(unsigned char *buffer);

EXPORT BOOL MsgFindObject(const unsigned char *name, unsigned char *dn, unsigned char *type, struct in_addr *nmap, MDBValueStruct *v);
EXPORT BOOL MsgFindObjectEx(const unsigned char *name, unsigned char *dn, unsigned char *type, struct in_addr *nmap, BOOL *disabled, MDBValueStruct *v);
EXPORT const unsigned char *MsgFindUserStore(const unsigned char *user, const unsigned char *defaultPath);

EXPORT BOOL MsgReadIP(unsigned char *object, unsigned char *type, MDBValueStruct *v);

EXPORT const unsigned char *MsgGetDBFDir(char *directory);
EXPORT const unsigned char *MsgGetWorkDir(char *directory);
EXPORT const unsigned char *MsgGetNLSDir(char *directory);
EXPORT const unsigned char *MsgGetLibDir(char *directory);
EXPORT const unsigned char *MsgGetBinDir(char *directory);
EXPORT const unsigned char *MsgGetTLSCertPath(char *path);
EXPORT const unsigned char *MsgGetTLSKeyPath(char *path);
EXPORT int MsgGetParentAttribute(const unsigned char *userDn, unsigned char *attribute, MDBValueStruct *v);
EXPORT unsigned char *MsgGetUserEmailAddress(const unsigned char *userDn, MDBValueStruct *userData, unsigned char *buffer, unsigned long bufLen);
EXPORT unsigned char *MsgGetUserDisplayName(const unsigned char *userDn, MDBValueStruct *userData);
EXPORT unsigned long MsgGetHostIPAddress(void);
EXPORT unsigned long MsgGetAgentBindIPAddress(void);

EXPORT const char *MsgGetUnpriviledgedUser(void);	

EXPORT void MsgMakePath(unsigned char *path);
EXPORT BOOL MsgCleanPath(unsigned char *path);

EXPORT BOOL MsgRegisterAddress(unsigned long address, unsigned char *name);
EXPORT BOOL MsgIsKnownAddress(unsigned long address, unsigned char *name);

EXPORT BOOL MsgResolveStart();
EXPORT BOOL MsgResolveStop();    

/*  fixme - deprecated interfaces? */
EXPORT BOOL MsgFindServer(const unsigned char *user, unsigned char *dn);

EXPORT BOOL MsgSetServerState(const unsigned char *server, const unsigned char *setState);

#ifdef __cplusplus
}
#endif

#endif /* MSGAPI_H */

