/****************************************************************************
 *
 * Copyright (c) 1997-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

/* Compile-time options */

#include <config.h>

/* Product defines */
#define	PRODUCT_NAME			"Hula Modular Web Agent"
#define	PRODUCT_DESCRIPTION	"Provides webclient access to Hula services like mail, calendar, user preferences, etc."
#define	PRODUCT_VERSION		"$Revision: 1.7 $"

#define DEFAULT_TITLE                  "Hula"

#define NMLOGID_H_NEED_LOGGING_KEY
#define NMLOGID_H_NEED_LOGGING_CERT
#include <xpl.h>

#include <connio.h>

#include <msgapi.h>
#include <nmap.h>
#include <hulautil.h>
#include <libical.h>
/*	Management Client	Header Include	*/
#include <management.h>
#include "modwebp.h"

#if defined(MODWEB_DEBUG_BUILD)
int		MWScreen;
#endif


/* Globals */
XplRWLock		ConfigLock; /* used to protect ModWebMaxThreadLoad and future writable parameters */
unsigned long	ModWebMaxThreadLoad					= 100000;
XplAtomic		ModWebConnThreads;
XplAtomic		ModWebServerThreads;
BOOL				ModWebReceiverStopped				= FALSE;
XplSemaphore	ModWebServerSemaphore;
XplSemaphore	ModWebShutdownSemaphore;
XplSemaphore	CacheSemaphore;
XplSemaphore	SessionDBSemaphore;
XplSemaphore	TSessionDBSemaphore;
BOOL				Unloading								= FALSE;
BOOL				Exiting									= FALSE;
BOOL CheckDiskForTemplateUpdates = FALSE;
BOOL				*MWExiting								= &Exiting;
int				ModWebServerSocket					= -1;
int				ModWebServerSocketSSL				= -1;
char				Hostname[MAXEMAILNAMESIZE];
char				ManagementURL[256]					= "";
int				TGid;
char				NMAP_ADDR[80]							= "127.0.0.1";
BOOL				AllowClientSSL							= TRUE;
BOOL				UseNMAPSSL								= FALSE;
int				MODWEB_PORT								= 80;
int				MODWEB_PORT_SSL						= 443;
BOOL				ForceLoad								= FALSE;
unsigned char	NLSDir[XPL_MAX_PATH+1];
unsigned char	ModuleDir[XPL_MAX_PATH+1]				= "sys:/system/modweb";
unsigned char	LogoDir[XPL_MAX_PATH+1]					= "sys:/system/modweb/logo";
unsigned char	WorkDir[XPL_MAX_PATH+1]					= "sys:/novonyx/mail/dbf/modweb";
unsigned char	TemplateDir[XPL_MAX_PATH+1]			= "sys:/system/modweb";
unsigned char	FormLoginRedirectURL[XPL_MAX_PATH+1]= "/";
unsigned char	FormLogoutRedirectURL[XPL_MAX_PATH+1]= "/";
BOOL				UseFormLogoutRedirectURL			= FALSE;
unsigned long	Configuration							= 0;
unsigned long	ClientSSLOptions						= 0;
unsigned char	OfficialDomain[MAXEMAILNAMESIZE+1] = "";
unsigned char	*DefaultTitle							= NULL;
unsigned char	NMAPHash[NMAP_HASH_SIZE];
void				*LogHandle								= NULL;
SSL_CTX			*SSLContext								= NULL;
unsigned char	*NMAPTraceUser							= NULL;
XplSemaphore	TraceSemaphore;
unsigned long	MIMEParamEncodingforHTTP			= 0;

/* Authentication Proxy Globals (Single Signon) */
unsigned long	AuthHosts								= 0;					/* Number of auth proxy servers.   If this is 0, auth proxy information is ignored	*/
in_addr_t	*AuthAddress							= NULL;				/* List of IP address that are trusted auth proxy servers									*/
unsigned char	AuthIDHeader[XPL_MAX_PATH+1]			= "";					/* The name of the http header where the auth proxy server puts the userID				*/ 
unsigned long	AuthIDHeaderLen						= 0;              /* Length of the AuthIDHeader																			*/

MDBHandle		ModWebDirectoryHandle				= NULL;

void				*ModWebConnectionPool				= NULL;

#define	SetPtrToValue(Ptr,String)	Ptr=String;while(isspace(*Ptr)) Ptr++;if ((*Ptr=='=') || (*Ptr==':')) Ptr++; while(isspace(*Ptr)) Ptr++;

#define	Send404()																																											\
{																																																	\
	MWSendClient(Client, "HTTP/1.1 404 Document does not exist\r\nPragma: no-cache\r\nContent-type: text/html\r\nConnection: close\r\n\r\n", 102);	\
	Client->KeepAlive=FALSE;																																								\
	MWSendClient(Client, "<H1>Document not found</H1>", 27);																														\
}


int ClientReadTrace(void *sktCtx, unsigned char *Buf, int Len, int sktTimeout);
int ClientReadSSLTrace(void *sktCtx, unsigned char *Buf, int Len, int sktTimeout);
int ClientWriteTrace(void *sktCtx, unsigned char *Buf, int Len);
int ClientWriteSSLTrace(void *sktCtx, unsigned char *Buf, int Len);
int NMAPReadTrace(void *sktCtx, unsigned char *Buf, int Len, int sktTimeout);
int NMAPReadSSLTrace(void *sktCtx, unsigned char *Buf, int Len, int sktTimeout);
int NMAPWriteTrace(void *sktCtx, unsigned char *Buf, int Len);
int NMAPWriteSSLTrace(void *sktCtx, unsigned char *Buf, int Len);
/*	Management Client	Declarations	*/
BOOL ReadMODWEBVariable(unsigned int Variable, unsigned char *Data, size_t *DataLength);
BOOL WriteMODWEBVariable(unsigned int Variable, unsigned char *Data, size_t DataLength);
ManagementVariables	MODWEBManagementVariables[] = {
	/*	0	unsigned long	ModWebMaxThreadLoad						*/	{	DMCMV_MAX_CONNECTION_COUNT,		DMCMV_MAX_CONNECTION_COUNT_HELP,			ReadMODWEBVariable,	WriteMODWEBVariable },
	/*	1	XplAtomic		ModWebConnThreads							*/	{	DMCMV_CONNECTION_COUNT,				DMCMV_CONNECTION_COUNT_HELP,				ReadMODWEBVariable,	NULL },
	/*	2	XplAtomic		ModWebServerThreads						*/	{	DMCMV_SERVER_THREAD_COUNT,			DMCMV_SERVER_THREAD_COUNT_HELP,			ReadMODWEBVariable,	NULL },
	/*	3	BOOL				ModWebReceiverStopped					*/	{	DMCMV_RECEIVER_DISABLED,			DMCMV_RECEIVER_DISABLED_HELP,				ReadMODWEBVariable,	WriteMODWEBVariable },
	/*	4	BOOL				AllowClientSSL								*/	{	DMCMV_SSL_ENABLED,					DMCMV_SSL_ENABLED_HELP,						ReadMODWEBVariable,	NULL },
	/*	5	BOOL				ForceLoad									*/	{	MWEBMV_FORCE_MODULE_LOAD,			MWEBMV_FORCE_MODULE_LOAD_HELP,			ReadMODWEBVariable,	NULL },
	/*	6	BOOL				UseFormLogoutRedirectURL				*/	{	MWEBMV_REDIRECT_LOGOUT,				MWEBMV_REDIRECT_LOGOUT_HELP,				ReadMODWEBVariable,	NULL },
	/*	7	int				MODWEB_PORT									*/	{	DMCMV_PORT,								DMCMV_PORT_HELP,								ReadMODWEBVariable,	NULL },
	/*	8	int				MODWEB_PORT_SSL							*/	{	DMCMV_SSL_PORT,						DMCMV_SSL_PORT_HELP,							ReadMODWEBVariable,	NULL },
	/*	9	unsigned char	NLSDir[XPL_MAX_PATH+1]						*/	{	DMCMV_NLS_DIRECTORY,					DMCMV_NLS_DIRECTORY,							ReadMODWEBVariable,	NULL },
	/*	10	unsigned char	ModuleDir[XPL_MAX_PATH+1]					*/	{	MWEBMV_MODULE_DIRECTORY,			MWEBMV_MODULE_DIRECTORY_HELP,				ReadMODWEBVariable,	NULL },
	/*	11	unsigned char	LogoDir[XPL_MAX_PATH+1]						*/	{	MWEBMV_LOGO_DIRECTORY,				MWEBMV_LOGO_DIRECTORY_HELP,				ReadMODWEBVariable,	NULL },
	/*	12	unsigned char	WorkDir[XPL_MAX_PATH+1]						*/	{	DMCMV_WORK_DIRECTORY,				DMCMV_WORK_DIRECTORY_HELP,					ReadMODWEBVariable,	NULL },
	/*	13	unsigned char	TemplateDir[XPL_MAX_PATH+1]				*/	{	MWEBMV_TEMPLATE_DIRECTORY,			MWEBMV_TEMPLATE_DIRECTORY_HELP,			ReadMODWEBVariable,	NULL },
	/*	14	unsigned char	FormLoginRedirectURL[XPL_MAX_PATH+1]	*/	{	MWEBMV_FORM_LOGIN_REDIRECT_URL,	MWEBMV_FORM_LOGIN_REDIRECT_URL_HELP,	ReadMODWEBVariable,	NULL },
	/*	15	unsigned char	FormLogoutRedirectURL[XPL_MAX_PATH+1]	*/	{	MWEBMV_FORM_LOGOUT_REDIRECT_URL,	MWEBMV_FORM_LOGOUT_REDIRECT_URL_HELP,	ReadMODWEBVariable,	NULL },
	/*	16	unsigned char	OfficialDomain[MAXEMAILNAMESIZE+1]	*/	{	DMCMV_OFFICIAL_NAME,					DMCMV_OFFICIAL_NAME_HELP,					ReadMODWEBVariable,	NULL },
	/*	17	unsigned char	*DefaultTitle								*/	{	MWEBMV_DEFAULT_TITLE,				MWEBMV_DEFAULT_TITLE_HELP,					ReadMODWEBVariable,	NULL }, 	
	/*	18	XplAtomic		ModWebStats.Clients.Incoming			*/	{	DMCMV_SESSION_COUNT,					DMCMV_SESSION_COUNT_HELP,					ReadMODWEBVariable,	WriteMODWEBVariable	}, 
	/*	19	XplAtomic		ModWebStats.Clients.Serviced			*/	{	DMCMV_TOTAL_CONNECTIONS,			DMCMV_TOTAL_CONNECTIONS_HELP,				ReadMODWEBVariable,	WriteMODWEBVariable	}, 
	/*	20	XplAtomic		ModWebStats.WrongPassword				*/	{	DMCMV_BAD_PASSWORD_COUNT,			DMCMV_BAD_PASSWORD_COUNT_HELP,			ReadMODWEBVariable,	WriteMODWEBVariable	}, 
	/*	21	unsigned char													*/	{	DMCMV_VERSION,							DMCMV_VERSION_HELP,							ReadMODWEBVariable,	NULL	}, 
	/*	22	#define			PRODUCT_VERSION							*/	{	DMCMV_REVISIONS,						DMCMV_REVISIONS_HELP,						ReadMODWEBVariable,	NULL	}, 
};		
		
static BOOL
MODWEBShutdown(unsigned char *Arguments, unsigned char **Response, BOOL *CloseConnection)
{
	int			s;
	XplThreadID	id;

	if (Response) {
		if (!Arguments) {
			if (ModWebServerSocket != -1) {
				*Response = MemStrdup("Shutting down.\r\n");
				if (*Response) {
					id = XplSetThreadGroupID(TGid);

					Exiting = TRUE;

					s = ModWebServerSocket;
					ModWebServerSocket = -1;

					if (s != -1) {
						IPclose(s);
					}

					if (CloseConnection) {
						*CloseConnection = TRUE;
					}

					XplSetThreadGroupID(id);
				}
			} else if (Exiting) {
				*Response = MemStrdup("Shutdown in progress.\r\n");
			} else {
				*Response = MemStrdup("Unknown shutdown state.\r\n");
			}

			if (*Response) {
				return(TRUE);
			}

			return(FALSE);
		}

		*Response = MemStrdup("Arguments not allowed.\r\n");
		return(TRUE);
	}

	return(FALSE);
}

static BOOL 
MODWEBDMCCommandHelp(unsigned char *Arguments, unsigned char **Response, BOOL *CloseConnection)
{
	BOOL	responded = FALSE;

	if (Response) {
		if (Arguments) {
			switch(toupper(Arguments[0])) {
				case 'M': {
					if (XplStrCaseCmp(Arguments, DMCMC_DUMP_MEMORY_USAGE) == 0) {
						if ((*Response = MemStrdup(DMCMC_DUMP_MEMORY_USAGE_HELP)) != NULL) {
							responded = TRUE;
						}

						break;
					}
				}

				case 'S': {
					if (XplStrCaseCmp(Arguments, DMCMC_SHUTDOWN) == 0) {
						if ((*Response = MemStrdup(DMCMC_SHUTDOWN_HELP)) != NULL) {
							responded = TRUE;
						}

						break;
					} else if (XplStrCaseCmp(Arguments, DMCMC_STATS) == 0) {
						if ((*Response = MemStrdup(DMCMC_STATS_HELP)) != NULL) {
							responded = TRUE;
						}

						break;
					}
				}

				default: {
					break;
				}
			}
		} else if ((*Response = MemStrdup(DMCMC_HELP_HELP)) != NULL) {
			responded = TRUE;
		}

		if (responded || ((*Response = MemStrdup(DMCMC_UNKOWN_COMMAND)) != NULL)) {
			return(TRUE);
		}
	}

	return(FALSE);
}

static BOOL
SendModWebStatistics(unsigned char *Arguments, unsigned char **Response, BOOL *CloseConnection)
{
	MemStatistics	poolStats;

	if (!Arguments && Response) {
		memset(&poolStats, 0, sizeof(MemStatistics));

		*Response = MemMalloc(sizeof(PRODUCT_NAME)					/*	Long Name						*/
											+ sizeof(PRODUCT_SHORT_NAME)	/*	Short Name						*/
											+ 10									/*	PRODUCT_MAJOR_VERSION		*/
											+ 10									/*	PRODUCT_MINOR_VERSION		*/
											+ 10									/*	PRODUCT_LETTER_VERSION		*/
											+ 10									/*	Connection Pool Allocation Count	*/
											+ 10									/*	Connection Pool Memory Usage		*/
											+ 10									/*	Connection Pool Pitches				*/
											+ 10									/*	Connection Pool Strikes				*/
											+ 10									/*	DMCMV_SERVER_THREAD_COUNT	*/
											+ 10 									/*	DMCMV_CONNECTION_COUNT		*/
											+ 10									/*	DMCMV_MAX_CONNECTION_COUNT	*/
											+ 10									/*	DMCMV_SESSION_COUNT			*/
											+ 10									/*	DMCMV_TOTAL_CONNECTIONS		*/
											+ 10									/*	DMCMV_BAD_PASSWORD_COUNT	*/
											+ 30);								/*	Formatting						*/

		MemPrivatePoolStatistics(ModWebConnectionPool, &poolStats);

		if (*Response) {
			sprintf(*Response, "%s (%s: v%d.%d.%d)\r\n%lu:%lu:%lu:%lu:%d:%d:%lu:%d:%d:%d\r\n", 
					PRODUCT_NAME, 
					PRODUCT_SHORT_NAME, 
					PRODUCT_MAJOR_VERSION, 
					PRODUCT_MINOR_VERSION, 
					PRODUCT_LETTER_VERSION, 
					poolStats.totalAlloc.count, 
					poolStats.totalAlloc.size, 
					poolStats.pitches, 
					poolStats.strikes, 
					XplSafeRead(ModWebServerThreads), 
					XplSafeRead(ModWebConnThreads), 
					ModWebMaxThreadLoad, 
					XplSafeRead(ModWebStats.Clients.Incoming), 
					XplSafeRead(ModWebStats.Clients.Serviced), 
					XplSafeRead(ModWebStats.WrongPassword));

			return(TRUE);
		}

		if ((*Response = MemStrdup("Out of memory.\r\n")) != NULL) {
			return(TRUE);
		}
	} else if ((Arguments) && ((*Response = MemStrdup("Arguments not allowed.\r\n")) != NULL)) {
		return(TRUE);
	}

	return(FALSE);
}

ManagementCommands MODWEBManagementCommands[] = {
	/*	0	HELP[ <MODWEBCommand>]				*/	{	DMCMC_HELP,								MODWEBDMCCommandHelp	}, 
	/*	1	SHUTDOWN									*/	{	DMCMC_SHUTDOWN,						MODWEBShutdown	},
	/*	2	STATS										*/	{	DMCMC_STATS,							SendModWebStatistics	}, 
	/*	3	MEMORY									*/	{	DMCMC_DUMP_MEMORY_USAGE,			ManagementMemoryStats		}, 
};

/*	Management Client Read Function	*/
BOOL ReadMODWEBVariable(unsigned int Variable, unsigned char *Data, size_t *DataLength)
{		
	int				count;
	unsigned char	*ptr;

	switch (Variable) {
		case 0: {	/*	 ModWebMaxThreadLoad */
			if (Data && (*DataLength > 12)) {
				sprintf(Data, "%010lu\r\n", (long unsigned int)ModWebMaxThreadLoad);
			}

			*DataLength = 12;
			break;
		}

		case 1: {	/*	XplAtomic ModWebConnThreads	*/
			if (Data && (*DataLength > 12)) {
				sprintf(Data, "%010lu\r\n", (long unsigned int)XplSafeRead(ModWebConnThreads));
			}

			*DataLength = 12;
			break;
		}

		case 2: {	/*	XplAtomic ModWebServerThreads	*/
			if (Data && (*DataLength > 12)) {
				sprintf(Data, "%010lu\r\n", (long unsigned int)XplSafeRead(ModWebServerThreads));
			}

			*DataLength = 12;
			break;
		}

		case 3: {	/*	BOOL ModWebReceiverStopped	*/
			if (ModWebReceiverStopped == FALSE) {
				ptr = "FALSE\r\n";
				count = 7;
			} else {
				ptr = "TRUE\r\n";
				count = 6;
			}

			if (Data && ((long)*DataLength > count)) {
				strcpy(Data, ptr);
			}

			*DataLength = count;
			break;
		}

		case 4: {	/*	BOOL AllowClientSSL	*/
			if (AllowClientSSL == FALSE) {
				ptr = "FALSE\r\n";
				count = 7;
			} else {
				ptr = "TRUE\r\n";
				count = 6;
			}

			if (Data && ((long)*DataLength > count)) {
				strcpy(Data, ptr);
			}

			*DataLength = count;
			break;
		}

		case 5: {	/*	BOOL ForceLoad	*/
			if (ForceLoad == FALSE) {
				ptr = "FALSE\r\n";
				count = 7;
			} else {
				ptr = "TRUE\r\n";
				count = 6;
			}

			if (Data && ((long)*DataLength > count)) {
				strcpy(Data, ptr);
			}

			*DataLength = count;
			break;
		}

		case 6: {	/*	BOOL UseFormLogoutRedirectURL	*/
			if (UseFormLogoutRedirectURL == FALSE) {
				ptr = "FALSE\r\n";
				count = 7;
			} else {
				ptr = "TRUE\r\n";
				count = 6;
			}

			if (Data && ((long)*DataLength > count)) {
				strcpy(Data, ptr);
			}

			*DataLength = count;
			break;
		}

		case 7: {	/*	int MODWEB_PORT	*/
			if (Data && (*DataLength > 12)) {
				sprintf(Data, "%010lu\r\n", (long unsigned int)MODWEB_PORT);
			}
			*DataLength = 12;
			break;
		}

		case 8: {	/*	int MODWEB_PORT_SSL	*/
			if (Data && ((long)*DataLength > 12)) {
				sprintf(Data, "%010lu\r\n", (long unsigned int)MODWEB_PORT_SSL);
			}
			*DataLength = 12;
			break;
		}

		case 9: {	/*	unsigned char NLSDir[XPL_MAX_PATH+1] */
			count = strlen(NLSDir) + 2;
			if (Data && ((long)*DataLength > count)) {
				sprintf(Data, "%s\r\n", NLSDir);
			}

			*DataLength = count;
			break;
		}

		case 10: {	/*	unsigned char ModuleDir[XPL_MAX_PATH+1] */
			count = strlen(ModuleDir) + 2;
			if (Data && ((long)*DataLength > count)) {
				sprintf(Data, "%s\r\n", ModuleDir);
			}

			*DataLength = count;
			break;
		}

		case 11: {	/*	unsigned char LogoDir[XPL_MAX_PATH+1] */
			count = strlen(LogoDir) + 2;
			if (Data && ((long)*DataLength > count)) {
				sprintf(Data, "%s\r\n", LogoDir);
			}

			*DataLength = count;
			break;
		}

		case 12: {	/*	unsigned char WorkDir[XPL_MAX_PATH+1] */
			count = strlen(WorkDir) + 2;
			if (Data && ((long)*DataLength > count)) {
				sprintf(Data, "%s\r\n", WorkDir);
			}

			*DataLength = count;
			break;
		}

		case 13: {	/*	unsigned char TemplateDir[XPL_MAX_PATH+1] */
			count = strlen(TemplateDir) + 2;
			if (Data && ((long)*DataLength > count)) {
				sprintf(Data, "%s\r\n", TemplateDir);
			}

			*DataLength = count;
			break;
		}

		case 14: {	/*	unsigned char FormLoginRedirectURL[XPL_MAX_PATH+1] */
			count = strlen(FormLoginRedirectURL) + 2;
			if (Data && ((long)*DataLength > count)) {
				sprintf(Data, "%s\r\n", FormLoginRedirectURL);
			}

			*DataLength = count;
			break;
		}

		case 15: {	/*	unsigned char FormLogoutRedirectURL[XPL_MAX_PATH+1] */
			count = strlen(FormLogoutRedirectURL) + 2;
			if (Data && ((long)*DataLength > count)) {
				sprintf(Data, "%s\r\n", FormLogoutRedirectURL);
			}

			*DataLength = count;
			break;
		}

		case 16: {	/*	unsigned char OfficialDomain[MAXEMAILNAMESIZE+1] */
			count = strlen(OfficialDomain)+ 2;
			if (Data && ((long)*DataLength > count)) {
				sprintf(Data, "%s\r\n", OfficialDomain);
			}

			*DataLength = count;
			break;
		}

		case 17: {	/*	unsigned char DefaultTitle */
			if (DefaultTitle) {
				count = strlen(DefaultTitle) + 2;
				if (Data && ((long)*DataLength > count)) {
					sprintf(Data, "%s\r\n", DefaultTitle);
				}
			} else {
				count = 2;
				sprintf(Data,"\r\n");
			}

			*DataLength = count;
			break;
		}

		case 18: {	/*	XplAtomic		ModWebStats.Clients.Incoming		*/
			if (Data && (*DataLength > 12)) {
				sprintf(Data, "%010lu\r\n", (long unsigned int)XplSafeRead(ModWebStats.Clients.Incoming));
			}

			*DataLength = 12;
			break;
		}

		case 19: {	/*	XplAtomic		ModWebStats.Clients.Serviced		*/
			if (Data && (*DataLength > 12)) {
				sprintf(Data, "%010lu\r\n", (long unsigned int)XplSafeRead(ModWebStats.Clients.Serviced));
			}

			*DataLength = 12;
			break;
		}

		case 20: {	/*	XplAtomic		ModWebStats.WrongPassword			*/
			if (Data && (*DataLength > 12)) {
				sprintf(Data, "%010lu\r\n", (long unsigned int)XplSafeRead(ModWebStats.WrongPassword));
			}

			*DataLength = 12;
			break;
		}

		case 21: {	/*	unsigned char													*/
			DMC_REPORT_PRODUCT_VERSION(Data, *DataLength);
			break;
		}

		case 22: {	/*	Version														*/
			unsigned char	version[30];

			PVCSRevisionToVersion(PRODUCT_VERSION, version);
			count = strlen(version) + 12;

			PVCSRevisionToVersion(ModWebDVersion, version);
			count += strlen(version) + 13;

			PVCSRevisionToVersion(ModWebMVersion, version);
			count += strlen(version) + 13;

			PVCSRevisionToVersion(ModWebPVersion, version);
			count += strlen(version) + 13;

			PVCSRevisionToVersion(ModWebRVersion, version);
			count += strlen(version) + 13;

			PVCSRevisionToVersion(ModWebSVersion, version);
			count += strlen(version) + 13;

			PVCSRevisionToVersion(ModWebTVersion, version);
			count += strlen(version) + 13;

			PVCSRevisionToVersion(ModWebUVersion, version);
			count += strlen(version) + 13;

			if (Data && ((long)*DataLength > count)) {
				ptr = Data;

				PVCSRevisionToVersion(PRODUCT_VERSION, version);
				ptr += sprintf(ptr, "modweb.c: %s\r\n", version);

				PVCSRevisionToVersion(ModWebDVersion, version);
				ptr += sprintf(ptr, "modwebd.c: %s\r\n", version);

				PVCSRevisionToVersion(ModWebMVersion, version);
				ptr += sprintf(ptr, "modwebm.c: %s\r\n", version);

				PVCSRevisionToVersion(ModWebPVersion, version);
				ptr += sprintf(ptr, "modwebp.c: %s\r\n", version);

				PVCSRevisionToVersion(ModWebRVersion, version);
				ptr += sprintf(ptr, "modwebr.c: %s\r\n", version);

				PVCSRevisionToVersion(ModWebSVersion, version);
				ptr += sprintf(ptr, "modwebs.c: %s\r\n", version);

				PVCSRevisionToVersion(ModWebTVersion, version);
				ptr += sprintf(ptr, "modwebt.c: %s\r\n", version);

				PVCSRevisionToVersion(ModWebUVersion, version);
				ptr += sprintf(ptr, "modwebu.c: %s\r\n", version);

				*DataLength = ptr - Data;
			} else {
				*DataLength = count;
			}

			break;
		}

		default: {
			*DataLength = 0;
			break;
		}
	}

	return(TRUE);
}

/*	Management Client Write Function	*/
BOOL WriteMODWEBVariable(unsigned int Variable, unsigned char *Data, size_t DataLength)
{
	unsigned char	*ptr;
	unsigned char	*ptr2;
	BOOL				result = TRUE;

	if (!Data || !DataLength) {
		return(FALSE);
	}

	XplRWWriteLockAcquire(&ConfigLock);

	switch (Variable) {
		case 0: {	/*	unsigned long	ModWebMaxThreadLoad							*/
			ptr = strchr(Data, '\n');
			if (ptr) {
				*ptr = '\0';
			}

			ptr2 = strchr(Data, '\r');
			if (ptr2) {
				ptr2 = '\0';
			}

			ModWebMaxThreadLoad = atol(Data);

			if (ptr) {
				*ptr = '\n';
			}

			if (ptr2) {
				*ptr2 = 'r';
			}

			break;
		}

		case 3: {	/*	3	BOOL          ModWebReceiverStopped              */
			if ((toupper(Data[0]) == 'T') || (atol(Data) != 0)) {
				ModWebReceiverStopped = TRUE;
			} else if ((toupper(Data[0] == 'F')) || (atol(Data) == 0)) {
				ModWebReceiverStopped = FALSE;
			} else {
				result = FALSE;
			}

			break;
		}

		case 18: {	/*	XplAtomic		ModWebStats.Clients.Incoming		*/
			ptr = strchr(Data, '\n');
			if (ptr) {
				*ptr = '\0';
			}

			ptr2 = strchr(Data, '\r');
			if (ptr2) {
				ptr2 = '\0';
			}

			XplSafeWrite(ModWebStats.Clients.Incoming, atol(Data));

			if (ptr) {
				*ptr = '\n';
			}

			if (ptr2) {
				*ptr2 = 'r';
			}

			break;
		}

		case 19: {	/*	XplAtomic		ModWebStats.Clients.Serviced		*/
			ptr = strchr(Data, '\n');
			if (ptr) {
				*ptr = '\0';
			}

			ptr2 = strchr(Data, '\r');
			if (ptr2) {
				ptr2 = '\0';
			}

			XplSafeWrite(ModWebStats.Clients.Serviced, atol(Data));

			if (ptr) {
				*ptr = '\n';
			}

			if (ptr2) {
				*ptr2 = 'r';
			}

			break;
		}

		case 20: {	/*	XplAtomic		ModWebStats.WrongPassword			*/
			ptr = strchr(Data, '\n');
			if (ptr) {
				*ptr = '\0';
			}

			ptr2 = strchr(Data, '\r');
			if (ptr2) {
				ptr2 = '\0';
			}

			XplSafeWrite(ModWebStats.WrongPassword, atol(Data));

			if (ptr) {
				*ptr = '\n';
			}

			if (ptr2) {
				*ptr2 = 'r';
			}

			break;
		}

		case 1:	/*	1	XplAtomic     ModWebConnThreads;                 */
		case 2:	/*	2	XplAtomic     ModWebServerThreads;               */
		case 4:	/*	4	BOOL          AllowClientSSL                     */
		case 5:	/*	5	BOOL          ForceLoad                          */
		case 6:	/*	6	BOOL          UseFormLogoutRedirectURL           */
		case 7:	/*	7	int           MODWEB_PORT                        */
		case 8:	/*	8	int           MODWEB_PORT_SSL                    */
		case 9:	/*	9	unsigned char NLSDir[XPL_MAX_PATH+1]                */
		case 10:	/*	10	unsigned char ModuleDir[XPL_MAX_PATH+1]             */
		case 11:	/*	11	unsigned char LogoDir[XPL_MAX_PATH+1]               */
		case 12:	/*	12	unsigned char WorkDir[XPL_MAX_PATH+1]               */
		case 13:	/*	13	unsigned char TemplateDir[XPL_MAX_PATH+1]           */
		case 14:	/*	14	unsigned char FormLoginRedirectURL[XPL_MAX_PATH+1]  */
		case 15:	/*	15	unsigned char FormLogoutRedirectURL[XPL_MAX_PATH+1] */
		case 16:	/*	16	unsigned char OfficialDomain[MAXEMAILNAMESIZE+1] */
		case 17:	/*	17	unsigned char *DefaultTitle                      */
		default: {
			result = FALSE;
			break;
		}
	}

	XplRWWriteLockRelease(&ConfigLock);

	return(result);
}

SessionFuncs SessionFuncTblNorm = {
  XplIPWrite, 
  XplIPWriteSSL,
  XplIPRead, 
  XplIPReadSSL,
};

ConnectionFuncs ConnectionFuncTblNorm = {
  XplIPWrite, 
  XplIPWriteSSL,
  XplIPRead, 
  XplIPReadSSL
};

SessionFuncs SessionFuncTblTrace = {
  NMAPWriteTrace, 
  XplIPWriteSSL,
  NMAPReadTrace, 
  XplIPReadSSL,
};

ConnectionFuncs ConnectionFuncTblTrace = {
  ClientWriteTrace, 
  XplIPWriteSSL,
  ClientReadTrace, 
  XplIPReadSSL
};

ConnectionFuncs	*ConnectionFuncTbl = &ConnectionFuncTblNorm;
SessionFuncs	*SessionFuncTbl = &SessionFuncTblNorm;

#undef DEBUG

int
MWDirectClientRead(ConnectionStruct *Client, unsigned char *Buf, int Len)
{
	return(DoClientRead(Client, Buf, Len, CONNECTION_TIMEOUT));
}

int
MWDirectClientWrite(ConnectionStruct *Client, unsigned char *Buf, int Len)
{
	return(DoClientWrite(Client, Buf, Len));
}

int
MWDirectNMAPRead(SessionStruct *Session, unsigned char *Buf, int Len)
{
	return(DoNMAPRead(Session, Buf, Len, CONNECTION_TIMEOUT));
}

int
MWDirectNMAPWrite(SessionStruct *Session, unsigned char *Buf, int Len)
{
	return(DoNMAPWrite(Session, Buf, Len));
}


/*
	Trace functions
*/
int
ClientReadTrace(void *sktCtx, unsigned char *Buf, int Len, int sktTimeout)
{
	int					retval;
	long		i;

	retval = XplIPRead(sktCtx, Buf,Len, sktTimeout);

	/*
		Now we've read, so lets print it

		We are going to print it char by char (Yes I know its very slow)
		because we want to insert a prefix at each \r\n.
	*/
	XplWaitOnLocalSemaphore(TraceSemaphore);
	XplConsolePrintf("\r\nHTTP > ");

	for (i = 0; i < Len; i++) {
		unsigned char		c = Buf[i];

		XplConsolePrintf("%c", c);
	}
	XplSignalLocalSemaphore(TraceSemaphore);

	return(retval);
}

int
ClientWriteTrace(void *sktCtx, unsigned char *Buf, int Len)
{
	long		i;
	/*
		We have the data, so lets print it

		We are going to print it char by char (Yes I know its very slow)
		because we want to insert a prefix at each \r\n.
	*/

	XplWaitOnLocalSemaphore(TraceSemaphore);
	XplConsolePrintf("\r\nHTTP < ");

	for (i = 0; i < Len; i++) {
		unsigned char		c = Buf[i];

		XplConsolePrintf("%c", c);
	}
	XplSignalLocalSemaphore(TraceSemaphore);

	return(XplIPWrite(sktCtx, Buf, Len));
}

int
NMAPReadTrace(void *sktCtx, unsigned char *Buf, int Len, int sktTimeout)
{
	int		retval;

	retval = XplIPRead(sktCtx, Buf, Len, sktTimeout);

	/*
		Now we've read, so lets print it

		We are going to print it char by char (Yes I know its very slow)
		because we want to insert a prefix at each \r\n.
	*/
	if (/* Session && (*/ !NMAPTraceUser /* || MWQuickCmp(NMAPTraceUser, Session->User))*/ ) {
		long			i;

		XplWaitOnLocalSemaphore(TraceSemaphore);

//		if (!Session->NMAPTraceReadPrefix) {
//			XplConsolePrintf("NMAP %s < ", Session->User);
//		}

		for (i = 0; i < retval; i++) {
			unsigned char		c = Buf[i];

			XplConsolePrintf("%c", c);

			if (i + 2 < retval && c == '\n') {
				/*
					If we find the end of a line, but are not at the end of what we have
					read, then send a new prefix
				*/

				//			XplConsolePrintf("NMAP %s < ", Session->User);
			}
		}

//		if (Buf[retval - 1] == '\r' || Buf[retval - 1] == '\n') {
//			Session->NMAPTraceReadPrefix = FALSE;
//		} else {
//			Session->NMAPTraceReadPrefix = TRUE;
//		}

		XplSignalLocalSemaphore(TraceSemaphore);
	}

	return(retval);
}

int
NMAPWriteTrace(void *sktCtx, unsigned char *Buf, int Len)
{
	/*
		We already have our data, so lets print it

		We are going to print it char by char (Yes I know its very slow)
		because we want to insert a prefix at each \r\n.
	*/
	if (!NMAPTraceUser) {
		long			i;

		XplWaitOnLocalSemaphore(TraceSemaphore);

		for (i = 0; i < Len; i++) {
			unsigned char		c = Buf[i];

			XplConsolePrintf("%c", c);

		}

		XplSignalLocalSemaphore(TraceSemaphore);
	}

	return(XplIPWrite(sktCtx, Buf, Len));

}

BOOL ModWebConnectionAllocCB(void *Buffer, void *ClientData)
{
	register ConnectionStruct *c = (ConnectionStruct *)Buffer;

    c->Flags = 0;
	c->State = STATE_FRESH;
	c->BufferPtr = 0;
	c->SBufferPtr = 0;
	c->KeepAlive = FALSE;
	c->ClientSSL = 0;
	c->Credentials[0] = '\0';
	c->Session = NULL;
	c->TSession = NULL;
	c->PostData = NULL;
	c->FormSeparator = NULL;
    c->URLHost = NULL;
	c->NMAPProtected = FALSE;
	c->DeviceType = DEVICE_HTML;
	c->Cookie = 0;
	c->ClearCookie = FALSE;
	c->CookieID = 0;

	return(TRUE);
}

void ReturnModWebConnection(ConnectionStruct *Client)
{
	register ConnectionStruct *c = Client;

    c->Flags = 0;
	c->State = STATE_FRESH;
	c->BufferPtr = 0;
	c->SBufferPtr = 0;
	c->KeepAlive = FALSE;
	c->ClientSSL = 0;
	c->Credentials[0] = '\0';
	c->Session = NULL;
	c->TSession = NULL;
	c->PostData = NULL;
	c->FormSeparator = NULL;
    c->URLHost = NULL;
	c->NMAPProtected = FALSE;
	c->DeviceType = DEVICE_HTML;
	c->Cookie = 0;
	c->ClearCookie = FALSE;
	c->CookieID = 0;

	MemPrivatePoolReturnEntry(c);

	return;
}

/* End Trace functions */

static void
SendMessagePage(ConnectionStruct *client, unsigned char *message, unsigned long messageLen)
{
    SendHTTPHeaderDynamic(client, "text/html", strlen("text/html"));
    MWSendClient(client, "<HTML><BODY>", strlen("<HTML><BODY>"));
    MWSendClient(client, message, messageLen);
    MWSendClient(client, "</BODY></HTML>", strlen("</BODY></HTML>"));
}


BOOL
EndClientConnection(ConnectionStruct *Client)
{
	if (Client->NMAPProtected) {
		return(FALSE);
	}

	if (Client) {
		if (Client->State == STATE_ENDING) {
			return(FALSE);
		}
		Client->State=STATE_ENDING;

		if (Client->s!=-1) {
			MWFlushClient(Client);
			IPclose(Client->s);
		}

		if (Client->ClientSSL) {
			if (Client->CSSL) {
				SSL_shutdown(Client->CSSL);
				SSL_free(Client->CSSL);
				Client->CSSL = NULL;
			}
		}

		if (Client->FormSeparator) {
			MemFree(Client->FormSeparator);
		}


		if (Client->PostData) {
			fclose(Client->PostData);
			if (Client->TSession) {
				DestroyTSession(Client->TSession);
			}
		} else {
			ReleaseTSession((unsigned int)Client->TSession);
		}

        if (Client->URLHost) {
            MemFree(Client->URLHost);
            Client->URLHost = NULL;
        }

		ReleaseSession(Client->Session);
		MWDebug("[%d.%d.%d.%d] Closing connection\n",	Client->cs.sin_addr.s_net,Client->cs.sin_addr.s_host,Client->cs.sin_addr.s_lh,Client->cs.sin_addr.s_impno);
		ReturnModWebConnection(Client);
	}

	XplSafeDecrement(ModWebConnThreads);

	XplExitThread(EXIT_THREAD, 0);
	return(TRUE);
}

BOOL
MWProtectNMAP(ConnectionStruct *Client, BOOL Protect)
{
	Client->NMAPProtected=Protect;
	return(TRUE);
}

BOOL	
MWFlushClient(ConnectionStruct *Client)
{
	int	count;
	int	sent=0;

 	while ((sent<Client->SBufferPtr) && (!Exiting)) {
		count=DoClientWrite(Client, Client->SBuffer+sent, Client->SBufferPtr-sent);
		if ((count<1) || (Exiting)) {
			if (!Client->NMAPProtected) {
				return(EndClientConnection(Client));
			} else {
				count=Client->SBufferPtr-sent;
			}
		}
		sent+=count;
	}
	Client->SBufferPtr=0;
	Client->SBuffer[0]='\0';
	return(TRUE);
}

BOOL
MWSendClient(ConnectionStruct *Client, unsigned char *Data, int Len)
{
	/* This function should be kept in sync with MWSendClientInline */
	int	sent=0;

	if (!Len)
		return(TRUE);

	if (!Data)
		return(FALSE);

	while((sent<Len) && !Exiting) {
		if (Len-sent+Client->SBufferPtr>=MTU) {
			memcpy(Client->SBuffer+Client->SBufferPtr, Data+sent, (MTU-Client->SBufferPtr));
			sent+=(MTU-Client->SBufferPtr);
			Client->SBufferPtr+=(MTU-Client->SBufferPtr);
			if (!MWFlushClient(Client)) {
				return(FALSE);
			}
		} else {
			memcpy(Client->SBuffer+Client->SBufferPtr, Data+sent, Len-sent);
			Client->SBufferPtr+=Len-sent;
			sent=Len;
		}
	}
	Client->SBuffer[Client->SBufferPtr]='\0';
	return(TRUE);
}

BOOL
MWHTMLSendClient(ConnectionStruct *Client, unsigned char *Data, int Len)
{
	StreamStruct *HTMLCodec=Client->Session->HTMLCodec;

	if (HTMLCodec) {
		/* Client changes between connections, so we need to reset client for every send */
		HTMLCodec->Next->Next->StreamData=(void *)Client;
		HTMLCodec->StreamData=Data;
		HTMLCodec->StreamLength=Len;

		HTMLCodec->Codec(HTMLCodec, HTMLCodec->Next);

		/* Reset the codec for the next use */
		HTMLCodec->Len=0;
		HTMLCodec->Charset=NULL;
		HTMLCodec->URL=NULL;
		HTMLCodec->EOS=0;
		return(TRUE);
	} else {
		/* Just send raw, no codec chain set up */
		return(MWSendClient(Client, Data, Len));
	}
}

BOOL
MWSendNMAPServer(SessionStruct *Session, unsigned char *Data, int Len)
{
	int	count;
	int	sent=0;

	Session->NMAPTimestamp = ModwebTimeStamp;

	while (sent<Len) {
// Fix me - handle error gracefully
		count=DoNMAPWrite(Session, Data+sent, Len-sent);
		if ((count<1) || (Exiting)) {
			IPclose(Session->NMAPs);
			Session->NMAPs=-1;
			return(FALSE);
		}
		sent+=count;
	}

	return(TRUE);
}

int
MWGetNMAPAnswer(SessionStruct *Session, unsigned char *Reply, int ReplyLen, BOOL CheckForResult)
{
	int				count;
	int				Result;
	unsigned char	*ptr;
	unsigned long	OOBCounter= 0;

	if (Session->NMAPs==-1)
		return(-1);

GetNextLine:
	if ((Session->NBufferPtr>0) && ((ptr=strchr(Session->NBuffer, 0x0a))!=NULL)) {
		*ptr='\0';
		if (ReplyLen>(long)strlen(Session->NBuffer)) {
			strcpy(Reply, Session->NBuffer);
			Session->NBufferPtr = strlen(ptr+1);
			memmove(Session->NBuffer, ptr+1, Session->NBufferPtr+1);
			if ((ptr=strrchr(Reply, 0x0d))!=NULL) {
				*ptr = '\0';
			}
		} else {
			*ptr = 0x0a;
			strncpy(Reply, Session->NBuffer, ReplyLen-1);
			Reply[ReplyLen-1] = '\0';
			Session->NBufferPtr = strlen(Session->NBuffer + ReplyLen - 1);
			memmove(Session->NBuffer, Session->NBuffer + ReplyLen - 1, Session->NBufferPtr + 1);
		}
	} else {
		do {
			if (!Exiting && ((count = DoNMAPRead(Session, Session->NBuffer + Session->NBufferPtr, BUFSIZE - Session->NBufferPtr, CONNECTION_TIMEOUT)) > 0)) {
				Session->NBufferPtr += count;
				Session->NBuffer[Session->NBufferPtr] = '\0';
				if ((ptr = strchr(Session->NBuffer,0x0a)) != NULL) {
					*ptr = '\0';
					count = min((ptr - Session->NBuffer) + 1, ReplyLen);
					memcpy(Reply, Session->NBuffer, count);

					Session->NBufferPtr = strlen(ptr + 1);
					memmove(Session->NBuffer, ptr + 1, Session->NBufferPtr + 1);
					if ((ptr = strrchr(Reply, 0x0d)) != NULL) {
						*ptr='\0';
					}
					break;
				}
			} else {
				/* FIX ME - handle error gracefully */
				return(-1);
			}
		} while (TRUE);
	}

	if (CheckForResult) {
		if ((Reply[0] != '6') || (Reply[1] != '0') || (Reply[2] != '0') || (Reply[3] != '0')) {
			if ((Reply[4] == ' ') || (Reply[4] == '-')) {
				/* Expected case */

				Result = atoi(Reply);

				if (Result != 5001) {
					memmove(Reply, Reply + 5, strlen(Reply + 5) + 1);
				} else {
					IPclose(Session->NMAPs);
					Session->NMAPs=-1;
				}
			} else {
				/* NMAP should not respond this way */
				return(-1);
			}
		} else {
			/* Handle out of bounds NMAP message */
			Session->NMAPChanged = TRUE;
			OOBCounter++;
			/* Every 64th time through, the bottom 7 bits will all be zero.  This is a cheap way of dividing by 64 */   
			if ((OOBCounter & 0x3f) != 0) {
				;
			} else {
				//XplConsolePrintf("User %s has received %d flag change notifications.\n", (Session->User) ? Session->User : "<unknown>", OOBCounter);
				XplDelay(1);
			}
			goto GetNextLine;
		}

	} else {
		Result = atoi(Reply);
	}
	return(Result);
}

BOOL
MWReadClientLine(ConnectionStruct *Client)
{
	BOOL				Ready=FALSE;
	unsigned char	*ptr;
	int				count;

	if ((Client->BufferPtr>0) && ((ptr=strchr(Client->Buffer, 0x0a))!=NULL)) {
		*ptr='\0';
		memcpy(Client->Command, Client->Buffer, ptr-Client->Buffer+1);
		Client->BufferPtr-=strlen(Client->Command)+1;
		memmove(Client->Buffer, ptr+1, Client->BufferPtr);
		Client->Buffer[Client->BufferPtr]='\0';
		if ((ptr=strrchr(Client->Command, 0x0d))!=NULL) {
			*ptr='\0';
		}
		Ready=TRUE;
	} else {
		while (!Ready) {
			if (Exiting) {
				return(EndClientConnection(Client));
			}
			if (!Client->PostData) {
				count=DoClientRead(Client, Client->Buffer+Client->BufferPtr, BUFSIZE-Client->BufferPtr, CONNECTION_TIMEOUT);
				if ((count<1) || (Exiting)) {
					return(EndClientConnection(Client));
				}
			} else {
				count=fread(Client->Buffer+Client->BufferPtr, 1, BUFSIZE-Client->BufferPtr, Client->PostData);
				if (feof(Client->PostData) || ferror(Client->PostData) || (Exiting)) {
					return(EndClientConnection(Client));
				}
			}
			if (count>(long)Client->ContentLength) {
				Client->ContentLength=0;
			} else {
				Client->ContentLength-=count;
			}
			Client->BufferPtr+=count;
			Client->Buffer[Client->BufferPtr]='\0';
			if ((ptr=strchr(Client->Buffer,0x0a))!=NULL) {
				*ptr='\0';
				memcpy(Client->Command, Client->Buffer, ptr-Client->Buffer+1);
				Client->BufferPtr-=strlen(Client->Command)+1;
				memmove(Client->Buffer, ptr+1, Client->BufferPtr);
				Client->Buffer[Client->BufferPtr]='\0';
				if ((ptr=strrchr(Client->Command, 0x0d))!=NULL) 
					*ptr='\0';
				Ready=TRUE;
			} else if (Client->BufferPtr>BUFSIZE) {
				return(EndClientConnection(Client));
			}
		}
	}
	return(TRUE);
}

static int 
MWSetAttendeeStatus(SessionStruct *session, char *address, int state, char *calendar, char *uid, unsigned long sequence)
{
    int ccode;
    unsigned long entryID;
    char buffer[BUFSIZE];
    char cmd[BUFSIZE];

    /*
        a) Find the matching entry
        b) Search for the specified attendee
        c) Update the status of the attendee
    */
    
    if (((ccode = MWSendNMAPServer(session, cmd, snprintf(cmd, BUFSIZE, "CSOPEN %s\r\n", calendar))) != -1) 
	&& ((ccode = MWGetNMAPAnswer(session, buffer, BUFSIZE, FALSE)) == 1000) 
	&& ((ccode = MWSendNMAPServer(session, "CSUPDA\r\n", 8)) != -1)) {
        do {
            if ((ccode = MWGetNMAPAnswer(session, buffer, BUFSIZE, FALSE)) == 1000) {
                break;
            }
        } while (ccode != -1);

        if ((ccode == 1000) 
                && ((ccode = MWSendNMAPServer(session, cmd, snprintf(cmd, BUFSIZE, "CSFIND %lu %s\r\n", sequence, uid))) != -1) 
                && ((ccode = MWGetNMAPAnswer(session, buffer, BUFSIZE, TRUE)) == 1000)) {
            entryID = atol(buffer);

            /* Update the attendee */
            switch(state) {
                default:
                case ICAL_PARTSTAT_NEEDS_ACTION:{
                    state = NMAP_CAL_STATE_NEED_ACT;        
                    if ((ccode = MWSendNMAPServer(session, cmd, snprintf(cmd, BUFSIZE, "CSATND %lu %c %s\r\n", entryID, state, address))) != -1) {
                        ccode = MWGetNMAPAnswer(session, buffer, BUFSIZE, TRUE);
                    }

                    break;
                }

                case ICAL_PARTSTAT_ACCEPTED:{
                    state = NMAP_CAL_STATE_ACCEPTED;        
                    if ((ccode = MWSendNMAPServer(session, cmd, snprintf(cmd, BUFSIZE, "CSATND %lu %c %s\r\n", entryID, state, address))) != -1) {
                        ccode = MWGetNMAPAnswer(session, buffer, BUFSIZE, TRUE);
                    }

                    break;
                }

                case ICAL_PARTSTAT_DECLINED:{
                    state = NMAP_CAL_STATE_DECLINED;
                    if ((ccode = MWSendNMAPServer(session, cmd, snprintf(cmd, BUFSIZE, "CSATND %lu %c %s\r\n", entryID, state, address))) != -1) {
                        ccode = MWGetNMAPAnswer(session, buffer, BUFSIZE, TRUE);
                    }

                    break;
                }

                case ICAL_PARTSTAT_TENTATIVE:{
                    state = NMAP_CAL_STATE_TENTATIVE;
                    if ((ccode = MWSendNMAPServer(session, cmd, snprintf(cmd, BUFSIZE, "CSATND %lu %c %s\r\n", entryID, state, address))) != -1) {
                        ccode = MWGetNMAPAnswer(session, buffer, BUFSIZE, TRUE);
                    }

                    break;
                }

                case ICAL_PARTSTAT_COMPLETED:{        
                    state = NMAP_CAL_STATE_COMPLETED;    
                    if ((ccode = MWSendNMAPServer(session, cmd, snprintf(cmd, BUFSIZE, "CSATND %lu %c %s\r\n", entryID, state, address))) != -1) {
                        ccode = MWGetNMAPAnswer(session, buffer, BUFSIZE, TRUE);
                    }

                    /* note: removed logic to autocomplete originator if all attendees complete task */
                    /*       Decided that it is easier for user to maintain his completed tasks with respect to his own calendar */
                    break;
                }

                case ICAL_PARTSTAT_IN_PROCESS: {
                    state = NMAP_CAL_STATE_INPROCESS;
                    break;
                }

                case ICAL_PARTSTAT_DELEGATED: {
		    /* Do we want to bother with delegation */
#if 0
                    ccode = SetAttendeeDelegationStatus(client, iCal, entryID, attendee, saddr, user);
                    break;
#endif
                }
            }
        }
    }

    return(ccode);
}


static BOOL
ReadHeader(ConnectionStruct *Client)
{
	BOOL					inHeader;
	unsigned char		*lineStart;
	unsigned char		*lineEnd;
	int					count;
	unsigned long		fragmentLen;

	Client->ContentLength = 0;
	if (Client->FormSeparator) {
		MemFree(Client->FormSeparator);
	}
	Client->FormSeparator = NULL;
	for (count = 0; count < 10; count++) {
		Client->SessionUID[count] = 0;
	}

	inHeader = TRUE;
	lineStart = Client->Buffer;

	do {
		lineEnd = strchr(lineStart, 0x0a);
		if (lineEnd != NULL && (lineEnd > lineStart)) {
			;
		} else {
			/* we don't have a full line in the buffer */
			if (lineStart != Client->Buffer) {
				/* there is data in the buffer that we don't need anymore. make as much room as possible for the read */
				if (lineStart < (Client->Buffer + Client->BufferPtr))	{
					/* Preserve the unseen line fragment and move it to the beginning of the buffer */
					fragmentLen = (Client->Buffer + Client->BufferPtr) - lineStart;
					memmove(Client->Buffer, lineStart, fragmentLen + 1);  /* move the NULL */
					Client->BufferPtr = fragmentLen;
				} else {
					Client->BufferPtr = 0;
				}

				lineStart = Client->Buffer;
			}

			do {
				if (Client->BufferPtr < BUFSIZE) {
					count = DoClientRead(Client, Client->Buffer + Client->BufferPtr, BUFSIZE - Client->BufferPtr, CONNECTION_TIMEOUT);

					if ((count > 0) && !Exiting) {
						Client->BufferPtr += count;
						Client->Buffer[Client->BufferPtr] = '\0';
						lineEnd = strchr(Client->Buffer, 0x0a);
						if (lineEnd != NULL) {
							 
							break;
						}

						/* There is still not a newline, go get more */
						continue;
					}

					return(EndClientConnection(Client));
				}

				/* the buffer is full and there is not a complete line. */
				/* since we are not interested in header line of this length */
				/* throw everything away up to the next newline */

				Client->BufferPtr = 0;
		
				do {
					if (Client->BufferPtr < BUFSIZE) {
						count = DoClientRead(Client, Client->Buffer + Client->BufferPtr, BUFSIZE - Client->BufferPtr, CONNECTION_TIMEOUT);
						if ((count > 0) && !Exiting) {
							Client->BufferPtr += count;
							Client->Buffer[Client->BufferPtr] = '\0';
							lineEnd = strchr(Client->Buffer, 0x0a);
							if (lineEnd != NULL) {
								lineStart = lineEnd + 1;
								if (lineStart != Client->Buffer) {
									if (lineStart < (Client->Buffer + Client->BufferPtr))	{
										/* Preserve the line fragment in the buffer and make as much room as possible for the read */
										fragmentLen = (Client->Buffer + Client->BufferPtr) - lineStart;
										memmove(Client->Buffer, lineStart, fragmentLen + 1);  /* copy the NULL */
										Client->BufferPtr = fragmentLen;
									} else {
										Client->BufferPtr = 0;
									}

									lineStart = Client->Buffer;
								}
								break;
							}

							/* There is still not a newline, go get more */
							continue;
						}
						return(EndClientConnection(Client));
					}

					/* the buffer is full again and there is still not a complete line */
						
					Client->BufferPtr = 0;
					continue;

				} while (TRUE);

				/* the long line has been skipped */
				lineEnd = strchr(Client->Buffer, 0x0a);
				if (lineEnd == NULL) {
					/* the buffer does not contain a full line */
					continue;
				}

				break;
			} while (TRUE);
		}

		/* We have a complete header line in the buffer */
		*lineEnd = '\0';
		if (*(lineEnd - 1) == 0x0d) {
			*(lineEnd - 1) = '\0';
		}

        switch(toupper(lineStart[0])) {
			case '\0': {
				inHeader = FALSE;
				break;
			}

			case 'C': {
				if (MWQuickNCmp(lineStart, "connection: keep-alive", 22)) {
					Client->KeepAlive = TRUE;
				} else if (MWQuickNCmp(lineStart, "content-length: ", 16)) {
					Client->ContentLength = atol(lineStart + 16);
				} else if (MWQuickNCmp(lineStart, "content-type: ", 14)) {
					unsigned char	*ptr;

					if (MWQuickNCmp(lineStart + 14, "multipart/form-data", 19)) {
						Client->EncodingType = FORM_DATA_ENCODED;
						ptr = lineStart + 13;
						do {
							ptr = strchr(ptr + 1, 'b');

							if (ptr) {
								if (MWQuickNCmp(ptr, "boundary=", 9)) {
									if (ptr[9] != '"') {
										Client->FormSeparator = MemStrdup(ptr + 7);
									} else {
										Client->FormSeparator = MemStrdup(ptr + 8);
										ptr = strchr(ptr+10, '"');
										if (ptr) {
											*ptr = '\0';
										}
									}
									Client->FormSeparator[0] = '-';
									Client->FormSeparator[1] = '-';
									ptr = NULL;
								}
							}
						} while (ptr);
					} else {
						Client->EncodingType = FORM_URL_ENCODED;
					}
				} else if (MWQuickNCmp(lineStart, "cookie: ", 8)) {
					unsigned char	*ptr;

					ptr = lineStart + 7;
					do {
						ptr = strchr(ptr + 1, '=');
						if (ptr) {
							unsigned char		*CookieName = ptr - 1;

							while (*CookieName >= '0' && *CookieName <= '9' && CookieName > lineStart + 7) {
								CookieName--;
							}

							if ((CookieName - 2 > lineStart + 7) && MWQuickNCmp(CookieName - 2, "SID", 3)) {
								unsigned long		CookieID = atol(CookieName + 1);

								if (CookieID < 10) {
									Client->SessionUID[CookieID] = atol(ptr + 1);
								}
							}
						}
					} while (ptr);

					/*
						Find the next avaliable free spot for a cookie.  Don't bother checking
						the 10th spot, because if thats all thats left we are just going to use
						it anyway.
					*/
					Client->CookieID = 0;
					while (Client->SessionUID[Client->CookieID] != 0 && Client->CookieID < 9) {
						Client->CookieID++;
					}					
				}
				break;
			}

			case 'A': {
				if (MWQuickNCmp(lineStart, "Authorization: Basic ", 21)) {
					int	len;

					if (AuthHosts == 0) {
						/* Decode the username and password */
						len = strlen(lineStart + 21);
						if (len > (MAXEMAILNAMESIZE * 2)) {
							len = MAXEMAILNAMESIZE * 2;
						}
						memcpy(Client->Credentials, lineStart + 21, len);
						Client->Credentials[MWDecodeBase64(Client->Credentials, len, &len)] = '\0';
						MWDebug("Client Credentials:%s\n", Client->Credentials);
					}
				} else if (MWQuickNCmp(lineStart, "Accept-Language: ", 17)) {

					/* Copy up to 20 characters of the language list. */
					HulaStrNCpy(Client->Language, lineStart + 17, 20);
					Client->Language[19] = '\0';

				} else if (MWQuickNCmp(lineStart, "Accept: ", 8) && strstr(lineStart, "wap")) {
					Client->DeviceType = DEVICE_WML;
				}
				break;
			}

            case 'H': {
				unsigned char *ptr;

                if (MWQuickNCmp(lineStart, "Host:", 5)) {
                    ptr = lineStart + 5;
                    while(isspace(*ptr)) {
                        ptr++;
                    }

                    Client->URLHost = MemStrdup(ptr);
                }
            }

            case 'U': {
                if (MWQuickNCmp(lineStart, "User-Agent:", 11)) {
                    if (strstr(lineStart, "Windows")) {
                        Client->Flags |= MWCLIENT_FLAG_WINDOWS;
                    }
                }
            }
		}
		
		if (AuthHosts == 0) {
			;
		} else {
			if ((AuthIDHeader[0] == lineStart[0]) && MWQuickNCmp(lineStart, AuthIDHeader, AuthIDHeaderLen)) {
				unsigned char *ptr;
				unsigned long i;

				ptr = lineStart + AuthIDHeaderLen;
				while (*ptr != '\0') {
					if (!isspace(*ptr)) {
						HulaStrNCpy(Client->Credentials, ptr, sizeof(Client->Credentials));
						for (i = 0; i < AuthHosts; i++) {
							if (AuthAddress[i] == Client->cs.sin_addr.s_addr) {
								Client->TrustCredentials = TRUE;
								break;
							}
						}
						break;
					}
					ptr++;
				} 
			}
		}

		lineStart = lineEnd + 1;

	} while (inHeader);

	if (lineStart == Client->Buffer) {
		;
	} else if (lineStart < (Client->Buffer + Client->BufferPtr))	{
		fragmentLen = Client->BufferPtr - (lineStart - Client->Buffer);
		memmove(Client->Buffer, lineStart, fragmentLen + 1); /* copy the NULL */
		Client->BufferPtr = fragmentLen;
	} else {
		Client->BufferPtr = 0;
	}

	if (Client->ContentLength > 0) {
		if ((unsigned int)Client->BufferPtr > Client->ContentLength) {
			Client->ContentLength = 0;
		} else {
			Client->ContentLength -= Client->BufferPtr;
		}
	}
	return(TRUE);
}

static BOOL
HandleConnection(void *param)
{
	ConnectionStruct		*Client = (ConnectionStruct *)param;
	int						count;
	int						ReplyInt;
	BOOL						Ready;
	unsigned char			*ptr;
	unsigned char			*URL;
	unsigned long			URLLen;
	unsigned char			Buffer[BUFSIZE+1];
	unsigned char			Answer[BUFSIZE+1];
	URLStruct				URLData;

	SetCurrentNameSpace(NWOS2_NAME_SPACE);

	MWDebug("HandleConnection() called\n");

	if (Client->ClientSSL) {
		LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_AUTH, LOGGER_EVENT_SSL_CONNECTION, LOG_INFO, 0, NULL, NULL, XplHostToLittle(Client->cs.sin_addr.s_addr), 0, NULL, 0);

		if (SSL_accept(Client->CSSL) != 1) {
			SSL_free(Client->CSSL);
			Client->CSSL = NULL;
			return(EndClientConnection(Client));
		}
	} else {
		LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_AUTH, LOGGER_EVENT_CONNECTION, LOG_INFO, 0, NULL, NULL, XplHostToLittle(Client->cs.sin_addr.s_addr), 0, NULL, 0);
	}

	while (TRUE) {
		Ready = FALSE;
		MWDebug("Begin of command loop, reading request (Session:%x)\n", (unsigned int)Client->Session);

		if ((Client->BufferPtr > 0) && ((ptr = strchr(Client->Buffer, 0x0a)) != NULL)) {
			*ptr = '\0';

			memcpy(Client->Command, Client->Buffer, ptr-Client->Buffer + 1);
			Client->BufferPtr = strlen(ptr+1);
			memmove(Client->Buffer, ptr + 1, Client->BufferPtr + 1);

			if ((ptr = strrchr(Client->Command, 0x0d)) != NULL) {
				*ptr = '\0';
			}

			Ready = TRUE;
		} else {
			while (!Ready) {
				if (Exiting) {
					return(EndClientConnection(Client));
				}

				MWDebug("Doing DoClientRead\n");
				count = DoClientRead(Client, Client->Buffer+Client->BufferPtr, BUFSIZE-Client->BufferPtr, CONNECTION_TIMEOUT);
				MWDebug("Done DoClientRead\n");

				if ((count < 1) || (Exiting)) {
					return(EndClientConnection(Client));
				}

				Client->BufferPtr += count;
				Client->Buffer[Client->BufferPtr] = '\0';
				if ((ptr = strchr(Client->Buffer, 0x0a)) != NULL) {
					*ptr = '\0';

					memcpy(Client->Command, Client->Buffer, ptr-Client->Buffer + 1);
					Client->BufferPtr = strlen(ptr + 1);
					memmove(Client->Buffer, ptr + 1, Client->BufferPtr);
					Client->Buffer[Client->BufferPtr] = '\0';

					if ((ptr = strrchr(Client->Command, 0x0d)) != NULL) {
						*ptr = '\0';
					}

					Ready = TRUE;
				} else if (Client->BufferPtr > BUFSIZE) {
					return(EndClientConnection(Client));
				}
			}
		}

		//MWDebug("[%d.%d.%d.%d] %s\n",	Client->cs.sin_addr.s_net,Client->cs.sin_addr.s_host,Client->cs.sin_addr.s_lh,Client->cs.sin_addr.s_impno,Client->Command);
		MWDebug("Cmd:%s\n", Client->Command);

		/* Handle busy redirection */
#if 0
		if (Configuration & CONFIG_REDIRECT_ONLY) {
			ReadHeader(Client);
			KeepAlive=FALSE;
			if (Client->ClientSSL) {
				ReplyInt=sprintf(Answer, MSGREDIRECT_TO, RedirectURLSSL, RedirectURLSSL, RedirectURLSSL);
			} else {
				ReplyInt=sprintf(Answer, MSGREDIRECT_TO, RedirectURL, RedirectURL, RedirectURL);
			}
			MWSendClient(Client, Answer, ReplyInt);
		}
#endif

		/* Read the rest of the HTTP header */

		ReadHeader(Client);
		Client->SentHeader = FALSE;

		URLLen = strlen(Client->Command);

		/* Parse the request header */
		switch(toupper(Client->Command[0])) {
			case 'P': 		/* POST */
			case 'H': { 	/* HEAD */
				if (URLLen > 5) {
					URL = Client->Command + 5;
				} else {
					URL = Client->Command + URLLen;
					URL[0] = '/';
				}
				break;
			}

			case 'G': {		/* GET */
				if (URLLen > 4) {
					URL = Client->Command + 4;
				} else {
					URL = Client->Command + URLLen;
					URL[0] = '/';
				}
				break;
			}

			default: {
				MWSendClient(Client, MSGERRBADREQUEST, MSGERRBADREQUEST_LEN);
				LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_UNHANDLED, LOGGER_EVENT_UNHANDLED_REQUEST, LOG_INFO, 0, __FILE__, Client->Command, XplHostToLittle(Client->cs.sin_addr.s_addr), 0, NULL, 0);
				return(EndClientConnection(Client));
			}
		}

		/* Take off the HTTP/1.x at the end */
		/* Most common case first */

		ptr = strchr(URL, ' ');
		if (ptr) {
			*ptr = '\0';
		}

		Client->URLExtra = "";
		if ((ptr = strchr(URL, '+')) != NULL) {
			Client->URLExtra = ptr + 1;
			*ptr = '\0';
		}

		MWDebug("Client requested:%s\n", URL);

		switch(URL[1]) {
			case 'a': {	/* Public access */
				if (!PublicTemplate) {
					Send404();
					break;
				}

				if (DecodeURL(URL + 3, &URLData)) {
					HandlePublicURL(Client, &URLData);
				} else if (URL[2] == '?' || URL[2] == '\0') {
					SessionStruct *Session;
					Session = MemMalloc(sizeof(SessionStruct));
					memset(Session, 0, sizeof(SessionStruct));

					/* note: Needs to change if NMAP ever starts using SSL */
					Session->Read = SessionFuncTbl->read;
					Session->Write = SessionFuncTbl->write;


					switch (Client->DeviceType) {
						case DEVICE_HTML: 
						default: {
							MWEncodeURL(Session, Buffer, URL_TYPE_PUBLIC, DISPLAY_TEMPLATE, PublicTemplate->InitialTemplate, 0, 0, 0);
							break;
						}

						case DEVICE_WML: {
							MWEncodeURL(Session, Buffer, URL_TYPE_PUBLIC, DISPLAY_TEMPLATE, PublicTemplate->InitialWMLTemplate, 0, 0, 0);
							break;
						}
					}
					MemFree(Session);
					MWRedirectClient(Client, Buffer);
				} else {
					Send404();
				}

				break;
			}

			case 'j': {	/* Regular template request */
				if (DecodeURL(URL + 3, &URLData)) {
					if ((Client->Session = RetrieveSession(URLData.SessionID, URLData.SessionUID)) != NULL) {
						if (AuthHosts == 0) {
							unsigned long		i = 0;

							/* Check access security */
							/* FIXME: This logic only requires browsers to have the cookie.	If support is added		*/
							/* for another device that can have clickable links, this logic must be changed. */

							while (i < 10) {
								if ((Client->SessionUID[i] == URLData.SessionUID) || (Client->DeviceType != DEVICE_HTML)) {
									MWDebug("User %s, Session %x Request:%d Arg1:%d Arg2:%d Arg3:%d\n", 
											  Client->Session->User, (unsigned int)Client->Session, (int)URLData.Request, 
											  (int)URLData.Argument[0], (int)URLData.Argument[1], (int)URLData.Argument[2]);
									HandleURL(Client, Client->Session, &URLData);

									break;
								} else {
									i++;
								}						
							}

							if (i >= 10) {
								MWDebug("Illegal access %x\n", (unsigned int)Client->Session);
								SendTimeoutPage(Client, &URLData);
							}
						} else  {
							if ((Client->TrustCredentials) && (((Client->Session->RealUser == NULL) && MWQuickCmp(Client->Credentials, Client->Session->User)) || ((Client->Session->RealUser != NULL) && MWQuickCmp(Client->Credentials, Client->Session->RealUser)))) {
								HandleURL(Client, Client->Session, &URLData);
							} else {
								SendTimeoutPage(Client, &URLData);
							}
						}
					} else {
					    HandleURL(Client, NULL, &URLData);
					}
				} else {
					MWDebug("Bobus URL \"%s\"\r\n", URL);
					Send404();
				}
				
				break;
			}

            case 'w': {	/* Regular template request */
				if (DecodeURL(URL + 3, &URLData)) {
					if ((Client->Session = RetrieveSession(URLData.SessionID, URLData.SessionUID)) != NULL) {
						if (AuthHosts == 0) {
							unsigned long		i = 0;

							/* Check access security */
							/* FIXME: This logic only requires browsers to have the cookie.	If support is added		*/
							/* for another device that can have clickable links, this logic must be changed. */

							while (i < 10) {
								if ((Client->SessionUID[i] == URLData.SessionUID) || (Client->DeviceType != DEVICE_HTML)) {
									MWDebug("User %s, Session %x Request:%d Arg1:%d Arg2:%d Arg3:%d\n", 
											  Client->Session->User, (unsigned int)Client->Session, (int)URLData.Request, 
											  (int)URLData.Argument[0], (int)URLData.Argument[1], (int)URLData.Argument[2]);
									HandleURL(Client, Client->Session, &URLData);

									break;
								} else {
									i++;
								}						
							}

							if (i >= 10) {
								MWDebug("Illegal access %x\n", (unsigned int)Client->Session);
								SendTimeoutPage(Client, &URLData);
							}
						} else  {
							if ((Client->TrustCredentials) && (((Client->Session->RealUser == NULL) && MWQuickCmp(Client->Credentials, Client->Session->User)) || ((Client->Session->RealUser != NULL) && MWQuickCmp(Client->Credentials, Client->Session->RealUser)))) {
								HandleURL(Client, Client->Session, &URLData);
							} else {
								SendTimeoutPage(Client, &URLData);
							}
						}
					} else {
						MWDebug("Bogus URL or invalid/expired session %x\n", (unsigned int)Client->Session);
						if (URLData.ReloginOK) {
							Client->URL = URL;
							SendReloginPage(Client, &URLData);
						} else {
							SendTimeoutPage(Client, &URLData);
						}
					}
				} else {
					MWDebug("Bobus URL \"%s\"\r\n", URL);
					Send404();
				}
				
				break;
			}

			case 't': {	/* URL Relogin request */
				Send404();
				break;
			}

			case 'p': {	/* Image request */
				if (DecodeURL(URL + 3, &URLData)) {
					HandleURL(Client, NULL, &URLData);
				} else {
					Send404();
				}
				break;
			}

			case 'r': {	/* Redirect request */
				if (DecodeURL(URL + 3, &URLData)) {
					MWRedirectClient(Client, Client->URLExtra);
				} else {
					Send404();
				}
				break;
			}

			case 'i': {
				if (!MWQuickNCmp(URL + 1, "index", 4)) {
					Send404();
					break;
				}
			}

			/* Fall through */

			case '\0': {	/* Index request */
				MWDebug("Login request, homepage\n");
				if (!PublicTemplate) {
					snprintf(Answer, sizeof(Answer), "/%d/l", (int)time(NULL));
					MWRedirectClient(Client, Answer);
				} else {
					snprintf(Answer, sizeof(Answer), "/%c", URL_TYPE_PUBLIC);
					MWRedirectClient(Client, Answer);
				}
				break;
			}

			case 'u':
			case 'f': {	/* Form-based login; also start of group for regular login */
				BOOL				Login;
				BOOL				Disabled;
				unsigned char	FieldName[128] = "\0";
				unsigned char	Username[256] = "\0";
				unsigned char	Password[256] = "\0";
				unsigned char	Template[256] = "\0";
				unsigned char	Page[256] = "\0";
				unsigned long	ValueSize;

				if (URL[1] != 'u') {
					if (URL[2] == '?') {	/* GET method */
						ptr = URL + 3;

						while (ptr && (ptr = GetURLFormName(ptr, FieldName, sizeof(FieldName))) != NULL) {
							ValueSize = BUFSIZE;
							ptr = GetURLFormValue(ptr, Client->Temp, &ValueSize);

						        XplConsolePrintf("\rGot fieldname \"");
						        XplConsolePrintf(FieldName);
						        XplConsolePrintf("\"\n\r");

							if (ValueSize > 0) {
								if (toupper(FieldName[0]) == 'U') {
								    HulaStrNCpy(Username, Client->Temp, sizeof(Username));
								} else if (toupper(FieldName[0]) == 'P') {
									if (MWQuickNCmp(FieldName, "Pass", 4)) {
									    HulaStrNCpy(Password, Client->Temp, sizeof(Password));
									} else if (MWQuickNCmp(FieldName, "Page", 4)) {
									    HulaStrNCpy(Page, Client->Temp, sizeof(Page));
									}
								} else if (toupper(FieldName[0]) == 'I') {	/* Interface */
								    HulaStrNCpy(Template, Client->Temp, sizeof(Template));
								}
							}
						}
					} else if (URL[2] == '\0') {
						while (MWGetFormName(Client, FieldName, sizeof(FieldName))) {
							ValueSize=BUFSIZE;
							MWGetFormValue(Client, Client->Temp, &ValueSize);

							if (ValueSize > 0) {
								if (toupper(FieldName[0]) == 'U') {
								    HulaStrNCpy(Username, Client->Temp, sizeof(Username));
								} else if (toupper(FieldName[0]) == 'P') {
									if (MWQuickNCmp(FieldName, "Pass", 4)) {
									    HulaStrNCpy(Password, Client->Temp, sizeof(Password));
									} else if (MWQuickNCmp(FieldName, "Page", 4)) {
									    HulaStrNCpy(Page, Client->Temp, sizeof(Page));
									}
								} else if (toupper(FieldName[0]) == 'I') {	/* Interface */
								    HulaStrNCpy(Template, Client->Temp, sizeof(Template));
								}
							}
						}
					} else {
						Send404();
						break;
					}
#if defined(URL_LOGIN)
				} else {
					unsigned char *colonPtr;
					
					if ((URL[2] == ':') && (colonPtr = strchr(URL + 3, ':') ) ) {
						unsigned long len;

						len = colonPtr - URL - 3;
						if (len < sizeof(Username)) {
							memcpy(Username, URL + 3, len);
							Username[len] = '\0';

							len = strlen(colonPtr + 1);
							if (len < sizeof(Password)) {
								memcpy(Password, colonPtr + 1, len);
								Password[len] = '\0';
							}
						}
					}
#endif				

				}

				if (Username[0]!='\0' && Password[0]!='\0') {

					if (AuthHosts == 0) {
						snprintf(Client->Credentials, sizeof(Client->Credentials), "%s:%s", Username, Password);
					}
				}
				/* Fall through */

			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case '0': 	/* Login redirection */

				Login=FALSE;
				Disabled=FALSE;

				MWDebug("Login request; credentials:%s\n", Client->Credentials);
				/* 
					We expect login credentials, if they're not provided or 
					don't work send the guy back to the 404 page 
				*/
				if (Client->Credentials[0] != '\0') {
					if (AuthHosts == 0) {
						ptr = strchr(Client->Credentials, ':');
						if (ptr) {
						    *ptr = '\0';
						    Login = CreateSession(Client, Client->Credentials, ptr + 1, &Disabled);
						}
					} else if (Client->TrustCredentials) {
						Login = CreateSession(Client, Client->Credentials, NULL, &Disabled);
					}

				}

				if (Disabled) {
					MWDebug("Login: FEATURE_MODWEB disabled\n");
					Client->KeepAlive=FALSE;
					MWSendClient(Client, "HTTP/1.1 200 Ok\r\nPragma: no-cache\r\nContent-type: text/html\r\nConnection: close\r\n", 89);
					MWSendClient(Client, "Content-type: text/html\r\n\r\n<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\">", 94);
					MWSendClient(Client, "<H1>ModWeb feature disabled</H1>", 33);
				} else if (!Login) {
					if (isdigit(URL[1])) {
						MWDebug("Login: No or wrong credentials; sending 401 error\n");
						Client->KeepAlive=FALSE;
						switch (Client->DeviceType) {

							case DEVICE_HTML:
							default: {
								MWSendClient(Client, "HTTP/1.1 401 Unauthorized\r\nPragma: no-cache\r\nContent-type: text/html\r\nConnection: close\r\n", 89);
								MWSendClient(Client, "WWW-Authenticate: Basic realm=\"", 31);
								MWSendClient(Client, "Hula Mail Service", 18);
								MWSendClient(Client, "\"\r\nContent-type: text/html\r\n\r\n<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=utf-8\">", 97);
								MWSendClient(Client, "<H1>Authentication required</H1>", 32);
								break;
							}

							case DEVICE_WML: {
								MWSendClient(Client, "HTTP/1.1 401 Unauthorized\r\nPragma: no-cache\r\nContent-type: text/vnd.wap.wml\r\nConnection: close\r\n", 96);
								MWSendClient(Client, "WWW-Authenticate: Basic realm=\"", 31);
								MWSendClient(Client, "Hula Mail Service", 18);
								MWSendClient(Client, "\"\r\n\r\n<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\"><wml><head><meta http-equiv=\"Cache-Control\" content=\"max-age=0\"/></head><card title=\"Login Page\"></card></wml>", 247);
								break;
							}
						}
					} else {
						MWRedirectClient(Client, FormLoginRedirectURL);
					}
				} else if (Login) {
					if (!Client->TSession) {
						/* Is he asking for a template other than his default? */
						if (Template[0] != '\0') {
						    long result;
							result = MWFindTemplate(Template);
							if (result != -1) {
								MWSetSessionTemplate((unsigned long)result, Client->Session->Language, Client->Session);
							}
						}

						/* let's build a URL and redirect the guy to the template's default page */
						switch (Client->DeviceType) {
							case DEVICE_HTML: 
							default:{
								signed long			pageID = -1;

								if (Page[0] != '\0') {
									/* Is he asking for a page other than the default? */

									pageID = MWFindTemplatePage(Page, Client->Session->TemplateID);
								}

								if (pageID == -1) {
									pageID = Templates[Client->Session->TemplateID]->InitialTemplate;
								}

								MWEncodeURL(Client->Session, Buffer, URL_TYPE_LINK, DISPLAY_TEMPLATE, pageID, 0, 0, 0);
								break;
							}

							case DEVICE_WML: {
								MWEncodeURL(Client->Session, Buffer, URL_TYPE_LINK, DISPLAY_TEMPLATE, Templates[Client->Session->TemplateID]->InitialWMLTemplate, 0, 0, 0);
								break;
							}
						}
						RedirectAfterLogin(Client, Buffer);
					} else {
						snprintf(Client->Temp, sizeof (Client->Temp), "%s/T%lu", WorkDir, Client->TSession->SessionID);
						Client->PostData = fopen(Client->Temp, "rb");

						/* Original content length */
						fgets(Client->Temp, BUFSIZE, Client->PostData);
						Client->ContentLength = atol(Client->Temp);

						/* Separator */
						fgets(Client->Temp, BUFSIZE, Client->PostData);
						ChopNL(Client->Temp);
						if (Client->Temp[0] != '\0') {
							Client->FormSeparator = MemStrdup(Client->Temp + 1);
						}

						if (Client->Temp[0] == 'f') {
							Client->EncodingType = FORM_DATA_ENCODED;
						} else {
							Client->EncodingType = FORM_URL_ENCODED;
						}

						/* Original request URL */
						fgets(Client->Temp, BUFSIZE, Client->PostData);
						ChopNL(Client->Temp);

						if (!DecodeURL(Client->Temp + 3, &URLData)) {
							switch (Client->DeviceType) {
								case DEVICE_HTML: 
								default: {
									MWEncodeURL(Client->Session, Buffer, URL_TYPE_LINK, DISPLAY_TEMPLATE, Templates[Client->Session->TemplateID]->InitialTemplate, 0, 0, 0);
									break;
								}

								case DEVICE_WML: {
									MWEncodeURL(Client->Session, Buffer, URL_TYPE_LINK, DISPLAY_TEMPLATE, Templates[Client->Session->TemplateID]->InitialWMLTemplate, 0, 0, 0);
									break;
								}
							}

							RedirectAfterLogin(Client, Buffer);
						} else {
//							Client->Session->SessionID=URLData.SessionID;
//							Client->Session->SessionUID=URLData.SessionUID;

							Client->Cookie = Client->Session->SessionUID;
							HandleURL(Client, Client->Session, &URLData);
						}
					}
				}
				break;
			}
		case 's' :
		case 'S' : {
		    char *owner;
		    char *calendar;
		    char *uid;
		    char *sequenceptr;
		    unsigned long sequenceNum;
		    char *method;
		    char *ptr;
		    char *attendee;
		    BOOL login = FALSE;
		    BOOL disabled = FALSE;
		    int ccode;
		    
		    Client->KeepAlive = FALSE;
		    
		    if (XplStrNCaseCmp(URL + 1, "Status/", 7) != 0) {
			goto statusCleanup;
		    }

		    owner = URL + 8;
		    calendar = strchr(owner, '/');
		    if (!calendar) {
			goto statusCleanup;
		    }
		    *calendar++ = '\0';
		    
		    uid = strchr(calendar, '/');
		    if (!uid) {
			goto statusCleanup;
		    }
		    *uid++ = '\0';
		    
		    sequenceptr = strchr(uid, '/');
		    if (!sequenceptr) {
			goto statusCleanup;
		    }
		    *sequenceptr++ = '\0';
		    sequenceNum = atol(sequenceptr);
		    
		    method = strchr(sequenceptr, '/');
		    if (!method) {
			goto statusCleanup;
		    }
		    *method++ = '\0';
		    
		    ptr = strchr(method, '?');
		    if (!ptr) {
			goto statusCleanup;
		    }
		    *ptr++ = '\0';

		    attendee = strchr(ptr, '=');
		    if (!attendee) {
			goto statusCleanup;
		    }
		    *attendee++ = '\0';
		    
		    if (XplStrCaseCmp(ptr, "email")) {
			goto statusCleanup;
		    }
		    
                    if ((login = CreateSession(Client, owner, NULL, &disabled)) == TRUE
			&& !disabled) {
			long template;
			long page;
			int state;
			char *pagename;

			if (!XplStrCaseCmp(method, "accept")) {
			    state = ICAL_PARTSTAT_ACCEPTED;
			    pagename = "appaccept";
			} else if (!XplStrCaseCmp(method, "decline")) {
			    state = ICAL_PARTSTAT_DECLINED;			    
			    pagename = "appdecline";
			} else if (!XplStrCaseCmp(method, "tentative")) {
			    state = ICAL_PARTSTAT_TENTATIVE;			    
			    pagename = "appaccept";
			} else {
			    goto statusCleanup;
			}
			ccode = MWSetAttendeeStatus(Client->Session, attendee, state, calendar, uid, sequenceNum);
			if (ccode == 1000) {
			    template = 0;
			    do {
				page = MWFindTemplatePage(pagename, template);
				if (page != -1) {
				    MWHandleTemplate(Client, Client->Session, (unsigned long)page);
				    break;
				}
				template++;
				if (template < TemplateCount) {
				    continue;
				}
				
				/* we could not find this page in any of the templates; do what we can */
				SendMessagePage(Client, "RSVP acknowledged!\r\n", strlen("RSVP acknowledged!\r\n"));
				break;
			    } while (TRUE);
			} else {
			    LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_UNHANDLED, LOGGER_EVENT_UNHANDLED_REQUEST, LOG_INFO, 0, __FILE__, URL, XplHostToLittle(Client->cs.sin_addr.s_addr), 0, NULL, 0);
			    SendMessagePage(Client, "Event not found.\r\n", strlen("Event not found.\r\n"));
			}
		    }
		    
		statusCleanup:
		    if (login) {
                        MWDestroySession(Client->Session);
			Client->Session = NULL;
                    }
		    
		    break;
		}
            case 'c':
            case 'C': {
                unsigned long used;
                unsigned char *owner;
                unsigned char *suffix;
                unsigned char *calendar;
				BOOL login = FALSE;
				BOOL disabled = FALSE;
                MDBValueStruct *vs;

                Client->KeepAlive = FALSE;

                if (((vs = MDBCreateValueStruct(ModWebDirectoryHandle, NULL)) != NULL) 
                        && (XplStrNCaseCmp(URL + 1, "Calendar/", 9) == 0) 
                        && ((suffix = strrchr(URL + 10, '.')) != NULL)
                        && (XplStrCaseCmp(suffix, ".ics") == 0)
                        && (suffix > (URL + 10))) {
                    *suffix = '\0';

                    calendar = strchr(URL + 10, '/');
                    if (calendar) {
                        *calendar++ = '\0';
                    } else {
                        calendar = "MAIN";
                    }

                    if (((login = CreateSession(Client, URL + 10, NULL, &disabled)) == TRUE) 
                            && !disabled) {
                        MDBRead(MSGSRV_ROOT, MSGSRV_A_AVAILABLE_SHARES, vs);

                        disabled = TRUE;
                        for (used = 0; used < vs->Used; used++) {
                            if ((vs->Value[used][0] != 'C') || (vs->Value[used][1] != 'A')) {
                                continue;
                            }

                            /* CA<CalendarName>CR<Owner>CR<ShareName> */
                            ptr = strchr(vs->Value[used] + 2, '\r');
                            if (ptr) {
                                *ptr++ = '\0';

                                owner = ptr;
                                ptr = strchr(ptr, '\r');
                            }

                            if (ptr) {
                                *ptr++ = '\0';

                                if ((XplStrCaseCmp(calendar, vs->Value[used] + 2) == 0) 
                                        && (XplStrCaseCmp(owner, URL + 10) == 0)) {
                                    disabled = FALSE;
                                }
                            }
                        }

                        if (!disabled) {
		                    MWSendNMAPServer(Client->Session, Answer, snprintf(Answer, sizeof(Answer), "CSOPEN %s\r\n", calendar));
		                    ReplyInt = MWGetNMAPAnswer(Client->Session, Answer, sizeof(Answer), TRUE);
                            if ((ReplyInt == 1000) || (ReplyInt == 1020)) {
                                MWSendIcs(Client, Client->Session);
                            }

                            MDBDestroyValueStruct(vs);

                            MWDestroySession(Client->Session);
                            break;
                        }
                    }

                    if (login) {
                        MWDestroySession(Client->Session);
                    }
                }

                if (vs) {
                    MDBDestroyValueStruct(vs);
                }

                /* Fall through */
            }

			default: {
				LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_UNHANDLED, LOGGER_EVENT_UNHANDLED_REQUEST, LOG_INFO, 0, __FILE__, URL, XplHostToLittle(Client->cs.sin_addr.s_addr), 0, NULL, 0);

				Send404();

				break;
			}
		}
		
		MWFlushClient(Client);

		if (!Client->KeepAlive) {
			MWDebug("End of command loop and thread (Session:%x)\n", (unsigned int)Client->Session);
			return(EndClientConnection(Client));
		} else {
			ReleaseSession(Client->Session);
		}
		MWDebug("End of command loop (Session:%x)\n", (unsigned int)Client->Session);
	}
	return(TRUE);
}
#if defined(NETWARE) || defined(LIBC) || defined(WIN32)
int _NonAppCheckUnload(void)
{
	int			s;
	static BOOL	checked = FALSE;
	XplThreadID	oldTGID;

	oldTGID = XplSetThreadGroupID(TGid);	

	if (!checked) {
		checked = Exiting = TRUE;

		XplWaitOnLocalSemaphore(ModWebShutdownSemaphore);

		if (ModWebServerSocket != -1) {
			s = ModWebServerSocket;
			ModWebServerSocket = -1;

			IPclose(s);
		}

		XplWaitOnLocalSemaphore(ModWebServerSemaphore);
	}

	XplSetThreadGroupID(oldTGID);	

	return(0);
}
#endif

static void
ModWebShutdownSigHandler(int sigtype)
{
	int			s;
	static BOOL	signaled = FALSE;
	XplThreadID	oldTGID;

	oldTGID = XplSetThreadGroupID(TGid);	

	if (!signaled && ((sigtype == SIGTERM) || (sigtype == SIGINT))) {
		signaled = Exiting = TRUE;

		if (ModWebServerSocket != -1) {
			s = ModWebServerSocket;
			ModWebServerSocket = -1;

			IPclose(s);
		}

		XplSignalLocalSemaphore(ModWebShutdownSemaphore);

		/*	Allow the main thread to close the final semaphores and exit.	*/
		XplDelay(1000);
	}

	XplSetThreadGroupID(oldTGID);	

	return;
}

static int
ServerSocketInit(void)
{
    int ccode;
    struct sockaddr_in	server_sockaddr;
    
    ModWebServerSocket = IPsocket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (ModWebServerSocket < 0) {
	XplConsolePrintf("hulamodweb: Could not allocate server socket\n");
	return ModWebServerSocket;
    }    
    ccode = 1;
    setsockopt(ModWebServerSocket, SOL_SOCKET, SO_REUSEADDR, (char *)&ccode, sizeof(ccode));
    
    memset(&server_sockaddr, 0, sizeof(struct sockaddr));
    
    server_sockaddr.sin_family = AF_INET;
    server_sockaddr.sin_port = htons((unsigned short)MODWEB_PORT);
    server_sockaddr.sin_addr.s_addr = MsgGetAgentBindIPAddress();
    
    /* Get root privs back for the bind.  It's ok if this fails - 
     * the user might not need to be root to bind to the port */
    XplSetEffectiveUserId(0);

    ccode = IPbind(ModWebServerSocket, (struct sockaddr *)&server_sockaddr, sizeof(server_sockaddr));

    if (XplSetEffectiveUser(MsgGetUnpriviledgedUser()) < 0) {
	XplConsolePrintf("hulamodweb: Could not drop to unpriviledged user '%s'\n", MsgGetUnpriviledgedUser());
	return -1;
    }

    if (ccode < 0) {
	XplConsolePrintf("hulamodweb: Could not bind to port %d\n", MODWEB_PORT);

	IPclose(ModWebServerSocket);
	return ccode;
    }
    
    return 0;
}	

static int
ServerSocketSSLInit(void)
{
    int ccode;
    struct sockaddr_in	server_sockaddr;
    
    ModWebServerSocketSSL = IPsocket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (ModWebServerSocketSSL < 0) {
	XplConsolePrintf("hulamodweb: Could not allocate SSL server socket\n");
	return ModWebServerSocketSSL;
    }    
	
    ccode = 1;
    setsockopt(ModWebServerSocketSSL, SOL_SOCKET, SO_REUSEADDR, (char *)&ccode, sizeof(ccode));
    
    memset(&server_sockaddr, 0, sizeof(struct sockaddr));
    
    server_sockaddr.sin_family = AF_INET;
    server_sockaddr.sin_port = htons((unsigned short)MODWEB_PORT_SSL);
    server_sockaddr.sin_addr.s_addr = MsgGetAgentBindIPAddress();
    

    /* Get root privs back for the bind.  It's ok if this fails - 
     * the user might not need to be root to bind to the port */
    XplSetEffectiveUserId(0);

    ccode = IPbind(ModWebServerSocketSSL, (struct sockaddr *)&server_sockaddr, sizeof(server_sockaddr));

    if (XplSetEffectiveUser(MsgGetUnpriviledgedUser()) < 0) {
	XplConsolePrintf("hulamodweb: Could not drop to unpriviledged user '%s'\n", MsgGetUnpriviledgedUser());
	return -1;
    }

    if (ccode < 0) {
	XplConsolePrintf("hulamodweb: Could not bind to SSL port %d\n", MODWEB_PORT_SSL);

	IPclose(ModWebServerSocket);
	return ccode;
    }
    
    return 0;
}


static void
ModWebServer(void *ignored)
{
	int						ccode;
	int						arg;
	int						oldTGID;
	IPSOCKET					ds;
	struct sockaddr_in	client_sockaddr;
	ConnectionStruct		*client;
	XplThreadID				id = 0;

	XplSafeIncrement(ModWebServerThreads);

	XplRenameThread(XplGetThreadID(), "ModWeb Server");

	ccode = IPlisten(ModWebServerSocket, 2048);
	if (ccode != -1) {
	    while (!Exiting) {
		arg = sizeof(client_sockaddr);
		ds = IPaccept(ModWebServerSocket, (struct sockaddr *)&client_sockaddr, &arg);

		if (!Exiting) {
		    if (ds != -1) {
			if (!ModWebReceiverStopped) {
			    if ((unsigned long)XplSafeRead(ModWebConnThreads) < ModWebMaxThreadLoad) {
				client = GetModWebConnection();
				if (client) {
				    client->s = ds;
				    client->cs = client_sockaddr;
				    client->Read = ConnectionFuncTbl->read;
				    client->Write = ConnectionFuncTbl->write;
				    client->ClientSSL = 0;
				    client->sktCtx = (void *)ds;
				    client->TrustCredentials = FALSE;

				    /*	Set TCP non blocking I/O	*/
				    ccode = 1;
				    setsockopt(ds, IPPROTO_TCP, 1, (char *)&ccode, sizeof(ccode));

				    XplBeginCountedThread(&id, HandleConnection, MODWEB_STACK_SPACE, (void *)client, ccode, ModWebConnThreads);
				    if (ccode == 0) {
					continue;
				    }

				    ReturnModWebConnection(client);
				}

				IPsend(ds, MSGERRNOMEMORY, MSGERRNOMEMORY_LEN, 0);
			    } else {
				IPsend(ds, MSGERRNOCONNECTIONS, MSGERRNOCONNECTIONS_LEN, 0);
			    }
			} else {
			    IPsend(ds, MSGERRRECEIVERDOWN, MSGERRRECEIVERDOWN_LEN, 0);
			}

			IPclose(ds);
			continue;
		    }

		    switch (errno) {
		    case ECONNABORTED:
#ifdef EPROTO
		    case EPROTO:
#endif
		    case EINTR: {
			LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_GENERAL, LOGGER_EVENT_ACCEPT_FAILURE, LOG_ERROR, 0, "Server", NULL, errno, 0, NULL, 0);
			continue;
		    }

		    case EIO: {
			LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_GENERAL, LOGGER_EVENT_ACCEPT_FAILURE, LOG_ERROR, 0, NULL, NULL, errno, 2, NULL, 0);

			Exiting = TRUE;
			
			LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_GENERAL, LOGGER_EVENT_ACCEPT_FAILURE, LOG_ALERT, 0, NULL, NULL, errno, 3, NULL, 0);
			

			break;
		    }

		    default: {
			arg = errno;

			LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_GENERAL, LOGGER_EVENT_ACCEPT_FAILURE, LOG_ALERT, 0, "Server", NULL, arg, 0, NULL, 0);
			XplConsolePrintf("MODWEBD: Server exiting after an accept() failure with an errno: %d\n", arg);

			break;
		    }
		    }

		    break;
		}

		/*	Shutdown signaled	*/
		break;

	    }
	}

	/*	Shutting down.	*/
	Exiting = TRUE;

	oldTGID = XplSetThreadGroupID(TGid);	

	XplConsolePrintf("\rMODWEBD: Preparing to unload; please be patient, this may take a minute.\r\n");

	if (ModWebServerSocket != -1) {
		IPclose(ModWebServerSocket);
		ModWebServerSocket = -1;
	}

	if(ModWebServerSocketSSL != -1) {
		IPclose(ModWebServerSocketSSL);
		ModWebServerSocketSSL = -1;
	}

	/*	Management Client Shutdown	*/
	if (ManagementState() == MANAGEMENT_RUNNING) {
        ManagementShutdown();
	}

	for (arg = 0; (ManagementState() != MANAGEMENT_STOPPED) && (arg < 60); arg++) {
		XplDelay(1000);
	}

	/*	Wake up the children and set them free!	*/
	/* fixme - SocketShutdown; */

	/*	Wait for the our siblings to leave quietly.	*/
	for (arg = 0; (XplSafeRead(ModWebServerThreads) > 1) && (arg < 60); arg++) {
		XplDelay(1000);
	}

	if (XplSafeRead(ModWebServerThreads) > 1) {
		XplConsolePrintf("MODWEBD: %d server threads outstanding; attempting forceful unload.\r\n", XplSafeRead(ModWebServerThreads) - 1);
	}

	XplConsolePrintf("MODWEBD: Shutting down %d client threads\r\n", XplSafeRead(ModWebConnThreads));

	/*	Make sure the kids have flown the coop.	*/
	for (arg = 0; XplSafeRead(ModWebConnThreads) && (arg < 3 * 60); arg++) {
		XplDelay(1000);
	}

	if (XplSafeRead(ModWebConnThreads)) {
		XplConsolePrintf("MODWEBD: %d threads outstanding; attempting forceful unload.\r\n", XplSafeRead(ModWebConnThreads));
	}

	DestroyAllSessions();

	if (AuthHosts > 0) {
		MemFree(AuthAddress);
	}

	FreeModules();

	FreeTemplates();

	SessionDBShutdown();

	if (DefaultTitle) {
		MemFree(DefaultTitle);
	}

	if (NMAPTraceUser) {
		MemFree(NMAPTraceUser);
	}

	XplCloseLocalSemaphore(TraceSemaphore);
	XplCloseLocalSemaphore(TSessionDBSemaphore);
	XplCloseLocalSemaphore(SessionDBSemaphore);
	XplCloseLocalSemaphore(CacheSemaphore);

	if (LogHandle) {
		LoggerClose(LogHandle);
		LogHandle = NULL;
	}

	/* Cleanup SSL */
	if (SSLContext) {
		SSL_CTX_free(SSLContext);
	}
	ERR_free_strings();
	ERR_remove_state(0);
	EVP_cleanup();
	XPLCryptoLockDestroy();

	MemPrivatePoolFree(ModWebConnectionPool);

	XplRWLockDestroy(&ConfigLock);
	MsgShutdown();
//	MDBShutdown();
	ConnShutdown();

	MemoryManagerClose(MSGSRV_AGENT_MODWEB);

	XplConsolePrintf("MODWEBD: Shutdown complete\r\n");

	XplSignalLocalSemaphore(ModWebServerSemaphore);
	XplWaitOnLocalSemaphore(ModWebShutdownSemaphore);

	XplCloseLocalSemaphore(ModWebShutdownSemaphore);
	XplCloseLocalSemaphore(ModWebServerSemaphore);

	XplSetThreadGroupID(oldTGID);

	return;
}

static void
ModWebSSLServer(void *ignored)
{
	int						ccode;
	int						arg;
	unsigned char			*message = NULL;
	IPSOCKET					ds;
	struct sockaddr_in	client_sockaddr;
	ConnectionStruct		*client;
	SSL						*cSSL = NULL;
	XplThreadID				id = 0;
    
	XplRenameThread(XplGetThreadID(), "ModWeb SSL Server");

	ccode = IPlisten(ModWebServerSocketSSL, 2048);
	if (ccode != -1) {
	    while (!Exiting) {
		arg = sizeof(client_sockaddr);
		ds = IPaccept(ModWebServerSocketSSL, (struct sockaddr *)&client_sockaddr, &arg);
		if (!Exiting) {
		    if (ds != -1) {
			if (!ModWebReceiverStopped) {
			    if ((unsigned long)XplSafeRead(ModWebConnThreads) < ModWebMaxThreadLoad) {
				client = GetModWebConnection();
				if (client) {
				    client->s = ds;
				    client->cs = client_sockaddr;
										
				    client->CSSL = SSL_new(SSLContext);
				    client->sktCtx = (void*)client->CSSL;
				    if (client->CSSL) {
					ccode = SSL_set_bsdfd(client->CSSL, client->s);
					if (ccode == 1) {
					    client->Read = ConnectionFuncTbl->readSSL;
					    client->Write = ConnectionFuncTbl->writeSSL;
					    client->ClientSSL = 1;
					    client->TrustCredentials = FALSE;

					    /*	Set TCP non blocking I/O	*/
					    ccode = 1;
					    setsockopt(ds, IPPROTO_TCP, 1, (unsigned char *)&ccode, sizeof(ccode));

					    XplBeginCountedThread(&id, HandleConnection, MODWEB_STACK_SPACE, (void *)client, ccode, ModWebConnThreads);
					    if (ccode == 0) {
						continue;
					    }
					    if (SSL_accept(client->CSSL) == 1) {
						XplIPWriteSSL(client->CSSL, MSGERRNOMEMORY, MSGERRNOMEMORY_LEN);
					    }
					} 

					SSL_free(client->CSSL);
					client->CSSL = NULL;
				    }
				    /* If we get here, we have already sent an error or SSL is not functional and we won't be able to */
				    ReturnModWebConnection(client);
				    IPclose(ds);
				    continue;
				}
				message = MSGERRNOMEMORY;
				arg = MSGERRNOMEMORY_LEN;
			    } else {
				message = MSGERRNOCONNECTIONS;
				arg = MSGERRNOCONNECTIONS_LEN;
			    }
			} else {
			    message = MSGERRRECEIVERDOWN;
			    arg = MSGERRRECEIVERDOWN_LEN;
			}

			cSSL = SSL_new(SSLContext);
			if (cSSL) {
			    ccode = SSL_set_bsdfd(cSSL, ds);
			    if (ccode == 1) {
				if (SSL_accept(cSSL) == 1) {
				    XplIPWriteSSL(cSSL, message, arg);
				}
			    }
			    SSL_free(cSSL);
			    cSSL = NULL;
			}
			IPclose(ds);
			continue;
		    }

		    switch (errno) {
		    case ECONNABORTED:
#ifdef EPROTO
		    case EPROTO:
#endif
		    case EINTR: {
			LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_GENERAL, LOGGER_EVENT_ACCEPT_FAILURE, LOG_ERROR, 0, "SSL Server", NULL, errno, 1, NULL, 0);
			continue;
		    }

		    case EIO: {
			Exiting = TRUE;

			LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_GENERAL, LOGGER_EVENT_ACCEPT_FAILURE, LOG_ERROR, 0, "SSL Server", NULL, errno, 3, NULL, 0);

			break;
		    }

		    default: {
			XplConsolePrintf("MODWEBD: SSL Server exiting after an accept() failure with an errno: %d\n", errno);
			LoggerEvent(LogHandle, LOGGER_SUBSYSTEM_GENERAL, LOGGER_EVENT_ACCEPT_FAILURE, LOG_ALERT, 0, "SSL Server", NULL, errno, 1, NULL, 0);

			break;
		    }
		    }

		    break;
		}

		/*	Shutdown signaled	*/
		break;
	    }
	}

	XplConsolePrintf("\rMODWEBD: SSL Server thread done.\r\n");

	XplSafeDecrement(ModWebServerThreads);

	if (!Exiting) {
		raise(SIGTERM);
	}

	return;
}

static BOOL
ParseAuthAddresses(unsigned char *Addresses)
{
	unsigned char	*ptr;
	unsigned char	*ipAddress;
	void				*tmp;

	ipAddress = ptr = Addresses;
	

	while (*ptr != '\0') {
		if (*ptr != ',') {
			ptr++;
			continue;
		} else {
			*ptr = '\0';
			tmp = realloc(AuthAddress, (AuthHosts + 1) * sizeof(unsigned long));
			if (tmp) {
			    AuthAddress = (in_addr_t *)tmp;
			    AuthAddress[AuthHosts] = inet_addr(ipAddress);
			    if (AuthAddress[AuthHosts] != INADDR_NONE) {
				AuthHosts++;
			    }
			}
			*ptr = ',';
			ipAddress = ptr + 1;
		}
		ptr++;
	}
	tmp = realloc(AuthAddress, (AuthHosts + 1) * sizeof(unsigned long));
	if (tmp) {
		AuthAddress = (in_addr_t *)tmp;
		AuthAddress[AuthHosts] = inet_addr(ipAddress);
		if (AuthAddress[AuthHosts] != INADDR_NONE) {
			AuthHosts++;
		}
	}
	return(TRUE);
}

static BOOL
ReadConfiguration(void)
{
	MDBValueStruct	*Config;
	unsigned long	i;

	MWDebug("ReadConfiguration() called\n");

	Config = MDBCreateValueStruct(ModWebDirectoryHandle, MsgGetServerDN(NULL));

	if (MDBRead(MSGSRV_SELECTED_CONTEXT, MSGSRV_A_SSL_OPTIONS, Config)) {
		ClientSSLOptions=atoi(Config->Value[0]);
		if (ClientSSLOptions!=0) {
			AllowClientSSL = TRUE;
			UseNMAPSSL = FALSE;
		}
	}
	MDBFreeValues(Config);

	if (MDBRead(MSGSRV_AGENT_MODWEB, MSGSRV_A_PORT, Config) > 0) {
		MODWEB_PORT = atoi(Config->Value[0]);
	} else {
		MODWEB_PORT = 80;
	}
	if (MODWEB_PORT==0) {
		MODWEB_PORT=80;
	}
	MDBFreeValues(Config);

	if (MDBRead(MSGSRV_AGENT_MODWEB, MSGSRV_A_SSL_PORT, Config) > 0) {
		MODWEB_PORT_SSL = atoi(Config->Value[0]);
	} else {
		MODWEB_PORT_SSL = 443;
	}
	if (MODWEB_PORT_SSL==0) {
		MODWEB_PORT_SSL=443;
	}
	MDBFreeValues(Config);
	MWDebug("ReadConfiguration: Port:%d SSL-Port:%d\n", MODWEB_PORT, MODWEB_PORT_SSL);

	if (MDBRead(MSGSRV_AGENT_MODWEB, MSGSRV_A_LANGUAGE, Config) > 0) {
		DefaultLanguage=atoi(Config->Value[0]);
	} else {
		DefaultLanguage=XplGetCurrentOSLanguageID();
	}
	MDBFreeValues(Config);

	/* Official Name */
	if (MDBRead(MSGSRV_SELECTED_CONTEXT, MSGSRV_A_OFFICIAL_NAME, Config)) {
		HulaStrNCpy(OfficialDomain, Config->Value[0], sizeof(OfficialDomain));
	}
	MDBFreeValues(Config);

	DefaultTimezoneOffset=MsgGetUTCOffset();
	if (MDBRead(MSGSRV_AGENT_MODWEB, MSGSRV_A_TIMEZONE, Config)) {
		DefaultTimezoneID=atol(Config->Value[0]);
		DefaultTimezoneOffset=MsgGetUTCOffsetByDate(DefaultTimezoneID, 0, 0, 0, 0);
	}
	MDBFreeValues(Config);
	MWDebug("ReadConfiguration: TimezoneOffset:%d\n", (int)DefaultTimezoneOffset);

	if (MDBRead(MSGSRV_AGENT_MODWEB, MSGSRV_A_CONFIGURATION, Config)) {
		for (i=0; i<Config->Used; i++) {
			if (XplStrNCaseCmp(Config->Value[i], "FormLoginRedirectURL=", 21)==0) {
				HulaStrNCpy(FormLoginRedirectURL, Config->Value[i]+21, sizeof(FormLoginRedirectURL));
				MWDebug("ReadConfiguration: FormLoginRedirectURL:%s\n", FormLoginRedirectURL);
			} else if (XplStrNCaseCmp(Config->Value[i], "FormLogoutRedirectURL=", 22)==0) {
				HulaStrNCpy(FormLogoutRedirectURL, Config->Value[i]+22, sizeof(FormLogoutRedirectURL));
				MWDebug("ReadConfiguration: FormLogoutRedirectURL:%s\n", FormLogoutRedirectURL);
				UseFormLogoutRedirectURL=TRUE;
			} else if (XplStrNCaseCmp(Config->Value[i], "Logo=", 5)==0) {
				DefaultLogoID=atol(Config->Value[i]+5);
				MWDebug("ReadConfiguration: DefaultLogoID:%d\n", (int)DefaultLogoID);
			} else if (XplStrNCaseCmp(Config->Value[i], "MaxLoad:", 8)==0) {
				ModWebMaxThreadLoad=atol(Config->Value[i]+8);
			} else if (XplStrNCaseCmp(Config->Value[i], "AuthIPAddr=", 11)==0) {
				ParseAuthAddresses(Config->Value[i] + 11);
			} else if (XplStrNCaseCmp(Config->Value[i], "AuthIDHeader=", 13)==0) {
				HulaStrNCpy(AuthIDHeader, Config->Value[i] + 13, sizeof(AuthIDHeader));
			} else if (XplStrNCaseCmp(Config->Value[i], "ANERecv=", 8) == 0) {
				MIMEParamEncodingforHTTP = atol(Config->Value[i] + 8);
			} else if (XplStrNCaseCmp(Config->Value[i], "JIT=", 4) == 0) {
				CheckDiskForTemplateUpdates = atol(Config->Value[i] + 4);
			}
		}
	}
	MDBFreeValues(Config);

	/* Validate Auth Proxy Configuration */
	if (AuthHosts > 0) {
		AuthIDHeaderLen = strlen(AuthIDHeader);
		if (AuthIDHeaderLen > 0) {
			unsigned char *colonPtr;

			colonPtr = strchr(AuthIDHeader, ':');
			if (!colonPtr) {
				AuthIDHeader[AuthIDHeaderLen] = ':';
				AuthIDHeader[AuthIDHeaderLen + 1] = '\0';
				AuthIDHeaderLen++;
			}
		} else {
			MemFree(AuthAddress);
			AuthAddress = NULL;
			AuthHosts = 0;
		}
	}

	if (MDBRead(MSGSRV_AGENT_MODWEB, MSGSRV_A_TITLE, Config) > 0) {
		DefaultTitle=MemStrdup(Config->Value[0]);
	} else {
		DefaultTitle=MemStrdup(DEFAULT_TITLE);
	}
	MDBFreeValues(Config);

	MDBSetValueStructContext(NULL, Config);
	if (MDBRead(MSGSRV_ROOT, MSGSRV_A_ACL, Config)>0) { 
		HashCredential(MsgGetServerDN(NULL), Config->Value[0], NMAPHash);
	}
	MDBFreeValues(Config);

	MsgGetNLSDir(NLSDir);

	MsgGetLibDir(TemplateDir);
	strcat(TemplateDir, "/modweb");
	MsgMakePath(TemplateDir);

	MsgGetLibDir(ModuleDir);
	strcat(ModuleDir, "/modweb");
	MsgMakePath(TemplateDir);

	MsgGetLibDir(LogoDir);
	strcat(LogoDir, "/modweb/logo");
	MsgMakePath(LogoDir);

	MsgGetWorkDir(WorkDir);
	strcat(WorkDir, "/modweb");
	MsgMakePath(WorkDir);

	MDBDestroyValueStruct(Config);

	return(TRUE);
}

XplServiceCode(ModWebShutdownSigHandler)

int
XplServiceMain(int argc, char *argv[])
{
	int				ccode;
	XplThreadID		id = 0;	

	if (XplSetEffectiveUser(MsgGetUnpriviledgedUser()) < 0) {
	    XplConsolePrintf("hulamodweb: Could not drop to unpriviledged user '%s', exiting.\n", MsgGetUnpriviledgedUser());
	    return 1;
	}

	TGid = XplGetThreadGroupID();

	XplSignalHandler(ModWebShutdownSigHandler);

	XplSafeWrite(ModWebServerThreads, 0);
	XplSafeWrite(ModWebConnThreads, 0);

	if (MemoryManagerOpen(MSGSRV_AGENT_MODWEB) == TRUE) {
		ModWebConnectionPool = MemPrivatePoolAlloc("ModWeb Connections", sizeof(ConnectionStruct), 0, 3072, TRUE, FALSE, ModWebConnectionAllocCB, NULL, NULL);
		if (ModWebConnectionPool != NULL) {
			;
		} else {
			MemoryManagerClose(MSGSRV_AGENT_MODWEB);

			XplConsolePrintf("MODWEBD: Unable to create connection pool; shutting down.\r\n");
			return(-1);
		}
	} else {
		XplConsolePrintf("MODWEBD: Unable to initialize memory manager; shutting down.\r\n");
		return(-1);
	}

	if (argc>1) {
		int	i;

		for (i=1; i<argc; i++)  {
			if (XplStrCaseCmp(argv[i],"-v")==0) {
				XplConsolePrintf("\r\n\n\n%s [%s]\n",PRODUCT_NAME, PRODUCT_VERSION);
				XplConsolePrintf("\r  Author:      peter dennis bartok [peter@novonyx.com]\n");

				MemPrivatePoolFree(ModWebConnectionPool);
				MemoryManagerClose(MSGSRV_AGENT_MODWEB);

				return(0);
			} else if (XplStrCaseCmp(argv[i], "-f")==0) {
				ForceLoad=TRUE;
				continue;
			} else if ((XplStrCaseCmp(argv[i], "-?")==0) || (XplStrCaseCmp(argv[i], "-h")==0)) {
				XplConsolePrintf("\r\n%s usage:\n", PRODUCT_NAME);
				XplConsolePrintf("\r%s [-f] [-v] [-h | -?]\n", argv[0]);
				XplConsolePrintf("\r-f       - Force loading of all modules in module dir\n");

				MemPrivatePoolFree(ModWebConnectionPool);
				MemoryManagerClose(MSGSRV_AGENT_MODWEB);

				return(0);
			} else if (MWQuickCmp(argv[i], "-jit")) {
				CheckDiskForTemplateUpdates = TRUE;
			} else if (MWQuickCmp(argv[i], "-HTTPTrace")) {
				ConnectionFuncTbl = &ConnectionFuncTblTrace;
			} else if (MWQuickNCmp(argv[i], "-NMAPTrace", 10)) {
				SessionFuncTbl = &SessionFuncTblTrace;

				if (argv[i][10] == ':') {
					/* We need to filter on a user */

					if (!NMAPTraceUser) {
						NMAPTraceUser = MemStrdup(argv[i] + 11);
					}
				}
			}
		}
	}

    ConnStartup(CONNECTION_TIMEOUT, TRUE);

	MDBInit();
	ModWebDirectoryHandle = (MDBHandle)MsgInit();
	if (ModWebDirectoryHandle == NULL) {
		XplBell();
		XplConsolePrintf("\rMODWEBD: Invalid directory credentials; exiting!\n");
		XplBell();

		MemPrivatePoolFree(ModWebConnectionPool);
		MemoryManagerClose(MSGSRV_AGENT_MODWEB);

		return(-1);
	}

	MWDebugInit();

	XplOpenLocalSemaphore(ModWebServerSemaphore, 0);
	XplOpenLocalSemaphore(ModWebShutdownSemaphore, 1);
	XplOpenLocalSemaphore(CacheSemaphore, 1);
	XplOpenLocalSemaphore(SessionDBSemaphore, 1);
	XplOpenLocalSemaphore(TSessionDBSemaphore, 1);
	XplOpenLocalSemaphore(TraceSemaphore, 1);

	LogHandle = LoggerOpen("hulamodweb");
	if (LogHandle != NULL) {
		;
	} else {
		XplConsolePrintf("MODWEBD: Unable to initialize Nsure Audit.  Logging disabled.\r\n");
	}

	/* Get our defaults */
	ReadConfiguration();

	if (ServerSocketInit() < 0) {
	    XplConsolePrintf("hulamodweb: Exiting\n");
	    return 1;
	}

	/* Initialize any modules and databases we require */
	SessionDBInit();

	printf ("loading templates from %s\n", TemplateDir);
	
	LoadTemplates(TemplateDir);
	if (Templates == NULL) {
		XplConsolePrintf("\rMODWEBD: No templates found; exiting\n");
		if (DefaultTitle) {
			MemFree(DefaultTitle);
		}

		XplCloseLocalSemaphore(TraceSemaphore);
		XplCloseLocalSemaphore(TSessionDBSemaphore);
		XplCloseLocalSemaphore(SessionDBSemaphore);
		XplCloseLocalSemaphore(CacheSemaphore);
		XplCloseLocalSemaphore(ModWebShutdownSemaphore);
		XplCloseLocalSemaphore(ModWebServerSemaphore);

		SessionDBShutdown();

		MemPrivatePoolFree(ModWebConnectionPool);
		MemoryManagerClose(MSGSRV_AGENT_MODWEB);

		exit(-1);
	}

	LoadModules(ModuleDir, ForceLoad);

	XplBeginCountedThread(&id, (void *)SessionMonitor, MODWEB_STACK_SPACE, NULL, ccode, ModWebServerThreads);

	if (AllowClientSSL) {
		SSL_load_error_strings();
		SSL_library_init();
		XPLCryptoLockInit();
		SSLContext=SSL_CTX_new(SSLv23_server_method());
		SSL_CTX_set_mode(SSLContext, SSL_MODE_AUTO_RETRY);
		if (SSLContext) {
			int	result;

			if (ClientSSLOptions & SSL_DONT_INSERT_EMPTY_FRAGMENTS) {
				SSL_CTX_set_options(SSLContext, SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS);
			}

			if (ClientSSLOptions & SSL_ALLOW_CHAIN) {
				result = SSL_CTX_use_certificate_chain_file(SSLContext, MsgGetTLSCertPath(NULL));
			} else {
				result = SSL_CTX_use_certificate_file(SSLContext, MsgGetTLSCertPath(NULL), SSL_FILETYPE_PEM);
			}

			if (result>0) {
				if (SSL_CTX_use_PrivateKey_file(SSLContext, MsgGetTLSKeyPath(NULL), SSL_FILETYPE_PEM)>0) {
					if (SSL_CTX_check_private_key(SSLContext)) {
					    if (ServerSocketSSLInit() >= 0) {
						/* Done binding, drop privs permanentely */
						if (XplSetRealUser(MsgGetUnpriviledgedUser()) < 0) {
						    XplConsolePrintf("hulamodweb: Could not drop to unpriviledged user '%s', exiting.\n", MsgGetUnpriviledgedUser());
						    return 1;
						}
						
						XplBeginCountedThread(&id, (void *)ModWebSSLServer, MODWEB_STACK_SPACE, NULL, ccode, ModWebServerThreads);
					    } else {
						AllowClientSSL = FALSE;
					    }
					} else {
						XplConsolePrintf("\rMODWEBD: PrivateKey check failed\n");
						AllowClientSSL=FALSE;
					}
				} else {
					XplConsolePrintf("\rMODWEBD: Could not load private key\n");
					AllowClientSSL=FALSE;
				}
			} else {
				XplConsolePrintf("\rMODWEBD: Could not load public key\n");
				AllowClientSSL=FALSE;
			}
		} else {
			XplConsolePrintf("\rMODWEBD: Could not generate SSL context\n");
			AllowClientSSL=FALSE;
		}
	}

	/* Done binding, drop privs permanentely */
	if (XplSetRealUser(MsgGetUnpriviledgedUser()) < 0) {
	    XplConsolePrintf("hulamodweb: Could not drop to unpriviledged user '%s', exiting.\n", MsgGetUnpriviledgedUser());
	    return 1;
	}

	/* Management Client Startup */
    if ((ManagementInit(MSGSRV_AGENT_MODWEB, ModWebDirectoryHandle)) 
            && (ManagementSetVariables(MODWEBManagementVariables, sizeof(MODWEBManagementVariables) / sizeof(ManagementVariables))) 
            && (ManagementSetCommands(MODWEBManagementCommands, sizeof(MODWEBManagementCommands) / sizeof(ManagementCommands)))) {
        XplBeginThread(&id, ManagementServer, DMC_MANAGEMENT_STACKSIZE, NULL, ccode);
    }


	XplStartMainThread(PRODUCT_SHORT_NAME, &id, ModWebServer, MODWEB_STACK_SPACE, NULL, ccode);

	XplUnloadApp(XplGetThreadID());
	return(0);
}
