/****************************************************************************
 *
 * Copyright (c) 1997-2004 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <xpl.h>

#include "nmapdp.h"

#define RBNODE_DEFAULT_LENGTH    64

enum RBNodeColors {
    RBNodeRed = 0, 
    RBNodeBlack, 

    RBNodeMaxColors
};

#pragma pack(push, 4)

struct _RBNODE_DATA {
    struct _RBNODE_DATA            *Next;
    struct _RBNODE_DATA            *Prev;

    unsigned char                    *Value;
    unsigned char                    Buffer[RBNODE_DEFAULT_LENGTH];
};

struct _RBNODE {
    enum RBNodeColors                Color;

    struct _RBNODE                    *Parent;
    struct _RBNODE                    *Left;
    struct _RBNODE                    *Right;

    struct _RBNODE_DATA            *Data;

    XplAtomic                        UseCount;

    struct {
        unsigned int                Length;

        unsigned char                *Value;
        unsigned char                Buffer[RBNODE_DEFAULT_LENGTH];
    } Key;
};

struct _RBTREE {
    struct _RBNODE                    *Sentinel;

    struct _RBNODE                    *Root;

    XplAtomic                        Nodes;
};

#pragma pack(pop)

typedef struct _RBNODE_DATA    RBNodeData;
typedef struct _RBNODE            RBNode;
typedef struct _RBTREE            RBTree;

#if 0
static void 
RBTreeRotateLeft(RBTree *Tree, RBNode *Node)
{
    RBNode *x = Node;
    RBNode *y;

    y = x->Right;

    x->Right = y->Left;

    if (y->Left != Tree->Sentinel) {
        y->Left->Parent = x;
    }

    y->Parent = x->Parent;

    if (x->Parent != Tree->Sentinel) {
        if (x == x->Parent->Left) {
            x->Parent->Left = y;
        } else {
            x->Parent->Right = y;
        }
    } else {
        Tree->Root = y;
    }

    y->Left = x;

    x->Parent = y;

    return;
}

static void 
RBTreeRotateRight(RBTree *Tree, RBNode *Node)
{
    RBNode *x = Node;
    RBNode *y;

    y = x->Left;

    x->Left = y->Right;

    if (y->Right != Tree->Sentinel) {
        y->Right->Parent = x;
    }

    y->Parent = x->Parent;

    if (x->Parent != Tree->Sentinel) {
        if (x == x->Parent->Right) {
            x->Parent->Right = y;
        } else {
            x->Parent->Left = y;
        }
    } else {
        Tree->Root = y;
    }

    y->Right = x;

    x->Parent = y;

    return;
}

static RBNode *
RBTreeSearch(RBTree *Tree, const unsigned char *Key)
{
    const unsigned char *k1;
    const unsigned char *k2;
    RBNode *x;
    RBNode *y;

    if (Tree && Key) {
        y = Tree->Sentinel;
        x = Tree->Root;

        k1 = Key;
        k2 = x->Key.Value;
        while (x != Tree->Sentinel) {
            y = x;

            if (*k1 < *k2) {
                x = x->Left;

                k1 = Key;
                k2 = x->Key.Value;
            } else if (*k1 > *k2) {
                x = x->Right;

                k1 = Key;
                k2 = x->Key.Value;
            } else if (*k1) {
                k1++;
                k2++;
            } else {
                return(x);
            }
        }
    }

    return(NULL);
}

static RBNode *
RBTreeInsert(RBTree *Tree, const unsigned char *Key, unsigned char *Data, unsigned int Size)
{
    const unsigned char *k1;
    const unsigned char *k2;
    BOOL l;
    RBNode *x;
    RBNode *y;

    if (Tree && Key) {
        y = Tree->Sentinel;
        x = Tree->Root;

        k1 = Key;
        k2 = x->Key.Value;
        while (x != Tree->Sentinel) {
            y = x;

            if (*k1 < *k2) {
                l = TRUE;

                x = x->Left;

                k1 = Key;
                k2 = x->Key.Value;
            } else if (*k1 > *k2) {
                l = FALSE;

                x = x->Right;

                k1 = Key;
                k2 = x->Key.Value;
            } else if (*k1) {
                k1++;
                k2++;
            } else {
                return(x);
            }
        }

        x = (RBNode *)MemMalloc(sizeof(RBNode));
        if (x) {
            while (*k1 != '\0') {
                k1++;
            }

            x->Key.Length = (k1 - Key) + 1;
            if (x->Key.Length < RBNODE_DEFAULT_LENGTH) {
                x->Key.Value = x->Key.Buffer;
            } else {
                x->Key.Value = (unsigned char *)MemMalloc(x->Key.Length + 1);
            }

            if (x->Key.Value) {
                XplSafeIncrement(Tree->Nodes);

                memcpy(x->Key.Value, Key, x->Key.Length);

                x->Parent = y;

                if (y != Tree->Sentinel) {
                    if (l == TRUE) {
                        y->Left = x;
                    } else {
                        y->Right = x;
                    }
                } else {
                    Tree->Root = x;
                }

                x->Left = Tree->Sentinel;
                x->Right = Tree->Sentinel;

                x->Color = RBNodeRed;

                while ((x != Tree->Root) && (x->Parent->Color == RBNodeRed)) {
                    if (x->Parent == x->Parent->Parent->Left) {
                        y = x->Parent->Parent->Right;
                        if (y->Color == RBNodeRed) {
                            x->Parent->Color = RBNodeBlack;

                            y->Color = RBNodeBlack;

                            x->Parent->Parent->Color = RBNodeRed;

                            x = x->Parent->Parent;
                        } else {
                            if (x == x->Parent->Right) {
                                x = x->Parent;

                                RBTreeRotateLeft(Tree, x);
                            }

                            x->Parent->Color = RBNodeBlack;

                            x->Parent->Parent->Color = RBNodeRed;

                            RBTreeRotateRight(Tree, x->Parent->Parent);
                        }
                    } else {
                        y = x->Parent->Parent->Left;
                        if (y->Color == RBNodeRed) {
                            x->Parent->Color = RBNodeBlack;

                            y->Color = RBNodeBlack;

                            x->Parent->Parent->Color = RBNodeRed;

                            x = x->Parent->Parent;
                        } else {
                            if (x == x->Parent->Left) {
                                x = x->Parent;

                                RBTreeRotateRight(Tree, x);
                            }

                            x->Parent->Color = RBNodeBlack;

                            x->Parent->Parent->Color = RBNodeRed;

                            RBTreeRotateLeft(Tree, x->Parent->Parent);
                        }
                    }
                }

                Tree->Root->Color = RBNodeBlack;
            } else {
                MemFree(x);

                x = NULL;
            }
        }
    }

    return(x);
}

static RBNode *
RBTreeDelete(RBTree *Tree, const unsigned char *Key, unsigned char *Data)
{
    return(NULL);
}

static RBTree *
RBTreeAlloc(void)
{
    register RBTree *tree = (RBTree *)MemMalloc(sizeof(RBTree));
    register RBNode *sentinel = (RBNode *)MemMalloc(sizeof(RBNode));

    if (tree && sentinel) {
        sentinel->Color = RBNodeBlack;

        sentinel->Parent = NULL;

        sentinel->Left = NULL;
        sentinel->Right = NULL;

        sentinel->Key.Length = 0;
        sentinel->Key.Value = NULL;

        tree->Sentinel = sentinel;
        tree->Root = sentinel;

        XplSafeWrite(tree->Nodes, 0);
    } else if (tree) {
        MemFree(tree);

        tree = NULL;
    } else {
        MemFree(sentinel);
    }

    return(tree);
}

static void 
RBTreeFree(RBTree *Tree)
{
    return;
}

static int 
RBTreeStartup(void)
{
    return(0);
}

static int 
RBTreeShutdown(void)
{
    return(0);
}
#endif

/* fixme - implement

int GetCachedDBHandle(void);
void ReleaseCachedDBHandle(int handle);
void ShutdownCachedDBHandles(void);

*/

#define MAX_DB_HANDLES    10000

unsigned long 
InitCachedDBHandles(unsigned long minimum, unsigned long maximum)
{
    return(0);
}

void 
ShutdownCachedDBHandles(void)
{
    return;
}

int 
GetCachedDBHandle(void)
{
    return(0);
}

void 
ReleaseCachedDBHandle(int handle)
{
    return;
}

unsigned long 
FlaimInit(unsigned int port)
{
    return(-1);
}

void 
FlaimShutdown(unsigned int port)
{
    return;
}

unsigned long 
OpenDb(char *dbName, int *handle)
{
    return(-1);
}

unsigned long 
CloseDb(int *handle)
{
    return(-1);
}

unsigned long 
CreateDb(char *dbName, int *handle)
{
    return(-1);
}

unsigned long 
AddQIDToDomain(int handle, unsigned char *domainName, unsigned long queueID)
{
    return(-1);
}

unsigned long 
GetNextQID(int handle, unsigned char *domainName, unsigned long *lastQueueID)
{
    return(-1);
}

unsigned long 
GetNextDomain(int handle, unsigned long bufferLen, unsigned char *lastDomain, unsigned long *domainCount)
{
    return(-1);
}

unsigned long 
DeleteDomainEntry(int handle, unsigned char *domainName, unsigned long *queueID)
{
    return(-1);
}

unsigned long 
DeleteQueueID(int handle, unsigned long queueID)
{
    return(-1);
}
