-- Novell WebAdmin - Schema Definition
--
-- Novell Inc.
-- 1800 South Novell Place
-- Provo, UT 84606-6194

-- VeRsIoN=WEBADMIN 4.0
-- CoPyRiGhT=(c) Copyright 2003, Novell, Inc.  All rights reserved

-- For questions contact mgorrell@novell.com


WebAdminSchemaExtentions DEFINITIONS ::=
BEGIN

-------------------------------------------------------------------------------
-- Generic Attributes
--

-- Generic configuration attribute for all WebAdmin object classes
"WebAdminConfig" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags       {DS_SYNC_IMMEDIATE},
	ASN1ObjID   {2 16 840 1 113719 2 407 4 2}
}

-- Link on NCP server object to Web Administration Server on the
-- same machine
"WebAdminConfigDN" ATTRIBUTE ::=
{
	SyntaxID SYN_DIST_NAME,
	Flags			{DS_SYNC_IMMEDIATE},
	ASN1ObjID	{2 16 840 1 113719 2 407 4 9}
}

-------------------------------------------------------------------------------
-- Attributes for WebAdmin Role Objects
--

-- Name of an administrative role
"WebAdminName" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags       {DS_SYNC_IMMEDIATE},
	ASN1ObjID   {2 16 840 1 113719 2 407 4 1}
}

-------------------------------------------------------------------------------
-- Attributes for Web Administration Server Objects
--

-- Port of Web Administration Server
"WebAdminPort" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags       {DS_SYNC_IMMEDIATE},
	ASN1ObjID   {2 16 840 1 113719 2 407 4 3}
}

-- SSL Port of Web Administration Server
"WebAdminSSLPort" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags       {DS_SYNC_IMMEDIATE},
	ASN1ObjID   {2 16 840 1 113719 2 407 4 4}
}

-- Template Path for Web Administration Server
"WebAdminPath" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags       {DS_SYNC_IMMEDIATE},
	ASN1ObjID   {2 16 840 1 113719 2 407 4 5}
}

-- Certificate Path for Web Administration Server
"WebAdminCertPath" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags       {DS_SYNC_IMMEDIATE},
	ASN1ObjID   {2 16 840 1 113719 2 407 4 6}
}

-- Private Key Path for Web Administration Server
"WebAdminKeyPath" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags       {DS_SYNC_IMMEDIATE},
	ASN1ObjID   {2 16 840 1 113719 2 407 4 7}
}

-- Address of Web Administration Server
"WebAdminAddress" ATTRIBUTE ::=
{
	SyntaxID	SYN_CI_STRING,
	Flags       {DS_SYNC_IMMEDIATE},
	ASN1ObjID   {2 16 840 1 113719 2 407 4 8}
}


------------------------------------------
-- New Object Classes
------------------------------------------
------------------------------------------

-- A Web Administration Object is used to allow other
--	services to determine where WebAdmin is running, and
-- its current state.
"WebAdminServer" OBJECT-CLASS ::=
{
	Operation       ADD,
	SubClassOf		{"TOP"},
	Flags				{DS_CONTAINER_CLASS, DS_EFFECTIVE_CLASS},
	ContainedBy		{"Organizational Unit", "Organization"},
	NamedBy			{"OU"},
	MustContain		{"OU"},
	MayContain  {
		"WebAdminPort",
		"WebAdminSSLPort",
		"WebAdminPath",
		"WebAdminCertPath",
		"WebAdminKeyPath",
		"WebAdminAddress",
		"WebAdminConfig"
	},
	ASN1ObjID   {2 16 840 1 113719 2 407 6 1}
}

-- A Web Administration Role Object is used for managing
-- a users rights to roles
"WebAdminRole" OBJECT-CLASS ::=
{
	Operation		ADD,
	SubClassOf		{"TOP"},
	Flags				{DS_EFFECTIVE_CLASS},
	ContainedBy		{"Organizational Unit", "Organization", "WebAdminServer"},
	NamedBy			{"OU"},
	MustContain		{"OU"},
	MayContain  {
		"WebAdminName",
		"WebAdminConfig"
	},
	ASN1ObjID   {2 16 840 1 113719 2 407 6 2}
}

-- Add a link to the Web Administration Server Object
"NCP Server" OBJECT-CLASS ::=
{
	Operation       MODIFY,
	MayContain  {
		"WebAdminConfigDN"
	}
}

END
