/****************************************************************************
 *
 * Copyright (c) 1998-2004 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <xpl.h>

#include <errno.h>
#include <hulautil.h>
#include <connio.h>

#include <openssl/pem.h>
#include <openssl/x509.h>
#include <openssl/x509v3.h>

#include "hulasetup.h"

#include <mwtempl.h>
#include <webadmin.h>

#define PRODUCT_NAME                    "Hula Configuration Utility"

#define ERR_ENTRY_ALREADY_EXISTS        0xFFFFFDA2
#define ERR_ATTRIBUTE_ALREADY_EXISTS    0xFFFFFD99
#define ERR_CLASS_ALREADY_EXISTS        0xFFFFFD7B
#define ERR_DUPLICATE_OPTIONAL          0xFFFFFD73

struct _HULA_GLOBAL_VARIABLES {
    unsigned long exiting;
    unsigned long actions;
    unsigned long agents;

    struct {
        XplThreadID main;
        XplThreadID group;
    } id;

    MDBHandle directoryHandle;

    struct {
        unsigned char name[MDB_MAX_OBJECT_CHARS + 1];
        unsigned char x500Name[MDB_MAX_OBJECT_CHARS + 1];
        unsigned char password[MDB_MAX_OBJECT_CHARS + 1];
    } user;

    struct {
        unsigned char dn[MDB_MAX_OBJECT_CHARS + 1];
        unsigned char context[MDB_MAX_OBJECT_CHARS + 1];
        unsigned char tree[MDB_MAX_OBJECT_CHARS + 1];
    } host;

    struct {
        unsigned char server[MDB_MAX_OBJECT_CHARS + 1];
        unsigned char host[MDB_MAX_OBJECT_CHARS + 1];
    } associate;

    struct {
        unsigned long ldap;
        unsigned long http;
        unsigned long https;

        struct {
            unsigned long http;
            unsigned long https;
        } webAdmin;

        struct {
            unsigned long clear;
            unsigned long secure;
        } smtp;
        struct {
            unsigned long clear;
            unsigned long secure;
        } imap;
        struct {
            unsigned long clear;
            unsigned long secure;
        } pop3;
    } ports;

    struct {
        int count;
        unsigned char *servers[3];
    } dns;

    unsigned char hint[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char server[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char webAdmin[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char domain[MDB_MAX_OBJECT_CHARS + 1];
} HulaSetup;

/*  fixme - see Exiting in connio
*/
int Exiting = FALSE;

static DirectoryAttributeStruct 
HulaAttributes[] = {
    {   MSGSRV_A_ACTION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 255,
        { 0, { HULA_CLASS_ANTISPAM_AGENT, 0 } }
    }, 
    {   MSGSRV_A_AGENT_STATUS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MAIL_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_ALIAS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_ALIAS_AGENT | HULA_CLASS_INTERNET_SERVICES, 0 } }
    }, 
    {   MSGSRV_A_AUTHENTICATION_REQUIRED,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_SMTP_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_CONFIGURATION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_MAIL_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_CLIENT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_CONTEXT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { HULA_CLASS_MESSAGING_SERVER, { HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_DOMAIN,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 255,
        { HULA_CLASS_SMTP_AGENT, { HULA_CLASS_CONTEXT | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_MWSIGNUP_MODULE } }
    }, 
    {   MSGSRV_A_EMAIL_ADDRESS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 255,
        { 0, { HULA_CLASS_ANTISPAM_AGENT | HULA_CLASS_USER, 0 } }
    }, 
    {   MSGSRV_A_DISABLED,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_MAIL_AGENT | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_HULA_RESOURCE | HULA_CLASS2_WEBADMIN_AGENT } }
    }, 
    {   MSGSRV_A_FINGER_MESSAGE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_GROUP | HULA_CLASS_FINGER_AGENT, 0 } }
    }, 
    {   MSGSRV_A_HOST,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { HULA_CLASS_MESSAGING_SERVER, { HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_IP_ADDRESS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        7, 15,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_LDAP_SERVER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 255,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_LDAP_NMAP_SERVER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_LDAP_SEARCH_DN,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 255,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_MESSAGE_LIMIT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_SMTP_AGENT | HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_MWMAIL_MODULE } }
    }, 
    {   MSGSRV_A_MESSAGING_SERVER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NCP_SERVER, 0 } }
    }, 
    {   MSGSRV_A_MODULE_NAME,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { HULA_CLASS_MAIL_AGENT, { 0, HULA_CLASS2_WEBADMIN_AGENT } }
    }, 
    {   MSGSRV_A_MODULE_VERSION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 3,
        { HULA_CLASS_MAIL_AGENT, { 0, 0 } }
    }, 
    {   MSGSRV_A_NMAP_SERVER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_NMAP_QUEUE_SERVER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MAIL_AGENT | HULA_CLASS_LIST | HULA_CLASS_NDSLIST, 0 } }
    }, 
    {   MSGSRV_A_OFFICIAL_NAME,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 255,
        { HULA_CLASS_MESSAGING_SERVER, { HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_QUOTA_MESSAGE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_POSTMASTER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { HULA_CLASS_MESSAGING_SERVER, { HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_REPLY_MESSAGE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_AUTOREPLY_AGENT | HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_URL,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_RESOLVER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        7, 15,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_ROUTING,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_SMTP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_SERVER_STATUS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_QUEUE_INTERVAL,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 32,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_QUEUE_TIMEOUT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 32,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_CONFIG_CHANGED,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_MAIL_AGENT | HULA_CLASS_INTERNET_SERVICES | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_SSL_OPTIONS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 255,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_UID,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 32,
        { 0, { HULA_CLASS_NMAP_AGENT, HULA_CLASS2_MWSIGNUP_MODULE } }
    }, 
    {   MSGSRV_A_WORD,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 46,
        { 0, { HULA_CLASS_ANTISPAM_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_MESSAGE_STORE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 255,
        { HULA_CLASS_NMAP_AGENT, { HULA_CLASS_CONTEXT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_FORWARDING_ADDRESS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 255,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_FORWARDING_ENABLED,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_WAP_MSG_SIZE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_USER, 0 } }
    }, 
    {   MSGSRV_A_AUTOREPLY_ENABLED,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_AUTOREPLY_MESSAGE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_AUTOREPLY_AGENT | HULA_CLASS_USER, 0 } }
    }, 
    {   MSGSRV_A_PORT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 6,
        { 0, { HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_SSL_PORT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 6,
        { 0, { HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_SNMP_DESCRIPTION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_SNMP_VERSION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_SNMP_ORGANIZATION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_SNMP_LOCATION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_SNMP_CONTACT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_SNMP_NAME,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_MESSAGING_DISABLED,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_USER | HULA_CLASS_GROUP | HULA_CLASS_ORGANIZATIONAL_ROLE | HULA_CLASS_CONTEXT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_NMAP_TRUSTED_HOSTS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        7, 15,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_USE_QUOTA,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT | HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_QUOTA_VALUE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT | HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_SCMS_USER_THRESHOLD,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_SCMS_SIZE_THRESHOLD,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_SMTP_VERIFY_ADDRESS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_SMTP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_SMTP_ALLOW_AUTH,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_SMTP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_SMTP_ALLOW_VRFY,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_SMTP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_SMTP_ALLOW_EXPN,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_SMTP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_WORK_DIRECTORY,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 255,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_LOGLEVEL,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 2,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_MINIMUM_SPACE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 12,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_SMTP_SEND_ETRN,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_SMTP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_SMTP_ACCEPT_ETRN,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_SMTP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_LIMIT_REMOTE_PROCESSING,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_LIMIT_REMOTE_START_WD,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 2,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_LIMIT_REMOTE_END_WD,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 2,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_LIMIT_REMOTE_START_WE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 2,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_LIMIT_REMOTE_END_WE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 2,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_PRODUCT_VERSION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 40,
        { 0, { HULA_CLASS_MAIL_AGENT | HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_PROXY_LIST,
        NULL, 
        0,
        0, 0,
        { 0, { HULA_CLASS_USER, 0 } }
    }, 
    {   MSGSRV_A_MAXIMUM_ITEMS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 5,
        { 0, { HULA_CLASS_PROXY_AGENT, 0 } }
    }, 
    {   MSGSRV_A_TIME_INTERVAL,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 10,
        { 0, { HULA_CLASS_ADDRESSBOOK_AGENT | HULA_CLASS_ALIAS_AGENT | HULA_CLASS_PROXY_AGENT, 0 } }
    }, 
    {   MSGSRV_A_RELAYHOST,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 255,
        { 0, { HULA_CLASS_SMTP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_ALIAS_OPTIONS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_ALIAS_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_LDAP_OPTIONS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_ADDRESSBOOK_AGENT, 0 } }
    }, 
    {   MSGSRV_A_CUSTOM_ALIAS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_ALIAS_AGENT, 0 } }
    }, 
    {   MSGSRV_A_ADVERTISING_CONFIG,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_LANGUAGE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_MODWEB_AGENT } }
    }, 
    {   MSGSRV_A_COLOR,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_MODWEB_AGENT } }
    }, 
    {   MSGSRV_A_FONT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_MODWEB_AGENT } }
    }, 
    {   MSGSRV_A_PREFERENCES,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_MODWEB_AGENT } }
    }, 
    {   MSGSRV_A_QUOTA_WARNING,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_RTS_HANDLING,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_QUEUE_TUNING,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_TIMEOUT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MAIL_AGENT | HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_PRIVACY,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MAIL_AGENT | HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_THREAD_LIMIT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_DBF_PAGESIZE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_DBF_KEYSIZE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_ADDRESSBOOK_CONFIG,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_MWMAIL_MODULE } }
    }, 
    {   MSGSRV_A_ADDRESSBOOK_URL_SYSTEM,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_MWMAIL_MODULE } }
    }, 
    {   MSGSRV_A_ADDRESSBOOK_URL_PUBLIC,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_MWMAIL_MODULE } }
    }, 
    {   MSGSRV_A_ADDRESSBOOK,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_SERVER_STANDALONE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_FORWARD_UNDELIVERABLE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_PHRASE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_ACCOUNTING_ENABLED,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_INTERNET_SERVICES | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_ACCOUNTING_DATA,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_BILLING_DATA,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_BLOCKED_ADDRESS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_SMTP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_ALLOWED_ADDRESS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_SMTP_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_UBE_CONFIGURATION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_SMTP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_RECIPIENT_LIMIT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_SMTP_AGENT | HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_MWMAIL_MODULE } }
    }, 
    {   MSGSRV_A_RBL_HOST,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_SMTP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_SIGNATURE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_CONNMGR,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_CONNMGR_CONFIG,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_USER_DOMAIN,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 255,
        { 0, { HULA_CLASS_SMTP_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_RTS_ANTISPAM_CONFIG,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT | HULA_CLASS_SMTP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_DEFAULT_CHARSET,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_INTERNET_SERVICES | HULA_CLASS_CONTEXT | HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_RULE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_RULESRV_AGENT | HULA_CLASS_USER | HULA_CLASS_GROUP | HULA_CLASS_CONTEXT | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_HULA_RESOURCE } }
    }, 
    {   MSGSRV_A_LIST_DIGESTTIME,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST_AGENT, 0 } }
    }, 
    {   MSGSRV_A_LIST_ABSTRACT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST | HULA_CLASS_NDSLIST, 0 } }
    }, 
    {   MSGSRV_A_LIST_DESCRIPTION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST | HULA_CLASS_NDSLIST, 0 } }
    }, 
    {   MSGSRV_A_LIST_CONFIGURATION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST | HULA_CLASS_NDSLIST, 0 } }
    }, 
    {   MSGSRV_A_LIST_STORE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST | HULA_CLASS_NDSLIST, 0 } }
    }, 
    {   MSGSRV_A_LIST_MODERATOR,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST | HULA_CLASS_NDSLIST, 0 } }
    }, 
    {   MSGSRV_A_LIST_OWNER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST | HULA_CLASS_NDSLIST | HULA_CLASS_LIST_AGENT, 0 } }
    }, 
    {   MSGSRV_A_LIST_SIGNATURE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST | HULA_CLASS_NDSLIST | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_PLUSPACK_AGENT } }
    }, 
    {   MSGSRV_A_LIST_SIGNATURE_HTML,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST | HULA_CLASS_NDSLIST | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_PLUSPACK_AGENT } }
    }, 
    {   MSGSRV_A_LIST_DIGEST_VERSION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST | HULA_CLASS_NDSLIST, 0 } }
    }, 
    {   MSGSRV_A_LIST_MEMBERS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NDSLIST, 0 } }
    }, 
    {   MSGSRV_A_LISTUSER_OPTIONS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST_USER, 0 } }
    }, 
    {   MSGSRV_A_LISTUSER_ADMINOPTIONS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST_USER, 0 } }
    }, 
    {   MSGSRV_A_LISTUSER_PASSWORD,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST_USER, 0 } }
    }, 
    {   MSGSRV_A_RELAY_DOMAIN,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_SMTP_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_SPOOL_DIRECTORY,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_SCMS_DIRECTORY,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT, 0 } }
    }, 
    {   MSGSRV_A_DBF_DIRECTORY,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_NLS_DIRECTORY,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_BIN_DIRECTORY,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_ACL,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_MAIL_AGENT | HULA_CLASS_INTERNET_SERVICES | HULA_CLASS_LIST | HULA_CLASS_NDSLIST | HULA_CLASS_LIST_CONTAINER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_FEATURE_SET,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_INTERNET_SERVICES | HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_MAIL_AGENT | HULA_CLASS_USER | HULA_CLASS_GROUP | HULA_CLASS_CONTEXT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_WEBMAIL_PLUGIN_ORDER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_INTERNET_SERVICES | HULA_CLASS_WEBMAIL_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_PRIVATE_KEY_LOCATION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_INTERNET_SERVICES | HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_NCP_SERVER, 0 } }
    }, 
    {   MSGSRV_A_CERTIFICATE_LOCATION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_INTERNET_SERVICES | HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_NCP_SERVER, 0 } }
    }, 
    {   MSGSRV_A_PARENT_OBJECT,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_PARENT_OBJECT | HULA_CLASS_GROUP | HULA_CLASS_ORGANIZATIONAL_ROLE | HULA_CLASS_CONTEXT | HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_FEATURE_INHERITANCE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_PARENT_OBJECT | HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_LISTSERVER_NAME,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST_AGENT, 0 } }
    }, 
    {   MSGSRV_A_LIST_WELCOME_MESSAGE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_LIST, 0 } }
    }, 
    {   MSGSRV_A_TEMPLATE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT | HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_DEFAULT_TEMPLATE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_PARENT_OBJECT | HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_TIMEZONE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT | HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_LOCALE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT | HULA_CLASS_MAIL_AGENT, 0 } }
    }, 
    {   MSGSRV_A_PASSWORD_CONFIGURATION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_MWPREF_MODULE } }
    }, 
    {   MSGSRV_A_TITLE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, HULA_CLASS2_MODWEB_AGENT } }
    }, 
    {   MSGSRV_A_TOM_MANAGER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_TOM_CONTEXTS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_TOM_DOMAINS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_TOM_OPTIONS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_DESCRIPTION,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_STATSERVER_1,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { 0, HULA_CLASS2_MWSIGNUP_MODULE } }
    }, 
    {   MSGSRV_A_STATSERVER_2,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { 0, HULA_CLASS2_MWSIGNUP_MODULE } }
    }, 
    {   MSGSRV_A_STATSERVER_3,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { 0, HULA_CLASS2_MWSIGNUP_MODULE } }
    }, 
    {   MSGSRV_A_STATSERVER_4,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { 0, HULA_CLASS2_MWSIGNUP_MODULE } }
    }, 
    {   MSGSRV_A_STATSERVER_5,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { 0, HULA_CLASS2_MWSIGNUP_MODULE } }
    }, 
    {   MSGSRV_A_STATSERVER_6,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { 0, HULA_CLASS2_MWSIGNUP_MODULE } }
    }, 
    {   MSGSRV_A_NEWS,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { 0, HULA_CLASS2_MWSIGNUP_MODULE } }
    }, 
    {   MSGSRV_A_MANAGER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_MESSAGING_SERVER, 0 } }
    }, 
    {   MSGSRV_A_WA_DEFAULT_TEMPLATE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_USER | HULA_CLASS_GROUP | HULA_CLASS_ORGANIZATIONAL_ROLE | HULA_CLASS_CONTEXT, 0 } }
    }, 
    {   MSGSRV_A_WA_DISALLOWED_TEMPLATES,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        1, 1,
        { 0, { HULA_CLASS_USER | HULA_CLASS_GROUP | HULA_CLASS_ORGANIZATIONAL_ROLE | HULA_CLASS_CONTEXT, 0 } }
    }, 
    {   MSGSRV_A_AVAILABLE_SHARES,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT | HULA_CLASS_INTERNET_SERVICES, 0 } }
    }, 
    {   MSGSRV_A_OWNED_SHARES,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER, 0 } }
    }, 
    {   MSGSRV_A_NEW_SHARE_MESSAGE,
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NMAP_AGENT | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   MSGSRV_A_AVAILABLE_PROXIES,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER | HULA_CLASS_PARENT_OBJECT | HULA_CLASS_INTERNET_SERVICES, 0 } }
    }, 
    {   MSGSRV_A_OWNED_PROXIES,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER, 0 } }
    }, 
    {   PLUSPACK_A_ACL_GROUP,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { 0, HULA_CLASS2_PLUSPACK_AGENT } }
    }, 
    {   PLUSPACK_A_COPY_USER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { 0, HULA_CLASS2_PLUSPACK_AGENT } }
    }, 
    {   PLUSPACK_A_COPY_MBOX,
        NULL, 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { 0, HULA_CLASS2_PLUSPACK_AGENT } }
    }, 
    {   MSGSRV_A_MANAGED_RESOURCES,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_USER, 0 } }
    }, 
    {   MSGSRV_A_RESOURCE_MANAGER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { 0, HULA_CLASS2_HULA_RESOURCE } }
    }, 
    {   MSGSRV_A_HULA_MESSAGING_SERVER,
        NULL, 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC | HULA_ATTRIBUTE_FLAG_PUBLIC,
        0, 0,
        { 0, { HULA_CLASS_NCP_SERVER, 0 } }
    }, 
    {   WA_A_ROLE_NAME,
        "2.16.840.1.113719.2.407.4.1", 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { 0, HULA_CLASS2_WEBADMIN_ROLE } }
    }, 
    {   WA_A_CONFIG,
        "2.16.840.1.113719.2.407.4.2", 
        HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC | HULA_ATTRIBUTE_FLAG_PUBLIC,
        0, 0,
        { 0, { 0, HULA_CLASS2_WEBADMIN_ROLE } }
    }, 
    {   WA_A_PORT,
        "2.16.840.1.113719.2.407.4.3", 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC | HULA_ATTRIBUTE_FLAG_PUBLIC,
        0, 0,
        { 0, { 0, HULA_CLASS2_WEBADMIN_AGENT } }
    }, 
    {   WA_A_SSLPORT,
        "2.16.840.1.113719.2.407.4.4", 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC | HULA_ATTRIBUTE_FLAG_PUBLIC,
        0, 0,
        { 0, { 0, HULA_CLASS2_WEBADMIN_AGENT } }
    }, 
    {   WA_A_PATH,
        "2.16.840.1.113719.2.407.4.5", 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC | HULA_ATTRIBUTE_FLAG_PUBLIC,
        0, 0,
        { 0, { 0, HULA_CLASS2_WEBADMIN_AGENT } }
    }, 
    {   WA_A_CERT_PATH,
        "2.16.840.1.113719.2.407.4.6", 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC | HULA_ATTRIBUTE_FLAG_PUBLIC,
        0, 0,
        { 0, { 0, HULA_CLASS2_WEBADMIN_AGENT } }
    }, 
    {   WA_A_KEY_PATH,
        "2.16.840.1.113719.2.407.4.7", 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC | HULA_ATTRIBUTE_FLAG_PUBLIC,
        0, 0,
        { 0, { 0, HULA_CLASS2_WEBADMIN_AGENT } }
    }, 
    {   WA_A_ADDRESS,
        "2.16.840.1.113719.2.407.4.8", 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC | HULA_ATTRIBUTE_FLAG_PUBLIC,
        0, 0,
        { 0, { 0, HULA_CLASS2_WEBADMIN_AGENT } }
    }, 
    {   WA_A_CONFIG_DN,
        "2.16.840.1.113719.2.407.4.9", 
        HULA_ATTRIBUTE_FLAG_DN | HULA_ATTRIBUTE_FLAG_SINGLE_VALUE | HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC,
        0, 0,
        { 0, { HULA_CLASS_NCP_SERVER, HULA_CLASS2_WEBADMIN_AGENT } }
    }, 
    {   NULL,
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }
};

static DirectoryAttributeStruct 
HulaSpecialAttributes[] = {
    {   A_PRIVATE_KEY, 
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE, 
        0, 0, 
        { 0, { HULA_CLASS_INTERNET_SERVICES | HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   A_PUBLIC_KEY, 
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE, 
        0, 0, 
        { 0, { HULA_CLASS_INTERNET_SERVICES | HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   A_LOGIN_INTRUDER_ADDRESS, 
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE, 
        0, 0, 
        { 0, { HULA_CLASS_INTERNET_SERVICES | HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   A_LOGIN_INTRUDER_ATTEMPTS, 
        NULL, 
        HULA_ATTRIBUTE_FLAG_SINGLE_VALUE, 
        0, 0, 
        { 0, { HULA_CLASS_INTERNET_SERVICES | HULA_CLASS_MESSAGING_SERVER | HULA_CLASS_PARENT_OBJECT, 0 } }
    }, 
    {   NULL,
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }
};

static DirectoryAttributeStruct 
HulaObsoleteAttributes[] = {
    {   "Novonyx:Address", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:Path", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:EchoMessage", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:Group", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:LDAPPassword", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:LDAPServer", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:LDAPUser", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:SSLKey", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:Title", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:ColorScheme", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:RegionalFormat", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:ListFormat", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:SSLCertificate", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:ReplySettings", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:Rule", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:Shutdown", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:Startup", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:Title", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:X509Certificate", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:RepositoryStream", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:LDIFCycleTime", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:ConfigChanged", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   "Novonyx:SyslogConfig", 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }, 
    {   NULL, 
        NULL, 
        0,
        0, 0,
        { 0, { 0, 0 } }
    }
};

static DirectoryObjectClassStruct 
HulaClasses[] = {
    {   MSGSRV_C_ROOT, 
        NULL, 
        HULA_CLASS_FLAG_CONTAINER, 
        { HULA_CLASS_INTERNET_SERVICES, 0 }, 
        C_TOP, 
        A_ORGANIZATION_NAME, 
        { C_TOP, C_ORGANIZATION, C_ORGANIZATIONAL_UNIT, NULL }, 
        { A_ORGANIZATION_NAME, NULL }
    }, 
    {   MSGSRV_C_SERVER, 
        NULL, 
        HULA_CLASS_FLAG_CONTAINER, 
        { HULA_CLASS_MESSAGING_SERVER, 0 }, 
        C_TOP, 
        A_ORGANIZATIONAL_UNIT_NAME, 
        { MSGSRV_C_ROOT, C_ORGANIZATION, C_ORGANIZATIONAL_UNIT, NULL }, 
        { A_ORGANIZATIONAL_UNIT_NAME, MSGSRV_A_POSTMASTER, MSGSRV_A_HOST, MSGSRV_A_CONTEXT, MSGSRV_A_OFFICIAL_NAME, NULL }
    }, 
    {   MSGSRV_C_AGENT, 
        NULL, 
        0, 
        { HULA_CLASS_MAIL_AGENT, 0 }, 
        C_TOP, 
        A_COMMON_NAME, 
        { MSGSRV_C_SERVER, NULL }, 
        { A_COMMON_NAME, MSGSRV_A_MODULE_NAME, MSGSRV_A_MODULE_VERSION, NULL }
    }, 
    {   MSGSRV_C_ADDRESSBOOK, 
        NULL, 
        0, 
        { HULA_CLASS_ADDRESSBOOK_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_ALIAS, 
        NULL, 
        0, 
        { HULA_CLASS_ALIAS_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_ANTISPAM, 
        NULL, 
        0, 
        { HULA_CLASS_ANTISPAM_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_AUTOREPLY, 
        NULL, 
        0, 
        { HULA_CLASS_AUTOREPLY_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_FINGER, 
        NULL, 
        0, 
        { HULA_CLASS_FINGER_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_IMAP, 
        NULL, 
        0, 
        { HULA_CLASS_IMAP_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_NMAP, 
        NULL, 
        0, 
        { HULA_CLASS_NMAP_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { MSGSRV_A_MESSAGE_STORE, NULL }
    }, 
    {   MSGSRV_C_POP, 
        NULL, 
        0, 
        { HULA_CLASS_POP_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_PROXY, 
        NULL, 
        0, 
        { HULA_CLASS_PROXY_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_SMTP, 
        NULL, 
        0, 
        { HULA_CLASS_SMTP_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { MSGSRV_A_DOMAIN, NULL}
    }, 
    {   MSGSRV_C_WEBMAIL, 
        NULL, 
        0, 
        { HULA_CLASS_WEBMAIL_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_SIGNUP, 
        NULL, 
        0, 
        { HULA_CLASS_SIGNUP_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_CONNMGR, 
        NULL, 
        0, 
        { HULA_CLASS_CONNMGR_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_RULESRV, 
        NULL, 
        0, 
        { HULA_CLASS_RULESRV_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_LISTAGENT, 
        NULL, 
        0, 
        { HULA_CLASS_LIST_AGENT, 0 }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_LISTCONTAINER, 
        NULL, 
        HULA_CLASS_FLAG_CONTAINER, 
        { HULA_CLASS_LIST_CONTAINER, 0 }, 
        C_TOP, 
        A_ORGANIZATIONAL_UNIT_NAME, 
        { MSGSRV_C_ROOT, NULL }, 
        { A_ORGANIZATIONAL_UNIT_NAME, NULL }
    }, 
    {   MSGSRV_C_LIST, 
        NULL, 
        HULA_CLASS_FLAG_CONTAINER, 
        { HULA_CLASS_LIST, 0 }, 
        C_TOP, 
        A_ORGANIZATIONAL_UNIT_NAME, 
        { MSGSRV_C_LISTCONTAINER, C_ORGANIZATION, C_ORGANIZATIONAL_UNIT, NULL }, 
        { A_ORGANIZATIONAL_UNIT_NAME, NULL }
    }, 
    {   MSGSRV_C_NDSLIST, 
        NULL, 
        0, 
        { HULA_CLASS_NDSLIST, 0 }, 
        C_TOP, 
        A_ORGANIZATIONAL_UNIT_NAME, 
        { MSGSRV_C_LISTCONTAINER, C_ORGANIZATION, C_ORGANIZATIONAL_UNIT, NULL }, 
        { A_ORGANIZATIONAL_UNIT_NAME, NULL }
    }, 
    {   MSGSRV_C_LISTUSER, 
        NULL, 
        0, 
        { HULA_CLASS_LIST_USER, 0 }, 
        C_USER, 
        A_COMMON_NAME, 
        { MSGSRV_C_LIST, NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_PARENTCONTAINER, 
        NULL, 
        HULA_CLASS_FLAG_CONTAINER, 
        { HULA_CLASS_PARENT_CONTAINER, 0 }, 
        C_TOP, 
        A_ORGANIZATIONAL_UNIT_NAME, 
        { MSGSRV_C_ROOT, NULL }, 
        {A_ORGANIZATIONAL_UNIT_NAME, NULL }
    }, 
    {   MSGSRV_C_PARENTOBJECT, 
        NULL, 
        0, 
        { HULA_CLASS_PARENT_OBJECT, 0 }, 
        C_TOP, 
        A_COMMON_NAME, 
        { MSGSRV_C_PARENTCONTAINER, C_ORGANIZATION, C_ORGANIZATIONAL_UNIT, NULL }, 
        { A_COMMON_NAME, NULL }
    }, 
    {   MSGSRV_C_TEMPLATECONTAINER, 
        NULL, 
        HULA_CLASS_FLAG_CONTAINER, 
        { HULA_CLASS_TEMPLATE_CONTAINER, 0 }, 
        C_TOP, 
        A_ORGANIZATIONAL_UNIT_NAME, 
        { MSGSRV_C_ROOT, NULL }, 
        { A_ORGANIZATIONAL_UNIT_NAME, NULL }
    }, 
    {   MSGSRV_C_MODWEBTEMPLATE, 
        NULL, 
        0, 
        { HULA_CLASS_MODWEB_TEMPLATE, 0 }, 
        C_TOP, 
        A_COMMON_NAME, 
        { MSGSRV_C_TEMPLATECONTAINER, C_ORGANIZATION, C_ORGANIZATIONAL_UNIT, NULL }, 
        { A_COMMON_NAME, NULL }
    }, 
    {   MSGSRV_C_MODWEB, 
        NULL, 
        HULA_CLASS_FLAG_CONTAINER, 
        { 0, HULA_CLASS2_MODWEB_AGENT }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_MWMAIL_MODULE, 
        NULL, 
        0, 
        { 0, HULA_CLASS2_MWMAIL_MODULE }, 
        MSGSRV_C_AGENT, 
        A_COMMON_NAME, 
        { MSGSRV_C_MODWEB, NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_MWCAL_MODULE, 
        NULL, 
        0, 
        { 0, HULA_CLASS2_MWCAL_MODULE }, 
        MSGSRV_C_AGENT, 
        A_COMMON_NAME, 
        { MSGSRV_C_MODWEB, NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_MWPREF_MODULE, 
        NULL, 
        0, 
        { 0, HULA_CLASS2_MWPREF_MODULE }, 
        MSGSRV_C_AGENT, 
        A_COMMON_NAME, 
        { MSGSRV_C_MODWEB, NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_MWTOM_MODULE, 
        NULL, 
        0, 
        { 0, HULA_CLASS2_MWTOM_MODULE }, 
        MSGSRV_C_AGENT, 
        A_COMMON_NAME, 
        { MSGSRV_C_MODWEB, NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_CALAGENT, 
        NULL, 
        0, 
        { 0, HULA_CLASS2_CALENDAR_AGENT }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_ANTIVIRUS, 
        NULL, 
        0, 
        { 0, HULA_CLASS2_ANTIVIRUS_AGENT }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_MWSIGNUP_MODULE, 
        NULL, 
        0, 
        { 0, HULA_CLASS2_MWSIGNUP_MODULE }, 
        MSGSRV_C_AGENT, 
        A_COMMON_NAME, 
        { MSGSRV_C_MODWEB, NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_RESOURCE, 
        NULL, 
        0, 
        { 0, HULA_CLASS2_HULA_RESOURCE }, 
        "Resource", 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   PLUSPACK_C, 
        NULL, 
        0, 
        { 0, HULA_CLASS2_PLUSPACK_AGENT }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_CAP, 
        NULL, 
        0, 
        { 0, HULA_CLASS2_CAP_AGENT }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   C_USER, 
        NULL, 
        0, 
        { HULA_CLASS_USER, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   C_GROUP, 
        NULL, 
        0, 
        { HULA_CLASS_GROUP, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   C_ORGANIZATIONAL_ROLE, 
        NULL, 
        0, 
        { HULA_CLASS_ORGANIZATIONAL_ROLE, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   C_ORGANIZATION, 
        NULL, 
        0, 
        { HULA_CLASS_CONTEXT, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   C_ORGANIZATIONAL_UNIT, 
        NULL, 
        0, 
        { HULA_CLASS_CONTEXT, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   C_NCP_SERVER, 
        NULL, 
        0, 
        { HULA_CLASS_NCP_SERVER, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   MSGSRV_C_MODWEB, 
        NULL, 
        HULA_CLASS_FLAG_CONTAINER, 
        { 0, HULA_CLASS2_MODWEB_AGENT }, 
        MSGSRV_C_AGENT, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   WA_C_SERVER_OBJECT, 
        "2.16.840.1.113719.2.407.6.1", 
        HULA_CLASS_FLAG_CONTAINER, 
        { 0, HULA_CLASS2_WEBADMIN_AGENT }, 
        C_TOP, 
        A_ORGANIZATIONAL_UNIT_NAME, 
        { C_ORGANIZATION, C_ORGANIZATIONAL_UNIT, NULL }, 
        { A_ORGANIZATIONAL_UNIT_NAME, NULL }
    }, 
    {   WA_C_ROLE, 
        "2.16.840.1.113719.2.407.6.2", 
        0, 
        { 0, HULA_CLASS2_WEBADMIN_ROLE }, 
        C_TOP, 
        A_ORGANIZATIONAL_UNIT_NAME, 
        { WA_C_SERVER_OBJECT, NULL }, 
        { A_ORGANIZATIONAL_UNIT_NAME, NULL }
    }, 
    {   NULL, 
        NULL, 
        0, 
        { 0, 0}, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }
};

static DirectoryObjectClassStruct 
HulaObsoleteClasses[] = {
    {   "Novonyx:Repository", 
        NULL, 
        0, 
        { 0, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   "Novonyx:Repository Type", 
        NULL, 
        0, 
        { 0, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   "Novonyx:Repository Item", 
        NULL, 
        0, 
        { 0, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   "Novonyx:AntiVirus Agent", 
        NULL, 
        0, 
        { 0, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   "Novonyx:Rule Agent", 
        NULL, 
        0, 
        { 0, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   "Novonyx:BulkMail Agent", 
        NULL, 
        0, 
        { 0, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   "Novonyx:Certificate", 
        NULL, 
        0, 
        { 0, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   "Novonyx:Certificate Database", 
        NULL, 
        0, 
        { 0, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   "Novonyx:Directory Agent", 
        NULL, 
        0, 
        { 0, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   "NIMS:AutoSignatureAgent", 
        NULL, 
        0, 
        { 0, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }, 
    {   NULL, 
        NULL, 
        0, 
        { 0, 0 }, 
        NULL, 
        NULL, 
        { NULL }, 
        { NULL }
    }
};

static BOOL 
AddSchema(void)
{
    int i;
    unsigned long j;
    int k;
    BOOL result = FALSE;
    MDBValueStruct *v;
    MDBValueStruct *superClass = NULL;
    MDBValueStruct *containment = NULL;
    MDBValueStruct *naming = NULL;
    MDBValueStruct *mandatory;
    MDBValueStruct *optional = NULL;

    v = MDBCreateValueStruct(HulaSetup.directoryHandle, NULL);
    if (v) {
        superClass = MDBShareContext(v);
        containment = MDBShareContext(v);
        naming = MDBShareContext(v);
        mandatory = MDBShareContext(v);
        optional = MDBShareContext(v);

        if (superClass && containment && naming && mandatory && optional) {
            result = TRUE;
        }
    } else {
        XplConsolePrintf("  Schema creation failed; out of memory\r\n");
        return(FALSE);
    }

    for (i = 0; result && HulaAttributes[i].name; i++) {
        result = MDBDefineAttribute(HulaAttributes[i].name, NULL, 
                (HulaAttributes[i].flags & HULA_ATTRIBUTE_FLAG_DN)? MDB_ATTR_SYN_DIST_NAME: MDB_ATTR_SYN_STRING, 
                (HulaAttributes[i].flags & HULA_ATTRIBUTE_FLAG_SINGLE_VALUE)? TRUE: FALSE, 
                (HulaAttributes[i].flags & HULA_ATTRIBUTE_FLAG_IMMEDIATE_SYNC)? TRUE: FALSE, 
                (HulaAttributes[i].flags & HULA_ATTRIBUTE_FLAG_PUBLIC)? TRUE: FALSE, 
                v);

        if (!result && (v->ErrNo == ERR_ATTRIBUTE_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Attribute \"%s\" defined.\r\n", HulaAttributes[i].name);

                continue;
            }

            XplConsolePrintf("  Attribute \"%s\" failed to define; error %lu\r\n", HulaAttributes[i].name, v->ErrNo);
        }
    }

    for (i = 0; result && HulaClasses[i].name; i++) {
        if (HulaClasses[i].superClass == NULL) {
            continue;
        }

        MDBFreeValues(optional);
        MDBFreeValues(mandatory);
        MDBFreeValues(naming);
        MDBFreeValues(containment);
        MDBFreeValues(superClass);

        MDBAddValue(HulaClasses[i].superClass, superClass);

        for (j = 0; HulaClasses[i].containment[j]; j++) {
            MDBAddValue(HulaClasses[i].containment[j], containment);
        }

        if (HulaClasses[i].naming) {
            MDBAddValue(HulaClasses[i].naming, naming);
        }

        for (j = 0; HulaClasses[i].mandatory[j]; j++) {
            MDBAddValue(HulaClasses[i].mandatory[j], mandatory);
        }

        result = MDBDefineClass(HulaClasses[i].name, NULL, (HulaClasses[i].flags & HULA_CLASS_FLAG_CONTAINER)? TRUE: FALSE, 
                superClass, containment, naming, mandatory, optional, v);

        if (!result && (v->ErrNo == ERR_CLASS_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            XplConsolePrintf("  Class \"%s\"\r\n    SuperClass \"%s\"\r\n", HulaClasses[i].name, superClass->Value[0]);

            if (naming->Used) {
                XplConsolePrintf("    Naming \"%s\"\r\n", naming->Value[0]);
            } else {
                XplConsolePrintf("    Naming is inherited.\r\n");
            }

            for (j = 0; j < mandatory->Used; j++) {
                XplConsolePrintf("    Mandatory \"%s\"\r\n", mandatory->Value[j]);
            }

            for (j = 0; j < optional->Used; j++) {
                XplConsolePrintf("    Optional \"%s\"\r\n", optional->Value[j]);
            }

            if (result) {
                XplConsolePrintf("    Defined Successfully.\r\n");

                continue;
            }

            XplConsolePrintf("    Failed to define, error %lu\r\n", v->ErrNo);
        }
    }

    for (i = 0; result && HulaClasses[i].name; i++) {
        for (j = 0; result && HulaAttributes[j].name; j++) {
            for (k = 0; result && (k < 2); k++) {
                if (HulaAttributes[j].attributes.optional[k] & HulaClasses[i].classes[k]) {
                    result = MDBAddAttribute(HulaAttributes[j].name, HulaClasses[i].name, v);
                    if (!result && (v->ErrNo == ERR_DUPLICATE_OPTIONAL)) {
                        result = TRUE;
                    }

                    if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                        if (result) {
                            XplConsolePrintf("  Add optional \"%s\" to \"%s\" succeeded.\r\n", HulaAttributes[j].name, HulaClasses[i].name);

                            continue;
                        }

                        XplConsolePrintf("  Add optional \"%s\" to \"%s\" failed; error %lu.\r\n", HulaAttributes[j].name, HulaClasses[i].name, v->ErrNo);
                    }
                }
            }
        }
    }

    for (i = 0; result && HulaClasses[i].name; i++) {
        for (j = 0; result && HulaSpecialAttributes[j].name; j++) {
            for (k = 0; result && (k < 2); k++) {
                if (HulaSpecialAttributes[j].attributes.optional[k] & HulaClasses[i].classes[k]) {
                    result = MDBAddAttribute(HulaSpecialAttributes[j].name, HulaClasses[i].name, v);
                    if (!result && (v->ErrNo == ERR_DUPLICATE_OPTIONAL)) {
                        result = TRUE;
                    }

                    if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                        if (result) {
                            XplConsolePrintf("  Add optional \"%s\" to \"%s\" succeeded.\r\n", HulaSpecialAttributes[j].name, HulaClasses[i].name);

                            continue;
                        }

                        XplConsolePrintf("  Add optional \"%s\" to \"%s\" failed; error %lu.\r\n", HulaSpecialAttributes[j].name, HulaClasses[i].name, v->ErrNo);
                    }
                }
            }
        }
    }

    if (optional) {
        MDBDestroyValueStruct(optional);
        optional = NULL;
    }

    if (mandatory) {
        MDBDestroyValueStruct(mandatory);
        mandatory = NULL;
    }

    if (naming) {
        MDBDestroyValueStruct(naming);
        naming = NULL;
    }

    if (containment) {
        MDBDestroyValueStruct(containment);
        containment = NULL;
    }

    if (superClass) {
        MDBDestroyValueStruct(superClass);
        superClass = NULL;
    }

    if (v) {
        MDBDestroyValueStruct(v);
        v = NULL;
    }

    return(result);
}

static BOOL 
AddHierarchy(void)
{
    unsigned char object[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char grantee[MDB_MAX_OBJECT_CHARS + 1];
    BOOL result = FALSE;
    MDBValueStruct *v;
    MDBValueStruct *attribute = NULL;
    MDBValueStruct *data = NULL;

    v = MDBCreateValueStruct(HulaSetup.directoryHandle, NULL);
    if (v) {
        attribute = MDBShareContext(v);
        data = MDBShareContext(v);

        if (attribute && data) {
            result = TRUE;
        }
    }

    if ((result) && (MDBIsObject(MSGSRV_ROOT, v) == FALSE)) {
        result = MDBCreateObject(MSGSRV_ROOT, MSGSRV_C_ROOT, attribute, data, v);
        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\" successfully.\r\n", MSGSRV_ROOT);
            } else {
                XplConsolePrintf("  Create \"%s\" failed; error %lu.\r\n", MSGSRV_ROOT, v->ErrNo);
            }
        }

        if (result) {
            sprintf(object, "%s\\", HulaSetup.host.tree);
	        sprintf(grantee, "%s\\%s", HulaSetup.host.tree, MSGSRV_ROOT);
	        result = MDBGrantObjectRights(object, grantee, TRUE, TRUE, TRUE, TRUE, TRUE, v);

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Access for \"%s\" to \"%s\" assigned.\r\n", object, grantee);
                } else {
                    XplConsolePrintf("  Access for \"%s\" to \"%s\" failed; error %lu.\r\n", object, grantee, v->ErrNo);
                }
            }
        }

        if (result) {
            result = MDBGrantAttributeRights(object, NULL, grantee, TRUE, TRUE, TRUE, v);

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Access for \"%s\" to \"%s\" values assigned.\r\n", object, grantee);
                } else {
                    XplConsolePrintf("  Access for \"%s\" to \"%s\" values failed; error %lu.\r\n", object, grantee, v->ErrNo);
                }
            }
        }

        if (result) {
            sprintf(object, "%s\\%s", HulaSetup.host.tree, MSGSRV_ROOT);
            MDBSetValueStructContext(object, v);

            result = MDBCreateObject(MSGSRV_LIST_ROOT, MSGSRV_C_LISTCONTAINER, attribute, data, v);

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", object, MSGSRV_LIST_ROOT);
                } else {
                    XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", object, MSGSRV_LIST_ROOT, v->ErrNo);
                }
            }
        }

        if (result) {
            result = MDBCreateObject(MSGSRV_PARENT_ROOT, MSGSRV_C_PARENTCONTAINER, attribute, data, v);

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", object, MSGSRV_PARENT_ROOT);
                } else {
                    XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", object, MSGSRV_PARENT_ROOT, v->ErrNo);
                }
            }
        }

        if (result) {
            result = MDBCreateObject(MSGSRV_TEMPLATE_ROOT, MSGSRV_C_TEMPLATECONTAINER, attribute, data, v);

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", object, MSGSRV_TEMPLATE_ROOT);
                } else {
                    XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", object, MSGSRV_TEMPLATE_ROOT, v->ErrNo);
                }
            }
        }

        if (result) {
            sprintf(object, "%s\\%s\\%s", HulaSetup.host.tree, MSGSRV_ROOT, MSGSRV_TEMPLATE_ROOT);
            MDBSetValueStructContext(object, v);

            result = MDBCreateObject("WebAccess", MSGSRV_C_MODWEBTEMPLATE, attribute, data, v);

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Created \"%s\\WebAccess\" successfully.\r\n", object);
                } else {
                    XplConsolePrintf("  Create \"%s\\WebAccess\" failed; error %lu.\r\n", object, v->ErrNo);
                }
            }
        }

        if (result) {
            result = MDBCreateObject("Webmail", MSGSRV_C_MODWEBTEMPLATE, attribute, data, v);

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Created \"%s\\Webmail\" successfully.\r\n", object);
                } else {
                    XplConsolePrintf("  Create \"%s\\Webmail\" failed; error %lu.\r\n", object, v->ErrNo);
                }
            }
        }

        if (result) {
            result = MDBCreateObject("Aurora", MSGSRV_C_MODWEBTEMPLATE, attribute, data, v);

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Created \"%s\\Aurora\" successfully.\r\n", object);
                } else {
                    XplConsolePrintf("  Create \"%s\\Aurora\" failed; error %lu.\r\n", object, v->ErrNo);
                }
            }
        }
    } else if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
        if (result) {
            XplConsolePrintf("  Object \"%s\" exists.\r\n", MSGSRV_ROOT);
        } else {
            XplConsolePrintf("  Out of memory.\r\n");
        }
    }

    if (attribute) {
        MDBDestroyValueStruct(attribute);
        attribute = NULL;
    }

    if (data) {
        MDBDestroyValueStruct(data);
        data = NULL;
    }

    if (v) {
        MDBDestroyValueStruct(v);
        v = NULL;
    }

    return(result);
}

static BOOL 
CreateMessagingServer(unsigned char *BaseDN)
{
    int i;
    unsigned char buffer[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char root[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char context[MDB_MAX_OBJECT_CHARS + 1];
    BOOL result = FALSE;
    MDBValueStruct *v;
    MDBValueStruct *attribute = NULL;
    MDBValueStruct *data = NULL;

    if (!BaseDN) {
		sprintf(root, "%s\\%s", HulaSetup.host.tree, MSGSRV_ROOT);
    } else if (BaseDN[0] != '\\') {
    	sprintf(root, "%s\\%s", HulaSetup.host.tree, BaseDN);
    } else {
        strcpy(root, BaseDN);
    }

    v = MDBCreateValueStruct(HulaSetup.directoryHandle, NULL);
    if (v) {
        attribute = MDBShareContext(v);
        data = MDBShareContext(v);

        if (attribute && data) {
            result = TRUE;
        }
    }

    MDBSetValueStructContext(root, v);

    if (result) {
	    if (HulaSetup.user.name[0] != '\\') {
		    sprintf(buffer, "%s\\%s", HulaSetup.host.tree, HulaSetup.user.name);

		    MDBAddDNAttribute(MSGSRV_A_POSTMASTER, buffer, attribute, data);
	    } else {
		    MDBAddDNAttribute(MSGSRV_A_POSTMASTER, HulaSetup.user.name, attribute, data);
	    }

        MDBAddDNAttribute(MSGSRV_A_HOST, HulaSetup.host.dn, attribute, data);

    	sprintf(context, "%s\\%s", HulaSetup.host.tree, HulaSetup.host.context);
        MDBAddDNAttribute(MSGSRV_A_CONTEXT, context, attribute, data);

        MDBAddStringAttribute(MSGSRV_A_OFFICIAL_NAME, HulaSetup.domain, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_WORK_DIRECTORY, XPL_DEFAULT_WORK_DIR, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_DBF_DIRECTORY, XPL_DEFAULT_DBF_DIR, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_NLS_DIRECTORY, XPL_DEFAULT_NLS_DIR, attribute, data);

        sprintf(buffer, "%d", SSL_ALLOW_SSL3);
        MDBAddStringAttribute(MSGSRV_A_SSL_OPTIONS, buffer, attribute, data);

        for (i = 0; i < HulaSetup.dns.count; i++) {
		    MDBAddStringAttribute(MSGSRV_A_RESOLVER, HulaSetup.dns.servers[i], attribute, data);
        }

        result = MDBCreateObject(HulaSetup.server, MSGSRV_C_SERVER, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", root, HulaSetup.server);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", root, HulaSetup.server, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);
    }

	sprintf(context, "%s\\%s", root, HulaSetup.server);
    MDBSetValueStructContext(context, v);

    if (result) {
    	MDBClear(HulaSetup.host.dn, MSGSRV_A_MESSAGING_SERVER, v);

        MDBAddValue(context, v);

        i = MDBWriteDN(HulaSetup.host.dn, MSGSRV_A_HULA_MESSAGING_SERVER, v);

        if (!i || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (i) {
                XplConsolePrintf("  Associated \"%s\" and \"%s\\%s\" successfully.\r\n", HulaSetup.host.dn, root, HulaSetup.server);
            } else {
                XplConsolePrintf("  Associating \"%s\" and \"%s\\%s\" failed; error %lu.\r\n", HulaSetup.host.dn, root, HulaSetup.server, v->ErrNo);
            }
        }

        MDBFreeValues(v);
    }

    if (attribute) {
        MDBDestroyValueStruct(attribute);
        attribute = NULL;
    }

    if (data) {
        MDBDestroyValueStruct(data);
        data = NULL;
    }

    if (v) {
        MDBDestroyValueStruct(v);
        v = NULL;
    }

    return(result);
}

static BOOL 
CreateMessagingAgents(unsigned char *Server)
{
    unsigned long a;
    unsigned long useCount;
    unsigned char buffer[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char webAccess[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char webMail[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char aurora[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char dn[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char nmapDN[MDB_MAX_OBJECT_CHARS + 1];
    BOOL result = FALSE;
    MDBValueStruct *v;
    MDBValueStruct *attribute = NULL;
    MDBValueStruct *data = NULL;
    MDBValueStruct *nmap = NULL;

    if (Server[0] == '\\') {
        strcpy(dn, Server);
    } else {
        sprintf(dn, "%s\\%s\\%s", HulaSetup.host.tree, MSGSRV_ROOT, Server);
    }

    v = MDBCreateValueStruct(HulaSetup.directoryHandle, NULL);
    if (v) {
        attribute = MDBShareContext(v);
        data = MDBShareContext(v);
        nmap = MDBShareContext(v);

        if (attribute && data && nmap) {
            result = TRUE;
        }
    }

	MDBSetValueStructContext(dn, v);

    if (result && (HulaSetup.agents & HULA_AGENT_NMAP)) {
    	sprintf(nmapDN, "%s\\%s", dn, MSGSRV_AGENT_NMAP);

        MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_NMAP, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_QUEUE_TIMEOUT, "5", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_QUEUE_INTERVAL, "30", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MINIMUM_SPACE, "2048", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_SCMS_USER_THRESHOLD, "5", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_SCMS_SIZE_THRESHOLD, "5", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_QUOTA_MESSAGE, DEFAULT_QUOTA_MESSAGE, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MESSAGE_STORE, XPL_DEFAULT_MAIL_DIR, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_SCMS_DIRECTORY, XPL_DEFAULT_SCMS_DIR, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_SPOOL_DIRECTORY, XPL_DEFAULT_SPOOL_DIR, attribute, data);

        result = MDBCreateObject(MSGSRV_AGENT_NMAP, MSGSRV_C_NMAP, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_NMAP);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_NMAP, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);
    }

    if (result && (HulaSetup.agents & HULA_AGENT_ADDRESS_BOOK) && (HulaSetup.agents & HULA_AGENT_NMAP)) {
        sprintf(buffer, "%lu", HulaSetup.ports.ldap);

        MDBAddStringAttribute(MSGSRV_A_PORT, buffer, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_ADDRESSBOOK, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_LDAP_OPTIONS, "1", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_TIME_INTERVAL, "1", attribute, data);

        MDBAddDNAttribute(MSGSRV_A_NMAP_SERVER, nmapDN, attribute, data);

        result = MDBCreateObject(MSGSRV_AGENT_ADDRESSBOOK, MSGSRV_C_ADDRESSBOOK, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (result) {
            MDBAddValue(MSGSRV_AGENT_ADDRESSBOOK, nmap);
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_ADDRESSBOOK);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_ADDRESSBOOK, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);
    }

    if (result && (HulaSetup.agents & HULA_AGENT_ALIAS) && (HulaSetup.agents & HULA_AGENT_NMAP)) {
        MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_ALIAS, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_ALIAS_OPTIONS, "0", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_TIME_INTERVAL, "1", attribute, data);

        MDBAddDNAttribute(MSGSRV_A_NMAP_SERVER, nmapDN, attribute, data);

        result = MDBCreateObject(MSGSRV_AGENT_ALIAS, MSGSRV_C_ALIAS, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (result) {
            MDBAddValue(MSGSRV_AGENT_ALIAS, nmap);
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_ALIAS);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_ALIAS, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);
    }

    if (result && (HulaSetup.agents & HULA_AGENT_ANTISPAM) && (HulaSetup.agents & HULA_AGENT_NMAP)) {
        MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_ANTISPAM, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);

        MDBAddDNAttribute(MSGSRV_A_NMAP_SERVER, nmapDN, attribute, data);

        result = MDBCreateObject(MSGSRV_AGENT_ANTISPAM, MSGSRV_C_ANTISPAM, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (result) {
            MDBAddValue(MSGSRV_AGENT_ANTISPAM, nmap);
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_ANTISPAM);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_ANTISPAM, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);
    }

    if (result && (HulaSetup.agents & HULA_AGENT_CALENDAR) && (HulaSetup.agents & HULA_AGENT_NMAP)) {
        MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_CALAGENT, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);

        MDBAddDNAttribute(MSGSRV_A_NMAP_SERVER, nmapDN, attribute, data);

        result = MDBCreateObject(MSGSRV_AGENT_CALAGENT, MSGSRV_C_CALAGENT, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (result) {
            MDBAddValue(MSGSRV_AGENT_CALAGENT, nmap);
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_CALAGENT);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_CALAGENT, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);
    }

    if (result && (HulaSetup.agents & HULA_AGENT_FORWARD) && (HulaSetup.agents & HULA_AGENT_NMAP)) {
        MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_FORWARD, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);

        MDBAddDNAttribute(MSGSRV_A_NMAP_SERVER, nmapDN, attribute, data);

        result = MDBCreateObject(MSGSRV_AGENT_AUTOREPLY, MSGSRV_C_AUTOREPLY, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (result) {
            MDBAddValue(MSGSRV_AGENT_AUTOREPLY, nmap);
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_AUTOREPLY);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_AUTOREPLY, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);
    }

    if (result && (HulaSetup.agents & HULA_AGENT_IMAP)) {
        MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_IMAP, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);
	
	sprintf(buffer, "Port=%lu", HulaSetup.ports.imap.clear);
	MDBAddStringAttribute(MSGSRV_A_CONFIGURATION, buffer, attribute, data);

	sprintf(buffer, "SecurePort=%lu", HulaSetup.ports.imap.secure);
	MDBAddStringAttribute(MSGSRV_A_CONFIGURATION, buffer, attribute, data);

        MDBAddDNAttribute(MSGSRV_A_NMAP_SERVER, nmapDN, attribute, data);

        result = MDBCreateObject(MSGSRV_AGENT_IMAP, MSGSRV_C_IMAP, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_IMAP);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_IMAP, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);
    }

    if (result && (HulaSetup.agents & HULA_AGENT_MODWEB) && (HulaSetup.agents & HULA_AGENT_NMAP)) {
        MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_MODWEB, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_TITLE, "Hula", attribute, data);

        sprintf(buffer, "%lu", HulaSetup.ports.http);
        MDBAddStringAttribute(MSGSRV_A_PORT, buffer, attribute, data);

        sprintf(buffer, "%lu", HulaSetup.ports.https);
        MDBAddStringAttribute(MSGSRV_A_SSL_PORT, buffer, attribute, data);

        sprintf(webAccess, "%s\\%s\\%s\\WebAccess", HulaSetup.host.tree, MSGSRV_ROOT, MSGSRV_TEMPLATE_ROOT);
        MDBAddDNAttribute(MSGSRV_A_TEMPLATE, webAccess, attribute, data);

        sprintf(webMail, "%s\\%s\\%s\\Webmail", HulaSetup.host.tree, MSGSRV_ROOT, MSGSRV_TEMPLATE_ROOT);
        MDBAddDNAttribute(MSGSRV_A_TEMPLATE, webMail, attribute, data);

        sprintf(aurora, "%s\\%s\\%s\\Aurora", HulaSetup.host.tree, MSGSRV_ROOT, MSGSRV_TEMPLATE_ROOT);
        MDBAddDNAttribute(MSGSRV_A_TEMPLATE, aurora, attribute, data);

        MDBAddDNAttribute(MSGSRV_A_DEFAULT_TEMPLATE, aurora, attribute, data);

        result = MDBCreateObject(MSGSRV_AGENT_MODWEB, MSGSRV_C_MODWEB, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_MODWEB);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_MODWEB, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);

        sprintf(buffer, "%s\\%s", dn, MSGSRV_AGENT_MODWEB);
        MDBSetValueStructContext(buffer, v);

        if (result) {
            MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_MWMAIL_MODULE, attribute, data);
            MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);

            MDBAddDNAttribute(MSGSRV_A_NMAP_QUEUE_SERVER, nmapDN, attribute, data);

            result = MDBCreateObject(MSGSRV_AGENT_MWMAIL, MSGSRV_C_MWMAIL_MODULE, attribute, data, v);

            if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
                result = TRUE;
            }

            if (result) {
                MDBAddValue(MSGSRV_AGENT_MODWEB"\\"MSGSRV_AGENT_MWMAIL, nmap);
            }

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Created \"%s\\%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_MODWEB, MSGSRV_AGENT_MWMAIL);
                } else {
                    XplConsolePrintf("  Create \"%s\\%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_MODWEB, MSGSRV_AGENT_MWMAIL, v->ErrNo);
                }
            }

            MDBFreeValues(attribute);
            MDBFreeValues(data);
        }

        if (result) {
            MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_MWCAL_MODULE, attribute, data);
            MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);

            MDBAddDNAttribute(MSGSRV_A_NMAP_QUEUE_SERVER, nmapDN, attribute, data);

            result = MDBCreateObject(MSGSRV_AGENT_MWCAL, MSGSRV_C_MWCAL_MODULE, attribute, data, v);

            if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
                result = TRUE;
            }

            if (result) {
                MDBAddValue(MSGSRV_AGENT_MODWEB"\\"MSGSRV_AGENT_MWCAL, nmap);
            }

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Created \"%s\\%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_MODWEB, MSGSRV_AGENT_MWCAL);
                } else {
                    XplConsolePrintf("  Create \"%s\\%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_MODWEB, MSGSRV_AGENT_MWCAL, v->ErrNo);
                }
            }

            MDBFreeValues(attribute);
            MDBFreeValues(data);
        }

        if (result) {
            MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_MWPREF_MODULE, attribute, data);
            MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);
            MDBAddStringAttribute(MSGSRV_A_PASSWORD_CONFIGURATION, "1", attribute, data);

            result = MDBCreateObject(MSGSRV_AGENT_MWPREF, MSGSRV_C_MWPREF_MODULE, attribute, data, v);

            if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
                result = TRUE;
            }

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Created \"%s\\%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_MODWEB, MSGSRV_AGENT_MWPREF);
                } else {
                    XplConsolePrintf("  Create \"%s\\%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_MODWEB, MSGSRV_AGENT_MWPREF, v->ErrNo);
                }
            }

            MDBFreeValues(attribute);
            MDBFreeValues(data);
        }

        if (result) {
            MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_MWTOM_MODULE, attribute, data);
            MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);

            result = MDBCreateObject(MSGSRV_AGENT_MWTOM, MSGSRV_C_MWTOM_MODULE, attribute, data, v);

            if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
                result = TRUE;
            }

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Created \"%s\\%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_MODWEB, MSGSRV_AGENT_MWTOM);
                } else {
                    XplConsolePrintf("  Create \"%s\\%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_MODWEB, MSGSRV_AGENT_MWTOM, v->ErrNo);
                }
            }

            MDBFreeValues(attribute);
            MDBFreeValues(data);
        }

        MDBSetValueStructContext(dn, v);
    }

    if (result && (HulaSetup.agents & HULA_AGENT_POP)) {
        MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_POP, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);

        sprintf(buffer, "Port=%lu", HulaSetup.ports.pop3.clear);
        MDBAddStringAttribute(MSGSRV_A_CONFIGURATION, buffer, attribute, data);

        sprintf(buffer, "SecurePort=%lu", HulaSetup.ports.pop3.secure);
        MDBAddStringAttribute(MSGSRV_A_CONFIGURATION, buffer, attribute, data);

        MDBAddDNAttribute(MSGSRV_A_NMAP_SERVER, nmapDN, attribute, data);

        result = MDBCreateObject(MSGSRV_AGENT_POP, MSGSRV_C_POP, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_POP);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_POP, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);
    }

    if (result && (HulaSetup.agents & HULA_AGENT_PROXY) && (HulaSetup.agents & HULA_AGENT_NMAP)) {
        MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_PROXY, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_TIME_INTERVAL, "3", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MAXIMUM_ITEMS, "3", attribute, data);

        MDBAddDNAttribute(MSGSRV_A_NMAP_SERVER, nmapDN, attribute, data);
        MDBAddDNAttribute(MSGSRV_A_NMAP_QUEUE_SERVER, nmapDN, attribute, data);

        result = MDBCreateObject(MSGSRV_AGENT_PROXY, MSGSRV_C_PROXY, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (result) {
            MDBAddValue(MSGSRV_AGENT_PROXY, nmap);
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_PROXY);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_PROXY, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);
    }

    if (result && (HulaSetup.agents & HULA_AGENT_RULESRV) && (HulaSetup.agents & HULA_AGENT_NMAP)) {
        MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_RULESRV, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);

        MDBAddDNAttribute(MSGSRV_A_NMAP_SERVER, nmapDN, attribute, data);

        result = MDBCreateObject(MSGSRV_AGENT_RULESRV, MSGSRV_C_RULESRV, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (result) {
            MDBAddValue(MSGSRV_AGENT_RULESRV, nmap);
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_RULESRV);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_RULESRV, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);
    }

    if (result && (HulaSetup.agents & HULA_AGENT_SMTP) && (HulaSetup.agents & HULA_AGENT_NMAP)) {
        MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_SMTP, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_DOMAIN, HulaSetup.domain, attribute, data);
        MDBAddStringAttribute(MSGSRV_A_ROUTING, "0", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_MESSAGE_LIMIT, "0", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_SMTP_ACCEPT_ETRN, "1", attribute, data);
        MDBAddStringAttribute(MSGSRV_A_SMTP_SEND_ETRN, "0", attribute, data);

        sprintf(buffer, "Port=%lu", HulaSetup.ports.smtp.clear);
        MDBAddStringAttribute(MSGSRV_A_CONFIGURATION, buffer, attribute, data);

        sprintf(buffer, "SecurePort=%lu", HulaSetup.ports.smtp.secure);
        MDBAddStringAttribute(MSGSRV_A_CONFIGURATION, buffer, attribute, data);

        MDBAddDNAttribute(MSGSRV_A_NMAP_SERVER, nmapDN, attribute, data);
        MDBAddDNAttribute(MSGSRV_A_NMAP_QUEUE_SERVER, nmapDN, attribute, data);

        result = MDBCreateObject(MSGSRV_AGENT_SMTP, MSGSRV_C_SMTP, attribute, data, v);

        if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
            result = TRUE;
        }

        if (result) {
            MDBAddValue(MSGSRV_AGENT_SMTP, nmap);
        }

        if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
            if (result) {
                XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_SMTP);
            } else {
                XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_SMTP, v->ErrNo);
            }
        }

        MDBFreeValues(attribute);
        MDBFreeValues(data);

        if (result && (HulaSetup.agents & HULA_AGENT_CONNMGR)) {
            MDBAddStringAttribute(MSGSRV_A_MODULE_NAME, MSGSRV_NLM_CONNMGR, attribute, data);
            MDBAddStringAttribute(MSGSRV_A_MODULE_VERSION, "1", attribute, data);
            MDBAddStringAttribute(MSGSRV_A_TIMEOUT,"15", attribute, data);

            result = MDBCreateObject(MSGSRV_AGENT_CONNMGR, MSGSRV_C_CONNMGR, attribute, data, v);

            if (!result && (v->ErrNo == ERR_ENTRY_ALREADY_EXISTS)) {
                result = TRUE;
            }

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, MSGSRV_AGENT_CONNMGR);
                } else {
                    XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, MSGSRV_AGENT_CONNMGR, v->ErrNo);
                }
            }

            MDBFreeValues(attribute);
            MDBFreeValues(data);

            if (result) {
                sprintf(buffer, "%s\\%s", dn, MSGSRV_AGENT_CONNMGR); 
                MDBAddValue(buffer, data);

                MDBWrite(dn, MSGSRV_A_CONNMGR, data);
                MDBFreeValues(data);

#if 0
                MDBAddValue("1", data);
                MDBWrite(dn, MSGSRV_A_CONNMGR_CONFIG, data);
                MDBFreeValues(data);
#endif

                MDBAddValue("9", data); 
                sprintf(buffer, "%s\\%s", dn, MSGSRV_AGENT_SMTP);
                MDBWrite(buffer, MSGSRV_A_UBE_CONFIGURATION, data); 
		
                MDBFreeValues(attribute);
                MDBFreeValues(data);
            }
        }
    }

    if (result && (HulaSetup.agents & HULA_AGENT_WEBADMIN)) {
        unsigned char buffer[MDB_MAX_OBJECT_CHARS + 1];
        MDBSetValueStructContext(HulaSetup.host.context, v);

        useCount = 0;

        result = MDBIsObject(HulaSetup.webAdmin, v);
	    if (!result) {
		    result = MDBCreateObject(HulaSetup.webAdmin, WA_C_SERVER_OBJECT, attribute, data, v);

            if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
                if (result) {
                    XplConsolePrintf("  Created \"%s\\%s\" successfully.\r\n", dn, HulaSetup.webAdmin);
                } else {
                    XplConsolePrintf("  Create \"%s\\%s\" failed; error %lu.\r\n", dn, HulaSetup.webAdmin, v->ErrNo);
                }
            }

            if (result) {
		        MDBAddValue(HulaSetup.webAdmin, v);

                MDBWriteDN(HulaSetup.host.dn, WA_A_CONFIG_DN, v);
            }
	    } else {
		    MDBRead(HulaSetup.webAdmin, WA_A_CONFIG, v);

		    for (a = 0; a < v->Used; a++) {
			    if (QuickNCmp(v->Value[a], "UseCount:", 9)) {
				    useCount = atol(v->Value[a] + 9);

				    MDBFreeValue(a, v);
			    }
		    }
	    }

        MDBFreeValues(v);

        if (result) {
		    useCount++;
		    sprintf(buffer, "UseCount:%lu", useCount);

		    MDBAddValue(buffer, v);

		    MDBWrite(HulaSetup.webAdmin, WA_A_CONFIG, v);

            if (HulaSetup.actions & HULA_SETUP_VERBOSE) {
                XplConsolePrintf("  Update \"%s\\%s\" use count to %lu.\r\n", dn, HulaSetup.webAdmin, useCount);
            }

	    XplPrintHostIPAddress(buffer, sizeof(buffer));

	        MDBAddValue(buffer, v);
	        MDBWrite(HulaSetup.webAdmin, WA_A_ADDRESS, v);
	        MDBFreeValues(v);

	        MDBAddValue(MSGSRV_NLM_WEBADMIN, v);
	        MDBWrite(HulaSetup.webAdmin, MSGSRV_A_MODULE_NAME, v);
	        MDBFreeValues(v);

	        sprintf(buffer, "%lu", HulaSetup.ports.webAdmin.http);
	        MDBAddValue(buffer, v);
	        MDBWrite(HulaSetup.webAdmin, WA_A_PORT, v);
	        MDBFreeValues(v);

	        sprintf(buffer, "%lu", HulaSetup.ports.webAdmin.https);
	        MDBAddValue(buffer, v);
	        MDBWrite(HulaSetup.webAdmin, WA_A_SSLPORT, v);
	        MDBFreeValues(v);

	        MDBAddValue(XPL_DEFAULT_LIB_DIR, v);
	        MDBWrite(HulaSetup.webAdmin, WA_A_PATH, v);
	        MDBFreeValues(v);

	        MDBAddValue(XPL_DEFAULT_BIN_DIR "/webadmin/osslcert.pem", v);
	        MDBWrite(HulaSetup.webAdmin, WA_A_CERT_PATH, v);
	        MDBFreeValues(v);

	        MDBAddValue(XPL_DEFAULT_BIN_DIR "/webadmin/osslpriv.pem", v);
	        MDBWrite(HulaSetup.webAdmin, WA_A_KEY_PATH, v);
	        MDBFreeValues(v);
        }

        MDBSetValueStructContext(dn, v);
    }

    if (result && nmap->Used) {
        MDBSetValueStructContext(dn, nmap);

        sprintf(buffer, "%s\\%s", dn, MSGSRV_AGENT_NMAP);
        MDBWriteDN(buffer, MSGSRV_A_CLIENT, nmap);
    }

    if (nmap) {
        MDBDestroyValueStruct(nmap);
        nmap = NULL;
    }

    if (data) {
        MDBDestroyValueStruct(data);
        data = NULL;
    }

    if (attribute) {
        MDBDestroyValueStruct(attribute);
        attribute = NULL;
    }

    if (v) {
        MDBDestroyValueStruct(v);
        v = NULL;
    }

    return(result);
}

static void 
MakePath(unsigned char *Path)
{
    unsigned char delim;
    unsigned char *ptr = Path;
    unsigned char *ptr2;
    struct stat sb;

    ptr = strchr(Path, '/');
    if (!ptr) {
        ptr = strchr(Path, '\\');
    }

    while (ptr) {
        delim = *ptr;
        *ptr = '\0';

        if (stat(Path, &sb) != 0) {
            XplMakeDir(Path);
        }

        *ptr = delim;

        ptr2 = ++ptr;
        ptr = strchr(ptr2, '/');
        if (!ptr) {
            ptr = strchr(ptr2, '\\');
        }
    }

    if (stat(Path, &sb) != 0) {
        XplMakeDir(Path);
    }

    return;
}

static BOOL
AddV3Extension(X509 *Certificate, int nid, char *Value)
{
    X509_EXTENSION *extension;
    X509V3_CTX context;

    X509V3_set_ctx(&context, Certificate, Certificate, NULL, NULL, 0);

    extension = X509V3_EXT_conf_nid(NULL, &context, nid, Value);
    if (extension) {
        X509_add_ext(Certificate, extension, -1);
        X509_EXTENSION_free(extension);

        return(TRUE);
    }

    return(FALSE);
}

static void
GenerateCertificateCallback(int p, int n, void *arg)
{
	XplDelay(55);

	return;
}

static BOOL 
GenerateCertificate(unsigned char *Filename)
{
    unsigned char *ptr;
    unsigned char buffer[256];
    unsigned char path[XPL_MAX_PATH + 1];
    unsigned long length;
    X509 *cert;
    X509_NAME *name = NULL;
    EVP_PKEY *privateKey;
    RSA *rsaData;
    FILE *fh;

    SSL_load_error_strings();
    SSL_library_init();

    do {
        srand((unsigned) time(NULL));

        length = sprintf(buffer, "%d", rand());

        RAND_seed(buffer, length);
    } while (RAND_status() != 1);


    /* Generate a private key */
    if ((privateKey = EVP_PKEY_new()) == NULL) {
        EVP_cleanup();
        ERR_free_strings();

        return(FALSE);
    }

    if ((cert = X509_new()) == NULL) {
        EVP_PKEY_free(privateKey);
        EVP_cleanup();
        ERR_free_strings();

        return(FALSE);
    }

    rsaData = RSA_generate_key(512, RSA_F4, GenerateCertificateCallback, NULL);
    if (!EVP_PKEY_assign_RSA(privateKey, rsaData)) {
        X509_free(cert);
        EVP_PKEY_free(privateKey);
        EVP_cleanup();
        ERR_free_strings();

        return(FALSE);
    }

    rsaData = NULL;

    X509_set_version(cert, 2);
    ASN1_INTEGER_set(X509_get_serialNumber(cert), 0x27051977);
    X509_gmtime_adj(X509_get_notBefore(cert), 0);
    X509_gmtime_adj(X509_get_notAfter(cert), 86400*365);
    X509_set_pubkey(cert, privateKey);

    name = X509_get_subject_name(cert);
    /*  X509_NAME_add_entry_by_txt(name, "C", MBSTRING_ASC, "US", -1, -1, 0);   */

    if (gethostname(buffer, sizeof(buffer)) != 0) {
	XplPrintHostIPAddress(buffer, sizeof(buffer));
    }

    X509_NAME_add_entry_by_txt(name, "CN", MBSTRING_ASC, buffer, -1, -1, 0);

    X509_set_issuer_name(cert, name);

    AddV3Extension(cert, NID_basic_constraints, "critical,CA:TRUE");

    AddV3Extension(cert, NID_key_usage, "critical,digitalSignature,keyEncipherment,keyCertSign");

    AddV3Extension(cert, NID_subject_key_identifier, "hash");

    if (!X509_sign(cert, privateKey, EVP_md5())) {
        X509_free(cert);
        EVP_PKEY_free(privateKey);
        EVP_cleanup();
        ERR_free_strings();

        return(FALSE);
    }

    strcpy(path, Filename);
    ptr = strrchr(path, '/');
    if (*ptr) {
        *ptr = '\0';
    }

    MakePath(path);

    if (*ptr) {
        *ptr = '/';
    }

    if (access(path, 0) == 0) {
        X509_free(cert);
        EVP_PKEY_free(privateKey);
        EVP_cleanup();
        ERR_free_strings();

        return(FALSE);		
    }

    fh = fopen(path, "wb");
    if (!fh) {
        X509_free(cert);
        EVP_PKEY_free(privateKey);
        EVP_cleanup();
        ERR_free_strings();

        return(FALSE);
    }

    PEM_write_X509(fh, cert);
    fclose(fh);

    fh = fopen(XPL_DEFAULT_KEY_PATH, "wb");
    if (!fh) {
        X509_free(cert);
        EVP_PKEY_free(privateKey);
        EVP_cleanup();
        ERR_free_strings();

        return(FALSE);
    }

    PEM_write_PrivateKey(fh, privateKey, NULL, NULL, 0, NULL, NULL);
    fclose(fh);

    X509_free(cert);
    EVP_PKEY_free(privateKey);
    EVP_cleanup();
    ERR_free_strings();

    return(TRUE);
}

static int 
GenerateCredential(unsigned char *Out, int OutLength, BOOL ASCIIOnly)
{
    unsigned int i;
    int j;
    unsigned char digest[16];
    MD5_CTX context;

    XplGetHighResolutionTime(i);

    srand(i);

    MD5_Init(&context);

    i = sprintf(digest, "%d", i);

    for ( ; i < sizeof(digest) - 1; ) {
        j = rand() % 0xFF;
        if (j) {
            digest[i] = (unsigned char)j;
            digest[++i] = '\0';
        }
    }

    MD5_Update(&context, digest, i - 1);

    if (HulaSetup.user.x500Name[0]) {
        MD5_Update(&context, HulaSetup.user.x500Name, strlen(HulaSetup.user.x500Name));
    }

    for (i = 0; i < (OutLength - 1); ) {
        j = rand() % 0xFF;
        if (j) {
            Out[i] = (unsigned char)j;
            Out[++i] = '\0';
        }
    }

    Out[OutLength - 1] = '\0';

    MD5_Update(&context, Out, OutLength - 1);

    if (HulaSetup.user.password[0]) {
        MD5_Update(&context, HulaSetup.user.password, strlen(HulaSetup.user.password));
    }

    MD5_Final(digest, &context);

    RAND_seed(digest, sizeof(digest));

    RAND_bytes(Out, OutLength);

    for (i = 0, j = (4 * 1024); (i < OutLength) && j; ) {
        if (Out[i] 
                && (Out[i] != '\r') && (Out[i] != '\n') 
                && (!ASCIIOnly || (isalpha(Out[i])))) {
            i++;

            j = (4 * 1024);

            continue;
        }

        RAND_bytes(&(Out[i]), 1);

        if (--j) {
            continue;
        }

        XplConsolePrintf("  Credential generator failed; too many retries.\r\n");
    }

    Out[OutLength - 1] = '\0';

    return(i);
}

static BOOL 
SetDirectoryCredential(void)
{
    int i;
    unsigned char path[XPL_MAX_PATH + 1];
    unsigned char password[128];
    BOOL result = FALSE;
    FILE *eclients = NULL;
    MDBValueStruct *v;

    strcpy(path, XPL_DEFAULT_DBF_DIR);
    MakePath(path);

    sprintf(path, "%s/eclients.dat", XPL_DEFAULT_DBF_DIR);

    v = MDBCreateValueStruct(HulaSetup.directoryHandle, NULL);
    if (v != NULL) {
        if (GenerateCredential(password, sizeof(password), FALSE) == sizeof(password)) {
            if (MDBReadDN(HulaSetup.host.dn, MSGSRV_A_HULA_MESSAGING_SERVER, v)) {
                result = MDBChangePasswordEx(v->Value[0], NULL, password, v);
                if (result == TRUE) {
                    result = FALSE;

                    eclients = fopen(path, "wb");
                    if (eclients) {
                        i = fwrite(password, sizeof(unsigned char), sizeof(password), eclients);

                        fclose(eclients);
                        eclients = NULL;

                        if (i == sizeof(password)) {
                            result = TRUE;
                        }
                    }

                    if (!result) {
                        unlink(path);
                    }
                }
            }
        }

        MDBDestroyValueStruct(v);
    }

    if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
        if (result) {
            XplConsolePrintf("  Generated MDB credential successfully.\r\n");
        } else {
            XplConsolePrintf("  Failed to generate an MDB credentail.\r\n");
        }
    }

    return(result);
}

static BOOL 
SetServerCredential(void)
{
    unsigned char password[NMAP_CREDENTIAL_SIZE + 1];
    BOOL result = FALSE;
    MDBValueStruct *v;

    v = MDBCreateValueStruct(HulaSetup.directoryHandle, NULL);
    if (v != NULL) {
#if 0
        if ((GenerateCredential(password, sizeof(password), TRUE) == sizeof(password)) 
                && (MDBAddValue(password, v) == 1)) {
            result = MDBWrite(MSGSRV_ROOT, MSGSRV_A_ACL, v);
        }
#else
        if (GenerateCredential(password, sizeof(password), TRUE) == sizeof(password)) {
            memcpy(password, "37b29c170g17d70e399e2bd704a4062e", 32);

            if (MDBAddValue(password, v) == 1) {
                result = MDBWrite(MSGSRV_ROOT, MSGSRV_A_ACL, v);
            }
        }

#endif

        MDBDestroyValueStruct(v);
    }

    if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
        if (result) {
            XplConsolePrintf("  Generated NMAP credential successfully.\r\n");
        } else {
            XplConsolePrintf("  Failed to generate an NMAP credentail.\r\n");
        }
    }

    return(result);
}

static void
X500ToMDBUserName(unsigned char *X500Name, unsigned char *MDBName)
{
    unsigned char *src;
    unsigned char *dest;
    unsigned char *ptr;
    BOOL checkTree;

    strcpy(MDBName, HulaSetup.host.tree);

    dest = MDBName + strlen(MDBName);

    checkTree = TRUE;
    do {
        src = strrchr(X500Name, '.');
        if (src) {
            if (checkTree && (XplStrCaseCmp(src + 1, HulaSetup.host.tree + 1) == 0)) {
                checkTree = FALSE;

                *src = '\0';
                continue;
            }

            ptr = src + 1;
        } else {
            ptr = X500Name;
        }

        if (ptr[1] == '=') {
            ptr += 2;
        } else if (ptr[2] == '=') {
            ptr += 3;
        }

        *dest++ = '\\';
        strcpy(dest, ptr);

        dest += strlen(ptr);

        checkTree = FALSE;

        if (src) {
            *src = '\0';
        }
    } while (src > X500Name);
}

static BOOL 
SetAssociations(void)
{
    unsigned char server[MDB_MAX_OBJECT_CHARS + 1];
    unsigned char host[MDB_MAX_OBJECT_CHARS + 1];
    BOOL result;
    MDBValueStruct *v;

    X500ToMDBUserName(HulaSetup.associate.host, host);
    X500ToMDBUserName(HulaSetup.associate.server, server);

    v = MDBCreateValueStruct(HulaSetup.directoryHandle, NULL);
    if (v) {
    	result = MDBClear(host, MSGSRV_A_MESSAGING_SERVER, v);
    	result = MDBClear(host, MSGSRV_A_HULA_MESSAGING_SERVER, v);

        MDBAddValue(server, v);

        if (MDBWriteDN(host, MSGSRV_A_MESSAGING_SERVER, v) == 1) {
            MDBFreeValues(v);

            MDBAddValue(host, v);

            if (MDBWriteDN(server, MSGSRV_A_HOST, v) == 1) {
                result = TRUE;
            }
        }

        MDBDestroyValueStruct(v);
        v = NULL;
    } else {
        result = FALSE;
    }

    if (!result || (HulaSetup.actions & HULA_SETUP_VERBOSE)) {
        if (result) {
            XplConsolePrintf("  Set \"%s\" as hosted by \"%s\" successfully.\r\n", server, host);
        } else {
            XplConsolePrintf("  Set \"%s\" as hosted by \"%s\" failed; error %lu\r\n", server, host, v->ErrNo);
        }
    }

    return(result);
}

static void 
HulaSetupUsage(void)
{
    XplConsolePrintf("hulasetup - Hula Configuration Utility\r\n");
    XplConsolePrintf("usage: hulasetup --domain=<name> [-u=<> -t=<>] []\r\n");
    XplConsolePrintf("  --help                 Help.  Display this screen.\r\n");
    XplConsolePrintf("  -a | --agents          Creates the following Hula agent objects:\r\n");
    XplConsolePrintf("                         Anti-Spam, Calendaring, Forward, Connection Manager\r\n");
    XplConsolePrintf("                         IMAP Server, POP3 Server, Modular Web Server\r\n");
    XplConsolePrintf("                         Mail Proxy, Rules Server and SMTP Server\r\n");
    XplConsolePrintf("  --certificate          Generate a self signed OpenSSL certificate.\r\n");
    XplConsolePrintf("  -c= | --create=<agent> Create a Hula agent objects where <agent> is:\r\n");
    XplConsolePrintf("                             addressbook     alias           antispam\r\n");
    XplConsolePrintf("                             calendar        connection      forward\r\n");
    XplConsolePrintf("                             imap            modweb          nmap\r\n");
    XplConsolePrintf("                             pluspack        pop             proxy\r\n");
    XplConsolePrintf("                             rules           smtp            webadmin\r\n");
    XplConsolePrintf("  --credential=<type>    Generate an access credential where <type> is:\r\n");
    XplConsolePrintf("                             directory       server\r\n");
    XplConsolePrintf("  --dns=<host[:host]>    Address, or domain name, to be used.  Up to three\r\n");
    XplConsolePrintf("                         domain name servers may be specified.\r\n");
    XplConsolePrintf("  --domain=<name>        The official messaging domain name to be used.\r\n");
    XplConsolePrintf("                         Defaults to localhost.localdomain\r\n");
    XplConsolePrintf("  -p= | --pass=<text>    The password used for MDB authentication.\r\n");
    XplConsolePrintf("  --host=<server:name>   The X500 host and messaging server to associate.\r\n");
    XplConsolePrintf("  --schema               Define schema extensions.\r\n");
    XplConsolePrintf("  --server=              The object name to create for this messaging server.\r\n");
    XplConsolePrintf("  --smtp=<port>          The unsecure SMTP port to receive on.  Default is 25.\r\n");
    XplConsolePrintf("  --smtps=<port>         The secure SMTP port to receive on.  Default is 465.\r\n");
    XplConsolePrintf("  --imap=<port>          The unsecure IMAP port to receive on.  Default is 143.\r\n");
    XplConsolePrintf("  --imaps=<port>         The secure IMAP port to receive on.  Default is 993.\r\n");
    XplConsolePrintf("  --pop=<port>          The unsecure POP3 port to receive on.  Default is 110.\r\n");
    XplConsolePrintf("  --pops=<port>         The secure POP3 port to receive on.  Default is 995.\r\n");
    XplConsolePrintf("  -u= | --user=<name>    An X500 user name for MDB authentication.\r\n");
    XplConsolePrintf("  -l= | --ldap=<port>    The LDAP port to be used by this server.\r\n");
    XplConsolePrintf("  -h= | --http=<port>    The HTTP port to be used by the Modular Web Server.\r\n");
    XplConsolePrintf("  -H= | --https=<port>   The HTTPS port to be used by the Modular Web Server.\r\n");
    XplConsolePrintf("  --webadmin=<port>      The HTTP port to be used for Web Administration.\r\n");
    XplConsolePrintf("  --webadmins=<port>     The HTTPS port to be used for Web Administration.\r\n");
    XplConsolePrintf("  --verbose              Display verbose progress messages.\r\n");

    return;
}

int
main(int argc, char *argv[])
{
    int i;
    unsigned char *ptr;
    unsigned char *ptr2;
    unsigned char buffer[MDB_MAX_OBJECT_CHARS + 1];
    BOOL result;
    MDBValueStruct *v;

    result = MemoryManagerOpen("Hula Setup");

    if (!result) {
        XplConsolePrintf("Failed to initialize the memory pool library.\r\n");

        return(-1);
    }
    
    if (XplSetEffectiveUser(MsgGetUnpriviledgedUser()) < 0) {
        XplConsolePrintf("hulasetup: Could not drop to unpriviledged user '%s', exiting.\n", MsgGetUnpriviledgedUser());
        return(-2);
    }

    HulaSetup.actions = 0;
    HulaSetup.agents = 0;

    HulaSetup.ports.ldap = 389;
    HulaSetup.ports.http = 8080; /* was 80 */
    HulaSetup.ports.https = 8443; /* was 443 */
    HulaSetup.ports.smtp.clear = 25;
    HulaSetup.ports.smtp.secure = 465;
    HulaSetup.ports.imap.clear = 143;
    HulaSetup.ports.imap.secure = 993;
    HulaSetup.ports.pop3.clear = 110;
    HulaSetup.ports.pop3.secure = 995;
    HulaSetup.ports.webAdmin.http = 89;
    HulaSetup.ports.webAdmin.https = 449;

    HulaSetup.user.x500Name[0] = '\0';
    HulaSetup.user.password[0] = '\0';
    HulaSetup.hint[0] = '\0';
    HulaSetup.server[0] = '\0';
    HulaSetup.domain[0] = '\0';

    HulaSetup.dns.count = 0;

    for (i = 1; i < argc; i++) {
        if ((XplStrCaseCmp(argv[i], "--help") == 0) 
                || (XplStrCaseCmp(argv[i], "-?") == 0) 
                || (XplStrCaseCmp(argv[i], "/?") == 0)) {
            result = FALSE;
        } else if (strncmp(argv[i], "-h=", 3) == 0) {
            HulaSetup.ports.http = atol(argv[i] + 3);
        } else if (strncmp(argv[i], "--http=", 7) == 0) {
            HulaSetup.ports.http = atol(argv[i] + 7);
        } else if (strncmp(argv[i], "-H=", 3) == 0) {
            HulaSetup.ports.https = atol(argv[i] + 3);
        } else if (strncmp(argv[i], "--https=", 8) == 0) {
            HulaSetup.ports.https = atol(argv[i] + 8);
        } else if (strncmp(argv[i], "-l=", 3) == 0) {
            HulaSetup.ports.ldap = atol(argv[i] + 3);
        } else if (strncmp(argv[i], "--ldap=", 7) == 0) {
            HulaSetup.ports.ldap = atol(argv[i] + 7);
        } else if ((strcmp(argv[i], "-a") == 0) || (strcmp(argv[i], "--agents") == 0)) {
            HulaSetup.actions |= HULA_SETUP_CREATE;
            HulaSetup.agents = HULA_AGENT_ALL;
        } else if (strcmp(argv[i], "--certificate") == 0) {
            HulaSetup.actions |= HULA_SETUP_CERTIFICATE;
        } else if ((strncmp(argv[i], "-c=", 3) == 0) || (strncmp(argv[i], "--create=", 9) == 0)) {
            if (argv[i][2] == '=') {
                ptr = argv[i] + 3;
            } else {
                ptr = argv[i] + 9;
            }

            HulaSetup.actions |= HULA_SETUP_CREATE;
            if (strcmp(ptr, "addressbook") == 0) {
                HulaSetup.agents |= HULA_AGENT_ADDRESS_BOOK;
            } else if (strcmp(ptr, "alias") == 0) {
                HulaSetup.agents |= HULA_AGENT_ALIAS;
            } else if (strcmp(ptr, "antispam") == 0) {
                HulaSetup.agents |= HULA_AGENT_ANTISPAM;
            } else if (strcmp(ptr, "calendar") == 0) {
                HulaSetup.agents |= HULA_AGENT_CALENDAR;
            } else if (strcmp(ptr, "connection") == 0) {
                HulaSetup.agents |= HULA_AGENT_CONNMGR;
            } else if (strcmp(ptr, "forward") == 0) {
                HulaSetup.agents |= HULA_AGENT_FORWARD;
            } else if (strcmp(ptr, "imap") == 0) {
                HulaSetup.agents |= HULA_AGENT_IMAP;
            } else if (strcmp(ptr, "modweb") == 0) {
                HulaSetup.agents |= HULA_AGENT_MODWEB;
            } else if (strcmp(ptr, "nmap") == 0) {
                HulaSetup.agents |= HULA_AGENT_NMAP;
            } else if (strcmp(ptr, "pluspack") == 0) {
                HulaSetup.agents |= HULA_AGENT_PLUSPACK;
            } else if (strcmp(ptr, "pop") == 0) {
                HulaSetup.agents |= HULA_AGENT_POP;
            } else if (strcmp(ptr, "proxy") == 0) {
                HulaSetup.agents |= HULA_AGENT_PROXY;
            } else if (strcmp(ptr, "rules") == 0) {
                HulaSetup.agents |= HULA_AGENT_RULESRV;
            } else if (strcmp(ptr, "smtp") == 0) {
                HulaSetup.agents |= HULA_AGENT_SMTP;
            } else if (strcmp(ptr, "webadmin") == 0) {
                HulaSetup.agents |= HULA_AGENT_WEBADMIN;
            } else {
                result = FALSE;

                XplConsolePrintf("Unknown agent in argument: %s\r\n", argv[i]);
            }
        } else if (strncmp(argv[i], "--credential=", 13) == 0) {
            ptr = argv[i] + 13;

            if (strcmp(ptr, "directory") == 0) {
                HulaSetup.actions |= HULA_SETUP_DIRECTORY_CREDENTIAL;
            } else if (strcmp(ptr, "server") == 0) {
                HulaSetup.actions |= HULA_SETUP_SERVER_CREDENTIAL;
            } else {
                result = FALSE;

                XplConsolePrintf("Unknown credential in argument: %s\r\n", argv[i]);
            }
        } else if (strncmp(argv[i], "--dns=", 6) == 0) {
            ptr = argv[i] + 6;

            while (ptr && (ptr[0] != '\0')) {
                ptr2 = strchr(ptr, ':');
                if (ptr2) {
                    *ptr2 = '\0';
                }

                if (HulaSetup.dns.count < 3) {
                    HulaSetup.dns.servers[HulaSetup.dns.count++] = MemStrdup(ptr);
                } else {
                    XplConsolePrintf("Ignoring excessive DNS resolver \"%s\".\r\n", ptr);
                }

                if (ptr2) {
                    *ptr2 = ':';

                    ptr = ++ptr2;

                    continue;
                }

                break;
            }
        } else if (strncmp(argv[i], "--domain=", 9) == 0) {
            strcpy(HulaSetup.domain, argv[i] + 9);
        } else if (strncmp(argv[i], "--host=", 7) == 0) {
            ptr = argv[i] + 7;

            ptr2 = strchr(ptr, ':');
            if (ptr2) {
                HulaSetup.actions |= HULA_SETUP_HOST_ASSOCIATION;

                memset(HulaSetup.associate.host, 0, sizeof(HulaSetup.associate.host));
                memset(HulaSetup.associate.server, 0, sizeof(HulaSetup.associate.server));

                memcpy(HulaSetup.associate.host, ptr, ptr2 - ptr);

                strcpy(HulaSetup.associate.server, ++ptr2);
            } else {
                result = FALSE;

                XplConsolePrintf("Unknown names in argument: %s\r\n", argv[i]);
            }
        } else if (strncmp(argv[i], "-p=", 3) == 0) {
            strcpy(HulaSetup.user.password, argv[i] + 3);
        } else if (strncmp(argv[i], "--pass=", 7) == 0) {
            strcpy(HulaSetup.user.password, argv[i] + 7);
        } else if (strcmp(argv[i], "--schema") == 0) {
            HulaSetup.actions |= HULA_SETUP_SCHEMA;
        } else if (strncmp(argv[i], "--server=", 9) == 0) {
            strcpy(HulaSetup.hint, argv[i] + 9);
        } else if (strncmp(argv[i], "--smtp=", 7) == 0) {
            HulaSetup.ports.smtp.clear = atol(argv[i] + 7);
        } else if (strncmp(argv[i], "--smtps=", 8) == 0) {
            HulaSetup.ports.smtp.secure = atol(argv[i] + 8);
        } else if (strncmp(argv[i], "--imap=", 7) == 0) {
            HulaSetup.ports.imap.clear = atol(argv[i] + 7);
        } else if (strncmp(argv[i], "--imaps=", 8) == 0) {
            HulaSetup.ports.imap.secure = atol(argv[i] + 8);
        } else if (strncmp(argv[i], "--pop=", 6) == 0) {
            HulaSetup.ports.pop3.clear = atol(argv[i] + 6);
        } else if (strncmp(argv[i], "--pops=", 7) == 0) {
            HulaSetup.ports.pop3.secure = atol(argv[i] + 7);
        } else if (strncmp(argv[i], "-u=", 3) == 0) {
            strcpy(HulaSetup.user.x500Name, argv[i] + 3);
        } else if (strncmp(argv[i], "--webadmin=", 11) == 0) {
            HulaSetup.ports.webAdmin.http = atol(argv[i] + 11);
        } else if (strncmp(argv[i], "--webadmins=", 12) == 0) {
            HulaSetup.ports.webAdmin.https = atol(argv[i] + 12);
        } else if (strncmp(argv[i], "--user=", 7) == 0) {
            strcpy(HulaSetup.user.x500Name, argv[i] + 7);
        } else if (strcmp(argv[i], "--verbose") == 0) {
            HulaSetup.actions |= HULA_SETUP_VERBOSE;
        } else {
            result = FALSE;

            XplConsolePrintf("Unknown argument: %s\r\n", argv[i]);
        }
    }
    
    if (!result) {
        HulaSetupUsage();

        return(0);
    }

    if (!HulaSetup.domain[0]) {
	    strcpy(HulaSetup.domain, "localhost.localdomain");
    }
    
    if (!MDBInit()) {
        XplConsolePrintf("hulasetup: Exiting\n.");
        return 1;
    }

    HulaSetup.host.tree[0] = '\\';
    MDBGetServerInfo(HulaSetup.host.dn, HulaSetup.host.tree + 1, NULL);

	ptr = strrchr(HulaSetup.host.dn, '\\');
	if (ptr) {
		*ptr = '\0';

		if (HulaSetup.host.dn[0] == '\\') {
			ptr2 = strchr(HulaSetup.host.dn + 1, '\\');
		} else {
			ptr2 = strchr(HulaSetup.host.dn, '\\');
		}

		if (ptr2) {
			strcpy(HulaSetup.host.context, ptr2 + 1);
		} else {
			strcpy(HulaSetup.host.context, HulaSetup.host.dn);
		}

		*ptr = '\\';
	} else {
		strcpy(HulaSetup.host.context, HulaSetup.host.dn);
	}

    if (!HulaSetup.actions || (HulaSetup.actions == HULA_SETUP_VERBOSE)) {
        HulaSetup.actions |= HULA_SETUP_ALL;
        HulaSetup.actions |= HULA_SETUP_CREATE;
        HulaSetup.agents = (HULA_AGENT_ANTISPAM | 
                            HULA_AGENT_CALENDAR | 
                            HULA_AGENT_FORWARD | 
                            HULA_AGENT_CONNMGR | 
                            HULA_AGENT_IMAP | 
                            HULA_AGENT_MODWEB | 
                            HULA_AGENT_NMAP | 
                            HULA_AGENT_POP | 
                            HULA_AGENT_PROXY | 
                            HULA_AGENT_RULESRV | 
                            HULA_AGENT_SMTP | 
                            HULA_AGENT_WEBADMIN);
    }

    if (!HulaSetup.hint[0]) {
        ptr = strrchr(HulaSetup.host.dn, '\\');
        if (ptr) {
            sprintf(HulaSetup.server, "%s Messaging Server", ptr + 1);
            sprintf(HulaSetup.webAdmin, "%s %s", ptr + 1, WA_SERVER_OBJECT);
        } else {
            sprintf(HulaSetup.server, "%s Messaging Server", HulaSetup.host.dn);
            sprintf(HulaSetup.webAdmin, "%s %s", HulaSetup.host.dn, WA_SERVER_OBJECT);
        }
    } else {
        sprintf(HulaSetup.server, "%s Messaging Server", HulaSetup.hint);
        sprintf(HulaSetup.webAdmin, "%s %s", HulaSetup.hint, WA_SERVER_OBJECT);
    }

    HulaSetup.server[0] = toupper(HulaSetup.server[0]);
    ptr = HulaSetup.server + 1;
    while (*ptr && !isspace(*ptr)) {
        *ptr = tolower(*ptr);
        ptr++;
    }

    HulaSetup.webAdmin[0] = toupper(HulaSetup.webAdmin[0]);
    ptr = HulaSetup.webAdmin + 1;
    while (*ptr && !isspace(*ptr)) {
        *ptr = tolower(*ptr);
        ptr++;
    }

    if (HulaSetup.user.x500Name[0]) {
        X500ToMDBUserName(HulaSetup.user.x500Name, HulaSetup.user.name);

        HulaSetup.directoryHandle = MDBAuthenticate("Hula", HulaSetup.user.name, HulaSetup.user.password);
    } else {
        HulaSetup.directoryHandle = MDBAuthenticate("Hula", NULL, NULL);
    }

    if (HulaSetup.directoryHandle) {
        if (!HulaSetup.user.x500Name[0]) {
            v = MDBCreateValueStruct(HulaSetup.directoryHandle, NULL);
            if (v) {
                sprintf(buffer, "%s\\%s", HulaSetup.host.tree, HulaSetup.host.context);

        	    if (MDBEnumerateObjects(buffer, C_USER, NULL, v)) {
                    sprintf(HulaSetup.user.name, v->Value[0]);

                    if (HulaSetup.actions & HULA_SETUP_VERBOSE) {
                        XplConsolePrintf("Assigning \"%s\" as post-master.\r\n", HulaSetup.user.name);
                    }
                }

                MDBDestroyValueStruct(v);
            }
        }

        result = TRUE;

        if (HulaSetup.actions & HULA_SETUP_SCHEMA) {
            result = AddSchema();
        }

        if (result && (HulaSetup.actions & HULA_SETUP_CREATE)) {
            result = AddHierarchy();
        }

        if (result && (HulaSetup.actions & HULA_SETUP_CREATE)) {
            result = CreateMessagingServer(NULL);

            if (result) {
                GenerateCertificate(XPL_DEFAULT_CERT_PATH);

                GenerateCertificate(XPL_DEFAULT_BIN_DIR "/webadmin/cert.int");
            }
        }

        if (result && HulaSetup.agents) {
            result = CreateMessagingAgents(HulaSetup.server);
        }

        if (result && (HulaSetup.actions & HULA_SETUP_DIRECTORY_CREDENTIAL)) {
            result = SetDirectoryCredential();
        }

        if (result && (HulaSetup.actions & HULA_SETUP_SERVER_CREDENTIAL)) {
            result = SetServerCredential();
        }

        if (result && (HulaSetup.actions & HULA_SETUP_HOST_ASSOCIATION)) {
            result = SetAssociations();
        }
    } else if (HulaSetup.user.x500Name[0]) {
        XplConsolePrintf("Authentication for user \"%s\" failed.\r\n", HulaSetup.user.name);
    } else {
        XplConsolePrintf("Public authentication failed.\r\n");
    }

    for (i = 0; i < HulaSetup.dns.count; i++) {
	    MemFree(HulaSetup.dns.servers[i]);
    }

    MemoryManagerClose("Hula Setup");

    return((result == FALSE)? -1: 0);
}
