/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <xpl.h>
#include <time.h>
#include <sys/stat.h>

#include <libical.h>
#define MSGDATE_H_NEED_DAYS_PER_MONTH
#include <msgapi.h>

#define BUFSIZE         1023

typedef struct {
    unsigned char    *TZName;
    unsigned char    *FullTZ;
} ICalTZRuleStruct;

static ICalTZRuleStruct        ICalTZRules[] = {
    { /*    TZ_UTC                  */  "UTC",                                                      "BEGIN:VTIMEZONE\r\nTZID:UTC\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                                  },
    { /*    TZ_GREENWICH            */  "Casablanca, Monrovia",                                     "BEGIN:VTIMEZONE\r\nTZID:Casablanca, Monrovia\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                 },
    { /*    TZ_GMT                  */  "Greenwich Mean Time : Dublin, Edinburgh, Lisbon, London",  "BEGIN:VTIMEZONE\r\nTZID:Greenwich Mean Time : Dublin, Edinburgh, Lisbon, London\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T010000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n" },
    { /*    TZ_WEST_EUROPE          */  "Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna",         "BEGIN:VTIMEZONE\r\nTZID:Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"        },
    { /*    TZ_CENTRAL_EUROPE       */  "Belgrade, Bratislava, Budapest, Ljubljana, Prague",        "BEGIN:VTIMEZONE\r\nTZID:Belgrade, Bratislava, Budapest, Ljubljana, Prague\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"       },
    { /*    TZ_ROMANCE              */  "Brussels, Copenhagen, Madrid, Paris",                      "BEGIN:VTIMEZONE\r\nTZID:Brussels, Copenhagen, Madrid, Paris\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                     },
    { /*    TZ_CENTRAL_EUROPEAN     */  "Sarajevo, Skopje, Sofija, Vilnius, Warsaw, Zagreb",        "BEGIN:VTIMEZONE\r\nTZID:Sarajevo, Skopje, Sofija, Vilnius, Warsaw, Zagreb\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"       },
    { /*    TZ_WEST_CENTRAL_AFRICA  */  "West Central Africa",                                      "BEGIN:VTIMEZONE\r\nTZID:West Central Africa\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                  },
    { /*    TZ_GBT                  */  "Athens, Istanbul, Minsk",                                  "BEGIN:VTIMEZONE\r\nTZID:Athens, Istanbul, Minsk\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                 },
    { /*    TZ_EAST_EUROPE          */  "Bucharest",                                                "BEGIN:VTIMEZONE\r\nTZID:Bucharest\r\nBEGIN:STANDARD\r\nDTSTART:20000924T010000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=9\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T000000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                                },
    { /*    TZ_EGYPT                */  "Cairo",                                                    "BEGIN:VTIMEZONE\r\nTZID:Cairo\r\nBEGIN:STANDARD\r\nDTSTART:20000927T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1WE;BYMONTH=9\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010504T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1FR;BYMONTH=5\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                                     },
    { /*    TZ_SOUTH_AFRICA         */  "Harare, Pretoria",                                         "BEGIN:VTIMEZONE\r\nTZID:Harare, Pretoria\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                     },
    { /*    TZ_FLE                  */  "Helsinki, Riga, Tallinn",                                  "BEGIN:VTIMEZONE\r\nTZID:Helsinki, Riga, Tallinn\r\nBEGIN:STANDARD\r\nDTSTART:20001029T040000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                 },
    { /*    TZ_ISRAEL               */  "Jerusalem",                                                "BEGIN:VTIMEZONE\r\nTZID:Jerusalem\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                            },
    { /*    TZ_ARABIC               */  "Baghdad",                                                  "BEGIN:VTIMEZONE\r\nTZID:Baghdad\r\nBEGIN:STANDARD\r\nDTSTART:20001001T040000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=10\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0400\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                                   },
    { /*    TZ_ARAB                 */  "Kuwait, Riyadh",                                           "BEGIN:VTIMEZONE\r\nTZID:Kuwait, Riyadh\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                       },
    { /*    TZ_RUSSIAN              */  "Moscow, St. Petersburg, Volgograd",                        "BEGIN:VTIMEZONE\r\nTZID:Moscow, St. Petersburg, Volgograd\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0400\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                       },
    { /*    TZ_EAST_AFRICA          */  "Nairobi",                                                  "BEGIN:VTIMEZONE\r\nTZID:Nairobi\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                              },
    { /*    TZ_IRAN                 */  "Tehran",                                                   "BEGIN:VTIMEZONE\r\nTZID:Tehran\r\nBEGIN:STANDARD\r\nDTSTART:20000926T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=4TU;BYMONTH=9\r\nTZOFFSETFROM:+0430\r\nTZOFFSETTO:+0330\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010304T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=3\r\nTZOFFSETFROM:+0330\r\nTZOFFSETTO:+0430\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE"                                                         },
    { /*    TZ_ARABIAN              */  "Abu Dhabi, Muscat",                                        "BEGIN:VTIMEZONE\r\nTZID:Abu Dhabi, Muscat\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                    },
    { /*    TZ_CAUCASUS             */  "Baku, Tbilisi, Yerevan",                                   "BEGIN:VTIMEZONE\r\nTZID:Baku, Tbilisi, Yerevan\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0400\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0500\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                  },
    { /*    TZ_AFGHANISTAN          */  "Kabul",                                                    "BEGIN:VTIMEZONE\r\nTZID:Kabul\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0430\r\nTZOFFSETTO:+0430\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                                },
    { /*    TZ_EKATERINENBURG       */  "Ekaterinburg",                                             "BEGIN:VTIMEZONE\r\nTZID:Ekaterinburg\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0500\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0600\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                            },
    { /*    TZ_WEST_ASIA            */  "Islamabad, Karachi, Tashkent",                             "BEGIN:VTIMEZONE\r\nTZID:Islamabad, Karachi, Tashkent\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                         },
    { /*    TZ_INDIA                */  "Calcutta, Chennai, Mumbai, New Delhi",                     "BEGIN:VTIMEZONE\r\nTZID:Calcutta, Chennai, Mumbai, New Delhi\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0530\r\nTZOFFSETTO:+0530\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                 },
    { /*    TZ_NEPAL                */  "Kathmandu",                                                "BEGIN:VTIMEZONE\r\nTZID:Kathmandu\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0545\r\nTZOFFSETTO:+0545\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                            },
    { /*    TZ_NORTH_CENTRAL_ASIA   */  "Almaty, Novosibirsk",                                      "BEGIN:VTIMEZONE\r\nTZID:Almaty, Novosibirsk\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0700\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                     },
    { /*    TZ_CENTRAL_ASIA         */  "Astana, Dhaka",                                            "BEGIN:VTIMEZONE\r\nTZID:Astana, Dhaka\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                        },
    { /*    TZ_SRI_LANKA            */  "Sri Jayawardenepura",                                      "BEGIN:VTIMEZONE\r\nTZID:Sri Jayawardenepura\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                  },
    { /*    TZ_MYANMAR              */  "Rangoon",                                                  "BEGIN:VTIMEZONE\r\nTZID:Rangoon\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0630\r\nTZOFFSETTO:+0630\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                              },
    { /*    TZ_SOUTH_EAST_ASIA      */  "Bangkok, Hanoi, Jakarta",                                  "BEGIN:VTIMEZONE\r\nTZID:Bangkok, Hanoi, Jakarta\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                              },
    { /*    TZ_NORTH_EAST_ASIA      */  "Krasnoyarsk",                                              "BEGIN:VTIMEZONE\r\nTZID:Krasnoyarsk\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0700\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0800\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                             },
    { /*    TZ_CHINA                */  "Beijing, Chongqing, Hong Kong, Urumqi",                    "BEGIN:VTIMEZONE\r\nTZID:Beijing, Chongqing, Hong Kong, Urumqi\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                },
    { /*    TZ_NORTH_ASIA_EAST      */  "Irkutsk, Ulaan Bataar",                                    "BEGIN:VTIMEZONE\r\nTZID:Irkutsk, Ulaan Bataar\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0800\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0900\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                   },
    { /*    TZ_SINGAPORE            */  "Kuala Lumpur, Singapore",                                  "BEGIN:VTIMEZONE\r\nTZID:Kuala Lumpur, Singapore\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                              },
    { /*    TZ_WEST_AUSTRALIA       */  "Perth",                                                    "BEGIN:VTIMEZONE\r\nTZID:Perth\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                                },
    { /*    TZ_TAIPEI               */  "Taipei",                                                   "BEGIN:VTIMEZONE\r\nTZID:Taipei\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                               },
    { /*    TZ_TOKYO                */  "Osaka, Sapporo, Tokyo",                                    "BEGIN:VTIMEZONE\r\nTZID:Osaka, Sapporo, Tokyo\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0900\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                },
    { /*    TZ_KOREA                */  "Seoul",                                                    "BEGIN:VTIMEZONE\r\nTZID:Seoul\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0900\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                                },
    { /*    TZ_YAKUTSK              */  "Yakutsk",                                                  "BEGIN:VTIMEZONE\r\nTZID:Yakutsk\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+0900\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+1000\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                                 },
    { /*    TZ_CENTRAL_AUSTRALIA    */  "Adelaide",                                                 "BEGIN:VTIMEZONE\r\nTZID:Adelaide\r\nBEGIN:STANDARD\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+1030\r\nTZOFFSETTO:+0930\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0930\r\nTZOFFSETTO:+1030\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                                },
    { /*    TZ_AUS_CENTRAL          */  "Darwin",                                                   "BEGIN:VTIMEZONE\r\nTZID:Darwin\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0930\r\nTZOFFSETTO:+0930\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                               },
    { /*    TZ_EAST_AUSTRALIA       */  "Brisbane",                                                 "BEGIN:VTIMEZONE\r\nTZID:Brisbane\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                             },
    { /*    TZ_AUS_EASTERN          */  "Canberra, Melbourne, Sydney",                              "BEGIN:VTIMEZONE\r\nTZID:Canberra, Melbourne, Sydney\r\nBEGIN:STANDARD\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1100\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                             },
    { /*    TZ_WEST_PACIFIC         */  "Guam, Port Moresby",                                       "BEGIN:VTIMEZONE\r\nTZID:Guam, Port Moresby\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                   },
    { /*    TZ_TASMANIA             */  "Hobart",                                                   "BEGIN:VTIMEZONE\r\nTZID:Hobart\r\nBEGIN:STANDARD\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20001001T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=10\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1100\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                                   },
    { /*    TZ_VLADIVOSTOK          */  "Vladivostok",                                              "BEGIN:VTIMEZONE\r\nTZID:Vladivostok\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1100\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                             },
    { /*    TZ_CENTRAL_PACIFIC      */  "Magadan, Solomon Is., New Caledonia",                      "BEGIN:VTIMEZONE\r\nTZID:Magadan, Solomon Is., New Caledonia\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                  },
    { /*    TZ_NEW_ZEALAND          */  "Auckland, Wellington",                                     "BEGIN:VTIMEZONE\r\nTZID:Auckland, Wellington\r\nBEGIN:STANDARD\r\nDTSTART:20010318T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=3SU;BYMONTH=3\r\nTZOFFSETFROM:+1300\r\nTZOFFSETTO:+1200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20001001T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=10\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                      },
    { /*    TZ_FIJI                 */  "Fiji, Kamchatka, Marshall Is.",                            "BEGIN:VTIMEZONE\r\nTZID:Fiji, Kamchatka, Marshall Is.\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                        },
    { /*    TZ_TONGO                */  "Nuku'alofa",                                               "BEGIN:VTIMEZONE\r\nTZID:Nuku'alofa\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1300\r\nTZOFFSETTO:+1300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                           },
    { /*    TZ_AZORES               */  "Azores",                                                   "BEGIN:VTIMEZONE\r\nTZID:Azores\r\nBEGIN:STANDARD\r\nDTSTART:20001029T030000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:-0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:-0100\r\nTZOFFSETTO:+0000\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                                  },
    { /*    TZ_CAPE_VERDE           */  "Cape Verde Is.",                                           "BEGIN:VTIMEZONE\r\nTZID:Cape Verde Is.\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0100\r\nTZOFFSETTO:-0100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                       },
    { /*    TZ_MID_ATLANTIC         */  "Mid-Atlantic",                                             "BEGIN:VTIMEZONE\r\nTZID:Mid-Atlantic\r\nBEGIN:STANDARD\r\nDTSTART:20000924T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=9\r\nTZOFFSETFROM:-0100\r\nTZOFFSETTO:-0200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010325T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\r\nTZOFFSETFROM:-0200\r\nTZOFFSETTO:-0100\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                             },
    { /*    TZ_EAST_SOUTH_AMERICA   */  "Brasilia",                                                 "BEGIN:VTIMEZONE\r\nTZID:Brasilia\r\nBEGIN:STANDARD\r\nDTSTART:20010211T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=2SU;BYMONTH=2\r\nTZOFFSETFROM:-0200\r\nTZOFFSETTO:-0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20001015T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=3SU;BYMONTH=10\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0200\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                                  },
    { /*    TZ_SA_EASTERN           */  "Buenos Aires, Georgetown",                                 "BEGIN:VTIMEZONE\r\nTZID:Buenos Aires, Georgetown\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                             },
    { /*    TZ_GREENLAND            */  "Greenland",                                                "BEGIN:VTIMEZONE\r\nTZID:Greenland\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0200\r\nTZOFFSETTO:-0300\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0200\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                                },
    { /*    TZ_NEWFOUNDLAND         */  "Newfoundland",                                             "BEGIN:VTIMEZONE\r\nTZID:Newfoundland\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0230\r\nTZOFFSETTO:-0330\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0330\r\nTZOFFSETTO:-0230\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                             },
    { /*    TZ_ATLANTIC             */  "Atlantic Time (Canada)",                                   "BEGIN:VTIMEZONE\r\nTZID:Atlantic Time (Canada)\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                   },
    { /*    TZ_SA_WESTERN           */  "Caracas, La Paz",                                          "BEGIN:VTIMEZONE\r\nTZID:Caracas, La Paz\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                      },
    { /*    TZ_PACIFIC_SA           */  "Santiago",                                                 "BEGIN:VTIMEZONE\r\nTZID:Santiago\r\nBEGIN:STANDARD\r\nDTSTART:20010310T000000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=2SA;BYMONTH=3\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20001014T000000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=2SA;BYMONTH=10\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                                  },
    { /*    TZ_SA_PACIFIC           */  "Bogota, Lima, Quito",                                      "BEGIN:VTIMEZONE\r\nTZID:Bogota, Lima, Quito\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                  },
    { /*    TZ_EASTERN              */  "Eastern Time (US & Canada)",                               "BEGIN:VTIMEZONE\r\nTZID:Eastern Time (US & Canada)\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                               },
    { /*    TZ_US_EASTERN           */  "Indiana (East)",                                           "BEGIN:VTIMEZONE\r\nTZID:Indiana (East)\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                       },
    { /*    TZ_CENTRAL_AMERICA      */  "Central America",                                          "BEGIN:VTIMEZONE\r\nTZID:Central America\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                      },
    { /*    TZ_CENTRAL              */  "Central Time (US & Canada)",                               "BEGIN:VTIMEZONE\r\nTZID:Central Time (US & Canada)\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                               },
    { /*    TZ_MEXICO               */  "Mexico City",                                              "BEGIN:VTIMEZONE\r\nTZID:Mexico City\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                              },
    { /*    TZ_CANADA_CENTRAL       */  "Saskatchewan",                                             "BEGIN:VTIMEZONE\r\nTZID:Saskatchewan\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                         },
    { /*    TZ_US_MOUNTAIN          */  "Arizona",                                                  "BEGIN:VTIMEZONE\r\nTZID:Arizona\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0700\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                              },
    { /*    TZ_MOUNTAIN             */  "Mountain Time (US & Canada)",                              "BEGIN:VTIMEZONE\r\nTZID:Mountain Time (US & Canada)\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0700\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0600\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                              },
    { /*    TZ_PACIFIC              */  "Pacific Time (US & Canada); Tijuana",                      "BEGIN:VTIMEZONE\r\nTZID:Pacific Time (US & Canada); Tijuana\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0800\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0700\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                      },
    { /*    TZ_ALASKAN              */  "Alaska",                                                   "BEGIN:VTIMEZONE\r\nTZID:Alaska\r\nBEGIN:STANDARD\r\nDTSTART:20001029T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0900\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nDTSTART:20010401T020000\r\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\r\nTZOFFSETFROM:-0900\r\nTZOFFSETTO:-0800\r\nTZNAME:Daylight Savings Time\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\n"                                                   },
    { /*    TZ_HAWAIIAN             */  "Hawaii",                                                   "BEGIN:VTIMEZONE\r\nTZID:Hawaii\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-1000\r\nTZOFFSETTO:-1000\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                               },
    { /*    TZ_SAMOA                */  "Midway Island, Samoa",                                     "BEGIN:VTIMEZONE\r\nTZID:Midway Island, Samoa\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-1100\r\nTZOFFSETTO:-1100\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                 },
    { /*    TZ_DATELINE             */  "Eniwetok, Kwajalein",                                      "BEGIN:VTIMEZONE\r\nTZID:Eniwetok, Kwajalein\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-1200\r\nTZOFFSETTO:-1200\r\nTZNAME:Standard Time\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\n"                                                                                                                                                                                                                                                                                                                  }
};

static BOOL
ICalQuickNCmp(unsigned char *str1, unsigned char *str2, int len)
{
    while (--len && *str1 && *str2 && toupper(*str1)==toupper(*str2)) {
        str1++; str2++;
    }
    return(toupper(*str1)==toupper(*str2));
}

static BOOL
ICalQuickCmp(unsigned char *str1, unsigned char *str2)
{
    while (*str1 && *str2 && toupper(*str1)==toupper(*str2)) {
        str1++; str2++;
    }
    return(toupper(*str1)==toupper(*str2));
}

BOOL
ICalParseTimezoneRule(ICalVTimeZone *Timezone, unsigned char *Rule, BOOL IsDST)
{
    unsigned char    *StartPtr;
    unsigned char    *ptr;


    /* First, look for the ByDay */
    if ((ptr=strstr(Rule, "BYDAY="))!=NULL) {
        StartPtr=ptr;
        if ((ptr=strchr(StartPtr, ';'))!=NULL) {
            *ptr='\0';
        }
        StartPtr+=6;
        if (IsDST) {
            Timezone->DSTDay=atol(StartPtr);
        } else {
            Timezone->Day=atol(StartPtr);
        }
        while (isdigit(*StartPtr) || *StartPtr=='+' || *StartPtr=='-') {
            StartPtr++;
        }
        if (ICalQuickCmp(StartPtr, "MO")) {
            if (IsDST) {
                Timezone->DSTWDay=1;
            } else {
                Timezone->WDay=1;
            }
        } else if (ICalQuickCmp(StartPtr, "TU")) {
            if (IsDST) {
                Timezone->DSTWDay=2;
            } else {
                Timezone->WDay=2;
            }
        } else if (ICalQuickCmp(StartPtr, "WE")) {
            if (IsDST) {
                Timezone->DSTWDay=3;
            } else {
                Timezone->WDay=3;
            }
        } else if (ICalQuickCmp(StartPtr, "TH")) {
            if (IsDST) {
                Timezone->DSTWDay=4;
            } else {
                Timezone->WDay=4;
            }
        } else if (ICalQuickCmp(StartPtr, "FR")) {
            if (IsDST) {
                Timezone->DSTWDay=5;
            } else {
                Timezone->WDay=5;
            }
        } else if (ICalQuickCmp(StartPtr, "SA")) {
            if (IsDST) {
                Timezone->DSTWDay=6;
            } else {
                Timezone->WDay=6;
            }
        }
        if (ptr) {
            *ptr=';';
        }
    }
    if ((ptr=strstr(Rule, "BYMONTH="))!=NULL) {
        if (IsDST) {
            Timezone->DSTMonth=atol(ptr+8);
        } else {
            Timezone->Month=atol(ptr+8);
        }
    }
    return(TRUE);
}

unsigned long
ICalParseRuleDateTime(ICalVRule *Rule, ICalVTimeZone *Timezone, unsigned char *DateTime)
{
    unsigned long    TimezoneID=TZ_UTC;
    unsigned char    *StartPtr;
    unsigned char    *ptr;
    unsigned char    Day;                        
    unsigned char    Month;
    unsigned short    Year;
    unsigned char    Hour;
    unsigned char    Minute;
    unsigned char    Second;

    if (DateTime[15]!='Z') {
        StartPtr=DateTime;
        if (ICalQuickNCmp(StartPtr, ";TZID=", 6)) {
            StartPtr+=6;

            if (StartPtr[0]=='"') {
                StartPtr++;
                ptr=strchr(StartPtr, '"');
                if (ptr) {
                    *ptr='\0';
                }
            } else {
                ptr=NULL;
            }
            
            /* Find the right timezone */
            while (Timezone) {

                if (Timezone->TZName && ICalQuickCmp(StartPtr, Timezone->TZName)) {
                    TimezoneID=Timezone->TimezoneID;
                    break;
                }
                Timezone = Timezone->Next;
            }
            if (ptr) {
                *ptr='"';
            }
        }
    }

    if (DateTime[8]!='T') {
        Year=(DateTime[0]-'0')*1000+(DateTime[1]-'0')*100+(DateTime[2]-'0')*10+DateTime[3]-'0';
        Month=(DateTime[4]-'0')*10+(DateTime[5]-'0');
        Day=(DateTime[6]-'0')*10+(DateTime[7]-'0');
        Hour=0;
        Minute=0;
        Second=0;
    } else {
        Year=(DateTime[0]-'0')*1000+(DateTime[1]-'0')*100+(DateTime[2]-'0')*10+DateTime[3]-'0';
        Month=(DateTime[4]-'0')*10+(DateTime[5]-'0');
        Day=(DateTime[6]-'0')*10+(DateTime[7]-'0');
        Hour=(DateTime[9]-'0')*10+(DateTime[10]-'0');
        Minute=(DateTime[11]-'0')*10+(DateTime[12]-'0');
        Second=(DateTime[13]-'0')*10+(DateTime[14]-'0');
    }

    if (DateTime[15]!='Z') {
        return(MsgGetUTC(Day, Month, Year, Hour, Minute, Second)-MsgGetUTCOffsetByDate(TimezoneID, Day, Month, Year, Hour));
    } else {
        return(MsgGetUTC(Day, Month, Year, Hour, Minute, Second));
    }
}

BOOL
ICalParseDTComponent(ICalObject *ICal, unsigned char *DateTime, unsigned char Type)
{
    unsigned char    *Value;
    BOOL                IsValue;
    unsigned char    *ptr;
    ICalVTimeZone        *Timezone=ICal->Timezone;
    unsigned long    TimezoneID=TZ_UTC;
    long                Offset=0;
    unsigned long    Day = 0;
    unsigned long    Month = 0;
    unsigned long    Year = 0;
    unsigned long    Hour = 0;
    unsigned long    Minute = 0;
    unsigned long    Second = 0;

    ptr=DateTime;
    Value=MemMalloc(strlen(DateTime)+1);

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (IsValue) {
            /* Now parse out the date */
            Year=(Value[0]-'0')*1000+(Value[1]-'0')*100+(Value[2]-'0')*10+Value[3]-'0';
            Month=(Value[4]-'0')*10+(Value[5]-'0');
            Day=(Value[6]-'0')*10+(Value[7]-'0');
            if (Value[8]=='T') {
                Hour=(Value[9]-'0')*10+(Value[10]-'0');
                Minute=(Value[11]-'0')*10+(Value[12]-'0');
                Second=(Value[13]-'0')*10+(Value[14]-'0');
            } else {
                Hour=0;
                Minute=0;
                Second=0;
            }

            if (Value[15]!='Z') {
                Offset=MsgGetUTCOffsetByDate(TimezoneID, Day, Month, Year, Hour);
            }
        } else {
            if (ICalQuickNCmp(Value, "TZID=", 5)) {
                while (Timezone) {
                    if (Timezone->TZName && ICalQuickCmp(Value+5, Timezone->TZName)) {
                        TimezoneID=Timezone->TimezoneID;
                        break;
                    }
                    Timezone = Timezone->Next;
                }
            }
        }
    } while (!IsValue && ptr);

    MemFree(Value);

    switch(Type) {
        case ICAL_DTSTART: {
            ICal->Start.TimezoneID=TimezoneID;
            ICal->Start.UTC=MsgGetUTC(Day, Month, Year, Hour, Minute, Second)-Offset;
            ICal->Start.Day=Day;
            ICal->Start.Month=Month;
            ICal->Start.Year=Year;
            ICal->Start.Hour=Hour;
            ICal->Start.Minute=Minute;
            ICal->Start.Second=Second;
            if (ICal->End.UTC==0) {
                ICal->End.UTC=ICal->Start.UTC;
            }
            break;
        }

        case ICAL_DTEND: {
            ICal->End.TimezoneID=TimezoneID;
            ICal->End.UTC=MsgGetUTC(Day, Month, Year, Hour, Minute, Second)-Offset;
            ICal->End.Day=Day;
            ICal->End.Month=Month;
            ICal->End.Year=Year;
            ICal->End.Hour=Hour;
            ICal->End.Minute=Minute;
            ICal->End.Second=Second;
            break;
        }

        case ICAL_DTSTAMP: {
            ICal->Stamp.TimezoneID=TimezoneID;
            ICal->Stamp.UTC=MsgGetUTC(Day, Month, Year, Hour, Minute, Second)-Offset;
            ICal->Stamp.Day=Day;
            ICal->Stamp.Month=Month;
            ICal->Stamp.Year=Year;
            ICal->Stamp.Hour=Hour;
            ICal->Stamp.Minute=Minute;
            ICal->Stamp.Second=Second;
            if (ICal->Start.UTC==0) {
                ICal->Start=ICal->Stamp;
            }
            break;
        }

        case ICAL_DTCOMPLETED: {
            ICal->Completed.TimezoneID=TimezoneID;
            ICal->Completed.UTC=MsgGetUTC(Day, Month, Year, Hour, Minute, Second)-Offset;
            ICal->Completed.Day=Day;
            ICal->Completed.Month=Month;
            ICal->Completed.Year=Year;
            ICal->Completed.Hour=Hour;
            ICal->Completed.Minute=Minute;
            ICal->Completed.Second=Second;
            break;
        }

        case ICAL_RECURID: {
            ICal->RecurrenceID.TimezoneID=TimezoneID;
            ICal->RecurrenceID.UTC=MsgGetUTC(Day, Month, Year, Hour, Minute, Second)-Offset;
            ICal->RecurrenceID.Day=Day;
            ICal->RecurrenceID.Month=Month;
            ICal->RecurrenceID.Year=Year;
            ICal->RecurrenceID.Hour=Hour;
            ICal->RecurrenceID.Minute=Minute;
            ICal->RecurrenceID.Second=Second;
            break;
        }
    }

    if (ICal->Start.UTC) {
        if ((ICal->Start.UTC!=ICal->End.UTC) && (ICal->Duration==0)) {
            ICal->Duration=ICal->End.UTC-ICal->Start.UTC;
        } if ((ICal->End.UTC==0) && (ICal->Duration!=0)) {
            ICal->End.UTC=ICal->Start.UTC+ICal->Duration;
        }
    }
    return(TRUE);
}

BOOL
ICalHasRule(ICalObject *ICal)
{
    if (ICal->Rule==NULL) {
        return(FALSE);
    }
    return(TRUE);
}

BOOL
ICalFirstRuleInstance(ICalObject *ICal, ICalVRuleIterator *Iteration)
{
    if (ICal->Rule==NULL) {
        return(FALSE);
    }
    memset(Iteration, 0, sizeof(ICalVRuleIterator));

    /* Find the first occurrence */

    Iteration->DayIndex=ICal->Start.Day-1;
    Iteration->MonthIndex=ICal->Start.Month-1;
    Iteration->YearIndex=0;
    Iteration->HourIndex=ICal->Start.Hour;
    Iteration->MinuteIndex=ICal->Start.Minute;

    return(ICalNextRuleInstance(ICal, Iteration));
}

BOOL
ICalNextRuleInstance(ICalObject *ICal, ICalVRuleIterator *Iteration)
{
    BOOL        Matched;
    ICalVRule        *Rule=ICal->Rule;

    FindTime:
    Matched=FALSE;

    /* First try to find the proper time */
    if (Iteration->HourIndex>23) {
        Iteration->HourIndex=0;
        Iteration->MinuteIndex=0;
    }

    do {
        if (Iteration->MinuteIndex>59) {
            Iteration->MinuteIndex=0;
            Iteration->HourIndex++;
            if (Iteration->HourIndex>23) {
                Iteration->HourIndex=0;
                Iteration->MinuteIndex=0;
                Iteration->DayIndex++;
                if (Iteration->DayIndex>30) {
                    Iteration->DayIndex=0;
                    Iteration->MonthIndex++;
                    if (Iteration->MonthIndex>11) {
                        Iteration->MonthIndex=0;
                        Iteration->YearIndex++;
                        if (Iteration->YearIndex>11) {
                            return(FALSE);
                        }
                    }
                }
            }
        }
        
        if ((Rule->Days[Iteration->YearIndex][Iteration->MonthIndex][Iteration->DayIndex]==Rule->DaysTop) && (Rule->Hours[Iteration->HourIndex][Iteration->MinuteIndex]==Rule->HoursTop)) {
            /* We've got a time that matches */

            Iteration->Day=Iteration->DayIndex+1;
            Iteration->Month=Iteration->MonthIndex+1;
            Iteration->Year=Iteration->YearIndex+ICal->Start.Year;
            Iteration->Hour=Iteration->HourIndex;
            Iteration->Minute=Iteration->MinuteIndex;
            Iteration->Second=ICal->Start.Second;
            Iteration->UTC=MsgGetUTC(Iteration->Day, Iteration->Month, Iteration->Year, Iteration->Hour, Iteration->Minute, ICal->Start.Second)-MsgGetUTCOffsetByDate(ICal->Start.TimezoneID, Iteration->Day, Iteration->Month, Iteration->Year, Iteration->Hour);
            Iteration->Duration=ICal->Duration;
            Iteration->Count++;

            if ((Rule->Until!=0 && Iteration->UTC>Rule->Until) || (Rule->Count!=0 && Iteration->Count>Rule->Count)) {
                return(FALSE);
            }
            Matched=TRUE;
        }
        Iteration->MinuteIndex++;
    } while (Iteration->Hour<24 && !Matched);

    if (Matched) {
        return(TRUE);
    }


    while (TRUE) {
        Iteration->DayIndex++;
        if (Iteration->DayIndex>30) {
            Iteration->DayIndex=0;
            Iteration->MonthIndex++;
        }
        if (Iteration->MonthIndex>11) {
            Iteration->MonthIndex=0;
            Iteration->YearIndex++;
            if (Iteration->YearIndex>11) {
                return(FALSE);
            }
        }
        if (Rule->Days[Iteration->YearIndex][Iteration->MonthIndex][Iteration->DayIndex]==Rule->DaysTop) {
            goto FindTime;
        }
    }
    return(FALSE);
}

BOOL
ICalEncodeArgument(unsigned char *Src, FILE *Dest, unsigned long BreakLen, unsigned long Start)
{
    unsigned long    Count=Start;

    while (*Src) {
        if (Count>=BreakLen) {
            Count=0;
            fprintf(Dest, "\r\n ");
            Count += 1;
        }
        switch(*Src) {
            case '\n': {
                Count += fprintf(Dest, "\\N");
                Src++;
                break;
            }

            case '\r': {
                Src++;
                break;
            }

            case ';': {
                Count += fprintf(Dest, "\\;");
                Src++;
                break;
            }

            case ':': {
                Count += fprintf(Dest, "\\:");
                Src++;
                break;
            }

            default: {
                Count += fprintf(Dest, "%c", *Src);
                Src++;
                break;
            }
        }
    }

    return(TRUE);
}


unsigned char
*ICalGrabArgument(BOOL *IsValue, unsigned char *String, unsigned char *Text)
{
    unsigned char    *Src=Text;
    unsigned char    *Dest=String;
    BOOL                InQuote=FALSE;

    if (!Text || !*Text ) {
        return(NULL);
    }

    Src=Text;
    *Dest='\0';
    if (*Src==';') {
        *IsValue=FALSE;
        Src++;
    } else if (*Src==':') {
        *IsValue=TRUE;
        Src++;
        /* Commented out; the same rules apply to a value */
        //strcpy(String, Src);
        //return(NULL);
    }

    do {
        switch(*Src) {
            case '"': {
                InQuote = !InQuote;
                break;
            }

            case '\\': {
                switch(Src[1]) {
                    case '\\':
//                    case '"':
                    case ':':
                    case ';': {
                        *Dest=Src[1]; 
                        Dest++;
                        Src++;
                        break;
                    }

                    case 'N':
                    case 'n': {
                        *Dest='\n';
                        Dest++;
                        Src++;
                        break;
                    }
                }
                break;
            }

            case ';':
            case ':': {
                if (!InQuote) {
                    if ((*IsValue)==FALSE) {
                        *Dest='\0'; 
                        return(Src);
                    }
                }
                *Dest=*Src;
                Dest++;
                break;
            }

            case '\0': {
                *Dest='\0';
                return(Src);
            }

            default: {
                *Dest=*Src;
                Dest++;
            }
        }
        Src++;
    } while (*Src!='\0');

    *Dest='\0';
    return(Src);
}

unsigned char
*ICalGrabPeriod(ICalVDateTime *Date, long *Duration, unsigned char *Text)
{
    unsigned char    *ptr;
    BOOL                Negative=FALSE;
    unsigned long    Value;

    *Duration=0;

    ptr=strchr(Text, ',');
    if (ptr) {
        *ptr='\0';
    }

    /* We have a date in front of the duration... */
    if (isdigit(Text[0])) {
        /* Sanity */
        if (Text[15]=='Z' && Date) {
            Date->Year=(Text[0]-'0')*1000+(Text[1]-'0')*100+(Text[2]-'0')*10+Text[3]-'0';
            Date->Month=(Text[4]-'0')*10+(Text[5]-'0');
            Date->Day=(Text[6]-'0')*10+(Text[7]-'0');
            if (Text[8]=='T') {
                Date->Hour=(Text[9]-'0')*10+(Text[10]-'0');
                Date->Minute=(Text[11]-'0')*10+(Text[12]-'0');
                Date->Second=(Text[13]-'0')*10+(Text[14]-'0');
            } else {
                Date->Hour=0;
                Date->Minute=0;
                Date->Second=0;
            }
            Date->UTC=MsgGetUTC(Date->Day, Date->Month, Date->Year, Date->Hour, Date->Minute, Date->Second);
        }
        Text+=16;
        if (Text[0]!='/') {
            /* No period specified */
            if (ptr) {
                *ptr=',';
                return(ptr+1);
            } else {
                return(NULL);
            }
        }
        Text++;
    }


    /* Text points to the first duration */
    if (Text[0]=='-') {
        Text++;
        Negative=TRUE;
    } else if (Text[0]=='+') {
        Text++;
    }

    if (Text[0]!='P') {
        return(NULL);
    }

    Text++;

    do {
        Value=atol(Text);
        while (isdigit(*Text)) {
            Text++;
        }
        switch(Text[0]) {
            case 'W': {
                Value*=(60*60*24*7);
                break;
            }

            case 'D': {
                Value*=(60*60*24);
                break;
            }

            case 'H': {
                Value*=60*60;
                break;
            }

            case 'M': {
                Value*=60;
                break;
            }
        }

        Text++;
        *Duration+=Value;
    } while (Text[0]!='\0');


    if (ptr) {
        *ptr=',';
        return(ptr+1);
    } else {
        return(NULL);
    }
}

unsigned char
*ICalGrabValue(long *Value, unsigned char *Text)
{
    unsigned char    *ptr;

    ptr=strchr(Text, ',');
    if (ptr) {
        *ptr='\0';
    }

    *Value=atol(Text);

    if (ptr) {
        *ptr=',';
        return(ptr+1);
    } else {
        return(NULL);
    }
}

unsigned char
*ICalGrabWDay(long *Offset, unsigned char *WDay, unsigned char *Text)
{
    unsigned char    *ptr;
    unsigned char    *ptr2;

    ptr=strchr(Text, ',');
    if (ptr) {
        *ptr='\0';
    }

    *Offset=atol(Text);

    ptr2=Text;
    while (*ptr2=='-' || *ptr2=='+' || isdigit(*ptr2)) {
        ptr2++;
    }

    if (ptr2[0]=='S' && ptr2[1]=='U') {
        *WDay=0;
    } else if (ptr2[0]=='M' && ptr2[1]=='O') {
        *WDay=1;
    } else if (ptr2[0]=='T' && ptr2[1]=='U') {
        *WDay=2;
    } else if (ptr2[0]=='W' && ptr2[1]=='E') {
        *WDay=3;
    } else if (ptr2[0]=='T' && ptr2[1]=='H') {
        *WDay=4;
    } else if (ptr2[0]=='F' && ptr2[1]=='R') {
        *WDay=5;
    } else if (ptr2[0]=='S' && ptr2[1]=='A') {
        *WDay=6;
    }

    if (ptr) {
        *ptr=',';
        return(ptr+1);
    } else {
        return(NULL);
    }
}

BOOL
ICalProcessYearlyRule(ICalObject *ICal, ICalVRule *Rule, unsigned char *RuleText)
{
    unsigned char    *ptr=RuleText;
    unsigned char    *StartPtr=RuleText;
    unsigned long    StartRD;
    long                Value;
    unsigned long    Day;
    unsigned long    Month;
    unsigned long    Year;
    long                Week;
    long                YearDay;
    unsigned char    WeekDay;
    long                Offset;
    unsigned char    *ptr2;
    unsigned char    Hour;
    unsigned char    Minute;
    unsigned long    RD1;
    unsigned long    RD2;

    /* Prepare our calendar array */
    StartRD=MsgGetRataDie(1, 1, ICal->Start.Year);

    for (Year=0; Year<12; Year++) {
        for (Month=1; Month<12; Month++) {
            for (Day=MSG_DAYS_IN_MONTH(Month, Year+ICal->Start.Year); Day<31; Day++) {
                Rule->Days[Year][Month-1][Day]=-1;
            }
        }
    }

    /* Now parse each BY_xx qualifier */
    if ((StartPtr=strstr(RuleText, "BYMONTH="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=8;
        do {
            StartPtr=ICalGrabValue(&Month, StartPtr);
            Month--;
            for (Year=0; Year<12; Year+=Rule->Interval) {
                for (Day=0; Day<31; Day++) {
                    if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                        Rule->Days[Year][Month][Day]++;
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYWEEKNO="))!=NULL) {
        unsigned long    D, M, Y;

        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=9;
        do {
            StartPtr=ICalGrabValue(&Week, StartPtr);
            for (Year=0; Year<12; Year+=Rule->Interval) {
                /* Calculate when the first week of the year happens; a week must be at least 4 days long */
                Offset=MsgGetRataDie(1, 1, ICal->Start.Year+Year);
                Value=Offset-(Offset % 7)+Rule->WeekStart;    /* Calculate WkSt */
                Value=Value-Offset;
                if (Value>=4) {
                    /* StartRD stays needs to point to last weekstart in last year; we've got enough days in the new year*/
                    Offset-=Value-1;
                } else if (Value>0) {
                    /* We don't have enough days in the new year, week starts a few days into the year */
                    Offset-=7-Value;
                } else if (Value<=-4) {
                    Offset+=Value+1;
                } else if (Value<0) {
                    Offset+=Value;
                }
                /* Now Offset points to when we start the week; now we can mark the proper weeks */
                Offset+=7*(Week-1);
                for (Day=Offset; Day<((unsigned long)Offset+7); Day++) {
                    /* We calculate every day separate, due to the fact that our array always has 31 days for a month */
                    MsgGetDate(Day, &D, &M, &Y);
                    D--;
                    M--;
                    Y-=ICal->Start.Year;
                    if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                        Rule->Days[Y][M][D]++;
                    }
                }
            }

        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYYEARDAY="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=10;
        do {
            StartPtr=ICalGrabValue(&YearDay, StartPtr);
            for (Offset=0; Offset<12; Offset+=Rule->Interval) {
                if (YearDay>0) {
                    Value=MsgGetRataDie(1,1,Offset+ICal->Start.Year)+YearDay-1;
                } else {
                    Value=MsgGetRataDie(1,1,Offset+ICal->Start.Year+1)+YearDay;    /* YearDay is negative already */
                }
                MsgGetDate(Value, &Day, &Month, &Year);
                Day--;
                Month--;
                Year-=ICal->Start.Year;
                if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                    Rule->Days[Year][Month][Day]++;
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYMONTHDAY="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=11;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);
            /* Go through all years and mark the days in every month */
            for (Year=0; Year<12; Year+=Rule->Interval) {
                for (Month=0; Month<12; Month++) {
                    if (Value>0 && Value<32) {
                        ptr2=(unsigned char *)(Rule->Days)+(Year*12*31)+(Month*31)+Value-1;
                    } else {
                        Day=MSG_DAYS_IN_MONTH(Month+1, Year+ICal->Start.Year)+Value;
                        ptr2=(unsigned char *)(Rule->Days)+(Year*12*31)+(Month*31)+Day;
                    }
                    if (*ptr2==Rule->DaysTop) {
                        (*ptr2)++;
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYDAY="))!=NULL) {
        unsigned long    D, M, Y;
        long                Occurrence;

        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=6;
        do {
            StartPtr=ICalGrabWDay(&Offset, &WeekDay, StartPtr);
            if (Offset==0) {
                for (Year=0; Year<12; Year+=Rule->Interval) {
                    RD1=MsgGetRataDie(1,1,Year+ICal->Start.Year);
                    RD2=MsgGetRataDie(1,1,Year+ICal->Start.Year+1);
                    for (Day=RD1; Day<RD2; Day++) {
                        if ((Day % 7)==WeekDay) {

                            MsgGetDate(Day, &D, &M, &Y);
                            D--;
                            M--;
                            Y-=ICal->Start.Year;
                            if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                                Rule->Days[Y][M][D]++;
                            }
                        }
                    }
                }
            } else if (Offset>0) {
                for (Year=0; Year<12; Year+=Rule->Interval) {
                    Occurrence=0;
                    RD1=MsgGetRataDie(1,1,Year+ICal->Start.Year);
                    RD2=MsgGetRataDie(1,1,Year+ICal->Start.Year+1);
                    for (Day=RD1; Day<RD2; Day++) {
                        if ((Day % 7)==WeekDay) {
                            MsgGetDate(Day, &D, &M, &Y);
                            D--;
                            M--;
                            Y-=ICal->Start.Year;
                            if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                                Occurrence++;
                                if (Occurrence==Offset) {
                                    Rule->Days[Y][M][D]++;
                                    break;
                                }
                            }
                        }
                    }
                }
            } else if (Offset<0) {
                Offset*=-1;
                for (Year=0; Year<12; Year+=Rule->Interval) {
                    Occurrence=0;
                    RD1=MsgGetRataDie(1,1,Year+ICal->Start.Year);
                    RD2=MsgGetRataDie(1,1,Year+ICal->Start.Year+1);
                    for (Day=RD2-1; Day>=RD1; Day--) {
                        if ((Day % 7)==WeekDay) {
                            MsgGetDate(Day, &D, &M, &Y);
                            D--;
                            M--;
                            Y-=ICal->Start.Year;
                            if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                                Occurrence++;
                                if (Occurrence==Offset) {
                                    Rule->Days[Y][M][D]++;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYHOUR="))!=NULL) {
        BOOL    HaveMinute=FALSE;

        if (strstr(RuleText, "BYMINUTE=")) {
            HaveMinute=TRUE;
        }
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=7;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);
            /* Go through all years and mark the days in every month */
            if (HaveMinute) {
                for (Minute=0; Minute<60; Minute++) {
                    if (Value>=0 && Value<24) {
                        if (Rule->Hours[Value][Minute]==Rule->HoursTop) {
                            Rule->Hours[Value][Minute]++;
                        }
                    }
                }
            } else {
                if (Rule->Hours[Value][ICal->Start.Minute]==Rule->HoursTop) {
                    Rule->Hours[Value][ICal->Start.Minute]++;
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->HoursTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYMINUTE="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=9;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);
            /* Go through all years and mark the days in every month */
            for (Hour=0; Hour<60; Hour++) {
                if (Value>=0 && Value<60) {
                    if (Rule->Hours[Hour][Value]==Rule->HoursTop) {
                        Rule->Hours[Hour][Value]++;
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->HoursTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYSETPOS="))!=NULL) {
        long    Match;

        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }

        StartPtr+=9;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);

            if (Value>0) {
                for (Year=0; Year<12; Year+=Rule->Interval) {
                    Match=0;
                    for (Month=0; Month<12; Month++) {
                        for (Day=0; Day<31; Day++) {
                            if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                                Match++;
                                if (Match==Value) {
                                    Rule->Days[Year][Month][Day]++;
                                    Day=31;
                                    Month=12;
                                    break;
                                }
                            }
                        }
                    }
                }
            } else {
                Value*=-1;
                for (Year=0; Year<12; Year+=Rule->Interval) {
                    Match=0;
                    for (Month=11; (long)Month>=0; Month--) {
                        for (Day=30; (long)Day>=0; Day--) {
                            if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                                Match++;
                                if (Match==Value) {
                                    Rule->Days[Year][Month][Day]++;
                                    Day=0;
                                    Month=0;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if (!strstr(RuleText, "BYDAY=") && !strstr(RuleText, "BYMONTHDAY=") && !strstr(RuleText, "BYYEARDAY=")) {
        /* Take day from date */
        for (Year=0; Year<12; Year+=Rule->Interval) {
            for (Month=0; Month<12; Month++) {
                if (Rule->Days[Year][Month][ICal->Start.Day-1]==Rule->DaysTop) {
                    Rule->Days[Year][Month][ICal->Start.Day-1]++;
                }
            }
        }
        Rule->DaysTop++;
    }
    
    /* If your actual start date hasn't been set yet, mark it, too */
#ifdef MARK_START
    Rule->Days[0][ICal->Start.Month-1][ICal->Start.Day-1]=Rule->DaysTop;
#endif

    /* We might have a yearly rule without any BYxxx arguments; in that case we should mark the start date in every year... */
    if (Rule->DaysTop==0) {
        for (Year=0; Year<12; Year+=Rule->Interval) {
            ptr2=(unsigned char *)(Rule->Days)+(Year*12*31)+((ICal->Start.Month-1)*31)+ICal->Start.Day-1;
            (*ptr2)++;
        }
        Rule->DaysTop++;
    }

    /* Figure out HoursTop */
    if (Rule->HoursTop==0) {
        Rule->Hours[ICal->Start.Hour][ICal->Start.Minute]++;
        Rule->HoursTop++;
    }

    return(TRUE);
}

BOOL
ICalProcessMonthlyRule(ICalObject *ICal, ICalVRule *Rule, unsigned char *RuleText)
{
    unsigned char    *ptr=RuleText;
    unsigned char    *StartPtr=RuleText;
    unsigned long    StartRD;
    long                Value;
    unsigned long    Day;
    unsigned long    Month;
    unsigned long    Year;
    long                Week;
    long                YearDay;
    unsigned char    WeekDay;
    long                Offset;
    unsigned char    *ptr2;
    unsigned char    Hour;
    unsigned char    Minute;
    unsigned long    RD1;
    unsigned long    RD2;

    /* Prepare our calendar array */
    StartRD=MsgGetRataDie(1, 1, ICal->Start.Year);
    for (Year=0; Year<12; Year++) {
        for (Month=1; Month<12; Month++) {
            for (Day=MSG_DAYS_IN_MONTH(Month, Year+ICal->Start.Year); Day<31; Day++) {
                Rule->Days[Year][Month-1][Day]=-1;
            }
        }
    }

    /* Now parse each BY_xx qualifier */
    if ((StartPtr=strstr(RuleText, "BYMONTH="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }

        StartPtr+=8;
        do {
            StartPtr=ICalGrabValue(&Month, StartPtr);
            Month--;
            for (Year=0; Year<12; Year++) {
                for (Day=0; Day<31; Day++) {
                    if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                        Rule->Days[Year][Month][Day]++;
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYWEEKNO="))!=NULL) {
        unsigned long    D, M, Y;

        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=9;
        do {
            StartPtr=ICalGrabValue(&Week, StartPtr);
            for (Year=0; Year<12; Year++) {
                /* Calculate when the first week of the year happens; a week must be at least 4 days long */
                Offset=MsgGetRataDie(1, 1, ICal->Start.Year+Year);
                Value=Offset-(Offset % 7)+Rule->WeekStart;    /* Calculate WkSt */
                Value=Value-Offset;
                if (Value>=4) {
                    /* StartRD stays needs to point to last weekstart in last year; we've got enough days in the new year*/
                    Offset-=Value-1;
                } else if (Value>0) {
                    /* We don't have enough days in the new year, week starts a few days into the year */
                    Offset-=7-Value;
                } else if (Value<=-4) {
                    Offset+=Value+1;
                } else if (Value<0) {
                    Offset+=Value;
                }
                /* Now Offset points to when we start the week; now we can mark the proper weeks */
                Offset+=7*(Week-1);
                for (Day=Offset; Day<((unsigned long)Offset+7); Day++) {
                    /* We calculate every day separate, due to the fact that our array always has 31 days for a month */
                    MsgGetDate(Day, &D, &M, &Y);
                    D--;
                    M--;
                    Y-=ICal->Start.Year;
                    if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                        Rule->Days[Y][M][D]++;
                    }
                }
            }

        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYYEARDAY="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=10;
        do {
            StartPtr=ICalGrabValue(&YearDay, StartPtr);
            for (Offset=0; Offset<12; Offset++) {
                if (YearDay>0) {
                    Value=MsgGetRataDie(1,1,Offset+ICal->Start.Year)+YearDay-1;
                } else {
                    Value=MsgGetRataDie(1,1,Offset+ICal->Start.Year+1)+YearDay;    /* YearDay is negative already */
                }
                MsgGetDate(Value, &Day, &Month, &Year);
                Day--;
                Month--;
                Year-=ICal->Start.Year;
                if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                    Rule->Days[Year][Month][Day]++;
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYMONTHDAY="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=11;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);
            /* Go through all years and mark the days in every month */
            for (Month=ICal->Start.Month-1; Month<(12*12); Month+=Rule->Interval) {
                Year=Month/12;
                if (Value>0 && Value<32) {
                    ptr2=(unsigned char *)(Rule->Days)+(Year*12*31)+((Month%12)*31)+Value-1;
                } else {
                    Day=MSG_DAYS_IN_MONTH((Month%12)+1, Year+ICal->Start.Year)+Value;
                    ptr2=(unsigned char *)(Rule->Days)+(Year*12*31)+((Month%12)*31)+Day;
                }
                if ((*ptr2)==Rule->DaysTop) {
                    (*ptr2)++;
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYDAY="))!=NULL) {
        unsigned long    D, M, Y;
        long                Occurrence;

        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=6;
        do {
            StartPtr=ICalGrabWDay(&Offset, &WeekDay, StartPtr);
            if (Offset==0) {
                for (Month=ICal->Start.Month-1; Month<(12*12); Month+=Rule->Interval) {
                    RD1=MsgGetRataDie(1, (Month % 12)+1, Month/12+ICal->Start.Year);
                    RD2=MsgGetRataDie(1, (Month % 12)+2, Month/12+ICal->Start.Year);
                    for (Day=RD1; Day<RD2; Day++) {
                        if ((Day % 7)==WeekDay) {

                            MsgGetDate(Day, &D, &M, &Y);
                            D--;
                            M--;
                            Y-=ICal->Start.Year;
                            if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                                Rule->Days[Y][M][D]++;
                            }
                        }
                    }
                }
            } else if (Offset>0) {
                for (Month=ICal->Start.Month-1; Month<(12*12); Month+=Rule->Interval) {
                    Occurrence=0;
                    RD1=MsgGetRataDie(1, (Month % 12)+1, Month/12+ICal->Start.Year);
                    RD2=MsgGetRataDie(1, (Month % 12)+2, Month/12+ICal->Start.Year);
                    for (Day=RD1; Day<RD2; Day++) {
                        if ((Day % 7)==WeekDay) {
                            MsgGetDate(Day, &D, &M, &Y);
                            D--;
                            M--;
                            Y-=ICal->Start.Year;
                            if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                                Occurrence++;
                                if (Occurrence==Offset) {
                                    Rule->Days[Y][M][D]++;
                                    break;
                                }
                            }
                        }
                    }
                }
            } else if (Offset<0) {
                Offset*=-1;
                for (Month=ICal->Start.Month-1; Month<(12*12); Month+=Rule->Interval) {
                    Occurrence=0;
                    RD1=MsgGetRataDie(1, (Month % 12)+1, Month/12+ICal->Start.Year);
                    RD2=MsgGetRataDie(1, (Month % 12)+2, Month/12+ICal->Start.Year);
                    for (Day=RD2-1; Day>=RD1; Day--) {
                        if ((Day % 7)==WeekDay) {
                            MsgGetDate(Day, &D, &M, &Y);
                            D--;
                            M--;
                            Y-=ICal->Start.Year;
                            if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                                Occurrence++;
                                if (Occurrence==Offset) {
                                    Rule->Days[Y][M][D]++;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYHOUR="))!=NULL) {
        BOOL    HaveMinute=FALSE;

        if (strstr(RuleText, "BYMINUTE=")) {
            HaveMinute=TRUE;
        }
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=7;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);
            /* Go through all years and mark the days in every month */
            if (HaveMinute) {
                for (Minute=0; Minute<60; Minute++) {
                    if (Value>=0 && Value<24) {
                        if (Rule->Hours[Value][Minute]==Rule->HoursTop) {
                            Rule->Hours[Value][Minute]++;
                        }
                    }
                }
            } else {
                if (Rule->Hours[Value][ICal->Start.Minute]==Rule->HoursTop) {
                    Rule->Hours[Value][ICal->Start.Minute]++;
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->HoursTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYMINUTE="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=9;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);
            /* Go through all years and mark the days in every month */
            for (Hour=0; Hour<60; Hour++) {
                if (Value>=0 && Value<60) {
                    if (Rule->Hours[Hour][Value]==Rule->HoursTop) {
                        Rule->Hours[Hour][Value]++;
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->HoursTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYSETPOS="))!=NULL) {
        long    Match;

        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }

        StartPtr+=9;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);

            if (Value>0) {
                Year=0;
                Month=ICal->Start.Month-1;

                while (Year<12) {
                    Match=0;
                    for (Day=0; Day<31; Day++) {
                        if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                            Match++;
                            if (Match==Value) {
                                Rule->Days[Year][Month][Day]++;
                                break;
                            }
                        }
                    }
                    Month+=Rule->Interval;
                    if (Month>11) {
                        Year+=Month / 12;
                        Month=Month % 12;
                    }
                }
            } else {
                Value*=-1;
                Year=0;
                Month=ICal->Start.Month-1;

                while (Year<12) {
                    Match=0;
                    for (Day=30; (long)Day>=0; Day--) {
                        if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                            Match++;
                            if (Match==Value) {
                                Rule->Days[Year][Month][Day]++;
                                break;
                            }
                        }
                    }
                    Month+=Rule->Interval;
                    if (Month>11) {
                        Year+=Month / 12;
                        Month=Month % 12;
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }
    
    /* If your actual start date hasn't been set yet, mark it, too */
#ifdef MARK_START
    Rule->Days[0][ICal->Start.Month-1][ICal->Start.Day-1]=Rule->DaysTop;
#endif

    /* We might have a monthly rule without any BYxxx arguments; in that case we should mark every month... */
    if (Rule->DaysTop==0) {
        for (Month=ICal->Start.Month-1; Month<(12*12); Month+=Rule->Interval) {
            Year=Month/12;
            ptr2=(unsigned char *)(Rule->Days)+(Year*12*31)+((Month%12)*31)+ICal->Start.Day-1;
            (*ptr2)++;
        }
        Rule->DaysTop++;
    }
    
    if (Rule->HoursTop==0) {
        Rule->Hours[ICal->Start.Hour][ICal->Start.Minute]++;
        Rule->HoursTop++;
    }

    return(TRUE);
}

BOOL
ICalProcessDailyRule(ICalObject *ICal, ICalVRule *Rule, unsigned char *RuleText)
{
    unsigned char    *ptr=RuleText;
    unsigned char    *StartPtr=RuleText;
    unsigned long    StartRD;
    long                Value;
    unsigned long    Day;
    unsigned long    Month;
    unsigned long    Year;
    long                Week;
    long                YearDay;
    unsigned char    WeekDay;
    long                Offset;
    unsigned char    *ptr2;
    unsigned char    Hour;
    unsigned char    Minute;
    unsigned long    RD1;
    unsigned long    RD2;

    /* Prepare our calendar array */
    StartRD=MsgGetRataDie(1, 1, ICal->Start.Year);
    for (Year=0; Year<12; Year++) {
        for (Month=1; Month<12; Month++) {
            for (Day=MSG_DAYS_IN_MONTH(Month, Year+ICal->Start.Year); Day<31; Day++) {
                Rule->Days[Year][Month-1][Day]=-1;
            }
        }
    }

    /* Now parse each BY_xx qualifier */
    if ((StartPtr=strstr(RuleText, "BYMONTH="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=8;
        do {
            StartPtr=ICalGrabValue(&Month, StartPtr);
            Month--;
            for (Year=0; Year<12; Year++) {
                for (Day=0; Day<31; Day++) {
                    if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                        Rule->Days[Year][Month][Day]++;
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYWEEKNO="))!=NULL) {
        unsigned long    D, M, Y;

        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=9;
        do {
            StartPtr=ICalGrabValue(&Week, StartPtr);
            for (Year=0; Year<12; Year++) {
                /* Calculate when the first week of the year happens; a week must be at least 4 days long */
                Offset=MsgGetRataDie(1, 1, ICal->Start.Year+Year);
                Value=Offset-(Offset % 7)+Rule->WeekStart;    /* Calculate WkSt */
                Value=Value-Offset;
                if (Value>=4) {
                    /* StartRD stays needs to point to last weekstart in last year; we've got enough days in the new year*/
                    Offset-=Value-1;
                } else if (Value>0) {
                    /* We don't have enough days in the new year, week starts a few days into the year */
                    Offset-=7-Value;
                } else if (Value<=-4) {
                    Offset+=Value+1;
                } else if (Value<0) {
                    Offset+=Value;
                }
                /* Now Offset points to when we start the week; now we can mark the proper weeks */
                Offset+=7*(Week-1);
                for (Day=Offset; Day<((unsigned long)Offset+7); Day++) {
                    /* We calculate every day separate, due to the fact that our array always has 31 days for a month */
                    MsgGetDate(Day, &D, &M, &Y);
                    D--;
                    M--;
                    Y-=ICal->Start.Year;
                    if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                        Rule->Days[Y][M][D]++;
                    }
                }
            }

        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYYEARDAY="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=10;
        do {
            StartPtr=ICalGrabValue(&YearDay, StartPtr);
            for (Offset=0; Offset<12; Offset++) {
                if (YearDay>0) {
                    Value=MsgGetRataDie(1,1,Offset+ICal->Start.Year)+YearDay-1;
                } else {
                    Value=MsgGetRataDie(1,1,Offset+ICal->Start.Year+1)+YearDay;    /* YearDay is negative already */
                }
                MsgGetDate(Value, &Day, &Month, &Year);
                Day--;
                Month--;
                Year-=ICal->Start.Year;
                if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                    Rule->Days[Year][Month][Day]++;
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYMONTHDAY="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=11;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);
            /* Go through all years and mark the days in every month */
            for (Month=ICal->Start.Month-1; Month<(12*12); Month++) {
                Year=Month/12;
                if (Value>0 && Value<32) {
                    ptr2=(unsigned char *)(Rule->Days)+(Year*12*31)+((Month%12)*31)+Value-1;
                } else {
                    Day=MSG_DAYS_IN_MONTH((Month%12)+1, Year+ICal->Start.Year)+Value;
                    ptr2=(unsigned char *)(Rule->Days)+(Year*12*31)+((Month%12)*31)+Day;
                }
                if ((*ptr2)==Rule->DaysTop) {
                    (*ptr2)++;
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYDAY="))!=NULL) {
        unsigned long    D, M, Y;
        long                Occurrence;

        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=6;
        do {
            StartPtr=ICalGrabWDay(&Offset, &WeekDay, StartPtr);
            if (Offset==0) {
                RD1=MsgGetRataDie(ICal->Start.Day, ICal->Start.Month, ICal->Start.Year);
                RD2=MsgGetRataDie(1, 1, ICal->Start.Year+12);

                for (Day=RD1; Day<RD2; Day+=Rule->Interval) {
                    if ((Day % 7)==WeekDay) {

                        MsgGetDate(Day, &D, &M, &Y);
                        D--;
                        M--;
                        Y-=ICal->Start.Year;
                        if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                            Rule->Days[Y][M][D]++;
                        }
                    }
                }
            } else if (Offset>0) {
                RD1=MsgGetRataDie(ICal->Start.Day, ICal->Start.Month, ICal->Start.Year);
                RD2=MsgGetRataDie(1, 1, ICal->Start.Year+12);

                Occurrence=0;
                for (Day=RD1; Day<RD2; Day+=Rule->Interval) {
                    if ((Day % 7)==WeekDay) {
                        MsgGetDate(Day, &D, &M, &Y);
                        D--;
                        M--;
                        Y-=ICal->Start.Year;
                        if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                            Occurrence++;
                            if (Occurrence==Offset) {
                                Rule->Days[Y][M][D]++;
                                break;
                            }
                        }
                    }
                }
            } else if (Offset<0) {
                Offset*=-1;
                RD1=MsgGetRataDie(ICal->Start.Day, ICal->Start.Month, ICal->Start.Year);
                RD2=MsgGetRataDie(1, 1, ICal->Start.Year+12);

                Occurrence=0;
                for (Day=RD2-1; Day>=RD1; Day--) {
                    if ((Day % 7)==WeekDay) {
                        MsgGetDate(Day, &D, &M, &Y);
                        D--;
                        M--;
                        Y-=ICal->Start.Year;
                        if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                            Occurrence++;
                            if (Occurrence==Offset) {
                                Rule->Days[Y][M][D]++;
                                break;
                            }
                        }
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYHOUR="))!=NULL) {
        BOOL    HaveMinute=FALSE;

        if (strstr(RuleText, "BYMINUTE=")) {
            HaveMinute=TRUE;
        }
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=7;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);
            /* Go through all years and mark the days in every month */
            if (HaveMinute) {
                for (Minute=0; Minute<60; Minute++) {
                    if (Value>=0 && Value<24) {
                        if (Rule->Hours[Value][Minute]==Rule->HoursTop) {
                            Rule->Hours[Value][Minute]++;
                        }
                    }
                }
            } else {
                if (Rule->Hours[Value][ICal->Start.Minute]==Rule->HoursTop) {
                    Rule->Hours[Value][ICal->Start.Minute]++;
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->HoursTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYMINUTE="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=9;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);
            /* Go through all years and mark the days in every month */
            for (Hour=0; Hour<60; Hour++) {
                if (Value>=0 && Value<60) {
                    if (Rule->Hours[Hour][Value]==Rule->HoursTop) {
                        Rule->Hours[Hour][Value]++;
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->HoursTop++;
    }

#if 0
    /* Doesn't make sense on days */
    if ((StartPtr=strstr(RuleText, "BYSETPOS="))!=NULL) {
        long    Match;
        int    DaysInMonth;

        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }

        StartPtr+=9;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);

            if (Value>0) {
                Year=0;
                Month=ICal->Start.Month-1;
                Day=ICal->Start.Day-1;
                Match=0;
                DaysInMonth=MSG_DAYS_IN_MONTH(Month, Year+ICal->Start.Year);

                while (Year<12) {
                    if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                        Match++;
                        if (Match==Value) {
                            Rule->Days[Year][Month][Day]++;
                            break;
                        }
                    }
                    Day+=Rule->Interval;
                    if (Day>=DaysInMonth) {
                        Match=0;
                        do {
                            Day-=DaysInMonth;
                            Month++;
                            if (Month>11) {
                                Year+=Month / 12;
                                Month=Month % 12;
                            }
                            DaysInMonth=MSG_DAYS_IN_MONTH(Month, Year+ICal->Start.Year);
                        } while (Day>DaysInMonth);
                    }
                }
            } else {
                Value*=-1;

                Year=0;
                Month=0;
                Match=0;
                DaysInMonth=MSG_DAYS_IN_MONTH(Month, Year+ICal->Start.Year);
                lDay=DaysInMonth-1;

                while (Year<12) {
                    if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                        Match++;
                        if (Match==Value) {
                            Rule->Days[Year][Month][Day]++;
                            break;
                        }
                    }
                    Day-=Rule->Interval;
                    if ((long)Day>=DaysInMonth) {
                        Match=0;
                        do {
                            Day-=DaysInMonth;
                            Month++;
                            if (Month>11) {
                                Year+=Month / 12;
                                Month=Month % 12;
                            }
                            DaysInMonth=MSG_DAYS_IN_MONTH(Month, Year+ICal->Start.Year);
                        } while (Day>DaysInMonth);
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }
#endif
    
    /* If your actual start date hasn't been set yet, mark it, too */
#ifdef MARK_START
    Rule->Days[0][ICal->Start.Month-1][ICal->Start.Day-1]=Rule->DaysTop;
#endif

    /* We might have a daily rule without any BYxxx arguments; in that case we should mark every matching day ... */
    if (Rule->DaysTop==0 && Rule->Interval!=1) {
        unsigned long    D, M, Y;
        unsigned long    RD1;
        unsigned long    RD2;

        RD1=MsgGetRataDie(ICal->Start.Day, ICal->Start.Month, ICal->Start.Year);
        RD2=MsgGetRataDie(1, 1, ICal->Start.Year+12);

        for (Day=RD1; Day<RD2; Day+=Rule->Interval) {
            MsgGetDate(Day, &D, &M, &Y);
            D--;
            M--;
            Y-=ICal->Start.Year;
            Rule->Days[Y][M][D]++;
        }
        Rule->DaysTop++;
    }

    if (Rule->HoursTop==0) {
        Rule->Hours[ICal->Start.Hour][ICal->Start.Minute]++;
        Rule->HoursTop++;
    }

    return(TRUE);
}

BOOL
ICalProcessWeeklyRule(ICalObject *ICal, ICalVRule *Rule, unsigned char *RuleText)
{
    unsigned char    *ptr=RuleText;
    unsigned char    *StartPtr=RuleText;
    unsigned long    StartRD;
    long                Value;
    unsigned long    Day;
    unsigned long    Month;
    unsigned long    Year;
    long                Week;
    long                YearDay;
    unsigned char    WeekDay;
    long                Offset;
    unsigned char    *ptr2;
    unsigned char    Hour;
    unsigned char    Minute;
    unsigned long    RD1;
    unsigned long    RD2;

    /* Prepare our calendar array */
    StartRD=MsgGetRataDie(1, 1, ICal->Start.Year);
    for (Year=0; Year<12; Year++) {
        for (Month=1; Month<12; Month++) {
            for (Day=MSG_DAYS_IN_MONTH(Month, Year+ICal->Start.Year); Day<31; Day++) {
                Rule->Days[Year][Month-1][Day]=-1;
            }
        }
    }

    /* Now parse each BY_xx qualifier */
    if ((StartPtr=strstr(RuleText, "BYMONTH="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }

        StartPtr+=8;
        do {
            StartPtr=ICalGrabValue(&Month, StartPtr);
            Month--;
            for (Year=0; Year<12; Year++) {
                for (Day=0; Day<31; Day++) {
                    if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                        Rule->Days[Year][Month][Day]++;
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYWEEKNO="))!=NULL) {
        unsigned long    D, M, Y;

        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=9;
        do {
            StartPtr=ICalGrabValue(&Week, StartPtr);
            for (Year=0; Year<12; Year++) {
                /* Calculate when the first week of the year happens; a week must be at least 4 days long */
                Offset=MsgGetRataDie(1, 1, ICal->Start.Year+Year);
                Value=Offset-(Offset % 7)+Rule->WeekStart;    /* Calculate WkSt */
                Value=Value-Offset;
                if (Value>=4) {
                    /* StartRD stays needs to point to last weekstart in last year; we've got enough days in the new year*/
                    Offset-=Value-1;
                } else if (Value>0) {
                    /* We don't have enough days in the new year, week starts a few days into the year */
                    Offset-=7-Value;
                } else if (Value<=-4) {
                    Offset+=Value+1;
                } else if (Value<0) {
                    Offset+=Value;
                }
                /* Now Offset points to when we start the week; now we can mark the proper weeks */
                Offset+=7*(Week-1);
                for (Day=Offset; Day<((unsigned long)Offset+7); Day++) {
                    /* We calculate every day separate, due to the fact that our array always has 31 days for a month */
                    MsgGetDate(Day, &D, &M, &Y);
                    D--;
                    M--;
                    Y-=ICal->Start.Year;
                    if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                        Rule->Days[Y][M][D]++;
                    }
                }
            }

        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYYEARDAY="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=10;
        do {
            StartPtr=ICalGrabValue(&YearDay, StartPtr);
            for (Offset=0; Offset<12; Offset++) {
                if (YearDay>0) {
                    Value=MsgGetRataDie(1,1,Offset+ICal->Start.Year)+YearDay-1;
                } else {
                    Value=MsgGetRataDie(1,1,Offset+ICal->Start.Year+1)+YearDay;    /* YearDay is negative already */
                }
                MsgGetDate(Value, &Day, &Month, &Year);
                Day--;
                Month--;
                Year-=ICal->Start.Year;
                if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                    Rule->Days[Year][Month][Day]++;
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYMONTHDAY="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=11;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);
            /* Go through all years and mark the days in every month */
            for (Month=ICal->Start.Month-1; Month<(12*12); Month++) {
                Year=Month/12;
                if (Value>0 && Value<32) {
                    ptr2=(unsigned char *)(Rule->Days)+(Year*12*31)+((Month%12)*31)+Value-1;
                } else {
                    Day=MSG_DAYS_IN_MONTH((Month%12)+1, Year+ICal->Start.Year)+Value;
                    ptr2=(unsigned char *)(Rule->Days)+(Year*12*31)+((Month%12)*31)+Day;
                }
                if ((*ptr2)==Rule->DaysTop) {
                    (*ptr2)++;
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYDAY="))!=NULL) {
        unsigned long    D, M, Y;

        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=6;
        do {
            StartPtr=ICalGrabWDay(&Offset, &WeekDay, StartPtr);
            if (Offset==0) {
                RD1=MsgGetRataDie(ICal->Start.Day, ICal->Start.Month, ICal->Start.Year);
                /* Round down to the previous weekstart */
                RD2=MsgGetRataDie(1, 1, ICal->Start.Year+12);
                Day=RD1;
                do {
                    if ((Day % 7)==WeekDay) {
                        MsgGetDate(Day, &D, &M, &Y);
                        D--;
                        M--;
                        Y-=ICal->Start.Year;
                        if (Rule->Days[Y][M][D]==Rule->DaysTop) {
                            Rule->Days[Y][M][D]++;
                        }
                    }
                    Day++;
                    if (((Day % 7)==Rule->WeekStart) && Rule->Interval>1) {
                        Day+=(Rule->Interval-1)*7;
                    }
                } while (Day<RD2);
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYHOUR="))!=NULL) {
        BOOL    HaveMinute=FALSE;

        if (strstr(RuleText, "BYMINUTE=")) {
            HaveMinute=TRUE;
        }
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=7;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);
            /* Go through all years and mark the days in every month */
            if (HaveMinute) {
                for (Minute=0; Minute<60; Minute++) {
                    if (Value>=0 && Value<24) {
                        if (Rule->Hours[Value][Minute]==Rule->HoursTop) {
                            Rule->Hours[Value][Minute]++;
                        }
                    }
                }
            } else {
                if (Rule->Hours[Value][ICal->Start.Minute]==Rule->HoursTop) {
                    Rule->Hours[Value][ICal->Start.Minute]++;
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->HoursTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYMINUTE="))!=NULL) {
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        StartPtr+=9;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);
            /* Go through all years and mark the days in every month */
            for (Hour=0; Hour<60; Hour++) {
                if (Value>=0 && Value<60) {
                    if (Rule->Hours[Hour][Value]==Rule->HoursTop) {
                        Rule->Hours[Hour][Value]++;
                    }
                }
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->HoursTop++;
    }

    if ((StartPtr=strstr(RuleText, "BYSETPOS="))!=NULL) {
        long                Match;
        unsigned long    DoW;
        unsigned long    RD;
        unsigned long    DaysInMonth;

        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }

        StartPtr+=9;
        do {
            StartPtr=ICalGrabValue(&Value, StartPtr);

            if (Value>0) {
                /* Rule->WeekStart = start of week */
                RD=MsgGetRataDie(ICal->Start.Day, ICal->Start.Month, ICal->Start.Year)-7;
                RD= RD - (RD % 7) + Rule->WeekStart;
                MsgGetDate(RD, &Day, &Month, &Year);
                Day--;
                Month--;
                Year-=ICal->Start.Year;
                DoW=0;

                Match=0;
                DaysInMonth=MSG_DAYS_IN_MONTH(Month+1, Year+ICal->Start.Year);

                while (Year<12) {
                    if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                        Match++;
                        if (Match==Value) {
                            Rule->Days[Year][Month][Day]++;
                            break;
                        }
                    }

                    DoW++;
                    if (DoW==7) {
                        Match=0;
                        DoW=0;
                        Day+=7*(Rule->Interval-1);
                    }
                    Day++;

                    if (Day>=DaysInMonth) {
                        do {
                            Day-=DaysInMonth;
                            Month++;
                            if (Month>11) {
                                Year+=Month / 12;
                                Month=Month % 12;
                            }
                            DaysInMonth=MSG_DAYS_IN_MONTH(Month+1, Year+ICal->Start.Year);
                        } while (Day>=DaysInMonth);
                    }
                }
            } else {
                Value*=-1;
#if 0
                /* Rule->WeekStart = start of week */
                RD=MsgGetRataDie(ICal->Start.Day, ICal->Start.Month, ICal->Start.Year)-7;
                RD= RD - (RD % 7) + Rule->WeekStart;
                MsgGetDate(RD, &Day, &Month, &Year);
                Day--;
                Month--;
                Year-=ICal->Start.Year;
                DoW=0;

                Match=0;
                DaysInMonth=MSG_DAYS_IN_MONTH(Month+1, Year+ICal->Start.Year);

                while (Year<12) {
                    if (Rule->Days[Year][Month][Day]==Rule->DaysTop) {
                        Match++;
                        if (Match==Value) {
                            Rule->Days[Year][Month][Day]++;
                            break;
                        }
                    }

                    DoW++;
                    if (Dow==7) {
                        Match=0;
                        DoW=0;
                        Day+=7*(Rule->Interval-1);
                    }
                    Day++;

                    if (Day>=DaysInMonth) {
                        do {
                            Day-=DaysInMonth;
                            Month++;
                            if (Month>11) {
                                Year+=Month / 12;
                                Month=Month % 12;
                            }
                            DaysInMonth=MSG_DAYS_IN_MONTH(Month+1, Year+ICal->Start.Year);
                        } while (Day>=DaysInMonth);
                    }
                }
#endif
            }
        } while (StartPtr);
        if (ptr) {
            *ptr=';';
        }
        Rule->DaysTop++;
    }
    
    /* If your actual start date hasn't been set yet, mark it, too */
#ifdef MARK_START
    Rule->Days[0][ICal->Start.Month-1][ICal->Start.Day-1]=Rule->DaysTop;
#endif

    /* We might have a weekly rule without any BYxxx arguments; in that case we should mark every month... */
    if (Rule->DaysTop==0) {
        unsigned long    D, M, Y;

        RD1=MsgGetRataDie(ICal->Start.Day, ICal->Start.Month, ICal->Start.Year);
        RD2=MsgGetRataDie(1, 1, ICal->Start.Year+12);
        for (Day=RD1; Day<RD2; Day+=(Rule->Interval*7)) {
            MsgGetDate(Day, &D, &M, &Y);
            D--;
            M--;
            Y-=ICal->Start.Year;
            Rule->Days[Y][M][D]++;
        }
        Rule->DaysTop++;
    }

    if (Rule->HoursTop==0) {
        Rule->Hours[ICal->Start.Hour][ICal->Start.Minute]++;
        Rule->HoursTop++;
    }

    return(TRUE);
}


BOOL
ICalProcessHourlyRule(ICalObject *ICal, ICalVRule *Rule, unsigned char *RuleText)
{
    unsigned char    *ptr=RuleText;
    unsigned char    *StartPtr=RuleText;
    long                Value;
    long                Hour;

    /* A hourly rule only goes for one day; we want to prevent huge, useless calendar files */
    Rule->DaysTop++;
    Rule->Days[0][ICal->Start.Month-1][ICal->Start.Day-1]=Rule->DaysTop;
    
    do {
        ptr=strchr(ptr+1, ';');
        if (ptr) {
            *ptr='\0';
        }

        if (ICalQuickNCmp(StartPtr, "BYMINUTE=", 9)) {
            StartPtr+=9;
            do {
                StartPtr=ICalGrabValue(&Value, StartPtr);
                if (Value<0) {
                    Value*=-1;
                }
                for (Hour=ICal->Start.Hour; Hour<ICal->Start.Hour+24; Hour+=Rule->Interval) {
                    if (Rule->Hours[Hour % 24][Value]==Rule->HoursTop) {
                        Rule->Hours[Hour % 24][Value]++;
                    }
                }
            } while (StartPtr);
            Rule->HoursTop++;
        }

        if (ptr) {
            *ptr=';';
        }
        StartPtr=ptr+1;
    } while (StartPtr!=(unsigned char *)1);
    
    /* If your actual start date hasn't been set yet, mark it, too */

    /* We might have a weekly rule without any BYxxx arguments; in that case we should mark every month... */
    if (Rule->HoursTop==0) {
        for (Hour=ICal->Start.Hour; Hour<ICal->Start.Hour+24; Hour+=Rule->Interval) {
            Rule->Hours[Hour % 24][ICal->Start.Minute]++;
        }
        Rule->HoursTop++;
    }
    
    return(TRUE);
}

BOOL
ICalProcessMinutelyRule(ICalObject *ICal, ICalVRule *Rule, unsigned char *RuleText)
{
    Rule->DaysTop++;
    Rule->Days[0][ICal->Start.Month-1][ICal->Start.Day-1]=Rule->DaysTop;
    Rule->HoursTop++;
    Rule->Hours[ICal->Start.Hour][ICal->Start.Minute]=Rule->HoursTop;
    return(TRUE);
}

BOOL
ICalProcessSecondlyRule(ICalObject *ICal, ICalVRule *Rule, unsigned char *RuleText)
{
    Rule->DaysTop++;
    Rule->Days[0][ICal->Start.Month-1][ICal->Start.Day-1]=Rule->DaysTop;
    Rule->HoursTop++;
    Rule->Hours[ICal->Start.Hour][ICal->Start.Minute]=Rule->HoursTop;
    return(TRUE);
}

BOOL
ICalParseRecurrenceRule(ICalObject *ICal, unsigned char *RuleText)
{
    ICalVRule                *Rule;
    ICalVTimeZone        *Timezone=ICal->Timezone;
    unsigned char    *ptr;
    unsigned char    *StartPtr;

    /* Make sure the RuleText is all uppercase */
    ptr=RuleText;
    while (*ptr) {
        if (islower(*ptr)) {
            *ptr=toupper(*ptr);
        }
        ptr++;
    }

    /* First, find the frequency */
    if ((StartPtr=strstr(RuleText, "FREQ="))==NULL) {
        return(FALSE);
    }

    Rule=ICalNewRule(ICal);
    if (!Rule) {
        return(FALSE);
    }

    StartPtr+=5;
    ptr=strchr(StartPtr, ';');
    if (ptr) {
        *ptr='\0';
    }
    if (ICalQuickCmp(StartPtr, "YEARLY")) {
        Rule->Frequency=ICAL_RULE_YEARLY;
    } else if (ICalQuickCmp(StartPtr, "MONTHLY")) {
        Rule->Frequency=ICAL_RULE_MONTHLY;
    } else if (ICalQuickCmp(StartPtr, "WEEKLY")) {
        Rule->Frequency=ICAL_RULE_WEEKLY;
    } else if (ICalQuickCmp(StartPtr, "DAILY")) {
        Rule->Frequency=ICAL_RULE_DAILY;
    } else if (ICalQuickCmp(StartPtr, "HOURLY")) {
        Rule->Frequency=ICAL_RULE_HOURLY;
    } else if (ICalQuickCmp(StartPtr, "MINUTELY")) {
        Rule->Frequency=ICAL_RULE_MINUTELY;
    } else if (ICalQuickCmp(StartPtr, "SECONDLY")) {
        Rule->Frequency=ICAL_RULE_SECONDLY;
    } else {
        if (ptr) {
            *ptr=';';
        }
        return(FALSE);
    }
    if (ptr) {
        *ptr=';';
    }

    /* Now we have the frequency; check for an interval, if any */
    if ((StartPtr=strstr(RuleText, "INTERVAL="))!=NULL) {
        StartPtr+=9;
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        Rule->Interval=atol(StartPtr);
        if (ptr) {
            *ptr=';';
        }
    } else {
        Rule->Interval=1;
    }

    /* Might have a WeekStart; get it now; default, according to spec is monday */
    if ((StartPtr=strstr(RuleText, "WKST="))!=NULL) {
        StartPtr+=5;
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        if (StartPtr[0]=='S' && StartPtr[1]=='U') {
            Rule->WeekStart=0;
        } else if (StartPtr[0]=='M' && StartPtr[1]=='O') {
            Rule->WeekStart=1;
        } else if (StartPtr[0]=='T' && StartPtr[1]=='U') {
            Rule->WeekStart=2;
        } else if (StartPtr[0]=='W' && StartPtr[1]=='E') {
            Rule->WeekStart=3;
        } else if (StartPtr[0]=='T' && StartPtr[1]=='H') {
            Rule->WeekStart=4;
        } else if (StartPtr[0]=='F' && StartPtr[1]=='R') {
            Rule->WeekStart=5;
        } else if (StartPtr[0]=='S' && StartPtr[1]=='A') {
            Rule->WeekStart=6;
        }
        if (ptr) {
            *ptr=';';
        }
    } else {
        Rule->WeekStart=1;
    }


    /* Now we have the frequency; find either the UNTIL or the COUNT */
    if ((StartPtr=strstr(RuleText, "UNTIL="))!=NULL) {
        StartPtr+=6;
        ptr=strchr(StartPtr, ';');
        if (ptr) {
            *ptr='\0';
        }
        Rule->Until=ICalParseRuleDateTime(Rule, Timezone, StartPtr);
        if (ptr) {
            *ptr=';';
        }
    } else if ((StartPtr=strstr(RuleText, "COUNT="))!=NULL) {
        Rule->Count=atol(StartPtr+6);
    } else {
        //return(FALSE);
    }

    /*
        We now know the frequency and how often or until when the event repeats
        Now we need to build the array of dates that the event actually occurs on.
    */

    /* Now start parsing the rules */    
    switch(Rule->Frequency) {
        case ICAL_RULE_YEARLY:        ICalProcessYearlyRule(ICal, Rule, RuleText); break;
        case ICAL_RULE_MONTHLY:        ICalProcessMonthlyRule(ICal, Rule, RuleText); break;
        case ICAL_RULE_DAILY:        ICalProcessDailyRule(ICal, Rule, RuleText); break;
        case ICAL_RULE_WEEKLY:        ICalProcessWeeklyRule(ICal, Rule, RuleText); break;
        case ICAL_RULE_HOURLY:        ICalProcessHourlyRule(ICal, Rule, RuleText); break;
        case ICAL_RULE_MINUTELY:    ICalProcessMinutelyRule(ICal, Rule, RuleText); break;
        case ICAL_RULE_SECONDLY:    ICalProcessSecondlyRule(ICal, Rule, RuleText); break;
    }

    return(TRUE);
}

BOOL
ICalParseSummary(ICalObject *ICal, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *Value;
    BOOL                IsValue;

    Value=MemMalloc(strlen(Text)+1);

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (IsValue) {
            ICal->Summary=Value;
        }
    } while (!IsValue && ptr);

    return(TRUE);
}

BOOL
ICalParseContact(ICalObject *ICal, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *Value;
    BOOL                IsValue;

    Value=MemMalloc(strlen(Text)+1);

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (IsValue) {
            ICal->Contact=Value;
        }
    } while (!IsValue && ptr);

    return(TRUE);
}

BOOL
ICalParseDescription(ICalObject *ICal, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *Value;
    BOOL                IsValue;

    Value=MemMalloc(strlen(Text)+1);

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (IsValue) {
            ICal->Description=Value;
        }
    } while (!IsValue && ptr);

    return(TRUE);
}


BOOL
ICalParseUID(ICalObject *ICal, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *Value;
    BOOL                IsValue;

    Value=MemMalloc(strlen(Text)+1);

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (IsValue) {
            ICal->UID=Value;
        }
    } while (!IsValue && ptr);

    return(TRUE);
}

BOOL
ICalParseLocation(ICalObject *ICal, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *Value;
    BOOL                IsValue;

    Value=MemMalloc(strlen(Text)+1);

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (IsValue) {
            ICal->Location=Value;
        }
    } while (!IsValue && ptr);

    return(TRUE);
}

ICalVRule
*ICalNewRule(ICalObject *Parent)
{
    ICalVRule *New;

    New=MemMalloc(sizeof(ICalVRule));
    if (!New) {
        return(NULL);
    }
    memset(New, 0, sizeof(ICalVRule));
    if (Parent) {
        Parent->Rule=New;
    }
    return(New);
}

BOOL
ICalFreeRule(ICalObject *Parent)
{
    if (Parent->Rule) {
        MemFree(Parent->Rule);
        Parent->Rule=NULL;
    }
    return(TRUE);
}

ICalVTimeZone *
ICalNewTimezone(ICalObject *Parent)
{
    ICalVTimeZone *New;
    ICalVTimeZone *Insert;

    New=MemMalloc(sizeof(ICalVTimeZone));
    if (!New) {
        return(NULL);
    }
    memset(New, 0, sizeof(ICalVTimeZone));
    if (Parent) {
        Insert=Parent->Timezone;
        if (Insert) {
            while (Insert->Next) {
                Insert = Insert->Next;
            }
           Insert->Next = New;
        } else {
            Parent->Timezone = New;
        }
    }
    return(New);
}

BOOL
ICalFreeTimezone(ICalObject *Parent)
{
    ICalVTimeZone    *Timezone=Parent->Timezone;
    ICalVTimeZone    *Next;

    if (!Timezone) {
        return(FALSE);
    }

    do {
        Next = Timezone->Next;
        if (Timezone->TZName) {
            MemFree(Timezone->TZName);
        }
        MemFree(Timezone);
        Timezone=Next;
    } while (Timezone);

    Parent->Timezone=NULL;
    return(TRUE);
}

ICalVFreeBusy
*ICalNewFreeBusy(ICalObject *Parent)
{
    ICalVFreeBusy *New;
    ICalVFreeBusy *Insert;

    New = (void *)MemMalloc(sizeof(ICalVFreeBusy));
    if (!New) {
        return(NULL);
    }
    memset(New, 0, sizeof(ICalVFreeBusy));
    if (Parent) {
        Insert = Parent->FreeBusy;
        if (Insert) {
            while (Insert->Next) {
                Insert = Insert->Next;
            }
            Insert->Next = New;
        } else {
            Parent->FreeBusy = New;
        }
    }
    return(New);
}

BOOL
ICalFreeFreeBusy(ICalObject *Parent)
{
    ICalVFreeBusy *FreeBusy=Parent->FreeBusy;
    ICalVFreeBusy *Next;

    if (!FreeBusy) {
        return(FALSE);
    }

    do {
        Next = FreeBusy->Next;
        MemFree(FreeBusy);
        FreeBusy=Next;
    } while (FreeBusy);

    Parent->FreeBusy=NULL;
    return(TRUE);
}

BOOL
ICalFreeAttendees(ICalObject *Parent)
{
    ICalVAttendee    *Attendee=Parent->Attendee;
    ICalVAttendee    *Next;

    if (!Attendee) {
        return(FALSE);
    }

    do {
        Next=Attendee->Next;
        MemFree(Attendee);
        Attendee=Next;
    } while (Attendee);
      
    Parent->Attendee=NULL;
    return(TRUE);
}

ICalObject
*ICalNewObject(ICalObject *Parent)
{
    ICalObject    *Object;

    Object=MemMalloc(sizeof(ICalObject));
    if (!Object) {
        return(NULL);
    }
    memset(Object, 0, sizeof(ICalObject));
    if (Parent) {
        Parent->Next=Object;
    }
    return(Object);
}

BOOL
ICalFreeObjects(ICalObject *Object)
{
    ICalObject    *Next;

    do {
        Next=Object->Next;
        ICalFreeTimezone(Object);
        ICalFreeRule(Object);
        ICalFreeAttendees(Object);
        ICalFreeFreeBusy(Object);
        if (Object->Organizer) {
            MemFree(Object->Organizer);
        }
        if (Object->Summary) {
            MemFree(Object->Summary);
        }
        if (Object->Contact) {
            MemFree(Object->Contact);
        }
        if (Object->UID) {
            MemFree(Object->UID);
        }
        if (Object->Description) {
            MemFree(Object->Description);
        }
        if (Object->Location) {
            MemFree(Object->Location);
        }
        if (Object->Comment) {
            MemFree(Object->Comment);
        }
        MemFree(Object);
        Object=Next;
    } while (Object);

    return(TRUE);
}

BOOL
ICalParsePercent(ICalObject *ICal, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *Value;
    BOOL                IsValue;

    Value=MemMalloc(strlen(Text)+1);

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (IsValue) {
            ICal->PercentComplete=atol(Value);
        }
    } while (!IsValue && ptr);

    MemFree(Value);

    return(TRUE);
}

BOOL
ICalParseSequence(ICalObject *ICal, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *Value;
    BOOL                IsValue;

    Value=MemMalloc(strlen(Text)+1);

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (IsValue) {
            ICal->Sequence=atol(Value);
        }
    } while (!IsValue && ptr);

    MemFree(Value);

    return(TRUE);
}

BOOL
ICalParsePriority(ICalObject *ICal, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *Value;
    BOOL                IsValue;

    Value=MemMalloc(strlen(Text)+1);

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (IsValue) {
            ICal->Priority=atol(Value);
        }
    } while (!IsValue && ptr);

    MemFree(Value);

    return(TRUE);
}

BOOL
ICalParseTransparency(ICalObject *ICal, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *Value;
    BOOL                IsValue;

    Value=MemMalloc(strlen(Text)+1);

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (IsValue) {
            if (ICalQuickCmp(Value, "TRANSPARENT")) {
                ICal->Transparent=TRUE;
            }
        }
    } while (!IsValue && ptr);

    MemFree(Value);

    return(TRUE);
}

BOOL
ICalParseFreeBusy(ICalObject *ICal, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *Value;
    BOOL                IsValue;
    unsigned char    Type;
    ICalVFreeBusy        *FB;

    Value=MemMalloc(strlen(Text)+1);

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (!IsValue) {
            if (ICalQuickNCmp(Value, "FBTYPE=", 7)) {
                if (ICalQuickCmp(Value+7, "FREE")) {
                    Type=ICAL_FREEBUSY_FREE;
                } else if (ICalQuickCmp(Value+7, "BUSY")) {
                    Type=ICAL_FREEBUSY_BUSY;
                } else if (ICalQuickCmp(Value+7, "BUSY-UNAVAILABLE")) {
                    Type=ICAL_FREEBUSY_BUSY_UNAVAILABLE;
                } else if (ICalQuickCmp(Value+7, "BUSY-TENTATIVE")) {
                    Type=ICAL_FREEBUSY_BUSY_TENTATIVE;
                }
            }
        }
    } while (!IsValue && ptr);

    if (ptr) {
        ptr=Value;
        do {
            FB=ICalNewFreeBusy(ICal);
            ptr=ICalGrabPeriod(&FB->Date, &FB->Duration, ptr);
        } while (ptr);
    }

    MemFree(Value);

    return(TRUE);
}

BOOL
ICalParseDuration(ICalObject *ICal, long *Duration, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *Value;
    BOOL                IsValue;

    Value=MemMalloc(strlen(Text)+1);

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (IsValue) {
            ICalGrabPeriod(NULL, Duration, Value);
        }
    } while (!IsValue && ptr);

    MemFree(Value);

    return(TRUE);
}

ICalVOrganizer
*ICalNewOrganizer(unsigned char *Name, unsigned char *Address)
{
    ICalVOrganizer        *Organizer;
    unsigned char    *Value;

    Value=MemMalloc(sizeof(ICalVOrganizer) + (Name ? strlen(Name) : 0) + (Address ? strlen(Address) : 0) + 2);

    Organizer=(ICalVOrganizer *)Value;
    Value+=sizeof(ICalVOrganizer);
    Organizer->Name=NULL;
    Organizer->Address=NULL;

    if (Name) {
        strcpy(Value, Name);
        Organizer->Name = Value;
        Value += strlen(Name) + 1;
    }
    if (Address) {
        strcpy(Value, Address);
        Organizer->Address = Value;
    }

    return(Organizer);
}

BOOL
ICalFreeOrganizer(ICalObject *Parent)
{
    if (Parent->Organizer) {
        MemFree(Parent->Organizer);
    }
    Parent->Organizer=NULL;

    return(TRUE);
}

ICalVAttendee
*ICalNewAttendee(ICalVAttendee *Previous, unsigned char *Name, unsigned char *Address, unsigned char *Delegated, unsigned char *DelegatedFrom, BOOL RSVP, unsigned long Type, unsigned long Role, unsigned long State)
{
    ICalVAttendee        *Attendee;
    unsigned long    BlockSize;
    unsigned char    *ptr;

    BlockSize=sizeof(ICalVAttendee);
    if (Name) {
        BlockSize+=strlen(Name)+1;
    }
    if (Address) {
        BlockSize+=strlen(Address)+1;
    }
    if (Delegated) {
        BlockSize+=strlen(Delegated)+1;
    }
    if (DelegatedFrom) {
        BlockSize+=strlen(DelegatedFrom)+1;
    }

    Attendee=MemMalloc(BlockSize);
    if (!Attendee) {
        return(NULL);
    }
    memset(Attendee, 0, sizeof(ICalVAttendee));

    ptr=(unsigned char *)Attendee+sizeof(ICalVAttendee);
    if (Name) {
        Attendee->Name=ptr;
        strcpy(ptr, Name);
        ptr+=strlen(Name)+1;
    }

    if (Address) {
        Attendee->Address=ptr;
        strcpy(ptr, Address);
        ptr+=strlen(Address)+1;
    }

    if (Delegated) {
        Attendee->Delegated=ptr;
        strcpy(ptr, Delegated);
        ptr+=strlen(Delegated)+1;
    }

    if (DelegatedFrom) {
        Attendee->DelegatedFrom=ptr;
        strcpy(ptr, DelegatedFrom);
        ptr+=strlen(DelegatedFrom)+1;
    }
    Attendee->RSVP=RSVP;
    Attendee->Role=Role;
    Attendee->Type=Type;
    Attendee->State=State;

    if (Previous) {
        while (Previous->Next) {
            Previous=Previous->Next;
        }
        Previous->Next=Attendee;
    }
    
    return(Attendee);
}


BOOL
ICalParseOrganizer(ICalObject *ICal, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *Value;
    BOOL                IsValue;

    Value=MemMalloc(sizeof(ICalVOrganizer)+strlen(Text)+1);

    ICal->Organizer=(ICalVOrganizer *)Value;
    Value+=sizeof(ICalVOrganizer);
    ICal->Organizer->Name=NULL;
    ICal->Organizer->Address=NULL;

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (!IsValue) {
            if (ICalQuickNCmp(Value, "CN=", 3)) {
                ICal->Organizer->Name=Value+3;
                Value+=strlen(Value)+1;
            }
        } else {
            if (ICalQuickNCmp(Value, "mailto:", 7)) {
                ICal->Organizer->Address=Value+7;
            } else {
                ICal->Organizer->Address=Value;
            }
        }
    } while (!IsValue && ptr);

    /* This looks scary, but these structure elements do not get freed */
    if (!ICal->Organizer->Address) {
        ICal->Organizer->Address = "";
    }

    if (!ICal->Organizer->Name) {
        ICal->Organizer->Name = "";
    }

    return(TRUE);
}

BOOL
ICalParseAttendee(ICalObject *ICal, unsigned char *Text)
{
    unsigned char    *ptr=Text;
    unsigned char    *ptr2;
    unsigned char    *Value;
    BOOL                IsValue;
    ICalVAttendee        *Attendee;

    Value=MemMalloc(sizeof(ICalVAttendee)+strlen(Text)+1);

    Attendee=ICal->Attendee;
    if (Attendee) {
        while (Attendee->Next) {
            Attendee=Attendee->Next;
        }
        Attendee->Next=(ICalVAttendee *)Value;
        Attendee=Attendee->Next;
    } else {
        ICal->Attendee=(ICalVAttendee *)Value;
        Attendee=ICal->Attendee;
    }

    Value+=sizeof(ICalVAttendee);
    memset(Attendee, 0, sizeof(ICalVAttendee));

    do {
        ptr=ICalGrabArgument(&IsValue, Value, ptr);
        if (!IsValue) {
            if (ICalQuickNCmp(Value, "RSVP=TRUE", 9)) {
                Attendee->RSVP=TRUE;
                Value+=strlen(Value)+1;
            } else if (ICalQuickNCmp(Value, "ROLE=", 5)) {
                ptr2=Value+5;
                if (ICalQuickCmp(ptr2, "CHAIR")) {
                    Attendee->Role=ICAL_ROLE_CHAIR;
                } else if (ICalQuickCmp(ptr2, "REQ-PARTICIPANT")) {
                    Attendee->Role=ICAL_ROLE_REQUIRED_PARTICIPANT;
                } else if (ICalQuickCmp(ptr2, "OPT-PARTICIPANT")) {
                    Attendee->Role=ICAL_ROLE_OPTIONAL_PARTICIPANT;
                } else if (ICalQuickCmp(ptr2, "NON-PARTICIPANT")) {
                    Attendee->Role=ICAL_ROLE_NON_PARTICIPANT;
                }
            } else if (ICalQuickNCmp(Value, "CUTYPE=", 7)) {
                ptr2=Value+7;
                if (ICalQuickCmp(ptr2, "INDIVIDUAL")) {
                    Attendee->Type=ICAL_CUTYPE_INDIVIDUAL;
                } else if (ICalQuickCmp(ptr2, "RESOURCE")) {
                    Attendee->Type=ICAL_CUTYPE_RESOURCE;
                } else if (ICalQuickCmp(ptr2, "GROUP")) {
                    Attendee->Type=ICAL_CUTYPE_GROUP;
                } else if (ICalQuickCmp(ptr2, "ROOM")) {
                    Attendee->Type=ICAL_CUTYPE_ROOM;
                } else if (ICalQuickCmp(ptr2, "UNKNOWN")) {
                    Attendee->Type=ICAL_CUTYPE_UNKNOWN;
                }
            } else if (ICalQuickNCmp(Value, "PARTSTAT=", 9)) {
                ptr2=Value+9;
                if (ICalQuickCmp(ptr2, "NEEDS-ACTION")) {
                    Attendee->State=ICAL_PARTSTAT_NEEDS_ACTION;
                } else if (ICalQuickCmp(ptr2, "ACCEPTED")) {
                    Attendee->State=ICAL_PARTSTAT_ACCEPTED;
                } else if (ICalQuickCmp(ptr2, "DECLINED")) {
                    Attendee->State=ICAL_PARTSTAT_DECLINED;
                } else if (ICalQuickCmp(ptr2, "TENTATIVE")) {
                    Attendee->State=ICAL_PARTSTAT_TENTATIVE;
                } else if (ICalQuickCmp(ptr2, "DELEGATED")) {
                    Attendee->State=ICAL_PARTSTAT_DELEGATED;
                } else if (ICalQuickCmp(ptr2, "COMPLETED")) {
                    Attendee->State=ICAL_PARTSTAT_COMPLETED;
                } else if (ICalQuickCmp(ptr2, "IN-PROCESS")) {
                    Attendee->State=ICAL_PARTSTAT_IN_PROCESS;
                }
            } else if (ICalQuickNCmp(Value, "CN=", 3)) {
                Attendee->Name=Value+3;
                Value+=strlen(Value)+1;
            } else if (ICalQuickNCmp(Value, "DELEGATED-TO=", 13)) {
                if (ICalQuickNCmp(Value+13, "mailto:", 7)) {
                    Attendee->Delegated=Value+20;
                } else {
                    Attendee->Delegated=Value+13;
                }
                Value+=strlen(Value)+1;
            } else if (ICalQuickNCmp(Value, "DELEGATED-FROM=", 15)) {
                if (ICalQuickNCmp(Value+15, "mailto:", 7)) {
                    Attendee->DelegatedFrom=Value+22;
                } else {
                    Attendee->DelegatedFrom=Value+15;
                }
                Value+=strlen(Value)+1;
            }
        } else {
            if (ICalQuickNCmp(Value, "mailto:", 7)) {
                Attendee->Address=Value+7;
            } else {
                Attendee->Address=Value;
            }
        }
    } while (!IsValue && ptr);

    if (!Attendee->Address) {
        ICalVAttendee    *Last;
        /*
            An address is required for an attendee.  If we return an attendee here
            without an address then we will fail later on, so we need to clean up
            and leave.
        */

        if (!ICal->Attendee->Next) {
            MemFree(ICal->Attendee);
            ICal->Attendee = NULL;
        } else {
            Attendee = ICal->Attendee;
            Last = Attendee->Next;

            while (Last->Next) {
                Last = Last->Next;
                Attendee = Attendee->Next;
            }
            MemFree(Attendee->Next);
            Attendee->Next = NULL;
        }
    }

    /* This looks scary, but these structure elements do not get freed */
    if (!Attendee->Address) {
        Attendee->Address = "";
    }

    if (!Attendee->Name) {
        Attendee->Name = "";
    }

    return(TRUE);
}

BOOL
ICalGenerateAttendeeFile(ICalObject *ICal, FILE *Object)
{
    ICalVAttendee        *Attendee;
    unsigned char    *Role="NON-PARTICIPANT";
    unsigned char    *PartStat="NEEDS-ACTION";
    unsigned char    *RSVP;
    unsigned char    *CN;
    unsigned char    *CUType="UNKNOWN";

    /* Generate attendees */
    Attendee=ICal->Attendee;
    while (Attendee) {
        if (Attendee->Name) {
            CN=Attendee->Name;
        } else {
            CN=Attendee->Address;
        }
        if (Attendee->RSVP) {
            RSVP="TRUE";
        } else {
            RSVP="FALSE";
        }
        switch(Attendee->Role) {
            case ICAL_ROLE_CHAIR:                        Role="CHAIR"; break;
            case ICAL_ROLE_REQUIRED_PARTICIPANT:    Role="REQ-PARTICIPANT"; break;
            case ICAL_ROLE_OPTIONAL_PARTICIPANT:    Role="OPT-PARTICIPANT"; break;
            case ICAL_ROLE_NON_PARTICIPANT:            Role="NON-PARTICIPANT"; break;
        }

        switch(Attendee->State) {
            case ICAL_PARTSTAT_NEEDS_ACTION:            PartStat="NEEDS-ACTION"; break;
            case ICAL_PARTSTAT_ACCEPTED:                PartStat="ACCEPTED"; break;
            case ICAL_PARTSTAT_DECLINED:                PartStat="DECLINED"; break;
            case ICAL_PARTSTAT_TENTATIVE:                PartStat="TENTATIVE"; break;
            case ICAL_PARTSTAT_DELEGATED:                PartStat="DELEGATED"; break;
            case ICAL_PARTSTAT_COMPLETED:                PartStat="COMPLETED"; break;
            case ICAL_PARTSTAT_IN_PROCESS:            PartStat="IN-PROCESS"; break;
        }
        switch(Attendee->Type) {
            case ICAL_CUTYPE_INDIVIDUAL:                CUType="INDIVIDUAL"; break;
            case ICAL_CUTYPE_GROUP:                        CUType="GROUP"; break;
            case ICAL_CUTYPE_RESOURCE:                    CUType="RESOURCE"; break;
            case ICAL_CUTYPE_ROOM:                        CUType="ROOM"; break;
            case ICAL_CUTYPE_UNKNOWN:                    CUType="UNKNOWN"; break;
        }

        fprintf(Object, "ATTENDEE;CN=\"%s\";ROLE=\"%s\";\r\n PARTSTAT=\"%s\";RSVP=\"%s\";CUTYPE=\"%s\":MAILTO:%s\r\n",
            CN, Role, PartStat, RSVP, CUType, Attendee->Address);
        Attendee=Attendee->Next;
    }
    return(TRUE);
}

BOOL
ICalGenerateObjectFile(ICalObject *ICal, FILE *Object, unsigned char *Identifier, unsigned char *RRule)
{
    unsigned char    Buffer[1024];
    unsigned long    Day, Month, Year, Hour, Minute, Second;
    unsigned long    TimeZone;

    if (ICal->Timezone) {
        TimeZone = ICal->Timezone->TimezoneID;
    } else {
        if (ICal->Start.TimezoneID) {
            TimeZone = ICal->Start.TimezoneID;
        } else {
            TimeZone = TZ_UTC;
        }
    }

    if (Identifier) {
        fprintf(Object, Identifier);
    } else {
        fprintf(Object, "BEGIN:VCALENDAR\r\nPRODID:-//Novell Inc//NetMail iCal Library//\r\nVERSION:2.0\r\n");
    }

    switch(ICal->Method) {
        case ICAL_METHOD_REPLY:        fprintf(Object, "METHOD:REPLY\r\n"); break;
        case ICAL_METHOD_REQUEST:    
        default:                            fprintf(Object, "METHOD:REQUEST\r\n"); break;
    }

    /* Throw in TimeZone Stuff if there is a reoccuring rule */
    if (RRule && TimeZone <= 74) {
        fprintf(Object, ICalTZRules[TimeZone].FullTZ);
    }

    switch(ICal->Type) {
        case ICAL_VEVENT:        fprintf(Object, "BEGIN:VEVENT\r\n"); break;
        case ICAL_VTODO:        fprintf(Object, "BEGIN:VTODO\r\n"); break;
        case ICAL_VJOURNAL:    fprintf(Object, "BEGIN:VJOURNAL\r\n"); break;
    }

    /* Organizer */
    if (ICal->Organizer && ICal->Organizer->Address) {
        if (ICal->Attendee) {
            if (ICal->Organizer->Name) {
                fprintf(Object, "ORGANIZER;CN=\"%s\":mailto:%s\r\n", ICal->Organizer->Name, ICal->Organizer->Address);
            } else {
                fprintf(Object, "ORGANIZER:mailto:%s\r\n", ICal->Organizer->Address);
            }
        } else {
            /* If there are no attendees then we do not list an organizer.  We list ourself as the only attendee instead. */
            if (ICal->Organizer->Name) {            
                fprintf(Object, "ATTENDEE;CN=\"%s\";ROLE=\"CHAIR\";\r\n PARTSTAT=\"ACCEPTED\";CUTYPE=\"INDIVIDUAL\":MAILTO:%s\r\n", ICal->Organizer->Name, ICal->Organizer->Address);
            } else {
                fprintf(Object, "ATTENDEE;ROLE=\"CHAIR\";\r\n PARTSTAT=\"ACCEPTED\";CUTYPE=\"INDIVIDUAL\":MAILTO:%s\r\n", ICal->Organizer->Address);
            }
        }
    }

    ICalGenerateAttendeeFile(ICal, Object);

    if (!RRule) {
        /* DTSTART */
        MsgGetDMY(ICal->Start.UTC, &Day, &Month, &Year, &Hour, &Minute, NULL);
        //MsgGetDMY(ICal->Start.UTC - MsgGetUTCOffsetByDate(TimeZone, Day, Month, Year, Hour), &Day, &Month, &Year, &Hour, &Minute, NULL);
        fprintf(Object, "DTSTART:%04d%02d%02dT%02d%02d00Z\r\n", (int)Year, (int)Month, (int)Day, (int)Hour, (int)Minute);

        /* DTEND */
        if (ICal->Start.UTC < ICal->End.UTC && ICal->Type != ICAL_VJOURNAL) {
            MsgGetDMY(ICal->End.UTC, &Day, &Month, &Year, &Hour, &Minute, NULL);
            //MsgGetDMY(ICal->End.UTC - MsgGetUTCOffsetByDate(TimeZone, Day, Month, Year, Hour), &Day, &Month, &Year, &Hour, &Minute, NULL);
            if (ICal->Type!=ICAL_VTODO) {
                fprintf(Object, "DTEND:%04d%02d%02dT%02d%02d00Z\r\n", (int)Year, (int)Month, (int)Day, (int)Hour, (int)Minute);
            } else {
                fprintf(Object, "DUE:%04d%02d%02dT%02d%02d00Z\r\n", (int)Year, (int)Month, (int)Day, (int)Hour, (int)Minute);
            }
        }
    } else { 
        ICalObject        *ICalRRule=NULL;
        ICalVRuleIterator    Iterator;
        unsigned long    EndYear;
        unsigned long    EndMonth;
        unsigned long    EndDay;
        unsigned long    EndHour;
        unsigned long    EndMinute;

        /* Send DTStart based on the RRULE and send the RRULE */

        /* Translate from UTC into "local" time */
        MsgGetDMY(ICal->Start.UTC, &Day, &Month, &Year, &Hour, &Minute, NULL);
        ICal->Start.UTC+=MsgGetUTCOffsetByDate(TimeZone, Day, Month, Year, Hour);
        MsgGetDMY(ICal->Start.UTC, &Day, &Month, &Year, &Hour, &Minute, NULL);


        MsgGetDMY(ICal->End.UTC, &EndDay, &EndMonth, &EndYear, &EndHour, &EndMinute, NULL);
        ICal->End.UTC+=MsgGetUTCOffsetByDate(TimeZone, EndDay, EndMonth, EndYear, EndHour);
        MsgGetDMY(ICal->End.UTC, &EndDay, &EndMonth, &EndYear, &EndHour, &EndMinute, NULL);

        snprintf(Buffer, sizeof(Buffer), "%sBEGIN:VEVENT\r\nDTSTART;TZID=\"%s\":%04d%02d%02dT%02d%02d00\r\nDTEND;TZID=\"%s\":%04d%02d%02dT%02d%02d00\r\n%s",
            ICalTZRules[TimeZone].FullTZ, ICalTZRules[TimeZone].TZName, (int)Year, (int)Month, (int)Day, (int)Hour, (int)Minute,
            ICalTZRules[TimeZone].TZName, (int)EndYear, (int)EndMonth, (int)EndDay, (int)EndHour, (int)EndMinute,
            RRule);

          ICalRRule=ICalParseObject(NULL, Buffer, strlen(Buffer));
        if (ICalRRule && ICalHasRule(ICalRRule)) {
            if (ICalFirstRuleInstance(ICalRRule, &Iterator)) {
                fprintf(Object, "DTSTART;TZID=\"%s\":%04d%02d%02dT%02d%02d00\r\n", ICalTZRules[TimeZone].TZName, 
                    (int)Iterator.Year, (int)Iterator.Month, (int)Iterator.Day, (int)Iterator.Hour, (int)Iterator.Minute);
                fprintf(Object, RRule);

                /* DTEND */
                ICal->Start.UTC = MsgGetUTC(Iterator.Day, Iterator.Month, Iterator.Year, Iterator.Hour, Iterator.Minute, Iterator.Second);
                ICal->End.UTC = ICal->Start.UTC + Iterator.Duration;
                if (ICal->Start.UTC < ICal->End.UTC && ICal->Type != ICAL_VJOURNAL) {
                    MsgGetDMY(ICal->End.UTC, &Day, &Month, &Year, &Hour, &Minute, NULL);
                    if (ICal->Type==ICAL_VEVENT) {
                        fprintf(Object, "DTEND;TZID=\"%s\":%04d%02d%02dT%02d%02d00\r\n", ICalTZRules[TimeZone].TZName, (int)Year, (int)Month, (int)Day, (int)Hour, (int)Minute);
                    } else if (ICal->Type==ICAL_VTODO) {
                        fprintf(Object, "DUE;TZID=\"%s\":%04d%02d%02dT%02d%02d00\r\n", ICalTZRules[TimeZone].TZName, (int)Year,(int) Month, (int)Day, (int)Hour, (int)Minute);
                    }
                }
            }
        }
        if (ICalRRule) {
            ICalFreeObjects(ICalRRule);
        }
    }

    fprintf(Object, "SEQUENCE:%lu\r\n", ICal->Sequence);
    if (!ICal->UID) {
        snprintf(Buffer, sizeof(Buffer), "%d%s", (int)time(NULL), (ICal->Organizer->Address) ? (char *)ICal->Organizer->Address : "");
        ICal->UID = MemStrdup(Buffer);
    }
    fprintf(Object, "UID:%s\r\n", ICal->UID);
    MsgGetDMY(time(NULL), &Day, &Month, &Year, &Hour, &Minute, &Second);
    fprintf(Object, "DTSTAMP:%04d%02d%02dT%02d%02d%02dZ\r\n", (int)Year, (int)Month, (int)Day, (int)Hour, (int)Minute, (int)Second);


    if (ICal->Type==ICAL_VTODO) {
        if (ICal->PercentComplete) {
            fprintf(Object, "PERCENT-COMPLETE:%lu\r\n", ICal->PercentComplete);
        }
        if (ICal->Completed.UTC!=0) {
            MsgGetDMY(ICal->Completed.UTC, &Day, &Month, &Year, &Hour, &Minute, NULL);
            fprintf(Object, "COMPLETED:%04d%02d%02dT%02d%02d00Z\r\n", (int)Year, (int)Month, (int)Day, (int)Hour, (int)Minute);
        }
    }

    if (ICal->Summary) {
        fprintf(Object, "SUMMARY:");
        ICalEncodeArgument(ICal->Summary, Object, 60, strlen("SUMMARY:"));
        fprintf(Object, "\r\n");
    }

    if (ICal->Description) {
        fprintf(Object, "DESCRIPTION:");
        ICalEncodeArgument(ICal->Description, Object, 60, strlen("DESCRIPTION"));
        fprintf(Object, "\r\n");
    }

    if (RRule) {
        fprintf(Object, RRule);
    }

    if (ICal->Location) {
        fprintf(Object, "LOCATION:");
        ICalEncodeArgument(ICal->Location, Object, 60, strlen("LOCATION:"));
        fprintf(Object, "\r\n");
    }
        
    switch(ICal->Type) {
        case ICAL_VEVENT:        fprintf(Object, "END:VEVENT\r\n"); break;
        case ICAL_VTODO:        fprintf(Object, "END:VTODO\r\n"); break;
        case ICAL_VJOURNAL:    fprintf(Object, "END:VJOURNAL\r\n"); break;
    }
    fprintf(Object, "END:VCALENDAR\r\n");
    return(TRUE);
}


ICalObject
*ICalParseObject(FILE *Object, unsigned char *MemoryObject, unsigned long Size)
{
    unsigned char    *Buffer;
    unsigned    long    State=ICAL_NO_STATE;
    unsigned    long    PrevState=ICAL_NO_STATE;
    ICalObject        *ICal;
    ICalVTimeZone        *CurrentTZ=NULL;
    BOOL                ObjectAllocated=FALSE;
    unsigned char    *ptr;
    unsigned char    *EndSrc;
    unsigned char    *Src;
    unsigned char    *Dest;

    if (Size==0 || (MemoryObject==NULL && Object==NULL)) {
        return(NULL);
    }

    /* Need to read from file? */
    if (!MemoryObject) {    
        unsigned long    Count;
        unsigned long    Total=0;
    
        ObjectAllocated=TRUE;
        MemoryObject=MemMalloc(sizeof(unsigned char)*Size+1);
        while (!feof(Object) && !ferror(Object) && Total<Size) {
            Count=fread(MemoryObject+Total, 1, BUFSIZE, Object);
            Total+=Count;
        }
        MemoryObject[Total]='\0';
        Size=Total;
    }

    /* Clean object; consolidate line continuation */
    Src=MemoryObject;
    EndSrc=MemoryObject+Size;
    Dest=NULL;
    while (Src[0] && Src<EndSrc) {
        if (Src[0]=='\r' && Src[1]=='\n') {
            Src++;
            Dest=Src;
            break;
        }
        Src++;
    }

    if (Dest) {
        if (Dest[-1]=='\r') {
            Dest--;
        }
        while (Src<EndSrc && Src[0]) {
            switch(Src[0]) {
                case '\r':    Src++; continue;
                case '\n': {
                    if ((Src+1)<EndSrc) {
                        if (Src[1]==' ') {
                            Src+=2;
                            continue;
                        }
                    }
                }
                default: {
                    *Dest++=*Src++;
                }
            }
        }
        Dest[0]='\0';
    }

    ICal=ICalNewObject(NULL);
    if (!ICal) {
        if (ObjectAllocated) {
            MemFree(MemoryObject);
        }
        return(FALSE);
    }

    Buffer=MemoryObject;
    while (Buffer) {
        ptr=strchr(Buffer, '\n');
        if (ptr) {
            *ptr='\0';
        }
        switch(State) {
            case ICAL_NO_STATE: {
                if (ICalQuickCmp(Buffer, "BEGIN:VTIMEZONE")) {
                    State=ICAL_VTIMEZONE;
                    CurrentTZ=ICalNewTimezone(ICal);
                    CurrentTZ->TZState=ICAL_TZ_NO_STATE;
                } else if (ICalQuickCmp(Buffer, "BEGIN:VEVENT")) {
                    State=ICAL_VEVENT;
                    ICal->Type=ICAL_VEVENT;
                } else if (ICalQuickCmp(Buffer, "BEGIN:VTODO")) {
                    State=ICAL_VTODO;
                    ICal->Type=ICAL_VTODO;
                } else if (ICalQuickCmp(Buffer, "BEGIN:VJOURNAL")) {
                    State=ICAL_VJOURNAL;
                    ICal->Type=ICAL_VJOURNAL;
                } else if (ICalQuickNCmp(Buffer, "METHOD:", 7)) {
                    if (ICalQuickCmp(Buffer+7, "REQUEST")) {
                        ICal->Method=ICAL_METHOD_REQUEST;
                    } else if (ICalQuickCmp(Buffer+7, "REPLY")) {
                        ICal->Method=ICAL_METHOD_REPLY;
                    } else if (ICalQuickCmp(Buffer+7, "CANCEL")) {
                        ICal->Method=ICAL_METHOD_CANCEL;
                    }
                    break;
                } else if (ICalQuickNCmp(Buffer, "PRODID:", 7)) {
                    if (strstr(Buffer + 7, "NetMail ModWeb")) { 
                        /* Used to determine if NetMail originated request */
                        ICal->ProdID = ICAL_PROD_MODWEB;
                    }
                }
                
                break;
            }

            case ICAL_VALARM: {
                if (ICalQuickCmp(Buffer, "END:VALARM")) {
                    State=PrevState;
                    break;
                }
                break;
            }


            case ICAL_VTIMEZONE: {
                if (ICalQuickCmp(Buffer, "END:VTIMEZONE")) {
                    /* Now match against all known timezones and store the timezone ID */
                    CurrentTZ->TimezoneID= MsgGetTimezoneID(CurrentTZ->Day, CurrentTZ->WDay, CurrentTZ->Month, CurrentTZ->Hour, 
                                                        CurrentTZ->DSTDay, CurrentTZ->DSTWDay, CurrentTZ->DSTMonth, CurrentTZ->DSTHour,
                                                        CurrentTZ->Offset, CurrentTZ->DSTOffset);
                    State=ICAL_NO_STATE;
                    break;
                } else if (ICalQuickNCmp(Buffer, "BEGIN:STANDARD", 14)) {
                    CurrentTZ->TZState=ICAL_TZ_STANDARD;
                } else if (ICalQuickNCmp(Buffer, "BEGIN:DAYLIGHT", 14)) {
                    CurrentTZ->TZState=ICAL_TZ_DAYLIGHT;
                } else if (ICalQuickNCmp(Buffer, "RRULE:", 6)) {
                    ICalParseTimezoneRule(CurrentTZ, Buffer+6, CurrentTZ->TZState==ICAL_TZ_DAYLIGHT);
                } else if (ICalQuickNCmp(Buffer, "DTSTART", 7) && Buffer[16]=='T') {
                    if (CurrentTZ->TZState==ICAL_TZ_STANDARD) {
                        CurrentTZ->Hour=(Buffer[17]-'0')*10+Buffer[18]-'0';
                    } else {
                        CurrentTZ->DSTHour=(Buffer[17]-'0')*10+Buffer[18]-'0';
                    }
                } else if (ICalQuickNCmp(Buffer, "TZOFFSETTO:", 11)) {
                    if (CurrentTZ->TZState==ICAL_TZ_STANDARD) {
                        CurrentTZ->Offset=(atol(Buffer+11)*60)/100;
                    } else {
                        CurrentTZ->DSTOffset=(atol(Buffer+11)*60)/100;
                    }
                } else if (ICalQuickNCmp(Buffer, "TZID:", 5)) {
                    unsigned char    *ptr=Buffer+4;
                    unsigned char    *Value;
                    BOOL                IsValue;

                    Value=MemMalloc(strlen(Buffer+4)+1);

                    do {
                        ptr=ICalGrabArgument(&IsValue, Value, ptr);
                        if (IsValue) {
                            if (CurrentTZ->TZName != NULL) {
                                MemFree(CurrentTZ->TZName);
                            }
                            CurrentTZ->TZName=Value;
                        }
                    } while (!IsValue && ptr);
                }
                break;
            }

            case ICAL_VTODO:
                if (ICalQuickNCmp(Buffer, "PERCENT-COMPLETE", 16)) {
                    ICalParsePercent(ICal, Buffer+16);
                    break;
                } else if (ICalQuickNCmp(Buffer, "COMPLETED", 9)) {
                    ICalParseDTComponent(ICal, Buffer+9, ICAL_DTCOMPLETED);
                    break;
                }
                /* Fall-through */

            case ICAL_VJOURNAL:
            case ICAL_VEVENT: {
                if (ICalQuickCmp(Buffer, "END:VEVENT") || ICalQuickCmp(Buffer, "END:VTODO") || ICalQuickCmp(Buffer, "END:VJOURNAL")) {
                    State=ICAL_NO_STATE;
                    break;
                } else if (ICalQuickCmp(Buffer, "BEGIN:VALARM")) {
                    PrevState=State;
                    State=ICAL_VALARM;
                    break;
                } else if (ICalQuickNCmp(Buffer, "DTSTART", 7)) {
                    ICalParseDTComponent(ICal, Buffer+7, ICAL_DTSTART);
                    break;
                } else if (ICalQuickNCmp(Buffer, "DTSTAMP", 7)) {
                    ICalParseDTComponent(ICal, Buffer+7, ICAL_DTSTAMP);
                    break;
                } else if (ICalQuickNCmp(Buffer, "DTEND", 5)) {
                    ICalParseDTComponent(ICal, Buffer+5, ICAL_DTEND);
                    break;
                } else if (ICalQuickNCmp(Buffer, "DUE", 3)) {
                    ICalParseDTComponent(ICal, Buffer+3, ICAL_DTEND);
                    break;
                } else if (ICalQuickNCmp(Buffer, "RECURRENCE-ID", 13)) {
                    ICalParseDTComponent(ICal, Buffer+13, ICAL_RECURID);
                    break;
                } else if (ICalQuickNCmp(Buffer, "RRULE:", 6)) {
                    ICalParseRecurrenceRule(ICal, Buffer);
                    break;
                } else if (ICalQuickNCmp(Buffer, "DURATION", 8)) {
                    ICalParseDuration(ICal, &ICal->Duration, Buffer+8);
                    break;
                } else if (ICalQuickNCmp(Buffer, "ORGANIZER", 9)) {
                    ICalParseOrganizer(ICal, Buffer+9);
                    break;
                } else if (ICalQuickNCmp(Buffer, "ATTENDEE", 8)) {
                    ICalParseAttendee(ICal, Buffer+8);
                    break;
                } else if (ICalQuickNCmp(Buffer, "SUMMARY", 7)) {
                    ICalParseSummary(ICal, Buffer+7);
                    break;
                } else if (ICalQuickNCmp(Buffer, "LOCATION", 8)) {
                    ICalParseLocation(ICal, Buffer+8);
                    break;
                } else if (ICalQuickNCmp(Buffer, "PRIORITY", 8)) {
                    ICalParsePriority(ICal, Buffer+8);
                    break;
                } else if (ICalQuickNCmp(Buffer, "UID", 3)) {
                    ICalParseUID(ICal, Buffer+3);
                    break;
                } else if (ICalQuickNCmp(Buffer, "TRANSP", 6)) {
                    ICalParseTransparency(ICal, Buffer+6);
                    break;
                } else if (ICalQuickNCmp(Buffer, "SEQUENCE", 8)) {
                    ICalParseSequence(ICal, Buffer+8);
                    break;
                } else if (ICalQuickNCmp(Buffer, "DESCRIPTION", 11)) {
                    ICalParseDescription(ICal, Buffer+11);
                    break;
                } else if (ICalQuickNCmp(Buffer, "FREEBUSY", 8)) {
                    ICalParseFreeBusy(ICal, Buffer+8);
                    break;
                }
                break;
            }
        }
        if (ptr) {
            *ptr='\n';
            Buffer=ptr+1;
        } else {
            Buffer=NULL;
        }
    }

    if (ObjectAllocated) {
        MemFree(MemoryObject);
    }
    return(ICal);
}
