/****************************************************************************
 *
 * Copyright (c) 2001-2002 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <libical.h>
#include <logger.h>
#include <ctype.h>

#include <calendar.tok>
#include <calendar.ary>

#define	PRODUCT_SHORT_NAME	"mwcal.nlm"

#define	ChopNL(String)		{ unsigned char *pTr; pTr=strchr((String), 0x0a);	if (pTr)	*pTr='\0'; pTr=strrchr((String), 0x0d); if (pTr) *pTr='\0'; }

#define	PRODUCT_NAME		"Hula ModWeb Module"

#define	REQUEST_CALENDAR_DAY			1001
#define	REQUEST_CALENDAR_WEEK		1002
#define	REQUEST_CALENDARY_MONTH		1003
#define	REQUEST_MINICALPREV_MONTH	1004
#define	REQUEST_MINICALNEXT_MONTH	1005
#define	REQUEST_DISPLAY_DATE			1006
#define	PROCESS_DATE_SELECTION		1007
#define	REQUEST_SET_CURRENT_DATE	1008

#define	REQUEST_VIEW_OBJECT			1009
#define	REQUEST_REPLY					1010

#define	COMPOSE_FORM					1201
#define	RECUR_FORM						1202
#define	CAL_REFRESH						1203
#define	REQUEST_CHANGE_DATE			1204
#define	REQUEST_SELECT_TODAY			1205
#define	LIST_FORM						1206
#define	COPY_FORM						1207

/* Also defined in mwmail.h */
#define	REQUEST_DISPLAY_CALENDAR	1210

/* named URLs */
#define	REFRESH_CALENDAR	1211
#define	REQUEST_ICS 1212

/* globals */
typedef struct _MwCalGlobal {
    /* directory paths */
    unsigned char WorkDir[XPL_MAX_PATH + 1];

    /* Handles */
    MDBHandle DirectoryHandle;
    void *LogHandle;

    /* Constants */

    /* Agent Settings */
    unsigned long NmapQAddress;
    unsigned long MaxRecipients;
    MDBValueStruct *Domains;
    /* Agent Status */
    BOOL Running;


    int Tgid;
    XplSemaphore ShutdownSemaphore;
    XplAtomic LibraryUserCount;

} MwCalGlobal;

extern MwCalGlobal MwCal;

typedef struct {
	unsigned long	ID;
	unsigned long	Type;
	unsigned long	UTCStart;
	unsigned long	UTCEnd;
	unsigned long	UTCDue;
	unsigned long  State; /* used for free busy status */
} ViewCacheStruct;

typedef struct {
	/* Generic */
	unsigned long		Error;							/* Last error to be reported								*/

	unsigned long		CalendarEnabled;				/* Does user have the feature?							*/
	unsigned long		CurrentCalendar;				/* Currently selected calendar							*/

	/* Compose */
	unsigned long		BeginTime;						/* Begin time for creating ICAL objects				*/
	unsigned long		EndTime;							/* End time for creating ICAL objects					*/

	/* View */
	unsigned long		CurrentWeekDay;				/* The current day of the week							*/
	unsigned long		SavedRataDie;					/* Required for Month/week to restore date			*/
	BOOL					HideFloatingTasks;			/* Show floating tasks?  Used for week/month 		*/

	/* Access */
	unsigned long		*IDList;							/* Translation table for Calendar IDs					*/
	BOOL					CalendarSelected;				/* Do we have a selected calendar on NMAP				*/

	/* Token state holders */
	int					InView;							/* Contains 0 or the type of current view				*/
	unsigned long		ListUTCStart;					/* UTC Start time of current list view					*/
	unsigned long		ListUTCEnd;						/* UTC end time of current list view					*/

	/* Calendar view caching */
	unsigned long		ViewUTCStart;					/* Cache list start time									*/
	unsigned long		ViewUTCEnd;						/* Cache list end time										*/
	unsigned long		ViewUsed;						/* The total number of items for current view		*/
	unsigned long		ViewAllocated;					/* The number of slots available in the cache		*/
	unsigned long		ViewPointer;					/* Currently selected cache item							*/
	ViewCacheStruct	*ViewCache;						/* Array of items in current view						*/

	/* Calendar entry caching */
	unsigned long		EntryID;							/* ID of cached entry										*/
	unsigned char		EntryOrganizer[40];			/* Cached Organizer											*/
	unsigned char		EntrySummary[40];				/* Cached Summary												*/
	char              EntryRole;                 /* Cached Role */
	char              EntryStatus;               /* Cached Status */
	unsigned long     EntryState;                /* Cached Calendar entry state */
	BOOL              IAmAttendee;               /* Am I in attendee list or am I a implied (BCC)   */

	/* Calendar detail caching */
	unsigned long		DetailID;						/* ID of what we're caching								*/
	unsigned long		DetailCalendar;				/* ID of the calendar that contains the ID			*/
	ICalObject			*ICal;							/* Cache data													*/
	ICalVAttendee			*CurrentAttendee;				/* Pointer to the current attendee						*/

	/* Free/Busy search display information */
	unsigned long		DayCounter;						/* Current display day										*/
	unsigned long		HourCounter;					/* Current display hour										*/

	unsigned long		*FreeBusyData;					/* Data for busy search results							*/
	unsigned long		*FreeBusyTotalData;			/* Data for busy search results totals					*/
	MDBValueStruct		*FreeBusyUsers;				/* The users included in the cached results data	*/
	unsigned long		FreeBusySegmentStart;		/* Begining of the current segment						*/
	unsigned long		FreeBusySegmentEnd;			/* Begining of the current segment						*/

	MDBValueStruct		*CopyValues;					/* MsgIDs to copy												*/
} CalendarSessionStruct;

#define	SearchCacheSlotSize		(60 * 24 * 7) / 8


/* These are the extensions for information we retrieve from the sender */
extern unsigned char	*COMPOSE_EXT_TO_LIST[];
#define	COMPOSE_TO									0
#define	COMPOSE_CC									1
#define	COMPOSE_BCC									2

#define	COMPOSE_EXT_SUBJECT						"sub"
#define	COMPOSE_EXT_BODY							"bdy"
#define	COMPOSE_EXT_LOCATION						"loc"
#define	COMPOSE_EXT_RRULE							"rul"
#define	COMPOSE_EXT_TEMP							"tmp"
#define	COMPOSE_EXT_ICAL							"ics"

/* Where we store our final message */
#define	COMPOSE_EXT_MESSAGE						"out"


/* Compose Actions */
#define	ACTION_APPOINTMENT						1
#define	ACTION_MESSAGE								2
#define	ACTION_NOTE									3
#define	ACTION_TASK									4
#define	ACTION_CANCEL								5
#define	ACTION_DECLINE								6
#define	ACTION_DELEGATE							7
#define	ACTION_COMPLETE							8

/* Compose Elements */
#define	COMPOSE_ELEMENT_TO						21
#define	COMPOSE_ELEMENT_CC						22
#define	COMPOSE_ELEMENT_BCC						23
#define	COMPOSE_ELEMENT_SUBJECT					24
#define	COMPOSE_ELEMENT_BODY						25
#define	COMPOSE_ELEMENT_LOCATION				26
#define	COMPOSE_ELEMENT_PRIORITY				27

/* Error string offsets */
#define	MAX_ERROR_LEN											256
#define	ERROR_NO_RECIPIENTS									1
#define	ERROR_TOO_MANY_RECIPIENTS							2
#define	ERROR_CONNECTING_TO_QUEUE							3
#define	ERROR_CREATING_MESSAGE__QCREA						4
#define	ERROR_CREATING_MESSAGE__FOPEN						5
#define	ERROR_CREATING_MESSAGE__LIST						6
#define	ERROR_CREATING_MESSAGE__QSTOR_FROM				7
#define	ERROR_CREATING_MESSAGE__QSTOR_RAW				8
#define	ERROR_CREATING_MESSAGE__QSTOR_TO					9
#define	ERROR_CREATING_MESSAGE__QSTOR_MESSAGE			10
#define	ERROR_CREATING_MESSAGE__QRUN						11
#define	ERROR_CREATING_MESSAGE__STAT						12
#define	ERROR_BUILDING_RECIP_LIST__FOPEN					13
#define	ERROR_BUILDING_RECIP_LIST__QSTOR_TO				14
#define	ERROR_NO_ENTRY_FOUND									15
#define	ERROR_SAVING_FORM_DATA__FOPEN						16
#define	ERROR_READING_FORM_DATA__FOPEN					17
#define	ERROR_NO_FOLDER_SELECTED							18
#define	ERROR_SELECTING_FOLDER__MBOX						19
#define	ERROR_CREATING_FOLDER__CREA						20
#define	ERROR_RENAMING_FOLDER__RNAM						21
#define	ERROR_REMOVING_FOLDER__RMOV						22
#define	ERROR_DELETING_MESSAGE__AFLG						23
#define	ERROR_COPYING_MESSAGE__COPY						24
#define	ERROR_STORING_ATTACHMENT__FOPEN					25
#define	ERROR_STORING_BODY__FOPEN							26
#define	ERROR_STORING_FORM_ELEMENT__FOPEN				27
#define	ERROR_ACCESSING_ORIGINAL_MESSAGE__MIME			28
#define	END_BEFORE_BEGIN										29
#define ERROR_BAD_TO_ADDR 33
#define ERROR_BAD_CC_ADDR 34
#define ERROR_BAD_BCC_ADDR  34


/* mwcal.c */
BOOL MWCALInitSession(SessionStruct *Session, void **ModuleData);
BOOL MWCALDestroySession(SessionStruct *Session, void *ModuleData);
BOOL MWCALHandleURL(ConnectionStruct *Client, SessionStruct *Session, URLStruct *URL, void *ModuleData);
BOOL MWCALHandleTemplate(ConnectionStruct *Client, SessionStruct *Session, unsigned long Page, TokenOverlayStruct *Token, unsigned long *GotoToken, void *ModuleData);
EXPORT BOOL MWCALInit(MWAPIArg);
EXPORT BOOL MWCALShutdown(void);


BOOL				SendICalReply(ConnectionStruct *Client, SessionStruct *Session, CalendarSessionStruct *CalendarSession, unsigned long Action);
BOOL				SendICalDelegation(ConnectionStruct *Client, SessionStruct *Session, CalendarSessionStruct *CalendarSession);	
BOOL				ICalMailReply(ConnectionStruct *Client, SessionStruct *Session, CalendarSessionStruct *CalendarSession, unsigned long Action);

/* calcache.c */
long				NMAPtoCalendarID(SessionStruct *Session, CalendarSessionStruct *CalendarSession, unsigned long NMAP);
BOOL				SelectCalendar(unsigned long CalendarID, SessionStruct *Session, CalendarSessionStruct *CalendarSession);

unsigned long	LoadCalendarView(unsigned long UTCStart, unsigned long UTCEnd, SessionStruct *Session, CalendarSessionStruct *CalendarSession);
BOOL				FreeCalendarView(SessionStruct *Session, CalendarSessionStruct *CalendarSession);

BOOL				FindCalendarEntry(unsigned long Type, unsigned long UTCStart, unsigned long UTCEnd, SessionStruct *Session, CalendarSessionStruct *CalendarSession);
BOOL				LoadCalendarEntry(unsigned long CalendarID, SessionStruct *Session, CalendarSessionStruct *CalendarSession);
BOOL				LoadCalendarEntryDetails(unsigned long CalendarID, SessionStruct *Session, CalendarSessionStruct *CalendarSession, BOOL ReLoad);
BOOL				FreeCalendarEntryDetails(SessionStruct *Session, CalendarSessionStruct *CalendarSession);

BOOL				UpdateCalendar(SessionStruct *Session, CalendarSessionStruct *CalendarSession);

/* ccode.c */
int				CalendarUTF7toUTF8(const unsigned char *UTF7, unsigned char *UTF8);
int				CalendarUTF8toUTF7(const unsigned char *UTF8, int UTF8Len, unsigned char *UTF7, int UTF7Len);


